/*
 * Decompiled with CFR 0.152.
 */
package rene.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.IconBarElement;
import rene.gui.SaveColor;

class BasicIcon
extends Panel
implements MouseListener,
IconBarElement,
Runnable {
    IconBar Bar;
    String Name;
    boolean Enabled;
    boolean On;
    boolean Focus = false;
    public static int Size = 22;
    boolean MouseOver;
    boolean MouseDown;
    boolean Unset;
    Thread T;
    boolean Control;

    public BasicIcon(IconBar iconBar, String string) {
        this.Bar = iconBar;
        this.Name = string;
        this.Enabled = true;
        this.On = false;
        this.addMouseListener(this);
        this.enableEvents(8L);
        this.setSize(Size, Size);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        this.Bar.getKey(keyEvent);
    }

    public void paint(Graphics graphics) {
        Color color;
        if (this.MouseDown) {
            graphics.setColor(this.getBackground());
            graphics.fill3DRect(0, 0, Size, Size, false);
        } else if (this.MouseOver) {
            if (this.On) {
                color = this.getBackground();
                graphics.setColor(new SaveColor(color.getRed() - 30, color.getGreen() - 30, color.getBlue()));
            } else {
                graphics.setColor(this.getBackground());
            }
            graphics.fill3DRect(0, 0, Size, Size, true);
        } else if (this.On) {
            color = this.getBackground();
            graphics.setColor(color);
            graphics.fillRect(0, 0, Size, Size);
            graphics.setColor(new SaveColor(color.getRed() - 100, color.getGreen() - 100, color.getBlue()));
            graphics.fillRect(3, 3, Size - 2, Size - 2);
            graphics.setColor(new SaveColor(color.getRed() - 50, color.getGreen() - 50, color.getBlue()));
            graphics.fillRect(1, 1, Size - 2, Size - 2);
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, Size, Size);
        }
        this.dopaint(graphics);
        if (this.Unset) {
            color = this.getBackground();
            graphics.setColor(new SaveColor(color.getRed() - 100, color.getGreen(), color.getBlue()));
            graphics.drawLine(0, 0, Size, Size);
        }
        if (this.Focus) {
            this.showFocus(graphics);
        }
    }

    public void showFocus(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.drawRect(4, 4, 1, 1);
        graphics.drawRect(Size - 5, 4, 1, 1);
        graphics.drawRect(4, Size - 5, 1, 1);
        graphics.drawRect(Size - 5, Size - 5, 1, 1);
    }

    public void dopaint(Graphics graphics) {
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.Enabled) {
            return;
        }
        this.MouseDown = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.Enabled) {
            return;
        }
        this.MouseDown = false;
        Dimension dimension = this.getSize();
        if (mouseEvent.getX() < 0 || mouseEvent.getX() > dimension.width || mouseEvent.getY() < 0 || mouseEvent.getY() > dimension.height) {
            this.repaint();
            return;
        }
        this.Unset = false;
        this.pressed(mouseEvent);
        this.repaint();
        this.T = null;
        long l = System.currentTimeMillis();
        this.Bar.iconPressed(this.Name, mouseEvent.isShiftDown(), mouseEvent.isControlDown());
        l = System.currentTimeMillis() - l;
        if (this.MouseOver && l > 1000L) {
            this.MouseOver = false;
            this.repaint();
        }
    }

    public void pressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public synchronized void mouseEntered(MouseEvent mouseEvent) {
        if (this.T != null) {
            return;
        }
        if (this.Enabled) {
            this.MouseOver = true;
        }
        this.repaint();
        if (!Global.getParameter("iconbar.showtips", true)) {
            return;
        }
        this.Control = mouseEvent.isControlDown();
        this.T = new Thread(this);
        this.T.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.T != null) {
            BasicIcon basicIcon = this;
            synchronized (basicIcon) {
                try {
                    String string;
                    Point point = this.getLocationOnScreen();
                    String string2 = Global.name("iconhelp." + this.Name, "");
                    if (string2.equals("") && this.Name.length() > 1) {
                        string2 = Global.name("iconhelp." + this.Name.substring(0, this.Name.length() - 1) + "?", "");
                    }
                    if (string2.equals("")) {
                        string2 = this.Bar.getHelp(this.Name);
                    }
                    if (string2.equals("")) {
                        string2 = Global.name("iconhelp.nohelp", "No help available");
                    }
                    if (this.Control && !(string = Global.name("iconhelp.control." + this.Name, "")).equals("")) {
                        string2 = string;
                    }
                    this.Bar.displayHelp(this, string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.T != null) {
                this.Bar.removeHelp();
            }
            this.T = null;
        }
    }

    public synchronized void mouseExited(MouseEvent mouseEvent) {
        this.T = null;
        this.MouseOver = false;
        this.repaint();
        this.Bar.removeHelp();
    }

    public int width() {
        return Size;
    }

    public void setPosition(int n, int n2) {
        this.setLocation(n, n2);
    }

    public Point getPosition() {
        return this.getLocationOnScreen();
    }

    public void setEnabled(boolean bl) {
        if (this.Enabled == bl) {
            return;
        }
        this.Enabled = bl;
        this.repaint();
    }

    public String getName() {
        return this.Name;
    }

    public boolean hasFocus() {
        return this.Focus;
    }

    public void setFocus(boolean bl) {
        this.Focus = bl;
        this.repaint();
    }

    public boolean isSet() {
        return !this.Unset;
    }

    public void unset(boolean bl) {
        this.Unset = bl;
    }

    public void unset() {
        this.unset(true);
    }
}

