# Именованные представления

Иногда необходимо отобразить сразу несколько компонентов, не вкладывая их один в другой — например, при создании разметки с боковой панелью и основным контентом. В этой ситуации может быть удобно использовать именованные представления. Вместо указания единственного `<router-view>`, можно использовать несколько, присвоив каждому собственное имя. Безымянный `router-view` автоматически получает имя `default`.

``` html
<router-view class="view one"></router-view>
<router-view class="view two" name="a"></router-view>
<router-view class="view three" name="b"></router-view>
```

При использовании нескольких представлений, вместо единственного компонента при описании пути необходимо указывать объект. Удостоверьтесь, что используете окончание множественного числа (`s`) в ключе `components`:

``` js
const router = new VueRouter({
  routes: [
    {
      path: '/',
      components: {
        default: Foo,
        a: Bar,
        b: Baz
      }
    }
  ]
})
```

Рабочее демо этого примера можно найти [здесь](https://jsfiddle.net/posva/6du90epg/).

## Вложенные именованные маршруты

Возможно и создание сложных шаблонов используя именованные представления с вложенными представлениями. При этом вам также нужно будет именовать используемые вложенные компоненты `router-view`. Разберём пример панели настроек:

```
/settings/emails                                       /settings/profile
+-----------------------------------+                  +------------------------------+
| UserSettings                      |                  | UserSettings                 |
| +-----+-------------------------+ |                  | +-----+--------------------+ |
| | Nav | UserEmailsSubscriptions | |  +------------>  | | Nav | UserProfile        | |
| |     +-------------------------+ |                  | |     +--------------------+ |
| |     |                         | |                  | |     | UserProfilePreview | |
| +-----+-------------------------+ |                  | +-----+--------------------+ |
+-----------------------------------+                  +------------------------------+
```

- `Nav` это просто обычный компонент
- `UserSettings` компонент представления
- `UserEmailsSubscriptions`, `UserProfile`, `UserProfilePreview` вложенные компоненты представлений

**Примечание**: _Давайте опустим как должен выглядеть HTML/CSS для реализации подобного шаблона и сосредоточимся на используемых компонентах_

Секция `<template>` компонента `UserSettings` будет выглядеть примерно так:

```html
<!-- UserSettings.vue -->
<div>
  <h1>Настройки пользователя</h1>
  <NavBar/>
  <router-view/>
  <router-view name="helper"/>
</div>
```

_Вложенные компоненты представлений опущены здесь, но вы можете найти полные исходные коды примера [здесь](https://jsfiddle.net/posva/22wgksa3/)_

Затем вы можете достичь компоновки шаблона выше с помощью конфигурации маршрута:

```js
{
  path: '/settings',
  // Вы могли также иметь именованные представления в верхней части
  component: UserSettings,
  children: [{
    path: 'emails',
    component: UserEmailsSubscriptions
  }, {
    path: 'profile',
    components: {
      default: UserProfile,
      helper: UserProfilePreview
    }
  }]
}
```

Рабочее демо этого примера можно найти [здесь](https://jsfiddle.net/posva/22wgksa3/).
