/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef PICTURELABEL_H
#define PICTURELABEL_H
#include<QLabel>

class PictureLabel : public QLabel
{
public:
    explicit PictureLabel(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::WindowFlags());
    explicit PictureLabel(const QString &text, QWidget *parent=nullptr, Qt::WindowFlags f=Qt::WindowFlags());
    ~PictureLabel();
    void setLocalPixmap(QPixmap pixmap);
    QRect getSourceRect(const QPixmap &pixmap, const QRect &screenGeometry);
    QRect getSourceRect(const QPixmap &pixmap);
    QRect getDestRect(const QPixmap &pixmap);
    void setMode(QString mode);

protected:
    void paintEvent(QPaintEvent *e);

private:
    QString mode;
    QPixmap m_pixmap;
};

#endif // PICTURELABEL_H
