/* tua_4_taylor.h -- Constants and structs definition,
 *                   functions prototype for Taylor Uucp.
 *
 * This file is part of TUA.
 *
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef _TUA_4_TAYLOR_H
#define _TUA_4_TAYLOR_H

#include "tua.h"

struct stats
{
  char * User;
  char * System;
  Julian_t TimeStamp;
  direction_t Direction;
  float Bytes;
  float Time;
#ifdef TAYLOR_LOGS_PATCH  
  char * PortName;
#endif
  BOOLEAN failed;
};

struct log
{
  char * Owner;
  char * System;
  char * User;
  Julian_t TimeStamp;
  int ProcessId;
  char * PortName;
  char * Command;
};
  
extern int EXFUN (GetStats, (FILE *, struct stats *));
extern int EXFUN (GetLog, (FILE *, struct log *));

#endif /* _TUA_4_TAYLOR_H */
