
# Copyright (C) 2020-2022 Tommi Höynälänmaa

# This file is part of Theme-D-Intr.

# You can redistribute and/or modify this file under the terms of the
# GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.

# This file is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program. If not, see https://www.gnu.org/licenses/.


.PHONY: all clean

EXTRA_COMP_OPTIONS ?=
EXTRA_LINK_OPTIONS ?=

TDC := theme-d-compile

TDL := theme-d-link

GEN_INTF := generate-intr-interface
GEN_BODY := generate-intr-body
GEN_TM := generate-intr-target-module

ifdef THEME_D_LIB_DIR
	MODULE_OPTION := -m .:$(THEME_D_LIB_DIR)
else
	MODULE_OPTION := -m .:
endif

all: hello.go

clean:
	-rm hello.go hello.tcp _intr-imports.tci _intr-imports.tcb \
	  _intr-imports.thi _intr-imports.thb _intr-imports-target.scm

hello.go: hello.tcp _intr-imports.tci _intr-imports.tcb \
	_intr-imports-target.scm
	$(TDL) $(MODULE_OPTION) \
	  -x "(g-golf)" \
	  -x "(guile-theme-d-intr support)" \
	  -x "(_intr-imports-target)" \
	  --duplicates="merge-generics replace warn-override-core warn last" \
	  --extra-guild-options="" \
	  $(EXTRA_LINK_OPTIONS) $<

hello.tcp: _intr-imports.tci

_intr-imports.thi: intr-imports.scm
	$(GEN_INTF)

_intr-imports.thb: intr-imports.scm
	$(GEN_BODY)

_intr-imports-target.scm: intr-imports.scm
	$(GEN_TM)

%.tci: %.thi
	$(TDC) $(MODULE_OPTION) $(EXTRA_COMP_OPTIONS) $<

%.tcb: %.thb
	$(TDC) $(MODULE_OPTION) $(EXTRA_COMP_OPTIONS) $<

%.tcp: %.thp
	$(TDC) $(MODULE_OPTION) $(EXTRA_COMP_OPTIONS) $<
