---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, arts et loisirs, arts, loisirs,
              cuisine, recettes de cuisine,enseignement ménager, recettes,
              ingrédients
---

# Comment écrire des recettes de cuisine ?

## Avec l'extension <ctanpkg:xcookybooky>

:::{todo} Compléter et ajouter un exemple
:::

Vous pouvez aussi utiliser [un modèle](https://www.overleaf.com/latex/templates/recipe-book/pqfjxcxnpyps) 
basé sur <ctanpkg:xcookybooky> et constitué par Baptiste Le Roy. 


## Avec l'extension <ctanpkg:cuisine>

L'extension <ctanpkg:cuisine> permet de décrire le déroulement 
d'une préparation, avec, en regard, la liste des ingrédients à utiliser 
à chaque étape. Il utilise un modèle de livres de cuisine en usage 
au Royaume-Uni.

Voici un premier exemple avec le moteur `pdflatex`.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}       % Encodage T1 (adapté au français)
  \usepackage{lmodern}           % Caractères plus lisibles
  \usepackage{babel}             % Réglages linguistiques (avec french)
  \pagestyle{empty}              % N'affiche pas de numéro de page
  \usepackage[a4paper]{geometry} % Amélioration de la géométrie de la page
  \usepackage{cuisine}

\begin{document}
\begin{recipe}{Œuf dur\\d'après le \emph{Larousse de la cuisine}}{pour 
  1~personne}{préparation \& cuisson : 15\,min}
\Ingredient{eau}
Porter une casserole d'eau à ébullition. 
\Ingredient{1~œuf}
Pour éviter que la coquille se fende et que le blanc sorte de la coquille, 
vous pouvez utiliser un pique-œuf.\\
Déposer délicatement l'œuf dans la casserole. Porter à nouveau à ébullition.\\
Cuire 10~minutes.\\
Vider la casserole de l'eau bouillante. La remplir d'eau froide 
pour rafraîchir l'œuf. L'écaler quand il est froid.
\end{recipe}
\end{document}
```

Et voici un exemple avec le moteur `lualatex`.

```
% !TEX TS-program = LuaLaTeX
\documentclass[french]{article}
  \usepackage[fulloldstyle]{kpfonts-otf} % choix de la police, des chiffres, 
                                         % des ligatures. Fontspec est chargé
  \usepackage{babel}             % Réglages linguistiques (avec french)
  \pagestyle{empty}              % N'affiche pas de numéro de page
  \usepackage{microtype}         % Ajustements typographiques fins
  \usepackage[a4paper]{geometry} % Amélioration de la géométrie de la page

  \usepackage[nonumber]{cuisine} % [nonumber] supprime la numérotation 
                                 % du titre de la recette

\begin{document}
\begin{recipe}{\emph{Tourin} (soupe du Béarn)\\d'après Adrienne 
  \textsc{Biasin}}{pour 4~personnes}{préparation \& cuisson : 30\,min}
\Ingredient{2~belles têtes d'ail}
\Ingredient{huile d'olive}
\Ingredient{beurre (facultatif)}
Éplucher et écraser grossièrement les gousses d'ail. Les faire revenir 
doucement dans l'huile et le beurre.
\Ingredient{1\,l d'eau}
\Ingredient{gros sel de mer}
\Ingredient{poivre du moulin}
Mouiller avec 1~litre d'eau, saler, poivrer. Laisser cuire 15~minutes 
après le départ de l'ébullition. Puis passer au chinois en écrasant bien 
les gousses (cette préparation se fait juste avant de servir).
\Ingredient{cheveux d'ange}
Porter à nouveau à ébullition. Verser le vermicelle en pluie dans la soupe.
\Ingredient{6~œufs}
Séparez les jaunes des blancs, et, lorsque le vermicelle est cuit, 
ajoutez les blancs, sans mélanger. Ils prendront la forme d'un nuage.
\Ingredient{6~demi-coquilles de vinaigre de vin}
Dans un bol, mélangez les jaunes avec la même quantité de vinaigre, 
les moitiés de coquille servant de mesure.
Ajoutez à la soupe, en mélangeant doucement, et servez aussitôt.
\vskip5pt % impose un saut de ligne de 5 points
Vin : un blanc bien sec, comme un cassis blanc ou un pouilly fumé : 
\og{}Compte tenu de l'ail et du vinaigre, le choix est assez restreint. 
Ces deux blancs, le premier charpenté et bien fruité, le second puissant 
et chaleureux, conviennent parfaitement.\fg{}.
\end{recipe}
\end{document}
```


:::{sources}
- [Documentation](texdoc:cuisine) de l'extension <ctanpkg:cuisine>
:::