# this contains imports plugins that configure py.test for astropy tests.
# by importing them here in conftest.py they are discoverable by py.test
# no matter how it is invoked within the source tree.

from importlib.util import find_spec

from astropy.version import version as astropy_version
from astropy.tests.plugins.display import PYTEST_HEADER_MODULES, TESTED_VERSIONS
from astropy.tests.helper import enable_deprecations_as_exceptions

## Uncomment the following line to treat all DeprecationWarnings as
## exceptions
enable_deprecations_as_exceptions()

# Uncomment and customize the following lines to add/remove entries from
# the list of packages for which version numbers are displayed when running
# the tests. Making it pass for KeyError is essential in some cases when
# the package uses other astropy affiliated packages.
try:
    PYTEST_HEADER_MODULES['Astropy'] = 'astropy'
    PYTEST_HEADER_MODULES['gwcs'] = 'gwcs'
    del PYTEST_HEADER_MODULES['h5py']
    del PYTEST_HEADER_MODULES['Pandas']
    del PYTEST_HEADER_MODULES['Matplotlib']
except (NameError, KeyError):  # NameError is needed to support Astropy < 1.0
    pass

# Use ASDF schema tester plugin if ASDF is installed
if find_spec('asdf') is not None:
    PYTEST_HEADER_MODULES['Asdf'] = 'asdf'

# Uncomment the following lines to display the version number of the
# package rather than the version number of Astropy in the top line when
# running the tests.
import os

# This is to figure out the affiliated package version, rather than
# using Astropy's
try:
    from .version import version
except ImportError:
    version = 'dev'

try:
    packagename = os.path.basename(os.path.dirname(__file__))
    TESTED_VERSIONS[packagename] = version
except NameError:   # Needed to support Astropy <= 1.0.0
    pass


# makes sure matplotlib doesn't try to pop up plots
try:
    import matplotlib
except ImportError:
    pass
else:
    matplotlib.use('Agg')
