7.1 Contrôle des synthés en cours de jeu

# Contrôle des synthés en train de jouer

Pour l'instant, nous nous sommes seulement préoccupés de déclencher 
de nouveaux sons et effets (FX). Toutefois, Sonic Pi nous offre la 
capacité de manipuler et de contrôler les sons pendant qu'il sont 
joués. Nous le faisons en utilisant une variable pour mémoriser la 
référence à un synthé. 

```
s = play 60, release: 5
```

Ici, nous avons une variable locale d'exécution `s` qui représente le 
synthé jouant la note 60. Notez que c'est *local à l'exécution* - 
vous ne pouvez pas y accéder depuis d'autres exécutions comme les 
fonctions.

Une fois que nous avons `s`, nous pouvons commencer à le contrôler via 
la fonction `control` :

```
s = play 60, release: 5
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

La chose à remarquer est que nous ne sommes pas en train de déclencher 
4 synthés différents - Nous en déclenchons seulement un et puis nous 
changeons ensuite 3 fois la hauteur, pendant qu'il joue.

Nous pouvons passer n'importe quel paramètre standard à `control`, 
vous pouvez donc contrôler des choses telles que `amp:`, `cutoff:` ou 
`pan`.

## Paramètres non contrôlables

Quelques paramètres ne peuvent pas être contrôlés une fois que le 
synthé joue. C'est le cas pour tous les paramètres d'enveloppe ADSR. 
Vous pouvez trouver quels paramètres sont contrôlables en regardant 
leur documentation dans le système d'aide. Si la documentation dit *Can 
not be changed once set (ne peut être modifié une fois attribué)*, 
vous savez que ce n'est pas possible de contrôler le paramètre après 
que le synthé ait commencé à jouer.

