/*
 * This file is part of the API Extractor project.
 *
 * Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
 * Copyright (C) 2002-2005 Roberto Raggi <roberto@kdevelop.org>
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#include "dumptree.h"

#include <QtCore/QString>
#include <QtCore/qdebug.h>

static char const * const names[] = {
    0,
    "AccessSpecifier",
    "AsmDefinition",
    "BaseClause",
    "BaseSpecifier",
    "BinaryExpression",
    "CastExpression",
    "ClassMemberAccess",
    "ClassSpecifier",
    "CompoundStatement",
    "Condition",
    "ConditionalExpression",
    "CppCastExpression",
    "CtorInitializer",
    "DeclarationStatement",
    "Declarator",
    "DeleteExpression",
    "DoStatement",
    "ElaboratedTypeSpecifier",
    "EnumSpecifier",
    "Enumerator",
    "ExceptionSpecification",
    "ExpressionOrDeclarationStatement",
    "ExpressionStatement",
    "ForStatement",
    "FunctionCall",
    "FunctionDefinition",
    "IfStatement",
    "IncrDecrExpression",
    "InitDeclarator",
    "Initializer",
    "InitializerClause",
    "LabeledStatement",
    "LinkageBody",
    "LinkageSpecification",
    "MemInitializer",
    "Name",
    "Namespace",
    "NamespaceAliasDefinition",
    "NewDeclarator",
    "NewExpression",
    "NewInitializer",
    "NewTypeId",
    "Operator",
    "OperatorFunctionId",
    "ParameterDeclaration",
    "ParameterDeclarationClause",
    "PostfixExpression",
    "PrimaryExpression",
    "PtrOperator",
    "PtrToMember",
    "ReturnStatement",
    "SimpleDeclaration",
    "SimpleTypeSpecifier",
    "SizeofExpression",
    "StringLiteral",
    "SubscriptExpression",
    "SwitchStatement",
    "TemplateArgument",
    "TemplateDeclaration",
    "TemplateParameter",
    "ThrowExpression",
    "TranslationUnit",
    "TryBlockStatement",
    "TypeId",
    "TypeIdentification",
    "TypeParameter",
    "Typedef",
    "UnaryExpression",
    "UnqualifiedName",
    "Using",
    "UsingDirective",
    "WhileStatement",
    "WinDeclSpec"
};

DumpTree::DumpTree()
{
}

void DumpTree::visit(AST *node)
{
    static int indent = 0;

    if (node)
        qDebug() << QString(indent * 2, ' ').toLatin1().constData() << names[node->kind]
        << '[' << node->start_token << ", " << node->end_token << ']';

    ++indent;
    DefaultVisitor::visit(node);
    --indent;
}

// kate: space-indent on; indent-width 2; replace-tabs on;
