/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "shortcutgrabber.h"

#include <QGridLayout>

ShortcutGrabber::ShortcutGrabber(QWidget *parent)
 : QDialog(parent)
{
  QGridLayout* grid = new QGridLayout(this);

  m_shortcutBtn = new ShortcutButton(this);

  grid->addWidget(m_shortcutBtn);

  m_shortcutBtn->setFocus();

  connect(m_shortcutBtn, SIGNAL(sequenceAccepted(const QKeySequence&)), this, SLOT(acceptSequence(const QKeySequence&)));

  setWindowTitle(tr("Input Shortcut"));
}

ShortcutGrabber::~ShortcutGrabber()
{
}

void ShortcutGrabber::acceptSequence(const QKeySequence& seq)
{
  m_sequence = seq;

  accept();
}

bool ShortcutGrabber::execute()
{
  m_shortcutBtn->grabKeyboard();

  return exec();
}
