# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.cosmosdbforpostgresql import CosmosdbForPostgresqlMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-cosmosdbforpostgresql
# USAGE
    python cluster_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = CosmosdbForPostgresqlMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="ffffffff-ffff-ffff-ffff-ffffffffffff",
    )

    response = client.clusters.begin_create(
        resource_group_name="TestGroup",
        cluster_name="testcluster",
        parameters={
            "location": "westus",
            "properties": {
                "administratorLoginPassword": "password",
                "citusVersion": "11.1",
                "coordinatorEnablePublicIpAccess": True,
                "coordinatorServerEdition": "GeneralPurpose",
                "coordinatorStorageQuotaInMb": 524288,
                "coordinatorVCores": 4,
                "enableHa": True,
                "enableShardsOnCoordinator": False,
                "nodeCount": 3,
                "nodeEnablePublicIpAccess": False,
                "nodeServerEdition": "MemoryOptimized",
                "nodeStorageQuotaInMb": 524288,
                "nodeVCores": 8,
                "postgresqlVersion": "15",
                "preferredPrimaryZone": "1",
            },
            "tags": {},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/stable/2022-11-08/examples/ClusterCreate.json
if __name__ == "__main__":
    main()
