%define version 0.10
%define release 1
Name: pmud 
Distribution: LinuxPPC June 1999 and 2000
Version: %version
Release: %release
Summary: Power Manager daemon for Apple powerbooks
Source: pmud-%{version}.%{release}.tar.gz
Copyright: GPL
Group: Utilities/System
Packager: Stephan Leemburg <stephan@jvc.nl>
BuildRoot: /var/tmp/pmud-%{version}.%{release}-buildroot
Provides: apmd
Prereq: chkconfig
ExclusiveArch: ppc

%description 
pmud is a daemon which periodically polls the PMU (power manager) and performs 
functions such as enabling or disabling devices appropriately when the power 
source changes. It can also be instructed to signal init(8) that a power-
failure has occured.
 
%prep

%setup 

%build
make

%install
rm -fr $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT/usr/X11R6/bin
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/etc/power
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/etc/sysconfig
mkdir -p $RPM_BUILD_ROOT/usr/man/man8

install -c pmud $RPM_BUILD_ROOT/sbin
install -c wakebay $RPM_BUILD_ROOT/sbin
install -c pwrctl $RPM_BUILD_ROOT/etc/power
install -c snooze $RPM_BUILD_ROOT/sbin
install -c fblevel $RPM_BUILD_ROOT/sbin
install -c xmouse $RPM_BUILD_ROOT/usr/X11R6/bin
install -c Batmon $RPM_BUILD_ROOT/usr/bin
install -m 0644 power.conf $RPM_BUILD_ROOT/etc/sysconfig/power
cp pmud.rc $RPM_BUILD_ROOT/etc/rc.d/init.d/pmud
cp pmud.8 $RPM_BUILD_ROOT/usr/man/man8
cp snooze.8 $RPM_BUILD_ROOT/usr/man/man8
cp fblevel.8 $RPM_BUILD_ROOT/usr/man/man8
cp batmon.8 $RPM_BUILD_ROOT/usr/man/man8
cp xmouse.8 $RPM_BUILD_ROOT/usr/man/man8

%clean
rm -rf $RPM_BUILD_ROOT

%pre 
[ -c /dev/pmu ] || {
	echo "creating /dev/pmu"
	mknod /dev/pmu c 10 154
}
[ -c /dev/adb ] || {
	echo "creating /dev/adb"
	mknod /dev/adb c 56 0
}

%post 
ln -s /sbin/snooze /usr/bin/apm 

/sbin/chkconfig --add pmud

%files
%defattr(-,root,root)
/sbin/pmud
/sbin/snooze
/sbin/wakebay
/sbin/fblevel
/usr/X11R6/bin/xmouse
/usr/bin/Batmon
/etc/power/pwrctl
/etc/rc.d/init.d/pmud 
/etc/sysconfig/power
%doc TODO
%doc BUGS
%doc README
%doc INSTALL
%doc CHANGES
%doc THANKS
%doc pwrctl-local
%doc contrib
%doc /usr/man/man8/pmud.8*
%doc /usr/man/man8/snooze.8*
%doc /usr/man/man8/fblevel.8*
%doc /usr/man/man8/batmon.8*
%doc /usr/man/man8/xmouse.8*
