/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <Axes2D.h>
#include <DataNode.h>

//
// Enum conversion methods for Axes2D::Ticks
//

static const char *Ticks_strings[] = {
"Off", "Bottom", "Left", 
"BottomLeft", "All"};

std::string
Axes2D::Ticks_ToString(Axes2D::Ticks t)
{
    int index = int(t);
    if(index < 0 || index >= 5) index = 0;
    return Ticks_strings[index];
}

std::string
Axes2D::Ticks_ToString(int t)
{
    int index = (t < 0 || t >= 5) ? 0 : t;
    return Ticks_strings[index];
}

bool
Axes2D::Ticks_FromString(const std::string &s, Axes2D::Ticks &val)
{
    val = Axes2D::Off;
    for(int i = 0; i < 5; ++i)
    {
        if(s == Ticks_strings[i])
        {
            val = (Ticks)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for Axes2D::Location
//

static const char *Location_strings[] = {
"Inside", "Outside", "Both"
};

std::string
Axes2D::Location_ToString(Axes2D::Location t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Location_strings[index];
}

std::string
Axes2D::Location_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Location_strings[index];
}

bool
Axes2D::Location_FromString(const std::string &s, Axes2D::Location &val)
{
    val = Axes2D::Inside;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Location_strings[i])
        {
            val = (Location)i;
            return true;
        }
    }
    return false;
}

// Type map format string
const char *Axes2D::TypeMapFormatString = "bbbiiiaa";

// ****************************************************************************
// Method: Axes2D::Axes2D
//
// Purpose: 
//   Constructor for the Axes2D class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Axes2D::Axes2D() : 
    AttributeSubject(Axes2D::TypeMapFormatString)
{
    visible = true;
    autoSetTicks = true;
    autoSetScaling = true;
    lineWidth = 0;
    tickLocation = Outside;
    tickAxes = BottomLeft;
    xAxis.GetTitle().SetTitle("X-Axis");
    xAxis.GetTitle().GetFont().SetFont(FontAttributes::Courier);
    xAxis.GetTitle().GetFont().SetBold(true);
    xAxis.GetTitle().GetFont().SetItalic(true);
    xAxis.GetLabel().GetFont().SetFont(FontAttributes::Courier);
    xAxis.GetLabel().GetFont().SetBold(true);
    xAxis.GetLabel().GetFont().SetItalic(true);
    yAxis.GetTitle().SetTitle("Y-Axis");
    yAxis.GetTitle().GetFont().SetFont(FontAttributes::Courier);
    yAxis.GetTitle().GetFont().SetBold(true);
    yAxis.GetTitle().GetFont().SetItalic(true);
    yAxis.GetLabel().GetFont().SetFont(FontAttributes::Courier);
    yAxis.GetLabel().GetFont().SetBold(true);
    yAxis.GetLabel().GetFont().SetItalic(true);
}

// ****************************************************************************
// Method: Axes2D::Axes2D
//
// Purpose: 
//   Copy constructor for the Axes2D class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Axes2D::Axes2D(const Axes2D &obj) : 
    AttributeSubject(Axes2D::TypeMapFormatString)
{
    visible = obj.visible;
    autoSetTicks = obj.autoSetTicks;
    autoSetScaling = obj.autoSetScaling;
    lineWidth = obj.lineWidth;
    tickLocation = obj.tickLocation;
    tickAxes = obj.tickAxes;
    xAxis = obj.xAxis;
    yAxis = obj.yAxis;

    SelectAll();
}

// ****************************************************************************
// Method: Axes2D::~Axes2D
//
// Purpose: 
//   Destructor for the Axes2D class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Axes2D::~Axes2D()
{
    // nothing here
}

// ****************************************************************************
// Method: Axes2D::operator = 
//
// Purpose: 
//   Assignment operator for the Axes2D class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Axes2D& 
Axes2D::operator = (const Axes2D &obj)
{
    if (this == &obj) return *this;
    visible = obj.visible;
    autoSetTicks = obj.autoSetTicks;
    autoSetScaling = obj.autoSetScaling;
    lineWidth = obj.lineWidth;
    tickLocation = obj.tickLocation;
    tickAxes = obj.tickAxes;
    xAxis = obj.xAxis;
    yAxis = obj.yAxis;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: Axes2D::operator == 
//
// Purpose: 
//   Comparison operator == for the Axes2D class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Axes2D::operator == (const Axes2D &obj) const
{
    // Create the return value
    return ((visible == obj.visible) &&
            (autoSetTicks == obj.autoSetTicks) &&
            (autoSetScaling == obj.autoSetScaling) &&
            (lineWidth == obj.lineWidth) &&
            (tickLocation == obj.tickLocation) &&
            (tickAxes == obj.tickAxes) &&
            (xAxis == obj.xAxis) &&
            (yAxis == obj.yAxis));
}

// ****************************************************************************
// Method: Axes2D::operator != 
//
// Purpose: 
//   Comparison operator != for the Axes2D class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Axes2D::operator != (const Axes2D &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: Axes2D::TypeName
//
// Purpose: 
//   Type name method for the Axes2D class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
Axes2D::TypeName() const
{
    return "Axes2D";
}

// ****************************************************************************
// Method: Axes2D::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the Axes2D class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Axes2D::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const Axes2D *tmp = (const Axes2D *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: Axes2D::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the Axes2D class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Axes2D::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new Axes2D(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: Axes2D::NewInstance
//
// Purpose: 
//   NewInstance method for the Axes2D class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Axes2D::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new Axes2D(*this);
    else
        retval = new Axes2D;

    return retval;
}

// ****************************************************************************
// Method: Axes2D::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
Axes2D::SelectAll()
{
    Select(ID_visible,        (void *)&visible);
    Select(ID_autoSetTicks,   (void *)&autoSetTicks);
    Select(ID_autoSetScaling, (void *)&autoSetScaling);
    Select(ID_lineWidth,      (void *)&lineWidth);
    Select(ID_tickLocation,   (void *)&tickLocation);
    Select(ID_tickAxes,       (void *)&tickAxes);
    Select(ID_xAxis,          (void *)&xAxis);
    Select(ID_yAxis,          (void *)&yAxis);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: Axes2D::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Axes2D::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    Axes2D defaultObject;
    bool addToParent = false;
    // Create a node for Axes2D.
    DataNode *node = new DataNode("Axes2D");

    if(completeSave || !FieldsEqual(ID_visible, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("visible", visible));
    }

    if(completeSave || !FieldsEqual(ID_autoSetTicks, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("autoSetTicks", autoSetTicks));
    }

    if(completeSave || !FieldsEqual(ID_autoSetScaling, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("autoSetScaling", autoSetScaling));
    }

    if(completeSave || !FieldsEqual(ID_lineWidth, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

    if(completeSave || !FieldsEqual(ID_tickLocation, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tickLocation", Location_ToString(tickLocation)));
    }

    if(completeSave || !FieldsEqual(ID_tickAxes, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tickAxes", Ticks_ToString(tickAxes)));
    }

    if(completeSave || !FieldsEqual(ID_xAxis, &defaultObject))
    {
        DataNode *xAxisNode = new DataNode("xAxis");
        if(xAxis.CreateNode(xAxisNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(xAxisNode);
        }
        else
            delete xAxisNode;
    }

    if(completeSave || !FieldsEqual(ID_yAxis, &defaultObject))
    {
        DataNode *yAxisNode = new DataNode("yAxis");
        if(yAxis.CreateNode(yAxisNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(yAxisNode);
        }
        else
            delete yAxisNode;
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: Axes2D::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
Axes2D::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("Axes2D");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("visible")) != 0)
        SetVisible(node->AsBool());
    if((node = searchNode->GetNode("autoSetTicks")) != 0)
        SetAutoSetTicks(node->AsBool());
    if((node = searchNode->GetNode("autoSetScaling")) != 0)
        SetAutoSetScaling(node->AsBool());
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("tickLocation")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetTickLocation(Location(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Location value;
            if(Location_FromString(node->AsString(), value))
                SetTickLocation(value);
        }
    }
    if((node = searchNode->GetNode("tickAxes")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 5)
                SetTickAxes(Ticks(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Ticks value;
            if(Ticks_FromString(node->AsString(), value))
                SetTickAxes(value);
        }
    }
    if((node = searchNode->GetNode("xAxis")) != 0)
        xAxis.SetFromNode(node);
    if((node = searchNode->GetNode("yAxis")) != 0)
        yAxis.SetFromNode(node);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
Axes2D::SetVisible(bool visible_)
{
    visible = visible_;
    Select(ID_visible, (void *)&visible);
}

void
Axes2D::SetAutoSetTicks(bool autoSetTicks_)
{
    autoSetTicks = autoSetTicks_;
    Select(ID_autoSetTicks, (void *)&autoSetTicks);
}

void
Axes2D::SetAutoSetScaling(bool autoSetScaling_)
{
    autoSetScaling = autoSetScaling_;
    Select(ID_autoSetScaling, (void *)&autoSetScaling);
}

void
Axes2D::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(ID_lineWidth, (void *)&lineWidth);
}

void
Axes2D::SetTickLocation(Axes2D::Location tickLocation_)
{
    tickLocation = tickLocation_;
    Select(ID_tickLocation, (void *)&tickLocation);
}

void
Axes2D::SetTickAxes(Axes2D::Ticks tickAxes_)
{
    tickAxes = tickAxes_;
    Select(ID_tickAxes, (void *)&tickAxes);
}

void
Axes2D::SetXAxis(const AxisAttributes &xAxis_)
{
    xAxis = xAxis_;
    Select(ID_xAxis, (void *)&xAxis);
}

void
Axes2D::SetYAxis(const AxisAttributes &yAxis_)
{
    yAxis = yAxis_;
    Select(ID_yAxis, (void *)&yAxis);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
Axes2D::GetVisible() const
{
    return visible;
}

bool
Axes2D::GetAutoSetTicks() const
{
    return autoSetTicks;
}

bool
Axes2D::GetAutoSetScaling() const
{
    return autoSetScaling;
}

int
Axes2D::GetLineWidth() const
{
    return lineWidth;
}

Axes2D::Location
Axes2D::GetTickLocation() const
{
    return Location(tickLocation);
}

Axes2D::Ticks
Axes2D::GetTickAxes() const
{
    return Ticks(tickAxes);
}

const AxisAttributes &
Axes2D::GetXAxis() const
{
    return xAxis;
}

AxisAttributes &
Axes2D::GetXAxis()
{
    return xAxis;
}

const AxisAttributes &
Axes2D::GetYAxis() const
{
    return yAxis;
}

AxisAttributes &
Axes2D::GetYAxis()
{
    return yAxis;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
Axes2D::SelectXAxis()
{
    Select(ID_xAxis, (void *)&xAxis);
}

void
Axes2D::SelectYAxis()
{
    Select(ID_yAxis, (void *)&yAxis);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: Axes2D::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
Axes2D::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_visible:        return "visible";
    case ID_autoSetTicks:   return "autoSetTicks";
    case ID_autoSetScaling: return "autoSetScaling";
    case ID_lineWidth:      return "lineWidth";
    case ID_tickLocation:   return "tickLocation";
    case ID_tickAxes:       return "tickAxes";
    case ID_xAxis:          return "xAxis";
    case ID_yAxis:          return "yAxis";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Axes2D::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
Axes2D::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_visible:        return FieldType_bool;
    case ID_autoSetTicks:   return FieldType_bool;
    case ID_autoSetScaling: return FieldType_bool;
    case ID_lineWidth:      return FieldType_linewidth;
    case ID_tickLocation:   return FieldType_enum;
    case ID_tickAxes:       return FieldType_enum;
    case ID_xAxis:          return FieldType_att;
    case ID_yAxis:          return FieldType_att;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: Axes2D::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
Axes2D::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_visible:        return "bool";
    case ID_autoSetTicks:   return "bool";
    case ID_autoSetScaling: return "bool";
    case ID_lineWidth:      return "linewidth";
    case ID_tickLocation:   return "enum";
    case ID_tickAxes:       return "enum";
    case ID_xAxis:          return "att";
    case ID_yAxis:          return "att";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Axes2D::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Axes2D::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const Axes2D &obj = *((const Axes2D*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_visible:
        {  // new scope
        retval = (visible == obj.visible);
        }
        break;
    case ID_autoSetTicks:
        {  // new scope
        retval = (autoSetTicks == obj.autoSetTicks);
        }
        break;
    case ID_autoSetScaling:
        {  // new scope
        retval = (autoSetScaling == obj.autoSetScaling);
        }
        break;
    case ID_lineWidth:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case ID_tickLocation:
        {  // new scope
        retval = (tickLocation == obj.tickLocation);
        }
        break;
    case ID_tickAxes:
        {  // new scope
        retval = (tickAxes == obj.tickAxes);
        }
        break;
    case ID_xAxis:
        {  // new scope
        retval = (xAxis == obj.xAxis);
        }
        break;
    case ID_yAxis:
        {  // new scope
        retval = (yAxis == obj.yAxis);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

