'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS18S20 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS18S20
\- High-Precision 1-Wire Digital Thermometer
.TP
.B DS1920
\- iButton version of the thermometer
.SH SYNOPSIS
Thermometer.
.PP
.B 10
[.]XXXXXXXXXXXX[XX][/[
.B die
|
.B power
|
.B temperature
|
.B temphigh
|
.B templow
|
.B trim
|
.B trimblanket
|
.B trimvalid
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 10
.SH SPECIAL PROPERTIES
.SS power
.I read-only,yes-no
.br
Is the chip powered externally (=1) or from the parasitically from the data bus (=0)?
.SS temperature
.I read-only, floating point
.br
.I Temperature
read by the chip at high resolution (~12 bits). Units are selected from the invoking command line. See
.B owfs(1)
or
.B owhttpd(1)
for choices. Default is Celsius.
Conversion takes 1000 msec.
.so man3/temperature_threshold.3so
.so man3/temperature_errata.3so
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH DESCRIPTION
.so man3/description.3so
.SS DS18S20 DS1920
The
.B DS18S20 (3)
is one of several available 1-wire temperature sensors. It has been largely replaced by the
.B DS18B20 (3)
and
.B DS1822 (3)
as well as temperature/vlotage measurements in the
.B DS2436 (3)
and
.B DS2438 (3).
For truly versatile temperature measurements, see the protean
.B DS1921 (3) Thermachron (3).
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS18S20.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
