###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mapserver_detect.nasl 1346 2009-04-07 12:21:12Z apr $
#
# MapServer Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800547);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("MapServer Version Detection");
  desc = "

  Overview: This script detects the installed version of MapServer
  and sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets KB for Version of MapServer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

mapPort = get_kb_item("Services/www");
if(!mapPort){
  mapPort = 80;
}

if(!get_port_state(mapPort)){
  exit(0);
}

sndReq = http_get(item:string("/cgi-bin/mapserv?map="), port:mapPort);
rcvRes = http_keepalive_send_recv(port:mapPort, data:sndReq, bodyonly:1);

if("MapServer" >!< rcvRes)
{
  sndReq = http_get(item: string("/cgi-bin/mapserv.exe?map="), port:mapPort);
  rcvRes = http_keepalive_send_recv(port:mapPort, data:sndReq, bodyonly:1);
  if("MapServer" >!< rcvRes){
    exit(0);
  }
}

mapVer = eregmatch(pattern:"MapServer version ([0-9]\.[0-9.]+)", string:rcvRes);
if(mapVer[1] != NULL)
{
  set_kb_item(name:"www/" + mapPort + "/MapServer", value:mapVer[1]);
  security_note(data:"MapServer version " + mapVer[1] + " was detected on the host");
}
