---
title: User Manual
last_modified_date: 31 January 2021
redirect_from:
  - /
  - /Home
nav_order: 0.01
---

{% if doxygen %}
**Note:** The [online version](https://www.openorienteering.org/mapper-manual/) of this documentation may contain additions and corrections.
{% endif %}

## Contents

[Installation](installation.md){: .subpage}
Instructions to download and install OpenOrienteering.

[Introduction to the User Interface](main_window.md){: .subpage}
Explanation of the home screen and main drawing window.

[The Touch Mode User Interface](touch-mode.md){: .subpage}
Using the Mapper app in "Touch Mode".

[The Mapper app for Android](android-app.md){: .subpage}
Working with the Android version of Mapper.

[Starting a new map](new_map.md){: .subpage}
First steps.

[Georeferencing](georeferencing.md){: .subpage}
Defining the relationship between map paper coordinates and real world coordinates.

[Map grid](grid.md){: .subpage}
Showing a helper grid in the map view.

[Objects](objects-index.md){: .subpage}
Organizing, tagging and finding map objects.

[Templates and Data](templates-index.md){: .subpage}
Using and processing images and geospatial data.

[Colors and symbols](colors_symbols.md){: .subpage}
Modifying map colors and symbols.

[Course design](course_design.md){: .subpage}
Using the course design symbol set.

[Reference](reference.md){: .subpage}
Drawing tools, toolbars, menu items, settings, CRT files.

[FAQ](faq.md){: .nosubpage}
Frequently asked questions.


## Online resources

[Blog](https://www.openorienteering.org/)
The latest news from OpenOrienteering.

[Issues list](https://github.com/OpenOrienteering/mapper/issues)
Submit feedback, bug reports, feature requests, and contributions.

[Releases](https://github.com/OpenOrienteering/mapper/releases)
Releases, with links to change information and known issues.
