/*###############################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_DNSCAPABILITIESACCESS_H_
#define OPENDRIM_DNSCAPABILITIESACCESS_H_

#include "DNS_Common.h"

#include "OpenDRIM_DNSCapabilities.h"
#include "assocOpenDRIM_DNSCapabilities.h"

int DNS_OpenDRIM_DNSCapabilities_load(const CMPIBroker* broker, string& errorMessage);

int DNS_OpenDRIM_DNSCapabilities_unload(string& errorMessage);

int DNS_OpenDRIM_DNSCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DNSCapabilities>& instances, const char** properties, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNSCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DNSCapabilities& instance, const char** properties, string& errorMessage);

int DNS_OpenDRIM_DNSCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSCapabilities& newInstance, const OpenDRIM_DNSCapabilities& oldInstance, const char** properties, string& errorMessage);

int DNS_OpenDRIM_DNSCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSCapabilities& instance, string& errorMessage);

int DNS_OpenDRIM_DNSCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSCapabilities& instance, string& errorMessage);

int DNS_OpenDRIM_DNSCapabilities_associatorCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNSCapabilities_associatorManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& Capabilities_associatedInstances, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNSCapabilities_referenceCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_DNSCapabilities>& OpenDRIM_DNSCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNSCapabilities_referenceManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& Capabilities_instances, vector<OpenDRIM_DNSCapabilities>& OpenDRIM_DNSCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNSCapabilities_populate(OpenDRIM_DNSCapabilities& instance, string& errorMessage);

#endif /*OPENDRIM_DNSCAPABILITIESACCESS_H_*/
