/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service;

import java.util.List;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.chefproject.core.User;
import org.chefproject.core.UserEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.generic.GenericUserDirectoryService;
import org.w3c.dom.Element;

public class UserDirectoryService {
    protected static GenericUserDirectoryService M_service = null;

    protected static void find() {
        if (M_service == null && (M_service = (GenericUserDirectoryService)((Object)TurbineServices.getInstance().getService(GenericUserDirectoryService.SERVICE_NAME))) == null) {
            Log.warn("chef", "UserDirectoryService.find: missing service: " + GenericUserDirectoryService.SERVICE_NAME);
        }
    }

    public static GenericUserDirectoryService getInstance() {
        UserDirectoryService.find();
        return M_service;
    }

    public static User getUser(String id) throws IdUnusedException {
        UserDirectoryService.find();
        return M_service.getUser(id);
    }

    public static User findUserByEmail(String email) throws IdUnusedException {
        UserDirectoryService.find();
        return M_service.findUserByEmail(email);
    }

    public static boolean allowUpdateUser(String id) {
        UserDirectoryService.find();
        return M_service.allowUpdateUser(id);
    }

    public static UserEdit editUser(String id) throws IdUnusedException, PermissionException, InUseException {
        UserDirectoryService.find();
        return M_service.editUser(id);
    }

    public static void commitEdit(UserEdit user) {
        UserDirectoryService.find();
        M_service.commitEdit(user);
    }

    public static void cancelEdit(UserEdit user) {
        UserDirectoryService.find();
        M_service.cancelEdit(user);
    }

    public static User getAnonymousUser() {
        UserDirectoryService.find();
        return M_service.getAnonymousUser();
    }

    public static List getUsers() {
        UserDirectoryService.find();
        return M_service.getUsers();
    }

    public static boolean allowAddUser(String id) {
        UserDirectoryService.find();
        return M_service.allowAddUser(id);
    }

    public static UserEdit addUser(String id) throws IdInvalidException, IdUsedException, PermissionException {
        UserDirectoryService.find();
        return M_service.addUser(id);
    }

    public static UserEdit mergeUser(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        UserDirectoryService.find();
        return M_service.mergeUser(el);
    }

    public static boolean allowRemoveUser(String id) {
        UserDirectoryService.find();
        return M_service.allowRemoveUser(id);
    }

    public static void removeUser(UserEdit user) throws PermissionException {
        UserDirectoryService.find();
        M_service.removeUser(user);
    }

    public static boolean authenticate(String id, String password) {
        UserDirectoryService.find();
        return M_service.authenticate(id, password);
    }

    public static String userReference(String id) {
        UserDirectoryService.find();
        return M_service.userReference(id);
    }
}

