"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
exports.__esModule = true;
var Arbitrary_1 = require("./definition/Arbitrary");
/** @hidden */
var FrequencyArbitrary = /** @class */ (function (_super) {
    __extends(FrequencyArbitrary, _super);
    function FrequencyArbitrary(warbs) {
        var _this = _super.call(this) || this;
        _this.warbs = warbs;
        _this.summedWarbs = warbs
            .reduce(function (p, c) {
            return p.concat({
                weight: p[p.length - 1].weight + c.weight,
                arbitrary: c.arbitrary
            });
        }, [{ weight: 0, arbitrary: warbs[0].arbitrary }])
            .slice(1);
        _this.totalWeight = _this.summedWarbs[_this.summedWarbs.length - 1].weight;
        return _this;
    }
    FrequencyArbitrary.prototype.generate = function (mrng) {
        var selected = mrng.nextInt(0, this.totalWeight - 1);
        return this.summedWarbs.find(function (warb) { return selected < warb.weight; }).arbitrary.generate(mrng);
    };
    FrequencyArbitrary.prototype.withBias = function (freq) {
        return new FrequencyArbitrary(this.warbs.map(function (v) { return ({ weight: v.weight, arbitrary: v.arbitrary.withBias(freq) }); }));
    };
    return FrequencyArbitrary;
}(Arbitrary_1["default"]));
/**
 * For one of the values generated by `warb0` or `...warbs` - the probability of selecting the ith warb is of `warb[i].weight / sum(warb[j].weight)`
 * @param warb0 One of the (Arbitrary, weight) that might be called to produce a value
 * @param warbs Other possible (Arbitrary, weight)
 */
function frequency(warb0) {
    var warbs = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        warbs[_i - 1] = arguments[_i];
    }
    return new FrequencyArbitrary(__spread([warb0], warbs));
}
exports.frequency = frequency;
//# sourceMappingURL=FrequencyArbitrary.js.map