if (typeof test === 'undefined') require('../test');

test('round', function () {
  var u;
  
  function t(expected, value, decimalPlaces, roundingMode) {
    test.areEqual(String(expected), new Big(String(value)).round(decimalPlaces, roundingMode).toString());
  }
  
  Big.DP = 20;
  Big.RM = 1;

  t('0', '0.000084888060736883027314038572334303632');
  t('30845717889906383053', '30845717889906383052.56472015469740823');
  t('76', '76.0719');
  t('0', '-0.00686876124450101884528');
  t('71710176', '71710176');
  t('79', '79');
  t('6309793381', '6309793381');
  t('76162410487880977', '76162410487880976.81307140573688335764284');
  t('7491318926', '7491318926.312122759153805942088431');
  t('74909422733607112719', '74909422733607112719.13179009875');
  t('559', '559.2110851431205');
  t('8', '8.0606265529');
  t('24701408591129838', '24701408591129838.22163');
  t('826068555927524695', '826068555927524695');
  t('0', '0.000058441452091833136219167587256');
  t('47353089', '47353089.2019161006899898');
  t('3103', '3103');
  t('5620', '5620.48101861977');
  t('9105547112', '9105547112.1319443692');
  t('335816732795', '335816732794.51601276961965281205689254');
  t('439059239410', '439059239409.55703238112278');
  t('43465109466157505', '43465109466157505');
  t('5390894521', '5390894520.8738091063016');
  t('485669', '485669');
  t('3', '3.284095344472285718254591781467536534546');
  t('0', '-0.4210910538061556801483189');
  t('3134', '3133.654494231705614');
  t('27796900', '27796900.0685101');
  t('736988809325', '736988809325');
  t('577064478018279', '577064478018279');
  t('3269018763090', '3269018763089.5711045989917554');

  t(0, 0);
  t(0, -0);
  t(1, 0.5);
  t(1, 0.7);
  t(1, 1);
  t(1, 1.1);
  t(1, 1.49999);
  t(-1, -0.5);
  t(-1, -0.5000000000000001);
  t(-1, -0.7);
  t(-1, -1);
  t(-1, -1.1);
  t(-1, -1.49999);
  t(-2, -1.5);
  t(-10, -10);

  t(9007199254740990, 9007199254740990);
  t(9007199254740991, 9007199254740991);
  t(-9007199254740990, -9007199254740990);
  t(-9007199254740991, -9007199254740991);

  t(536870911, 536870910.5);
  t(536870911, 536870911);
  t(536870911, 536870911.4);
  t(536870912, 536870911.5);
  t(536870912, 536870912);
  t(536870912, 536870912.4);
  t(536870913, 536870912.5);
  t(536870913, 536870913);
  t(536870913, 536870913.4);
  t(1073741823, 1073741822.5);
  t(1073741823, 1073741823);
  t(1073741823, 1073741823.4);
  t(1073741824, 1073741823.5);
  t(1073741824, 1073741824);
  t(1073741824, 1073741824.4);
  t(1073741825, 1073741824.5);
  t(2147483647, 2147483646.5);
  t(2147483647, 2147483647);
  t(2147483647, 2147483647.4);
  t(2147483648, 2147483647.5);
  t(2147483648, 2147483648);
  t(2147483648, 2147483648.4);
  t(2147483649, 2147483648.5);

  t(0, 0.4);
  t(-0, -0.4);
  t(-1, -0.5);
  t(1, 0.6);
  t(-1, -0.6);
  t(2, 1.5);
  t(2, 1.6);
  t(-2, -1.6);

  t(8640000000000000, 8640000000000000);
  t(8640000000000001, 8640000000000001);
  t(8640000000000002, 8640000000000002);
  t(9007199254740990, 9007199254740990);
  t(9007199254740991, 9007199254740991);
  t(-8640000000000000, -8640000000000000);
  t(-8640000000000001, -8640000000000001);
  t(-8640000000000002, -8640000000000002);
  t(-9007199254740990, -9007199254740990);
  t(-9007199254740991, -9007199254740991);

  t(0, 0.49999999999999994);
  t(1, 0.5);
  t(-0, -0.49999999999999994);

  t('0', '-0', 0);
  t('0', '-0', 1, 0);
  t('0', '0', 10);
  t('0', '-0', 20);

  // Tests generated using java BigDecimal and random values.
  t('-7187', '-7187', 4, 1);
  t('-2.4263', '-2.426346', 4, 2);
  t('652506', '652506', 3, 2);
  t('-0.0496', '-0.049635', 4, 1);
  t('520216039', '520216039', 7, 0);
  t('53937.3', '53937.399', 1, 0);
  t('-3583', '-3583', 5, 0);
  t('-888980.3', '-888980.3', 1, 2);
  t('-0.336889', '-0.336888682', 6, 2);
  t('43759', '43759', 6, 1);
  t('0.0000804', '0.0000804', 8, 2);
  t('336379823', '336379823', 4, 0);
  t('-5446775', '-5446775', 7, 1);
  t('47086', '47085.84', 0, 1);
  t('-2564', '-2564', 3, 1);
  t('-0.4', '-0.42528874', 1, 2);
  t('-0.00005573', '-0.000055732', 8, 0);
  t('-0.00003014', '-0.000030137', 8, 2);
  t('57', '57', 3, 2);
  t('-7', '-7', 0, 1);
  t('-0.00004595', '-0.00004595', 8, 0);
  t('-22243', '-22243', 0, 0);
  t('5', '5', 1, 2);
  t('2', '2', 2, 2);
  t('3808', '3808', 0, 1);
  t('0.00009', '0.00008892', 5, 1);
  t('0.07', '0.06922', 2, 1);
  t('-326', '-326', 2, 0);
  t('-0.356', '-0.3564473', 3, 2);
  t('0', '-0.003', 0, 1);
  t('-572936', '-572936', 3, 2);
  t('684.2426407', '684.2426407', 8, 2);
  t('0', '-0.0007851', 1, 2);
  t('-0.00064', '-0.00063953', 6, 2);
  t('-3.76703298', '-3.767032983', 8, 1);
  t('-645406477.5', '-645406477.5', 2, 0);
  t('-0.89603', '-0.8960278', 5, 2);
  t('484.002', '484.002', 4, 2);
  t('420', '419.83', 0, 2);
  t('4611867124', '4611867124', 4, 1);
  t('0', '-0.02829833', 1, 1);
  t('-8', '-8', 0, 1);
  t('-0.0073554', '-0.00735541', 7, 1);
  t('228', '228', 3, 1);
  t('0', '0.005', 0, 2);
  t('-0.026', '-0.0259', 3, 1);
  t('-0.00801', '-0.008007359', 5, 1);
  t('-81', '-81', 4, 2);
  t('-2876', '-2876', 5, 2);
  t('-62453828', '-62453828', 7, 2);
  t('-706', '-706', 0, 0);
  t('36.911', '36.9109527', 4, 1);
  t('-0.08', '-0.08', 2, 1);
  t('-0.352847', '-0.352847085', 6, 2);
  t('-0.4389', '-0.438905', 4, 0);
  t('-8858843.829', '-8858843.829', 3, 0);
  t('608475', '608475', 6, 2);
  t('-1.6', '-1.5678', 1, 2);
  t('-7.173', '-7.173', 4, 2);
  t('-54.37621076', '-54.37621076', 8, 1);
  t('4823.725785', '4823.725785', 7, 1);
  t('0', '-0.000084', 1, 1);
  t('-7491', '-7491', 4, 2);
  t('-0.8', '-0.8109', 1, 2);
  t('-91.1579356', '-91.15793558', 7, 2);
  t('-5376196', '-5376196', 1, 2);
  t('-0.6', '-0.6', 1, 2);
  t('-39983.5195', '-39983.5195', 5, 2);
  t('-0.723', '-0.722771', 3, 1);
  t('-8637388', '-8637388', 4, 0);
  t('193', '193', 4, 2);
  t('0.00052', '0.00051869', 5, 2);
  t('-0.248552', '-0.248552', 6, 1);
  t('0.8599583', '0.8599583', 7, 2);
  t('868619', '868619', 3, 1);
  t('-0.0003926', '-0.0003926', 7, 1);
  t('4.3567', '4.35670557', 4, 1);
  t('-238', '-238', 3, 0);
  t('1271.594054', '1271.594054', 7, 1);
  t('-4.1787893', '-4.178789328', 7, 0);
  t('372', '372', 3, 2);
  t('-9.1645', '-9.1645354', 4, 2);
  t('83.241462', '83.241462', 6, 2);
  t('-0.00001262', '-0.00001262', 8, 2);
  t('2138522', '2138522', 6, 0);
  t('-1969563', '-1969563', 8, 0);

  t('0.00085774283834918184933525579624189945402764', '0.0008577428383491818493352557962418994540276420616048890965876345513', 44, 1);
  t('0', '0.0000083135366316053183734543904737952651532784316140061929170739473518406297062533554026617147464', 0, 0);
  t('-22678769.817248435493696742588538', '-22678769.817248435493696742588538331241538369550386799148219117165563326051964281', 24, 1);
  t('-35620697798492911.0669248410687861643251268323797667576839159303711022', '-35620697798492911.066924841068786164325126832379766757683915930371102255700535220012496346147093317', 52, 0);
  t('-0.8174627036499993060703761337876311', '-0.81746270364999930607037613378763105641195817852303184573911882', 34, 1);
  t('-0.0005550919624693963627417354876271038367574907', '-0.000555091962469396362741735487627103836757490736793688', 46, 2);
  t('83', '83', 1, 1);
  t('-554303811557294466.269761483473739646624314242607077', '-554303811557294466.269761483473739646624314242607077815435340758612837177421989342652', 33, 0);
  t('-0.19004485', '-0.19004485473016995992614957080209680408919713640428488619', 8, 0);
  t('0.000252525605711892', '0.000252525605711891731866212005527221984514215823140269482997380211714402276122070798053', 18, 2);
  t('-20967.65067808575', '-20967.6506780857520813447701235001803657407937', 11, 2);
  t('-274912.8896024699', '-274912.8896024699118787839924993246206752520896053416203239133353705', 10, 0);
  t('-2651358523359639', '-2651358523359639', 16, 1);
  t('-699708233495.712278374225898965891885496', '-699708233495.71227837422589896589188549642075052667001859282382939797996992686357419809583', 27, 1);
  t('6744808.28630410992583043657159413157574982400492', '6744808.28630410992583043657159413157574982400491999838773235902794700459508120619939892', 42, 2);
  t('0.07662404229928167815820747802086592943344134084819', '0.0766240422992816781582074780208659294334413408481864862625859275536716954542357278357044523255', 50, 1);
  t('663336.45734367931832199866', '663336.4573436793183219986595282312647796998714487327022132545955984591825466144183', 20, 1);
  t('-461221276.52047063868261544207237644195170184', '-461221276.5204706386826154420723764419517018397461911607', 36, 1);
  t('19446.966116400627008657626752077217581388920002', '19446.966116400627008657626752077217581388920001650492489914443643730475', 42, 2);
  t('0.42425', '0.4242532985015934975349331325449597502579863812797694513697436078382', 5, 2);
  t('-0.0000762276772207934863238537452', '-0.000076227677220793486323853745211809223538788353453336644181293192727858100277468114', 31, 0);
  t('2545.02415115677316212239', '2545.0241511567731621223858827267448711169160082660710108790421759089', 20, 1);
  t('182677642047881.78165441673019155464219406264001214565556885348479', '182677642047881.78165441673019155464219406264001214565556885348478627713505384459736760885446', 50, 1);
  t('11036262983412.43034', '11036262983412.43033528368482450310801430632754197929230502318864896161821328429506937237954870210095', 5, 2);
  t('114826904256612733.386864222161825009298982005624415354243438170865464426025', '114826904256612733.3868642221618250092989820056244153542434381708654644260250420408639727676555', 58, 2);
  t('-0.012993495776054845588950537203826106468', '-0.01299349577605484558895053720382610646775576321', 39, 1);
  t('33939997624.0197921818931949496918774963224187187', '33939997624.01979218189319494969187749632241871866115828172706446', 37, 1);
  t('0.00013443010000122739', '0.000134430100001227389387332790313969924187247172103522415803', 20, 1);
  t('-209.9943998837517521171865', '-209.9943998837517521171865', 22, 0);
  t('-5091778328', '-5091778328', 3, 1);
  t('0.12237956363887424653903641168389546218306318289244', '0.122379563638874246539036411683895462183063182892438860817851', 50, 2);
  t('-21623630838130.41753786411051466836143', '-21623630838130.41753786411051466836142541353', 23, 1);
  t('0.01670470626375882709919052077738319859836353121358428', '0.01670470626375882709919052077738319859836353121358428381884805750145', 53, 2);
  t('-0.00007215749036271791941521566318078882873853148647784214', '-0.0000721574903627179194152156631807888287385314864778421351738105827688353', 56, 1);
  t('366211876730525184.2112925847409', '366211876730525184.2112925847408882079013862619705659971494103242295', 13, 2);
  t('614620959.71471965275572405064779427741657286', '614620959.71471965275572405064779427741657286365469689495728000154430488188257888436646377190255908', 35, 1);
  t('0.00081378123325625046095444674524950183268906906', '0.0008137812332562504609544467452495018326890690605771240762295999653129452516984857208', 48, 0);
  t('22790948246303245', '22790948246303245', 2, 0);
  t('26063.51488387693273367995592341542227268081315828530152', '26063.51488387693273367995592341542227268081315828530152248204562165099342', 50, 0);
  t('82575172816978114.87683857936991415384457', '82575172816978114.876838579369914153844570011199517178441757629522946782860018297776571802906754196', 24, 1);
  t('-2437094615.41350858123042926442269584680387347048427179419', '-2437094615.4135085812304292644226958468038734704842717941889573519082323297558840308', 47, 2);
  t('332180937526303', '332180937526303', 11, 2);
  t('-309838422086.048', '-309838422086.04808185', 3, 0);
  t('3747046262', '3747046262', 5, 0);
  t('169029712348.55170414716062751882592912346872779338106493155966548277055', '169029712348.551704147160627518825929123468727793381064931559665482770557368651', 59, 0);
  t('31.0602835210115', '31.06028352101159116694707249229172391419071049341139', 13, 0);
  t('-290563347.4018618590644496547932201955716045339506671235383081837373', '-290563347.40186185906444965479322019557160453395066712353830818373739840892194032111993775', 58, 0);
  t('36646445.4', '36646445.42824516523285194093354092096642673855547686910006', 1, 1);
  t('0.43424917263886958982405140577413037118', '0.43424917263886958982405140577413037118797467795184', 38, 0);
  t('-35159732781823.97716511119720206064558667', '-35159732781823.977165111197202060645586672946470926242812549089110584121041', 26, 1);
  t('4478793059557.919366066899688681937166624937', '4478793059557.919366066899688681937166624937037651207942775207986303596524642642692579', 31, 0);
  t('-0.00000336921984240686812663817912975898', '-0.00000336921984240686812663817912975898003855606655763928424753588827973199516045', 38, 0);
  t('-7094775936348915.769263075129454561542743852557970402', '-7094775936348915.7692630751294545615427438525579704015758356635999962', 36, 1);
  t('-0.0004618114320999748548', '-0.0004618114320999748548227742586597847789768814695996979397676648662277615278571112727802', 22, 0);
  t('4397525934482', '4397525934482', 10, 0);
  t('-0.00080510769276', '-0.0008051076927558161863905844170590891349375387966097254255501665792278513428990177180729', 14, 1);
  t('-85.754361554275952592904696122168206579', '-85.754361554275952592904696122168206579375505261', 36, 2);
  t('-8969924824887750.078167576440491913960555993', '-8969924824887750.0781675764404919139605559934327012046423719029', 27, 2);
  t('83664.29974759139108443286033487', '83664.2997475913910844328603348762233403', 26, 0);
  t('4783482240722.889565506051950025731026748125580032', '4783482240722.88956550605195002573102674812558003270323257226548107196735812', 36, 0);
  t('0.08328506397736199', '0.08328506397736199281189505020297381756462266529288847578', 17, 2);
  t('6138685955473706895.27191846437634217823067', '6138685955473706895.271918464376342178230674192673963926883446477458738606505318684196487099828273', 23, 0);
  t('8676085578448129636.46125142815995954615633699159686307427564866280997975', '8676085578448129636.461251428159959546156336991596863074275648662809979754896', 53, 2);
  t('-5656502680950453.307129232', '-5656502680950453.3071292317099969560559506107', 9, 2);
  t('707.380045900803464776244462046183', '707.380045900803464776244462046182987', 31, 2);
  t('86863819.0795207560566246205038942404911', '86863819.07952075605662462050389424049106413333666160054769765', 31, 1);
  t('-0.00000690323521226292545282', '-0.0000069032352122629254528255683555238', 26, 0);
  t('-0.00864924723907831760464760343418947', '-0.00864924723907831760464760343418946520325901534', 35, 2);
  t('11960649002', '11960649002', 11, 0);
  t('-6502553383150595', '-6502553383150595', 18, 2);
  t('-679.96730494488662265292122816939430658266', '-679.96730494488662265292122816939430658266', 38, 2);
  t('-77589.796358', '-77589.7963584873098058997214465516938135824363', 6, 0);
  t('489167543699462369.29206154', '489167543699462369.2920615397068117518054274410906616895686747969646065180181122832961', 8, 1);
  t('1736062301921704.3544399700210783', '1736062301921704.354439970021078301187861306249924535576', 17, 1);
  t('2', '2', 2, 2);
  t('-346930759824.8932559917769593999', '-346930759824.893255991776959399952245588688', 19, 0);
  t('-7953667604', '-7953667604', 5, 0);
  t('-0.00068344382770949159674695980739380635445', '-0.0006834438277094915967469598073938063544463198925827927897963802449983538', 41, 1);
  t('-2372.6417339151826508053284670230939641484', '-2372.6417339151826508053284670230939641484398', 37, 0);
  t('-296495898199.58115237407948666112', '-296495898199.5811523740794866611232178652873298488744263', 20, 2);
  t('0', '0.0002', 0, 0);
  t('-4470337.856339789341346743328195402056', '-4470337.8563397893413467433281954020555766465023528610798962516623771308', 30, 1);
  t('-869559474794910580.4702422545', '-869559474794910580.470242254580425701508344203389450340088616045503344062196', 10, 0);
  t('-269860226.555168110686802', '-269860226.555168110686802406496811651255242690733933523277397815449890266344932488292555', 15, 2);
  t('-498.288', '-498.2877551595647284860735236925190739383420573843285964682707105606057458671350918750993', 3, 2);
  t('-58249061380532235.683643040770210682572744295', '-58249061380532235.68364304077021068257274429468', 27, 1);
  t('17790773861566.9127491793774523928', '17790773861566.9127491793774523927742086885', 19, 2);
  t('-0.000052578846594552360365003261412', '-0.00005257884659455236036500326141292751072228323274374276273184032573733734930586182920538869496014', 33, 0);
  t('-1848824671208162.036118636322531620559621761039257152', '-1848824671208162.0361186363225316205596217610392571519859349877420578173659325511361795', 36, 2);
  t('-8815.8895192223252405825465547234263054813143616472980391', '-8815.889519222325240582546554723426305481314361647298039143773292329917612441361288012832403085661674', 52, 1);
  t('-1.337926538823846889672640236908474426590700086', '-1.3379265388238468896726402369084744265907000856185156132950540139555844532982184035787153238', 45, 1);
  t('22265', '22265', 3, 1);
  t('44550253.862798116411937890173846464380254722540077', '44550253.862798116411937890173846464380254722540076612180961686217459396341111804577388882586249791', 42, 2);
  t('89983719097904808464', '89983719097904808464', 1, 1);
  t('-229500965923850.70051429223116003250968598721393599828363661825696333', '-229500965923850.700514292231160032509685987213935998283636618256963339786490679495749782904303115', 53, 0);
  t('0.00017652709951498133638383919005461463529305123', '0.000176527099514981336383839190054614635293051230467643495742837724131', 47, 0);
  t('-2410200702497', '-2410200702497', 11, 0);
  t('-0.00566575519125872879638699056271355696758097', '-0.00566575519125872879638699056271355696758097875409951260368210651006', 44, 0);
  t('1706349694.76350749557800040706127419362257045545428491995', '1706349694.763507495578000407061274193622570455454284919951774181697932220714269', 47, 1);
  t('5457344694848495013.70758306793373443062303840408774687096091471', '5457344694848495013.70758306793373443062303840408774687096091470997296538132975451', 45, 2);
  t('-0.519371276718530514624846800754582116141529266132757', '-0.5193712767185305146248468007545821161415292661327570320784267894852821486214528653', 51, 0);

  t(1, 1.23, u, u);
  t(-1, -1.23, u, u);
  t(568, '567.89', u, u);
  t(-568, -'567.89', u, u);
  t('12.35', '12.345', 2);
  t('12', '12.345', u);

  Big.DP = 20;
  Big.RM = 2;

  t(1, 1.23, u, u);
  t(-1, -1.23, u, u);
  t('4', 4.5, u, u);
  t('-4', -4.5, u, u);
  t(569, '568.9', u, u);
  t(-569, -'568.9', u, u);
  t('12.34', '12.345', 2);
  t('12', '12.345', u);
  t('12', '12.345', u, 2);

  t('3', '3', 0, 0);
  t('3.4157', '3.41571', 4, 0);
  t('77', '77.47', 0, 0);
  t('9424.512995', '9424.51299501636', 6, 0);
  t('-9.804e-7', '-0.000000980422875677', 10, 0);
  t('-2.3e-8', '-0.00000002396558486342', 9, 0);
  t('-147.5', '-147.548160', 1, 0);
  t('0', '-0.000000014550487', 3, 0);
  t('-12.9', '-12.9065548981629', 1, 0);
  t('2518', '2518.43', 0, 0);
  t('-315563065838', '-315563065838.04', 0, 0);
  t('-35054647', '-35054647.6002', 0, 0);
  t('0', '0', 0, 0);
  t('0', '-0.131', 0, 0);
  t('-13419', '-13419.8455', 0, 0);
  t('12225.2', '12225.2508', 1, 0);
  t('0', '0.27', 0, 0);
  t('10991.1', '10991.13', 1, 0);
  t('-10.699', '-10.69920', 3, 0);
  t('-0.00048', '-0.0004822436817', 5, 0);
  t('2.311e-7', '0.000000231184325036', 10, 0);
  t('7913863527', '7913863527.1310', 0, 0);
  t('1318352', '1318352.8', 0, 0);
  t('1', '1', 0, 0);
  t('9.6', '9.609231', 2, 0);
  t('2.9', '2.9928', 1, 0);
  t('0', '0.000000441533788150', 6, 0);
  t('-10.7', '-10.7716818', 1, 0);
  t('7', '7', 0, 0);
  t('-45', '-45.4372867804721', 0, 0);
  t('-3.6192', '-3.61925479396', 4, 0);
  t('-138', '-138.9', 0, 0);
  t('0', '0.0100244375', 0, 0);
  t('166.604', '166.6041518', 3, 0);
  t('-1', '-1.1', 0, 0);
  t('-1', '-1.7', 0, 0);
  t('13997', '13997.5175', 0, 0);
  t('-69', '-69.45', 0, 0);
  t('1124033.703', '1124033.703710', 3, 0);
  t('217.3', '217.352', 1, 0);
  t('483', '483.3', 0, 0);
  t('-25.976341', '-25.9763414', 6, 0);
  t('43.49', '43.4908', 2, 0);
  t('-1', '-1', 0, 0);
  t('46', '46.6', 0, 0);
  t('1.541e-7', '0.00000015411430', 10, 0);
  t('0', '-0.000000830', 0, 0);
  t('7584807.5', '7584807.572', 1, 0);
  t('6', '6', 0, 0);
  t('0', '0.0000000205720727244', 1, 0);
  t('-2.6400375', '-2.64003750311', 8, 0);
  t('10.3', '10.3965', 1, 0);
  t('0', '-0.000496334', 2, 0);
  t('1.1993', '1.19937', 4, 0);
  t('-2', '-2', 0, 0);
  t('-19', '-19.0046', 0, 0);
  t('0', '0.00048', 2, 0);
  t('-1264.5', '-1264.513', 1, 0);
  t('-0.00798172', '-0.0079817231887464', 8, 0);
  t('2145526645', '2145526645.44370', 0, 0);
  t('-3', '-3', 0, 0);
  t('1880207.8', '1880207.821', 1, 0);
  t('0.00006441', '0.0000644121908433204', 8, 0);
  t('314892', '314892.96976', 0, 0);
  t('0', '-0.0000004795062', 0, 0);
  t('1', '1.2', 0, 0);
  t('377.672', '377.672806', 3, 0);
  t('-7', '-7.71', 0, 0);
  t('-1', '-1.9453', 0, 0);
  t('0', '0.0000034', 5, 0);
  t('-1', '-1.644', 0, 0);
  t('-1.6170028', '-1.61700283891260', 7, 0);
  t('0', '0.000000011711069429347', 3, 0);
  t('-360982021', '-360982021.39', 0, 0);
  t('48339808025', '48339808025.72', 0, 0);
  t('868951121630', '868951121630.43', 0, 0);
  t('0', '-0.00043', 3, 0);
  t('-660368729645', '-660368729645.21', 0, 0);
  t('-10710785', '-10710785.3', 0, 0);
  t('0.1028356423', '0.102835642301091', 10, 0);
  t('-845886', '-845886.85353', 0, 0);
  t('-1015806.57278', '-1015806.5727870', 5, 0);
  t('711', '711.3', 0, 0);
  t('-355', '-355.7', 0, 0);
  t('-40333.1536731', '-40333.15367314', 7, 0);
  t('434.4804', '434.480478585', 4, 0);
  t('-25', '-25.2', 0, 0);
  t('-700838.64', '-700838.6401', 2, 0);
  t('1', '1.2', 0, 0);
  t('-125.8', '-125.8009', 1, 0);
  t('-1.042', '-1.042407797', 3, 0);
  t('-13.6', '-13.661', 1, 0);
  t('5295445267', '5295445267.58', 0, 0);
  t('0', '0.0000022009534937', 2, 0);
  t('1.781', '1.7816', 3, 0);
  t('2', '2', 0, 0);
  t('-193.14', '-193.14012581600', 3, 0);
  t('-5.9', '-5.9171262', 1, 0);
  t('0.01', '0.010072549149960', 4, 0);
  t('-2855964', '-2855964.070', 1, 0);
  t('1549.1', '1549.125', 1, 0);
  t('-132632', '-132632.83', 0, 0);
  t('-0.000803', '-0.0008038171535511', 6, 0);
  t('-5.648e-7', '-0.00000056485800370', 10, 0);
  t('0', '-0.048', 0, 0);
  t('-1218896175', '-1218896175.20', 0, 0);
  t('2', '2.24', 0, 0);
  t('-57786', '-57786.167707791', 0, 0);
  t('87743', '87743.9', 0, 0);
  t('0', '0.0016299', 0, 0);
  t('-0.00008767', '-0.00008767694', 8, 0);
  t('-74839', '-74839.9', 0, 0);
  t('-138.3197', '-138.319719351192', 4, 0);
  t('-20.4', '-20.48512', 1, 0);
  t('0', '-0.0001075340957445', 1, 0);
  t('-0.2', '-0.28402', 1, 0);
  t('-349', '-349.5791', 0, 0);
  t('8433', '8433.11', 0, 0);
  t('55.8', '55.817', 1, 0);
  t('-23.4', '-23.44711', 1, 0);
  t('-8', '-8.96086822', 0, 0);
  t('106.692', '106.6928125', 3, 0);
  t('9627', '9627.565267', 0, 0);
  t('335561404', '335561404.9395', 0, 0);
  t('-72.83', '-72.83489272', 2, 0);
  t('8380.8168', '8380.816861', 4, 0);
  t('23842617274', '23842617274.4', 0, 0);
  t('40148.6', '40148.634', 1, 0);
  t('0', '-0.1255758162297', 0, 0);
  t('780381160', '780381160.80', 0, 0);
  t('-42122.9929627', '-42122.992962748', 7, 0);
  t('5.94', '5.9443', 2, 0);
  t('-49569', '-49569.4921442', 0, 0);
  t('-14348604230', '-14348604230.8', 0, 0);
  t('-0.0075', '-0.0075419045288', 4, 0);
  t('1614572.14', '1614572.140804', 3, 0);
  t('-573', '-573.60', 0, 0);
  t('-56.77', '-56.779037760684', 2, 0);
  t('0', '-0.0000000487660', 2, 0);
  t('-7727', '-7727.7', 0, 0);
  t('-0.00082', '-0.000828380', 5, 0);
  t('-175.7', '-175.7979133887', 1, 0);
  t('0', '-0.000000012336338193', 0, 0);
  t('-31', '-31.6', 0, 0);
  t('-1.5992', '-1.59927551', 4, 0);
  t('-1877909543422', '-1877909543422.67', 0, 0);
  t('-42164', '-42164.0870', 1, 0);
  t('-87.9', '-87.94336', 1, 0);
  t('0', '0.0000000173460424291', 0, 0);
  t('42429150137495', '42429150137495.0', 0, 0);
  t('37498693', '37498693.83', 0, 0);
  t('-4659', '-4659.2', 0, 0);
  t('3', '3', 0, 0);
  t('727082', '727082.1', 0, 0);
  t('0.0000015', '0.000001541114108773', 7, 0);
  t('4.26', '4.2647805637288', 2, 0);
  t('-16891181', '-16891181.93', 0, 0);
  t('9.182898', '9.18289830', 6, 0);
  t('119.6', '119.6950', 1, 0);
  t('-0.068369', '-0.0683696097', 6, 0);
  t('-38', '-38.7', 0, 0);
  t('-904.78062', '-904.78062404', 5, 0);
  t('0', '-0.000011', 1, 0);
  t('0', '-0.0000112382500844484', 1, 0);
  t('-54916112.1', '-54916112.174', 1, 0);
  t('-1328966', '-1328966.8', 0, 0);
  t('-1.2897361368', '-1.28973613685897', 10, 0);
  t('6', '6', 0, 0);
  t('49463742', '49463742.197', 0, 0);
  t('-26556652', '-26556652.7', 0, 0);
  t('-5', '-5', 0, 0);
  t('120362', '120362.044', 0, 0);
  t('7.52869', '7.528690875', 5, 0);
  t('-545.557951', '-545.5579519426', 6, 0);
  t('-87.84160902281', '-87.841609022811', 11, 0);
  t('0', '-0.00000746', 3, 0);
  t('0.0001', '0.00010074610', 6, 0);
  t('282', '282.725', 0, 0);
  t('-6.53', '-6.5375', 2, 0);
  t('-1.0091e-7', '-0.000000100912', 11, 0);
  t('2058817', '2058817.13', 0, 0);
  t('0', '-0.000232325894', 3, 0);
  t('0', '0.000036396', 1, 0);
  t('1', '1.7', 0, 0);
  t('1', '1.2', 0, 0);
  t('91.17', '91.1758', 2, 0);
  t('4284.594', '4284.5945725385', 3, 0);
  t('19.361', '19.3617694197238', 3, 0);
  t('-241543229', '-241543229.419', 0, 0);
  t('0', '0.0000010', 2, 0);
  t('-9.1e-7', '-0.00000091165421', 8, 0);
  t('2332', '2332.5022', 0, 0);
  t('0', '-0.0000000668925289', 3, 0);
  t('7466.5', '7466.560', 1, 0);
  t('1', '1.94', 0, 0);
  t('-0.000031', '-0.00003140689353', 6, 0);
  t('-219', '-219.6', 0, 0);
  t('696971', '696971.4910', 0, 0);
  t('0', '0.0000000120460503155595', 3, 0);
  t('-0.0906', '-0.090693', 4, 0);
  t('-3.087814', '-3.08781449', 6, 0);
  t('1', '1', 0, 0);
  t('-7', '-7', 0, 0);
  t('0', '0.0000031618658712', 3, 0);
  t('0.00097461', '0.0009746146031569', 8, 0);
  t('-9', '-9', 1, 0);
  t('-18.96460027725', '-18.964600277252', 11, 0);
  t('0', '-0.1946', 0, 0);
  t('-382004141344', '-382004141344.6', 0, 0);
  t('-33', '-33.067865207540', 1, 0);
  t('3', '3.5', 0, 0);
  t('0', '-0.000000152493329', 5, 0);
  t('6', '6', 0, 0);
  t('-136420', '-136420.235', 0, 0);
  t('0', '-0.063190393', 0, 0);
  t('-136', '-136.19', 0, 0);
  t('0', '-0.0000010895573842', 5, 0);
  t('0.000009155', '0.000009155983308330', 9, 0);
  t('218.73110807', '218.7311080731', 8, 0);
  t('-9', '-9.8', 0, 0);
  t('-12150204207146', '-12150204207146.8', 0, 0);
  t('32687681', '32687681.4', 0, 0);
  t('0', '0.000002318138842', 0, 0);
  t('-194994.799527', '-194994.7995270', 6, 0);
  t('-6400.47', '-6400.4797836', 2, 0);
  t('-3', '-3.1', 0, 0);
  t('3604', '3604.033', 1, 0);
  t('6179882.66', '6179882.66353438', 2, 0);
  t('-1', '-1.1', 0, 0);
  t('-3353188', '-3353188.754831', 0, 0);
  t('-3479.8', '-3479.814763641', 1, 0);
  t('193837916.51', '193837916.51059', 3, 0);
  t('925910.2', '925910.2254', 1, 0);
  t('-3', '-3.1', 0, 0);
  t('-45923605', '-45923605.3', 0, 0);
  t('-5739640408', '-5739640408.61', 0, 0);
  t('0', '0.000000026702', 2, 0);
  t('2263', '2263.2278', 0, 0);
  t('-1.26098', '-1.26098908270364', 5, 0);
  t('-6349.354', '-6349.35474', 3, 0);
  t('458189.4', '458189.4043', 1, 0);
  t('8', '8.17298', 0, 0);
  t('1', '1', 0, 0);
  t('0', '0.000211155', 1, 0);
  t('-7.3837356', '-7.383735616214', 7, 0);
  t('-0.6559159', '-0.65591593', 7, 0);
  t('25479402895651', '25479402895651.0', 0, 0);
  t('59.53', '59.5333', 2, 0);
  t('384', '384.6', 0, 0);
  t('-3', '-3', 0, 0);
  t('-1', '-1.2', 0, 0);
  t('-31622181', '-31622181.760', 0, 0);
  t('66.10928637', '66.109286376', 8, 0);
  t('9', '9', 0, 0);
  t('-5', '-5.6', 0, 0);
  t('50', '50.33', 0, 0);
  t('-1', '-1.6874', 0, 0);
  t('-2893.77715', '-2893.7771581', 5, 0);
  t('-36585.1', '-36585.1493766222', 1, 0);
  t('23', '23.0320', 1, 0);
  t('-1', '-1.51744523757', 0, 0);
  t('0.112', '0.112042321', 3, 0);
  t('-3965526', '-3965526.33', 0, 0);
  t('0.039', '0.039883413', 3, 0);
  t('-5985', '-5985.5', 0, 0);
  t('-11128639', '-11128639.5', 0, 0);
  t('-21', '-21.2', 0, 0);
  t('0', '-0.157', 0, 0);
  t('287', '287.1', 0, 0);
  t('-11166.2403', '-11166.24038274', 4, 0);
  t('-0.6', '-0.6672197920040', 1, 0);
  t('11642.4966', '11642.496644822', 4, 0);
  t('-3', '-3', 0, 0);
  t('0', '0.000000040144735', 6, 0);
  t('-380.9', '-380.9234', 1, 0);
  t('0', '0.310292869', 0, 0);
  t('-1626.45', '-1626.4574', 2, 0);
  t('34109264', '34109264.610', 0, 0);
  t('-18.6803', '-18.68030', 4, 0);
  t('39743', '39743.1221508', 0, 0);
  t('13.1', '13.198', 1, 0);
  t('34.193151', '34.1931518121594', 6, 0);
  t('-1.5197', '-1.519726', 4, 0);
  t('-905422', '-905422.3', 0, 0);
  t('-70.05747', '-70.0574738', 5, 0);
  t('-11396.553', '-11396.55311402', 3, 0);
  t('-18', '-18.1', 0, 0);
  t('-35786612404273', '-35786612404273.4', 0, 0);
  t('-0.0697', '-0.069781754', 4, 0);
  t('0', '0.407', 0, 0);
  t('25112.523', '25112.5230201', 4, 0);
  t('0', '0.0000006117065780539', 0, 0);
  t('4', '4', 0, 0);
  t('-0.3', '-0.30492201', 2, 0);
  t('3740', '3740.7', 0, 0);
  t('17260922.317', '17260922.31728', 3, 0);
  t('0', '0.0000057926177', 4, 0);
  t('-1', '-1.23', 0, 0);
  t('-315.21', '-315.216212550992', 2, 0);
  t('1059567.1', '1059567.1851551', 1, 0);
  t('11183622.74', '11183622.741', 2, 0);
  t('33460011.925', '33460011.92578', 3, 0);
  t('4.26516', '4.26516757341024', 5, 0);
  t('-1', '-1.19', 0, 0);
  t('633931143962', '633931143962.5', 0, 0);
  t('6.262', '6.2624', 3, 0);
  t('-203.8', '-203.80', 1, 0);
  t('-85', '-85.4', 0, 0);
  t('0.000001', '0.000001207624055558', 6, 0);
  t('-0.000019', '-0.000019202077603', 6, 0);
  t('0.0009', '0.0009133094523911', 4, 0);
  t('945051319576', '945051319576.58', 0, 0);
  t('-70953', '-70953.5', 0, 0);
  t('-0.000002', '-0.0000020685433866', 6, 0);
  t('-207', '-207.7', 0, 0);
  t('-490', '-490.444', 0, 0);
  t('-5.37', '-5.3771', 2, 0);
  t('83', '83.7', 0, 0);
  t('366796807.5', '366796807.5574', 1, 0);
  t('1745848', '1745848.08', 0, 0);
  t('1', '1.0', 0, 0);
  t('-1', '-1.5', 0, 0);
  t('5', '5.14', 0, 0);
  t('0', '0.00003456', 0, 0);
  t('-8.1477', '-8.147743719852', 4, 0);
  t('-4910173945.9', '-4910173945.90609', 2, 0);
  t('0', '0.000000022285849598', 0, 0);
  t('3.33465', '3.3346587411', 5, 0);
  t('0', '-0.00000729', 0, 0);
  t('-6522.4', '-6522.434', 1, 0);
  t('259', '259.537', 0, 0);
  t('0', '-0.00104081043935', 2, 0);
  t('3', '3', 0, 0);
  t('-1', '-1', 1, 0);
  t('-1864926.52', '-1864926.5206', 2, 0);
  t('-71542', '-71542.7', 0, 0);
  t('2', '2', 0, 0);
  t('40.4', '40.490', 1, 0);
  t('-164258071856', '-164258071856.43', 0, 0);
  t('-2231171.7782484', '-2231171.77824847', 7, 0);
  t('0.00006946', '0.0000694635799508', 8, 0);
  t('2188795845.6', '2188795845.680', 1, 0);
  t('-21', '-21.1', 0, 0);
  t('0', '-0.000000031', 0, 0);
  t('-3', '-3', 0, 0);
  t('-1526', '-1526.888', 0, 0);
  t('-438', '-438.2', 0, 0);
  t('-3', '-3', 0, 0);
  t('-6814824', '-6814824.25', 0, 0);
  t('-2', '-2', 0, 0);
  t('98991.3', '98991.3556836', 1, 0);
  t('5312169', '5312169.9', 0, 0);
  t('-42854', '-42854.6', 0, 0);
  t('-27.6572', '-27.6572288157', 4, 0);
  t('9', '9.6002813627', 0, 0);
  t('0', '-0.029', 1, 0);
  t('-526534', '-526534.4', 0, 0);
  t('-7.5', '-7.5124', 1, 0);
  t('-108923', '-108923.1', 0, 0);
  t('-9', '-9.4', 0, 0);
  t('-850.5', '-850.55888926', 1, 0);
  t('20.2', '20.2030258520', 2, 0);
  t('-0.609870723', '-0.6098707231015', 9, 0);
  t('5281.09', '5281.0906', 3, 0);
  t('-3.7e-8', '-0.000000037004277253', 9, 0);
  t('-0.0000488', '-0.0000488028554633245', 7, 0);
  t('0.02366303', '0.0236630365418', 8, 0);
  t('1', '1.63', 0, 0);
  t('-0.0005', '-0.00053', 4, 0);
  t('42406.41', '42406.4173728213', 2, 0);
  t('-1234.07', '-1234.0784', 2, 0);
  t('-3e-7', '-0.0000003154', 7, 0);
  t('-0.0081739', '-0.00817397896', 7, 0);
  t('173650', '173650.451', 0, 0);
  t('11284.3', '11284.397', 1, 0);
  t('-6', '-6', 0, 0);
  t('-6893', '-6893.8', 0, 0);
  t('99.17', '99.1724', 2, 0);
  t('39', '39.13', 0, 0);
  t('16564.38', '16564.38086', 3, 0);
  t('-191.419', '-191.419531187', 3, 0);
  t('-7', '-7', 0, 0);
  t('84298765.75', '84298765.7508', 3, 0);
  t('-145830', '-145830.71251', 0, 0);
  t('-234182173', '-234182173.87', 0, 0);
  t('0', '-0.00000001345158437', 1, 0);
  t('2552530.18', '2552530.1811', 2, 0);
  t('0.001367', '0.001367230074', 6, 0);
  t('572.04343', '572.04343606', 5, 0);
  t('-1487814', '-1487814.67', 0, 0);
  t('2678', '2678.096391', 0, 0);
  t('-2', '-2', 1, 0);
  t('0', '-0.0000055', 4, 0);
  t('0', '0.0001067796289669', 0, 0);
  t('1393884', '1393884.74335020', 0, 0);
  t('-2', '-2', 0, 0);
  t('-10861102', '-10861102.43', 0, 0);
  t('-336423.21', '-336423.21318', 2, 0);
  t('0.0000021066', '0.00000210660015078679', 11, 0);
  t('39358671', '39358671.66589', 0, 0);
  t('0', '-0.0000604438109', 2, 0);
  t('28', '28.8', 0, 0);
  t('0.0002', '0.0002127', 4, 0);
  t('5', '5.27', 0, 0);
  t('2e-8', '0.0000000223520836', 8, 0);
  t('1.2952', '1.2952068', 5, 0);
  t('-0.0009', '-0.000977833', 4, 0);
  t('4', '4', 0, 0);
  t('422856110415', '422856110415.57', 0, 0);
  t('-21279632', '-21279632.42', 0, 0);
  t('8310941', '8310941.9', 0, 0);
  t('6138183175.8', '6138183175.801', 1, 0);
  t('-1', '-1.0', 0, 0);
  t('-92', '-92.4', 0, 0);
  t('1', '1', 0, 0);
  t('0', '-0.00005520', 2, 0);
  t('1400', '1400.4268', 0, 0);
  t('-7.6', '-7.6365', 1, 0);
  t('11734', '11734.29825972', 0, 0);
  t('-47.52771384', '-47.5277138495', 8, 0);
  t('58073.135', '58073.13547', 3, 0);
  t('183.515939', '183.51593967261', 6, 0);
  t('-441.16', '-441.162', 2, 0);
  t('-7', '-7.36', 0, 0);
  t('70.05777541765', '70.0577754176541', 11, 0);
  t('-94', '-94.193', 0, 0);
  t('16035311', '16035311.3', 0, 0);
  t('0', '0.0083246640962823', 0, 0);
  t('1', '1.023', 1, 0);
  t('0', '0.000038668455', 0, 0);
  t('0', '0.06305', 0, 0);
  t('-136906.5153', '-136906.515355622', 4, 0);
  t('-43.96', '-43.9649', 2, 0);
  t('0', '-0.00001820', 3, 0);
  t('-9', '-9.3013', 0, 0);
  t('244', '244.60011', 0, 0);
  t('85.0993', '85.099344', 4, 0);
  t('-0.27', '-0.27837505453', 2, 0);
  t('175189.6', '175189.643', 1, 0);
  t('-328814818618', '-328814818618.75', 0, 0);
  t('-4.4748e-7', '-0.000000447487436', 11, 0);
  t('-2', '-2.04', 0, 0);
  t('-0.089', '-0.08939251022342', 3, 0);
  t('0', '-0.000000010877355', 5, 0);
  t('53321.87', '53321.8748', 2, 0);
  t('1915', '1915.79', 0, 0);
  t('-367.5', '-367.578', 1, 0);
  t('-21.9', '-21.9540', 1, 0);
  t('-39.1', '-39.14059', 1, 0);
  t('-1.6', '-1.60601', 1, 0);
  t('6', '6.8', 0, 0);
  t('-1.2885', '-1.28850179741370', 4, 0);
  t('-1', '-1.55455', 0, 0);
  t('-221', '-221.13', 0, 0);
  t('0', '0.000012022217901638', 2, 0);
  t('0', '0.000639079', 2, 0);
  t('1.84', '1.846583441436', 2, 0);
  t('12071.250496', '12071.2504963', 6, 0);
  t('-3675', '-3675.926242', 0, 0);
  t('-315374', '-315374.067', 0, 0);
  t('7', '7.91', 0, 0);
  t('-0.0027114', '-0.00271140536474855', 8, 0);
  t('-24', '-24.7', 0, 0);
  t('0', '0.00000414', 5, 0);
  t('37689482.631', '37689482.631724', 3, 0);
  t('1621038532', '1621038532.13', 0, 0);
  t('-7000312.14286', '-7000312.1428635', 5, 0);
  t('0.0001366067', '0.0001366067359067', 10, 0);
  t('356688.7', '356688.768', 1, 0);
  t('-429630451056', '-429630451056.17', 0, 0);
  t('0.001', '0.001706', 3, 0);
  t('-0.15', '-0.15115309937', 2, 0);
  t('0', '-0.00000426741761569024', 5, 0);
  t('-361', '-361.8735', 0, 0);
  t('34.463', '34.46316', 3, 0);
  t('2773', '2773.052', 1, 0);
  t('-48.8555', '-48.8555860944', 4, 0);
  t('-401.15381', '-401.15381004', 7, 0);
  t('15080', '15080.56474400', 0, 0);
  t('739', '739.712017', 0, 0);
  t('17394829', '17394829.4', 0, 0);
  t('-94603484573', '-94603484573.572', 0, 0);
  t('88.287', '88.28799', 3, 0);
  t('-3', '-3.9', 0, 0);
  t('0.028002559', '0.028002559141', 9, 0);
  t('0.0003965772', '0.000396577277638737', 10, 0);
  t('6', '6.1', 0, 0);
  t('-343.35771428', '-343.35771428919', 8, 0);
  t('-3.6', '-3.6321', 1, 0);
  t('272406.4320645', '272406.43206452', 7, 0);
  t('0', '-0.0022548', 0, 0);
  t('-0.001', '-0.0013211', 3, 0);
  t('5.6', '5.6424', 1, 0);
  t('-4856.3', '-4856.365', 1, 0);
  t('8983241577', '8983241577.46', 0, 0);
  t('-104785798641', '-104785798641.1979', 0, 0);
  t('-25.3', '-25.36896', 1, 0);
  t('0', '0.0000000439950662012', 0, 0);
  t('-4449540', '-4449540.86', 0, 0);
  t('-474.7142', '-474.7142522663', 4, 0);
  t('-1.31', '-1.319', 2, 0);
  t('1', '1.0886', 0, 0);
  t('-7', '-7', 0, 0);
  t('-0.0001', '-0.0001727480', 4, 0);
  t('573.868', '573.86843', 3, 0);
  t('0', '-0.00095', 0, 0);
  t('344', '344.2', 0, 0);
  t('-2334602', '-2334602.418', 0, 0);
  t('3', '3', 0, 0);
  t('11831576861.1', '11831576861.108', 1, 0);
  t('-5', '-5.84', 0, 0);
  t('0', '-0.0000516463227954072', 4, 0);
  t('-1871009.24048', '-1871009.240482', 5, 0);
  t('-14', '-14.5', 0, 0);
  t('-21773807.1', '-21773807.116', 1, 0);
  t('-13990', '-13990.320', 0, 0);
  t('-9', '-9.741', 0, 0);
  t('0', '0.00000270', 5, 0);
  t('8.4e-7', '0.0000008440', 8, 0);
  t('-324.951', '-324.9513563376', 3, 0);
  t('0', '-0.0017455758', 2, 0);
  t('-4.7', '-4.70677', 1, 0);
  t('-4000702.65', '-4000702.6580', 2, 0);
  t('0', '0.046250560170087', 0, 0);
  t('0', '0.000901', 3, 0);
  t('21173148', '21173148.59', 0, 0);
  t('0', '0.0000001917443', 2, 0);
  t('22', '22.170', 0, 0);
  t('-264', '-264.40', 0, 0);
  t('-2313.4', '-2313.478', 1, 0);
  t('1.3', '1.375', 1, 0);
  t('192.6523', '192.6523354', 4, 0);
  t('-6', '-6.2', 0, 0);
  t('-20007999756', '-20007999756.5', 0, 0);
  t('23', '23.0', 0, 0);
  t('-67156.4', '-67156.46', 1, 0);
  t('0', '0.00080', 1, 0);
  t('-1241843.08', '-1241843.08419', 2, 0);
  t('16', '16.9', 0, 0);
  t('-13574.183', '-13574.183482', 3, 0);
  t('85.5', '85.5844524', 1, 0);
  t('326691', '326691.689', 0, 0);
  t('-3.61', '-3.6129', 2, 0);
  t('-5832697.9', '-5832697.901', 1, 0);
  t('-86.6', '-86.611', 1, 0);
  t('17211', '17211.120849', 0, 0);
  t('-6', '-6.3', 0, 0);
  t('0', '0.00603649', 0, 0);
  t('-0.8', '-0.859', 1, 0);
  t('1', '1', 0, 0);
  t('-72262215.33', '-72262215.33059', 2, 0);
  t('30151422', '30151422.2379', 0, 0);
  t('0', '0.0000041944073', 4, 0);
  t('-6', '-6.686', 0, 0);
  t('3841', '3841.462', 0, 0);
  t('3', '3', 0, 0);
  t('0', '-0.000000434373861681637', 3, 0);
  t('0.19151782', '0.191517823', 8, 0);
  t('3', '3.0622069618', 1, 0);
  t('-1103792', '-1103792.3', 0, 0);
  t('2600', '2600.0', 0, 0);
  t('-0.049', '-0.049027', 4, 0);
  t('245', '245.2', 0, 0);
  t('17', '17.9', 0, 0);
  t('-5', '-5', 1, 0);
  t('9', '9.1', 0, 0);
  t('-5.426', '-5.4267', 3, 0);
  t('-7', '-7.12', 0, 0);
  t('6469941', '6469941.9', 0, 0);
  t('0', '0.00001772', 3, 0);
  t('373', '373.7', 0, 0);
  t('90.9', '90.9725', 1, 0);
  t('0.00002706', '0.000027066060090', 8, 0);
  t('0', '0.51', 0, 0);
  t('-26', '-26.753', 0, 0);
  t('38', '38.0927444', 0, 0);
  t('-28.4', '-28.4389641946', 1, 0);
  t('-363', '-363.9', 0, 0);
  t('-1195', '-1195.7', 0, 0);
  t('3.11198', '3.1119880455', 5, 0);
  t('0', '0.045227', 0, 0);
  t('-1316140051.5', '-1316140051.579', 1, 0);
  t('-4', '-4.118', 0, 0);
  t('-3936947210', '-3936947210.85', 0, 0);
  t('110.6003', '110.600335', 4, 0);
  t('-6', '-6.0', 0, 0);
  t('90893484.6', '90893484.650', 1, 0);
  t('-0.7006', '-0.7006145', 4, 0);
  t('-0.00001', '-0.000019936362507165', 5, 0);
  t('24678137835.9', '24678137835.942', 1, 0);
  t('-0.00000971', '-0.00000971086828641997', 8, 0);
  t('0', '0.0000000580238', 2, 0);
  t('11528102.7726', '11528102.7726523', 4, 0);
  t('-2.68486159', '-2.6848615902383', 8, 0);
  t('1161', '1161.7', 0, 0);
  t('-5', '-5.567', 0, 0);
  t('10144443712', '10144443712.86', 0, 0);
  t('-2', '-2', 1, 0);
  t('9', '9', 0, 0);
  t('6.2889e-7', '0.0000006288925870', 11, 0);
  t('876.4', '876.468063', 1, 0);
  t('105.9', '105.91973', 1, 0);
  t('0', '0.0000010125974', 2, 0);
  t('2.0842154', '2.08421540', 7, 0);
  t('-4649.5', '-4649.5866', 1, 0);
  t('0.11245', '0.112457886', 5, 0);
  t('-7', '-7.1', 0, 0);
  t('-625.285', '-625.28564498', 3, 0);
  t('-7475217', '-7475217.036', 1, 0);
  t('-1.603017', '-1.60301705792', 7, 0);
  t('-869155972', '-869155972.30', 0, 0);
  t('-39', '-39.004217187', 2, 0);
  t('-1772', '-1772.7', 0, 0);
  t('3', '3.0', 0, 0);
  t('-7809', '-7809.1', 0, 0);
  t('112', '112.98', 0, 0);
  t('306940', '306940.42', 0, 0);
  t('200', '200.113', 0, 0);
  t('0', '-0.000000062530377194', 6, 0);
  t('-17.011295', '-17.011295361', 6, 0);
  t('110.184', '110.18489', 3, 0);
  t('5', '5', 0, 0);
  t('1.4e-8', '0.00000001445074049593', 9, 0);
  t('-1.215', '-1.2157723', 3, 0);
  t('1732583495.3', '1732583495.304', 1, 0);
  t('124948994003', '124948994003.9', 0, 0);
  t('3', '3', 0, 0);
  t('0', '-0.000000137314187', 4, 0);
  t('13413', '13413.019', 1, 0);
  t('0', '-0.17318', 0, 0);
  t('15387866568', '15387866568.3', 0, 0);
  t('-1', '-1', 0, 0);
  t('-13', '-13.94', 0, 0);
  t('7291', '7291.102', 0, 0);
  t('-57.8613', '-57.86131', 4, 0);
  t('43386097920', '43386097920.70', 0, 0);
  t('-0.000128966', '-0.00012896634', 9, 0);
  t('-232', '-232.969', 0, 0);
  t('-42', '-42.79069937124', 0, 0);
  t('3.6248', '3.62487029', 4, 0);
  t('-1', '-1', 0, 0);
  t('0', '0.000000013', 6, 0);
  t('15', '15.43478642', 0, 0);
  t('350', '350.6', 0, 0);
  t('77697915082828', '77697915082828.5', 0, 0);
  t('7338', '7338.3', 0, 0);
  t('-51.9775', '-51.977502', 5, 0);
  t('95', '95.9', 0, 0);
  t('1', '1', 0, 0);
  t('-8', '-8.9', 0, 0);
  t('8284.591', '8284.5917750894', 3, 0);
  t('-1e-7', '-0.0000001088', 7, 0);
  t('-33376.998', '-33376.99830385', 3, 0);
  t('0.03', '0.0382307', 2, 0);
  t('-48.7', '-48.709', 1, 0);
  t('2.6168481', '2.6168481042', 8, 0);
  t('-5.483812', '-5.4838122', 6, 0);
  t('2.646923529', '2.64692352926013', 9, 0);
  t('-26257', '-26257.7041', 0, 0);
  t('-49641.7', '-49641.7149', 1, 0);
  t('-462589', '-462589.0', 0, 0);
  t('461214', '461214.3649', 0, 0);
  t('129386821301', '129386821301.98', 0, 0);
  t('3', '3.2905', 0, 0);
  t('1', '1.4', 0, 0);
  t('0', '-0.000000227515922', 2, 0);
  t('3588.6381', '3588.63817', 4, 0);
  t('3.53', '3.53466566', 2, 0);
  t('-6660.35', '-6660.35924', 2, 0);
  t('0', '0.0000066060550015', 3, 0);
  t('156637133.3', '156637133.39', 1, 0);
  t('5', '5.108', 0, 0);
  t('168508', '168508.1', 0, 0);
  t('-10', '-10.33499', 0, 0);
  t('0', '0.000000067600476724650', 1, 0);
  t('-22.83', '-22.83845', 2, 0);
  t('-20706434', '-20706434.27', 0, 0);
  t('0', '0.00024671', 2, 0);
  t('-1769955.74', '-1769955.746', 2, 0);
  t('9', '9.25', 0, 0);
  t('-64310286654', '-64310286654.707', 0, 0);
  t('-5.818273127', '-5.8182731277099', 9, 0);
  t('8.4', '8.4839', 1, 0);
  t('-289049', '-289049.8667', 0, 0);
  t('-8.87381741', '-8.8738174166', 8, 0);
  t('61078769295.7', '61078769295.796', 1, 0);
  t('-2142', '-2142.2491090', 0, 0);
  t('-24', '-24.0', 0, 0);
  t('-28450.7746', '-28450.77469', 4, 0);
  t('-8', '-8.9', 0, 0);
  t('0', '0.0000000264301164105', 7, 0);
  t('-4181.599211', '-4181.599211051', 7, 0);
  t('0', '-0.000199', 1, 0);
  t('-10590.48', '-10590.4897', 2, 0);
  t('-135.7703', '-135.770329', 4, 0);
  t('0', '-0.000017071302239222', 2, 0);
  t('4096.2', '4096.273925994', 1, 0);
  t('-1e-8', '-0.00000001831', 8, 0);
  t('-1', '-1.8', 0, 0);
  t('59.323301', '59.323301609', 6, 0);
  t('10785.986', '10785.98636097841', 3, 0);
  t('1', '1.3', 0, 0);
  t('-7.332', '-7.3327', 3, 0);
  t('-37', '-37.8', 0, 0);
  t('275519', '275519.8', 0, 0);
  t('47451699221', '47451699221.7', 0, 0);
  t('0', '0.00000416770', 1, 0);
  t('-0.0343498646', '-0.03434986461', 10, 0);
  t('4242324543.46', '4242324543.469', 2, 0);
  t('-1', '-1', 0, 0);
  t('52.42', '52.4272395', 2, 0);
  t('98579756', '98579756.6', 0, 0);
  t('0.0033455329', '0.003345532903918', 10, 0);
  t('38006', '38006.2595', 0, 0);
  t('-5827979902', '-5827979902.5', 0, 0);
  t('1027679', '1027679.04', 0, 0);
  t('0', '-0.0000001128226980', 1, 0);
  t('-0.0355', '-0.0355964995', 4, 0);
  t('0', '0.00028', 2, 0);
  t('-5.2271551934', '-5.22715519347', 10, 0);
  t('-7.2886723', '-7.288672381', 7, 0);
  t('135123420', '135123420.26', 0, 0);
  t('-43551.8', '-43551.8035464', 2, 0);
  t('-1.52', '-1.5240', 2, 0);
  t('-9', '-9', 0, 0);
  t('0', '-0.422', 0, 0);
  t('-8.3', '-8.357', 1, 0);
  t('0.0000036043', '0.000003604354139', 10, 0);
  t('0.0000242', '0.0000242502776', 7, 0);
  t('-601701.23461', '-601701.234613771', 5, 0);
  t('-3', '-3', 0, 0);
  t('0', '-0.1888421', 0, 0);
  t('-7.4024', '-7.4024326123759', 4, 0);
  t('1', '1', 0, 0);
  t('-77', '-77.0', 0, 0);
  t('2', '2', 0, 0);
  t('173.826146', '173.826146902372', 6, 0);
  t('41628873412', '41628873412.7', 0, 0);
  t('-7.6898808', '-7.689880862', 7, 0);
  t('7', '7', 0, 0);
  t('0', '-0.105', 0, 0);
  t('42148790855.26', '42148790855.2676', 2, 0);
  t('-6032.8', '-6032.806', 1, 0);
  t('1', '1.1', 0, 0);
  t('0.279', '0.279143546', 3, 0);
  t('-0.00020291', '-0.0002029105398', 9, 0);
  t('-58.3168385', '-58.3168385103573', 7, 0);
  t('1200671047233', '1200671047233.0', 0, 0);
  t('5', '5', 0, 0);
  t('-2', '-2.1', 0, 0);
  t('-8026', '-8026.55', 0, 0);
  t('3557', '3557.9', 0, 0);
  t('-4172', '-4172.11', 0, 0);
  t('-434443.5', '-434443.55842219', 1, 0);
  t('-79649', '-79649.589', 0, 0);
  t('-683356', '-683356.704', 0, 0);
  t('-23157.94', '-23157.9414070', 2, 0);
  t('-834275304.9697', '-834275304.969786', 4, 0);
  t('0.00021394028', '0.000213940281027423', 11, 0);
  t('207220', '207220.6', 0, 0);
  t('0', '0.00000027328846590', 3, 0);
  t('-181', '-181.7', 0, 0);
  t('993', '993.47', 0, 0);
  t('0.0000183', '0.00001831903', 7, 0);
  t('-2165', '-2165.914422617', 0, 0);
  t('7158', '7158.6', 0, 0);
  t('0.000004399', '0.000004399592', 9, 0);
  t('-448.1549', '-448.154990', 4, 0);
  t('8', '8.31', 0, 0);
  t('-4646.3', '-4646.366', 1, 0);
  t('-374405891.742', '-374405891.74227', 3, 0);
  t('-18858640.775', '-18858640.7752', 3, 0);
  t('-5.944e-7', '-0.0000005944823366829', 10, 0);
  t('-3763100.1', '-3763100.173', 1, 0);
  t('0', '-0.00009409', 1, 0);
  t('-1465712045100', '-1465712045100.7', 0, 0);
  t('77.9', '77.9005', 2, 0);
  t('-582373.3', '-582373.36', 1, 0);
  t('0.00101946', '0.0010194644198', 8, 0);
  t('-1990653061', '-1990653061.0972', 1, 0);
  t('3', '3.462697', 0, 0);
  t('1.957', '1.95785', 3, 0);
  t('2420754', '2420754.52', 0, 0);
  t('-0.0006430603', '-0.00064306030', 10, 0);
  t('22411582.12', '22411582.1255', 2, 0);
  t('74677097.7', '74677097.718049', 1, 0);
  t('-1', '-1.9', 0, 0);
  t('-4228070', '-4228070.3279', 0, 0);
  t('-46.3', '-46.3717', 1, 0);
  t('-3', '-3', 0, 0);
  t('0', '0.00012', 2, 0);
  t('-0.04332484', '-0.043324844640', 8, 0);
  t('1', '1', 0, 0);
  t('0', '-0.21', 0, 0);
  t('0.0008', '0.0008813', 4, 0);
  t('0', '-0.000003211579', 5, 0);
  t('1555', '1555.7', 0, 0);
  t('2', '2', 0, 0);
  t('-14', '-14.7', 0, 0);
  t('1.2', '1.262009414478', 1, 0);
  t('11', '11.30224', 0, 0);
  t('3.3e-8', '0.00000003399', 9, 0);
  t('13', '13.56', 0, 0);
  t('2646.8', '2646.82301781544', 1, 0);
  t('122.7', '122.7266', 1, 0);
  t('3', '3.48298', 0, 0);
  t('3', '3.4', 0, 0);
  t('3', '3.0', 0, 0);
  t('7', '7.6', 0, 0);
  t('0', '0.58', 0, 0);
  t('-21.0915', '-21.091525', 4, 0);
  t('22262', '22262.5', 0, 0);
  t('-2415583', '-2415583.0', 0, 0);
  t('-962', '-962.6', 0, 0);
  t('3', '3.024', 0, 0);
  t('2.7997', '2.799706099', 5, 0);
  t('-15804.6023', '-15804.6023324', 4, 0);
  t('1', '1.23924229', 0, 0);
  t('-200373.5', '-200373.502979', 1, 0);
  t('-4170.151', '-4170.151057', 3, 0);
  t('279', '279.1052697190', 0, 0);
  t('-14902.11331', '-14902.1133147411', 5, 0);
  t('-72', '-72.19800', 0, 0);
  t('-0.00001961', '-0.000019610697', 8, 0);
  t('-5', '-5', 0, 0);
  t('0', '0.00000349047', 2, 0);
  t('69', '69.4', 0, 0);
  t('1886', '1886.04', 0, 0);
  t('7982', '7982.5', 0, 0);
  t('35.142265745', '35.1422657459', 9, 0);
  t('7408353', '7408353.2', 0, 0);
  t('7', '7', 0, 0);
  t('-5', '-5', 0, 0);
  t('-10159281.7729875', '-10159281.77298752', 7, 0);
  t('0.0138316681', '0.01383166817', 10, 0);
  t('149232', '149232.9', 0, 0);
  t('10983303592', '10983303592.73', 0, 0);
  t('0', '-0.000000099576', 7, 0);
  t('-1.10231', '-1.1023114', 5, 0);
  t('0.002316', '0.00231613481130', 6, 0);
  t('-5', '-5', 0, 0);
  t('-1', '-1', 0, 0);
  t('550', '550.6', 0, 0);
  t('-50', '-50.4', 0, 0);
  t('-0.00030265', '-0.0003026572202', 8, 0);
  t('10043.24', '10043.24056', 3, 0);
  t('6165060053567', '6165060053567.8', 0, 0);
  t('0', '0.074', 1, 0);
  t('-8867', '-8867.9', 0, 0);
  t('375.094', '375.094529', 3, 0);
  t('0', '-0.000000062089369038978', 5, 0);
  t('3', '3.4', 0, 0);
  t('-2.3', '-2.30006', 3, 0);
  t('-1451.61677', '-1451.616779838', 5, 0);
  t('-258.4', '-258.41', 1, 0);
  t('0.000001', '0.00000134861276115417', 6, 0);
  t('0', '-0.000003211650', 0, 0);
  t('-0.000573521', '-0.000573521667', 9, 0);
  t('0', '0.0000000506819', 4, 0);
  t('-0.00002', '-0.000022909766037852', 5, 0);
  t('0', '0.0000381368', 2, 0);
  t('-76', '-76.1', 0, 0);
  t('0', '-0.000000068', 3, 0);
  t('-0.009719', '-0.009719051425047', 7, 0);
  t('40.55', '40.5592', 2, 0);
  t('-83.5379912', '-83.53799123571', 7, 0);
  t('10', '10.3', 0, 0);
  t('9.92844', '9.928445325', 5, 0);
  t('303698112889', '303698112889.87', 0, 0);
  t('-1', '-1', 0, 0);
  t('-602', '-602.89', 0, 0);
  t('-186404.9571', '-186404.95710', 4, 0);
  t('4', '4.1', 0, 0);
  t('40380', '40380.0', 0, 0);
  t('2', '2.5', 0, 0);
  t('-8', '-8.0683', 0, 0);
  t('0', '0.00000011768533836', 2, 0);
  t('-11576', '-11576.09', 0, 0);
  t('-776', '-776.04', 0, 0);
  t('-52520079.8', '-52520079.861', 1, 0);
  t('913', '913.10', 0, 0);
  t('1', '1.1', 0, 0);
  t('1774', '1774.181', 0, 0);
  t('31322.26', '31322.26062', 2, 0);
  t('-29.086', '-29.086057', 3, 0);
  t('-19.6', '-19.66', 1, 0);
  t('-189695248', '-189695248.65', 0, 0);
  t('11169869441', '11169869441.4', 0, 0);
  t('71454', '71454.00777', 0, 0);
  t('-0.00000137577', '-0.000001375778212', 11, 0);
  t('-8', '-8.59', 0, 0);
  t('-0.000001952', '-0.00000195225207', 9, 0);
  t('2.9e-8', '0.00000002985427932', 9, 0);
  t('-6', '-6.0', 0, 0);
  t('851', '851.58', 0, 0);
  t('4', '4.8', 0, 0);
  t('0.000008153', '0.000008153933', 9, 0);
  t('-5.349177', '-5.34917724', 6, 0);
  t('-5.2', '-5.2316', 1, 0);
  t('-377', '-377.577', 0, 0);
  t('3834387', '3834387.2', 0, 0);
  t('12181', '12181.725980', 0, 0);
  t('71428.4620618', '71428.462061893', 7, 0);
  t('-1', '-1', 0, 0);
  t('-0.0110663', '-0.01106636', 7, 0);
  t('1', '1', 0, 0);
  t('0.0002597768', '0.00025977687636', 10, 0);
  t('-1', '-1.9599', 0, 0);
  t('275.5', '275.58', 1, 0);
  t('-0.0814', '-0.081443', 4, 0);
  t('0', '0.000008240', 3, 0);
  t('0', '-0.60624570', 0, 0);
  t('-0.0227783311', '-0.02277833117', 10, 0);
  t('-541', '-541.62', 0, 0);
  t('-14.2', '-14.209', 1, 0);
  t('1.2e-8', '0.0000000129296', 9, 0);
  t('-1', '-1.6', 0, 0);
  t('3773.2', '3773.286093', 1, 0);
  t('-2875.1', '-2875.1665111', 1, 0);
  t('0', '0.0000000697699318009', 2, 0);
  t('-7030.3', '-7030.36404', 1, 0);
  t('-40373.922163', '-40373.92216305', 6, 0);
  t('3006131', '3006131.2004', 0, 0);
  t('2', '2.2455', 0, 0);
  t('852718', '852718.7', 0, 0);
  t('-1', '-1', 0, 0);
  t('5347.08', '5347.0867716269', 2, 0);
  t('-4192.483', '-4192.48339', 3, 0);
  t('-378464', '-378464.2', 0, 0);
  t('-12839.478', '-12839.4786507', 3, 0);
  t('0.000026608', '0.0000266084208752225', 9, 0);
  t('-6', '-6.5', 0, 0);
  t('-4.212691', '-4.21269172515416', 6, 0);
  t('139.9', '139.957', 1, 0);
  t('86', '86.700', 0, 0);
  t('-0.00011158487', '-0.000111584878251992', 11, 0);
  t('-1247678537977', '-1247678537977.4', 0, 0);
  t('-23354042796', '-23354042796.5', 0, 0);
  t('2.3', '2.30288', 2, 0);
  t('-17', '-17.0', 0, 0);
  t('193.64', '193.6412', 2, 0);
  t('21', '21.15', 0, 0);
  t('-0.0000011652', '-0.000001165269571', 10, 0);
  t('0', '-0.00000014165644812', 1, 0);
  t('-3906082.6', '-3906082.6538', 1, 0);
  t('3.15', '3.1573', 2, 0);
  t('-26', '-26.680', 0, 0);
  t('0', '0.0000058085006209', 2, 0);
  t('498671554.99', '498671554.99400', 2, 0);
  t('3', '3', 0, 0);

  t('-621.1', '-621.1936868481623240587206058101226345962123520808', 1, 0);
  t('5.99444445523332228500677286802783348360874453460088221e+52', '59944444552333222850067728680278334836087445346008822.13109022', 1, 0);
  t('-0.00002', '-0.0000201677676330073', 5, 0);
  t('1.53863896315841870737458749488245817075e+31', '15386389631584187073745874948824.5817075338', 7, 0);
  t('-56330304118.366083', '-56330304118.366083425392876', 6, 0);
  t('-16', '-16.99', 0, 0);
  t('4.3668867451575236553332372e+21', '4366886745157523655333.2372863483627759542882630172217538130769969793881', 4, 0);
  t('1.097179', '1.09717917321722983004155405936241279', 6, 0);
  t('-3.6975305330293889774343758702e+22', '-36975305330293889774343.75870221577', 6, 0);
  t('-8.88998801310289527776424735580399220426722e+36', '-8889988013102895277764247355803992204.2672237', 5, 0);
  t('-2196415.5156', '-2196415.515629482968611257446984981968', 4, 0);
  t('0', '-0.00000005313286431705', 2, 0);
  t('-0.000102', '-0.00010217822924031', 6, 0);
  t('5.96350134614079915547738049581729484902e+28', '59635013461407991554773804958.172948490263614', 10, 0);
  t('-16', '-16.884', 0, 0);
  t('-76225396478720.7008524', '-76225396478720.700852473753693253737152345038330', 7, 0);
  t('-48577704323.577', '-48577704323.57724116540031426797', 3, 0);
  t('9172999786599669515', '9172999786599669515.1985', 0, 0);
  t('-5.13728694936470433709839374614062215040327669043753416e+50', '-513728694936470433709839374614062215040327669043753.4169063486', 3, 0);
  t('0.01', '0.019477672802315379261', 2, 0);
  t('-2.8580836477802451608475674622084473734e+36', '-2858083647780245160847567462208447373.488250403720', 1, 0);
  t('1.696764276603630426587419544285178813310996399309659791613e+49', '16967642766036304265874195442851788133109963993096.59791613055777022317054', 8, 0);
  t('510015455512', '510015455512.773144427', 0, 0);
  t('198799307405.41868368', '198799307405.41868368401077584830034903659', 8, 0);
  t('-33654.17', '-33654.178044480', 2, 0);
  t('-7', '-7.5', 0, 0);
  t('-7.945797700578646041041642994871386743393827046e+46', '-79457977005786460410416429948713867433938270460.92', 0, 0);
  t('-44', '-44.6', 0, 0);
  t('6969661407', '6969661407.48424', 0, 0);
  t('83893.2', '83893.22331277', 1, 0);
  t('-2.630769214064197932535879788479595265695e+36', '-2630769214064197932535879788479595265.69521806007', 3, 0);
  t('990990', '990990.4', 0, 0);
  t('-1945631159.4810852163', '-1945631159.48108521631058458200076750951128255185238512326839986743900799', 10, 0);
  t('24905227025676.571', '24905227025676.5716106', 3, 0);
  t('0', '-0.000201430550343505757156880394129280666198393269302', 1, 0);
  t('-7561348607829301891.14806377', '-7561348607829301891.1480637733147836437810415200', 8, 0);
  t('-405812.4387', '-405812.438704644726521226898488918352166523197441655908639584529732376', 5, 0);
  t('47.22039131203', '47.220391312031825404355122541793679345', 11, 0);
  t('0', '0.061467931008788549313382642265045703820816822', 1, 0);
  t('-522', '-522.27', 0, 0);
  t('-1.0298090952446488212965020894376172016774303e+36', '-1029809095244648821296502089437617201.67743037440775706800232655651', 7, 0);
  t('-49391771041600926.19376192011', '-49391771041600926.1937619201198', 11, 0);
  t('6.1771381755937831918252746169e+26', '617713817559378319182527461.6946248462538585976176748811616955665', 2, 0);
  t('4.7e-8', '0.0000000470087540427589519389570706502883047502294670400998618937817856494', 10, 0);
  t('126217046586302550', '126217046586302550.025', 0, 0);
  t('-4.2664699739101266426220460329e+27', '-4266469973910126642622046032.94313272856121814', 1, 0);
  t('73319041804356.002247491', '73319041804356.00224749170535645204297035206', 9, 0);
  t('4.55876708695751791697893686065697e+22', '45587670869575179169789.368606569711018880333705815252211', 10, 0);
  t('0', '-0.0000001434883113009966933873395369054112062388926420862433380492288546295369348', 1, 0);
  t('3016.8146519', '3016.8146519048', 8, 0);
  t('0', '-0.0000014354308754362856910795566313805294620061860895512856075910468433', 4, 0);
  t('-113074753134553.8674007293', '-113074753134553.8674007293072734726949062844916460018529095146537036', 11, 0);
  t('-3464', '-3464.746778614274994429826235994128081767466690909212396204', 0, 0);
  t('14917.299', '14917.29949887', 3, 0);
  t('5.31076079084367953105700057004959675218098419542915084e+46', '53107607908436795310570005700495967521809841954.2915084902', 7, 0);
  t('-1.040401883357966973828661248788073147986368877554342679e+44', '-104040188335796697382866124878807314798636887.7554342679937294752334', 10, 0);
  t('3.27429527792', '3.2742952779219542', 11, 0);
  t('-3.0401688094971536417093904855772853976e+35', '-304016880949715364170939048557728539.762216882104', 2, 0);
  t('-5991407.328708', '-5991407.32870817577', 6, 0);
  t('-243.4', '-243.47182', 1, 0);
  t('2', '2.7', 0, 0);
  t('1.287479360486616348178843963e+25', '12874793604866163481788439.6336905060374319474242776890412336399691', 2, 0);
  t('-17211.33', '-17211.3348298348721175791398512934620533547204228871623142124252', 2, 0);
  t('-2.750531014066285288486154362448825511195696793357440694193e+48', '-2750531014066285288486154362448825511195696793357.44069419365292729', 9, 0);
  t('4283923754637.7694', '4283923754637.769449546039', 4, 0);
  t('581735157.86130924', '581735157.86130924967847643084880395988936857460019579671897', 8, 0);
  t('5.712', '5.71266', 3, 0);
  t('220.4', '220.466163946155', 1, 0);
  t('3432432548.35', '3432432548.359', 2, 0);
  t('0', '-0.000080760485437144615992151070726723778256819938', 1, 0);
  t('-21698917949276671923.1', '-21698917949276671923.10205', 1, 0);
  t('529.04', '529.04476753422213292011208273412114659', 2, 0);
  t('-507800676594.83', '-507800676594.83242350850813652671110610288061248835132620', 2, 0);
  t('-4794533274621.74926', '-4794533274621.749266083338158610283566763759340664128162695', 5, 0);
  t('-1.76397707743100284264532089027283467941689395373725e+41', '-176397707743100284264532089027283467941689.3953737252804799408650025222', 9, 0);
  t('6.522728150963021116628893371747564560173083459950784699084470643e+57', '6522728150963021116628893371747564560173083459950784699084.470643477', 6, 0);
  t('-35258530238599.6', '-35258530238599.629', 1, 0);
  t('-8.732591689772504734455817160416563354576836156e+39', '-8732591689772504734455817160416563354576.83615670298067742759875349154', 6, 0);
  t('1.9278512518337504615624783032371199006751550185707360652672364126e+53', '192785125183375046156247830323711990067515501857073606.526723641263841174', 11, 0);
  t('4.288192032964014615755494325492124705877934669e+45', '4288192032964014615755494325492124705877934669.308919220119', 0, 0);
  t('1081499', '1081499.340547937530711016', 0, 0);
  t('1937456388292374.476731', '1937456388292374.476731668861915440713155190170836', 6, 0);
  t('9.7843242779655264916144633656155391703e+31', '97843242779655264916144633656155.39170345271222446', 6, 0);
  t('96020928829768.10663813833', '96020928829768.10663813833637107018993087', 11, 0);
  t('-1404660430272454.995761758', '-1404660430272454.99576175888357480117217949034', 9, 0);
  t('-0.0001819', '-0.000181998190255586118068479533019475726491058426074059095491632442624987334604', 7, 0);
  t('-8.53692202899', '-8.53692202899553884', 11, 0);
  t('1.8948398953903675796801968762872526848885e+33', '1894839895390367579680196876287252.6848885539934891607289174963694814850', 7, 0);
  t('1.2942015160060948232044544828758143089710176705868728e+49', '12942015160060948232044544828758143089710176705868.7289030111', 3, 0);
  t('-1.668355544328844957526397301607869823058e+29', '-166835554432884495752639730160.786982305820088063915283383412524254', 10, 0);
  t('-208.641', '-208.641643023', 3, 0);
  t('0.0044', '0.004440721763727523846427918683602094331446739592972780457001368833293', 4, 0);
  t('1.8000294404468274394450127472021884973400130177632829445984e+57', '1800029440446827439445012747202188497340013017763282944598.42664110863075', 1, 0);
  t('-1.663694795014649286027998916820975379128758945630263647771e+48', '-1663694795014649286027998916820975379128758945630.263647771061032926129697', 10, 0);
  t('183982490', '183982490.7540529110', 0, 0);
  t('4.5179e-7', '0.000000451791742650153941321563100125029348696439716', 11, 0);
  t('3.07843381954352839904767689826e+21', '3078433819543528399047.67689826456', 8, 0);
  t('703094413485022326.29383', '703094413485022326.29383791942669106433079', 5, 0);
  t('-7.6441086157640615807282619077874809177472329954691e+44', '-764410861576406158072826190778748091774723299.54691778214479967820', 5, 0);
  t('1.7969733913826182126120489369443001595436011683e+46', '17969733913826182126120489369443001595436011683.8', 0, 0);
  t('424', '424.0625789', 0, 0);
  t('-968899371607.5608', '-968899371607.5608700932694', 4, 0);
  t('103', '103.3551450921833686059315778179256', 0, 0);
  t('0', '0.000757123872112209889927518652070234813867880039983564592421157804', 0, 0);
  t('-0.00011179065', '-0.000111790659699', 11, 0);
  t('-2e-8', '-0.0000000204345202376402833084935395637065638724483544956497074232931', 9, 0);
  t('-762475500540.295122171', '-762475500540.295122171843853282909431645820678185456789361877151582', 9, 0);
  t('176156.9', '176156.985979052314472225633608623323563', 1, 0);
  t('0', '-0.01206587298374532086925889221874090724433409239555026431545007500', 1, 0);
  t('5.89192140089688259342559325654e+21', '5891921400896882593425.59325654785790306', 8, 0);
  t('-0.0000885', '-0.00008851689324', 7, 0);
  t('-3.24749690892', '-3.247496908921508566511556285', 11, 0);
  t('18278158818.793124326', '18278158818.7931243264927799557220771159', 9, 0);
  t('-2193356253079.5', '-2193356253079.5748407545247053489151071979465252418192690592', 1, 0);
  t('-7.8283552610688878548333208280647880275355192458558e+42', '-7828355261068887854833320828064788027535519.24585582091559480953', 7, 0);
  t('122466.3927', '122466.39271', 4, 0);
  t('1.35508201785836360038092301151263116222e+28', '13550820178583636003809230115.126311622233379', 10, 0);
  t('-3357263812997320489', '-3357263812997320489.28684299830402222687595077091942630', 0, 0);
  t('-572629.1657', '-572629.16570004207511779521313055159794990541408988601548190310870875248', 7, 0);
  t('-1.362956631213164447817483051461022029606957046318999058437e+49', '-13629566312131644478174830514610220296069570463189.99058437392', 8, 0);
  t('7.8e-7', '0.0000007825493958482525', 8, 0);
  t('-0.5093', '-0.5093044573152321275285783647460768563513835655687560', 4, 0);
  t('1', '1.43', 0, 0);
  t('5.58298595981175588480004210935337e+22', '55829859598117558848000.4210935337076623857438813821060915952243622275', 11, 0);
  t('1.5233343194169311107500909380787852284746387419762508408e+49', '15233343194169311107500909380787852284746387419762.50840840791943', 6, 0);
  t('0.000005', '0.00000554466759427564870786645690498627177', 6, 0);
  t('1.6470459067450660089114601177e+25', '16470459067450660089114601.177933318701734936705', 3, 0);
  t('-169454980923350', '-169454980923350.539110315560833861894', 0, 0);
  t('1.59244019874696194359922544692e+29', '159244019874696194359922544692.812', 0, 0);
  t('0', '-0.00000010640568829452763610800039032588474099795283885047127225343614944', 6, 0);
  t('-3.78624438268881842269739489156e+25', '-37862443826888184226973948.915695305453903203897386', 4, 0);
  t('2.98108476513426175971467852186325736e+31', '29810847651342617597146785218632.573695725815755547242233867', 4, 0);
  t('-662.1368', '-662.136833141', 4, 0);
  t('-147106526173825.2867101389', '-147106526173825.2867101389196435369588', 10, 0);
  t('1.43670887212657952287587e+22', '14367088721265795228758.7417610610725284316560219', 1, 0);
  t('-66088388794388381382.8622091', '-66088388794388381382.862209167639577363', 7, 0);
  t('0', '0.00000028900352893882415015658089254626163204582366959', 4, 0);
  t('0', '0.1110824238844369871371015629337477', 0, 0);
  t('4.013137942240553065957183228344012e+22', '40131379422405530659571.8322834401245989022030481075279092940325725', 11, 0);
  t('366522483730948.9', '366522483730948.9410457', 1, 0);
  t('-635661944421848.13', '-635661944421848.13561', 2, 0);
  t('-464032909524683312691.20464', '-464032909524683312691.20464345926823518', 5, 0);
  t('-3295550873673941.196209475', '-3295550873673941.1962094750682620434172387221212716035', 10, 0);
  t('29.0071041578', '29.007104157838691532857026891163787420228593629840231832633217', 10, 0);
  t('3.552301800376926251312483579134278762257e+37', '35523018003769262513124835791342787622.570583628867', 2, 0);
  t('1', '1', 0, 0);
  t('883270406217971', '883270406217971.84075684', 0, 0);
  t('3', '3', 0, 0);
  t('0', '-0.0008675899217770461423354681626904394809662788110819918795335', 1, 0);
  t('-0.0000054', '-0.00000547758490741367927', 7, 0);
  t('36', '36.4', 0, 0);
  t('1.8897980442175431071851730842393614876e+29', '188979804421754310718517308423.936148765853251317189398288', 8, 0);
  t('-1.1457206581840961483702129812202931992404712420834931410821e+55', '-11457206581840961483702129812202931992404712420834931410.8214147435495006', 3, 0);
  t('0', '-0.00003418014014354605974', 3, 0);
  t('1.08627300720819424774100936183120861755032795354319206820304661e+62', '108627300720819424774100936183120861755032795354319206820304661.36', 0, 0);
  t('0', '-0.0000008826780710237101534839334003491546857115558379387283809', 0, 0);
  t('-0.2', '-0.27262066316663189844699825285243922042', 1, 0);
  t('-1.2734605018735958248502548e+24', '-1273460501873595824850254.82835251694', 1, 0);
  t('0', '-0.0000022988384652503747936752850467602008689327344', 3, 0);
  t('-18174970825856477.3', '-18174970825856477.3074482547', 1, 0);
  t('-106773.0476', '-106773.04768350721216651533847933852004806216967710847580764680', 4, 0);
  t('2.3956115746159882129934842207e+28', '23956115746159882129934842207.30761903149070', 0, 0);
  t('-4.34736832418163635178249231367e+26', '-434736832418163635178249231.367076', 3, 0);
  t('1.298530424288187903018473058167860792085752926e+34', '12985304242881879030184730581678607.9208575292695376856554984070969081748740', 11, 0);
  t('194797080090002690.16', '194797080090002690.1663486955588151687848147692', 2, 0);
  t('1.2386167739374301743671445187e+24', '1238616773937430174367144.518753573168521505940763', 4, 0);
  t('-2870053.8679261551', '-2870053.8679261551465', 10, 0);
  t('-7.4390502631475374477298396352e+22', '-74390502631475374477298.396352228294450218530', 6, 0);
  t('-17747957199001766605.78814981636', '-17747957199001766605.788149816367636967763431769786295751371696048302660487', 11, 0);
  t('26.6', '26.6944692073126451687781431072069795350236', 1, 0);
  t('-485184315', '-485184315.9', 0, 0);
  t('13285719.4763047', '13285719.4763047571387992542198134986758176086864627177975740909459553087035', 7, 0);
  t('-426391.758', '-426391.758490723147', 3, 0);
  t('0.0496304', '0.049630418953', 7, 0);
  t('-3.710678540703152527500023763323267641531782e+40', '-37106785407031525275000237633232676415317.820453567428079469388217239', 3, 0);
  t('3.5', '3.522', 1, 0);
  t('45433421369161', '45433421369161.68442099806029000587663491218502017328187645', 0, 0);
  t('-1.3176', '-1.3176073', 4, 0);
  t('-2.20636486597900214368358506927185625431264002582e+43', '-22063648659790021436835850692718562543126400.25825556', 4, 0);
  t('-0.000003', '-0.000003800', 6, 0);
  t('0.0001', '0.0001066928846067353999453896267892144860873304390869242760135881028334791948', 4, 0);
  t('13370890.028447', '13370890.028447719443000572782', 6, 0);
  t('-0.002854', '-0.002854132010168', 6, 0);
  t('-1.36835068792165244964367055623463448365e+37', '-13683506879216524496436705562346344836.5644131145220898728325480014775787', 1, 0);
  t('52.1', '52.1986', 1, 0);
  t('-1.605044493102064468833520939e+22', '-16050444931020644688335.2093919239970792001350433875', 5, 0);
  t('0', '-0.000004771156424010419119829988853', 4, 0);
  t('2.0016487356511796984178e+22', '20016487356511796984178.41', 0, 0);
  t('-0.0000425', '-0.00004255477314450976148075447051756431999655754935016368071166740', 7, 0);
  t('8277333746516897.180275586', '8277333746516897.1802755869157162497', 9, 0);
  t('6.292580420622652228607172707464889e+33', '6292580420622652228607172707464889.290610389971317641703738443939590', 0, 0);
  t('-0.00011', '-0.00011429709282446853254556488946551697722931383939927196', 5, 0);
  t('-54815865864100534450.12625', '-54815865864100534450.126251139', 5, 0);
  t('3444555419522944481.6377', '3444555419522944481.6377911617444569', 4, 0);
  t('7.1', '7.112', 1, 0);
  t('3873369.8', '3873369.823', 1, 0);
  t('-6', '-6.097', 0, 0);
  t('881942537884746.634401391', '881942537884746.6344013913524107821463944792', 9, 0);
  t('147.557805', '147.55780578552047', 6, 0);
  t('1.360661218764723546101434893065580880554303196411043336251649043e+53', '136066121876472354610143489306558088055430319641104333.625164904304330113', 11, 0);
  t('-3.6358793138178240822562643092655522410853419411397655049658727e+61', '-36358793138178240822562643092655522410853419411397655049658727.87', 0, 0);
  t('-10', '-10.46343109269871923780122241346406655750435775895660420699159782', 0, 0);
  t('144016588896272878.01', '144016588896272878.012441', 2, 0);
  t('0', '0.0000143118174214791570666477821216420086504888243', 0, 0);
  t('0', '-0.0000009216037985889175319897606512176142523507025631582568746', 1, 0);
  t('0', '0.018924317664142942743154696151527983624985506256173575489945597606091738', 0, 0);
  t('0', '-0.0012384681586411924085605244957560657888146052', 1, 0);
  t('-1.9962139398189005397351423924e+26', '-199621393981890053973514239.2478', 2, 0);
  t('7.3240325390574920949672025280204581901311477e+35', '732403253905749209496720252802045819.01311477077027051341952754041218130', 9, 0);
  t('7.20797888759725269110448401449311327403641414603871118e+52', '72079788875972526911044840144931132740364141460387111.8170046188657523694591', 1, 0);
  t('-2.6775381974268043087248686e+23', '-267753819742680430872486.8666830274904078860682529', 2, 0);
  t('23.86', '23.8671781391501056278971378348123790521971996328', 2, 0);
  t('-1.695e-8', '-0.000000016952525349', 11, 0);
  t('-997032368255340.85', '-997032368255340.858167', 2, 0);
  t('3102', '3102.3282323930789400085493726946893130103734000514579676340627508447765', 0, 0);
  t('0.0000028', '0.0000028580305', 7, 0);
  t('134635038', '134635038.97', 0, 0);
  t('-0.2613769', '-0.261376900396132412934758268522146171186416181286722535792306023', 9, 0);
  t('47830201688.0174895004', '47830201688.017489500417749306790656314394', 10, 0);
  t('-4.760416615168524995210630297610798168548714366209e+42', '-4760416615168524995210630297610798168548714.36620985351198725168', 6, 0);
  t('2396712571453.0062', '2396712571453.0062223914270561212745595222436061190181782432322653', 4, 0);
  t('5666074752714.376444147', '5666074752714.376444147382948323436605741840112535', 9, 0);
  t('3', '3', 0, 0);
  t('-35487092590.323484129', '-35487092590.3234841293', 9, 0);
  t('0.0000031', '0.000003186073204002183', 7, 0);
  t('0.0002074', '0.000207466964950951844860515', 7, 0);
  t('1.2831881222343647528658123606e+28', '12831881222343647528658123606.12805', 0, 0);
  t('-0.4471', '-0.4471004715357804871305109', 6, 0);
  t('-3.8746041804740719834063e+22', '-38746041804740719834063.147219', 0, 0);
  t('-1.4586261266351697829931608642354799913292571e+40', '-14586261266351697829931608642354799913292.571114826', 3, 0);
  t('2135.734', '2135.734038487', 4, 0);
  t('0', '0.00000023401336870829522118094403373873354815641796082508693909184856655856028239', 6, 0);
  t('-0.0000097337', '-0.0000097337033573100298', 10, 0);
  t('0.00121979045', '0.001219790452873015772530825230', 11, 0);
  t('-10683389', '-10683389.7', 0, 0);
  t('-5.406675323117739022228e+21', '-5406675323117739022228.07', 0, 0);
  t('-0.47675', '-0.47675244022186747923865985435466799925694588482853', 5, 0);
  t('91441691420756116902.80665861001', '91441691420756116902.80665861001006726847189277342411748556292657', 11, 0);
  t('4', '4.831740829717073261450711096113951605848900293077879898738234061695193', 0, 0);
  t('-6.42165157475544721109839882297580925202244142594608091715e+51', '-6421651574755447211098398822975809252022441425946080.917155958106', 5, 0);
  t('1846729365800666.1292', '1846729365800666.129290307', 4, 0);
  t('-1.0061956108903602810047893740230186911756e+29', '-100619561089036028100478937402.301869117569540574858039', 11, 0);
  t('0', '-0.000000084828275333301566425543267138805818239983425418247985348526171519070087130', 6, 0);
  t('1.489088332992948496349659568953171722884872e+35', '148908833299294849634965956895317172.288487208712031099079746443843', 8, 0);
  t('-0.0000047', '-0.000004799032886229965156863176212727828859057881174', 7, 0);
  t('3.1038605680375917071523388e+21', '3103860568037591707152.338825842176399498685', 4, 0);
  t('-8.36936794331128299654061446036342538681e+38', '-836936794331128299654061446036342538681.10', 0, 0);
  t('4.93413565873232980894673e+22', '49341356587323298089467.3787070845', 1, 0);
  t('60808.24038482914', '60808.24038482914787367162935430003621673616014962009861716892370781210986', 11, 0);
  t('0', '0.0000001389251986236583290110743215307476', 0, 0);
  t('0', '-0.0000000720119054163336208', 6, 0);
  t('3096.35', '3096.359', 2, 0);
  t('0', '0.000000214687199805660791987938147817896390564632616832441', 5, 0);
  t('5', '5', 0, 0);
  t('5.81009876511765640002990483832063765610025426e+40', '58100987651176564000299048383206376561002.5426972547431455320826100073399562', 4, 0);
  t('-3566258', '-3566258.71789', 0, 0);
  t('-7.1121392852483844051240080203543974369013e+39', '-7112139285248384405124008020354397436901.35977852', 1, 0);
  t('-3.1030322445411722033618923e+25', '-31030322445411722033618923.87', 0, 0);
  t('1338.18384986', '1338.183849861656266320788438522111848084507432240033258605411', 8, 0);
  t('-0.00835822', '-0.0083582266064483839752', 8, 0);
  t('-13242677.11038703', '-13242677.1103870313740058387180784633685610074407936315123006', 8, 0);
  t('-0.914372', '-0.9143725218462452966687', 6, 0);
  t('-93446160531244.77086866616', '-93446160531244.770868666163444621106575819324', 11, 0);
  t('0', '-0.0490', 1, 0);
  t('0.00039684', '0.0003968403544217719999216', 8, 0);
  t('-0.00004', '-0.000042471316853291209476781179454367913', 5, 0);
  t('0', '-0.08169118731568279980175561480562036791914279342220440953803', 0, 0);
  t('-8.743188556735564953976507080360176205277e+34', '-87431885567355649539765070803601762.052774577', 5, 0);
  t('-0.0002', '-0.00026048898753846715072949338593135164864804725739105356', 4, 0);
  t('30.1', '30.1070', 2, 0);
  t('-372443500', '-372443500.87', 0, 0);
  t('-1.16353257607190506884948452531e+21', '-1163532576071905068849.4845253194161005921931519251443597', 8, 0);
  t('1.167892482779209659681424e+24', '1167892482779209659681424.146', 0, 0);
  t('17270175', '17270175.7281', 0, 0);
  t('619625.7286', '619625.7286058432355202393008523', 5, 0);
  t('-83.0869176', '-83.08691763', 7, 0);
  t('-4118', '-4118.8', 0, 0);
  t('2440050845384.87357791', '2440050845384.8735779158293538846996892279411728111590045386688649294634175', 8, 0);
  t('-59098969147090265', '-59098969147090265.2155', 0, 0);
  t('0', '0.000019445968509762027587853915750836776260487420534707223798804570502095905827', 4, 0);
  t('7.508470444531795608012761679545077964561514273903291455183e+57', '7508470444531795608012761679545077964561514273903291455183.28', 0, 0);
  t('1.21480991630151311662879932683552403e+28', '12148099163015131166287993268.355240389974552485540959', 7, 0);
  t('0', '0.00974491088762115527935828096020382412594603931084053594935957087773954221', 2, 0);
  t('0.857953', '0.8579539758668673057170095849043785347365712', 6, 0);
  t('-2.60369231014935603404789157368928779112e+37', '-26036923101493560340478915736892877911.2153548', 1, 0);
  t('-149182643775156.5784113923', '-149182643775156.57841139234626989630252539230050001889364941702', 10, 0);
  t('-61908.2832', '-61908.283290208', 4, 0);
  t('0', '-0.0000000174116332658497', 4, 0);
  t('-0.00010289348', '-0.0001028934818977297155342229240900125914965', 11, 0);
  t('0.0127546', '0.01275465715370721130299340566504165922633043642993809232890289101897125023', 7, 0);
  t('0', '0.00003625', 1, 0);
  t('-1430892736.68453081757', '-1430892736.6845308175727428982', 11, 0);
  t('141190906659881641.38794', '141190906659881641.387941864319419844935479637500611246061779392682027', 5, 0);
  t('-1321676844103668.3112788284', '-1321676844103668.3112788284667476612533101226174', 10, 0);
  t('9675620', '9675620.3', 0, 0);
  t('-0.005367', '-0.0053679901474997', 6, 0);
  t('2', '2.6', 0, 0);
  t('0', '-0.00809', 2, 0);
  t('0', '0.000005968754734081530078567711869927223359925853632268952475278181833791005', 3, 0);
  t('-17031766.68299', '-17031766.682999904740138346', 5, 0);
  t('-4140921928.6208084928', '-4140921928.62080849280290109410537423622502801699165114622706', 10, 0);
  t('2556570187717.276', '2556570187717.27668266925882609', 3, 0);
  t('7.42264163005814411652305998493937e+23', '742264163005814411652305.99849393765', 9, 0);
  t('0.00020231965', '0.00020231965294979204736358744034769355714940580140209380823393112', 11, 0);
  t('-1.0677137535421841434976925678125003299e+36', '-1067713753542184143497692567812500329.9377258', 1, 0);
  t('-13.00220354', '-13.00220354894936829693751908776940012275270320437', 8, 0);
  t('0', '-0.02482741101921428855995376839268938064810209683400948022', 0, 0);
  t('0', '0.0064933231650473424923752474715793843629291714768170299403', 1, 0);
  t('1e-8', '0.00000001776216224201190413578979105910', 8, 0);
  t('-3.163144769362405522940054788790777097100684578844072467410986510768307e+69', '-3163144769362405522940054788790777097100684578844072467410986510768307.855', 0, 0);
  t('-1.224647928181561457020277159914e+30', '-1224647928181561457020277159914.882', 0, 0);
  t('-1444921.9885', '-1444921.988545053874186127598252743189634713992842106795644310074704927781', 4, 0);
  t('0.000002954', '0.00000295466629149644888035604565294', 9, 0);
  t('7177.6', '7177.63937736', 1, 0);
  t('0.010499', '0.0104991705576431924165420325976930820', 6, 0);
  t('4324993562.2', '4324993562.29980986154939338565764', 1, 0);
  t('38205143834359582694.76', '38205143834359582694.7644', 2, 0);
  t('-0.00000609', '-0.000006095848225286539665414', 8, 0);
  t('38385446899272.37', '38385446899272.370635491019661673655363639327097785502776771839', 3, 0);
  t('13482367.671', '13482367.6712355812690101759607172942952207375677', 3, 0);
  t('-93206560', '-93206560.922', 0, 0);
  t('0', '-0.0000001764791019977084216549880884390737540307620', 5, 0);
  t('-0.60448', '-0.6044825535', 5, 0);
  t('-197246', '-197246.8', 0, 0);
  t('-672924716467362234208', '-672924716467362234208.06373', 0, 0);
  t('0', '0.82971389037810240798314377212101170870', 0, 0);
  t('4.304128887470973117692846397983402e+33', '4304128887470973117692846397983402.091290106184824850752099673554922458', 1, 0);
  t('250.7773', '250.77734824513275397094632260910820641', 4, 0);
  t('-0.05', '-0.0536185198999776174717811772609795004', 2, 0);
  t('-96.027', '-96.0277791695733479800169548987224782155523920791589487094223720228946', 3, 0);
  t('-64883262956.4979330025', '-64883262956.4979330025696591829267906657318134', 10, 0);
  t('1747629841057963', '1747629841057963.304628381402528543417389640791687081229802', 0, 0);
  t('2.4243800119692796428032600479001157e+29', '242438001196927964280326004790.011572665426689176701270789827300846745', 5, 0);
  t('-31303936.05', '-31303936.053051252', 2, 0);
  t('425880.5627034044', '425880.562703404445931160478127510385977001', 10, 0);
  t('-1', '-1.5106', 0, 0);
  t('5950725620727.6', '5950725620727.621734376461617', 1, 0);
  t('4.708543191176142909137246901540413194933e+29', '470854319117614290913724690154.04131949333', 10, 0);
  t('223305405251.29687', '223305405251.296873588577424550942551362859460695495773270406806', 5, 0);
  t('765003784909712666.2055905668', '765003784909712666.205590566874870047', 10, 0);
  t('0', '0.00014324223647476234425594472169889008092', 0, 0);
  t('0.752267306', '0.7522673060296722267', 10, 0);
  t('-285413834777400834460.5317657534', '-285413834777400834460.531765753405012', 11, 0);
  t('-0.00012694251', '-0.0001269425181372227857995226818562132019338832175049504302', 11, 0);
  t('-6', '-6', 1, 0);
  t('-4.427734311', '-4.427734311522', 9, 0);
  t('-3.36034171879742754409086862346619250463963149e+34', '-33603417187974275440908686234661925.04639631492225906731529462533363', 10, 0);
  t('-339.6', '-339.6490', 1, 0);
  t('-15162965', '-15162965.5753622884962', 0, 0);
  t('2980', '2980.7', 0, 0);
  t('-8', '-8.6', 0, 0);
  t('-7.2930743714224300387618190169600765421717451222413e+38', '-729307437142243003876181901696007654217.174512224134736361', 11, 0);
  t('0', '0.0000573223449789679316774692546803782743781481278821106295395857414498799931887', 0, 0);
  t('0.3866077149', '0.3866077149633565382069316773051635298849181318362', 10, 0);
  t('15.57', '15.577', 2, 0);
  t('0', '-0.000012273012586376759227038973184', 1, 0);
  t('-0.000004867', '-0.000004867492749464', 9, 0);
  t('0.0001', '0.0001095307659063969625208', 4, 0);
  t('0', '-0.000005427710610340713573075723399512800', 1, 0);
  t('1.6373871008860865592799865380097002606e+31', '16373871008860865592799865380097.0026062889343715930001633912740543', 6, 0);
  t('22.022', '22.0227038563434378290975354399306066851', 3, 0);
  t('1', '1.0481032788093', 0, 0);
  t('4.2', '4.278', 1, 0);
  t('-4.03775717455877344134046611079003671293849273e+44', '-403775717455877344134046611079003671293849273.28', 0, 0);
  t('7.1242645028305587840846248e+25', '71242645028305587840846248.23205', 0, 0);
  t('-3.5730547399540425456965478979002981382305e+33', '-3573054739954042545696547897900298.1382305656635943914086370993', 7, 0);
  t('-675099994', '-675099994.9', 0, 0);
  t('25314724232', '25314724232.072', 1, 0);
  t('5.53721917393132515454468195563178759165638198802122e+42', '5537219173931325154544681955631787591656381.98802122370577567969250', 8, 0);
  t('3026055655279.233561193', '3026055655279.23356119337088454', 9, 0);
  t('-1.422806960639524126623200027372808449126974075e+36', '-1422806960639524126623200027372808449.126974075182510319839324167', 9, 0);
  t('0', '0.000000356401788904508358896228311234', 4, 0);
  t('-2e-8', '-0.00000002707733961926713177822772332770373164449982159883694286921', 8, 0);
  t('9724879823855729.4983898', '9724879823855729.498389866598442', 7, 0);
  t('-1', '-1.4', 0, 0);
  t('-6.318922438489962225585117207108373356301446444810967526467020299e+56', '-631892243848996222558511720710837335630144644481096752646.7020299443361', 7, 0);
  t('-425.4', '-425.4618361', 1, 0);
  t('22832971148.2078787405', '22832971148.20787874057427810133', 10, 0);
  t('-2192638256', '-2192638256.633', 0, 0);
  t('-8.0993880635959158901012908005279193926658344e+34', '-80993880635959158901012908005279193.92665834432831345298052522568773', 9, 0);
  t('-14265996585.2129870452', '-14265996585.2129870452159', 10, 0);
  t('1.38098692327849284088017053e+25', '13809869232784928408801705.3811102252370773378748441221155215502776022', 1, 0);
  t('0', '-0.000032193514758463', 1, 0);
  t('-3.30946096675482763608388616051e+25', '-33094609667548276360838861.60518084103074444080165', 4, 0);
  t('-2521813153.99', '-2521813153.991359183227269831960', 2, 0);
  t('164.64781304', '164.647813049903845572882310160222156484', 8, 0);
  t('95277306006990726587.25549888', '95277306006990726587.2554988863807673374634102640547614361', 8, 0);
  t('56686708331658418.197', '56686708331658418.1974342002', 3, 0);
  t('3.139173808678031493712273995822215318e+36', '3139173808678031493712273995822215318.34714872221556703629', 0, 0);
  t('1.3165829356447483373211291824898e+31', '13165829356447483373211291824898.29840376', 0, 0);
  t('-178169181739645704657.2981', '-178169181739645704657.2981721112', 4, 0);
  t('3.68467509698', '3.68467509698957075012252592640', 11, 0);
  t('1.73634822392412550118984628e+22', '17363482239241255011898.46284629519281', 4, 0);
  t('4.79348637332402354824716927912589733e+35', '479348637332402354824716927912589733.40', 0, 0);
  t('-1.594501087683540921323214e+21', '-1594501087683540921323.2145959715538866096', 3, 0);
  t('-2', '-2', 0, 0);
  t('1.1646141036182830696548831860019e+32', '116461410361828306965488318600190.6472', 0, 0);
  t('16', '16.5', 0, 0);
  t('38.261568894', '38.2615688947', 9, 0);
  t('42.78', '42.7878', 2, 0);
  t('789388090.774', '789388090.774740', 3, 0);
  t('-0.000324', '-0.000324007355296354614909840185671486572099947', 8, 0);
  t('-8.12458027014004111989605212e+22', '-81245802701400411198960.5212906126162992810148378568930', 4, 0);
  t('6467469.33689672', '6467469.3368967277447259584009887667747', 8, 0);
  t('-2.57039830497867645337981665434153180496689591554966170009477e+59', '-257039830497867645337981665434153180496689591554966170009477.61', 0, 0);
  t('0.000068', '0.0000686901196897790630511468496', 6, 0);
  t('2.55579935343945983659998822935592e+32', '255579935343945983659998822935592.224761466867002', 0, 0);
  t('32141818.956097', '32141818.9560975847810962464', 6, 0);
  t('2.3550386349516411676438367220376144532738606135e+41', '235503863495164116764383672203761445327386.061356509869489775298', 5, 0);
  t('-0.00000213', '-0.000002130361279925841154', 8, 0);
  t('-26796403902', '-26796403902.2', 0, 0);
  t('-2.0079835705261416530976415724605412e+34', '-20079835705261416530976415724605412.128676322226980848217', 0, 0);
  t('-91120857.8', '-91120857.819108392986534932140992385972178000812644252717554465', 1, 0);
  t('-189.7288', '-189.7288810', 4, 0);
  t('57680.7', '57680.70640919937521727437569913061826823192692703812275057477981518007048', 1, 0);
  t('642368771596624.4', '642368771596624.4983226583191', 1, 0);
  t('0', '0.000000121771821345422866035718300131045', 2, 0);
  t('4634752.2332487', '4634752.2332487271', 7, 0);
  t('0.2', '0.207', 1, 0);
  t('-18146399958.2514570173', '-18146399958.25145701730', 10, 0);
  t('235120212008292695825.21236190975', '235120212008292695825.21236190975527368992393365283125', 11, 0);
  t('-308885207994835711.15688', '-308885207994835711.15688372563620895934805060382171', 5, 0);
  t('8.08217669', '8.082176698927877602', 8, 0);
  t('2.0878318078463408754784e+22', '20878318078463408754784.80', 0, 0);
  t('-8.454043592532232948387671e+23', '-845404359253223294838767.1667233258327', 1, 0);
  t('470.21344167639', '470.21344167639152046362676178721363979220169', 11, 0);
  t('1.222155957406616073863236148184972375584078899667067e+48', '1222155957406616073863236148184972375584078899667.06737125481831992608593564', 3, 0);
  t('159008.92793825', '159008.927938257709702318264376740863200907973313239382125026576056926203155', 8, 0);
  t('2.134538351051546861879077801892214625626e+31', '21345383510515468618790778018922.14625626508385894959552', 8, 0);
  t('-1.3020155476456994061444877669129783924443962248004e+45', '-1302015547645699406144487766912978392444396224.80043767414078272816856', 4, 0);
  t('0', '-0.0003213146822330987763249634874812550662835002430704733228221708553265345', 0, 0);
  t('9.56965172370903663965140024e+23', '956965172370903663965140.024733', 3, 0);
  t('-119776164113297999828.12037', '-119776164113297999828.120378815462266668039085', 5, 0);
  t('81477213332813026419.69', '81477213332813026419.6929254248665086511783416084310934507749445', 2, 0);
  t('-0.0001754', '-0.00017544909121', 7, 0);
  t('0', '-0.147278935', 0, 0);
  t('0', '-0.002587107072212092757522490723865014169', 2, 0);
  t('4.75544482100415445857730098512900600299e+28', '47554448210041544585773009851.29006002996563821365', 10, 0);
  t('2.13190179605758224032247e+22', '21319017960575822403224.776941156563', 1, 0);
  t('14754293664011304687.79100555657', '14754293664011304687.791005556571983352775', 11, 0);
  t('1.06750973', '1.0675097375408131630668957917532058125642', 8, 0);
  t('-3.29305579823417900484505609758207907116127727259187e+49', '-32930557982341790048450560975820790711612772725918.7734380926', 1, 0);
  t('4.7e-7', '0.00000047971613168064240150373114358298786372634554407675238830009663', 8, 0);
  t('4.7030077272797028131891309847834272e+35', '470300772727970281318913098478342720.8', 0, 0);
  t('0.0002', '0.00020662410032804269392', 5, 0);
  t('0.269292', '0.269292051055601846868876264', 6, 0);
  t('-107946415385049.73', '-107946415385049.733453008437', 2, 0);
  t('-1382049868.46911', '-1382049868.469119279', 5, 0);
  t('-1', '-1.973', 0, 0);
  t('-2.5957603675339547496002591738104489e+23', '-259576036753395474960025.9173810448962540877985761415345354692751', 11, 0);
  t('9330365751491.494', '9330365751491.49482057598423593579489712590731280183168698642616296781297', 3, 0);
  t('0.02863808', '0.0286380899665338458758024915280692', 8, 0);
  t('7.905276448752364004467172072061757677124158539175227343e+47', '790527644875236400446717207206175767712415853917.522734347021947', 7, 0);
  t('23345208538964009.8164', '23345208538964009.8164741757835608091916531484683390250100691034', 4, 0);
  t('1.67148414', '1.671484145469631601134082', 8, 0);
  t('0.002', '0.0028071057930094233241781856794321', 3, 0);
  t('1.6045358314382307282565639593417789386631636e+41', '160453583143823072825656395934177893866316.362690701', 2, 0);
  t('-2.08259336939225693051187e+21', '-2082593369392256930511.877136676416381190490519055609611156', 2, 0);
  t('-118814528031522.19', '-118814528031522.19972035', 2, 0);
  t('-1.958838207297959207945e+21', '-1958838207297959207945.2971324200818441085014981639092972833865964', 0, 0);
  t('6.6e-8', '0.0000000662119135906632810568699987539844784853859058864531066', 9, 0);
  t('-167', '-167.10', 0, 0);
  t('1692043349420108106', '1692043349420108106.8', 0, 0);
  t('2e-8', '0.000000020935513997167797193397973766229736564337726316507136243641941728', 8, 0);
  t('-9618.87779576', '-9618.87779576516105933645321300734758676986688279252970', 8, 0);
  t('-0.00007', '-0.0000708221427644344613420998310417208104130537220113336', 5, 0);
  t('-741715495132', '-741715495132.7', 0, 0);
  t('1.514423260904431150132567816897936418291851773831931528e+54', '1514423260904431150132567816897936418291851773831931528.3285', 0, 0);
  t('0.000021832', '0.00002183292363281114', 9, 0);
  t('-0.00001155', '-0.0000115511670164513443948325262', 8, 0);
  t('-0.0891495', '-0.089149518216074815', 7, 0);
  t('-1648809.92809113', '-1648809.9280911309325743966557559984671', 8, 0);
  t('2.05081776533150043381770869554555215651958838030866046832872e+59', '205081776533150043381770869554555215651958838030866046832872.21', 0, 0);
  t('0', '-0.00000034113025971634708599834754698657881048609671151399', 3, 0);
  t('1348', '1348.8', 0, 0);
  t('3', '3.2361188790344478956136516016241', 0, 0);
  t('100345392482113', '100345392482113.1388951481855717039174819045', 0, 0);
  t('1.2414009598547683002702425150518879e+32', '124140095985476830027024251505188.7904955077716802810163625', 2, 0);
  t('1.0145167015814693126827433e+21', '1014516701581469312682.74331704144237403051304691', 4, 0);
  t('14732742920.26', '14732742920.2685559974631997792773', 2, 0);
  t('-0.0000024396', '-0.00000243967419912877390787054052365115', 10, 0);
  t('-4.0652508739514080019583290078439950962271332e+32', '-406525087395140800195832900784399.5096227133214862156130351490', 11, 0);
  t('-1723979796', '-1723979796.36', 0, 0);
  t('5525', '5525.92', 0, 0);
  t('-3945747002551399578.343468', '-3945747002551399578.3434682661524331142116054134897040821632176778072415187', 6, 0);
  t('-2.7780232151171394619321317048575868086206929374e+47', '-277802321511713946193213170485758680862069293740.394536021', 0, 0);
  t('20009625230484826.12356005', '20009625230484826.1235600500135', 8, 0);
  t('44880369477378.33', '44880369477378.33683988', 2, 0);
  t('-0.00002', '-0.00002070867117576', 5, 0);
  t('1603.77149385202', '1603.771493852020103076100922878498629488434386573975', 11, 0);
  t('0', '0.0017748129281851314125454440286334982408504523961975049886257367986777', 1, 0);
  t('-1550422', '-1550422.358', 0, 0);
  t('-4.5e-7', '-0.00000045650272822792696660021783625691968009108554171438878088264841794276932', 8, 0);
  t('4.1', '4.183503660', 1, 0);
  t('0.02108569', '0.021085698865677366047750841398199696262143401265150640671649097736218283', 8, 0);
  t('-3515707', '-3515707.1', 0, 0);
  t('-1199369298.5', '-1199369298.53062585030', 1, 0);
  t('184.31314', '184.31314737703995157395494440087062581441249', 5, 0);
  t('-1', '-1.9', 0, 0);
  t('-1.97e-7', '-0.00000019731724344543479845753700126009098771380157471239', 9, 0);
  t('0.13', '0.1330', 2, 0);
  t('0', '-0.170797860790707644741173067420215649184403', 0, 0);
  t('-1.058791456939305607808666099444175650225669395607895889843e+48', '-1058791456939305607808666099444175650225669395607.8958898438980228534', 9, 0);
  t('1.81471749893173114051685035838817192816002517e+44', '181471749893173114051685035838817192816002517.093', 0, 0);
  t('3', '3', 0, 0);
  t('-8210356329.8350248', '-8210356329.83502480092019', 7, 0);
  t('970309054384.7', '970309054384.7077624529925550266852265867852219138787709262', 2, 0);
  t('0', '0.001256084817082448822869563644416034044969297869311795367679024', 2, 0);
  t('-73253339269.00317', '-73253339269.003177874104876286563406', 5, 0);
  t('-0.0001095774', '-0.0001095774586911457858120030993374571566809707128377023326606794', 10, 0);
  t('-4.06114936290035281747321715977579517e+30', '-4061149362900352817473217159775.79517553170363759', 5, 0);
  t('-177.759', '-177.7597', 3, 0);
  t('-9689136821930366.362039', '-9689136821930366.3620393296962009031', 6, 0);
  t('0', '-0.00000026610962684697676312450579756507', 1, 0);
  t('4.173e-7', '0.0000004173202906218834631', 10, 0);
  t('645158009697.975', '645158009697.9756067861', 3, 0);
  t('3.9930686135370805999397805041e+29', '399306861353708059993978050410.3192', 0, 0);
  t('-4.50555959338720252810716307358365213830134e+41', '-450555959338720252810716307358365213830134.6935', 0, 0);
  t('5.8362109268073045818954628434687849525599077754e+45', '5836210926807304581895462843468784952559907775.409', 1, 0);
  t('-0.0162077', '-0.01620770', 7, 0);
  t('-22.43', '-22.437', 2, 0);
  t('1829830.38527', '1829830.3852727457818890034794051195', 5, 0);
  t('-4042', '-4042.3', 0, 0);
  t('-1.543e-7', '-0.000000154314412587363247204811405157772723', 10, 0);
  t('-108219527.2', '-108219527.2753825142493880175762918722366497565062990963579193260442', 1, 0);
  t('-6693837', '-6693837.34', 0, 0);
  t('181889127.62828662692', '181889127.628286626927713395304', 11, 0);
  t('143519501512857845', '143519501512857845.52745932333494473744528867459573671281622423730632325', 0, 0);
  t('-2.97840471795764585085100568390504009e+28', '-29784047179576458508510056839.05040099963416337672436', 7, 0);
  t('0.0004729', '0.0004729742140402031262663950013870098613', 7, 0);
  t('6.027491580728751445977097297364913829146e+31', '60274915807287514459770972973649.138291469484', 8, 0);
  t('-2974205108472984.0187894994', '-2974205108472984.0187894994152562247', 10, 0);
  t('0', '0.00000003009610991086645054308592280317853547678789030319098478950', 4, 0);
  t('4.03012103930395941348059491e+26', '403012103930395941348059491.9180', 0, 0);
  t('-0.1393983138', '-0.13939831384897888129257340318652092887944119864399281284907491225104465342', 10, 0);
  t('1011149900.5282', '1011149900.5282077336421015157519567471045463775066283923', 5, 0);
  t('8757', '8757.3748738406897702852206883331108562', 0, 0);
  t('0', '-0.00000003416534537494286', 5, 0);
  t('10602062556447038.062767923', '10602062556447038.0627679235875283817418323', 9, 0);
  t('-257086.4', '-257086.4828724867962888260166020699520935110804', 1, 0);
  t('572159505468186.77378', '572159505468186.7737880713875315207454289441416743', 5, 0);
  t('7530.1229589115', '7530.1229589115753760123793226226265', 10, 0);
  t('-8872964877907125.83663224', '-8872964877907125.836632242339819051886008', 8, 0);
  t('2.135649501653429583982578779007e+23', '213564950165342958398257.877900795456', 7, 0);
  t('104474530', '104474530.59968725243197049730531512711173143221249334644382', 0, 0);
  t('5602949', '5602949.19574', 0, 0);
  t('-4.7019643514874636942057482628125287e+33', '-4701964351487463694205748262812528.779706941940756897', 1, 0);
  t('-1.496261933510554322547529229678085544700407e+34', '-14962619335105543225475292296780855.4470040706000838466800380657384201941388', 8, 0);
  t('-3341205218116868.231958233', '-3341205218116868.23195823366593974408576984756959338338', 9, 0);
  t('-9.5528', '-9.55286496837663', 4, 0);
  t('-171362.48', '-171362.48491', 2, 0);
  t('230352589.6893', '230352589.689308254079219490583', 4, 0);
  t('2.967567462870573188997043463715161944631486206865763e+47', '296756746287057318899704346371516194463148620686.5763165070566684812', 4, 0);
  t('-81.9731037493', '-81.97310374930414353', 11, 0);
  t('0', '-0.000001364895713381179229228129', 4, 0);
  t('-0.0064456035', '-0.006445603540385205399', 10, 0);
  t('0.5357', '0.53570153071612836', 5, 0);
  t('-0.000073283', '-0.000073283335116091089788268013822581929607077220801606989298113096', 9, 0);
  t('0', '0.00115208912639663390043073006446847154309286519', 2, 0);
  t('-53231893.3', '-53231893.3768667511787779872401690753646608375', 1, 0);
  t('55.53', '55.53793629', 2, 0);
  t('6326591924581951.226410656', '6326591924581951.2264106560290992', 10, 0);
  t('493707390.18', '493707390.18624460056971050831646', 2, 0);
  t('-13827742.1165809042', '-13827742.116580904208679321874576115091', 11, 0);
  t('314697175.2272149', '314697175.22721493131154', 7, 0);
  t('1.05892136737591133155235384190575784e+31', '10589213673759113315523538419057.57849396617692150181', 4, 0);
  t('0.15956', '0.159565725056306032039912920289953', 5, 0);
  t('-3.488895423328733482554502771e+22', '-34888954233287334825545.027710099059496511784329', 6, 0);
  t('-1.609819', '-1.6098196859', 6, 0);
  t('-975983.96922718323', '-975983.969227183233', 11, 0);
  t('-0.0141935', '-0.01419356410', 7, 0);
  t('84880122612.770782', '84880122612.770782013755', 7, 0);
  t('-0.0000178', '-0.00001786452390451', 7, 0);
  t('-1.3798798327631376188186773982e+27', '-1379879832763137618818677398.22414462933821716', 1, 0);
  t('-2.245402865590056643557523753833e+29', '-224540286559005664355752375383.32978492325792324672', 1, 0);
  t('-8315.1468', '-8315.1468630503641630807897537632482126986782838279069296070041015502607', 4, 0);
  t('0', '-0.0000000838211740920556261299830093531772078', 2, 0);
  t('-0.0416876582', '-0.041687658284091671374555836402610898955125740095273786', 10, 0);
  t('7.65815382418113814779861743921190243765657354981e+45', '7658153824181138147798617439211902437656573549.8183', 2, 0);
  t('0.02767389', '0.0276738904494591599704336', 8, 0);
  t('-5.4185550099080522233510156701024301728125270723e+39', '-5418555009908052223351015670102430172812.52707235037987', 7, 0);
  t('-1899149827', '-1899149827.82514', 0, 0);
  t('0.7955483', '0.79554834141083', 7, 0);
  t('8154781528705858888', '8154781528705858888.9755625442951128673075040254267', 0, 0);
  t('-3803', '-3803.73898144337426131695504756056366905080520143458631028393761802679372', 0, 0);
  t('3.025641505907837351766241552783840055348710559239450674782e+55', '30256415059078373517662415527838400553487105592394506747.8290423981807724122', 2, 0);
  t('2.13711849954694553100660878052886279077189600979e+41', '213711849954694553100660878052886279077189.60097919245167946502003', 6, 0);
  t('-7.0745670674096135006113419526707798056656926944e+46', '-70745670674096135006113419526707798056656926944.21', 0, 0);
  t('-15229799310101156.043667205', '-15229799310101156.04366720568297383189340788345705720764931939894579214', 9, 0);
  t('-0.04402792', '-0.0440279252399474662093512884982084310150480290636938800967448604460967483', 8, 0);
  t('-250047500.21', '-250047500.21005', 3, 0);
  t('-0.027', '-0.02708', 3, 0);
  t('-491', '-491.5737', 0, 0);
  t('769007.341147', '769007.34114777', 6, 0);

  t('4', '3.54', 0, 1);
  t('9.469329375', '9.4693293752', 9, 1);
  t('-0.00001', '-0.0000123411488', 5, 1);
  t('-245', '-245.39', 0, 1);
  t('15798541.64', '15798541.6399048', 2, 1);
  t('0.001', '0.00091997', 3, 1);
  t('2272', '2271.52', 0, 1);
  t('35', '35.23', 0, 1);
  t('-683818066864', '-683818066864.1', 0, 1);
  t('10933231', '10933230.697', 0, 1);
  t('5.2609', '5.260857', 4, 1);
  t('0.000008', '0.000007821', 6, 1);
  t('0.0000491', '0.00004910447048', 8, 1);
  t('12186', '12186.0', 0, 1);
  t('21', '20.9', 0, 1);
  t('3825954', '3825954.03', 0, 1);
  t('118288288.5', '118288288.46', 1, 1);
  t('1125779', '1125779.2', 0, 1);
  t('-1.734', '-1.7341669', 3, 1);
  t('0', '0.000000459562', 4, 1);
  t('16.592754', '16.59275402', 7, 1);
  t('-28.25', '-28.251', 2, 1);
  t('5099463.3', '5099463.33', 1, 1);
  t('-0.001', '-0.00104', 4, 1);
  t('-287109280612', '-287109280612.15', 0, 1);
  t('-2', '-1.758', 0, 1);
  t('-6', '-6', 0, 1);
  t('-21.276619', '-21.2766193', 6, 1);
  t('1', '1', 0, 1);
  t('-144', '-143.53', 0, 1);
  t('-3.2', '-3.159', 1, 1);
  t('-3', '-3.34', 0, 1);
  t('12497685.01731', '12497685.0173061', 5, 1);
  t('8889.428', '8889.42787', 3, 1);
  t('0', '-0.00000001830584505', 2, 1);
  t('3598678', '3598677.7', 0, 1);
  t('-41', '-40.90742', 0, 1);
  t('0', '0', 0, 1);
  t('2021953.19', '2021953.18947', 2, 1);
  t('2', '2', 0, 1);
  t('-12', '-12.125', 0, 1);
  t('-2', '-2.2', 0, 1);
  t('-2115', '-2115.00054', 0, 1);
  t('0.134', '0.13369', 3, 1);
  t('-38', '-38.38', 0, 1);
  t('0.42145318', '0.4214531777643', 8, 1);
  t('0', '-0.0001878654916842', 3, 1);
  t('741', '741.04', 1, 1);
  t('3606', '3605.93', 0, 1);
  t('-544', '-544.1', 0, 1);
  t('-3809', '-3808.737', 0, 1);
  t('3951799', '3951798.7', 0, 1);
  t('2799.97', '2799.9674', 2, 1);
  t('47333.42', '47333.4176', 2, 1);
  t('-55.924280361', '-55.92428036145', 9, 1);
  t('-0.000001', '-0.00000052824264', 6, 1);
  t('8090504333', '8090504333.3', 0, 1);
  t('-1', '-1', 0, 1);
  t('-230049481', '-230049480.590878', 0, 1);
  t('0', '-0.00000001200602888520', 0, 1);
  t('0', '0.000000099', 3, 1);
  t('45556093.78', '45556093.7798', 2, 1);
  t('-401.4', '-401.401', 1, 1);
  t('-44571', '-44570.52', 0, 1);
  t('1243358.922', '1243358.921638', 3, 1);
  t('11494.70637742', '11494.706377423', 8, 1);
  t('-874.7', '-874.704544', 1, 1);
  t('-24401396920', '-24401396920.00', 1, 1);
  t('-4', '-4', 0, 1);
  t('0.383788308', '0.38378830829645', 9, 1);
  t('122', '122.23', 0, 1);
  t('0', '0.0014', 2, 1);
  t('-289508.068', '-289508.06805116', 3, 1);
  t('59.3', '59.265', 1, 1);
  t('0', '-0.0000002026086826898', 1, 1);
  t('0', '-0.11', 0, 1);
  t('0', '0.000000047207', 2, 1);
  t('0', '0.000000434103949485954', 5, 1);
  t('-37065', '-37065.1171', 0, 1);
  t('0', '-0.000031', 0, 1);
  t('-82998.083585', '-82998.0835851', 6, 1);
  t('323933.4', '323933.420', 1, 1);
  t('-9', '-9', 0, 1);
  t('-2172', '-2172.3', 0, 1);
  t('-60690.7132', '-60690.713158', 4, 1);
  t('-24642', '-24642.1', 0, 1);
  t('0', '0.007112335', 0, 1);
  t('0.1594031', '0.159403096880', 8, 1);
  t('-4160', '-4160.351', 0, 1);
  t('-2', '-1.705', 0, 1);
  t('50634015', '50634015.2824', 0, 1);
  t('-3339', '-3338.7', 0, 1);
  t('-67.7', '-67.668902665', 1, 1);
  t('-154279.4526', '-154279.452649', 4, 1);
  t('-1.168', '-1.16773', 3, 1);
  t('365', '365.08', 0, 1);
  t('-20', '-19.6', 0, 1);
  t('1.58', '1.5776', 2, 1);
  t('-8.25', '-8.248', 2, 1);
  t('-0.04581', '-0.0458084604321', 5, 1);
  t('117389', '117388.6', 0, 1);
  t('212.065', '212.06493', 3, 1);
  t('0', '0', 0, 1);
  t('29.4', '29.3577', 1, 1);
  t('3685491.07096', '3685491.07096275', 5, 1);
  t('0', '-0.00000011', 4, 1);
  t('-1', '-1', 0, 1);
  t('-13950.078', '-13950.07841', 3, 1);
  t('1.4e-7', '0.000000140308463652314', 9, 1);
  t('-11428646', '-11428645.8', 0, 1);
  t('0.0223918', '0.0223917956214', 7, 1);
  t('32.7904', '32.79037393', 4, 1);
  t('-14', '-14.299', 0, 1);
  t('6586.89603', '6586.896032', 5, 1);
  t('-5', '-5.038658', 1, 1);
  t('0.0317341185', '0.03173411854312', 10, 1);
  t('0', '-0.0000000487', 0, 1);
  t('-0.0345', '-0.03449922', 5, 1);
  t('-17', '-16.59', 0, 1);
  t('2', '1.5', 0, 1);
  t('48518.42', '48518.4152', 2, 1);
  t('-5001', '-5000.96', 0, 1);
  t('1.725e-7', '0.0000001725037994167', 11, 1);
  t('603', '603.0', 0, 1);
  t('88353.4724', '88353.47237057', 4, 1);
  t('332.16464', '332.16463927', 5, 1);
  t('-32417545529', '-32417545528.9', 0, 1);
  t('1.27', '1.2748049', 2, 1);
  t('-182998', '-182998.2', 0, 1);
  t('-432', '-431.53', 0, 1);
  t('3384', '3383.5', 0, 1);
  t('0', '0', 0, 1);
  t('-0.00038305', '-0.0003830543', 8, 1);
  t('0', '0.0000000557126451001', 5, 1);
  t('117564754', '117564753.54747', 0, 1);
  t('-1', '-1.40', 0, 1);
  t('7.9', '7.923121', 1, 1);
  t('0', '0.00000054132', 5, 1);
  t('-0.07958882602', '-0.07958882601561', 11, 1);
  t('1', '1.2', 0, 1);
  t('-3', '-3', 0, 1);
  t('8', '7.7', 0, 1);
  t('-71.7', '-71.71', 1, 1);
  t('-728', '-728.46', 0, 1);
  t('1', '1.4', 0, 1);
  t('-1', '-1.35', 0, 1);
  t('3', '3', 0, 1);
  t('-8', '-7.6', 0, 1);
  t('25', '25.0', 0, 1);
  t('-233815', '-233814.57', 0, 1);
  t('0', '0.000070465023556944', 2, 1);
  t('-47', '-47.253', 0, 1);
  t('6052', '6052.0', 0, 1);
  t('8.059', '8.058982', 3, 1);
  t('4079021608', '4079021608.24', 0, 1);
  t('-4', '-3.8', 0, 1);
  t('-1493.68', '-1493.68006', 3, 1);
  t('36252.56', '36252.5563', 2, 1);
  t('-30537452.369', '-30537452.3689598', 4, 1);
  t('3', '2.8', 0, 1);
  t('0', '-0.000002949', 1, 1);
  t('-9', '-8.7', 0, 1);
  t('1e-8', '0.0000000116199', 8, 1);
  t('-0.0230056', '-0.02300560354353', 7, 1);
  t('-0.01714', '-0.01714395921115', 5, 1);
  t('8.17', '8.174653754', 2, 1);
  t('9', '9', 0, 1);
  t('1337', '1337.29', 0, 1);
  t('0.105', '0.105175', 3, 1);
  t('0.0275', '0.027464', 4, 1);
  t('-11', '-10.5', 0, 1);
  t('-71', '-71.2', 0, 1);
  t('77510.70416', '77510.704160068', 6, 1);
  t('-162', '-161.6707', 0, 1);
  t('0', '0', 0, 1);
  t('-0.001037464', '-0.001037464042', 10, 1);
  t('84', '83.8', 0, 1);
  t('-0.00592135', '-0.005921353', 8, 1);
  t('7', '6.99', 0, 1);
  t('0', '0.0000049', 1, 1);
  t('-7', '-6.51', 0, 1);
  t('-5.5131360655', '-5.51313606545899', 10, 1);
  t('-0.0001', '-0.0000751', 4, 1);
  t('-104.1', '-104.1261', 1, 1);
  t('-1', '-1.3', 0, 1);
  t('-23673', '-23672.63', 0, 1);
  t('-284889898', '-284889898.042415', 0, 1);
  t('1', '1.196', 0, 1);
  t('-1', '-1', 0, 1);
  t('28458387', '28458386.54337', 0, 1);
  t('-1160674293', '-1160674292.62', 0, 1);
  t('-0.000255348', '-0.0002553481995', 9, 1);
  t('-130897.86507', '-130897.865070415', 5, 1);
  t('0.01', '0.00636836', 2, 1);
  t('695862', '695861.98280567', 1, 1);
  t('17', '17.25', 0, 1);
  t('0', '0.026', 0, 1);
  t('3212075.025', '3212075.02501', 3, 1);
  t('4', '4', 0, 1);
  t('-1151', '-1150.8244355257', 0, 1);
  t('-8e-7', '-0.0000007534893580', 7, 1);
  t('3382', '3381.713', 0, 1);
  t('2e-7', '0.00000019647604646674', 8, 1);
  t('0', '0', 0, 1);
  t('9008915726', '9008915725.5231', 0, 1);
  t('-0.00001', '-0.0000096379', 5, 1);
  t('6.72', '6.721', 2, 1);
  t('2136.074', '2136.073710', 3, 1);
  t('0.00605847', '0.006058471', 8, 1);
  t('-292', '-292.1', 0, 1);
  t('0', '-0.000000139814030017060', 4, 1);
  t('13754822793593', '13754822793592.9', 0, 1);
  t('-179980965', '-179980964.61363', 0, 1);
  t('-29', '-28.51', 0, 1);
  t('698.80091', '698.8009100925', 6, 1);
  t('-8.1187', '-8.11873', 4, 1);
  t('1602.33', '1602.32753', 2, 1);
  t('-15', '-14.99', 0, 1);
  t('-5', '-4.5', 0, 1);
  t('-0.000005', '-0.00000545', 6, 1);
  t('0', '0', 0, 1);
  t('0', '0.00100', 1, 1);
  t('0.2', '0.2003034', 1, 1);
  t('105.41', '105.4104', 2, 1);
  t('1', '1.4', 0, 1);
  t('0', '-0.000050930947634381', 3, 1);
  t('7.48139', '7.481390', 5, 1);
  t('17090.1', '17090.140748', 1, 1);
  t('1', '1', 0, 1);
  t('-9', '-9.42', 0, 1);
  t('2', '1.673', 0, 1);
  t('1885.1', '1885.063', 1, 1);
  t('-1', '-1', 0, 1);
  t('357.4774', '357.477414', 4, 1);
  t('-1.327', '-1.32675724197', 3, 1);
  t('-0.00011277', '-0.000112772492448619', 8, 1);
  t('-2', '-2', 0, 1);
  t('0.15', '0.1546', 2, 1);
  t('35', '35.3', 0, 1);
  t('763177.3511', '763177.3511416', 4, 1);
  t('-3.70037', '-3.70037205114696', 5, 1);
  t('-3797014.351144', '-3797014.35114432', 6, 1);
  t('8.08', '8.07957', 3, 1);
  t('24384.3412', '24384.3412018', 5, 1);
  t('67.306832434', '67.3068324339', 9, 1);
  t('-4040528.764098', '-4040528.76409829', 6, 1);
  t('-1', '-1.01940037', 0, 1);
  t('0.0000512526', '0.00005125258015', 10, 1);
  t('-290889556', '-290889556.41', 0, 1);
  t('123', '123.01', 0, 1);
  t('-2', '-2.3', 0, 1);
  t('-34811.594', '-34811.59385', 3, 1);
  t('0', '-0.0000005950445', 4, 1);
  t('0', '-0.00000082', 0, 1);
  t('6', '6.3', 0, 1);
  t('0', '0', 0, 1);
  t('1.68157826653', '1.6815782665335', 11, 1);
  t('-2837.586', '-2837.58566843817', 3, 1);
  t('8416.064', '8416.06355596086', 3, 1);
  t('0', '0.00000236731', 5, 1);
  t('-26125699736', '-26125699736.353', 0, 1);
  t('18959.6', '18959.611157', 1, 1);
  t('1', '1', 0, 1);
  t('-153', '-152.64414243011', 0, 1);
  t('45', '44.7', 0, 1);
  t('0', '0.285', 0, 1);
  t('0', '0', 0, 1);
  t('522.0525552', '522.0525552014', 7, 1);
  t('246398', '246398.1013', 0, 1);
  t('-4.70615764', '-4.7061576418', 8, 1);
  t('-0.021', '-0.0213884', 3, 1);
  t('2513257', '2513257.0', 0, 1);
  t('2', '2.018', 0, 1);
  t('30.62311', '30.6231080', 5, 1);
  t('-11', '-10.8', 0, 1);
  t('5800384499', '5800384498.51', 0, 1);
  t('0', '0.00017579381086966', 0, 1);
  t('657004656', '657004656.1', 0, 1);
  t('-35', '-34.6', 0, 1);
  t('21404600819', '21404600819.44', 0, 1);
  t('349.5', '349.507', 1, 1);
  t('-2.7', '-2.71078800784', 1, 1);
  t('1', '1.0', 0, 1);
  t('4.10089', '4.10089097', 5, 1);
  t('-2', '-2', 0, 1);
  t('-202', '-202.3', 0, 1);
  t('1767', '1766.741', 0, 1);
  t('82.466061', '82.46606111510', 6, 1);
  t('0.008', '0.008015', 3, 1);
  t('16.9', '16.8951', 2, 1);
  t('4', '4.4', 0, 1);
  t('-12139', '-12139.4', 0, 1);
  t('1123.228', '1123.22775794', 3, 1);
  t('0', '0', 0, 1);
  t('0', '-0.015', 0, 1);
  t('-38', '-37.79829', 0, 1);
  t('-34', '-34.1', 0, 1);
  t('0', '0', 0, 1);
  t('0.10602', '0.10601990', 6, 1);
  t('2', '2', 0, 1);
  t('0', '-0.00000006432774459198', 4, 1);
  t('0.4', '0.39537509450253', 2, 1);
  t('0.01', '0.011214357', 2, 1);
  t('0', '0.0005905773', 0, 1);
  t('253647.4208', '253647.42081', 4, 1);
  t('-33.39', '-33.388186842', 2, 1);
  t('-0.005', '-0.00504754237505', 3, 1);
  t('0', '0.0017685649868078', 2, 1);
  t('-3', '-2.964957', 1, 1);
  t('1212124629', '1212124629.2', 0, 1);
  t('2858', '2857.54', 0, 1);
  t('625', '624.7', 0, 1);
  t('-3916620', '-3916619.9775', 0, 1);
  t('30.6', '30.5902', 1, 1);
  t('11834.705', '11834.70498', 3, 1);
  t('0', '0', 0, 1);
  t('-3773880428', '-3773880428.05', 0, 1);
  t('-0.000001', '-0.0000005856634', 6, 1);
  t('0.0005', '0.00049843937125', 4, 1);
  t('-442', '-442.4', 0, 1);
  t('386', '385.98', 0, 1);
  t('5819920498', '5819920497.9', 0, 1);
  t('-46791.40369', '-46791.4036938', 5, 1);
  t('0', '0.00000125362', 1, 1);
  t('75148', '75147.57', 0, 1);
  t('4e-8', '0.000000040010', 9, 1);
  t('-153', '-152.56', 0, 1);
  t('-117629583.114', '-117629583.11409', 3, 1);
  t('7594.3', '7594.251', 1, 1);
  t('2', '1.594', 0, 1);
  t('6', '5.9', 0, 1);
  t('-4.1', '-4.105626', 1, 1);
  t('0', '-0.0000015417', 4, 1);
  t('3.3', '3.26', 1, 1);
  t('-221647.193', '-221647.1931266', 3, 1);
  t('-6', '-6', 0, 1);
  t('-7449.38', '-7449.37982840', 3, 1);
  t('-0.0248', '-0.02475807590', 4, 1);
  t('-149481', '-149481.0', 0, 1);
  t('11', '10.8', 0, 1);
  t('1', '1', 0, 1);
  t('0', '0', 0, 1);
  t('1778.86324386', '1778.8632438600', 8, 1);
  t('114', '113.55', 0, 1);
  t('-8', '-8.2', 0, 1);
  t('-302', '-301.550001962', 0, 1);
  t('9387795', '9387794.6', 0, 1);
  t('-1', '-1.08980', 0, 1);
  t('-1705229.851', '-1705229.85058600', 3, 1);
  t('-0.0000033', '-0.0000032605738', 7, 1);
  t('275467468', '275467468.18013', 0, 1);
  t('-598', '-597.51', 0, 1);
  t('-156', '-155.80', 0, 1);
  t('-356', '-356.2300', 0, 1);
  t('-2456.55', '-2456.5548', 2, 1);
  t('50.7', '50.68557486224', 1, 1);
  t('-17014379.8342', '-17014379.834214', 4, 1);
  t('11.2395', '11.23949375', 4, 1);
  t('-7', '-6.8', 0, 1);
  t('-7', '-7.0', 0, 1);
  t('-19115.826', '-19115.82586923', 3, 1);
  t('344958.07', '344958.07497121', 2, 1);
  t('3167.5417', '3167.54171', 4, 1);
  t('-2119.391', '-2119.39075', 3, 1);
  t('-26336.3', '-26336.284', 1, 1);
  t('0', '-0.0028819832496059', 0, 1);
  t('683027', '683027.49662710', 0, 1);
  t('0', '-0.01696979', 1, 1);
  t('-0.0000153521', '-0.000015352093', 10, 1);
  t('0', '-0.00000059', 5, 1);
  t('0', '-0.000000108630053168', 4, 1);
  t('3', '2.8', 0, 1);
  t('0', '-0.0574', 0, 1);
  t('0', '0.00000048434', 3, 1);
  t('72', '72.0563438327', 0, 1);
  t('-16003037', '-16003037.3', 0, 1);
  t('3055.3', '3055.321', 1, 1);
  t('-2', '-2', 0, 1);
  t('207928569', '207928568.877', 0, 1);
  t('0.00122847', '0.00122847183', 8, 1);
  t('-159442', '-159442.45', 0, 1);
  t('-564018', '-564017.60', 0, 1);
  t('0.0004064', '0.0004063768', 7, 1);
  t('0', '-0.00000107578', 0, 1);
  t('-7e-7', '-0.0000007033082032', 7, 1);
  t('1', '1', 0, 1);
  t('-16192390.6856', '-16192390.685644', 4, 1);
  t('189', '188.508', 0, 1);
  t('-0.000001938', '-0.00000193843231', 9, 1);
  t('-917365.61922217', '-917365.619222172', 8, 1);
  t('33.77562', '33.775620223', 5, 1);
  t('549361', '549360.583612', 0, 1);
  t('0', '0.000033771', 1, 1);
  t('1', '1.1', 0, 1);
  t('0.00128028', '0.001280277', 8, 1);
  t('-75794.07', '-75794.07428', 2, 1);
  t('274278258209', '274278258208.65', 0, 1);
  t('1821', '1820.7', 0, 1);
  t('2.1437329601', '2.14373296009861', 11, 1);
  t('-73602905270', '-73602905269.79', 0, 1);
  t('0', '0.000000047', 7, 1);
  t('0', '-0.0000454008553081', 1, 1);
  t('1202.03', '1202.02784', 2, 1);
  t('-204745093', '-204745093.149', 0, 1);
  t('0.15143502', '0.1514350178', 8, 1);
  t('-2.8', '-2.753', 1, 1);
  t('-1.96046619', '-1.9604661896', 8, 1);
  t('107244555.3', '107244555.29808', 2, 1);
  t('310106298', '310106298.2', 0, 1);
  t('2574227639', '2574227638.973', 0, 1);
  t('-0.71332', '-0.7133198793', 5, 1);
  t('-9', '-9.307339', 0, 1);
  t('-5e-8', '-0.00000005035516793', 9, 1);
  t('1754538.0548', '1754538.054780', 4, 1);
  t('3', '2.53', 0, 1);
  t('3800509207', '3800509207.05', 0, 1);
  t('-0.09', '-0.0862263', 2, 1);
  t('3', '2.7', 0, 1);
  t('-712', '-711.7', 0, 1);
  t('0.495', '0.495022', 3, 1);
  t('19.6278', '19.627796', 5, 1);
  t('-919', '-919.2', 0, 1);
  t('-1', '-1', 0, 1);
  t('-1289', '-1289.00020552', 2, 1);
  t('1630500.34744', '1630500.347435', 5, 1);
  t('0', '-0.000054042861262', 2, 1);
  t('0', '0.000029500146408', 2, 1);
  t('0', '-0.00000002030148260', 3, 1);
  t('34', '33.71', 0, 1);
  t('5', '5.3', 0, 1);
  t('0', '-0.0003208256', 0, 1);
  t('-113.9191', '-113.919080', 4, 1);
  t('28', '27.50', 0, 1);
  t('75', '74.73', 0, 1);
  t('2892.79', '2892.7902130', 2, 1);
  t('384', '384.0040452', 0, 1);
  t('-1', '-1.2622', 0, 1);
  t('-2', '-1.75618', 0, 1);
  t('1444', '1443.6', 0, 1);
  t('-11', '-10.64424', 0, 1);
  t('0', '-0.0001113', 2, 1);
  t('-2', '-2.35', 0, 1);
  t('275.5', '275.498', 1, 1);
  t('0', '-0.0000207139508', 2, 1);
  t('-1077', '-1077.18', 0, 1);
  t('-5', '-5', 0, 1);
  t('2.1336', '2.1335903', 4, 1);
  t('0.00000111', '0.00000110529701', 8, 1);
  t('2', '2', 0, 1);
  t('-5447.148', '-5447.14813', 3, 1);
  t('1665584192005', '1665584192004.9', 0, 1);
  t('6', '5.9', 0, 1);
  t('-0.077401', '-0.07740113239', 6, 1);
  t('1', '1', 0, 1);
  t('0', '0', 0, 1);
  t('1454.2', '1454.20728', 1, 1);
  t('0', '-0.000190882119683', 3, 1);
  t('-6', '-6', 0, 1);
  t('-865267397666.5', '-865267397666.486', 1, 1);
  t('-1', '-1.2', 0, 1);
  t('-134211958.607', '-134211958.6072', 3, 1);
  t('-0.21207728037', '-0.21207728036525', 11, 1);
  t('71135.5558', '71135.55576459', 4, 1);
  t('386265132.455', '386265132.4551', 3, 1);
  t('778233889', '778233888.5311', 0, 1);
  t('0.000719', '0.0007189512437178', 7, 1);
  t('0', '0.0000171', 3, 1);
  t('-410994', '-410993.83', 0, 1);
  t('0', '0', 0, 1);
  t('0.00000441', '0.00000440527', 8, 1);
  t('0', '0', 0, 1);
  t('0.1662581', '0.16625812962245', 7, 1);
  t('-11.696829', '-11.6968294515', 6, 1);
  t('1.361', '1.3612841282', 3, 1);
  t('-336185', '-336184.61', 0, 1);
  t('-122', '-121.8', 0, 1);
  t('620.39', '620.3909', 2, 1);
  t('-0.91', '-0.9105636', 2, 1);
  t('0', '0.034', 0, 1);
  t('769', '769.1', 0, 1);
  t('526.29', '526.29171618', 2, 1);
  t('0.1', '0.116916674', 1, 1);
  t('-3', '-3.0', 0, 1);
  t('-2021000', '-2020999.5', 0, 1);
  t('5', '5', 0, 1);
  t('-7', '-6.82842', 0, 1);
  t('18642.374', '18642.374031', 4, 1);
  t('0.001623', '0.0016232841612', 6, 1);
  t('0.00007', '0.0000704', 5, 1);
  t('-1884042142', '-1884042142.3', 0, 1);
  t('1.00467076', '1.004670762', 8, 1);
  t('8', '8', 0, 1);
  t('-3', '-3', 0, 1);
  t('77', '76.8614', 0, 1);
  t('-35', '-34.61', 0, 1);
  t('0.00005', '0.000045472900016655', 5, 1);
  t('9543', '9542.76576', 0, 1);
  t('0.32221017', '0.32221016668', 8, 1);
  t('35.8', '35.806', 1, 1);
  t('-14234918948', '-14234918947.7', 0, 1);
  t('-156.603862', '-156.60386225', 6, 1);
  t('-0.1', '-0.124', 1, 1);
  t('12284', '12283.5032', 0, 1);
  t('-10975.98', '-10975.9844', 2, 1);
  t('8', '7.575', 0, 1);
  t('-4.13461', '-4.134609080', 5, 1);
  t('179204391', '179204390.719054', 0, 1);
  t('-5.662e-7', '-0.0000005661820', 10, 1);
  t('380.537', '380.5370279291', 4, 1);
  t('-0.0010019', '-0.00100193', 7, 1);
  t('-0.0000122', '-0.000012165594', 7, 1);
  t('943546.71327', '943546.713265', 5, 1);
  t('-2669453.3', '-2669453.345', 1, 1);
  t('0', '0.004864560344', 0, 1);
  t('0', '0', 0, 1);
  t('0', '0', 0, 1);
  t('9', '9', 0, 1);
  t('-0.1493', '-0.14926753011132', 4, 1);
  t('3897025593.357', '3897025593.3573', 3, 1);
  t('-37', '-37.4', 0, 1);
  t('46', '46.3', 0, 1);
  t('20.6', '20.550', 1, 1);
  t('1680', '1680.17658', 0, 1);
  t('607.2', '607.24238', 1, 1);
  t('0', '-0.0000268383808', 4, 1);
  t('-425', '-424.590', 0, 1);
  t('15.5', '15.504414', 1, 1);
  t('-4464038280', '-4464038280.1', 0, 1);
  t('-4', '-3.6844471', 0, 1);
  t('1', '1', 0, 1);
  t('-11.8635530882', '-11.863553088174', 10, 1);
  t('139', '138.7558620', 0, 1);
  t('-80538.44', '-80538.435066403', 2, 1);
  t('1', '1', 0, 1);
  t('-2666311731291', '-2666311731291.1', 0, 1);
  t('2', '2.31', 0, 1);
  t('64643770', '64643770.19', 0, 1);
  t('-19.56', '-19.56215', 2, 1);
  t('-0.000035525', '-0.00003552532514', 9, 1);
  t('9', '9.27', 0, 1);
  t('-7415.88', '-7415.87912', 2, 1);
  t('-316220238.7', '-316220238.72', 1, 1);
  t('0', '0.0115691059', 0, 1);
  t('60.8', '60.81', 1, 1);
  t('2', '1.8', 0, 1);
  t('-1224373557.72', '-1224373557.72346', 2, 1);
  t('0', '0.006564652', 0, 1);
  t('-1183009315275', '-1183009315274.74', 0, 1);
  t('-0.962', '-0.9620066507', 3, 1);
  t('5424049.3261', '5424049.3261228', 4, 1);
  t('2957265327.84', '2957265327.8373', 2, 1);
  t('-2', '-2.2', 0, 1);
  t('-26', '-25.99', 0, 1);
  t('-266.29018764', '-266.29018763899', 8, 1);
  t('75.689732', '75.6897322', 6, 1);
  t('188', '188.4', 0, 1);
  t('-349', '-348.79', 0, 1);
  t('-0.000003', '-0.0000030322124916', 7, 1);
  t('-309973085817', '-309973085816.91', 0, 1);
  t('-42.7', '-42.67490756', 1, 1);
  t('-75705485', '-75705485.3', 0, 1);
  t('0.00049132155', '0.0004913215513505', 11, 1);
  t('-106.24', '-106.24477', 2, 1);
  t('5', '4.64', 0, 1);
  t('0', '0.00024421', 3, 1);
  t('28659.74', '28659.74024', 3, 1);
  t('-149697181.5', '-149697181.47357', 1, 1);
  t('997', '997.1', 0, 1);
  t('-541', '-540.85693061', 0, 1);
  t('86', '86.1858325', 0, 1);
  t('3', '2.5', 0, 1);
  t('1', '1', 0, 1);
  t('-542', '-542.2', 0, 1);
  t('-1431.8924', '-1431.89244', 4, 1);
  t('0', '-0.000004896', 5, 1);
  t('49531304', '49531304.0', 0, 1);
  t('-10102.6665', '-10102.66645', 4, 1);
  t('65875', '65874.66', 0, 1);
  t('0.0023', '0.0022917848', 4, 1);
  t('1935365', '1935365.22', 0, 1);
  t('135733326.2', '135733326.1591', 1, 1);
  t('-0.0707371128', '-0.0707371127503952', 10, 1);
  t('0', '-0.00000142', 5, 1);
  t('-233036262.8', '-233036262.753067', 1, 1);
  t('2757.9', '2757.906', 1, 1);
  t('-427.2', '-427.2133', 1, 1);
  t('0', '0', 1, 1);
  t('-108737.43', '-108737.43024', 3, 1);
  t('146', '146.1', 0, 1);
  t('-2', '-1.583477702', 0, 1);
  t('-0.71474', '-0.7147426', 5, 1);
  t('-110342266440.2', '-110342266440.225', 1, 1);
  t('200212.8', '200212.777698349', 1, 1);
  t('-304', '-303.74', 0, 1);
  t('0.00001917', '0.0000191730', 8, 1);
  t('0', '0', 0, 1);
  t('-9', '-9', 0, 1);
  t('-18.663', '-18.66330', 3, 1);
  t('-2', '-1.907', 0, 1);
  t('0', '0.0000000203965335', 7, 1);
  t('-2', '-2.1', 0, 1);
  t('-3567227766911', '-3567227766910.6', 0, 1);
  t('-1573865.79336', '-1573865.7933632', 5, 1);
  t('0', '0.0488', 1, 1);
  t('-1', '-1.23', 0, 1);
  t('271', '271.21', 0, 1);
  t('19781', '19780.99', 0, 1);
  t('-0.0056', '-0.0056298804', 4, 1);
  t('1025931', '1025931.3', 0, 1);
  t('-3', '-3', 0, 1);
  t('-0.000449409', '-0.00044940932', 9, 1);
  t('0.00001136', '0.000011363008', 8, 1);
  t('7.2e-8', '0.000000071857073', 9, 1);
  t('156530.89', '156530.88737', 2, 1);
  t('40052', '40052.3', 0, 1);
  t('685705157', '685705157.1', 0, 1);
  t('0.012', '0.01193466', 3, 1);
  t('3696898.357', '3696898.3570351', 4, 1);
  t('-477186', '-477186.2', 0, 1);
  t('2.4', '2.43185', 1, 1);
  t('-20', '-19.60955', 0, 1);
  t('-669.4', '-669.360', 1, 1);
  t('3', '3', 0, 1);
  t('-8.351363', '-8.35136301', 6, 1);
  t('54561127852', '54561127852.3', 0, 1);
  t('16.6', '16.608', 1, 1);
  t('262', '262.433', 0, 1);
  t('-1379', '-1378.7221328', 0, 1);
  t('-5', '-5.09', 0, 1);
  t('0', '0.000003547', 1, 1);
  t('-0.005884', '-0.0058840863', 6, 1);
  t('-86669.6', '-86669.64', 1, 1);
  t('-3160538', '-3160537.9', 0, 1);
  t('0', '-0.0000002055499', 4, 1);
  t('-2.7', '-2.70201', 1, 1);
  t('0', '0', 0, 1);
  t('-2', '-2.3', 0, 1);
  t('0', '0.000000620171758', 5, 1);
  t('0', '-0.0045737044781', 2, 1);
  t('-6064679.7', '-6064679.701029', 2, 1);
  t('0', '-0.0000026439', 3, 1);
  t('47.46', '47.458425', 2, 1);
  t('-4.969e-8', '-0.000000049690', 11, 1);
  t('-10830688519.15', '-10830688519.1499', 3, 1);
  t('949637', '949636.6', 0, 1);
  t('158824226', '158824225.6', 0, 1);
  t('2046', '2045.9618', 1, 1);
  t('4', '4.3', 0, 1);
  t('0', '0.026593', 1, 1);
  t('0.855089', '0.855088838', 6, 1);
  t('-2.0981254126', '-2.09812541257', 10, 1);
  t('190', '190.20', 0, 1);
  t('0', '0', 0, 1);
  t('14484746413', '14484746412.809', 0, 1);
  t('7', '7.0', 0, 1);
  t('-115.75', '-115.7492209', 2, 1);
  t('23172876854.6', '23172876854.649', 1, 1);
  t('-5.4116e-7', '-0.00000054115736547', 11, 1);
  t('767576990', '767576990.4', 0, 1);
  t('6960', '6959.82', 0, 1);
  t('-811632.5249', '-811632.52490259', 4, 1);
  t('-72.879', '-72.878784', 3, 1);
  t('-11320.669', '-11320.66879647', 3, 1);
  t('0', '0', 0, 1);
  t('-0.015', '-0.0145205240695404', 3, 1);
  t('-457', '-457.04', 0, 1);
  t('0', '0', 0, 1);
  t('0', '-0.000000013081857748', 1, 1);
  t('1408763955', '1408763955.16', 0, 1);
  t('488.7651', '488.765079', 4, 1);
  t('-0.0007', '-0.000659', 4, 1);
  t('2', '2', 0, 1);
  t('-1.7', '-1.694', 1, 1);
  t('0', '-0.000000011514', 1, 1);
  t('24.05', '24.0464192', 2, 1);
  t('-2344335.93', '-2344335.92778', 2, 1);
  t('372717', '372716.9', 0, 1);
  t('5974', '5974.4', 0, 1);
  t('0', '0.000185812', 3, 1);
  t('386710062.02', '386710062.023', 2, 1);
  t('1968589867033', '1968589867032.95', 0, 1);
  t('4', '4.4', 0, 1);
  t('495791305', '495791305.04589', 0, 1);
  t('-84192051.9', '-84192051.8927', 1, 1);
  t('-130.9', '-130.93299058', 1, 1);
  t('-4', '-4.2', 0, 1);
  t('-519296', '-519295.5', 0, 1);
  t('243', '242.979552', 0, 1);
  t('-7', '-7', 0, 1);
  t('0', '0.0000060536747', 3, 1);
  t('71', '71.1', 0, 1);
  t('-323.8', '-323.8429505864', 1, 1);
  t('2.87556352', '2.875563522', 8, 1);
  t('-63046180.41', '-63046180.410407', 3, 1);
  t('0', '-0.00000027', 0, 1);
  t('83564', '83563.57717', 0, 1);
  t('1', '1', 0, 1);
  t('0', '0.00022535', 2, 1);
  t('7', '6.9', 0, 1);
  t('0', '-0.00042', 1, 1);
  t('0.0000016226', '0.00000162258', 10, 1);
  t('6', '6', 0, 1);
  t('-24656750', '-24656749.8', 0, 1);
  t('-4', '-4.1', 0, 1);
  t('0', '0', 0, 1);
  t('-4.3911231', '-4.39112307844', 7, 1);
  t('-54750.71661998', '-54750.716619979', 8, 1);
  t('-1256.1', '-1256.1232', 1, 1);
  t('-3', '-3', 0, 1);
  t('-3', '-2.8', 0, 1);
  t('0.093539', '0.093539384842', 6, 1);
  t('-0.08035759', '-0.080357592', 8, 1);
  t('-32.962', '-32.96185263111', 3, 1);
  t('0', '-0.001255', 1, 1);
  t('1271', '1270.6', 0, 1);
  t('-60823', '-60822.84374', 0, 1);
  t('-32299.7829', '-32299.7828637', 4, 1);
  t('9', '8.54', 0, 1);
  t('0.0017', '0.001703173', 5, 1);
  t('5148433662740', '5148433662739.80', 0, 1);
  t('-2388.07167', '-2388.071668', 5, 1);
  t('0', '-0.2139779365881', 0, 1);
  t('2955789058628', '2955789058627.9', 0, 1);
  t('-0.00011879', '-0.000118787975513795', 8, 1);
  t('-0.0156', '-0.01560295', 4, 1);
  t('-72925', '-72925.496', 0, 1);
  t('-0.6', '-0.60497', 1, 1);
  t('3', '2.646383445', 0, 1);
  t('5', '5', 0, 1);
  t('733990.9', '733990.92824161', 1, 1);
  t('-846', '-846.396', 0, 1);
  t('36708548', '36708548.322', 0, 1);
  t('0.00507', '0.0050707064636', 5, 1);
  t('-15', '-14.6', 0, 1);
  t('4', '4.49', 0, 1);
  t('33', '32.87', 0, 1);
  t('-18.1995848878', '-18.19958488777', 10, 1);
  t('0', '0.00000004118736618', 0, 1);
  t('465660955.77', '465660955.7698', 2, 1);
  t('2105671.9997', '2105671.99972582', 4, 1);
  t('0.4255077577', '0.42550775772', 10, 1);
  t('-178112', '-178111.9', 0, 1);
  t('-17', '-16.9', 0, 1);
  t('-6577867.32', '-6577867.32435442', 2, 1);
  t('-1.9', '-1.886', 1, 1);
  t('-5', '-5.24716', 0, 1);
  t('2', '1.837257', 0, 1);
  t('0', '-0.000202344', 2, 1);
  t('-0.0375', '-0.037548490', 4, 1);
  t('-19', '-19.02', 0, 1);
  t('-13207696039', '-13207696038.939', 0, 1);
  t('-5.9', '-5.913382', 1, 1);
  t('0', '0', 0, 1);
  t('2', '2.0', 0, 1);
  t('-1.448033', '-1.448032647880', 6, 1);
  t('-1', '-1', 0, 1);
  t('-159', '-158.7', 0, 1);
  t('50.79716', '50.7971630', 5, 1);
  t('0', '0.07632', 0, 1);
  t('986184', '986183.5', 0, 1);
  t('9', '9', 0, 1);
  t('-3114.504', '-3114.5043868', 3, 1);
  t('87802', '87801.7603237', 0, 1);
  t('0.0033', '0.00328654370742', 4, 1);
  t('51.98', '51.983123357948', 2, 1);
  t('-7', '-7', 0, 1);
  t('-2', '-1.571', 0, 1);
  t('0', '0', 0, 1);
  t('2801596', '2801596.0', 0, 1);
  t('0.00234', '0.0023350528619', 5, 1);
  t('-122', '-122.107', 0, 1);
  t('-3', '-3.36', 0, 1);
  t('-172', '-172.0', 0, 1);
  t('0.0032', '0.0032122465642733', 4, 1);
  t('3', '3', 0, 1);
  t('-25.4957', '-25.495733', 4, 1);
  t('-5e-7', '-0.000000499', 8, 1);
  t('-0.000001', '-0.0000005380105', 6, 1);
  t('-9.76e-7', '-0.000000975981503729640', 10, 1);
  t('0', '-0.000000070477667823983', 6, 1);
  t('71744', '71743.7', 0, 1);
  t('0', '0', 0, 1);
  t('95', '95.2', 0, 1);
  t('-0.01', '-0.01111683', 2, 1);
  t('5.03', '5.03281', 2, 1);
  t('0.8', '0.75779', 1, 1);
  t('0.001', '0.0006057', 3, 1);
  t('-2', '-2.31', 0, 1);
  t('0', '-0.00000056', 0, 1);
  t('0.000003', '0.000003294251178582', 6, 1);
  t('6619689722', '6619689721.6', 0, 1);
  t('0', '-0.00000001018341357041540', 3, 1);
  t('-10', '-9.874', 0, 1);
  t('69', '68.7074152722', 0, 1);
  t('1.2', '1.16', 1, 1);
  t('0', '0.00000014850981636', 6, 1);
  t('0.36157', '0.36157063', 5, 1);
  t('-0.0681', '-0.068115905086', 4, 1);
  t('-3', '-2.9', 0, 1);
  t('-3', '-3.0', 0, 1);
  t('0.01', '0.010156', 2, 1);
  t('0.11809', '0.118093', 5, 1);
  t('260130.08036', '260130.08035520', 5, 1);
  t('-3', '-3', 0, 1);
  t('43757924', '43757924.4', 0, 1);
  t('1021503432084.6', '1021503432084.62', 1, 1);
  t('-299', '-298.7', 0, 1);
  t('-6963749493.6', '-6963749493.6458', 1, 1);
  t('-174', '-174.19', 0, 1);
  t('298408', '298407.7', 0, 1);
  t('69316.45', '69316.446', 2, 1);
  t('0', '0.41096', 0, 1);
  t('-1357152', '-1357151.9', 0, 1);
  t('29.822731709', '29.82273170936', 9, 1);
  t('-1.3', '-1.270', 1, 1);
  t('6422.76', '6422.7577', 2, 1);
  t('9410320', '9410320.3', 0, 1);
  t('3', '3', 0, 1);
  t('-23359', '-23358.8559', 0, 1);
  t('-247.3', '-247.266', 1, 1);
  t('-2331', '-2331.063', 0, 1);
  t('-373439751221.1', '-373439751221.070', 1, 1);
  t('9.2', '9.196524', 2, 1);
  t('0', '0.0036554524385', 1, 1);
  t('0', '-0.00000063618822', 0, 1);
  t('-5', '-4.9', 0, 1);
  t('17', '17.2117810', 0, 1);
  t('1639293', '1639293.26', 0, 1);
  t('-0.253461', '-0.2534610319511', 7, 1);
  t('-23336833', '-23336833.23', 0, 1);
  t('-98776423.47', '-98776423.4662929', 2, 1);
  t('-568985020.026', '-568985020.0263', 3, 1);
  t('53.881', '53.8814996', 3, 1);
  t('789', '788.8', 0, 1);
  t('-0.0030614', '-0.003061380710', 7, 1);
  t('-5', '-5', 1, 1);
  t('1', '1.06', 0, 1);
  t('-2537823638', '-2537823637.5', 0, 1);
  t('-695603331.0329', '-695603331.03289', 4, 1);
  t('0', '0', 0, 1);
  t('6.3432', '6.3432491', 4, 1);
  t('75', '74.8158', 0, 1);
  t('-13', '-12.6', 0, 1);
  t('18.3', '18.308319', 1, 1);
  t('165654144811', '165654144810.883', 0, 1);
  t('4102', '4102.044757', 0, 1);
  t('1.8', '1.809', 1, 1);
  t('-298452487', '-298452487.1695', 0, 1);
  t('0.1', '0.053', 1, 1);
  t('-0.00008', '-0.000076', 5, 1);
  t('-447681', '-447681.37', 0, 1);
  t('-7', '-6.95', 0, 1);
  t('351', '350.9', 0, 1);
  t('3', '2.8', 0, 1);
  t('0', '0', 1, 1);
  t('31771920', '31771919.6412', 0, 1);
  t('1', '0.80', 0, 1);
  t('-4', '-4.1613', 0, 1);
  t('0', '0.00105', 2, 1);
  t('-61', '-60.6', 0, 1);
  t('-9768788109241', '-9768788109240.65', 0, 1);
  t('-1470.307877', '-1470.30787672', 6, 1);
  t('-0.0000157963', '-0.00001579626298', 10, 1);
  t('-23', '-22.9979140212', 1, 1);
  t('-6045846.1', '-6045846.08424', 1, 1);
  t('0', '-0.0000001962', 3, 1);
  t('-1.745e-8', '-0.000000017453524440675', 11, 1);
  t('0', '-0.000213', 2, 1);
  t('-3487156.6', '-3487156.607', 1, 1);
  t('2982.44', '2982.4384228', 2, 1);
  t('1', '1', 0, 1);
  t('0', '0.000000070148692065', 1, 1);
  t('145066', '145065.9572', 0, 1);
  t('9', '8.9', 0, 1);
  t('-1', '-1', 0, 1);
  t('-902.7', '-902.6736', 1, 1);
  t('-780', '-779.6', 0, 1);
  t('0', '-0.393186057405', 0, 1);
  t('6', '5.70', 0, 1);
  t('-99', '-98.64', 0, 1);
  t('-1.27', '-1.2704', 3, 1);
  t('-690973732155', '-690973732155.469', 0, 1);
  t('722.4', '722.406', 1, 1);
  t('0', '-0.00000002880164', 7, 1);
  t('-0.3672915204', '-0.3672915203791', 10, 1);
  t('6', '5.7', 0, 1);
  t('-7.8', '-7.794810', 1, 1);
  t('-4', '-4', 0, 1);
  t('0', '-0.00000004432', 0, 1);
  t('-2.876e-8', '-0.00000002875518', 11, 1);
  t('-4809617.494', '-4809617.4942825', 3, 1);
  t('0', '-0.00059268', 2, 1);
  t('58.98', '58.978039', 2, 1);
  t('0', '-0.016', 0, 1);
  t('-2.47e-8', '-0.00000002471605291', 10, 1);
  t('-6', '-6', 0, 1);
  t('-160.1', '-160.133738', 1, 1);
  t('-46.47', '-46.4710664927', 2, 1);
  t('-42132', '-42131.8', 0, 1);
  t('-177078565', '-177078565.1', 0, 1);
  t('-13', '-12.96', 0, 1);
  t('-2466194887576', '-2466194887576.07', 0, 1);
  t('85817.5', '85817.5257', 1, 1);
  t('0.000001', '0.000001096', 6, 1);
  t('2721.28259362', '2721.2825936208', 8, 1);
  t('-666.8', '-666.7638629', 1, 1);
  t('0', '0', 0, 1);
  t('3', '3.05', 0, 1);
  t('2.8305', '2.83053418', 4, 1);
  t('107747209344', '107747209343.65', 0, 1);
  t('-19516.877', '-19516.87709', 3, 1);
  t('24906462', '24906462.2', 0, 1);
  t('-1647073.3', '-1647073.28763752', 1, 1);
  t('11.97377477611', '11.9737747761098', 11, 1);
  t('229.9', '229.8997488', 2, 1);
  t('-155', '-155.42068', 0, 1);
  t('1455.6', '1455.596', 1, 1);
  t('0', '-0.094530', 0, 1);
  t('482996.4', '482996.375', 1, 1);
  t('3435.41656999', '3435.4165699855', 8, 1);
  t('5.4335589802', '5.43355898018699', 10, 1);
  t('0', '0.00000001719440', 5, 1);
  t('5', '4.69', 0, 1);
  t('1193970209.03', '1193970209.0299', 2, 1);
  t('27', '26.8', 0, 1);
  t('-13.3', '-13.332', 1, 1);
  t('8.8568097543', '8.85680975426', 10, 1);
  t('-124', '-124.154', 0, 1);
  t('427249', '427248.78', 0, 1);
  t('83973094.3', '83973094.318', 1, 1);
  t('-7', '-7', 0, 1);
  t('3881136', '3881136.2057221', 0, 1);
  t('4.18237401733', '4.18237401732936', 11, 1);
  t('0.4177077', '0.4177076950138', 8, 1);
  t('3513833', '3513832.82', 0, 1);
  t('7288384.112', '7288384.11222', 3, 1);
  t('0.000322', '0.0003217517162', 6, 1);
  t('0', '-0.000007719562365530', 3, 1);
  t('-10', '-10.4', 0, 1);
  t('0', '-0.00000224787930800899', 1, 1);
  t('-97', '-96.86', 0, 1);
  t('-3', '-3', 1, 1);
  t('637366619', '637366618.9', 0, 1);
  t('-2.616e-8', '-0.00000002616200290', 11, 1);
  t('0', '0', 0, 1);
  t('5557040', '5557039.99142487', 1, 1);
  t('-37424', '-37424.4', 0, 1);

  t('-875092', '-875092.35', 0, 1);
  t('-0.0000227976', '-0.0000227975639550678262017478129916576433201220848434842725874939487930664284021', 10, 1);
  t('2.2538758714350806283686432935115171705361713946e+42', '2253875871435080628368643293511517170536171.39460291655003180', 4, 1);
  t('389519057522885070', '389519057522885069.86441361857796786', 0, 1);
  t('-0.0001604003', '-0.0001604003427736412297055604178957447533846320505', 10, 1);
  t('0', '-0.0003759237499866949805539122027066706346375', 3, 1);
  t('2.9595687120678047014195596e+23', '295956871206780470141955.9555269914541454552900717667176906633518', 2, 1);
  t('0', '-0.0057349186548783089088994765859209750489356748290335702491795', 0, 1);
  t('-1.989050624377365882377141710271815800678153946676651e+50', '-198905062437736588237714171027181580067815394667665.11419329795371', 1, 1);
  t('-1515214549716.139', '-1515214549716.1393042', 3, 1);
  t('31556.85078252', '31556.8507825226', 8, 1);
  t('-1.64115375742136036300482707547256589139e+35', '-164115375742136036300482707547256589.138771', 3, 1);
  t('0.01423', '0.01422573', 5, 1);
  t('-0.000232456', '-0.000232455943624282993507882240453744242293713800574665111', 9, 1);
  t('0', '-0.000025617812904936793014356691660353526050603873148471115025', 4, 1);
  t('-0.01', '-0.010262775046489756235913496198266450161035343642295161', 2, 1);
  t('3259083251662243.322196728', '3259083251662243.3221967278882', 9, 1);
  t('6641773.697', '6641773.6965111', 3, 1);
  t('-0.000237281', '-0.0002372812954013189833260110975097715969010825213646853232862206931548464821', 9, 1);
  t('-1431262931.5956088095', '-1431262931.595608809490355795145672584199277613148822', 10, 1);
  t('1.85211665460405609612572e+23', '185211665460405609612572.0', 0, 1);
  t('-4.54754727912822904642311229824179969700406514678997829227e+53', '-454754727912822904642311229824179969700406514678997829.22679916651460596', 3, 1);
  t('-7583395067147', '-7583395067147.46131', 0, 1);
  t('-1175993156896.913', '-1175993156896.91292304118629937255798554', 3, 1);
  t('0', '0', 0, 1);
  t('-28774002381919556', '-28774002381919556.212086401514914505706498255002845429415', 0, 1);
  t('35004312889918', '35004312889918.160769768247981', 0, 1);
  t('-1237177071444512515.4528141742', '-1237177071444512515.4528141741787326270587113205375195611793', 10, 1);
  t('-37672320944258.356912', '-37672320944258.356911524821222943551002336', 6, 1);
  t('-38144110276257609.449768698', '-38144110276257609.4497686977075226897463', 9, 1);
  t('0', '0.000000046547346405619925578246092071968538873393319160460', 2, 1);
  t('0', '0.00001838576431325940902832914928959039483389269847319076396485901145650900', 1, 1);
  t('49501837517.214069742', '49501837517.21406974209598582965535114994486454740290406795', 9, 1);
  t('-1.10094639313007538634258872002416492596260417033e+43', '-11009463931300753863425887200241649259626041.703327237', 4, 1);
  t('-15079320729.1894', '-15079320729.1893812032633172481133077974162581453005755313218284', 4, 1);
  t('-564880', '-564879.81730188296827284760142', 0, 1);
  t('0', '-0.00000044710415335926612475456733757920412327813375556836787988595622211127775', 5, 1);
  t('-5.0892251246766458444912241643674812585582e+31', '-50892251246766458444912241643674.81258558217344932428492833748374386935', 9, 1);
  t('-0.4', '-0.39773938360585457515044562142137000481695128784849', 2, 1);
  t('-59877098075549.9', '-59877098075549.871', 1, 1);
  t('7.01425197216637438530506871997325620997125812e+37', '70142519721663743853050687199732562099.71258120285569129579872914365', 7, 1);
  t('0', '0', 0, 1);
  t('1170960728043781', '1170960728043780.52', 0, 1);
  t('-158679923.8', '-158679923.83895211051855', 1, 1);
  t('-1312134.4', '-1312134.37262', 1, 1);
  t('339.90300146', '339.90300146396785894119726', 8, 1);
  t('313.99394909', '313.9939490905555364316583381093179922478', 8, 1);
  t('100', '100.43539989895095793026558070', 0, 1);
  t('0.0005', '0.000511967049034719202427396', 4, 1);
  t('1.3826292', '1.38262918376398535955329100656900617', 7, 1);
  t('-3376864609027', '-3376864609027.31', 0, 1);
  t('0', '-0.00022742631720238953606664846536638238892593836630193', 2, 1);
  t('0.04', '0.03644343194033728170638539939055404195454217128924', 2, 1);
  t('1.85079020372598370434938839203919481797033266247609133021349427255e+54', '1850790203725983704349388392039194817970332662476091330.2134942725494346', 11, 1);
  t('-1019472.7374745413', '-1019472.7374745412966658065097247388402969329', 11, 1);
  t('-7.7219209467723723861814313230702956157e+32', '-772192094677237238618143132307029.561567998790593083720', 5, 1);
  t('0', '0.0002250988428774989303333158578906535198611417', 0, 1);
  t('3818042524114368270.55990696309', '3818042524114368270.559906963093970691750518438534274907246771762349334', 11, 1);
  t('5.5317765055734350936674694588551855966580241138435936153803855e+51', '5531776505573435093667469458855185596658024113843593.615380385499', 10, 1);
  t('1.210324318102871018749790888251e+25', '12103243181028710187497908.882505631762785050909329', 5, 1);
  t('-32489581947553187.65', '-32489581947553187.64937178976559783298752043613654217187748263824', 2, 1);
  t('-5.819668587356525630435934798507394021971300298e+44', '-581966858735652563043593479850739402197130029.76011', 1, 1);
  t('47225831.900305649', '47225831.900305649147437954583710923866999871', 9, 1);
  t('-17361443874.82', '-17361443874.82050042729914650794408003097403090226747628770292154158', 2, 1);
  t('808432127545768', '808432127545767.5672', 0, 1);
  t('-3.5872396370964479081510988473876e+23', '-358723963709644790815109.8847387592291366949137370811246555449', 8, 1);
  t('0.00116173203', '0.0011617320255535260635480469459847025228266492036602115184031567', 11, 1);
  t('-4.3404695776587808601814031692728177e+33', '-4340469577658780860181403169272817.665240', 1, 1);
  t('-1.897193503573543819793095470929478770084696029189486852137e+58', '-18971935035735438197930954709294787700846960291894868521370.024409953', 1, 1);
  t('-5292241017779477.09658543', '-5292241017779477.09658543045290622741062294257', 9, 1);
  t('-35.1', '-35.13905', 1, 1);
  t('235.1', '235.148', 1, 1);
  t('-1.200691371507463776806656069591490050554246628537520819692e+55', '-12006913715074637768066560695914900505542466285375208196.91755077', 2, 1);
  t('-5.418204419424594214395334985560184016e+29', '-541820441942459421439533498556.018401564186863579641277488705', 7, 1);
  t('5.444163340153691434331171778822781944798016655625e+44', '544416334015369143433117177882278194479801665.562468836', 4, 1);
  t('-131626533038183601', '-131626533038183601.081', 0, 1);
  t('9.6611510968833617556877072868245e+28', '96611510968833617556877072868.24499', 3, 1);
  t('642', '642.15', 0, 1);
  t('2.8', '2.7839951081005608001358255', 1, 1);
  t('1575660085.637500732', '1575660085.63750073184325110547601', 9, 1);
  t('343795539312454947078.5379', '343795539312454947078.5379263', 4, 1);
  t('230493558539330961.46', '230493558539330961.4583404314830897111138533096929011660', 2, 1);
  t('3485954.87640169', '3485954.876401687900086645288006479385774', 8, 1);
  t('-424.180135', '-424.180134765132172292603759715197331411088421809167963657362', 6, 1);
  t('664762188525820.19', '664762188525820.193954602032806708897222883562127550899924400644608688950', 2, 1);
  t('-245', '-245.08', 0, 1);
  t('2', '2.1', 0, 1);
  t('0', '-0.00000016680630368737512629184', 5, 1);
  t('0.0014', '0.00137262324057619148068114213992452771542833', 4, 1);
  t('-48560891683776.102059', '-48560891683776.1020585782570631379694154', 6, 1);
  t('-49037303691146507.15961', '-49037303691146507.15961048922934', 6, 1);
  t('6504.5', '6504.4995059409990113', 2, 1);
  t('-68194.4', '-68194.445299', 1, 1);
  t('36548.079', '36548.0786291685788403454784765575946380627330', 3, 1);
  t('-3632', '-3631.57593', 0, 1);
  t('-5.404924165184979293599519181266283024e+31', '-54049241651849792935995191812662.830235709335668296987713', 5, 1);
  t('-94446.93049594', '-94446.93049594035645149897427911523049241547775', 9, 1);
  t('-285', '-285.21', 0, 1);
  t('-8.4798376467830902363925009423294054760926150920484621224536e+49', '-84798376467830902363925009423294054760926150920484.6212245356', 9, 1);
  t('3567332.2', '3567332.154085633406700981', 1, 1);
  t('0', '-0.00000027090925348557045641317523', 6, 1);
  t('-615.27093117', '-615.2709311718156906735', 8, 1);
  t('6.1466191709', '6.14661917089102448242483866840892371', 10, 1);
  t('-81430605431426', '-81430605431425.9818', 1, 1);
  t('-2228410971.21211174', '-2228410971.212111738403506', 8, 1);
  t('14.56', '14.559163589685051018706820831355074258529053190436', 2, 1);
  t('10112.991', '10112.99134', 3, 1);
  t('-1.549654744079498361988855705e+26', '-154965474407949836198885570.532', 1, 1);
  t('-1.9612603016946628003179519291841508116446683884444e+49', '-19612603016946628003179519291841508116446683884444.16', 0, 1);
  t('47508.546', '47508.5464269', 3, 1);
  t('-112738828416.39520687878', '-112738828416.3952068787790118880227555103034032188186027302206954847064305', 11, 1);
  t('1770382', '1770382.1', 0, 1);
  t('0.00395', '0.00394974463050177539372800127529601980689844112635569413483705289912', 6, 1);
  t('17773256759265862.69901967', '17773256759265862.6990196665850794629027119693414326654199282580563866916', 8, 1);
  t('2196971', '2196971.18126', 0, 1);
  t('25359251738269721822.5', '25359251738269721822.4955044', 2, 1);
  t('0.00000627', '0.00000627003230463190432200378605149422479671069336272160735', 8, 1);
  t('-4369010.49267486', '-4369010.49267486025', 8, 1);
  t('3.9165171265879219556625e+23', '391651712658792195566249.5145649', 0, 1);
  t('-0.00567994759', '-0.0056799475886137751344765089598966788653731735', 11, 1);
  t('15781.9', '15781.92058136698346', 1, 1);
  t('-7907913721716.3105685344', '-7907913721716.31056853439', 10, 1);
  t('-9693450511.4', '-9693450511.4364345502415098763692791003398494225455326915628', 1, 1);
  t('105.94', '105.941073626', 2, 1);
  t('90569738206088032', '90569738206088031.56735007529169388144464377571473516086', 0, 1);
  t('0', '0.0000064104086163561537456510584567812011298386884368729071232', 4, 1);
  t('-275676888204082', '-275676888204081.7', 0, 1);
  t('-0.418899', '-0.4188990517551812147580279209347258', 6, 1);
  t('1446561555475694130.0307', '1446561555475694130.030741065760666433164798040501502060845671885', 4, 1);
  t('312', '311.87', 0, 1);
  t('1.9314131082464092998121719755669499e+31', '19314131082464092998121719755669.4985129906527231922243980692884', 3, 1);
  t('-1.438964102525355362357420633e+26', '-143896410252535536235742063.2929', 1, 1);
  t('6.3466257031691681890016112674760177105555569494998930013143741215e+64', '63466257031691681890016112674760177105555569494998930013143741215.3', 0, 1);
  t('-1075991106231353', '-1075991106231352.85897436863706283122368232494927841291088', 0, 1);
  t('3e-7', '0.0000003025771858567905454701894144820622844125524179484777759969900546341907', 8, 1);
  t('0.26924219819', '0.26924219818549771642', 11, 1);
  t('-8015635148902724631.2', '-8015635148902724631.203', 1, 1);
  t('-18.71632606', '-18.7163260579908078250564735368880998343628734869184299960015055535449864', 8, 1);
  t('-3231.50987', '-3231.50987067', 5, 1);
  t('0.0014', '0.00138483199605699422972312', 4, 1);
  t('592524956077', '592524956077.36', 0, 1);
  t('46161060214305611.9', '46161060214305611.905923999914', 1, 1);
  t('-118050105415060868265', '-118050105415060868265.17452270162067', 0, 1);
  t('0', '-0.0000419150096503208194115355041221223877284254', 0, 1);
  t('349643647.767', '349643647.7667443874073380083108205387951569802697884386818', 3, 1);
  t('-5.916267067947468161184058954565920177652319e+39', '-5916267067947468161184058954565920177652.3190639778650036234024469031012137', 3, 1);
  t('-3198422718124818925.9566145386', '-3198422718124818925.9566145385798592', 10, 1);
  t('2163180.515', '2163180.5147178519745943148334645411750862330805', 3, 1);
  t('-6e-8', '-0.0000000602928973647126340509049', 8, 1);
  t('0', '0', 0, 1);
  t('-12720', '-12720.0628', 0, 1);
  t('-4.429398854150809254887788137e+21', '-4429398854150809254887.788137417', 6, 1);
  t('15464660106717031389.9', '15464660106717031389.8986987488731481357154523657013368570628985336477649', 2, 1);
  t('-63154186749142214876.8218779201', '-63154186749142214876.821877920128863', 10, 1);
  t('-11290260.5995255858', '-11290260.599525585841162466997053750802235950453228408340883', 10, 1);
  t('0', '0', 0, 1);
  t('15659433', '15659432.8', 0, 1);
  t('-11075372.2', '-11075372.1591', 1, 1);
  t('-0.000012542', '-0.000012541956961791973704249225434244498747029492497449809114722830404507', 10, 1);
  t('0.0001', '0.000069237492968208049866', 4, 1);
  t('1749887008.40093843044', '1749887008.4009384304368250420327', 11, 1);
  t('-1411686.7', '-1411686.7427308578723', 1, 1);
  t('-0.00049580939', '-0.00049580939113687167275006000995373385414454730', 11, 1);
  t('-0.001', '-0.0010958004592288185', 3, 1);
  t('1.1330767787768417637020668947e+22', '11330767787768417637020.6689469575538839155167073739', 6, 1);
  t('0', '-0.0000000719730809474333956442093395372329599094726657137', 5, 1);
  t('-1030434920.125023', '-1030434920.125023292041', 6, 1);
  t('-0.01615', '-0.01614727974310057130602783119679271773492084831215117999332526354', 5, 1);
  t('1.5', '1.457', 1, 1);
  t('90289522.6216297603', '90289522.621629760293727149784155', 10, 1);
  t('-28505223886234442.6', '-28505223886234442.613673188963701636152740', 1, 1);
  t('0.00316398', '0.00316398058542186042159127483357911190755734894117002', 8, 1);
  t('445420392002161617.72463', '445420392002161617.724630448638', 5, 1);
  t('-10480899895139690.8', '-10480899895139690.79396842787', 1, 1);
  t('242029030401', '242029030400.76', 0, 1);
  t('8819268473.84598', '8819268473.8459776656713794401718879712350433244017515003765201823', 5, 1);
  t('-18.7', '-18.7175', 1, 1);
  t('665', '664.7167725818441030647033402651', 0, 1);
  t('-9075411967.293', '-9075411967.292692099', 3, 1);
  t('-0.02505900376', '-0.0250590037593497067153442190787824933811766014832125232373883316645974', 11, 1);
  t('-307', '-307.2', 0, 1);
  t('-78.32', '-78.316911', 2, 1);
  t('-55750170', '-55750169.739447352', 0, 1);
  t('0', '-0.0000706446718743070077386709316943343947210934751081', 2, 1);
  t('-154366721494737499158.11581191', '-154366721494737499158.115811914880280741724525821345', 8, 1);
  t('0', '0.000000244176706193853848', 5, 1);
  t('3.02854522355334928443125776956621576e+29', '302854522355334928443125776956.621575508273376267512685902226959421411562874', 6, 1);
  t('0', '0.000000038454633084227435', 5, 1);
  t('-47.498579', '-47.49857933', 6, 1);
  t('-5845057724680625.629', '-5845057724680625.6286483975495329281801633904425921895179286141302705', 3, 1);
  t('0', '-0.0000001753', 1, 1);
  t('6.304937094670304432147673713077936562995e+39', '6304937094670304432147673713077936562994.6290684312675815393937', 0, 1);
  t('-4.4148160945578821446429e+21', '-4414816094557882144642.899533371', 2, 1);
  t('0.0000015', '0.000001544907', 7, 1);
  t('0.51054077', '0.51054076847', 8, 1);
  t('-837298723.6827', '-837298723.68271037290095959146346996164686705661213188582911407844898522', 4, 1);
  t('5.75868113138888770811211463843096239187e+38', '575868113138888770811211463843096239186.60', 0, 1);
  t('189720.9', '189720.884', 1, 1);
  t('-9996', '-9996.4', 0, 1);
  t('-2936836337860435881.21', '-2936836337860435881.2063', 2, 1);
  t('69774091268.49603997188', '69774091268.4960399718783250836608642488956447749899414465', 11, 1);
  t('231847185', '231847185.2', 0, 1);
  t('1.6476540181976483178382e+21', '1647654018197648317838.156494', 1, 1);
  t('83436958727485935716.8457886', '83436958727485935716.8457885824037214853084354008586010224909377289371', 7, 1);
  t('2199.246181618', '2199.24618161841666879186451139376780483414384051259408415945', 9, 1);
  t('0', '-0.00014190990205091919220', 3, 1);
  t('2.257358496396596635167063887366480385039047331567239793599971428933e+59', '225735849639659663516706388736648038503904733156723979359997.14289330399', 8, 1);
  t('0', '0.000000038390688774835136785769346544535597804407691090', 4, 1);
  t('-4', '-4', 0, 1);
  t('-9.52697169829242933400467627255600447579e+38', '-952697169829242933400467627255600447579.14375759', 0, 1);
  t('-665091398016.58953737686', '-665091398016.589537376861890998062838', 11, 1);
  t('-4.23e-8', '-0.000000042328577200854267846657373266299411791629974587715258557194', 10, 1);
  t('5.9202052490969753231227267184e+26', '592020524909697532312272671.83500966963327664391287246', 2, 1);
  t('0', '0.0000000179149807345230640185816994822819392', 6, 1);
  t('0', '-0.0057021237827481286659368552', 1, 1);
  t('7.27e-7', '0.00000072673060039794461103', 9, 1);
  t('-99439407.8895458356', '-99439407.8895458356434576964403463752975283874335863794282435580132707', 10, 1);
  t('-13543275287842646375.6476439176', '-13543275287842646375.64764391760373455801804429729964426098924216', 11, 1);
  t('-7152493.81324903', '-7152493.81324903009331429108422125949333353411541802', 8, 1);
  t('3730694.65583999', '3730694.65583999002916799352994988975876027309978210', 8, 1);
  t('6762015.02820054', '6762015.028200543434317056809442137716', 8, 1);
  t('-530.65', '-530.65132', 2, 1);
  t('-18845.7', '-18845.705', 1, 1);
  t('-2946719567247740755.91', '-2946719567247740755.91206221173742948424654685827676871308445', 2, 1);
  t('1', '1.35682667671002126192513305875792506665133376', 0, 1);
  t('7451608379.73', '7451608379.732177', 2, 1);
  t('-178.94246554', '-178.942465543951964859810274753961730897866488075435062964868431', 8, 1);
  t('-975010', '-975010.049', 0, 1);
  t('-0.001684183', '-0.0016841832970762709660330762585224913289348880089336173', 9, 1);
  t('-8987761465620025443.38965', '-8987761465620025443.38964962728592015354299860', 5, 1);
  t('-83909014414.25986651154', '-83909014414.25986651154355041127298613275', 11, 1);
  t('-13.15975', '-13.1597524', 5, 1);
  t('-4748943070009072355.1311048839', '-4748943070009072355.1311048839000', 10, 1);
  t('6793530.7148', '6793530.714800700602741845216', 4, 1);
  t('0.2', '0.19336656929824273029867332405424043809017452815309723830415986704865', 1, 1);
  t('-1.529759780960691402489076959e+22', '-15297597809606914024890.7695883863359671729177926128456053', 5, 1);
  t('0.7', '0.6812493081411867995961743', 1, 1);
  t('-61609', '-61609.480', 0, 1);
  t('0.3686942377', '0.36869423769948576020183350690479101310831768153121393758423171728318', 10, 1);
  t('-29110961878245122977', '-29110961878245122976.5', 0, 1);
  t('59419992370876.94', '59419992370876.9376440531529836730761352971301958944171895380455574', 2, 1);
  t('-56.4335458161', '-56.43354581607959408247951', 10, 1);
  t('6.8442509224929872472789618828612411616418e+38', '684425092249298724727896188286124116164.184', 2, 1);
  t('0', '-0.00015', 3, 1);
  t('80881689696778642420', '80881689696778642419.9263', 0, 1);
  t('0', '0.0577940327113659086419745424518100', 0, 1);
  t('0.383', '0.3832620286', 3, 1);
  t('0.01464495748', '0.0146449574801145651434409145562996188668883420', 11, 1);
  t('877.62221989', '877.622219891131514106177614702356642546765977763219997467246016352100684739', 8, 1);
  t('1343135299012.954', '1343135299012.95398', 3, 1);
  t('-9644346592838', '-9644346592838.386961952575164137732494766797778853886', 0, 1);
  t('-521841889561.949541', '-521841889561.94954093936232905402428381282', 6, 1);
  t('0', '-0.00244105708420249163090854919205183356655994092461832624561939981104901', 1, 1);
  t('-5.8234798002248768024638353003946549132832898986453211886549627133e+58', '-58234798002248768024638353003946549132832898986453211886549.62713286235574', 6, 1);
  t('3139', '3138.62', 0, 1);
  t('0', '0.0001198056967084273101161036010098247178', 1, 1);
  t('0', '0.000000282232416431871002402', 4, 1);
  t('-3.5267693422143770971710572e+24', '-3526769342214377097171057.1982128651', 1, 1);
  t('0', '-0.00028366966937563882731517577864263710585186525623549589863418077071', 3, 1);
  t('91693087570352.600817', '91693087570352.6008170206439979060334911', 6, 1);
  t('-1.69938495608143495608548828108517535172348930633049530716e+53', '-169938495608143495608548828108517535172348930633049530.7159', 3, 1);
  t('4.109778740139187954868003044968718135913437529519e+38', '410977874013918795486800304496871813591.3437529518848865335260867216', 10, 1);
  t('-7398274144471934.6', '-7398274144471934.563218249107642055', 1, 1);
  t('-8', '-7.784310170693', 0, 1);
  t('-571890306374296407.9', '-571890306374296407.943', 1, 1);
  t('-6.633e-8', '-0.0000000663307924548045646890186879751708423426975624666424084662', 11, 1);
  t('0', '-0.000126', 0, 1);
  t('3264.1143148', '3264.114314761262198', 7, 1);
  t('21.5154476', '21.515447580538608939378147773244405078958206375602341252932027644734460969', 7, 1);
  t('1.114224824217252451210400841289249056735851e+36', '1114224824217252451210400841289249056.735850704960510381246929960356', 6, 1);
  t('-10438.45', '-10438.4493', 2, 1);
  t('0.00003350151', '0.0000335015134639164447942467980070763509369044498665883910186335362012066', 11, 1);
  t('-0.0884527694', '-0.0884527693877831112215937398', 10, 1);
  t('-9935322316284.355228', '-9935322316284.35522848745770884435562183155801', 6, 1);
  t('4.77736147637228277582670683345723181411748305340671501670241970309124008e+64', '47773614763722827758267068334572318141174830534067150167024197030.912400806', 7, 1);
  t('0', '0', 0, 1);
  t('1.75483559835859910986230669030376449279e+38', '175483559835859910986230669030376449279.2', 0, 1);
  t('9.482403377529181690360444118e+21', '9482403377529181690360.44411775742580', 6, 1);
  t('0', '-0.0000917695370689692068175190', 2, 1);
  t('1.1302e-7', '0.0000001130227102566118673161208090824479165834097561628587177919563228', 11, 1);
  t('-0.0002', '-0.000220386', 4, 1);
  t('-6.23360780006710623107814475832835e+28', '-62336078000671062310781447583.283496871701917', 5, 1);
  t('0', '-0.0000014859262806322324908123019207978267246752674585719916413874449', 1, 1);
  t('-2.945454781472201940260256266752003181661017e+39', '-2945454781472201940260256266752003181661.01729363', 3, 1);
  t('1', '1.12', 0, 1);
  t('16028', '16028.2', 0, 1);
  t('8.719946816447055084159323587485285e+30', '8719946816447055084159323587485.28493012926755972043', 3, 1);
  t('10257341.1', '10257341.1479881', 1, 1);
  t('17013817361.935264454', '17013817361.935264453943321310979871994304292123382', 9, 1);
  t('-22720931.7016855', '-22720931.70168547339', 7, 1);
  t('3.13680917716151905744790064171349024e+33', '3136809177161519057447900641713490.236469555306636', 2, 1);
  t('896720586914166855.9', '896720586914166855.879365970680029002', 1, 1);
  t('4.2837750290481535203021258140802312695249833551461558872789566e+54', '4283775029048153520302125814080231269524983355146155887.278956615', 7, 1);
  t('-251712843580128455922.68527733', '-251712843580128455922.6852773326', 8, 1);
  t('-624702.3385486386', '-624702.33854863863132162134480885', 10, 1);
  t('-3111028.772', '-3111028.771629280', 3, 1);
  t('1.5343442398130900316772821216965e+27', '1534344239813090031677282121.69646067091128951374385916873', 4, 1);
  t('-207638921.484075', '-207638921.484074779969497112988694629164072981085440065565', 6, 1);
  t('-4', '-4.3', 0, 1);
  t('-7.667993', '-7.6679930877344994', 6, 1);
  t('-638028799.23148337', '-638028799.2314833708135163919329621483224070827', 8, 1);
  t('5372711.93472769', '5372711.93472768979', 9, 1);
  t('-0.0228', '-0.0227676793924317452083619', 4, 1);
  t('5.895022660661795448320177250831188412885e+38', '589502266066179544832017725083118841288.4650055461695021762815742647767', 1, 1);
  t('-1', '-0.7028672167258748238236251776154', 0, 1);
  t('9.3569549641456163006343855549325267324958e+30', '9356954964145616300634385554932.52673249577170209357953905386683330', 10, 1);
  t('-190569.83', '-190569.830208369225650606809797066267262066949682411309676855800407968002', 3, 1);
  t('8682386157181739.244674', '8682386157181739.2446743748113687131975267001211320111334608550775773', 6, 1);
  t('-6.117412690975843613242144918158874790952e+37', '-61174126909758436132421449181588747909.5246006273', 2, 1);
  t('100.5', '100.451', 1, 1);
  t('8493144.5932861', '8493144.593286139', 7, 1);
  t('-0.0012', '-0.0011504742593558933405586716859068329652410', 4, 1);
  t('-69770724.00678', '-69770724.00678127', 5, 1);
  t('2.887811613235232046989e+21', '2887811613235232046989.45', 0, 1);
  t('0', '0.000043543', 0, 1);
  t('-2.570662211618339726384438457073655042907038603795501596304531612785165e+69', '-2570662211618339726384438457073655042907038603795501596304531612785165.2', 0, 1);
  t('-635143350251489038.32065', '-635143350251489038.32064982758220679977', 6, 1);
  t('-0.5216032', '-0.521603168503201998', 7, 1);
  t('7.361869542409565631617120379371892080532e+34', '73618695424095656316171203793718920.8053198250586090', 5, 1);
  t('0.0533664', '0.053366386047511479307547893533547909227', 7, 1);
  t('209228370892404117.98739530602', '209228370892404117.98739530602036548608540', 11, 1);
  t('2.91e-7', '0.00000029126796883406907292121569232822875536053044', 9, 1);
  t('-359391.75092346007', '-359391.75092346007356230407272', 11, 1);
  t('-163.5735689', '-163.5735688760734090660', 7, 1);
  t('-1', '-1', 0, 1);
  t('40004210.5582584224', '40004210.558258422361333', 10, 1);
  t('25597650.3', '25597650.2731', 1, 1);
  t('1.001657661088558240100760821561e+21', '1001657661088558240100.76082156119896270760831812226297', 9, 1);
  t('22597.5713590881', '22597.5713590881338521413164246977885071809826288008051430179570', 10, 1);
  t('-2.82507338465291476336051705148451643477094428073974e+47', '-282507338465291476336051705148451643477094428073.973872167', 3, 1);
  t('-5.46787453939454578640208e+24', '-5467874539394545786402079.84219678844129055803', 0, 1);
  t('349932064648365', '349932064648365.2444292', 0, 1);
  t('0.000043', '0.00004265910947358020415348499125067179010441889634366697337077133466552', 6, 1);
  t('0.00005674972', '0.0000567497239128431129600124874784', 11, 1);
  t('-2', '-1.75', 0, 1);
  t('9.06961775964308196048869225134891040528806077e+37', '90696177596430819604886922513489104052.8806076658528638816991', 7, 1);
  t('-55.6622823345', '-55.6622823345398', 10, 1);
  t('7.946152863153624318328619951066698613611636717991127e+50', '794615286315362431832861995106669861361163671799112.68315099693185752514234', 1, 1);
  t('3.32126600038407214285810665582386e+23', '332126600038407214285810.6655823860401336492892313979965330510658024', 10, 1);
  t('-5.0801669389908910140721e+21', '-5080166938990891014072.064473841803788707044', 1, 1);
  t('-5.471319410437490768688847166e+22', '-54713194104374907686888.4716622264607577782175537678600733957195788', 5, 1);
  t('-3.91637553952', '-3.916375539522145012433961993251468641359348985354768027', 11, 1);
  t('0.6217', '0.621707002873765311594634770374556488042204123528621863966092999736483975597', 4, 1);
  t('-38877', '-38876.91927046902154631', 0, 1);
  t('-1.59537635340599267825283316569238823e+25', '-15953763534059926782528331.6569238822674194186084410', 10, 1);
  t('0.26134768', '0.26134768471794575538600112', 8, 1);
  t('8.6611482787553463490740035e+24', '8661148278755346349074003.478', 1, 1);
  t('1.527e-7', '0.0000001526709669983697775532674726749547571621689512122876', 10, 1);
  t('229699.4869', '229699.486895620', 4, 1);
  t('-1.57168680038064574877849491149787045545806678876e+40', '-15716868003806457487784949114978704554580.667887604957629728485973024547', 8, 1);
  t('-1.9363323745510392836429671043085943741188929973006010284961057744e+57', '-1936332374551039283642967104308594374118892997300601028496.105774437', 7, 1);
  t('0.00000339', '0.00000338786070575526629053749300687308748454084326619224482154043951477723217', 8, 1);
  t('-168', '-167.7', 0, 1);
  t('1107464196.5228165', '1107464196.522816523319516305242786613554977896352538090021010422838102', 7, 1);
  t('-0.0211121421', '-0.0211121420805180091655019083761316294', 10, 1);
  t('0.4', '0.388649053814232307126', 1, 1);
  t('34301146', '34301145.8263498894841911363070431836655336743157323418701425822', 0, 1);
  t('-0.079', '-0.078564204260789475382083885352759745950294802666611880', 3, 1);
  t('9.565473502896567600791678352422525063839825352974916607e+45', '9565473502896567600791678352422525063839825352.9749166072654879552027', 9, 1);
  t('626792265339.1', '626792265339.145094', 1, 1);
  t('-235448.9', '-235448.88036', 1, 1);
  t('-78103.28622', '-78103.28622457354649', 5, 1);
  t('-6.62390578590572068579674362431595353e+32', '-662390578590572068579674362431595.3525277518970626510774282', 3, 1);
  t('-48122945326168143882', '-48122945326168143882.3', 0, 1);
  t('8363.564', '8363.56446', 3, 1);
  t('-3.637652544552061090930479659378147190018883689027726e+51', '-3637652544552061090930479659378147190018883689027725.92109964841073608596', 0, 1);
  t('3.227685372039569033997527213105091722187242619167e+48', '3227685372039569033997527213105091722187242619166.73', 0, 1);
  t('2.137566384682188124535023473201797095886638943949510144621567457e+60', '2137566384682188124535023473201797095886638943949510144621567.45671', 3, 1);
  t('-3.315687716997812844093088662218228e+32', '-331568771699781284409308866221822.7927192992469250739427210961811703051307', 1, 1);
  t('-725', '-725.1', 0, 1);
  t('2.395404566051884918577591156726042015580751407749133e+48', '2395404566051884918577591156726042015580751407749.1334606336477794', 3, 1);
  t('-0.000001', '-0.00000053696558009', 6, 1);
  t('40213632702173443471.6121383', '40213632702173443471.6121383204029486849806851441038805518711333048462529', 7, 1);
  t('25226864323.2136106', '25226864323.213610598425', 7, 1);
  t('3.0702662350049631116943484739443862479174483359e+43', '30702662350049631116943484739443862479174483.3590074655360144', 3, 1);
  t('-6.4529061793389722113117862297e+26', '-645290617933897221131178622.96763376', 2, 1);
  t('-1565949460821', '-1565949460821.07', 0, 1);
  t('-1.3', '-1.306823', 1, 1);
  t('0', '0.000000035648743249682144080763704181744851219816495062903160470498752497919821006', 0, 1);
  t('-8.4726254302913882251462863225390460912013610876e+37', '-84726254302913882251462863225390460912.013610876011727', 10, 1);
  t('6.2203816355011871081767811814183e+30', '6220381635501187108176781181418.34', 1, 1);
  t('-0.163', '-0.1626680061048713', 3, 1);
  t('-2.54188403069862540205970518461756e+32', '-254188403069862540205970518461756.3', 0, 1);
  t('0', '0.00000002604390158484059660660648738134281026698213903426210929194225657081623', 2, 1);
  t('-346152.58', '-346152.582714163729795', 2, 1);
  t('-12996.7280474', '-12996.728047390422147964', 7, 1);
  t('-154760705.346333', '-154760705.3463329890689', 6, 1);
  t('2.9526e-7', '0.000000295263521260395666244956353272273501719081318063362632', 11, 1);
  t('-3.9091117425141622418826610429537228643488274e+42', '-3909111742514162241882661042953722864348827.4471', 1, 1);
  t('1654', '1653.9979', 1, 1);
  t('2773217368', '2773217367.80812', 0, 1);
  t('-23501672596', '-23501672595.53', 0, 1);
  t('0', '-0.000045990856191673263477331211915840285633', 3, 1);
  t('-4.5480197585398187814583347799356579e+24', '-4548019758539818781458334.77993565788611620044739214590767274535417774609', 10, 1);
  t('0', '-0.000045554559303731', 4, 1);
  t('-12632.80348310909', '-12632.80348310908730561124183308842973815319952', 11, 1);
  t('-1.18138082285988940681765555e+25', '-11813808228598894068176555.45553076656681573765904427280530513256977948', 1, 1);
  t('-479', '-478.9874771448950756650422818619215246639689281', 1, 1);
  t('1', '1.2', 0, 1);
  t('6.0041499420870181363520308772719e+31', '60041499420870181363520308772718.5', 0, 1);
  t('-6662877696.4', '-6662877696.37391335730576604739334748253185681', 1, 1);
  t('0.00117', '0.0011726235472768599281043101323482392891852', 5, 1);
  t('-939.4', '-939.3730961', 1, 1);
  t('99159.39', '99159.38873', 2, 1);
  t('-359', '-359.47288627064601781627496', 0, 1);
  t('890117.08', '890117.08289778434200510019632397889822517753431431', 2, 1);
  t('6.63375816371156968457041e+23', '663375816371156968457041.28423899', 0, 1);
  t('-4.10982057418276081462637206727837458797467583857e+47', '-410982057418276081462637206727837458797467583856.7630608288', 0, 1);
  t('-397', '-396.6', 0, 1);
  t('3.11294746158246369823126325149e+21', '3112947461582463698231.263251491762277', 8, 1);
  t('7746', '7746.23', 0, 1);
  t('-0.00003', '-0.000026912239767670597962773', 5, 1);
  t('-3778', '-3777.9522', 1, 1);
  t('-4.97684852436124361495527801648e+28', '-49768485243612436149552780164.8009875', 2, 1);
  t('7.73491171036745726904923118841780876822672534265838323731111e+58', '77349117103674572690492311884178087682267253426583832373111.113', 1, 1);
  t('9.8966431653240771996047279226027e+22', '98966431653240771996047.279226027028594', 9, 1);
  t('23908641.31', '23908641.3117499867219846081522558794662902490122', 2, 1);
  t('4', '3.9859', 0, 1);
  t('90', '90.0', 0, 1);
  t('-32222.00196243', '-32222.001962426278', 8, 1);
  t('-1.518812829487247562216e+21', '-1518812829487247562215.50', 0, 1);
  t('-3.2', '-3.205808906', 1, 1);
  t('-208770543038.898211507', '-208770543038.89821150705007918491104570836293773169717074580960456468', 9, 1);
  t('0', '0.000000390429', 4, 1);
  t('-0.139785', '-0.1397846918276028134595856546868795675545305896587195631099738048047', 6, 1);
  t('-1.84389766241608422523501200650754496059404401530264148e+50', '-184389766241608422523501200650754496059404401530264.147603644835863734115', 3, 1);
  t('-7.68712094018412860572676017845484411481069908369e+43', '-76871209401841286057267601784548441148106990.83687622', 4, 1);
  t('6900142030817.429259765', '6900142030817.4292597646130999967607639644490993092155806195853800514', 9, 1);
  t('0', '-0.0000030105518225', 4, 1);
  t('-6.714055800144920951764125282793656980593253819271136670806e+54', '-6714055800144920951764125282793656980593253819271136670.80600816', 3, 1);
  t('-4653189416537390728.885', '-4653189416537390728.8845285', 3, 1);
  t('-3.260638535748528452047650918e+27', '-3260638535748528452047650917.7', 0, 1);
  t('26', '26.0', 0, 1);
  t('-8.37538727256099503145610141e+23', '-837538727256099503145610.141001640509967520511', 3, 1);
  t('99196567204778640861', '99196567204778640860.9', 0, 1);
  t('-8.314138986470814691119031485199361807215508368060178444673010328e+63', '-8314138986470814691119031485199361807215508368060178444673010328.0', 0, 1);
  t('-0.00023051', '-0.0002305104687388081214425409647589066479519914620169527', 9, 1);
  t('-297660548619', '-297660548618.87868055700832812526230847743363886232739754318064', 0, 1);
  t('3464007694860431.3', '3464007694860431.262227463683', 1, 1);
  t('-2.54786099963234047754453248094241328707387393361512773860762408e+62', '-254786099963234047754453248094241328707387393361512773860762408.00232010', 0, 1);
  t('9.2446412511027120407547836502910175913797442684210761625379e+47', '924464125110271204075478365029101759137974426842.107616253789853128', 11, 1);
  t('-0.0387', '-0.0387128076266330873519195800285655071301555834', 4, 1);
  t('480.9188452863', '480.9188452863468446164206625079058768955271449097704906073506311', 10, 1);
  t('-1', '-0.86630884300516744402803291780220945152', 0, 1);
  t('231', '230.92', 0, 1);
  t('3071350172608341', '3071350172608340.582294', 0, 1);
  t('-0.00579', '-0.005789503974483376471867887936688850815456010473859463666368', 6, 1);
  t('-10405.57708', '-10405.577077443128366832013822', 5, 1);
  t('-233021510458372.09', '-233021510458372.0871487752298159597491435', 2, 1);
  t('-0.745', '-0.7446916142342546383', 3, 1);
  t('-7.183748714068453807909078219515115338295556607578058e+46', '-71837487140684538079090782195151153382955566075.78058204639491751222475', 5, 1);
  t('-420.688253944', '-420.68825394427265204', 9, 1);
  t('0', '-0.0000000184', 5, 1);
  t('-1450.5', '-1450.52789867375960865669661274621776039770235088108', 1, 1);
  t('2519.499011', '2519.4990105028243887459', 6, 1);
  t('-1.1579003534187508725179188871520283529038877369575333e+41', '-115790035341875087251791888715202835290388.77369575333378444006', 11, 1);
  t('9.1337739219127354631923706483787555165493265605427231e+52', '91337739219127354631923706483787555165493265605427231.118070308970', 0, 1);
  t('-3.438376250556765725696862916053630521463884474650422e+51', '-3438376250556765725696862916053630521463884474650422.3059', 0, 1);
  t('8.96012359366431497668176957569850445552446405905713945659589e+54', '8960123593664314976681769575698504455524464059057139456.59588917555775872', 5, 1);
  t('-6.262', '-6.261991', 4, 1);
  t('-1923282567571543', '-1923282567571543.0', 0, 1);
  t('-277519680026359854845.783', '-277519680026359854845.78298210824', 3, 1);
  t('-1.3864797947640414885611300634734495921516466e+32', '-138647979476404148856113006347344.959215164664547445239359524502584', 11, 1);
  t('-2.87681272861729467781784585784825522e+35', '-287681272861729467781784585784825522.17', 0, 1);
  t('0', '-0.00000001524207549800724296881028', 0, 1);
  t('233745.664117498', '233745.66411749814175074770422796212482624286110', 9, 1);
  t('0.0605867', '0.06058668571', 7, 1);
  t('4.25642795850019500221778960004785372318e+27', '4256427958500195002217789600.0478537231827990952214326842205373895208090', 11, 1);
  t('-1.293060165483310538998170050182112181287293136e+40', '-12930601654833105389981700501821121812872.93135723', 5, 1);
  t('-3.702699384156750832389352255401551076630250622317e+48', '-3702699384156750832389352255401551076630250622316.61', 0, 1);
  t('1.2562980355543511178621443709616584e+30', '1256298035554351117862144370961.6583506281536131516066898334442154061619', 4, 1);
  t('-2.95109741336962946655925352405421607192048673035597695624029e+57', '-2951097413369629466559253524054216071920486730355976956240.2937587220684923', 2, 1);
  t('0', '0.000000354302718125605329359047449071913792856192407017510430841042020', 2, 1);
  t('-4.1886828855896969785562283060471713726327e+31', '-41886828855896969785562283060471.713726326922976134142', 9, 1);
  t('212.36103954', '212.36103953965351449195537664336809100212801284487487', 9, 1);
  t('312987948072725355.731', '312987948072725355.73110', 3, 1);
  t('0', '0.0022285232415869089', 0, 1);
  t('8.41103077595298166624326704393352e+22', '84110307759529816662432.67043933515175794884796241628149632964385', 10, 1);
  t('1.6181570850366653393085559862269258983714718422352e+40', '16181570850366653393085559862269258983714.7184223522496148795709977', 9, 1);
  t('-3.545357198162377086150366549612e+23', '-354535719816237708615036.654961160450023393989037709', 7, 1);
  t('4.85672619573002901257927271256214712389417099731862402683e+58', '48567261957300290125792727125621471238941709973186240268300.24', 0, 1);
  t('-1.289502824605541590536763565385582220044069170707581501639e+51', '-1289502824605541590536763565385582220044069170707581.5016394828165246', 6, 1);
  t('1448196.228316', '1448196.228316069023212965555019856731002229021164196810243253', 6, 1);
  t('-8.080041750568999820868791787555178724453992774828388516549513376e+57', '-8080041750568999820868791787555178724453992774828388516549.51337567', 6, 1);
  t('-1.01055281005365912493269566e+25', '-10105528100536591249326956.581283197818463383', 1, 1);
  t('-12.624', '-12.623767', 3, 1);
  t('-7.84933169263129008291480512506622e+32', '-784933169263129008291480512506622.23', 0, 1);
  t('-128786713.43', '-128786713.426987', 2, 1);
  t('-420168758265445.657953646', '-420168758265445.6579536462520299', 9, 1);
  t('0', '0', 1, 1);
  t('134172.7683330327', '134172.7683330326699243976976191874309135530063216675297', 10, 1);
  t('-0.00002', '-0.0000156861682310722089669532', 5, 1);
  t('0.4039235', '0.40392349884638953158868927159351683622934', 7, 1);
  t('-0.655', '-0.6546433013', 3, 1);
  t('-5896336262907.79', '-5896336262907.7884', 2, 1);
  t('1300317344730.259780862', '1300317344730.2597808619', 9, 1);
  t('1.3164177199643139680812653361907748673532016952e+35', '131641771996431396808126533619077486.73532016951620119242012156406441440426', 11, 1);
  t('-145', '-144.97', 0, 1);
  t('-94', '-93.9299', 0, 1);
  t('-379619', '-379618.6', 0, 1);
  t('0', '0.0116337344716633718843866952096', 0, 1);
  t('0', '-0.0000034855964717763280140903715489653', 4, 1);
  t('2.7994709479081275481235098788288226563182e+38', '279947094790812754812350987882882265631.81569392', 2, 1);
  t('15483520831504428.7', '15483520831504428.71185556292487488', 1, 1);
  t('3938497355403603664.38966923245', '3938497355403603664.389669232448583858628040351059', 11, 1);
  t('3.49655882970990547552385877397868e+23', '349655882970990547552385.8773978677153', 9, 1);
  t('-9.5314113588574107571253229194237285440827882316e+38', '-953141135885741075712532291942372854408.2788231629758128487', 8, 1);
  t('-224636067269702735000.8672514296', '-224636067269702735000.86725142959778', 10, 1);
  t('0.3695925', '0.36959252', 7, 1);
  t('1.185290463414173095654799796718546626342254428225e+39', '1185290463414173095654799796718546626342.25442822457028904', 9, 1);
  t('-0.00024', '-0.0002445248283', 5, 1);
  t('0.0002', '0.0002035773', 4, 1);
  t('-67561.881', '-67561.88140', 3, 1);
  t('-382.63', '-382.62760', 2, 1);
  t('0.00555607448', '0.00555607447955739905806214891', 11, 1);
  t('0', '-0.025116267790149342121433040975769563203802094834366406896379339054223842542', 0, 1);
  t('0', '0', 0, 1);
  t('28429490195.57', '28429490195.5708216404077', 2, 1);
  t('-1521445298207930.98', '-1521445298207930.982620841330373025', 2, 1);
  t('8.88171462946985916159853167638395740134495541340377982037213559e+61', '88817146294698591615985316763839574013449554134037798203721355.9382', 1, 1);
  t('-1531412194183093824', '-1531412194183093824.10', 0, 1);
  t('-3.363e-7', '-0.000000336320797303583625836661743', 10, 1);
  t('-194473.19', '-194473.18603590896099', 2, 1);
  t('19.01217085652', '19.01217085651954495368001976', 11, 1);
  t('1.5379458966028217243205838105736021447587584029506112e+51', '1537945896602821724320583810573602144758758402950611.195448438', 2, 1);
  t('41624098749768620074.1', '41624098749768620074.0540229620361', 1, 1);
  t('-1.38', '-1.379301328311813', 2, 1);
  t('17720451681.157', '17720451681.15700740385172996037168075', 4, 1);
  t('-73387.81468935876', '-73387.8146893587610025733427447949657007667886', 11, 1);
  t('414.736', '414.735957', 4, 1);
  t('1.2e-8', '0.00000001212553313934520327766598', 9, 1);
  t('0', '-0.00001275652831810138570098622005202939166281601580172628549356898902900808543816', 4, 1);
  t('-2.36917074377733585116586726e+25', '-23691707437773358511658672.587', 1, 1);
  t('93174923.4184308', '93174923.41843076742677981590825039', 7, 1);
  t('-862199924941.95', '-862199924941.9474', 2, 1);
  t('3.52866519632116536288396957497481880361281627440312e+44', '352866519632116536288396957497481880361281627.44031247032904531753968261', 6, 1);
  t('-1.6563049865205455344453409124683468977856587003665369e+52', '-16563049865205455344453409124683468977856587003665368.9025730603', 0, 1);
  t('-5.477737070119550239652450301897710710356e+39', '-5477737070119550239652450301897710710355.989', 0, 1);
  t('-4.2418934307630353668205727885634470772201281227805e+39', '-4241893430763035366820572788563447077220.1281227804520966330964', 10, 1);
  t('4.07049387418768102471806544437519776093375362941725263411168615944e+56', '407049387418768102471806544437519776093375362941725263411.1686159435942537', 9, 1);
  t('0', '0.000000019057584769480004695230149267550830622691165', 3, 1);
  t('122391892.536722961', '122391892.53672296148271940362017147176012184701554664942474075', 9, 1);
  t('-44313153771648852027', '-44313153771648852027.3692806353020656219927765849305557248', 0, 1);
  t('38153.9053', '38153.90529104833668124228664435', 4, 1);
  t('0.236', '0.23634083366008638136639627501128685101991305893232329', 3, 1);
  t('0.0186693076', '0.018669307645557655917520540823302957385770316520650838282', 10, 1);
  t('-0.34449', '-0.34448900654968710762200791169829886245515492178837315', 5, 1);
  t('31', '31.1', 0, 1);
  t('-1.29792351657689538346132624656000780523205305846628988682e+55', '-12979235165768953834613262465600078052320530584662898868.17500889', 1, 1);
  t('0', '-0.000046', 4, 1);
  t('-20010813478.64083664', '-20010813478.6408366361070', 8, 1);
  t('2951941912470115.5974', '2951941912470115.59736435', 4, 1);
  t('-9', '-9.4', 0, 1);
  t('0.0000153', '0.000015343066761846151730356902050688028263924987670784747252051', 7, 1);
  t('30961311756.32', '30961311756.3151291446832973999719296714620432793509265', 2, 1);
  t('-1.0948418039170141673217e+21', '-1094841803917014167321.7124134094809311874868523809918', 1, 1);
  t('4.687736212830129016257021000471e+26', '468773621283012901625702100.047107777750192', 4, 1);
  t('1.19582955451758313109936852523330173839437623635495402711234119426414e+65', '119582955451758313109936852523330173839437623635495402711234119426.4138495', 3, 1);
  t('-7.013548124129147436389337e+21', '-7013548124129147436389.3373035690248269593583176320179096', 3, 1);
  t('-1.344991799425954638800919469e+27', '-1344991799425954638800919468.9399', 0, 1);
  t('-11', '-10.9', 0, 1);
  t('-107', '-107.22976913758305862', 0, 1);
  t('9.8904744098946133271435843964e+27', '9890474409894613327143584396.4001262431581123694271153317170128001773690', 3, 1);
  t('0', '-0.0000000108336519389576646838131755873813163905060581182032693', 0, 1);
  t('-5.5918627371723343369781004783977834030666019473e+36', '-5591862737172334336978100478397783403.0666019472687818522119057', 10, 1);
  t('8.362497831801355477859900044042767114289e+31', '83624978318013554778599000440427.6711428894', 8, 1);
  t('137.3', '137.341112600854', 1, 1);
  t('17379904590994.27725043', '17379904590994.277250429976337', 8, 1);
  t('-0.60621', '-0.606208881308', 5, 1);
  t('38744', '38744.390233505840778545660298168992325038', 0, 1);
  t('170533872573340181578.91004924', '170533872573340181578.9100492413121007055651272048219539395306', 8, 1);
  t('0', '0.0000047362', 2, 1);
  t('-1523936.7405885338', '-1523936.7405885337867719583950329482600383855327226', 10, 1);
  t('-58446089958131727.025373', '-58446089958131727.025373434060170797492892', 6, 1);
  t('-4729094181.1', '-4729094181.11778391', 1, 1);
  t('1.01979778733735830237359817251e+24', '1019797787337358302373598.1725095410658909952834115082909671', 5, 1);
  t('-0.02128', '-0.0212811283274298550900009544', 5, 1);
  t('-9425489893588.98', '-9425489893588.9800401269333270769217550783', 2, 1);
  t('622587997.5626', '622587997.56256', 4, 1);
  t('3.7845328654165150700873884718853005151641384472585888545284e+54', '3784532865416515070087388471885300515164138447258588854.52836180967222074', 4, 1);
  t('-74.7', '-74.71697', 1, 1);
  t('-3.740882736979288061669172e+24', '-3740882736979288061669171.7', 0, 1);
  t('-1.343570291469338269679843664e+24', '-1343570291469338269679843.6637213713796529056849612263771571', 3, 1);
  t('0', '0.00005192083176237492100788000786884053842625', 1, 1);
  t('5260897810132.282564', '5260897810132.282563799600362294070', 6, 1);
  t('0', '0', 0, 1);
  t('2.060230767965580990040251487e+25', '20602307679655809900402514.869837307561474090776325879651263627244518872', 3, 1);
  t('-34', '-33.8594', 0, 1);
  t('-7', '-7.49', 0, 1);
  t('-0.000001639', '-0.00000163942310692491434432346648257477465124', 9, 1);
  t('-9.9021626373043956053556011585899140945874e+39', '-9902162637304395605355601158589914094587.4058805767590884741', 1, 1);
  t('-0.17149767', '-0.171497674765951662417692129904134', 8, 1);
  t('-7.68657764', '-7.686577641177065448311154300', 8, 1);
  t('-5463089078.55', '-5463089078.5499', 2, 1);
  t('0', '0.00009765108167483017723523200360038472782500342095634165', 3, 1);
  t('-60066284653119421907', '-60066284653119421907.02', 0, 1);
  t('18267219965812161.682716417', '18267219965812161.68271641735116607850169066422401918', 9, 1);
  t('-359823075.05', '-359823075.05184', 2, 1);
  t('7553178939.34286302152', '7553178939.342863021518180187118100472170706733103', 11, 1);
  t('37.66', '37.6629626', 2, 1);
  t('195129678672654.67533159826', '195129678672654.6753315982644258458702074835530772564', 11, 1);
  t('-3657626963769.5', '-3657626963769.536269724966', 1, 1);
  t('5.717653721376967382317720776658856639880399732296360651499406725e+62', '571765372137696738231772077665885663988039973229636065149940672.461780433870', 1, 1);
  t('-2.407349719715028091951237560575371262545331e+34', '-24073497197150280919512375605753712.625453314608', 8, 1);
  t('-6.4622277965591985368834499222516637572362747e+43', '-64622277965591985368834499222516637572362747.4', 0, 1);
  t('3012466875327212', '3012466875327212.4', 0, 1);
  t('1.673176376655786719519141454337050776069611476662e+42', '1673176376655786719519141454337050776069611.4766618332251964145156295512', 6, 1);
  t('1.13e-8', '0.0000000112567111305945', 10, 1);
  t('-135286346.87', '-135286346.86596090987128112491', 2, 1);
  t('116995056244446790768.91471', '116995056244446790768.914706121681375140971854835080239124462777', 5, 1);
  t('-33088.39496454', '-33088.394964535359912440962286892244713859961860774966', 8, 1);
  t('0.0029', '0.002885193676601631297646225699780092258488825849283430', 4, 1);
  t('-0.001', '-0.000704030345270927068850442923020087083', 3, 1);
  t('-1.51407647126853483913342837463e+26', '-151407647126853483913342837.463345209492150873648385567790658360709', 3, 1);
  t('0', '0', 0, 1);
  t('-5398341.98066801', '-5398341.98066800959', 8, 1);
  t('-8.288708420223118829114238753638493767494917749638444493534e+48', '-8288708420223118829114238753638493767494917749638.4444935337702366748194786', 9, 1);
  t('192907781641736378215.146', '192907781641736378215.14610049857389471404', 3, 1);
  t('78329278074221693.3', '78329278074221693.3133941436516666426043', 1, 1);
  t('-3.844371790823678015597142559385e+23', '-384437179082367801559714.25593849', 7, 1);
  t('21074805308.5927422', '21074805308.592742178918130048041802940662', 7, 1);
  t('-1930.9', '-1930.942124', 1, 1);
  t('-0.97293629', '-0.972936285382', 8, 1);
  t('-9.709400309860657906797403790106462e+22', '-97094003098606579067974.03790106462449351025312764568284545139277106780292', 11, 1);
  t('17831', '17830.98', 1, 1);
  t('-46544753121703122265.2713', '-46544753121703122265.27125112', 4, 1);
  t('-5.991334435581337500054321597e+28', '-59913344355813375000543215970.16537373853', 0, 1);
  t('0', '-0.0000001946909', 6, 1);
  t('233.7368876', '233.7368876445806317007863917653462120868746636783056773', 7, 1);
  t('1769.3998', '1769.3997977335036784261487149795516611933958166076767121595', 4, 1);
  t('-95018518199868.632', '-95018518199868.631881346636866877542576474815981572784160735439977118453', 3, 1);
  t('158147928.1317846256', '158147928.131784625606882039773678202142661445683308834511212124861965028525', 10, 1);
  t('-14.139240057', '-14.13924005743791', 9, 1);
  t('-125724980377360443.5580642', '-125724980377360443.55806419977907634317200', 7, 1);
  t('-73.034', '-73.0340', 3, 1);
  t('1681866.99', '1681866.986085', 2, 1);
  t('1.33601798152535223780330576969005726785169583538640675408963899841e+62', '133601798152535223780330576969005726785169583538640675408963899.84057', 3, 1);
  t('111', '110.6555', 0, 1);
  t('9', '9.099125417327897365947614504895516342775008058', 0, 1);
  t('-0.052016776', '-0.0520167761116816871032925156655990097', 9, 1);
  t('18229450755648.712341', '18229450755648.712340831354', 6, 1);
  t('2.6e-8', '0.000000026160038294472688099667', 9, 1);
  t('-1.7206688854743220363372359758867079461161087627710638664433972736242e+61', '-17206688854743220363372359758867079461161087627710638664433972.736241983', 6, 1);
  t('1', '1', 0, 1);
  t('1.2695107004330982000745571550387e+31', '12695107004330982000745571550387.32', 0, 1);
  t('0', '0.0005939767670372974905583467', 2, 1);
  t('8.02652023220212325908046032809925190557e+38', '802652023220212325908046032809925190556.5', 0, 1);
  t('-245.3', '-245.33097066', 1, 1);
  t('1.090226389834921673230331e+21', '1090226389834921673230.3310', 3, 1);
  t('1.401837692724662712631988597540334132135480114016365507751445200334e+59', '140183769272466271263198859754033413213548011401636550775144.52003338757', 7, 1);
  t('-0.0429803', '-0.0429803041', 7, 1);
  t('-837484961', '-837484960.51', 0, 1);
  t('-557608372863.374', '-557608372863.373921081728019772120728554175942502425671364031130', 3, 1);
  t('6.825202084728211879663190567e+25', '68252020847282118796631905.67084676539398210188429', 2, 1);
  t('33948609923840755629.304218', '33948609923840755629.304218064480684384308', 6, 1);
  t('-0.0357', '-0.03571534747616285470841646879235954336063067311362', 4, 1);
  t('-439747322686', '-439747322686.1', 0, 1);
  t('0', '0.000000822481121469906323328750556698695469952901211', 4, 1);
  t('95444.6519867', '95444.6519866587190337', 7, 1);
  t('-7.17015621327183952499082564e+22', '-71701562132718395249908.2563957094740145854388', 4, 1);
  t('-81132060708306341.811681685', '-81132060708306341.81168168450289157', 9, 1);
  t('-9.08360793483831940102708651965451e+28', '-90836079348383194010270865196.545143', 4, 1);
  t('-9.11354679479764129316286471970162778677559818557738185522798977e+57', '-9113546794797641293162864719701627786775598185577381855227.9897652', 5, 1);
  t('-1.20107336023', '-1.2010733602307560002266486134910603189900978971328542457027197223', 11, 1);
  t('-15955570843522957.816', '-15955570843522957.8160770200916500451217450313739195578676', 3, 1);
  t('-111.4943366', '-111.4943365989469234', 7, 1);
  t('393.45234', '393.452340', 5, 1);
  t('1987200778481096003', '1987200778481096003.16', 0, 1);
  t('-7202.8', '-7202.80351', 2, 1);
  t('1732487169109154', '1732487169109153.52627277901881882865792751811312733979132760882', 0, 1);
  t('-8.770612191350956121181448768884081992044658126083387868221336e+56', '-877061219135095612118144876888408199204465812608338786822.13364626776086839', 4, 1);
  t('-76.350859562', '-76.350859561627852755222958', 9, 1);
  t('14355.401', '14355.401447712201680807651283669170933318382087626825204', 3, 1);
  t('-1449378859710864758.26773', '-1449378859710864758.26773309601951175854071779292282', 5, 1);
  t('369802.55569961', '369802.555699610300566368213049437766039899940979268573160115903', 8, 1);
  t('-8988273856', '-8988273855.87818747196544722', 0, 1);
  t('3.7490866818249648752537859531214733687327658435e+37', '37490866818249648752537859531214733687.3276584345286843889253209929', 9, 1);
  t('-425752860.9332964', '-425752860.93329641196271410201809839254840862905389622', 7, 1);
  t('-4.60654192082043464308466467412e+28', '-46065419208204346430846646741.236632587152498106407144958650724081014624394', 1, 1);
  t('296346.3', '296346.25871', 1, 1);
  t('250685207', '250685206.77', 0, 1);
  t('-1.7537550489691833353467395256e+21', '-1753755048969183335346.73952559599863783171656860631880307873', 8, 1);
  t('-0.02358678', '-0.02358678465099879980932281725020008846931303833', 8, 1);
  t('-212.254562139', '-212.2545621390394289', 10, 1);
  t('-1311853939632005.3', '-1311853939632005.33217525413262599600344107894549742882485', 1, 1);
  t('-3.539793727968227919261506653423576395e+34', '-35397937279682279192615066534235763.946493594243196971211943568615379', 2, 1);
  t('529181484178613', '529181484178613.09', 0, 1);
  t('0', '0.0000008378207217740230407452', 1, 1);
  t('-3170391159000754.962', '-3170391159000754.9623327991753934895846400678', 3, 1);
  t('-1166.1865647', '-1166.186564702', 7, 1);
  t('0', '0.0000005065', 2, 1);
  t('-239408324760819.699', '-239408324760819.69896', 3, 1);
  t('-150', '-149.54', 0, 1);
  t('-6', '-5.7', 0, 1);
  t('5.982178131653128642563607607479e+30', '5982178131653128642563607607478.51598', 0, 1);
  t('114194344839831508.94887', '114194344839831508.9488704', 5, 1);
  t('-3', '-2.96948140508', 0, 1);
  t('0', '-0.00000178', 2, 1);
  t('-5.49560861202813506376830616e+22', '-54956086120281350637683.06157838610270962981835747228080444707773438697951', 4, 1);
  t('-1130', '-1129.7', 0, 1);
  t('-1.09622390091172445433959e+22', '-10962239009117244543395.87', 1, 1);
  t('4.1967409516931539323376833501876e+25', '41967409516931539323376833.50187593', 6, 1);
  t('488.4431', '488.443058881421', 4, 1);
  t('-3.341081197947358283406856754935400152922716824359441832062252350337092e+63', '-3341081197947358283406856754935400152922716824359441832062252350.33709238596', 6, 1);
  t('-0.0001', '-0.000131', 4, 1);
  t('-2811137', '-2811137.0', 0, 1);
  t('-6.8518242119095136588703752785064861293918e+33', '-6851824211909513658870375278506486.12939181706060680111320378931', 7, 1);
  t('0', '-0.000001158412390171247036611398535301441492397427860549381', 1, 1);
  t('-1.8457310857905680733220158103e+26', '-184573108579056807332201581.03157560162525421016385805', 2, 1);
  t('26035515.3765696', '26035515.3765696412799599329272502540947186361836163857925494614375654502', 7, 1);
  t('-0.00015697544', '-0.00015697544492028121161565046082349574494206132949', 11, 1);
  t('0', '-0.00000922', 4, 1);
  t('-2.9710955860835260512433819239889924e+30', '-2971095586083526051243381923988.9923792511653901141196', 4, 1);
  t('4812', '4812.08', 0, 1);
  t('323873569.9', '323873569.8538583293929536318', 1, 1);
  t('-0.05', '-0.0525345488873151519197355747109516567762564531998894232967588627795646124839', 2, 1);
  t('-3.749856289691268920412813776399690267e+25', '-37498562896912689204128137.7639969026712577799317', 11, 1);
  t('15760520075', '15760520075.2077272585674595951', 0, 1);
  t('0.000002', '0.000002047301347967023214702141475464067271617001839618440963176162442171', 7, 1);
  t('-37958888589732.18', '-37958888589732.17646343', 2, 1);
  t('0.00038335414', '0.00038335414145913803544666166332132', 11, 1);
  t('412', '412.115631', 0, 1);
  t('0.7858', '0.78583053497689849277819', 4, 1);
  t('12145011.6834', '12145011.683373', 4, 1);
  t('-2599841469120502', '-2599841469120502.30054715279289266251072312479714125516139560932248677', 0, 1);
  t('-1.9e-8', '-0.00000001915099862196171556902231592931', 9, 1);
  t('-1360750129010445875', '-1360750129010445875.3', 0, 1);

  t('5667.86424', '5667.86423613606', 5, 2);
  t('77064.18', '77064.1808', 2, 2);
  t('-16', '-15.6194', 0, 2);
  t('1', '1', 0, 2);
  t('0', '-0.0198831139', 1, 2);
  t('0.000001', '0.0000010773756787', 6, 2);
  t('1.664e-7', '0.000000166404881860', 11, 2);
  t('-4992.662407', '-4992.66240693950', 6, 2);
  t('0.000005', '0.000005323614362503', 6, 2);
  t('0', '0.000045730652367143', 4, 2);
  t('86122.4', '86122.381', 1, 2);
  t('0.0006972', '0.00069715250388650', 7, 2);
  t('-0.00307929', '-0.00307929245183', 8, 2);
  t('-1', '-1', 0, 2);
  t('114897406', '114897405.57', 0, 2);
  t('-511095586.0277', '-511095586.027694', 4, 2);
  t('-2439169322144', '-2439169322144.0', 0, 2);
  t('192429067', '192429067.3', 0, 2);
  t('1.6075e-7', '0.00000016074832889101', 11, 2);
  t('-66', '-66.35', 0, 2);
  t('567704214424', '567704214424.05', 1, 2);
  t('-98', '-97.61165691706', 0, 2);
  t('50611.68', '50611.681', 2, 2);
  t('-11781.4', '-11781.4484', 1, 2);
  t('0.353525', '0.3535253268', 6, 2);
  t('-5156552075', '-5156552075.0', 0, 2);
  t('6.3', '6.290', 1, 2);
  t('-35.18471', '-35.18471189', 5, 2);
  t('0', '-0.00000020599568', 4, 2);
  t('0', '-0.0000032547092901614', 1, 2);
  t('43415', '43415.078', 0, 2);
  t('145', '145.07', 0, 2);
  t('18511', '18510.93', 0, 2);
  t('-126', '-125.705879', 0, 2);
  t('-1', '-1', 0, 2);
  t('84', '84.41', 0, 2);
  t('-632', '-631.8801', 0, 2);
  t('-918.8', '-918.828', 1, 2);
  t('24537', '24536.7774', 0, 2);
  t('649.3', '649.3069', 1, 2);
  t('-0.00054', '-0.0005358424700', 5, 2);
  t('-252098.69483', '-252098.6948257', 5, 2);
  t('-2', '-1.83', 0, 2);
  t('-2602891.6709', '-2602891.67089836', 4, 2);
  t('-111', '-110.70', 0, 2);
  t('0', '0.0000000205365', 0, 2);
  t('756162.23', '756162.234812', 2, 2);
  t('-9.5', '-9.456', 1, 2);
  t('-4347477', '-4347477.0', 0, 2);
  t('-194481859.7', '-194481859.7352', 1, 2);
  t('19.39', '19.3874', 2, 2);
  t('3', '3.28', 0, 2);
  t('4689610.3', '4689610.2868', 1, 2);
  t('1.63784942', '1.63784942078', 8, 2);
  t('-52', '-52.07', 0, 2);
  t('151664', '151664.282', 0, 2);
  t('654516815715', '654516815714.8', 0, 2);
  t('155', '155.298', 0, 2);
  t('129895589', '129895589.16', 0, 2);
  t('3', '3', 0, 2);
  t('-4', '-3.8', 0, 2);
  t('0', '0.0000003065761', 3, 2);
  t('-1166.691', '-1166.69117213', 3, 2);
  t('143367', '143366.6367', 0, 2);
  t('4', '3.78', 0, 2);
  t('5879635', '5879635.3', 0, 2);
  t('-28637', '-28636.732841956', 0, 2);
  t('85', '84.8', 0, 2);
  t('-110332204', '-110332204.4', 0, 2);
  t('-11', '-10.78', 0, 2);
  t('43.13178', '43.131779781', 6, 2);
  t('-24518', '-24518.0', 0, 2);
  t('0', '0.000000037550093872', 0, 2);
  t('-2826.714', '-2826.71372', 3, 2);
  t('0', '0.0000016424239140301', 2, 2);
  t('3e-7', '0.0000002551065510', 7, 2);
  t('0.005', '0.0045833', 3, 2);
  t('-5344653.4', '-5344653.399', 1, 2);
  t('-0.0714449199', '-0.07144491994', 10, 2);
  t('-44', '-44.3', 0, 2);
  t('-3', '-2.8', 0, 2);
  t('525726486.328', '525726486.32840', 3, 2);
  t('-48786108.8837', '-48786108.8837116', 4, 2);
  t('519553', '519552.96837', 1, 2);
  t('3', '2.51', 0, 2);
  t('3', '3', 0, 2);
  t('-0.003', '-0.00252341812981132', 3, 2);
  t('72.156', '72.15606', 3, 2);
  t('-7.2', '-7.206', 1, 2);
  t('0', '0.000000470', 4, 2);
  t('0', '-0.015210270', 0, 2);
  t('6', '6.377', 0, 2);
  t('0', '0.0243542304268736', 0, 2);
  t('3173.4', '3173.3541', 1, 2);
  t('-14.01', '-14.0131', 2, 2);
  t('-11', '-11.2', 0, 2);
  t('-39323844147.9', '-39323844147.8556', 1, 2);
  t('0', '0.0000025984686009', 1, 2);
  t('2.121038', '2.1210379', 6, 2);
  t('-0.032298452', '-0.03229845202271', 9, 2);
  t('-2231', '-2230.6', 0, 2);
  t('-0.10617305', '-0.106173047187', 8, 2);
  t('-0.07914', '-0.079142689', 5, 2);
  t('3.6', '3.63105', 1, 2);
  t('-105', '-104.749', 0, 2);
  t('8608', '8607.64', 0, 2);
  t('0', '-0.000000036533159941', 3, 2);
  t('-9024.69', '-9024.69428198619', 2, 2);
  t('-2.62', '-2.6230644095', 2, 2);
  t('-157089.64', '-157089.63972', 2, 2);
  t('10996853', '10996853.27', 0, 2);
  t('17310821', '17310821.17', 0, 2);
  t('553164825599', '553164825598.9', 0, 2);
  t('-439409.7903', '-439409.79027156', 4, 2);
  t('1', '1.4', 0, 2);
  t('0', '0.00000283594273', 1, 2);
  t('-3160627.8', '-3160627.79', 1, 2);
  t('0', '-0.0000000122', 3, 2);
  t('13.09', '13.0947284881', 2, 2);
  t('7.6', '7.611', 1, 2);
  t('1', '1', 0, 2);
  t('-4', '-3.9', 0, 2);
  t('-3.8e-7', '-0.000000380008000605611', 9, 2);
  t('0', '-0.03867276', 1, 2);
  t('-0.0000013587', '-0.0000013587446', 10, 2);
  t('0', '0.000013922335687903', 4, 2);
  t('6336358769268', '6336358769268.1', 0, 2);
  t('-662049', '-662048.52', 0, 2);
  t('-14691.03', '-14691.0266', 2, 2);
  t('0', '-0.000000111042466941', 0, 2);
  t('-0.08', '-0.08023', 3, 2);
  t('13.65', '13.64845611', 2, 2);
  t('0', '0.0000003093585', 2, 2);
  t('-107.797', '-107.797035141', 4, 2);
  t('29', '28.951', 0, 2);
  t('1546.85541', '1546.855413', 5, 2);
  t('0', '0.00000001346', 7, 2);
  t('-7090.7', '-7090.6973785', 1, 2);
  t('-0.0000014', '-0.0000013773530', 7, 2);
  t('199960', '199960.1', 0, 2);
  t('3798', '3798.09', 0, 2);
  t('-1798.64605', '-1798.6460536', 5, 2);
  t('7.3', '7.255058', 1, 2);
  t('5619255', '5619254.78958842', 0, 2);
  t('-1.55', '-1.549', 2, 2);
  t('42954.2807', '42954.2806920', 4, 2);
  t('-0.1', '-0.12145613', 1, 2);
  t('130095.1664', '130095.16644', 4, 2);
  t('0.001', '0.00080', 3, 2);
  t('-0.01361', '-0.0136069442553064', 5, 2);
  t('0', '0.000323', 3, 2);
  t('5', '4.8', 0, 2);
  t('0', '0', 0, 2);
  t('-38443', '-38443.3', 0, 2);
  t('7068981', '7068981.4', 0, 2);
  t('1254', '1253.9', 0, 2);
  t('94', '93.97', 0, 2);
  t('225319314', '225319313.982', 1, 2);
  t('43188727.7496', '43188727.749556', 4, 2);
  t('30.68', '30.68362777706', 2, 2);
  t('-28688.6', '-28688.607192', 1, 2);
  t('5', '5.397', 0, 2);
  t('80905094745458', '80905094745457.7', 0, 2);
  t('0', '-0.000000501548601278879', 0, 2);
  t('0', '0.009603', 0, 2);
  t('3', '3', 0, 2);
  t('11.9653', '11.9652973', 4, 2);
  t('12', '12.28128', 0, 2);
  t('473038.6', '473038.60250505', 2, 2);
  t('581.9327851756', '581.932785175634', 10, 2);
  t('7e-8', '0.0000000709', 8, 2);
  t('-7.55e-7', '-0.000000755476359308', 9, 2);
  t('1359295.232', '1359295.23220', 3, 2);
  t('206514', '206514.058', 0, 2);
  t('6227', '6226.64', 0, 2);
  t('11458.71', '11458.7128784935', 2, 2);
  t('0', '-0.000000463030076', 0, 2);
  t('-68498', '-68497.90318', 0, 2);
  t('0', '-0.000000052923214', 4, 2);
  t('-47276919', '-47276918.6', 0, 2);
  t('-1.5', '-1.498618', 2, 2);
  t('-1227652019', '-1227652018.70982', 0, 2);
  t('0', '0.0000076395117470', 3, 2);
  t('606', '606.2', 0, 2);
  t('-31.1', '-31.053', 1, 2);
  t('1241258.5419', '1241258.54190', 4, 2);
  t('0', '0.0000000199335', 2, 2);
  t('-0.000012511', '-0.0000125113106926', 9, 2);
  t('25', '24.53659035', 0, 2);
  t('1', '1', 0, 2);
  t('0', '0', 0, 2);
  t('70.08', '70.0755513', 2, 2);
  t('13.564', '13.5640339577', 4, 2);
  t('0', '-0.0011', 0, 2);
  t('-452388079', '-452388079.23774', 0, 2);
  t('-3662306', '-3662305.7', 0, 2);
  t('668443163.952', '668443163.9523', 3, 2);
  t('238', '237.55', 0, 2);
  t('5180946', '5180946.29', 0, 2);
  t('0.01055950429', '0.0105595042884', 11, 2);
  t('0.00103', '0.00103103380', 5, 2);
  t('0', '-0.0000595562092852', 2, 2);
  t('304638', '304637.7', 0, 2);
  t('0', '0', 0, 2);
  t('-2698', '-2698.1', 0, 2);
  t('0', '0', 0, 2);
  t('21', '20.8', 0, 2);
  t('-1056.322598', '-1056.3225978', 6, 2);
  t('0', '-0.000046561', 1, 2);
  t('-14721', '-14721.41', 0, 2);
  t('5', '5.2', 0, 2);
  t('0.0003355981', '0.0003355980531', 10, 2);
  t('30242.6', '30242.568924', 1, 2);
  t('22008', '22007.913', 0, 2);
  t('-5', '-5', 0, 2);
  t('-4.27838', '-4.278383126', 5, 2);
  t('5', '5', 0, 2);
  t('38.3127', '38.312706', 4, 2);
  t('-3.01', '-3.0087', 2, 2);
  t('-0.00000727', '-0.00000727017231697', 8, 2);
  t('0', '0.46', 0, 2);
  t('1', '1', 0, 2);
  t('187.243', '187.242942', 3, 2);
  t('9230.5', '9230.541', 1, 2);
  t('0', '0.0000001277', 5, 2);
  t('-8', '-8.0', 0, 2);
  t('6', '6.0', 0, 2);
  t('0', '0', 0, 2);
  t('-25311.7', '-25311.7440865', 1, 2);
  t('-0.0003877', '-0.000387687300056204', 7, 2);
  t('-0.00000323316', '-0.0000032331642940', 11, 2);
  t('-3579', '-3579.4492471', 0, 2);
  t('3', '2.98', 0, 2);
  t('8', '8', 0, 2);
  t('0.0004405', '0.0004404793064989', 7, 2);
  t('1719738619', '1719738618.551', 0, 2);
  t('2.0795288519', '2.07952885187153', 10, 2);
  t('28', '27.6', 0, 2);
  t('0', '-0.000015689532077', 2, 2);
  t('1.4', '1.4454', 1, 2);
  t('60431664855', '60431664854.62', 0, 2);
  t('0', '0', 0, 2);
  t('-5023632794932', '-5023632794932.45', 0, 2);
  t('-467912.6151184', '-467912.615118399', 8, 2);
  t('0', '0.00000002973', 7, 2);
  t('1', '1.37623744313', 0, 2);
  t('1.315e-7', '0.00000013146985447', 10, 2);
  t('-108611.3', '-108611.2508332', 1, 2);
  t('-943067401.709', '-943067401.70877', 3, 2);
  t('-432.151', '-432.1509', 3, 2);
  t('1', '1.1', 0, 2);
  t('-7.2231653903', '-7.22316539034098', 10, 2);
  t('13244016829', '13244016828.583', 0, 2);
  t('84.80426237', '84.80426237130', 8, 2);
  t('-2822', '-2821.8', 0, 2);
  t('-263.88744', '-263.887436', 5, 2);
  t('-10.52978', '-10.529783949205', 5, 2);
  t('-384', '-383.855', 0, 2);
  t('-2', '-2', 0, 2);
  t('-2', '-2', 0, 2);
  t('50.8', '50.7962', 2, 2);
  t('-3.2', '-3.179', 1, 2);
  t('0', '0.000000129191', 6, 2);
  t('-20', '-20.4', 0, 2);
  t('-10273', '-10273.09414', 0, 2);
  t('-0.000002', '-0.00000195206031', 7, 2);
  t('1.7', '1.725', 1, 2);
  t('0', '-0.000000081111', 2, 2);
  t('1051982', '1051981.971507', 1, 2);
  t('-791.5', '-791.5303', 1, 2);
  t('782.5', '782.50257403', 1, 2);
  t('1683.653', '1683.6533622', 3, 2);
  t('0', '0.000001830912258987', 0, 2);
  t('1', '1', 0, 2);
  t('1', '1', 0, 2);
  t('3', '3', 0, 2);
  t('0', '0.1979406187210', 0, 2);
  t('-1619.03', '-1619.02757', 2, 2);
  t('19.818364', '19.81836358', 6, 2);
  t('2285', '2285.1', 0, 2);
  t('-10.301469014', '-10.3014690136647', 9, 2);
  t('-425432259761', '-425432259760.75', 0, 2);
  t('-0.00372', '-0.0037240613948967', 5, 2);
  t('69860', '69859.9', 0, 2);
  t('47', '47.48', 0, 2);
  t('-7.339e-7', '-0.000000733890', 10, 2);
  t('-972.7579343', '-972.75793426542', 7, 2);
  t('-0.000001', '-0.00000149104374921', 6, 2);
  t('9', '9', 0, 2);
  t('-98.21', '-98.20563090362', 2, 2);
  t('2', '2', 0, 2);
  t('4509.793', '4509.79347', 3, 2);
  t('-1', '-1.480', 0, 2);
  t('6', '6', 0, 2);
  t('2160.6', '2160.64199500', 1, 2);
  t('0', '-0.000000051998', 2, 2);
  t('-9001064240', '-9001064240.17', 0, 2);
  t('-7', '-7', 0, 2);
  t('3', '3.0', 0, 2);
  t('0', '-0.05955', 0, 2);
  t('0', '-0.00059', 2, 2);
  t('-3', '-3.03', 0, 2);
  t('23729292333', '23729292333.3', 0, 2);
  t('13.196304207', '13.1963042065158', 9, 2);
  t('8941.7', '8941.705', 1, 2);
  t('-397.2', '-397.248', 1, 2);
  t('79974871', '79974870.90', 0, 2);
  t('-86.67', '-86.6730', 2, 2);
  t('-2', '-2.4', 0, 2);
  t('1', '1.24', 0, 2);
  t('-0.0046931', '-0.004693142692', 7, 2);
  t('-7.55e-7', '-0.000000755159902862', 9, 2);
  t('0.000004', '0.0000038816', 6, 2);
  t('-88', '-88.4', 0, 2);
  t('329004398.76', '329004398.759', 2, 2);
  t('443076211', '443076211.10', 0, 2);
  t('30.959959', '30.959958807', 6, 2);
  t('12758.018', '12758.017742049', 3, 2);
  t('-0.0002', '-0.000164638', 4, 2);
  t('1', '1', 0, 2);
  t('0', '-0.0000000165739', 7, 2);
  t('-4.2995384', '-4.29953836', 7, 2);
  t('601736976.15', '601736976.150075', 3, 2);
  t('-47', '-47.1', 0, 2);
  t('1284155', '1284155.04626171', 1, 2);
  t('-1135.68', '-1135.6757', 2, 2);
  t('0', '0.00028', 1, 2);
  t('1.445e-7', '0.00000014454442544152', 10, 2);
  t('99022342', '99022342.4', 0, 2);
  t('-708723900.986', '-708723900.98621', 3, 2);
  t('8', '8', 0, 2);
  t('-1', '-1', 0, 2);
  t('14277', '14277.32', 0, 2);
  t('-57.9', '-57.896496', 2, 2);
  t('-18725', '-18724.7876', 0, 2);
  t('-1', '-1.19', 0, 2);
  t('0', '-0.000000187910472', 0, 2);
  t('18459.974', '18459.9742236', 3, 2);
  t('-1.9661e-7', '-0.0000001966121396', 11, 2);
  t('-4.74729273', '-4.7472927339', 8, 2);
  t('10336.224', '10336.22357215', 3, 2);
  t('2', '2.453', 0, 2);
  t('-25', '-25.38757910', 0, 2);
  t('1', '1.3', 0, 2);
  t('838324.5', '838324.508', 1, 2);
  t('-7.8925', '-7.892491', 4, 2);
  t('-2', '-2', 0, 2);
  t('-0.5', '-0.50243', 2, 2);
  t('0.029', '0.029151', 3, 2);
  t('-42', '-42.4', 0, 2);
  t('1', '1.0', 0, 2);
  t('45912', '45912.2', 0, 2);
  t('0', '0.00015657800066464', 1, 2);
  t('-1748153.392', '-1748153.3919800', 3, 2);
  t('238004.648', '238004.6478', 3, 2);
  t('2', '1.5', 0, 2);
  t('0', '0', 0, 2);
  t('-102311032', '-102311031.74', 0, 2);
  t('-4', '-4.0', 0, 2);
  t('3', '3', 0, 2);
  t('0', '0.000004289664163', 4, 2);
  t('7664', '7663.80', 0, 2);
  t('0.00001', '0.000009614318297914', 5, 2);
  t('-2282479', '-2282478.656', 0, 2);
  t('0', '0.000000072841279100687', 0, 2);
  t('0.007691', '0.007691210', 6, 2);
  t('-6769.1', '-6769.0580574', 1, 2);
  t('8.2', '8.1702', 1, 2);
  t('-2', '-1.5', 0, 2);
  t('0.000001', '0.00000127393387', 6, 2);
  t('14.89622241299', '14.896222412990', 11, 2);
  t('19.3', '19.329', 1, 2);
  t('9', '9', 0, 2);
  t('-19173078.84', '-19173078.84450', 2, 2);
  t('-8415778', '-8415777.87', 0, 2);
  t('-3217.695', '-3217.695232', 3, 2);
  t('0.253097', '0.2530971625', 6, 2);
  t('11', '11.0', 0, 2);
  t('-285.4', '-285.3955790', 1, 2);
  t('-12940', '-12939.90', 0, 2);
  t('-4546', '-4546.00', 0, 2);
  t('16063804427', '16063804427.00', 0, 2);
  t('213549801.564', '213549801.5643', 3, 2);
  t('0', '0.0000020', 5, 2);
  t('-0.001597', '-0.00159656504863', 6, 2);
  t('-3', '-3', 0, 2);
  t('2789.1258', '2789.12575845882', 4, 2);
  t('20', '20.08', 0, 2);
  t('-278253', '-278253.335', 0, 2);
  t('5155197036', '5155197036.08', 0, 2);
  t('0', '0.000090532', 1, 2);
  t('0.0000098766', '0.00000987655338039', 10, 2);
  t('-140130180.467', '-140130180.466561', 3, 2);
  t('641', '640.5733', 0, 2);

  t('-67285786000786430001.84171870243087110299464', '-67285786000786430001.8417187024308711029946448897932826', 23, 2);
  t('9.448956481724741409276350694692e+31', '94489564817247414092763506946919.8', 0, 2);
  t('3.9859538341143269291710936210864682461858568393e+42', '3985953834114326929171093621086468246185856.839308', 4, 2);
  t('0.213160682590482673720123', '0.21316068259048267372012300014571642637779193717', 24, 2);
  t('5.72565350402356154220096385167682e+31', '57256535040235615422009638516768.225', 1, 2);
  t('9827312', '9827312.47', 0, 2);
  t('-2.2564988241271537703332692244064362415604326645258e+32', '-225649882412715377033326922440643.624156043266452575589', 17, 2);
  t('1.66707495526148873561077484048960432973187660089798073324972e+43', '16670749552614887356107748404896043297318766.00897980733249721644878650173799', 16, 2);
  t('-0.0000071107308186824690925689846775808645266157065951834776704', '-0.00000711073081868246909256898467758086452661570659518347767037593811212465683211', 61, 2);
  t('-3', '-2.7', 0, 2);
  t('-124072473283894719.8715', '-124072473283894719.87148942', 4, 2);
  t('-938632.1357753642335703748125308124878707', '-938632.1357753642335703748125308124878706553070', 34, 2);
  t('39285', '39285.4', 0, 2);
  t('-45794', '-45793.50873140400806620555552893025547', 0, 2);
  t('0.00043', '0.00043106', 5, 2);
  t('18', '17.73', 0, 2);
  t('6887378876161819.67479130637439655936364361', '6887378876161819.67479130637439655936364361410', 26, 2);
  t('-1.1960916e-8', '-0.0000000119609155768816951932628381810701975669492665', 15, 2);
  t('1.828237972677109386632976406084191004086430106300561e+36', '1828237972677109386632976406084191004.08643010630056121370', 15, 2);
  t('-17303', '-17303.3408', 0, 2);
  t('-19559', '-19559.46', 0, 2);
  t('-2776522865791539.58044671387378715834122857', '-2776522865791539.580446713873787158341228571654967', 26, 2);
  t('0.076856590227331010541737834596785248134670483538', '0.0768565902273310105417378345967852481346704835376204807182192445', 48, 2);
  t('0', '0.00245', 1, 2);
  t('-3.41389637403613085735112909331883540231314050519e+47', '-341389637403613085735112909331883540231314050519.00860662913317', 0, 2);
  t('-368492.440703113657551617159', '-368492.4407031136575516171594705959653971098906752876011', 21, 2);
  t('-0.00076499312776788732685735417680687', '-0.000764993127767887326857354176806868723015882585141', 35, 2);
  t('10', '9.7', 0, 2);
  t('330102494712310331.12306063', '330102494712310331.123060634144064300', 8, 2);
  t('-0.000003226553114636545996352307137343217224761657145083011751164580439393196', '-0.0000032265531146365459963523071373432172247616571450830117511645804393931964', 75, 2);
  t('1.5702336798860813312183359e+23', '157023367988608133121833.5855612719027316361101408', 2, 2);
  t('0.420659864842', '0.4206598648416116', 12, 2);
  t('759760850.828060083330170495', '759760850.8280600833301704946713858114861864875449552519487198', 18, 2);
  t('1099597660.162386930330972024346573920574311743321057000285499', '1099597660.1623869303309720243465739205743117433210570002854989', 51, 2);
  t('3739531.055716347318685950986625837615439', '3739531.05571634731868595098662583761543850359', 33, 2);
  t('-0.14543253925259458', '-0.14543253925259457747232564', 17, 2);
  t('3.5', '3.50814', 1, 2);
  t('-5.41454379798682504099699334458753424877e+37', '-54145437979868250409969933445875342487.6861', 1, 2);
  t('205750716.75', '205750716.7462395939087377087656350896709751', 2, 2);
  t('0.00066278', '0.000662776584984111370072905287425443201916618952335', 8, 2);
  t('0', '0.0000016117928', 5, 2);
  t('-0.00003', '-0.000032768380546', 5, 2);
  t('0.00496970433228', '0.00496970433228023649', 14, 2);
  t('-98855802', '-98855801.857', 0, 2);
  t('0.019831116', '0.01983111585118373352634551962622475581387392672786862266', 9, 2);
  t('-1.250497797600278700528421637022e+26', '-125049779760027870052842163.7022267607', 4, 2);
  t('-1.0703480882326315629356124788024935893e+23', '-107034808823263156293561.24788024935893194454', 14, 2);
  t('14.3782725', '14.378272540813426603840567432608467558210983286187231978794388200', 7, 2);
  t('0.130309272828', '0.13030927282839862022799474014968156901', 12, 2);
  t('-98.2367', '-98.2366524', 4, 2);
  t('-9', '-9.334695', 0, 2);
  t('-1.51505681615472494415896e+22', '-15150568161547249441589.558', 1, 2);
  t('-33996868251851100.585', '-33996868251851100.58496619754005488500403', 4, 2);
  t('0', '-0.0000000445570', 4, 2);
  t('-8.433637457626482976280018539173129453591e+21', '-8433637457626482976280.01853917312945359095583331656603718400547595544859', 19, 2);
  t('1334988745.761857839', '1334988745.761857839379796', 9, 2);
  t('-0.022225', '-0.0222249250847738107161776348', 6, 2);
  t('8.684754443744498618422872261580837e+34', '86847544437444986184228722615808370.19657421100', 0, 2);
  t('2.922024257428597556034287345124912344450293834e+45', '2922024257428597556034287345124912344450293833.8129215408521595652', 0, 2);
  t('0.0000648445133383637987208162047581', '0.000064844513338363798720816204758098469664554078934548313142281617460359733', 35, 2);
  t('390329802.648019727629713525697316674630011', '390329802.6480197276297135256973166746300111125272836200796445049', 33, 2);
  t('-258.7377120823', '-258.7377120823111', 10, 2);
  t('-0.0009685', '-0.000968500150771686937989972375065545', 7, 2);
  t('0', '0.00001567480449354560092932487475', 1, 2);
  t('-39106865762460584826.61', '-39106865762460584826.6134373', 2, 2);
  t('-2024356012607685.91210486332', '-2024356012607685.91210486331556459161280069', 11, 2);
  t('4.2272584512300583139927e+21', '4227258451230058313992.658', 1, 2);
  t('0.0459', '0.0458919371347914920702113541006466518199441673180948648147920516', 4, 2);
  t('4.0788686840632834035954963974683420880173963e+35', '407886868406328340359549639746834208.8017396288009080302177256123451', 8, 2);
  t('-0.00009', '-0.00008871177', 5, 2);
  t('0.0061668373803029681902308465080502801072', '0.006166837380302968190230846508050280107153425', 40, 2);
  t('-1040007630812.941015034179', '-1040007630812.94101503417886495', 12, 2);
  t('0.000136472595912', '0.0001364725959115254910859356482798544', 15, 2);
  t('-0.0153267716907368139410051956675888180198889155020425400611', '-0.01532677169073681394100519566758881801988891550204254006110507', 58, 2);
  t('5180625731910.5', '5180625731910.48668196960520', 1, 2);
  t('764175553.46592562879911554228354', '764175553.4659256287991155422835439198583518', 23, 2);
  t('-49791487687634.462954323763995', '-49791487687634.46295432376399496348733626', 15, 2);
  t('-2.075420216421173225959162452422753893506711747533e+25', '-20754202164211732259591624.5242275389350671174753304991285873546862637315407', 24, 2);
  t('-5.0054055085399355972769643870056428632554707684e+33', '-5005405508539935597276964387005642.863255470768395', 13, 2);
  t('1.951622761635077663716034563192653e+26', '195162276163507766371603456.31926525141507523396', 7, 2);
  t('-61836437247095674305', '-61836437247095674304.85', 0, 2);
  t('0.00000120046184768718310251206266', '0.00000120046184768718310251206265650997614905779334067390449317101', 32, 2);
  t('-1.321291387358977659751752369056414212658859828663888695e+44', '-132129138735897765975175236905641421265885982.8663888695420', 10, 2);
  t('-0.0225061581484051054706509', '-0.02250615814840510547065090236991166716445044354', 26, 2);
  t('-1.03734592047984313101196852354224e+32', '-103734592047984313101196852354224.3', 0, 2);
  t('6.0714968914457709837688505913972e-8', '0.000000060714968914457709837688505913972273472036648067644984631337385932792384', 39, 2);
  t('-4.424689440563e-7', '-0.00000044246894405625465334491186253836069633565915798651696937138992', 19, 2);
  t('361930101457674.9123152981212660394276621424572552', '361930101457674.91231529812126603942766214245725524852174544050431945', 34, 2);
  t('-0.00551777897795307941', '-0.0055177789779530794063565568726718111', 20, 2);
  t('1320022156327195304.2862', '1320022156327195304.2862467363', 4, 2);
  t('1.393406492071950292273457068e+21', '1393406492071950292273.45706820527079320873560107472', 6, 2);
  t('1.0269197e-8', '0.0000000102691965991750033577123127518408689885755178', 15, 2);
  t('610.7330267607358798510856', '610.73302676073587985108562182554617995657512357222962606228', 22, 2);
  t('475.45356645', '475.4535664469763', 8, 2);
  t('39308353.674244163460792', '39308353.67424416346079199508314279800891292', 16, 2);
  t('-0.00000111247061906829296287242333901057862623715694', '-0.0000011124706190682929628724233390105786262371569355158932082', 50, 2);
  t('0.0036', '0.003600002894710703226857784186834678814556423748484289043243180803', 4, 2);
  t('1.4367015106015220124311611649076291214791241904e+43', '14367015106015220124311611649076291214791241.9044067465338279610', 3, 2);
  t('-0.0000049', '-0.00000492474514844', 7, 2);
  t('-2682.992534525157856663314343338249605843', '-2682.9925345251578566633143433382496058430938', 36, 2);
  t('-0.0047789493954347727115716166553271462130155068', '-0.004778949395434772711571616655327146213015506797742', 46, 2);
  t('29976620808732.3', '29976620808732.341', 1, 2);
  t('34467049.3544601338724540364', '34467049.3544601338724540364064', 19, 2);
  t('7', '7', 0, 2);
  t('-662133.00465205638', '-662133.0046520563776', 11, 2);
  t('2.44788852354438130340107042634297800959715e+40', '24478885235443813034010704263429780095971.50919918', 1, 2);
  t('5.5840020568373290858000711571918227643588141e+29', '558400205683732908580007115719.18227643588141420171245503157', 14, 2);
  t('-0.06109533751309145375766889907329830495281437343', '-0.0610953375130914537576688990732983049528143734300275841', 49, 2);
  t('-3', '-3', 0, 2);
  t('0.0000116350328781581323214913277691', '0.0000116350328781581323214913277691443607512', 34, 2);
  t('-2433982989070.4', '-2433982989070.403', 1, 2);
  t('-7.0167184965701058927533986398937262620399996279594e+33', '-7016718496570105892753398639893726.262039999627959364032', 16, 2);
  t('-8.9000106900925293578691833690040840525929e+40', '-89000106900925293578691833690040840525928.91', 0, 2);
  t('0.000054203379804599615157434163794162966', '0.000054203379804599615157434163794162965957412837278234', 40, 2);
  t('-2127366.224397134733738444', '-2127366.224397134733738443958576561654947612', 19, 2);
  t('4.798500859389719185990153286257486251359951905454e+36', '4798500859389719185990153286257486251.35995190545445017015607', 12, 2);
  t('8.3200499567357591546481e-8', '0.00000008320049956735759154648073267451497555299882333529487356431749492990511', 30, 2);
  t('-4049855209642613.651532624298979', '-4049855209642613.651532624298978612', 15, 2);
  t('13.58533', '13.5853339451327021829891', 5, 2);
  t('33657408.809293464588458245970704338672790222742028799', '33657408.809293464588458245970704338672790222742028799114506234331', 45, 2);
  t('-0.04157606948782812', '-0.0415760694878281231183691167081729081692459541479327758297294103600574911', 17, 2);
  t('0.2445904', '0.2445904471913271833048522773906687055584248941', 7, 2);
  t('-36537020339', '-36537020339.16141697788090075037424', 0, 2);
  t('4.630562796498611773739234434155312293599049865032851482061645e+59', '463056279649861177373923443415531229359904986503285148206164.49901872', 1, 2);
  t('1.7617343232685185747636e+22', '17617343232685185747636.4', 0, 2);
  t('1.525089712663928023613087842832e+21', '1525089712663928023613.0878428317813976498464747556820657268610', 9, 2);
  t('0.00038330994', '0.0003833099373942592', 11, 2);
  t('-0.0000015', '-0.000001543435020133316209445585022978853749590080', 7, 2);
  t('4.50094710942861848281692841507435565e+26', '450094710942861848281692841.507435564923465551', 9, 2);
  t('-0.00035850200532934193061574888771534', '-0.0003585020053293419306157488877153436004542078609868325', 35, 2);
  t('1.311043869294805642966391661328043356833640077333494177096852028409847e+69', '1311043869294805642966391661328043356833640077333494177096852028409846.9609', 0, 2);
  t('207.2388', '207.2388201250069484', 4, 2);
  t('12041993739.97', '12041993739.969781', 2, 2);
  t('-2077024113734199269.39343269', '-2077024113734199269.39343269273123', 8, 2);
  t('0', '0', 0, 2);
  t('5', '4.78577', 0, 2);
  t('230585.4224', '230585.4223915054695', 4, 2);
  t('-3', '-3', 0, 2);
  t('3.810109473503769848973037919997e+23', '381010947350376984897303.79199969464', 7, 2);
  t('25', '24.63', 0, 2);
  t('-6.716451397589143643551852912381968495578731e+26', '-671645139758914364355185291.238196849557873142082006', 16, 2);
  t('3.4571440605914848469882543452079004250591e+24', '3457144060591484846988254.3452079004250590953212', 16, 2);
  t('2.07813834137958074056402139226279661163e+37', '20781383413795807405640213922627966116.327287758', 1, 2);
  t('2.20811976073009562166804891911561429569e+38', '220811976073009562166804891911561429568.8714048', 0, 2);
  t('2821455730331145446.164894864', '2821455730331145446.164894863662', 9, 2);
  t('1.20328283658891555052353210123174774597875558777e+42', '1203282836588915550523532101231747745978755.58777211896105829042905229', 5, 2);
  t('2094', '2094.5', 0, 2);
  t('-1.46309380694124829132018162108068176509032446141953221528591461e+63', '-1463093806941248291320181621080681765090324461419532215285914609.88', 0, 2);
  t('0.000001098105705433025064601749605', '0.0000010981057054330250646017496051056659564434089372848599897061', 33, 2);
  t('54180309.5737671311731383357', '54180309.5737671311731383356938538', 19, 2);
  t('-1.3446620287542373065048354e+24', '-1344662028754237306504835.370385643357826543914532179239449995256077396252', 1, 2);
  t('260.21288924583334713616284047849875533', '260.2128892458333471361628404784987553320', 35, 2);
  t('1.240425698711451610006525', '1.2404256987114516100065247472595218334587180888317317562184323937', 24, 2);
  t('-0.0782583611183', '-0.078258361118346105370946044305759035074', 13, 2);
  t('-32251186716.4112827815640577', '-32251186716.411282781564057698891811073', 16, 2);
  t('2.30816210064841495287372520638020007782784097576420030091493e+55', '23081621006484149528737252063802000778278409757642003009.149299500630172608', 5, 2);
  t('-5.112891963390565799576723527086504197404846e+37', '-51128919633905657995767235270865041974.0484596507', 6, 2);
  t('-859338923835148146.135', '-859338923835148146.13524799870184210', 3, 2);
  t('-1.5733785884726617471894e+22', '-15733785884726617471894.004', 1, 2);
  t('9.076880708431840006783794173382765592057302804e-7', '0.000000907688070843184000678379417338276559205730280366519137475', 52, 2);
  t('0.000184', '0.00018380491750345880348', 6, 2);
  t('-1.104394255519294295532100240877856139565868e+31', '-11043942555192942955321002408778.561395658677038345808864487', 11, 2);
  t('1.929655038148014258102318236820330361e+30', '1929655038148014258102318236820.33036098693678428147522651490925837608203', 7, 2);
  t('796749.2546404361275835', '796749.2546404361275834731877', 16, 2);
  t('2.974889592421425054232781420528e+30', '2974889592421425054232781420528.1', 0, 2);
  t('-1.23614324919504883710249e-7', '-0.00000012361432491950488371024922330362189476329', 30, 2);
  t('-3181', '-3181.07', 0, 2);
  t('3.8917208641819951832474565153515100204151778558835276e+44', '389172086418199518324745651535151002041517785.5883527577464942528975', 8, 2);
  t('-0.00000298000181812078999302622407', '-0.0000029800018181207899930262240706816', 32, 2);
  t('132946096.6702637270075111733', '132946096.670263727007511173336921377448', 19, 2);
  t('-428601831.9477995', '-428601831.947799514525012592182', 7, 2);
  t('-2.752554498061690200289273e+22', '-27525544980616902002892.7324266', 2, 2);
  t('-6.9846559437579283716265588667080665496910108842e+45', '-6984655943757928371626558866708066549691010884.200066689038', 2, 2);
  t('0.05767389365898215109805122377357', '0.05767389365898215109805122377357153258394222588783481524098710204114978550', 32, 2);
  t('-176340385801.100826', '-176340385801.10082602223', 6, 2);
  t('-212354390.1497373150863173307463542744189834481800609273373051611', '-212354390.149737315086317330746354274418983448180060927337305161077885', 55, 2);
  t('-2336366', '-2336366.26', 0, 2);
  t('6916400', '6916399.5', 0, 2);
  t('-0.00001071053973792406', '-0.0000107105397379240606378152899980275612107280855733678146', 20, 2);
  t('-2.8800409115600482283961113639377e+27', '-2880040911560048228396111363.9377100202168703885798', 4, 2);
  t('719367751925625.455637281128703154493011753', '719367751925625.455637281128703154493011752810595216', 27, 2);
  t('-11543125764.2541826265', '-11543125764.2541826265147', 10, 2);
  t('-1025094.53', '-1025094.53162', 2, 2);
  t('3.414285798583205404006180974874484876575212877892246e+35', '341428579858320540400618097487448487.657521287789224624641731579999272111102', 16, 2);
  t('0', '0.0000014572444376521826654212106', 2, 2);
  t('138707089045.3995889739', '138707089045.399588973894721182131202', 10, 2);
  t('-4411008.0233775', '-4411008.0233775422635870874538875351', 7, 2);
  t('-0.054423555291247088879390591875', '-0.05442355529124708887939059187495927214269377843771471', 30, 2);
  t('1.794247933287349165322647e+24', '1794247933287349165322647.212', 0, 2);
  t('825185764736934056.5', '825185764736934056.5024', 1, 2);
  t('-47.6231', '-47.62309010745975854', 4, 2);
  t('0', '-0.000000252591875309898322973316907158763461535345', 3, 2);
  t('-16472044.832801884361170273965818537471011358395588794679268276', '-16472044.8328018843611702739658185374710113583955887946792682757018915517', 54, 2);
  t('-658931119.584', '-658931119.584173964276694213675441716', 3, 2);
  t('1557121244565546587.92942', '1557121244565546587.929423896', 5, 2);
  t('0.064938249930897', '0.06493824993089714978290', 15, 2);
  t('1.713241863546246153396280899381097009866937100161073482610902e+53', '171324186354624615339628089938109700986693710016107348.261090242', 7, 2);
  t('-5.578460559', '-5.5784605591046843026707381808', 9, 2);
  t('3741194380218900599', '3741194380218900598.566', 0, 2);
  t('0.013427', '0.0134268306617315971189146092934753081313', 6, 2);
  t('-705412423.2481568637873293838', '-705412423.2481568637873293837749115', 19, 2);
  t('-551525.36560570912458684574715845895760539616', '-551525.3656057091245868457471584589576053961596968', 38, 2);
  t('0.43407983923', '0.43407983922858', 11, 2);
  t('-0.0053621296583095859461173544410402795871718180829748123269520233777509', '-0.00536212965830958594611735444104027958717181808297481232695202337775093', 70, 2);
  t('-612854611639761420.9751', '-612854611639761420.975055727', 4, 2);
  t('0.009', '0.009159714329113076954041356584476951662872164908033765', 3, 2);
  t('0.0144', '0.014392639227', 4, 2);
  t('8.9471971597833345188972851819e-7', '0.0000008947197159783334518897285181917', 35, 2);
  t('96309960.6242', '96309960.624196947', 5, 2);
  t('3.990190412077384860236358315842561559323035602004e+45', '3990190412077384860236358315842561559323035602.004402366200415', 3, 2);
  t('4.5878993268407879024910318222553e+23', '458789932684078790249103.182225525018445913048224005112808', 8, 2);
  t('-0.043393911518', '-0.043393911518220171546273150261643317263998699216946401', 12, 2);
  t('89280512232815557.8845', '89280512232815557.884504150030245582494', 4, 2);
  t('5', '5', 0, 2);
  t('-910.9172', '-910.917230574', 4, 2);
  t('0.42098715459', '0.4209871545896056726599642485885413869650885615708279293101172250', 11, 2);
  t('-5', '-4.59', 0, 2);
  t('8.63547766590626440636295875183622814068766317298135132715426e+56', '863547766590626440636295875183622814068766317298135132715.4258892', 3, 2);
  t('-25056083356.8', '-25056083356.7528521', 1, 2);
  t('-31990264650008.5551', '-31990264650008.5551366740959556498546697383614518810436455435', 4, 2);
  t('-240.8', '-240.79', 1, 2);
  t('-0.8', '-0.819788077550378064715432600235770304659408604805555834502173572271862691', 1, 2);
  t('-0.00036322200989697788840667', '-0.00036322200989697788840666638881421', 26, 2);
  t('0', '-0.000041956450745210', 1, 2);
  t('2.207724324015216551375839783778892039172992332e+38', '220772432401521655137583978377889203917.2992332143730922966019906422', 7, 2);
  t('0', '-0.000013451648752675131603759357976788', 2, 2);
  t('6.185617252064270849867524635742510008139794224628799360982761e+31', '61856172520642708498675246357425.1000813979422462879936098276106', 29, 2);
  t('-0.03', '-0.02575', 2, 2);
  t('0', '0', 0, 2);
  t('10452764153877176428.933378', '10452764153877176428.93337773', 6, 2);
  t('-36.615', '-36.61456605', 3, 2);
  t('-2.0387765901950670492652649802719075092e+31', '-20387765901950670492652649802719.0750920490551', 6, 2);
  t('-5061', '-5061.0395117493112251', 0, 2);
  t('-447', '-447.0838536123844', 0, 2);
  t('1.67668773581435025020555235868e+22', '16766877358143502502055.5235867892274419949224031229344093405', 7, 2);
  t('-49910610812859.81866633684', '-49910610812859.81866633684104514439664504', 11, 2);
  t('0.01097590608339462644113174', '0.0109759060833946264411317350132322858382693643512423982897150886', 26, 2);
  t('-0.000056', '-0.0000563672528266727098897834991643435408', 6, 2);
  t('-9.1780944221871967816919973193794198e+34', '-91780944221871967816919973193794197.84', 0, 2);
  t('-4e-8', '-0.00000003927619509409046993765635077890368622748488980141371288668759465104000', 8, 2);
  t('-2.7', '-2.740', 1, 2);
  t('8918433421.559065', '8918433421.559064961', 6, 2);
  t('1959273986162264.956458189069', '1959273986162264.95645818906875430791071589', 12, 2);
  t('-0.000006684490569314940458384646312040301083', '-0.00000668449056931494045838464631204030108304026', 43, 2);
  t('0', '-0.062369969637330', 0, 2);
  t('-0.04614396454006526692', '-0.046143964540065266920289730823802285518', 20, 2);
  t('226967505298570612781.54608921', '226967505298570612781.546089208780341376052998273', 8, 2);
  t('-10839390.58484', '-10839390.584842942700582', 5, 2);
  t('868439994.1320807088007763864778', '868439994.13208070880077638647780008703', 22, 2);
  t('-0.005813511531330806757481', '-0.005813511531330806757481313033065203370412581777', 24, 2);
  t('-4.424299509301660380785763010084230541184720473378038797e+53', '-442429950930166038078576301008423054118472047337803879.6635', 1, 2);
  t('-399213.66312571', '-399213.66312570830186137439274665188508356759499770453283185057603', 8, 2);
  t('-335', '-335.392756844', 0, 2);
  t('-0.0013343509714277900461842997584952282099183918599632', '-0.0013343509714277900461842997584952282099183918599632329803255851751278', 52, 2);
  t('6.04088462513315477231784826871e+27', '6040884625133154772317848268.7102043', 3, 2);
  t('2.46950448676711977794768641983309224710220715789654610815105e-8', '0.00000002469504486767119777947686419833092247102207157896546108151052297', 67, 2);
  t('-3114.75858614', '-3114.7585861446261919285', 8, 2);
  t('-9.0546473738122139172928674929730049459178130055258e-8', '-0.0000000905464737381221391729286749297300494591781300552575245680951971029596426', 57, 2);
  t('41.1807899', '41.18078990422433', 8, 2);
  t('495750160104586862.5666645', '495750160104586862.566664461528193390556540', 7, 2);
  t('-8.98', '-8.9778278167881324073731341', 2, 2);
  t('-2116175891812.794', '-2116175891812.7939768426', 4, 2);
  t('-3.6182815372059264267232627823e+26', '-361828153720592642672326278.22865114', 2, 2);
  t('6.91926698469067732284294462635680557466174970384484191405541e+55', '69192669846906773228429446263568055746617497038448419140.5540615206730888', 4, 2);
  t('-0.00419884443471870022', '-0.00419884443471870022468195300780146430411150006777919207216409', 20, 2);
  t('-8033878364502.3325365749451346472956677907427748195113826885', '-8033878364502.332536574945134647295667790742774819511382688466', 46, 2);
  t('-486962302648.183', '-486962302648.18265374', 3, 2);
  t('-7.1', '-7.1095', 1, 2);
  t('23.4881799476998144258548955', '23.48817994769981442585489549418579391917433345605175109076155', 25, 2);
  t('1362581810314889.01655209391675903989371427684923714702980317', '1362581810314889.016552093916759039893714276849237147029803172658223425843853', 44, 2);
  t('38.987', '38.98727817', 3, 2);
  t('3.01', '3.0125076', 2, 2);
  t('268.71847962', '268.718479615127', 8, 2);
  t('6.178281743904239218316327429803948047116222954307162971074534658e+62', '617828174390423921831632742980394804711622295430716297107453465.769589', 1, 2);
  t('87985329567746884168.848792423904143996400652033558107', '87985329567746884168.84879242390414399640065203355810695023', 34, 2);
  t('-2e-8', '-0.000000016614924', 8, 2);
  t('971018573.9351024627', '971018573.93510246274902', 10, 2);
  t('9.660185132001915848521737730064490522780766417225527e+42', '9660185132001915848521737730064490522780766.417225526901104328', 9, 2);
  t('159.6965435', '159.696543504319408719621608456250975441450767678', 7, 2);
  t('-3.367784650526976455147506e+24', '-3367784650526976455147506.423', 0, 2);
  t('5.3019770372835752127587110983470447669673154466331963e+51', '5301977037283575212758711098347044766967315446633196.250996', 1, 2);
  t('-2.1473013069070408429029131991202812063e+34', '-21473013069070408429029131991202812.063087754465091', 3, 2);
  t('766857563160.6960134906032267', '766857563160.6960134906032267315', 16, 2);
  t('-191634575485.83277038307369', '-191634575485.83277038307368580580848576144062350195119125466', 14, 2);
  t('5', '5.1', 0, 2);
  t('2.28746467824105519533886976175e+29', '228746467824105519533886976174.6334005511361836027142563134799536', 0, 2);
  t('-9.914795006896482243227593e+21', '-9914795006896482243227.5926229960932853076586763153861896', 3, 2);
  t('-9.341346856947225300022135731173159534994013137758e+42', '-9341346856947225300022135731173159534994013.1377576581', 6, 2);
  t('-5.0242532844816065799730725158970637072793189719e+38', '-502425328448160657997307251589706370727.931897193433', 8, 2);
  t('17731860897715.269', '17731860897715.2688041298936', 3, 2);
  t('4.094701538164225721691405859500986303573e+33', '4094701538164225721691405859500986.303573407766838', 6, 2);
  t('-9.51675966294231957674538643975454195842613065223609016515519750514e+64', '-95167596629423195767453864397545419584261306522360901651551975051.38324', 1, 2);
  t('-5436021.42796103003028402311974489', '-5436021.4279610300302840231197448886479095730', 26, 2);
  t('3.135176935382312221625565750722954686146209765653375247224e+52', '31351769353823122216255657507229546861462097656533752.47224074436034', 5, 2);
  t('337060357.3', '337060357.26', 1, 2);
  t('2.6271954688244100255756219950216841700588972460588924608080129e+54', '2627195468824410025575621995021684170058897246058892460.808012912489', 7, 2);
  t('281178997', '281178996.5976', 0, 2);
  t('-3.7416365442826426560967132552738483081106546977255172e-8', '-0.0000000374163654428264265609671325527384830811065469772551715662577343', 60, 2);
  t('1.3727188410646580349004880859865280446230595500367686727484267353444e+67', '13727188410646580349004880859865280446230595500367686727484267353444.3', 0, 2);
  t('-0.00088985146564621', '-0.00088985146564620608048415', 17, 2);
  t('3721.5', '3721.537', 1, 2);
  t('-0.00219863409103471179790656', '-0.00219863409103471179790655802533', 26, 2);
  t('-26781724', '-26781723.5', 0, 2);
  t('218.2531799358844460971554', '218.25317993588444609715539650070250824969952622974912', 22, 2);
  t('-44', '-43.7', 0, 2);
  t('-309335509.9', '-309335509.88533', 1, 2);
  t('-5.327045089642836185612088037337020004330131280899e+23', '-532704508964283618561208.8037337020004330131280898730790462324050', 25, 2);
  t('984.9856405', '984.9856405049808665054091826958542262554545001404', 8, 2);
  t('7.00993519484211940209201083804040269332248869745494333748e+47', '700993519484211940209201083804040269332248869745.494333747965608082', 10, 2);
  t('-7885969523014.605058', '-7885969523014.6050580389202970357856', 7, 2);
  t('1.52318061844515e-7', '0.000000152318061844515074836771249714094', 21, 2);
  t('-64939898415025.305611891697261588794905431448369478634207431', '-64939898415025.305611891697261588794905431448369478634207430633', 45, 2);
  t('-258421493773522547.88731715718248', '-258421493773522547.88731715718248046312342736119836225597', 15, 2);
  t('1077263095864838.5614104685761771', '1077263095864838.56141046857617709811', 17, 2);
  t('6183976', '6183976.5', 0, 2);
  t('8.325499741075553695463029798274706310310484455788556341180382100734', '8.32549974107555369546302979827470631031048445578855634118038210073413199', 66, 2);
  t('-1.384748229432702348634792951322719911228208889724246e-7', '-0.000000138474822943270234863479295132271991122820888972424581974241818611315594142', 58, 2);
  t('1.31374879232602936208030647793555445352291058868647245381778975959e+62', '131374879232602936208030647793555445352291058868647245381778975.95919', 3, 2);
  t('-2.447904439806615489965743011142512728568044130197e+46', '-24479044398066154899657430111425127285680441301.96935775323', 2, 2);
  t('-10', '-10.19', 0, 2);
  t('-3.082910490003966903', '-3.082910490003966903366344671328144204691192545155168776704048986557931103', 18, 2);
  t('-5178094814996041.36737972391515', '-5178094814996041.367379723915151269', 14, 2);
  t('-3.3249136426221858313725101568537327894468465e+33', '-3324913642622185831372510156853732.789446846492981', 10, 2);
  t('-2.06821234777328170719614325051408101131404395e+33', '-2068212347773281707196143250514081.0113140439451', 11, 2);
  t('0.0017723350926201', '0.00177233509262007', 16, 2);
  t('-0.00002477389977504019349811671283452040427545214076', '-0.00002477389977504019349811671283452040427545214075681713174506192054024371900', 50, 2);
  t('0.003263574700561451789363525963469', '0.003263574700561451789363525963469355176633442', 33, 2);
  t('449.4', '449.407', 1, 2);
  t('-7.85515833325985798644165643742234801824669361504800641625569324e+41', '-785515833325985798644165643742234801824669.361504800641625569324437516', 21, 2);
  t('391565662160326402.105640349349073220598869874', '391565662160326402.10564034934907322059886987371427724541769273727750290', 27, 2);
  t('1.95650530805972620051683214423789446286353982669544434142938062565718608e+71', '195650530805972620051683214423789446286353982669544434142938062565718607.678', 0, 2);
  t('0', '0.0000011565616220409568184786922969644521092946467241340932011354570', 3, 2);
  t('0.0025810469', '0.00258104694183287681167959', 10, 2);
  t('-0.000073551445570206365577194645100488446054822', '-0.000073551445570206365577194645100488446054821992276396043570369485039867162743', 45, 2);
  t('-8515.522791', '-8515.522790910197870982166791876498800311529648071780334553410', 6, 2);
  t('-5.4027873737416336758797677286370965e+24', '-5402787373741633675879767.72863709654170463385890907658609160690480', 10, 2);
  t('-0.18712986164937532238', '-0.18712986164937532238378410594768', 20, 2);
  t('0.00406764031854846408', '0.00406764031854846407555743301', 20, 2);
  t('54767628435359.6', '54767628435359.647', 1, 2);
  t('-1', '-1', 0, 2);
  t('-0.0000124160521778520149603186832111269038867316917357', '-0.00001241605217785201496031868321112690388673169173569688907', 53, 2);
  t('0.02488', '0.024876241568684480534625282774663232642673985204690815638313174315453087287', 5, 2);
  t('9.2307913348311064049720266690541055e-7', '0.00000092307913348311064049720266690541055153257415986777281062537137664978', 41, 2);
  t('-2.326029248740152330270018627545386287825103e+35', '-232602924874015233027001862754538628.78251029676039562', 8, 2);
  t('-0.155', '-0.154818', 3, 2);
  t('3.32888971852648661581695241275281873259406877781882369077440705711e+33', '3328889718526486615816952412752818.73259406877781882369077440705711338275', 32, 2);
  t('-1', '-1.18', 0, 2);
  t('39852.10180469', '39852.10180468652181', 8, 2);
  t('-6154.6163498', '-6154.6163497932918', 7, 2);
  t('896262802773.41075', '896262802773.4107480', 5, 2);
  t('-0.03947887960417678654587826821778073915945', '-0.03947887960417678654587826821778073915944585607966087002', 41, 2);
  t('-22186.67201', '-22186.6720143178', 5, 2);
  t('230407301532455.2', '230407301532455.213219479193124862822701', 1, 2);
  t('11549.1105376666724512647835421034452506231739415401592', '11549.11053766667245126478354210344525062317394154015919218401503417306548', 49, 2);
  t('2.67563613072690366289383376116991e+30', '2675636130726903662893833761169.9078362', 2, 2);
  t('-3.60431581832431502984600113357549e+30', '-3604315818324315029846001133575.48956', 3, 2);
  t('-2.0355916610129389785837839086851500365849600725e+46', '-20355916610129389785837839086851500365849600725.0', 0, 2);
  t('-310464685005830937017.533844926486699973', '-310464685005830937017.533844926486699973269', 18, 2);
  t('-2.80428626744961165115808932541067589351e+38', '-280428626744961165115808932541067589351.26749755', 0, 2);
  t('-1.51964478908675307650893356754e+23', '-151964478908675307650893.35675389075', 6, 2);
  t('-7.558301852267810891312402861259282675481483297901350599522e+43', '-75583018522678108913124028612592826754814832.979013505995222936290520419', 14, 2);
  t('-264932120.0111', '-264932120.01114476143', 4, 2);
  t('-1.6536905839710017648662e-7', '-0.000000165369058397100176486622445905719729626842826489257468935375441655120325', 29, 2);
  t('-8.2147737713227483991576483809928276302e+22', '-82147737713227483991576.4838099282763016224026377078741614930894975683925', 15, 2);
  t('4.6813100042819418792661472235803123843114844e+24', '4681310004281941879266147.2235803123843114843979661704100330', 19, 2);
  t('-79917988367898984162.771972375793469188811', '-79917988367898984162.7719723757934691888109506', 21, 2);
  t('1.718922894626514564618828855297608701259698e+28', '17189228946265145646188288552.9760870125969820982026694370944058', 14, 2);
  t('-2.54235352910879596627611114683e+29', '-254235352910879596627611114682.5197025126180', 0, 2);
  t('-0.0006377434246903456401074021835126', '-0.00063774342469034564010740218351255413834921475983267503880750339362350', 34, 2);
  t('-0.0000159667176487587863973651015688869543529', '-0.0000159667176487587863973651015688869543528973149424', 43, 2);
  t('34787532108017.36264556992459990655727819886040471164', '34787532108017.36264556992459990655727819886040471164049221419', 39, 2);
  t('340', '340.22286339861', 0, 2);
  t('0.00106256852', '0.0010625685238858429232158574995746825415338378', 11, 2);
  t('0', '0.00001987165161745', 4, 2);
  t('-1.7227346755016108799363427735780255491574875239296007442923933114215188e+68', '-172273467550161087993634277357802554915748752392960074429239331142151.8750529', 2, 2);
  t('-0.002', '-0.0023436690820812', 3, 2);
  t('-205142531636.983', '-205142531636.98322', 3, 2);
  t('368893219538140.012911230797202785', '368893219538140.0129112307972027849498676929772156806286921', 18, 2);
  t('11992026', '11992025.93', 0, 2);
  t('-1.46079553133366e-7', '-0.000000146079553133365771702861', 21, 2);
  t('173723908.406197485909291320429923309772543', '173723908.406197485909291320429923309772542669793531563804094', 33, 2);
  t('-1.154922660890749233253720349837427188882687948198568837064531e+52', '-11549226608907492332537203498374271888826879481985688.370645312714', 8, 2);
  t('-2.56512841950156426111553743304e+28', '-25651284195015642611155374330.448', 1, 2);
  t('-6.98327849514e-8', '-0.000000069832784951383612151542162363', 19, 2);
  t('-0.0017110009470017826865419211', '-0.00171100094700178268654192107985245918748100174134127010194184744376678', 28, 2);
  t('-1.2276253886099118409020649116468796300103657e+27', '-1227625388609911840902064911.64687963001036571137', 16, 2);
  t('-2.8944397480675756068756995613977603412469774503740809037e+30', '-2894439748067575606875699561397.760341246977450374080903697789', 26, 2);
  t('5.3688', '5.36877904', 4, 2);
  t('-232713338.53642883', '-232713338.536428834379920', 8, 2);
  t('4344159280431.568', '4344159280431.5684058', 3, 2);
  t('-0.12888687617900862581', '-0.12888687617900862580859080307904674813760620654970750343447', 20, 2);
  t('-9.931812300730398433817144250738676639072235625e-7', '-0.000000993181230073039843381714425073867663907223562501787458182093', 53, 2);
  t('1.0886424643522812876217902901080206639337e+40', '10886424643522812876217902901080206639336.682', 0, 2);
  t('-3205239391665364.3', '-3205239391665364.302372474', 2, 2);
  t('126627439.4530768407472514788', '126627439.4530768407472514787848654587067105226484705', 19, 2);
  t('-2.0871953015e-7', '-0.0000002087195301456554284734778681', 17, 2);
  t('1', '1.16', 0, 2);
  t('-18410333.90802111701277688', '-18410333.908021117012776877288249505896078', 17, 2);
  t('-556476.280850791846342285259052294054093579170565778152', '-556476.28085079184634228525905229405409357917056577815200073366', 48, 2);
  t('0.000010511333887440339636918374174796481869', '0.00001051133388744033963691837417479648186937531639', 42, 2);
  t('0.0001908354257520862348118', '0.00019083542575208623481180843896814014379719629080674990143119907012123719', 25, 2);
  t('4.1979130133719944121064126679625602164915e+31', '41979130133719944121064126679625.60216491534764987018912430232370', 9, 2);
  t('-1.12159082208216081393178290871e+23', '-112159082208216081393178.2908707994378762172725533364173', 6, 2);
  t('0.00000948186537', '0.000009481865369812518108306621137606', 14, 2);
  t('4', '4', 0, 2);
  t('-9005824104.1516', '-9005824104.1515616681384', 4, 2);
  t('-2.07079721270046768129501830480994188e+29', '-207079721270046768129501830480.994188465128030780', 6, 2);
  t('-1.0167735305123016026045336422251915908250994613293275e+51', '-1016773530512301602604533642225191590825099461329327.53758399251655036152', 1, 2);
  t('2.9879792262079374383688905215957531196451515878102381439097400153322e+62', '298797922620793743836889052159575311964515158781023814390974001.5332199239', 6, 2);
  t('-1.1906541440263150209638305613023602610769846122100132e+52', '-11906541440263150209638305613023602610769846122100132.20613889425978288450610', 0, 2);
  t('1656450356727943.55248790648750208670947483059', '1656450356727943.552487906487502086709474830589587416422742356778600', 29, 2);
  t('0.00584116201333836543', '0.0058411620133383654275523923742199', 20, 2);
  t('139521336093419480143.075764112192252501', '139521336093419480143.075764112192252500528467', 18, 2);
  t('15921941205.616836836014597152106', '15921941205.61683683601459715210643572915109864749981471190908', 21, 2);
  t('-5.7138739956242573873769350866208867234541995982847725785e+37', '-57138739956242573873769350866208867234.541995982847725785340684498', 18, 2);
  t('0.61997049', '0.619970489821060978341978409995963688187655653', 9, 2);
  t('-7.4090933116680340957603797e+22', '-74090933116680340957603.79708076686080734', 3, 2);
  t('-9.21449339309994522855053912036e+26', '-921449339309994522855053912.03593786392160920282481187087', 3, 2);
  t('0', '0.000134485282687896367414503278909579', 1, 2);
  t('0.007513626757660323436698935', '0.0075136267576603234366989350733', 27, 2);
  t('2.418504309070136090748861817695450823889247431456322519642e+48', '2418504309070136090748861817695450823889247431456.32251964194887712776', 9, 2);
  t('-1.0740831304248609109039483011910337397782076776913e+45', '-1074083130424860910903948301191033739778207677.6913256458', 4, 2);
  t('-245889710.4640159', '-245889710.464015908', 7, 2);
  t('0.0000270807652779158', '0.00002708076527791575965334330855704284', 19, 2);
  t('-0.177', '-0.17744798878451516443435580962926', 3, 2);
  t('-47842851492.434198', '-47842851492.43419824528052515', 6, 2);
  t('1.9', '1.910', 1, 2);
  t('-4.782877822612973201093718405341579997668805955e+26', '-478287782261297320109371840.53415799976688059546036707291', 19, 2);
  t('-1.80524578371278763492143072783999388149754649154264303990817e+38', '-180524578371278763492143072783999388149.75464915426430399081696240812518', 22, 2);
  t('1236845809088610.2794764699600434432148', '1236845809088610.2794764699600434432148040', 23, 2);
  t('0.0040202140017428665', '0.004020214001742866465799734358693789591244730619907620860', 19, 2);
  t('-16793', '-16792.8715', 0, 2);
  t('1.52965861113556488627385916764762986725508733133592883159e+39', '1529658611135564886273859167647629867255.0873313359288315908850491', 17, 2);
  t('-5.087349825712688842122102763208569189651561678966e+41', '-508734982571268884212210276320856918965156.167896598919', 7, 2);
  t('-3231.9', '-3231.90000265106649', 5, 2);
  t('-1.1465315194239824701971177006907718578363311185909185e+27', '-1146531519423982470197117700.6907718578363311185909184562520178', 25, 2);
  t('4757617552.3896096923197129476314', '4757617552.389609692319712947631449', 22, 2);
  t('-203793', '-203793.0', 0, 2);
  t('-168500.18931162760872697', '-168500.189311627608726973364', 17, 2);
  t('30457207666.3', '30457207666.3324553251054242304', 1, 2);
  t('1.498244418624314530236867086028109437e+21', '1498244418624314530236.86708602810943661254704875', 15, 2);
  t('7.84330718900954994680701749496822406146865570537444394134e+37', '78433071890095499468070174949682240614.686557053744439413417591', 19, 2);
  t('-1.04', '-1.04427224', 2, 2);
  t('7037113708', '7037113707.984', 1, 2);
  t('-4929432965244.0894241', '-4929432965244.089424107111981528843359732736', 7, 2);
  t('-129436110', '-129436109.90', 0, 2);
  t('-0.070341048979829406', '-0.07034104897982940646456', 18, 2);
  t('1.49943272396148939927855668411581621e+22', '14994327239614893992785.566841158162132', 13, 2);
  t('1190.54140478633144808902212491401945', '1190.5414047863314480890221249140194479772152263', 32, 2);
  t('-0.1341255157877690453717122', '-0.13412551578776904537171217936255082699597112889615258559768723503470687', 25, 2);
  t('-1', '-1', 0, 2);
  t('136135415696414', '136135415696414.08550518', 0, 2);
  t('2.3984356196072489067857e+21', '2398435619607248906785.723531', 1, 2);
  t('0.000004', '0.00000400764400', 6, 2);
  t('1', '1', 0, 2);
  t('1177485.6564193890627', '1177485.6564193890626947', 13, 2);
  t('-7.202452949102316512011204453e+26', '-720245294910231651201120445.30801777', 1, 2);
  t('4.3101422046279260292215537982057622949241438129e+40', '43101422046279260292215537982057622949241.4381289316624978163830', 6, 2);
  t('5257095714249.9', '5257095714249.912729551', 1, 2);
  t('2.54500796000227883387387786619199652728e+30', '2545007960002278833873877866191.9965272796572', 9, 2);
  t('-3363827901988953', '-3363827901988953.473705748', 0, 2);
  t('1', '1.08', 0, 2);
  t('2419647124.91', '2419647124.911418', 2, 2);
  t('2.299366039129045865549710422996535398236312843083405235580516e+59', '229936603912904586554971042299653539823631284308340523558051.569', 1, 2);
  t('5722684.681', '5722684.6813677939376718642741084181169171', 3, 2);
  t('-0.00000856192341374507633260886802913696841959', '-0.0000085619234137450763326088680291369684195858559330551448988', 44, 2);
  t('-7.58548454783003165111014981367268951364498366053535072962e+28', '-75854845478300316511101498136.7268951364498366053535072961603962511762', 28, 2);
  t('0.00000324516611009', '0.0000032451661100852371849803608939739393154221037228659938551948', 17, 2);
  t('-2.826114473479211256275145479739345861003210827006986013438931e+60', '-2826114473479211256275145479739345861003210827006986013438930.781219883', 0, 2);
  t('-59.90942754', '-59.9094275437203662198882369814830942846', 8, 2);
  t('0.000860247294663', '0.0008602472946629780', 16, 2);
  t('726039.4553', '726039.455316', 4, 2);
  t('-344792.748100918', '-344792.748100918315152301009123551280977110515759', 9, 2);
  t('3828739.47476', '3828739.4747604176', 6, 2);
  t('2.89695964235050121935374256321529e+21', '2896959642350501219353.74256321529453390321370577490185448', 11, 2);
  t('380769947.3', '380769947.25892873505079229', 1, 2);
  t('38169678989947.23576', '38169678989947.235760859572768092936285736019808973853693855', 5, 2);
  t('-4.06187689432457626038228989710314707751042296389669167993e+56', '-406187689432457626038228989710314707751042296389669167992.8', 0, 2);
  t('-481924652.64390259670068272423214883707740411790013808', '-481924652.64390259670068272423214883707740411790013808242355438761152', 44, 2);
  t('111282.2054547745975655973', '111282.20545477459756559734369034164890791116623322446023', 19, 2);
  t('3470691625013660234', '3470691625013660234.4763', 0, 2);
  t('2.08312991726', '2.0831299172556', 11, 2);
  t('2.387443148424699940911355179816280411561516099447117664752029e+34', '23874431484246999409113551798162804.1156151609944711766475202929356839478', 26, 2);
  t('96588542901383845829.33260156501449145', '96588542901383845829.3326015650144914520126953878145351036206674277139', 17, 2);
  t('0.0859316324', '0.085931632434', 10, 2);
  t('-1038117264917677263', '-1038117264917677263.48', 0, 2);
  t('994060', '994059.619', 0, 2);
  t('-287716469964987525.411706898', '-287716469964987525.411706897688', 9, 2);
  t('4.77162062787431764844918594715546716737e+28', '47716206278743176484491859471.55467167370591027180526183', 10, 2);
  t('71642268576253.525814396056080396', '71642268576253.52581439605608039599274530156', 18, 2);
  t('313777282785849.6186322071434949853', '313777282785849.6186322071434949852781760618262466634950090663078288', 19, 2);
  t('363188009.47117', '363188009.4711653397', 5, 2);
  t('83060368781968.6414142644071', '83060368781968.6414142644070950280298355193622759', 14, 2);
  t('-7702303120.136852544439825139', '-7702303120.136852544439825138516515', 18, 2);
  t('3.8', '3.83622775367500005', 1, 2);
  t('-44721684418754.23712737855230310641641161565324', '-44721684418754.23712737855230310641641161565323849304032906808562', 32, 2);
  t('-0.0008155750709', '-0.0008155750708748847', 13, 2);
  t('-2.75382721785528285272368760786023568952e+38', '-275382721785528285272368760786023568951.994', 0, 2);
  t('-2.8000095096880195386595483219771267204452292555904067391e+52', '-28000095096880195386595483219771267204452292555904067.391207261584563895229', 3, 2);
  t('-1.001169760253693440733497296459537371669409110805225882e+46', '-10011697602536934407334972964595373716694091108.052258817811612769982716034', 8, 2);
  t('-4.70440835255452422851805702520870770994551407444852e+50', '-470440835255452422851805702520870770994551407444851.8839101198964', 0, 2);
  t('-1.592099961267576755050412627250487620849975e+38', '-159209996126757675505041262725048762084.997510', 4, 2);
  t('1.13169626219389933580658128519e+23', '113169626219389933580658.128518765290814133', 6, 2);
  t('-0.000001996042366071', '-0.0000019960423660707252777921361106303844720487494502033231614376857313', 18, 2);
  t('44677664133649.17601590794953562', '44677664133649.176015907949535616051996589764661448006', 17, 2);
  t('-2625167', '-2625167.2', 0, 2);
  t('-1369097935757876947.08345', '-1369097935757876947.0834494750736291716753967951584866287030', 5, 2);
  t('0', '0.0012981872695081482534598236422959807070892976659044189447', 0, 2);
  t('-0.06913235261519', '-0.069132352615194995001048', 14, 2);
  t('-3289', '-3289.1848592233982829143952832795959169142723179682122564366573587977', 0, 2);
  t('-0.0119100131781', '-0.01191001317811045907293968261648', 13, 2);
  t('5.469152717346860798', '5.46915271734686079750212198972765471937753478532657244061627920913334442542', 18, 2);
  t('-13418168.272289490519815', '-13418168.2722894905198151456227812736418688544', 15, 2);
  t('1.342304082e-7', '0.000000134230408157266765744388589397565836768732', 16, 2);
  t('731634.86384', '731634.863839838166272', 5, 2);
  t('1.46144970652530879389938587588726189836843273562867854109114402e+58', '14614497065253087938993858758872618983684327356286785410911.4401916', 4, 2);
  t('-1.7745469685271046133089050632221225694077927171097050200303e+42', '-1774546968527104613308905063222122569407792.7171097050200303230806', 16, 2);
  t('-7.638452469588587535062610011186070367337190042103e+43', '-76384524695885875350626100111860703673371900.421029956551', 6, 2);
  t('404', '403.8', 0, 2);
  t('-5.98995555082640166786390126510577860651374161094418588e+51', '-5989955550826401667863901265105778606513741610944185.8796234966725', 2, 2);
  t('1.1251043524016684780476098638927e+31', '11251043524016684780476098638926.6242', 0, 2);
  t('-507666190128601894', '-507666190128601893.822', 0, 2);
  t('0.0001205616018589240519093984291668745', '0.0001205616018589240519093984291668745037338709531616484000337021819479121', 37, 2);
  t('1.79406094989631079647556900199317784625722467666464760323807e+52', '17940609498963107964755690019931778462572246766646476.0323807012480', 8, 2);
  t('4.873e-8', '0.000000048729927235298367812147092890578', 11, 2);
  t('17.295832317', '17.295832316629305757', 9, 2);
  t('-33.579', '-33.57898', 3, 2);
  t('1.28', '1.28393', 2, 2);
  t('6220', '6220.39920443806605504575', 0, 2);
  t('-6317', '-6316.6', 0, 2);
  t('-0.00005848892114937004028325601357030246824024235494762', '-0.00005848892114937004028325601357030246824024235494762337957', 53, 2);
  t('12259019880011.692389', '12259019880011.69238875374573107737', 6, 2);
  t('5117620.88234', '5117620.88233942444', 5, 2);
  t('-5402817113.48355823224028534844314403355889336077490394277592226', '-5402817113.48355823224028534844314403355889336077490394277592226301173', 53, 2);
  t('-7', '-7', 0, 2);
  t('-174.1', '-174.05877495228', 1, 2);
  t('0.0000055438668515535873303968821901982', '0.0000055438668515535873303968821901982019139057562024454394240649190199027054', 37, 2);
  t('0.03396514', '0.0339651389413732234059150651011640032028', 8, 2);
  t('96627697594272840870.37877815466', '96627697594272840870.37877815465601593169625', 11, 2);
  t('-98.47', '-98.472056197178250742', 2, 2);
  t('-0.00584475813467750872', '-0.005844758134677508716736867', 20, 2);
  t('461383471710858.43694651', '461383471710858.436946511072311907', 8, 2);
  t('-1', '-1.4716907181349510132643929384315764239211731726973517515804983721754447810', 0, 2);
  t('-9.805355702', '-9.805355702162446301', 9, 2);
  t('2.7833783953196266754113271e+24', '2783378395319626675411327.0993787634844', 2, 2);
  t('0.00000294628669788757426', '0.000002946286697887574263521448020176957705009159643384865438526', 23, 2);
  t('-0.0063693144816', '-0.00636931448160159981555215581788634', 13, 2);
  t('-304.4008445147353575743', '-304.400844514735357574331545', 19, 2);
  t('0.000005295423638576797037626921333737826535401226', '0.0000052954236385767970376269213337378265354012264706634077258', 48, 2);
  t('2381', '2381.1', 0, 2);
  t('0', '-0.0000001503080979319766117393755519926784943226068180488290827487323134813', 5, 2);
  t('-4413778', '-4413778.42', 0, 2);
  t('0.0018', '0.001814326', 4, 2);
  t('43275043988264577.5782955700917236306540097299', '43275043988264577.578295570091723630654009729926255882124833989160960', 28, 2);
  t('4.073317856779391360450809425491524780764927416736008196948e+38', '407331785677939136045080942549152478076.492741673600819694798494', 20, 2);
  t('-1.795997717217889909554206838442196975978e+39', '-1795997717217889909554206838442196975977.7090303', 0, 2);
  t('0', '0', 0, 2);
  t('1253303751', '1253303751.11', 0, 2);
  t('-1.8353538134549708634874726628420313543155591003e+41', '-183535381345497086348747266284203135431555.910027682', 5, 2);
  t('1.58271792373595200950913155012871e+29', '158271792373595200950913155012.8712656263', 3, 2);
  t('-165357179.3237118032017', '-165357179.32371180320174', 13, 2);
  t('-1.07999644036047590963042262814354655551271e+41', '-107999644036047590963042262814354655551271.4414028749232958991', 0, 2);
  t('5259080', '5259080.03', 0, 2);
  t('3.867', '3.86687', 3, 2);
  t('-143436219', '-143436218.96', 0, 2);
  t('-3362250861082347264.397', '-3362250861082347264.3967745362450289041114949361', 3, 2);
  t('0.000003443327805653865', '0.0000034433278056538651433367179354571545', 21, 2);
  t('7', '7', 0, 2);
  t('2', '1.9', 0, 2);
  t('33', '32.8', 0, 2);
  t('18711.053066683178133379575206278', '18711.053066683178133379575206277557088', 27, 2);
  t('0.06507750783', '0.06507750782860441213826443046871427392840944', 11, 2);
  t('-9.1659242474457515e-7', '-0.0000009165924247445751548548', 23, 2);
  t('-3.93473122795752405190113747389790954279680349089920785e+45', '-3934731227957524051901137473897909542796803490.8992078504135489994387', 9, 2);
  t('0', '0.00000248274', 3, 2);
  t('-1.839213914613e-7', '-0.0000001839213914613028222646989', 20, 2);
  t('1.52794815702332565521951549506313217119977e+33', '1527948157023325655219515495063132.171199766472', 8, 2);
  t('1.018947329417956797657999460824474028982833986785e+32', '101894732941795679765799946082447.4028982833986785140672', 16, 2);
  t('35858452208.19', '35858452208.19000066517865585', 3, 2);
  t('-4.9760854838267859701683640123496467e+33', '-4976085483826785970168364012349646.7110', 1, 2);
  t('0.1392706914163679322924904087695251375868', '0.1392706914163679322924904087695251375868426732425599523', 40, 2);
  t('0.13446494941321870029804759', '0.1344649494132187002980475900304326552736540695179689653394697684703', 27, 2);
  t('457.77', '457.76950475', 3, 2);
  t('674.47', '674.4659', 2, 2);
  t('-1.0937779892070530440639729e+25', '-10937779892070530440639729.1', 0, 2);
  t('-0.000132355755', '-0.0001323557553949230602', 12, 2);
  t('-0.04482779362729189394578176624022542808410955129244', '-0.044827793627291893945781766240225428084109551292436500115827935157927', 50, 2);
  t('-57188906.2368820185002349936363257413916364318456271361984977283', '-57188906.236882018500234993636325741391636431845627136198497728333', 55, 2);
  t('-13606797141428053.1721544576048', '-13606797141428053.1721544576047601', 13, 2);
  t('-2', '-1.5', 0, 2);
  t('3.9786160949676465677728032348367425595031527660811966604e+54', '3978616094967646567772803234836742559503152766081196660.427', 1, 2);
  t('-469.3911288', '-469.3911287597434989', 7, 2);
  t('-4', '-4.1', 0, 2);
  t('-1277.9', '-1277.903', 1, 2);
  t('304410650367.36', '304410650367.35664', 2, 2);
  t('96399.1012', '96399.1011912', 4, 2);
  t('26094.55', '26094.5511', 2, 2);
  t('6477056174', '6477056173.6411', 0, 2);
  t('-0.486', '-0.486308269217851', 3, 2);
  t('-2.78289893084433975153577083884e+22', '-27828989308443397515357.70838836838735242665739067560302801304002', 7, 2);
  t('-0.0003823628361791375369489730392166197957616066152954', '-0.000382362836179137536948973039216619795761606615295361372771068223314838565425', 52, 2);
  t('3.891433971547872547392046197523607284e+34', '38914339715478725473920461975236072.8395753635577232542318617535489', 3, 2);
  t('-1.538170383683e-7', '-0.000000153817038368329506748657969019346481236319269253843', 19, 2);
  t('-1.3778153377081407178699920577521464615665209277274e+22', '-13778153377081407178699.92057752146461566520927727394934570834', 27, 2);
  t('-3.7068598520902305941197645936643101515587705089472283657927775e+62', '-370685985209023059411976459366431015155877050894722836579277749.633', 0, 2);
  t('0', '0', 0, 2);
  t('292676496919465.33932', '292676496919465.339320791911', 5, 2);
  t('-2', '-2', 0, 2);
  t('55944989627', '55944989627.2', 0, 2);
  t('0.0001745908758205551186206851627111357216043377299', '0.0001745908758205551186206851627111357216043377298747095684250151', 49, 2);
  t('0.00002', '0.000015652', 5, 2);
  t('-6308330.4601747264191318343440394995877829678398891', '-6308330.4601747264191318343440394995877829678398890799813', 43, 2);
  t('-12', '-11.676050', 0, 2);
  t('-3', '-3.235', 0, 2);
  t('-215644685.5', '-215644685.495', 1, 2);
  t('3461262121564.04', '3461262121564.040233', 2, 2);
  t('-0.00014745131941260946021835553943481393698173399807042837569798294', '-0.00014745131941260946021835553943481393698173399807042837569798294009208657', 65, 2);
  t('-2.08', '-2.07985990', 3, 2);
  t('63744.2073675375', '63744.207367537545', 10, 2);
  t('-0.029796769', '-0.029796769466934', 9, 2);
  t('-5.8702888709741165230920812798431951e+24', '-5870288870974116523092081.27984319513877039316912356140774746', 10, 2);
  t('247022598701.139124275079996064587405002948665338', '247022598701.13912427507999606458740500294866533765359232307077727427265576', 36, 2);
  t('0', '-0.00001535574855767881813030028275600548470185898581409854429471545267483', 1, 2);
  t('-3.739936850451623270067041648852460725129360951353e+34', '-37399368504516232700670416488524607.2512936095135303', 14, 2);
  t('3.28204290000808630525635795159271802716431529e+39', '3282042900008086305256357951592718027164.31528961882273327583170', 5, 2);
  t('-466.9529320172758025649894593692191876472', '-466.9529320172758025649894593692191876472497595267', 37, 2);
  t('0.01892410898213188428082254311554777266916395226', '0.018924108982131884280822543115547772669163952257024583', 47, 2);
  t('0.0049076526493185979809', '0.00490765264931859798089956560752203543779323690451288', 22, 2);
  t('-0.127', '-0.127328643383904', 3, 2);
  t('0', '0.0000533', 2, 2);
  t('90622099140893.8027', '90622099140893.80273068', 4, 2);
  t('1064.4615379190056', '1064.461537919005585646809998571315', 13, 2);
  t('0', '0.00007759619948403817701724', 1, 2);
  t('-1', '-1.0', 0, 2);
  t('-1.9694835349821333431993987103324436327515e+40', '-19694835349821333431993987103324436327515.29047', 0, 2);
  t('11.543236849694283119077563690234148', '11.5432368496942831190775636902341482878', 33, 2);
  t('350.273', '350.2727878', 3, 2);
  t('-1.0938060190301544076858679503e+27', '-1093806019030154407685867950.270', 1, 2);
  t('-56', '-55.9', 0, 2);
  t('0.0000091251974931034584620941259317252498', '0.000009125197493103458462094125931725249773437533979', 40, 2);
  t('-1.2765000870625293313844175195581828230390103480747338219e+56', '-127650008706252933138441751955818282303901034807473382189.53', 0, 2);
  t('46010765094830.4254989721024557', '46010765094830.4254989721024556606933308', 16, 2);
  t('-1.1640698340609127253625e+22', '-11640698340609127253625.18735', 0, 2);
  t('-1.4564903187476621039807e+22', '-14564903187476621039806.6', 0, 2);
  t('0', '-0.000000083722991559151862209039851326449700021597494648458400616', 4, 2);
  t('-6.41e-8', '-0.00000006411083811709488721082917930416624806', 10, 2);
  t('1.696580271646251070184e+21', '1696580271646251070184.4430539', 0, 2);
  t('1107791439863915.5351', '1107791439863915.535095147027172', 4, 2);
  t('-532886977.4329272345712552', '-532886977.432927234571255248498', 16, 2);
  t('0.00000405110901100232', '0.0000040511090110023173739194134569067017749467', 20, 2);
  t('-0.00948680319971605622505854', '-0.009486803199716056225058540348965741932814789016495565292645244', 27, 2);
  t('0', '0.0080318078761344866009', 0, 2);
  t('-1.37577559807023391528966414020162389e+26', '-137577559807023391528966414.0201623891925167', 9, 2);
  t('-4.5121902412212444901397798054265850634052e+40', '-45121902412212444901397798054265850634051.869727661437134173358890308', 0, 2);
  t('7661428532.89', '7661428532.88944', 2, 2);
  t('-1.454177252487370323102862188643496189890378635234086314307117507172844192e+72', '-1454177252487370323102862188643496189890378635234086314307117507172844191.68', 0, 2);
  t('1', '1', 0, 2);
  t('2228091788.094318361964894877792', '2228091788.094318361964894877791728462856', 21, 2);
  t('-167212906036730617137', '-167212906036730617137.407', 0, 2);
  t('500750302397190800816.91', '500750302397190800816.905746', 2, 2);
  t('-0.00000159395903051', '-0.00000159395903050987044005601994219766495204682721341176661305', 17, 2);
  t('269475211134.877705293926202935522247619', '269475211134.8777052939262029355222476190098691256', 28, 2);
  t('134216893250721.36710032886160507672804', '134216893250721.3671003288616050767280350182737', 23, 2);
  t('1786503345716873136.90383439054', '1786503345716873136.9038343905353823339117801', 11, 2);
  t('6.033624247158741524363758442046375055019654816766227061e+53', '603362424715874152436375844204637505501965481676622706.0796529943', 1, 2);
  t('0', '0.000000891412', 0, 2);
  t('1.441272897484758186061077347880712264246610812052e+23', '144127289748475818606107.7347880712264246610812051905', 25, 2);
  t('17330641893976318.84564282', '17330641893976318.845642820744162068', 8, 2);
  t('-5.05839280161950115929179319311608856947954305e+34', '-50583928016195011592917931931160885.6947954305375437776', 10, 2);
  t('-0.0000039098583205503801528049598095573438985499608506137', '-0.00000390985832055038015280495980955734389854996085061369809565645040804908', 56, 2);
  t('-4.7619609', '-4.761960944657805969402176136088588439', 7, 2);
  t('273458691.286084108782212740242241940302', '273458691.286084108782212740242241940302211220982731343671088', 30, 2);
  t('1.31453397792031152952620632607892728680844e+40', '13145339779203115295262063260789272868084.4085', 1, 2);
  t('-17357207.2134449642186462093', '-17357207.2134449642186462093120318412401', 19, 2);
  t('-868481.451544', '-868481.4515437974', 6, 2);
  t('-0.0000176325355611781611', '-0.000017632535561178161068999572586816824236922834327427056531600273135620323', 22, 2);
  t('-0.0001587367', '-0.00015873672795035529756886', 10, 2);
  t('-1.052739979885063383916533e+21', '-1052739979885063383916.5327087', 3, 2);
  t('3216685477704.4611954923596363', '3216685477704.46119549235963631463383616410', 16, 2);
  t('-307680530765503.428571437476593', '-307680530765503.42857143747659306575704161814703801353953299558', 15, 2);
  t('3037111883.04765', '3037111883.04765194870097922567918686275782297598801628132273755040', 5, 2);
  t('-479135.81', '-479135.808320370869', 2, 2);
  t('121663.0102985209899925732302728565711', '121663.010298520989992573230272856571102', 31, 2);
  t('0.28539648840514488927929634002439242329613582', '0.2853964884051448892792963400243924232961358175446193879397140987732203563', 44, 2);
  t('1576592228177973985', '1576592228177973985.3', 0, 2);
  t('-0.0107', '-0.0107295665153732185295046079912469331520367', 4, 2);
  t('-2.3536900425940950479720519095e+26', '-235369004259409504797205190.9503521429680852294', 3, 2);
  t('-2860793.23', '-2860793.2348491781522', 2, 2);
  t('-2.85838744565432080413451445337094465696861572528518e+27', '-2858387445654320804134514453.370944656968615725285181979', 23, 2);
  t('-3.53421999222748811063287661087586e-7', '-0.000000353421999222748811063287661087586406474414299', 39, 2);
  t('-6215', '-6215.34', 0, 2);
  t('7.988771220236220007270250634879480023908e+38', '798877122023622000727025063487948002390.773', 1, 2);
  t('-1.1569696515e-7', '-0.00000011569696514766369073619293472418', 17, 2);
  t('-1115858.4455', '-1115858.44549589161866177375496670794054765702194', 5, 2);
  t('-3.896275696361162608951278497483809375561923715889e+49', '-38962756963611626089512784974838093755619237158890.34692', 0, 2);
  t('4.3245017042873698864372702101985207690004064e+23', '432450170428736988643727.021019852076900040644009173571', 20, 2);
  t('-22170178', '-22170177.70841743', 0, 2);
  t('3.6584055292803920957409556278905283081022499041139e+45', '3658405529280392095740955627890528308102249904.113921699', 4, 2);
  t('-4.50029396038632669339818689932e+27', '-4500293960386326693398186899.31915520', 2, 2);
  t('-141723568.376664689', '-141723568.376664688849', 9, 2);
  t('5626070073180771.46', '5626070073180771.464720835351567475739703', 2, 2);
  t('-1687579710795354.623048868485609055093667518', '-1687579710795354.623048868485609055093667518014861431377506825969398025', 28, 2);
  t('-844251383136295', '-844251383136295.195', 0, 2);
  t('-1366.45333803255457983', '-1366.4533380325545798269352', 17, 2);
  t('1.616517984524612699717355385084000297718640111608e+21', '1616517984524612699717.355385084000297718640111607775614178018', 27, 2);
  t('-0.00460305367297441', '-0.00460305367297441113888954961570827988520', 17, 2);
  t('-17687431722.3140597210681', '-17687431722.3140597210681325048373017817841713775', 13, 2);
  t('5394.903', '5394.90287299681', 3, 2);
  t('5.22109331317558145439471625e+26', '522109331317558145439471625.26', 0, 2);
  t('-0.000041802535523658', '-0.00004180253552365815871676', 18, 2);
  t('9.026516727856752608946954266950892264209146690378801844984922750379805e+60', '9026516727856752608946954266950892264209146690378801844984922.750379804852', 9, 2);
  t('94275109', '94275109.021', 1, 2);
  t('0.000004616456949662159600889881739', '0.00000461645694966215960088988173933387666979288344500471354739672179117074', 33, 2);
  t('-1719371359697', '-1719371359696.95', 0, 2);
  t('-27.3367', '-27.33667873', 4, 2);
  t('2543111538817370.3490073511136251015353', '2543111538817370.349007351113625101535313677948165135921164', 22, 2);
  t('1.3345940433600211820210284767785368417612358543578176164157104e+60', '1334594043360021182021028476778536841761235854357817616415710.42736', 1, 2);
  t('-3291574451706986.8758', '-3291574451706986.8757568', 4, 2);
  t('96405.635', '96405.635100', 3, 2);
  t('3049403108.412923800395777724353', '3049403108.4129238003957777243527876084827225355762', 21, 2);
  t('0', '0', 0, 2);
  t('0.00135577440331309044027', '0.001355774403313090440268742644904579785259888199353003417742070', 23, 2);
  t('-9.217391826607404316458528e+25', '-92173918266074043164585279.81118', 0, 2);
  t('0.0237258', '0.02372578857087513310497550', 7, 2);
  t('-48', '-48.4', 0, 2);
  t('6.9959049225118279690633605702415647755970752718462923693534691e+60', '6995904922511827969063360570241564775597075271846292369353469.06081011824', 1, 2);
  t('-2.91644062862385254968625542750539352911940245514111765589074092469129478e+69', '-2916440628623852549686255427505393529119402455141117655890740924691294.776', 2, 2);
  t('0.000008340907791377', '0.000008340907791377023026', 18, 2);
  t('0', '-0.00000015', 1, 2);
  t('-15907748.2', '-15907748.189', 1, 2);
  t('0', '0.0000000516717209025282803', 3, 2);
  t('0.00805700885801193345479952', '0.00805700885801193345479951801', 26, 2);
  t('0', '0.000000690241671505883936406906696546003155121125187210750083970996577124118', 1, 2);
  t('562', '562.32', 0, 2);
  t('-5.881233836149031776879600122668181177e+21', '-5881233836149031776879.600122668181177011921512256229', 16, 2);
  t('-278290307625765293888.05', '-278290307625765293888.0507900', 2, 2);
  t('5', '4.79', 0, 2);
  t('-1198252696874748.3211911365306282303', '-1198252696874748.32119113653062823030286029915', 20, 2);
  t('1.85945139752585852753811e-8', '0.000000018594513975258585275381132530313449911158263', 31, 2);
  t('-1.1407050071970528529191421693346177928979244133835766190739141389528248e+65', '-114070500719705285291914216933461779289792441338357661907391413895.2824761', 5, 2);
  t('-0.353', '-0.3534130540265816021015859736', 3, 2);
  t('28664614.408117689', '28664614.408117689188239077547338', 9, 2);
  t('-268871363196450682.614', '-268871363196450682.6136699', 3, 2);
  t('2', '2.4', 0, 2);
  t('0', '0', 0, 2);
  t('0.038863047504098263754587496098', '0.0388630475040982637545874960983', 30, 2);
  t('-552382524740993597449.17971153278', '-552382524740993597449.179711532783627', 11, 2);
  t('1.561800830043227350712928455747038e+30', '1561800830043227350712928455747.03816', 3, 2);
  t('0', '0.372000', 0, 2);
  t('30.804347619793369791031725539335381852887648326486049230154802476', '30.8043476197933697910317255393353818528876483264860492301548024760023311', 64, 2);
  t('13368', '13368.02', 0, 2);
  t('2723634870', '2723634869.88045', 0, 2);
  t('7', '7', 0, 2);
  t('0.0071000662601', '0.00710006626011943981022498192125744874706640717982408', 13, 2);
  t('-9334602199292852753.5651', '-9334602199292852753.565061', 4, 2);
  t('2.729836503389467360083910925625124385529680269583096301667151203843208783e+65', '272983650338946736008391092562512438552968026958309630166715120384.320878309', 7, 2);
  t('-0.006', '-0.0056357', 3, 2);
  t('22899716068547.126306054', '22899716068547.12630605408664680838', 9, 2);
  t('-5.02824725050301597590659024229733081751392712748e+46', '-50282472505030159759065902422973308175139271274.848', 1, 2);
  t('-87', '-87.154481969', 0, 2);
  t('-0.00004553187486191', '-0.00004553187486190784', 17, 2);
  t('4.184376969241000088691790311151962529738578473848959e+32', '418437696924100008869179031115196.25297385784738489589', 19, 2);
  t('-0.397263', '-0.39726251919448835621320733060316', 6, 2);
  t('78845952.939020828383752049449151195187870271022', '78845952.9390208283837520494491511951878702710218984505967916788', 39, 2);
  t('2.770372114757730412680309526784713044108130304373392176e+51', '2770372114757730412680309526784713044108130304373392.176244754', 3, 2);
  t('0', '0.000000016720450859173397668989', 5, 2);
  t('-1.562455332398304839537137663396453141288893760649393300155e+29', '-156245533239830483953713766339.645314128889376064939330015503', 28, 2);
  t('0.000876344550348635702', '0.0008763445503486357022165753142695186277630007987646280699898384', 21, 2);
  t('-1', '-1', 0, 2);
  t('-8.7689639992444559472566978362522431218385745539867e+49', '-87689639992444559472566978362522431218385745539866.770786098116338', 0, 2);
  t('6.745165947865409245106269e+24', '6745165947865409245106268.9', 0, 2);
  t('-9690090866817300866.5001184568', '-9690090866817300866.5001184567974535869898427535739539447563', 10, 2);
  t('16812157145369246.1390494058969646849926124434165956423925626', '16812157145369246.139049405896964684992612443416595642392562629', 43, 2);
  t('-85.743964880502573121090925427555594662684357', '-85.7439648805025731210909254275555946626843566155871159446020573999638237', 42, 2);
  t('0.05752687180161750017555411217026419371188707852', '0.057526871801617500175554112170264193711887078519141747897656972093', 47, 2);
  t('-62.536520674882', '-62.53652067488192047470964', 12, 2);
  t('-6.304771829630676008320130020526e+28', '-63047718296306760083201300205.2565', 2, 2);
  t('-1.7750867078270178043590219665540149640345992e+39', '-1775086707827017804359021966554014964034.5991580785', 4, 2);
  t('-6.73252754422871084624524819626268003', '-6.73252754422871084624524819626268002578592446', 35, 2);
  t('12230467541708652594.81344', '12230467541708652594.8134442936', 5, 2);
  t('5.9515360926529978569058942741307748379577128394359794e+45', '5951536092652997856905894274130774837957712839.4359794485658237', 7, 2);
  t('-7.39392590188918268234992452e+26', '-739392590188918268234992451.67508368118561', 0, 2);
  t('16286.3232351229941418', '16286.323235122994141804376055326858788736369392450153849161300046353727', 17, 2);
  t('15469.69867', '15469.698666429057', 5, 2);
  t('-10', '-9.7', 0, 2);
  t('-0.000014693761691537558568253201957781367850654159135332775062', '-0.0000146937616915375585682532019577813678506541591353327750624395516217833370960', 60, 2);
  t('-0.0001424906145756648557167', '-0.0001424906145756648557167372535004793436424937964062239423', 25, 2);
  t('-1078093526184022.7963', '-1078093526184022.796253', 4, 2);
  t('-1.815287952979117938264058056902741947894527910100505717833774716838e+65', '-181528795297911793826405805690274194789452791010050571783377471683.767', 1, 2);
  t('-653.9065768471', '-653.906576847053298532666147291912030069213', 10, 2);
  t('0.09140216031745575', '0.0914021603174557462098609339238985', 17, 2);
  t('43.8809', '43.8809157757331', 4, 2);
  t('-86108', '-86107.612', 0, 2);
  t('3.86022289248163319594748155782859e+32', '386022289248163319594748155782858.9007', 0, 2);
  t('5.621196571890384186384686118709744384577384856e+41', '562119657189038418638468611870974438457738.48557635682977189942282386179928', 4, 2);
  t('-113474555.303661301570927857', '-113474555.30366130157092785703509802627045554249807599884692307252251912', 18, 2);
  t('0', '0.00000024871666447686081513415760090831233621149', 6, 2);
  t('0', '0.000003140', 0, 2);
  t('-0.8077', '-0.80768350725', 4, 2);
  t('2716795343.054377410367818069076130325912', '2716795343.0543774103678180690761303259119780871514', 30, 2);
  t('0.08215183479018280866121048171017014672595', '0.082151834790182808661210481710170146725947636135600624942', 41, 2);
  t('-15599396', '-15599396.47463676716826571518009734129', 0, 2);
  t('21237332302166130', '21237332302166130.5', 0, 2);
  t('4.446802729574404672215e+21', '4446802729574404672214.5841989231212', 0, 2);
  t('151595', '151594.7878535770037932', 0, 2);
  t('-9', '-9.1', 0, 2);
  t('18', '18.35584408282', 0, 2);
  t('-0.04536687705', '-0.045366877045781157814871332455248235349', 11, 2);
  t('3.58962', '3.589620823', 5, 2);
  t('-3470871455926727', '-3470871455926727.4213', 0, 2);
  t('-5.43267224426488094025101495226314154904279e+37', '-54326722442648809402510149522631415490.42787135', 4, 2);
  t('2.1701233393452135837687989289801783613534e+40', '21701233393452135837687989289801783613533.7083', 0, 2);
  t('-110226456088098.34', '-110226456088098.3354257139084337657140821170', 2, 2);
  t('1.79527294692173689644030821922e+29', '179527294692173689644030821922.36', 0, 2);
  t('2465786', '2465785.5', 0, 2);
  t('0.059', '0.0590097', 4, 2);
  t('-0.00032341204149493519172411533844411518109538', '-0.00032341204149493519172411533844411518109537514034386131655201857305', 44, 2);
  t('-19632526678771', '-19632526678770.5179362', 0, 2);
  t('83850975.9116141', '83850975.91161413953344', 7, 2);
  t('1.3330575581185095e-8', '0.000000013330575581185094725', 24, 2);
  t('9.593757839891004592635206828432142735400349114724354435185e+27', '9593757839891004592635206828.432142735400349114724354435184976270503456', 31, 2);
  t('-1.5834359535561981827384627232289049496513728e+29', '-158343595355619818273846272322.89049496513727978', 15, 2);
  t('-161385178003980959.7', '-161385178003980959.71957215', 1, 2);
  t('-8.15856460209393352542084878399e+24', '-8158564602093933525420848.7839864247', 5, 2);
  t('-734334.87', '-734334.86528524', 2, 2);
  t('-339107.532', '-339107.53240533465722', 3, 2);
  t('0.0182264564729', '0.01822645647290769756975719547208786195238221037777193944140277446083612264', 13, 2);
  t('0', '0.000000312535177523535094674680811257', 4, 2);
  t('-1.02317614554336751348183375464e+25', '-10231761455433675134818337.5464107', 4, 2);
  t('-5192', '-5192.2', 0, 2);
  t('4.194414075099341862772775482e+27', '4194414075099341862772775481.96', 0, 2);
  t('0.011', '0.011409868990755914863555139060256834004384701965', 3, 2);
  t('119.9377386667742', '119.937738666774165317150', 13, 2);
  t('-280557779722362', '-280557779722361.920271594258351879901', 0, 2);
  t('-88990007973014097', '-88990007973014097.402', 0, 2);
  t('0.1626198829126045426702564789', '0.162619882912604542670256478874554675083', 28, 2);
  t('0', '0.0000001077381345477023', 4, 2);
  t('-0.0010058504431498241471201525718053', '-0.00100585044314982414712015257180528', 34, 2);
  t('39507381.12', '39507381.117798830437320321819745628719103', 2, 2);
  t('-2.050602224312136987122686636e+23', '-205060222431213698712268.663604116', 5, 2);
  t('-14.755523280399235472', '-14.75552328039923547174081588953690734302657223334', 18, 2);
  t('5', '5', 0, 2);
  t('-9.75881721989668738875263337478353073721585336373089515072925085364e+25', '-97588172198966873887526333.747835307372158533637308951507292508536375', 40, 2);
  t('0', '-0.0000015245848', 3, 2);
  t('-0.00001922927428707613217504434079596', '-0.00001922927428707613217504434079595910790056397804239', 35, 2);
  t('7375868', '7375868.357940', 0, 2);
  t('-2.59884314', '-2.598843139712835', 8, 2);
  t('-3069.5', '-3069.509358849664', 1, 2);
  t('277549389.08968912793732154', '277549389.0896891279373215444205527113793247', 17, 2);
  t('-3.6788826053419000928251587320525e+30', '-3678882605341900092825158732052.500322302531277210598', 1, 2);
  t('9.548857944235036904508484482396167658656110421603801e+47', '954885794423503690450848448239616765865611042160.3800783', 4, 2);
  t('98806177.44981668', '98806177.44981668155474315342', 8, 2);
  t('206.85148341', '206.8514834102037', 8, 2);
  t('1.6697970968114023796527900430323144973544151692977457e+44', '166979709681140237965279004303231449735441516.929774568403', 8, 2);
  t('-5.876853276710302874983908e+22', '-58768532767103028749839.07955', 3, 2);
  t('-28.477683461', '-28.47768346112565043170812', 9, 2);
  t('-414152503735.735094144050962324427196806634', '-414152503735.73509414405096232442719680663367650677003262299033', 30, 2);
  t('-1530', '-1530.2325969933', 0, 2);
  t('1.67495602958004117641339319024379972941875931904023877993700175078e+65', '167495602958004117641339319024379972941875931904023877993700175077.95137', 1, 2);
  t('5234', '5233.662', 0, 2);
  t('-190523450.6', '-190523450.567', 1, 2);
  t('1.1432525741847682794437171601229238400265e+40', '11432525741847682794437171601229238400264.9661', 1, 2);
  t('-2.99583340382501073629209407987407915791340762683834568719e+35', '-299583340382501073629209407987407915.7913407626838345687187994', 21, 2);
  t('-0.00004', '-0.0000392', 5, 2);
  t('71621.14', '71621.144179', 2, 2);
  t('-1890', '-1890.14', 0, 2);
  t('1.4686517218614327647983137371969e+22', '14686517218614327647983.13737196939359638064986252998693', 9, 2);
  t('489090527336691382696.105', '489090527336691382696.10541305057', 3, 2);
  t('304070461379406.605407', '304070461379406.60540684169314', 6, 2);
  t('-11.6', '-11.568', 1, 2);
  t('1.422624734702245114376941302742587248917335e+37', '14226247347022451143769413027425872489.173350489614354031691494939', 6, 2);
  t('1.9', '1.8969534077467812781478737406964724400409391', 1, 2);
  t('2027091', '2027090.944', 0, 2);
  t('1.2234607376132958e-8', '0.0000000122346073761329580239635143344389270410244', 25, 2);
  t('0.000205265132', '0.0002052651317354143799470812669', 12, 2);
  t('227729.86380759002723544183936484272966773', '227729.863807590027235441839364842729667729035395957243', 35, 2);
  t('6.42747724441705776916400463006150151711550978008727e+36', '6427477244417057769164004630061501517.11550978008727410', 14, 2);
  t('-52051054081793.2672679713905273103909501396258575', '-52051054081793.2672679713905273103909501396258574953153828', 34, 2);
  t('0', '0', 0, 2);
  t('11875545.61', '11875545.610120', 2, 2);
  t('83542652463', '83542652462.958362000208518025786276278329509580', 1, 2);
  t('-401437509134.126753911001702061515772', '-401437509134.126753911001702061515772042472', 25, 2);
  t('117209371.58414', '117209371.5841398132283', 5, 2);
  t('-74527.75605569111', '-74527.7560556911142469', 11, 2);
  t('-0.09', '-0.090352527437431724009201587160643523155031024972052117377', 2, 2);
  t('5.55', '5.553662', 2, 2);
  t('102227377262987.3093738016576', '102227377262987.30937380165760189891748642629640436577221577326700076451', 14, 2);
  t('-1.08505022157355782542910761489229861552176e+39', '-1085050221573557825429107614892298615521.76460395', 2, 2);
  t('-13', '-12.6', 0, 2);
  t('-3632808919.1', '-3632808919.07371062219', 1, 2);
  t('-485708170667.969649834185802791581238709', '-485708170667.9696498341858027915812387093327385', 27, 2);
  t('-4.594805598', '-4.59480559832078991740', 9, 2);
  t('1346356.65', '1346356.650482596113805165394442591002016854', 2, 2);
  t('-2.16009738819645430801800828e+26', '-216009738819645430801800827.56078', 0, 2);
  t('-52704.267218', '-52704.2672175213516660657448', 6, 2);
  t('-2.916153881351363898131418752828573101558e+37', '-29161538813513638981314187528285731015.579857871545774805605', 3, 2);
  t('-3.4937178314931012799461660644864734612715548774e+42', '-3493717831493101279946166064486473461271554.8773821822', 4, 2);
  t('0', '0.0000023647203264421', 1, 2);
  t('1.989756784879801030533213375415812776636025008435569523075e+40', '19897567848798010305332133754158127766360.2500843556952307500839202812', 18, 2);
  t('-97260642', '-97260642.05', 0, 2);
  t('0', '-0.0000000337886464136259021586124727251750885109409', 2, 2);
  t('-1.14257955e-8', '-0.00000001142579546607962945225', 16, 2);
  t('7.44877621032950231335430253285255273724302401015805296e+53', '744877621032950231335430253285255273724302401015805295.7', 0, 2);
  t('1.775299455743090238528215532021e+29', '177529945574309023852821553202.13198', 1, 2);
  t('-2.37905145360030744233272167257615464e+35', '-237905145360030744233272167257615464.5', 0, 2);
  t('1.02175848129590067439065e+23', '102175848129590067439065.02', 0, 2);
  t('0', '-0.000273593279278068', 0, 2);
  t('-0.0000183471573', '-0.0000183471573015865', 13, 2);
  t('-2.12274080557609569582588730594098004856e-7', '-0.00000021227408055760956958258873059409800485622885332576686587569613000909143762', 45, 2);
  t('3.0200161e-7', '0.00000030200160571197733444217721269656', 14, 2);
  t('-6263.10301664173381991555829833514363', '-6263.103016641733819915558298335143627616957', 32, 2);
  t('-324565569264469.7697', '-324565569264469.76973626498148841934', 4, 2);
  t('2.0356920034598500325931466276970479920769197e+39', '2035692003459850032593146627697047992076.91966941729463', 4, 2);
  t('-3.7274264783062264794262624965296657029e+35', '-372742647830622647942626249652966570.29370', 2, 2);
  t('1.60302196933629697346794839662315623452283174780650335959292811374e+47', '160302196933629697346794839662315623452283174780.6503359592928113740962157369', 18, 2);
  t('-0.024429818883535342', '-0.0244298188835353418193163558516579', 18, 2);
  t('23756303523305.6140950547', '23756303523305.6140950547362366198', 10, 2);
  t('-64', '-64.121465561370155651261986518696226', 0, 2);
  t('-1', '-1.13', 0, 2);
  t('-5.9e-8', '-0.0000000593304079243227119', 9, 2);
  t('5627537826012654.05876667817', '5627537826012654.05876667816732352831662092524977075', 11, 2);
  t('-8.27665277458e-8', '-0.00000008276652774579588', 19, 2);
  t('861513716', '861513715.6741', 0, 2);
  t('3e-7', '0.000000257206720261651', 7, 2);
  t('0', '0.0007927', 2, 2);
  t('86896.0793', '86896.0793412169', 4, 2);
  t('1881.403', '1881.403241319480686035039127812', 3, 2);
  t('4.392651708547615025847404743299513825363847608692e+48', '4392651708547615025847404743299513825363847608692.07', 0, 2);
  t('88490', '88490.47', 0, 2);
  t('-0.002520080111610405629478', '-0.0025200801116104056294775120111812168253859022387858989987369', 24, 2);
  t('-0.00001954811406075605', '-0.000019548114060756054246867110232262755190200519141776424080201732786', 20, 2);
  t('2223754.7527995', '2223754.7527994672219542483768111486118124321099', 7, 2);
  t('6.091736744674932958041487633787806768568507433438650553608452876e+63', '6091736744674932958041487633787806768568507433438650553608452875.72', 0, 2);
  t('49894.113', '49894.1127799519294971', 3, 2);
  t('0.00014716749253645018595071503227', '0.000147167492536450185950715032272743133814160026661411028052325585862', 32, 2);
  t('3.81040319815393750281067878907184507122920230505815564457784e+45', '3810403198153937502810678789071845071229202305.05815564457784047325821743', 14, 2);
  t('-876471048554.3', '-876471048554.3047', 1, 2);
  t('-2.88524162951643474889032043499458669e+33', '-2885241629516434748890320434994586.6882765880', 2, 2);
  t('-0.001736753895', '-0.0017367538954142089514084785545', 12, 2);
  t('-4', '-4', 0, 2);
  t('-6.512960873093505284474111490971867178300352124628025656839315965e+52', '-65129608730935052844741114909718671783003521246280256.5683931596513567720910', 11, 2);
  t('1.0980475166911', '1.09804751669106053295836153349782413287881213', 13, 2);
  t('-9.52739343917771237705829027591031075925453730263899396244900573459e+40', '-95273934391777123770582902759103107592545.3730263899396244900573459364', 25, 2);
  t('6266994391864.6457286946', '6266994391864.64572869458316836014463', 10, 2);
  t('32818087531630388688.541212000359651379985916816547', '32818087531630388688.541212000359651379985916816547001029122', 30, 2);
  t('-6.74952425706814883243146844744111948684907205e+33', '-6749524257068148832431468447441119.4868490720458937275298704', 11, 2);
  t('1390737649580.164027609372666559633410099161120120113528', '1390737649580.16402760937266655963341009916112012011352799657622104260826183', 42, 2);
  t('1.377356798931617572168824144922e+28', '13773567989316175721688241449.2249378', 2, 2);
  t('-136.980592', '-136.98059207687877543990242', 6, 2);
  t('-9.940719781507809586982903206069125166489707e+24', '-9940719781507809586982903.206069125166489706924170724911', 18, 2);
  t('-2.919415632330415539162055538e+27', '-2919415632330415539162055538.36743214', 0, 2);
  t('0.5044040336849305898871951944104110698368739561294195225', '0.50440403368493058988719519441041106983687395612941952252648164', 55, 2);
  t('-211939308449.806', '-211939308449.80610', 3, 2);
  t('9', '9', 0, 2);
  t('-0.000002529042206717194', '-0.00000252904220671719422836', 21, 2);
  t('0.13783', '0.137833239471954697384832913641929313', 5, 2);
  t('-7', '-6.959319286182', 0, 2);
  t('-18376.595853842449641806856827882353282165594', '-18376.5958538424496418068568278823532821655944864835322', 39, 2);
  t('-5.788181284389440139668504e+24', '-5788181284389440139668504.04', 0, 2);
  t('-6517661118689', '-6517661118688.671', 0, 2);
  t('-4', '-3.9', 0, 2);
  t('-31134726.3196', '-31134726.31956543905411576841391657438724006870983352032765413', 4, 2);
  t('736935.6717779', '736935.67177787809451704627896212268788499886470861541163', 7, 2);
  t('-1.19413296045337846822938788115970951731619e+41', '-119413296045337846822938788115970951731618.6053098788249753452', 0, 2);
  t('-2.430625127524074829671611249118947124506314106473763566088e+32', '-243062512752407482967161124911894.7124506314106473763566088179', 25, 2);
  t('2.97154e-7', '0.0000002971535498369260212763981014672847846827781862484611818953', 12, 2);
  t('5.131850706303771906876154006932365178207368407589e+45', '5131850706303771906876154006932365178207368407.58930848', 3, 2);
  t('-2.594623492073402044682711994246207736e+35', '-259462349207340204468271199424620773.619225', 1, 2);
  t('-580515', '-580514.51266982', 0, 2);
  t('3', '2.6', 0, 2);
  t('499491386121413.839966864719354501', '499491386121413.83996686471935450079', 18, 2);
  t('-197419447699338754619.241644310441263', '-197419447699338754619.2416443104412628738', 15, 2);
  t('2.73619440021960269467178371169519e+32', '273619440021960269467178371169518.67', 0, 2);
  t('0.000015271956744930317606856959647902032034991009788568796', '0.00001527195674493031760685695964790203203499100978856879597', 57, 2);
  t('2.0469381062538947948048399936368577750183119466067181e+36', '2046938106253894794804839993636857775.018311946606718080', 16, 2);
  t('-2.21538347481844971594054e+21', '-2215383474818449715940.54466', 2, 2);
  t('19104837206.88', '19104837206.8785650019902873131114637398122818852991713', 2, 2);
  t('-2.05e-8', '-0.0000000205037320799412748102174720532304479663672372992229635664934671661929', 10, 2);
  t('-1.54034202082889515748408194e-8', '-0.0000000154034202082889515748408194049', 35, 2);
  t('-0.00000148490511430300806742668011308298618928937721949', '-0.000001484905114303008067426680113082986189289377219486220129452620539', 53, 2);
  t('1.06947853825804210903107783956033201405330460741113965153452866240598028333658574600335986282424005728822195712469239427515115497688805463213672082362783538099103520875006075956709410401127681714635619808549164975775653198187384132067097089033589263672210569243378453394296722458663645730124374780200631239499035297347068633399893578423983210776283580625821940144222187506712840219298810415057963261973055402443168859938145430149792389607844764196802154175749313795864230898105128337096324097715e+112', '10694785382580421090310778395603320140533046074111396515345286624059802833365857460033598628242400572882219571246.9239427515115497688805463213672082362783538099103520875006075956709410401127681714635619808549164975775653198187384132067097089033589263672210569243378453394296722458663645730124374780200631239499035297347068633399893578423983210776283580625821940144222187506712840219298810415057963261973055402443168859938145430149792389607844764196802154175749313795864230898105128337096324097715316745478605824049582433501231131614926547026172075676335478969822988872724971675943974680694103048603395181915379760948587689747562343921462399023385862972305737770702775356163975369732864199938961020377305697840185796727984150041090650368003', 382, 2);
  t('1.666459852506088168940120080515492127846107360888123211919252210485934832e+35', '166645985250608816894012008051549212.7846107360888123211919252210485934832046158028424177226511182571636047696001087114343029984850297897', 38, 2);
  t('6.795422862161439777133903173611314918560038216974815214939905174613969043746572902940337970764552530690194400013861117517675495274170021408916149693335937318130790526998291013468189650994970285684672283481295779507882877959051666346246442284486862455561895975859865354050430664693584564169600892792136243794827310642598727847206593084e-7', '0.00000067954228621614397771339031736113149185600382169748152149399051746139690437465729029403379707645525306901944000138611175176754952741700214089161496933359373181307905269982910134681896509949702856846722834812957795078828779590516663462464422844868624555618959758598653540504306646935845641696008927921362437948273106425987278472065930838249339634376551644739510812090250783854642527850733364781848186734237535786279286466267174280926901122630867278466184745897155447413254972336025365004060824737540978874643680859778500140264160473', 340, 2);
  t('-5.54355224689196844206859540363498692034719895921748834278269838486587451020484476411412420100529171186353680057871054976715300749756833859399255728021953892489844952806572444070781089008785332958846102959532440189983269164499559578570579783482347156352653297783089500247950240789247732417130487000728146146750592278993087383958504592787728768825737216406179968758245527771260009803330413354492471210501617590136098619488503725533652941984324437991860841248948016812599622204499741034884841495557895147301378076755e+445', '-55435522468919684420685954036349869203471989592174883427826983848658745102048447641141242010052917118635368005787105497671530074975683385939925572802195389248984495280657244407078108900878533295884610295953244018998326916449955957857057978348234715635265329778308950024795024078924773241713048700072814614675059227899308738395850459278772876882573721640617996875824552777126000980333041335449247121050161759013609861948850372553365294198432443799.18608412489480168125996222044997410348848414955578951473013780767545375506505763870999386335585090677935839415557291517548517372483099509837724691439063670273856129047489', 67, 2);
  t('-1.038423229963297710070799812780594733870806645120204521101153028241587269142557204149036780962768944346262853146999169453538114642577746872981543397527917079134275352059973647053423481416375263148940763516017475328454656432465396109620956410605718777812402229415468896313e+207', '-1038423229963297710070799812780594733870806645120204521101153028241587269142557204149036780962768944346262853146999169453538114642577746872981543397527917079134275352059973647053423481416375263148940763516017.47532845465643246539610962095641060571877781240222941546889631318090011936631395629133025949352554817487189764986556035050585870288979670296892407195043380429320863938431760347995985515782979075529024437173605', 63, 2);
  t('8.065651075321143246040850009763097959044533851699723570348927203628584985160062586480941064076934619876975029387054157915068857896332361627034335238120500756293865622499568841613676346408932187928798004379733010314247e+192', '8065651075321143246040850009763097959044533851699723570348927203628584985160062586480941064076934619876975029387054157915068857896332361627034335238120500756293865622499568841613676346408932187.928798004379733010314247003299794121687552736213805867662', 26, 2);
  t('3.755251348586178013256491795260474822130327679322928599973564802612022947035253831502390443833283173811818869685965694441144295788399306628553857621790836089128737568257964630143653411992511976227894547548026996174581171880909938220161371478535428434648089431053486261717575680974847249359e+273', '3755251348586178013256491795260474822130327679322928599973564802612022947035253831502390443833283173811818869685965694441144295788399306628553857621790836089128737568257964630143653411992511976227894547548026996174581171880909938220161371478535428434648089431053486261717575.68097484724935855314654858493044317521713283', 15, 2);
  t('1.387080130424276523575308751131710282141382406374751822200756834050776526956906706127471044689577632997933469417179151174707015492859254718943091966840592138437472858086537927043359078800761961974437918067501488911857847082084614313343570527022926132823594753199206424619916401613903645400246787e+272', '138708013042427652357530875113171028214138240637475182220075683405077652695690670612747104468957763299793346941717915117470701549285925471894309196684059213843747285808653792704335907880076196197443791806750148891185784708208461431334357052702292613282359475319920642461991.64016139036454002467870753530166006895080634133700307339994605318746285606605073353768500074983272463614878771789', 22, 2);
  t('-2.0147295359992226490664114468525909001083615718156688545109096030966812316646296696244506758247380693060716738997774336291334777558764168442727045228978658333475633951171114409162804797915645069952459681290495610755679161021535360787280798779945877150305455930002954788915519355859501739508635378049100689305317716787e+269', '-201472953599922264906641144685259090010836157181566885451090960309668123166462966962445067582473806930607167389977743362913347775587641684427270452289786583334756339511711144091628047979156450699524596812904956107556791610215353607872807987799458771503054559300029547889.15519355859501739508635378049100689305317716786951516233580707306193436745410967166057722082066234795871225272004585743988004310277976348845952193544799339399270894134537975729366831004390595794638774978735891732320626305334667695544905377923208230333561302518753006083732106004221640098474474898156374500650480817182411615989343913968729275', 47, 2);
  t('-6.4682751605699355152266972951219578190232663387125277427813370101021024454088417337203306465434592368744067517932721298668319157478136775716794966023207432720971025564367309853897410122135689538902518988304105352456783498314585984555931949638826096953846413551985933439654307839734950854166998750670707454974566582975088165611307071735157582662935545867739486245437961518301507423104249032343960859764576608030271247372660070350389908389430595724896643252828388489303743567441360757671539e+249', '-6468275160569935515226697295121957819023266338712527742781337010102102445408841733720330646543459236874406751793272129866831915747813677571679496602320743272097102556436730985389741012213568953890251898830410535245678349831458598455593194963882609695.38464135519859334396543078397349508541669987506707074549745665829750881656113070717351575826629355458677394862454379615183015074231042490323439608597645766080302712473726600703503899083894305957248966432528283884893037435674413607576715392267537759820458682796889223257918124328104437523683802855020225211529425741276482883297680943485112', 238, 2);
  t('5230967583910917018.50408152810449967993263111384544784726', '5230967583910917018.50408152810449967993263111384544784725922303637701488425', 38, 2);
  t('-0.000085973527408593099297590684824326491271165817048126780181592293397723679155645862767949431630165486569936241487844960076963', '-0.0000859735274085930992975906848243264912711658170481267801815922933977236791556458627679494316301654865699362414878449600769633687185176786270458354947674908972417152027784127735753855428208967654594385777066599617492461534927747699445067573964509724154493067244067868559216103094348525698193681847454441400336730113735370577184008388250', 126, 2);
  t('-9.3847383309424905092769888480938735782018823273293340248673207665497218024993378966128004521828466138060970432748067803944342148229594394346525017564326180056518201810017521759339476789450692085472086161159434651133321658654080808856427367695408032643998143849351421395165378721233408866762093964110432258780229e+303', '-9384738330942490509276988848093873578201882327329334024867320766549721802499337896612800452182846613806097043274806780394434214822959439434652501756432618005651820181001752175933947678945069208547208616115943465113332165865408080885642736769540803264399814384935142139516537872123340886676209396411043225.878022887143305613', 7, 2);
  t('-7.86369869882265586932482627732231268105900029876920276398291943996637269402814339594667942531593510873608675301033720550758603882629417032584858e+122', '-786369869882265586932482627732231268105900029876920276398291943996637269402814339594667942531593510873608675301033720550758.60388262941703258485804554572282126764058890142339713655268042738219801468219614749500', 22, 2);
  t('-3.24857067939522454734336203662672299837356891031743623860060538736486301475399061560512392394884948745543208602570775307358755746669961014878645623565611494631180939993451255915972674634834616018539901681606751450166257e-7', '-0.0000003248570679395224547343362036626722998373568910317436238600605387364863014753990615605123923948849487455432086025707753073587557466699610148786456235656114946311809399934512559159726746348346160185399016816067514501662571156091293134174347038519804296721477826974827296719926896623954921270961340041265740815881463886029615618666804627388609251441241506365246517894986651117794381468287345354611387206329', 225, 2);
  t('-5.9670766439293144146547691222551429082605718907793715738025865511910266033917629911839964290319954814528909057720556941094162253740574605331983125017245800601068795343684034767491074047e+73', '-59670766439293144146547691222551429082605718907793715738025865511910266033.9176299118399642903199548145289090577205569410941622537405746053319831250172458006010687953436840347674910740466327752921613094989509085998298098885318461726700218175283830994713114336237775743029926303902381171775835259997315252881136774538178086270869890018', 111, 2);
  t('2.5096639117920463462287328597296749981043275920449323425180027976786885113276657223411254461434269831425623582399660089134643409640967108556266387756733203512320234738256119878196681697440729493145607544255387069966170741620152988303108642695833719140542818586581182077496877278980368345805264823051552922025335588381030245229042320819186001790656047668908952938407230366580345510489802293908847175605443453027574073443725254019132539578894357997564831507795134922021932595993282495857755246142968279845938140122676856708224385947019820217053e+384', '2509663911792046346228732859729674998104327592044932342518002797678688511327665722341125446143426983142562358239966008913464340964096710855626638775673320351232023473825611987819668169744072949314560754425538706996617074162015298830310864269583371914054281858658118207749687727898036834580526482305155292202533558838103024522904232081918600179065604766890895293840723036658034551048980.2293908847175605443453027574073443725254019132539578894357997564831507795134922021932595993282495857755246142968279845938140122676856708224385947019820217053305656', 157, 2);
  t('-2.8507660941108569550287308326064177121151538201978258092410665344309678010272912820704619664520658494905035914159401466197846483930745282965809112705487219212406030489394517260243199295173286870921113764608918717971025087726764185158191295932128205693711051120987324699581522929876731219164524225135484900780869219107191498080757339162373435074430045067468529047359582843910911985237699559020798413773087104499530272180332255967127361187e+398', '-285076609411085695502873083260641771211515382019782580924106653443096780102729128207046196645206584949050359141594014661978464839307452829658091127054872192124060304893945172602431992951732868709211137646089187179710250877267641851581912959321282056937110511209873246995815229298767312191645242251354849007808692191071914980807573391623734350744300450674685290473595828439109119852376995590207984137.73087104499530272180332255967127361187414060128315925467453140320346147820', 38, 2);
  t('-3.59089828969834447089866670409563698613796519920887260893628116796219699700295155566574700974305862881829539116842175156625589321038153746830136335430975180117738583836263157892672949110363994957437257028596753086911681027493231687723660583340473066987864559390829822248332270981499602035052694294589999780431928143466271681066767593313168237835986350589527099528400107655526657067e+260', '-359089828969834447089866670409563698613796519920887260893628116796219699700295155566574700974305862881829539116842175156625589321038153746830136335430975180117738583836263157892672949110363994957437257028596753086911681027493231687723660583340473066987864559390.829822248332270981499602035052694294589999780431928143466271681066767593313168237835986350589527099528400107655526657067124497659393816422837799218949133277601595497917912674114827477096642873285066389309250196072308994823837109436543139707', 120, 2);
  t('8.9952767699784490329238753106556088240055363532827226609029521944449657384883384170667072930734367679170716914947678038820950440722219201194e+43', '89952767699784490329238753106556088240055363.53282722660902952194444965738488338417066707293073436767917071691494767803882095044072221920119400608976324854', 97, 2);

  test.isException(function () {new Big('12.345').round(null)}, ".round(null)");
  test.isException(function () {new Big('12.345').round(NaN)}, ".round(NaN)");
  test.isException(function () {new Big('12.345').round('NaN')}, ".round('NaN')");
  test.isException(function () {new Big('12.345').round([])}, ".round([])");
  test.isException(function () {new Big('12.345').round({})}, ".round({})");
  test.isException(function () {new Big('12.345').round('')}, ".round('')");
  test.isException(function () {new Big('12.345').round(' ')}, ".round(' ')");
  test.isException(function () {new Big('12.345').round('hello')}, ".round('hello')");
  test.isException(function () {new Big('12.345').round('\t')}, ".round('\t')");
  test.isException(function () {new Big('12.345').round(new Date)}, ".round(new Date)");
  test.isException(function () {new Big('12.345').round(new RegExp)}, ".round(new RegExp)");
  test.isException(function () {new Big('12.345').round(function () {})}, ".round(function () {})");
  test.isException(function () {new Big('12.345').round(0.1)}, ".round(0.1)");
  test.isException(function () {new Big('12.345').round(7.5)}, ".round(7.5)");
  test.isException(function () {new Big('12.345').round('0')}, ".round('0')");
  test.isException(function () {new Big('12.345').round('1')}, ".round('1')");
  test.isException(function () {new Big('12.345').round('1.2')}, ".round('1.2')");
  test.isException(function () {new Big('12.345').round('99')}, ".round('99')");
  test.isException(function () {new Big('12.345').round('1.1e1')}, ".round('1.1e1')");
  test.isException(function () {new Big('12.345').round('-1')}, ".round('-1')");
  test.isException(function () {new Big('12.345').round(1e9 + 1)}, ".round(1e9 + 1)");
  test.isException(function () {new Big('12.345').round(1e9 + 0.1)}, ".round(1e9 + 1)");
  test.isException(function () {new Big('12.345').round('-0.01')}, ".round('-0.01')");
  test.isException(function () {new Big('12.345').round('-1e-1')}, ".round('-1e-1')");
  test.isException(function () {new Big('12.345').round(Infinity)}, ".round(Infinity)");
  test.isException(function () {new Big('12.345').round('-Infinity')}, ".round('-Infinity')");
  test.isException(function () {new Big('12.345').round(new Big('2'))}, ".round(new Big('2'))");

  test.isException(function () {new Big('12.345').round(u, null)}, ".round(u, null)");
  test.isException(function () {new Big('12.345').round(u, NaN)}, ".round(u, NaN)");
  test.isException(function () {new Big('12.345').round(u, 'NaN')}, ".round(u, 'NaN')");
  test.isException(function () {new Big('12.345').round(u, [])}, ".round(u, [])");
  test.isException(function () {new Big('12.345').round(u, {})}, ".round(u, {})");
  test.isException(function () {new Big('12.345').round(u, '')}, ".round(u, '')");
  test.isException(function () {new Big('12.345').round(u, ' ')}, ".round(u, ' ')");
  test.isException(function () {new Big('12.345').round(u, 'hello')}, ".round(u, 'hello')");
  test.isException(function () {new Big('12.345').round(u, '\t')}, ".round(u, '\t')");
  test.isException(function () {new Big('12.345').round(u, new Date)}, ".round(u, new Date)");
  test.isException(function () {new Big('12.345').round(u, function () {})}, ".round(u, function () {})");
  test.isException(function () {new Big('12.345').round(u, new RegExp)}, ".round(u, new RegExp)");
  test.isException(function () {new Big('12.345').round(u, 0.1)}, ".round(u, 0.1)");
  test.isException(function () {new Big('12.345').round(u, 7.5)}, ".round(u, 7.5)");
  test.isException(function () {new Big('12.345').round(u, '0')}, ".round(u, '0')");
  test.isException(function () {new Big('12.345').round(u, '1')}, ".round(u, '1')");
  test.isException(function () {new Big('12.345').round(u, '1.2')}, ".round(u, '1.2')");
  test.isException(function () {new Big('12.345').round(u, '99')}, ".round(u, '99')");
  test.isException(function () {new Big('12.345').round(u, '1.1e1')}, ".round(u, '1.1e1')");
  test.isException(function () {new Big('12.345').round(u, '-1')}, ".round('u, -1')");
  test.isException(function () {new Big('12.345').round(u, 8.01)}, ".round(u, 8.01)");
  test.isException(function () {new Big('12.345').round(u, 9)}, ".round(u, 9)");
  test.isException(function () {new Big('12.345').round(u, -1)}, ".round(u, -1)");
  test.isException(function () {new Big('12.345').round(u, '-0.01')}, ".round(u, '-0.01')");
  test.isException(function () {new Big('12.345').round(u, '-1e-1')}, ".round(u, '-1e-1')");
  test.isException(function () {new Big('12.345').round(u, Infinity)}, ".round(u, Infinity)");
  test.isException(function () {new Big('12.345').round(u, '-Infinity')}, ".round(u, '-Infinity')");
  test.isException(function () {new Big('12.345').round(u, new Big('2'))}, ".round(u, new Big('2'))");

  // Tests for RM 3, ROUND_UP, i.e. round away from zero.
  Big.RM = 3;

  t(0, 0);
  t(0, -0);
  t(1, 0.1);
  t(-1, -0.1);
  t(1, 0.4);
  t(-1, -0.4);
  t(1, 0.5);
  t(-1, -0.5);
  t(1, 0.6);
  t(-1, -0.6);
  t(1, 0.9999999);
  t(-1, -0.9999999);
  t(1, 1);
  t(2, 1.1);
  t(2, 1.49999);
  t(-1, -0.5000000000000001);
  t(-1, -1);
  t(-2, -1.1);
  t(-2, -1.49999);
  t(-2, -1.5);
  t(-10, -10);
  t(2, 1.5);
  t(2, 1.6);
  t(-2, -1.6);
  t(1, 0.00000000000000001);
  t(1, '1e-100');
  t(1, 0.49999999999999994);
  t(1, 0.5);
  t(-1, -0.00000000000000001);
  t(-1, '-1e-100');
  t(-1, -0.49999999999999994);
  t(536870911, 536870910.5);
  t(536870911, 536870911);
  t(536870912, 536870911.4);
  t(536870912, 536870911.5);
  t(536870912, 536870912);
  t(536870913, 536870912.4);
  t(536870913, 536870912.5);
  t(536870913, 536870913);
  t(536870914, 536870913.4);
  t(1073741823, 1073741822.5);
  t(1073741823, 1073741823);
  t(1073741824, 1073741823.4);
  t(1073741824, 1073741823.5);
  t(1073741824, 1073741824);
  t(1073741825, 1073741824.4);
  t(1073741825, 1073741824.5);
  t(2147483647, 2147483646.5);
  t(2147483647, 2147483647);
  t(2147483648, 2147483647.4);
  t(2147483648, 2147483647.5);
  t(2147483648, 2147483648);
  t(2147483649, 2147483648.4);
  t(2147483649, 2147483648.5);

  t(2, 1.23);
  t(2, 1.23, u, u);
  t(-2, -1.23, u, u);
  t('5', 4.5, u, u);
  t('-5', -4.5, u, u);
  t(569, '568.9', u, u);
  t(-569, -'568.9', u, u);
  t('12.35', '12.345', 2);
  t('13', '12.345', u);
  t('12', '12.345', u, 2);

  // Negative dp tests.

  t('0', '0', -1, 0);
  t('0', '0', -2, 0);
  t('0', '0', -3, 0);

  t('0', '0', -1, 1);
  t('0', '0', -2, 1);
  t('0', '0', -3, 1);

  t('0', '0', -1, 2);
  t('0', '0', -2, 2);
  t('0', '0', -3, 2);

  t('0', '0', -1, 3);
  t('0', '0', -2, 3);
  t('0', '0', -3, 3);

  t('10', '10', -1, 3);
  t('100', '10', -2, 3);
  t('1000', '10', -3, 3);

  t('1', '1', 0, 0);
  t('1', '1', 0, 1);
  t('1', '1', 0, 2);
  t('1', '1', 0, 3);

  t('0', '1', -1, 0);
  t('0', '1', -1, 1);
  t('0', '1', -1, 2);
  t('10', '1', -1, 3);

  t('0', '-1', -1, 0);
  t('0', '-1', -1, 1);
  t('0', '-1', -1, 2);
  t('-10', '-1', -1, 3);

  t('0', '1', -2, 0);
  t('0', '1', -2, 1);
  t('0', '1', -2, 2);
  t('100', '1', -2, 3);
  t('1000', '1', -3, 3);
  t('10000', '1', -4, 3);
  t('100000', '1', -5, 3);

  t('0', '-1', -2, 0);
  t('0', '-1', -2, 1);
  t('0', '-1', -2, 2);
  t('-100', '-1', -2, 3);
  t('-1000', '-1', -3, 3);
  t('-10000', '-1', -4, 3);
  t('-100000', '-1', -5, 3);

  t('0', '5', -1, 0);
  t('10', '5', -1, 1);
  t('0', '5', -1, 2);
  t('10', '5', -1, 3);

  t('0', '-5', -1, 0);
  t('-10', '-5', -1, 1);
  t('0', '-5', -1, 2);
  t('-10', '-5', -1, 3);

  t('0', '5', -2, 0);
  t('0', '5', -2, 1);
  t('0', '5', -2, 2);
  t('100', '5', -2, 3);

  t('0', '-5', -2, 0);
  t('0', '-5', -2, 1);
  t('0', '-5', -2, 2);
  t('-100', '-5', -2, 3);

  t('10', '14', -1, 0);
  t('10', '14', -1, 1);
  t('10', '14', -1, 2);
  t('20', '14', -1, 3);

  t('-10', '-14', -1, 0);
  t('-10', '-14', -1, 1);
  t('-10', '-14', -1, 2);
  t('-20', '-14', -1, 3);

  t('0', '14', -2, 0);
  t('0', '14', -2, 1);
  t('0', '14', -2, 2);
  t('100', '14', -2, 3);

  t('0', '-14', -2, 0);
  t('0', '-14', -2, 1);
  t('0', '-14', -2, 2);
  t('-100', '-14', -2, 3);

  t('10', '15', -1, 0);
  t('20', '15', -1, 1);
  t('20', '15', -1, 2);
  t('20', '15', -1, 3);

  t('-10', '-15', -1, 0);
  t('-20', '-15', -1, 1);
  t('-20', '-15', -1, 2);
  t('-20', '-15', -1, 3);

  t('0', '15', -2, 0);
  t('0', '15', -2, 1);
  t('0', '15', -2, 2);
  t('100', '15', -2, 3);

  t('0', '-15', -2, 0);
  t('0', '-15', -2, 1);
  t('0', '-15', -2, 2);
  t('-100', '-15', -2, 3);

  t('10', '16', -1, 0);
  t('20', '16', -1, 1);
  t('20', '16', -1, 2);
  t('20', '16', -1, 3);

  t('-10', '-16', -1, 0);
  t('-20', '-16', -1, 1);
  t('-20', '-16', -1, 2);
  t('-20', '-16', -1, 3);

  t('0', '16', -2, 0);
  t('0', '16', -2, 1);
  t('0', '16', -2, 2);
  t('100', '16', -2, 3);

  t('0', '-16', -2, 0);
  t('0', '-16', -2, 1);
  t('0', '-16', -2, 2);
  t('-100', '-16', -2, 3);

  t('10', '12.345', -1, 0);
  t('10', '12.345', -1, 1);
  t('10', '12.345', -1, 2);
  t('20', '12.345', -1, 3);

  t('-10', '-12.345', -1, 0);
  t('-10', '-12.345', -1, 1);
  t('-10', '-12.345', -1, 2);
  t('-20', '-12.345', -1, 3);

  t('0', '12.345', -2, 0);
  t('0', '12.345', -2, 1);
  t('0', '12.345', -2, 2);
  t('100', '12.345', -2, 3);
  t('1000', '12.345', -3, 3);
  t('10000', '12.345', -4, 3);
  t('100000', '12.345', -5, 3);

  t('0', '-12.345', -2, 0);
  t('0', '-12.345', -2, 1);
  t('0', '-12.345', -2, 2);
  t('-100', '-12.345', -2, 3);
  t('-1000', '-12.345', -3, 3);
  t('-10000', '-12.345', -4, 3);
  t('-100000', '-12.345', -5, 3);

  // Big.RM
  // 0  Round towards zero (i.e. truncate, no rounding).
  // 1  Round to nearest neighbour. If equidistant, round up.
  // 2  Round to nearest neighbour. If equidistant, to even.
  // 3  Round away from zero.

  t('98765000', '98765000', -2, 0);

  t('98765000', '98765000', -2, 1);
  t('98765000', '98765000', -2, 2);
  t('98765000', '98765000', -2, 3);
  t('98765100', '98765000.000001', -2, 3);

  t('98765000', '98765000', -3, 0);
  t('98765000', '98765000', -3, 1);
  t('98765000', '98765000', -3, 2);
  t('98765000', '98765000', -3, 3);

  t('98765000', '98765000.000001', -3, 0);
  t('98765000', '98765000.000001', -3, 1);
  t('98765000', '98765000.000001', -3, 2);
  t('98766000', '98765000.000001', -3, 3);

  t('98760000', '98765000', -4, 0);
  t('98770000', '98765000', -4, 1);
  t('98760000', '98765000', -4, 2);
  t('98770000', '98765000', -4, 3);

  t('98760000', '98765000.000001', -4, 0);
  t('98770000', '98765000.000001', -4, 1);
  t('98770000', '98765000.000001', -4, 2);
  t('98770000', '98765000.000001', -4, 3);

  t('98700000', '98765000', -5, 0);
  t('98800000', '98765000', -5, 3);
  t('98000000', '98765000', -6, 0);
  t('99000000', '98765000', -6, 3);

  t('90000000', '98765000', -7, 0);
  t('100000000', '98765000', -7, 1);
  t('100000000', '98765000', -7, 2);
  t('100000000', '98765000', -7, 3);

  t('0', '98765000', -8, 0);
  t('100000000', '98765000', -8, 1);
  t('100000000', '98765000', -8, 2);
  t('100000000', '98765000', -8, 3);

  t('0', '98765000', -9, 0);
  t('0', '98765000', -9, 1);
  t('0', '98765000', -9, 2);
  t('1000000000', '98765000', -9, 3);

  t('0', '98765000', -10, 0);
  t('0', '98765000', -10, 1);
  t('0', '98765000', -10, 2);
  t('10000000000', '98765000', -10, 3);
  
  // #191
  test.isTrue(new Big('9.9').round().c['-1'] === u);
});
