/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.javacard.templates;

import java.awt.event.ActionListener;
import org.netbeans.modules.javacard.constants.FileWizardConstants;
import org.openide.util.NbBundle;

import javax.swing.*;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class ServletDeploymentVisualPanel extends JPanel
        implements DocumentListener, ActionListener {
    
    private ServletDeploymentWizardPanel wizardPanel;
    
    ServletDeploymentVisualPanel(ServletDeploymentWizardPanel wizardPanel) {
        initComponents();
        this.wizardPanel = wizardPanel;
        servletNameTextField.getDocument().addDocumentListener(this);
        urlPatternTextField.getDocument().addDocumentListener(this);
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ServletDeploymentVisualPanel.class,
                "LBL_wizard_deployment");
    }

    /**
     * Fill the text field with defalt value. Do not modify users input.
     * 
     * @param className
     */
    void setClassName(String className) {
        String oldClassName = classNameTextField.getText();
        // This is about to update previously set value
        boolean update = oldClassName != null && !oldClassName.equals("");
        
        classNameTextField.setText(className);
        if (update){
            String oldText = servletNameTextField.getText();
            if (oldText.startsWith(oldClassName)) {
                servletNameTextField.setText(
                        className + oldText.substring(oldClassName.length()));
            }
            oldText = urlPatternTextField.getText();
            if (oldText.startsWith("/" + oldClassName)) {
                urlPatternTextField.setText("/" + className
                        + oldText.substring(oldClassName.length() + 1));
            }
        } else {
            servletNameTextField.setText(className);
            urlPatternTextField.setText("/" + className);
        }
    }
    
    String getServletName() {
        return servletNameTextField.getText();
    }
    
    String getUrlPattern() {
        return urlPatternTextField.getText();
    }
    
    boolean isAddInfoSelected() {
        return addInfoCheckBox.isSelected();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        addInfoCheckBox = new javax.swing.JCheckBox();
        jLabel2 = new javax.swing.JLabel();
        classNameTextField = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        servletNameTextField = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        urlPatternTextField = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();

        addInfoCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(addInfoCheckBox, org.openide.util.NbBundle.getMessage(ServletDeploymentVisualPanel.class, "LBL_add_to_web_descr")); // NOI18N
        addInfoCheckBox.addActionListener(this);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(ServletDeploymentVisualPanel.class, "LBL_class_name")); // NOI18N

        classNameTextField.setEditable(false);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(ServletDeploymentVisualPanel.class, "LBL_servlet_name")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, org.openide.util.NbBundle.getMessage(ServletDeploymentVisualPanel.class, "LBL_url_pattern")); // NOI18N

        urlPatternTextField.addActionListener(this);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, "<html>Register the Servlet with the application by giving the URL Pattern(s)</html>");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jLabel1, javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(addInfoCheckBox, javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addGap(21, 21, 21)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel4)
                            .addComponent(jLabel3)
                            .addComponent(jLabel2))
                        .addGap(10, 10, 10)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(classNameTextField, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 321, Short.MAX_VALUE)
                            .addComponent(servletNameTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 317, Short.MAX_VALUE)
                            .addComponent(urlPatternTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 321, Short.MAX_VALUE))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(addInfoCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(classNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(servletNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(urlPatternTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(103, Short.MAX_VALUE))
        );
    }

    // Code for dispatching events from components to event handlers.

    public void actionPerformed(java.awt.event.ActionEvent evt) {
        if (evt.getSource() == addInfoCheckBox) {
            ServletDeploymentVisualPanel.this.addInfoCheckBoxActionPerformed(evt);
        }
        else if (evt.getSource() == urlPatternTextField) {
            ServletDeploymentVisualPanel.this.urlPatternTextFieldActionPerformed(evt);
        }
    }// </editor-fold>//GEN-END:initComponents

    private void urlPatternTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_urlPatternTextFieldActionPerformed

}//GEN-LAST:event_urlPatternTextFieldActionPerformed

    private void addInfoCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addInfoCheckBoxActionPerformed
        servletNameTextField.setEditable(addInfoCheckBox.isSelected());
        urlPatternTextField.setEditable(addInfoCheckBox.isSelected());
    }//GEN-LAST:event_addInfoCheckBoxActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox addInfoCheckBox;
    private javax.swing.JTextField classNameTextField;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JTextField servletNameTextField;
    private javax.swing.JTextField urlPatternTextField;
    // End of variables declaration//GEN-END:variables

    public void insertUpdate(DocumentEvent e) {
        textsUpdated(e);
    }

    public void removeUpdate(DocumentEvent e) {
        textsUpdated(e);
    }

    public void changedUpdate(DocumentEvent e) {
        textsUpdated(e);
    }
    
    private void textsUpdated(DocumentEvent e) {
        wizardPanel.fireChangeEvent();
        if (servletNameTextField.getDocument() == e.getDocument()) {
            firePropertyChange(FileWizardConstants.PROP_SERVLET_NAME, null, getServletName());
        }
        if (urlPatternTextField.getDocument() == e.getDocument()) {
            firePropertyChange(FileWizardConstants.PROP_URL_PATTERN, null, getUrlPattern());
        }
    }
}

