/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ExportAsFilePanel.java
 *
 * Created on Mar 9, 2009, 3:55:34 PM
 */

package org.netbeans.modules.mercurial.ui.diff;

import java.awt.event.ActionListener;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.versioning.util.ExportDiffSupport.AbstractExportDiffPanel;

/**
 *
 * @author Ondra Vrabec
 */
public class ExportAsFilePanel extends AbstractExportDiffPanel {

    /** Creates new form ExportAsFilePanel */
    public ExportAsFilePanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        fileLabel = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(browseButton, org.openide.util.NbBundle.getMessage(ExportAsFilePanel.class, "ExportAsFilePanel.browseButton.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(fileLabel, org.openide.util.NbBundle.getMessage(ExportAsFilePanel.class, "ExportAsFilePanel.fileLabel.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(fileLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(outputFileTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 178, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(browseButton))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(browseButton)
                .addComponent(fileLabel)
                .addComponent(outputFileTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private final javax.swing.JButton browseButton = new javax.swing.JButton();
    javax.swing.JLabel fileLabel;
    private final javax.swing.JTextField outputFileTextField = new javax.swing.JTextField();
    // End of variables declaration//GEN-END:variables

    @Override
    public String getOutputFileText() {
        return outputFileTextField.getText();
    }

    @Override
    public void setOutputFileText(String text) {
        outputFileTextField.setText(text);
    }

    @Override
    public void addOutputFileTextDocumentListener(DocumentListener list) {
        outputFileTextField.getDocument().addDocumentListener(list);
    }

    @Override
    public void addBrowseActionListener(ActionListener actionListener) {
        browseButton.addActionListener(actionListener);
    }

}
