/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQPlotView_H
#define MvQPlotView_H

#include <QGraphicsView>

class QLabel;
class QLineEdit;
class QPlainTextEdit;
class QTimer;
class QUndoStack;

class MvKeyProfile;

class MvQAreaSelection;
class MvQCursorData;
class MvQDrop;
class MvQLineSelection;
class MvQMagnifier;
class MvQZoom;
class MvQPlaceMark;
class MvQPointSelection;
class MvQFeatureItem;
class MvQFeatureSelector;
class MvQFeatureCommandTarget;
class MvQFeatureRibbonEditor;
class MvQFeatureHandler;

class MgQPlotScene;
class MgQLayoutItem;
class MgQSceneItem;

#include "Layer.h"

// TODO: move it into a separate header
//#define MVQ_FEATURE_DEV_MODE_

class MvQPlotView : public QGraphicsView
{
    Q_OBJECT

    friend class MvQUndoCommand;
    friend class MvQFeatureAddCommand;
    friend class MvQFeatureHandler;

public:
    MvQPlotView(QGraphicsScene*, QWidget* parent = 0);
    ~MvQPlotView();
    void resetBegin();
    void resetEnd();
    void setMvPlotSize(double, double);
    void setDataProbe(MvQPlaceMark*);

    MvQFeatureHandler* featureHandler() const {return featureHandler_;}
    void itemSelected(MvQFeatureItem*);
    //void removeFeatures(QList<MvQFeatureItem*> item);
    bool hasFeatureTypeToAdd() const {return !featureTypeToAdd_.isEmpty();}
    bool hasFeatures() const;
    MvQFeatureSelector* selector();
    QAction* handleContextMenu(QList<QAction*> topLevelActions, const QPoint& globalPos, const QPointF& scenePos);
    void setUndoStack(QUndoStack*);
    void setFeatureInfoWidget(QPlainTextEdit*);

public slots:
    void slotSetEnableZoom(bool);
    void slotSetEnableMagnifier(bool);
    void slotMagnifierChanged();
    void slotSetEnableCursorData(bool);
    void slotSetEnableAreaSelection(bool);
    void slotSetEnableLineSelection(bool);
    void slotSetEnablePointSelection(bool);
    void slotChangeArea(double, double, double, double);
    void slotClearArea();
    void slotSelectAllArea();
    void slotChangeLine(double, double, double, double);
    void slotClearLine();
    void slotChangeLineDirection();
    void slotChangePoint(double, double);
    void slotClearPoint();
    void slotSelectScene();
    void enterFeatureAddMode(QString);
    void slotCommandShortcut();

protected slots:
    void delayedRemoveFeatures();
    void delayedFeatureSelection();

signals:
    void zoomRectangleIsDefined(const string&, const string&);
    void areaIsDefined(double, double, double, double);
    void areaIsUndefined();
    void lineIsDefined(double, double, double, double);
    void lineIsUndefined();
    void pointIsDefined(double, double);
    void pointIsUndefined();
    void magnifierIsEnabledProgramatically(bool);
    void zoomIsEnabledProgramatically(bool);
    void inputSIsEnabledProgramatically(bool);
    void sceneSelected(QPointF);
    void contextMenuEventHappened(const QPoint&, const QPointF&);
    void resizeEventHappened(const QSize&);
    void zoomActionStarted(MgQSceneItem*);
    void cursorDataChanged(QPointF, QList<ValuesCollector>);
    void iconDropped(const MvQDrop&, QPoint);
    void addRibbonEditor(QWidget*);

protected:
    void mouseDoubleClickEvent(QMouseEvent* event);
    void mouseMoveEvent(QMouseEvent* event);
    void mousePressEvent(QMouseEvent* event);
    void mouseReleaseEvent(QMouseEvent* event);
    void contextMenuEvent(QContextMenuEvent*);
    void resizeEvent(QResizeEvent*);
    void dragEnterEvent(QDragEnterEvent*);
    void dragMoveEvent(QDragMoveEvent*);
    void dropEvent(QDropEvent*);
    void keyPressEvent(QKeyEvent* event);

    void removeFeatureTextEditor();
    void leaveFeatureAddMode();
    QTimer* delayedFeatureSelectionTimer();

    MgQPlotScene* plotScene_;

    //Zoom
    MvQZoom* zoom_;
    MvQMagnifier* magnifier_;
    MvQCursorData* cursorData_;
    MvQAreaSelection* area_;
    MvQLineSelection* line_;
    MvQPointSelection* point_;
    bool sceneIsBeingSelected_;
    MvQPlaceMark* dataProbe_;

    //features
    QList<MvQFeatureItem*> delayedRemoveFeatures_;
    QString featureTypeToAdd_;
    QTimer* delayedFeatureSelectionTimer_{nullptr};
    MvQFeatureRibbonEditor* featureRibbonEditor_{nullptr};
    MvQFeatureHandler* featureHandler_{nullptr};
};

#endif
