# MetPy Tutorials

Welcome to the MetPy tutorials! These tutorials are designed to help you get started with using MetPy for meteorological data analysis and visualization. Whether you're a beginner looking to explore the basics or an experienced user seeking advanced techniques, these tutorials will guide you through various aspects of MetPy.

## Purpose

The purpose of these tutorials is to provide hands-on examples and explanations to help you learn how to use MetPy effectively for your meteorological data analysis tasks. Each tutorial focuses on a specific aspect of MetPy, gradually building your understanding and skills as you progress through them.

## Getting Started

If this is your first time using MetPy head over to the [installation guide](https://unidata.github.io/MetPy/latest/userguide/installguide.html) to make sure the required dependencies have been installed.

## Tutorials by Difficulty Level

### Beginner Level

1. **Area Tutorial**: Learn how to use predefined areas with MetPy.

2. **Declarative Tutorial**: MetPy's declarative syntax simplifies data exploration and analysis by streamlining plotting in Python, hiding complexity to make data investigation more accessible.
 
3.  **Unit Tutorial**: Learn how to work with units within Metpy!

### Intermediate Level

1. **Upper Air Soundings**: Upper air analysis is a staple of many synoptic and mesoscale analysis problems. In this tutorial we will gather weather balloon data, plot it, perform a series of thermodynamic calculations, and summarize the results.

2. **xarray with MetPy Tutorial**: This tutorial demonstrates how to work with xarray, a powerful Python package for labeled arrays and datasets. MetPy seamlessly integrates with xarray's data model, offering convenient methods and properties for coordinate, coordinate reference system, and unit operations. 
### Advanced Level

1. **Advanced Tutorials Coming Soon**

The [Examples Gallery](https://unidata.github.io/MetPy/latest/examples/index.html) has more examples of what else you can create with MetPy!

## Contribution

We welcome contributions to these tutorials! If you have any suggestions for improvements or would like to add new tutorials feel free to submit an issue or make a pull request. More information on how to contribute can be found by checking out the [Contributors Guide](https://github.com/Unidata/MetPy/blob/main/CONTRIBUTING.md)
