/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.serial.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;

import org.apache.log4j.Logger;

/**
 * 
 * This code was extracted from MarshalledInvocation. It converts any string to a unique HashCode
 * @author Clebert Suconic
 *
 */
public class HashStringUtil {
	private static final Logger log = Logger.getLogger(HashStringUtil.class);
   	private static final boolean isDebug = log.isDebugEnabled();
	
	public static long hashName(String name)
	{
		try
		{
			long hash=0;
	        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
	        MessageDigest messagedigest = MessageDigest.getInstance("SHA");
	        DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
	        dataoutputstream.writeUTF(name);
	        dataoutputstream.flush();
	        byte abyte0[] = messagedigest.digest();
	        for (int j = 0; j < Math.min(8, abyte0.length); j++)
	           hash += (long) (abyte0[j] & 0xff) << j * 8;
	        
	        if (isDebug)
	        {
	        	log.debug("hash on field " + name + " = " + hash);
	        }
	        return hash;
		}
		catch (Exception e)
		{
			RuntimeException rte = new RuntimeException(e);
			throw rte;
		}
		
	}

}
