/*  Lunzip - Decompressor for the lzip format
    Copyright (C) 2010-2018 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef INT64_MAX
#define INT64_MAX  0x7FFFFFFFFFFFFFFFLL
#endif


struct Block
  {
  long long pos, size;			/* pos + size <= INT64_MAX */
  };

static inline void init_block( struct Block * const b,
                               const long long p, const long long s )
  { b->pos = p; b->size = s; }

static inline long long block_end( const struct Block b )
  { return b.pos + b.size; }


struct Member
  {
  struct Block dblock, mblock;		/* data block, member block */
  unsigned dictionary_size;
  };

static inline void init_member( struct Member * const m,
                                const long long dp, const long long ds,
                                const long long mp, const long long ms,
                                const unsigned dict_size )
  { init_block( &m->dblock, dp, ds ); init_block( &m->mblock, mp, ms );
    m->dictionary_size = dict_size; }

struct File_index
  {
  struct Member * member_vector;
  char * error;
  long long isize;
  long members;
  int error_size;
  int retval;
  };

bool Fi_init( struct File_index * const fi, const int infd,
              const bool ignore_trailing, const bool loose_trailing );

void Fi_free( struct File_index * const fi );

static inline long long Fi_udata_size( const struct File_index * const fi )
  {
  if( fi->members <= 0 ) return 0;
  return block_end( fi->member_vector[fi->members-1].dblock );
  }

static inline long long Fi_cdata_size( const struct File_index * const fi )
  {
  if( fi->members <= 0 ) return 0;
  return block_end( fi->member_vector[fi->members-1].mblock );
  }

  /* total size including trailing data (if any) */
static inline long long Fi_file_size( const struct File_index * const fi )
  { if( fi->isize >= 0 ) return fi->isize; else return 0; }

static inline const struct Block * Fi_dblock( const struct File_index * const fi,
                                              const long i )
  { return &fi->member_vector[i].dblock; }

static inline const struct Block * Fi_mblock( const struct File_index * const fi,
                                              const long i )
  { return &fi->member_vector[i].mblock; }

static inline unsigned Fi_dictionary_size( const struct File_index * const fi,
                                           const long i )
  { return fi->member_vector[i].dictionary_size; }
