package tests::URLCategoriserTest;

use strict;

use base qw/Lire::Test::DlfAnalyserTestCase/;

use Lire::DlfAnalysers::URLCategoriser;
use File::Basename;

sub schemasdir {
    return dirname( __FILE__ ) . "/../..";
}

sub create_analyser {
    return new Lire::DlfAnalysers::URLCategoriser();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../../www-url_init";
}

sub test_categorise {
    my $self = $_[0];

    my $analyser = $self->create_analyser();

    my $dlf = { 'requested_page' => undef };
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'requested_file'} );
    $self->assert_null( $dlf->{'requested_page_ext'} );
    $self->assert_null( $dlf->{'directory'} );

    $dlf->{'requested_page'} = '/directory///index.html?test=top';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( '/directory//', $dlf->{'directory'} );
    $self->assert_str_equals( 'html', $dlf->{'requested_page_ext'} );
    $self->assert_str_equals( '/directory///index.html',
                              $dlf->{'requested_file'} );

    $dlf->{'requested_page_ext'} = undef;
    $dlf->{'requested_page'} = '/index';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( '/', $dlf->{'directory'} );
    $self->assert_null( $dlf->{'requested_page_ext'} );
    $self->assert_str_equals( '/index',
                              $dlf->{'requested_file'} );

    return;
}


1;
