/**
 * Copyright (c) FOM-Nikhef 2014-
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 *  Authors:
 *  2014-
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl>
 *
 */

#ifndef LCMAPS_GRIDMAPDIR_H
#define LCMAPS_GRIDMAPDIR_H

/* include lcmaps_gridmapfile.h for the MATCH_* types */
#include "lcmaps_gridmapfile.h"


/************************************************************************
 * Gridmapdir options
 ************************************************************************/

#define OVERRIDE_INCONSISTANCY    (1<<8)  /* remove existing lease */
#define MATCH_STRICT_PREFIX_NUM   (1<<9)  /* gridmapdir entries must be pool+num */
#define ONLY_USE_EXISTING_LEASE   (1<<10) /* verify existing lease */

#define ABSOLUTE_MAPPING_MAX	    9999
#define DEFAULT_MAPPING_MAX	    1
#define UNSET_MAPPING_MAX	    (-1)
#define MAPPING_MIN		    1


/************************************************************************
 * Function prototypes
 ************************************************************************/

/* Using a grid-mapfile (globusidfile) and grid-mapdir it looks for a DN or FQAN
 * (globusidp) in the grid-mapfile for a pool, i.e. a mapping starting with a .
 * (a period). When a pool is found it uses the grid-mapdir to find a valid
 * existing lease or tries to create a new lease. When a requested mapping is
 * specified the resulting mapping (pool-entry) has to match it.
 * The encoded gridmapdir entry is based on leasename (when set), or otherwise
 * globusidp. When a valid mapcounter is set (MAPPING_MIN <= mapcounter
 * <=mapping_max) it will be added to the leasename to create the encoded
 * entry in the gridmapdir. The mapping_max value should be >= MAPPING_MIN or
 * UNSET_MAPPING_MAX. When a valid lease is obtained, the resulting pool-entry
 * is returned in pool-entry, the encoded hardlink in encodedglobusidp, both
 * should be freed.
 * return 1 on successful mapping, 0 on no match or mapping, -1 on error */
int lcmaps_gridmapdir(const char *globusidfile, const char *globusidp,
		      const char *gridmapdir, int mapping_max, int mapcounter,
		      const char *leasename, const char *req_mapping,
		      int options, char **poolentry, char **encodedglobusidp);

#endif /* LCMAPS_GRIDMAPDIR_H */
