.\"
.\" $Id: rfio_lseek.man,v 1.1 2005/03/31 13:13:03 baud Exp $
.\"
.\" @(#)$RCSfile: rfio_lseek.man,v $ $Revision: 1.1 $ $Date: 2005/03/31 13:13:03 $ CERN IT-PDP/DM Jean-Philippe Baud
.\" Copyright (C) 1999-2003 by CERN/IT/PDP/DM
.\" All rights reserved
.\"
.TH RFIO_LSEEK 3 "$Date: 2005/03/31 13:13:03 $" CASTOR "Rfio Library Functions"
.SH NAME
rfio_lseek \- positions/repositions a file
.SH SYNOPSIS
.B #include <sys/types.h>
.br
\fB#include "rfio_api.h"\fR
.sp
.BI "off_t rfio_lseek (int " s ", off_t " offset ", int " how ");"
.br
.sp 
Under Linux, for large files:
.br
.B #define _LARGEFILE64_SOURCE
.br
.B #include <sys/types.h>
.br
\fB#include "rfio_api.h"\fR
.br
.sp
.BI "off64_t rfio_lseek64 (int " s ", off64_t " offset ", int " how ");"
.br
.sp
For large files, under other systems:
.br
.B #include <sys/types.h>
.br
\fB#include "rfio_api.h"\fR
.sp
.BI "off64_t rfio_lseek64 (int " s ", off64_t " offset ", int " how ");"
.SH DESCRIPTION
.B rfio_lseek
positions/repositions to
.I offset
the file associated with the descriptor
.I s
generated by a previous
.BR rfio_open .
.I how
indicates how to interpret the
.I offset
value:
.RS
.TP 1.3i
.B SEEK_SET
The offset is set from beginning of file.
.TP
.B SEEK_CUR
The offset is added to current position.
.TP
.B SEEK_END
The offset is added to current file size.
.RE
.sp
.B rfio_lseek64
performs the same function on large files using off64_t rather than off_t.
.B
.SH RETURN VALUE
This routine returns -1 if the operation failed or the actual offset from the
beginning of file. In case of failure, 
.B serrno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B EBADF
.I s
is not a valid descriptor.
.TP
.B EINVAL
incorrect value for
.IR how .
.TP
.B SENOSHOST
Host unknown.
.TP
.B SENOSSERV
Service unknown.
.TP
.B SETIMEDOUT
Timed out.
.TP
.B SEBADVERSION
Version ID mismatch.
.TP
.B SEINTERNAL
Internal error.
.TP
.B SECONNDROP
Connection closed by remote end.
.TP
.B SECOMERR
Communication error.
.SH SEE ALSO
.BR rfio_open(3)
.SH AUTHOR
\fBCASTOR\fP Team <castor.support@cern.ch>
