/*
 *  Copyright (c) 2002-2003, The Joust Project
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *  - Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 *  - Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in 
 *    the documentation and/or other materials provided with the 
 *    distribution. 
 *  - Neither the name of the Joust Project nor the names of its
 *    contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN 
 *  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 *  POSSIBILITY OF SUCH DAMAGE.
 *
 *  File created by keith @ Feb 18, 2003
 *
 */

package net.kano.joscar.snaccmd.auth;

import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;

/**
 * A base class for SNAC commands in the "auth" <code>0x17</code> SNAC family.
 */
public abstract class AuthCommand extends SnacCommand {
    /** This family's SNAC family code. */
    public static final int FAMILY_AUTH   = 0x0017;

    /** A SNAC family information object for this family. */
    public static final SnacFamilyInfo FAMILY_INFO
            = new SnacFamilyInfo(FAMILY_AUTH, 0x0001, 0x0110, 0x0801);

    /** The command subtype for requesting an authorization key. */
    public static final int CMD_KEY_REQ   = 0x0006;
    /** The command subtype for requesting authorization (login). */
    public static final int CMD_AUTH_REQ  = 0x0002;

    /** The command subtype for a response to a key request. */
    public static final int CMD_KEY_RESP  = 0x0007;
    /** The command subtype for an authorization attempt response. */
    public static final int CMD_AUTH_RESP = 0x0003;

    public static final int CMD_SECURID_REQ = 0x000a;
    public static final int CMD_SECURID_RESPONSE = 0x000b;

    /**
     * Creates a new SNAC command in this family with the given command subtype.
     *
     * @param command the command subtype of this command
     */
    protected AuthCommand(int command) {
        super(FAMILY_AUTH, command);
    }
}
