-- ------------------------------------------------------------------------- --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/objects/person.ads,v $
--  Description     : Handle the Person related information                  --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 30-Dec-2006                                            --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2007/01/21 08:48:34 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2006-2007 Michael Erdmann                                  --
--                                                                           --
--  GNADE is copyrighted by the persons and institutions enumerated in the   --
--  AUTHORS file. This file is located in the root directory of the          --
--  GNADE distribution.                                                      --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNADE; see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from      --
--  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
--  files  to produce an executable, these  units or libraries do not by     --
--  itself cause the resulting  executable  to  be covered  by the  GNU      --
--  General  Public  License.  This exception does not however invalidate    --
--  any other reasons why  the executable file  might be covered by the      --
--  GNU Public License.                                                      --
--                                                                           --
-- ------------------------------------------------------------------------- --
with Ada.Strings.Unbounded;		use Ada.Strings.Unbounded;
with Persistent;			use Persistent;
with Key_Type;				use Key_Type;

package Person is

   Not_Existing : exception;

   type Object is new Persistent.Object with record
         Firstname  : Unbounded_String := Null_Unbounded_String;
         Lastname   : Unbounded_String := Null_unbounded_String ;
      end record;

   procedure Create(
      This      : in out Object;
      Firstname : in Unbounded_String ;
      Lastname  : in Unbounded_String );

   procedure Query(
      This      : in out Object;
      Firstname : in Unbounded_String ;
      Lastname  : in Unbounded_String );

   function Lookup(
      Firstname : in Unbounded_String ;
      Lastname  : in Unbounded_String ) return Person.Object;

   procedure Display(
      This   : in out Object );

   type Key_Object is new Key_Type.Object with record
         Name : Unbounded_String;
      end record;


   function Make_Key(
        This : in Object'Class ) return Key_Object;


end Person;
