/*
 * Decompiled with CFR 0.152.
 */
package visad.data.fits;

import java.lang.reflect.Array;

public abstract class GenericArrayConverter {
    Object o;
    int[] lengths;

    public GenericArrayConverter(Class type, int[] lengths) {
        this.o = Array.newInstance(type, lengths);
        this.lengths = lengths;
    }

    abstract void assign(Object var1, int var2, double var3);

    private Object getBottomArray(Object o, int[] which) {
        int d = which.length - 1;
        int i = 0;
        while (i < d) {
            o = Array.get(o, which[i++]);
        }
        return o;
    }

    private Object getNextRMBottomArray(Object o, int[] coord) {
        int l = coord.length - 1;
        while (coord[l] >= this.lengths[l]) {
            coord[l] = 0;
            if (--l < 0) {
                return null;
            }
            int n = l;
            coord[n] = coord[n] + 1;
        }
        return this.getBottomArray(o, coord);
    }

    private Object getNextCMBottomArray(Object o, int[] coord) {
        int l = 0;
        while (coord[l] >= this.lengths[this.lengths.length - (l + 1)]) {
            coord[l] = 0;
            if (++l >= coord.length) {
                return null;
            }
            int n = l;
            coord[n] = coord[n] + 1;
        }
        return this.getBottomArray(o, coord);
    }

    public Object getRowMajor(double[][] values) {
        int[] coord = new int[this.lengths.length];
        for (int i = 0; i < this.lengths.length; ++i) {
            coord[i] = 0;
        }
        int lastCoord = this.lengths.length - 1;
        Object ra = this.getBottomArray(this.o, coord);
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                int n = lastCoord;
                int n2 = coord[n] + 1;
                coord[n] = n2;
                this.assign(ra, this.lengths[lastCoord] - n2, values[i][j]);
                if (coord[lastCoord] < this.lengths[lastCoord] || (ra = this.getNextRMBottomArray(this.o, coord)) != null) continue;
                return this.o;
            }
        }
        return this.o;
    }

    public Object getColumnMajor(double[][] values) {
        int[] coord = new int[this.lengths.length];
        for (int i = 0; i < this.lengths.length; ++i) {
            coord[i] = 0;
        }
        int lastCoord = this.lengths.length - 1;
        for (int i = 0; i < values[0].length; ++i) {
            this.assign(this.getBottomArray(this.o, coord), coord[lastCoord], values[0][i]);
            coord[0] = coord[0] + 1;
            if (coord[0] < this.lengths[0] || this.getNextCMBottomArray(this.o, coord) != null) continue;
            return this.o;
        }
        return this.o;
    }
}

