/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include <boost/python.hpp>
#include "Python/esys/lsm/ElasticMesh2DPrmsPy.h"

namespace esys
{
  namespace lsm
  {
    NRotElasticLinMeshPrmsPy::NRotElasticLinMeshPrmsPy(
      const string &interactionName,
      const string &meshName,
      double normalK
    )
      : ETriMeshIP(interactionName, meshName, normalK)
    {
    }

    NRotElasticMesh2DPrmsPy::NRotElasticMesh2DPrmsPy(
      const string &interactionName,
      const string &meshName,
      double normalK
    )
      : ETriMeshIP(interactionName, meshName, normalK)
    {
    }

    using boost::python::arg;
    void exportElasticMesh2DPrms()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      boost::python::class_<NRotElasticLinMeshPrmsPy>(
        "NRotElasticLinMeshPrms",
        "Defines linear elastic contact interaction between particles and a"
        " piece-wise linear mesh surface.\n",
        boost::python::init<
          const std::string &,
          const std::string &,
          double
        >(
            (
              arg("name"),
              arg("meshName"),
              arg("normalK")
            ),
	    "Parameters defining elastic contact interactions between particles and 2D mesh walls\n"
            "@type name: string\n"
            "@kwarg name: Name assigned to the group of interactions.\n"
            "@type meshName: string\n"
            "@kwarg meshName: Name of the mesh for which the interactions apply.\n"
            "@type normalK: float\n"
            "@kwarg normalK: spring constant for the linear elastic contact interaction."
        )
      );

      boost::python::class_<NRotElasticMesh2DPrmsPy>(
        "NRotElasticMesh2DPrms",
        "Defines linear elastic contact interaction between particles and a"
        " 2D mesh.\n"
        "DEPRECATED: Use NRotElasticLinMeshPrms instead.",
        boost::python::init<
          const std::string &,
          const std::string &,
          double
        >(
            (
              arg("name"),
              arg("meshName"),
              arg("normalK")
            ),
	    "Parameters defining elastic contact interactions between particles and 2D mesh walls\n"
            "@type name: string\n"
            "@kwarg name: Name assigned to the group of interactions.\n"
            "@type meshName: string\n"
            "@kwarg meshName: Name of the mesh for which the interactions apply.\n"
            "@type normalK: float\n"
            "@kwarg normalK: spring constant for the linear elastic contact interaction."
        )
      );
    }
  }
}
