/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef MODEL_ABCDAMPING_H
#define MODEL_ABCDAMPING_H

// -- project includes --
#include "Model/Damping.h"
#include "Model/ABCDampingIGP.h"

/*!
  Damping for absorbing boundary conditions - damping increases exponentially
  towards a given plane (boundary)
*/
 template <class ParticleType>
 class ABCDamping : public CDamping<ParticleType>
{
 protected:
  Vec3 m_pos;
  Vec3 m_normal;
  double m_c1;

 public:
  typedef ABCDampingIGP ParameterType;


  typedef double (ABCDamping::* ScalarFieldFunction)() const;
  typedef pair<bool,double> (ABCDamping::* CheckedScalarFieldFunction)() const;
  typedef Vec3 (ABCDamping::* VectorFieldFunction)() const;

  static ScalarFieldFunction getScalarFieldFunction(const string&);
  static CheckedScalarFieldFunction getCheckedScalarFieldFunction(const string&);
  static VectorFieldFunction getVectorFieldFunction(const string&);

  ABCDamping(ParticleType*,ABCDampingIGP*);
  virtual ~ABCDamping();
};

#include "Model/ABCDamping.hpp"

#endif // MODEL_ABCDAMPING_H
