/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignmentPanel;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PaintRefresher {
    static Hashtable components;

    public static void Register(Component comp, String seqSetId) {
        if (components == null) {
            components = new Hashtable();
        }
        if (components.containsKey(seqSetId)) {
            Vector comps = (Vector)components.get(seqSetId);
            if (!comps.contains(comp)) {
                comps.addElement(comp);
            }
        } else {
            Vector<Component> vcoms = new Vector<Component>();
            vcoms.addElement(comp);
            components.put(seqSetId, vcoms);
        }
    }

    public static void RemoveComponent(Component comp) {
        if (components == null) {
            return;
        }
        Enumeration en = components.keys();
        while (en.hasMoreElements()) {
            String id = en.nextElement().toString();
            Vector comps = (Vector)components.get(id);
            comps.removeElement(comp);
            if (comps.size() != 0) continue;
            components.remove(id);
        }
    }

    public static void Refresh(Component source, String id) {
        PaintRefresher.Refresh(source, id, false, false);
    }

    public static void Refresh(Component source, String id, boolean alignmentChanged, boolean validateSequences) {
        if (components == null) {
            return;
        }
        Vector comps = (Vector)components.get(id);
        if (comps == null) {
            return;
        }
        Enumeration e = comps.elements();
        while (e.hasMoreElements()) {
            Component comp = (Component)e.nextElement();
            if (comp == source) continue;
            if (!comp.isValid()) {
                comps.removeElement(comp);
            } else if (validateSequences && comp instanceof AlignmentPanel && source instanceof AlignmentPanel) {
                PaintRefresher.validateSequences(((AlignmentPanel)source).av.alignment, ((AlignmentPanel)comp).av.alignment);
            }
            if (comp instanceof AlignmentPanel && alignmentChanged) {
                ((AlignmentPanel)comp).alignmentChanged();
            }
            comp.repaint();
        }
    }

    static void validateSequences(AlignmentI source, AlignmentI comp) {
        int j;
        int i;
        SequenceI[] a2;
        int jSize;
        SequenceI[] a1 = source.getHiddenSequences().getSize() > 0 ? source.getHiddenSequences().getFullAlignment().getSequencesArray() : source.getSequencesArray();
        int iSize = a1.length;
        if (iSize == (jSize = (a2 = comp.getHiddenSequences().getSize() > 0 ? comp.getHiddenSequences().getFullAlignment().getSequencesArray() : comp.getSequencesArray()).length)) {
            return;
        }
        boolean exists = false;
        for (i = 0; i < iSize; ++i) {
            exists = false;
            for (j = 0; j < jSize; ++j) {
                if (a2[j] != a1[i]) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            if (i < comp.getHeight()) {
                comp.getSequences().insertElementAt(a1[i], i);
            } else {
                comp.addSequence(a1[i]);
            }
            a2 = comp.getHiddenSequences().getSize() > 0 ? comp.getHiddenSequences().getFullAlignment().getSequencesArray() : comp.getSequencesArray();
            jSize = a2.length;
        }
        iSize = a1.length;
        jSize = a2.length;
        for (j = 0; j < jSize; ++j) {
            exists = false;
            for (i = 0; i < iSize; ++i) {
                if (a2[j] != a1[i]) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            comp.deleteSequence(a2[j]);
        }
    }
}

