/* This file is -*-C++-*-
------------------------------------------------------------------------------
denef - Decode NEF image files
Copyright (C) 2000 Daniel Stephens (daniel@cheeseplant.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
------------------------------------------------------------------------------

$Id: nefdata.h,v 1.4 2000/09/18 07:51:43 daniel Exp $

*/

#ifndef NEFDATA_H_INCLUDED
#define NEFDATA_H_INCLUDED

class nefImageData
{
private:
    nefImageData(const nefImageData &);
    nefImageData &operator=(const nefImageData &);

    int width;
    int height;
public:
    short *data;
    
    nefImageData(int w, int h) : width(w), height(h) {
	data = new short[w*h];
    };
    ~nefImageData() {
	delete [] data;
    }

    int Width() const {return width;}
    int Height() const {return height;}
    short *Data() {return data;}
    const short *Data() const {return data;}
    const short *Data(int x, int y) const {return &data[x+y*width];}

    const double Max_Value() const { return (double)(2<<12);}
};

extern nefImageData * Load_NEF_Data(istream &is);
extern nefImageData * Test_NEF_Data();

struct rgbTriple
{
    double r,g,b;

    double Luminance() const {
	// From C. Poynton's FAQ on Gamma (http://www.inforamp.net/~poynton/)
	// CIE Rec 709
	return (r * 0.2126) + (g * 0.7152) + (b * 0.0722);
    };
};

class fullImageData
{
private:
    fullImageData(const fullImageData &);
    fullImageData &operator=(const fullImageData &);

    int width;
    int height;
public:
    rgbTriple *data;
    
    fullImageData(int w, int h) : width(w), height(h) {
	data = new rgbTriple[w*h];
    };
    ~fullImageData() {
	delete [] data;
    }

    int Width() const {return width;}
    int Height() const {return height;}
    rgbTriple *Data() {return data;}
    rgbTriple &operator()(int x, int y) {return data[x+y*width];}
    const rgbTriple *Data() const {return data;}
    const rgbTriple *Data(int x, int y) const {return &data[x+y*width];}
};

#endif /* NEFDATA_H_INCLUDED */
