/*
 *  dancer-XML parser
 *  Copyright (C) 2000,2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/*

  XML parser header file. Defines the structs

copyright 2000 Junichi Uekawa

*/
#ifndef __DANCER_XML_H__
#define __DANCER_XML_H__

#include <stdio.h>

/** 
    Structure representing attributes within element.
*/
typedef struct dxml_attribute
{
  /** the name of the attribute  */
  char * attribute_name ;	
  /** the content of the attribute  */
  char * attribute_data ;
  /** the next item in the list */
  struct dxml_attribute * next;  
} dxml_attribute;


/**
   Structure holding #PCDATA or ELEMENT

   <element attribute=data>
   PCDATA
   </element>
*/
typedef struct dxml_element
{
  /** in case of PCDATA the text is contained here... */
  char * element_name;
  /** the type of element */
  enum element_type{
    /** element. */
    element_type_element, 
    /** Parsed character data: attribute=child=NULL  */
    element_type_pcdata 
  } element_type;
  /** The attribute that belongs to the element */
  dxml_attribute * element_attribute;
  /** The child in the element. All children will be linked as
   ->child and its ->next. */
  struct dxml_element * child;
  /** The next item in the element list */
  struct dxml_element *next;
} dxml_element;

/** Read the XML file and load it as the element structure
 *
 * @return NULL on fail.
 */
dxml_element * dxml_read_xml(FILE*f/** File pointer to the XML file*/);	

/** Obtain the next non-PCDATA, i.e. element  */
dxml_element * dxml_next_notPCDATA(dxml_element * e/** element pointer*/);

/** Get the pointer to element by name */
dxml_element * dxml_get_element_byname(dxml_element * e/** element */, const char * name /** The name of the element */);

/** Get the pointer to element by a simple path, using name/name/name notation. */
dxml_element * dxml_get_element_bysimplepath(dxml_element * e /** element */, const char*path /* path to the element */);

/** For debug, dump the element contents */
void dxml_dump_element (dxml_element * e /** content to be dumped */);

/** Obtain the PCDATA specified with a simple path, using name/name/name notation */
char * dxml_get_PCDATA_bysimplepath(dxml_element * e /** element */ , const char * path /** path to PCDATA */);

/** free the allocated xml structure */
void dxml_free_xml(dxml_element * e);

#endif


