{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCenterOfMass: TVector3;
    procedure SetCenterOfMass(const Value: TVector3);
    function GetCoord: TAbstractCoordinateNode;
    procedure SetCoord(const Value: TAbstractCoordinateNode);
    function GetMass: Single;
    procedure SetMass(const Value: Single);
    function GetNameField: string;
    procedure SetNameField(const Value: string);
  public
    property CenterOfMass: TVector3 read GetCenterOfMass write SetCenterOfMass;
    property Coord: TAbstractCoordinateNode read GetCoord write SetCoord;
    procedure SetDisplacers(const Value: array of THAnimDisplacerNode);
    property Mass: Single read GetMass write SetMass;
    procedure SetMomentsOfInertia(const Value: array of Single);
    procedure SetMomentsOfInertia(const Value: TSingleList);
    property NameField: string read GetNameField write SetNameField;

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimSegmentNode ----------------------------------------------- }

function THAnimSegmentNode.GetCenterOfMass: TVector3;
begin
  Result := FdCenterOfMass.Value;
end;

procedure THAnimSegmentNode.SetCenterOfMass(const Value: TVector3);
begin
  FdCenterOfMass.Send(Value);
end;

function THAnimSegmentNode.GetCoord: TAbstractCoordinateNode;
begin
  if FdCoord.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdCoord.Value)
  else
    Result := nil;
end;

procedure THAnimSegmentNode.SetCoord(const Value: TAbstractCoordinateNode);
begin
  FdCoord.Send(Value);
end;

procedure THAnimSegmentNode.SetDisplacers(const Value: array of THAnimDisplacerNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimDisplacerNode));
  FdDisplacers.Send(A);
end;

function THAnimSegmentNode.GetMass: Single;
begin
  Result := FdMass.Value;
end;

procedure THAnimSegmentNode.SetMass(const Value: Single);
begin
  FdMass.Send(Value);
end;

procedure THAnimSegmentNode.SetMomentsOfInertia(const Value: array of Single);
begin
  FdMomentsOfInertia.Send(Value);
end;

procedure THAnimSegmentNode.SetMomentsOfInertia(const Value: TSingleList);
begin
  FdMomentsOfInertia.Send(Value);
end;

function THAnimSegmentNode.GetNameField: string;
begin
  Result := FdName.Value;
end;

procedure THAnimSegmentNode.SetNameField(const Value: string);
begin
  FdName.Send(Value);
end;

{$endif read_implementation}
