//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_18.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot18(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[18] = {3.380206059614466e-02,3.045951920680225e-01,8.482074788245103e-01,1.668775553329836e+00,2.772724528639121e+00,
    4.169058247501773e+00,5.869795294527881e+00,7.890605917460938e+00,1.025174061640137e+01,1.297940302833536e+01,1.610783362121137e+01,1.968259409656978e+01,
    2.376601473315190e+01,2.844686341618787e+01,3.385916986557835e+01,4.022405046954309e+01,4.796392137388955e+01,5.816084450618310e+01};
  constexpr double aw[18] = {3.555400742737078e-01,2.717012470095276e-01,1.583554537511661e-01,7.010475010517786e-02,2.342576750973172e-02,
    5.856425986559556e-03,1.082534756686802e-03,1.456961596263603e-04,1.399702922032880e-05,9.355570089773111e-07,4.207491323109042e-08,1.217867820955731e-09,
    2.135354181784506e-11,2.080912674286899e-13,9.902901686906247e-16,1.861597987807984e-18,9.256403083558327e-22,4.447153417575597e-26};
  constexpr double x[6912] = {  3.602934140130130e-03, -4.860305000612312e-05,  4.908467154486721e-07, -4.396040701317578e-09,  3.679909002930177e-11,
 -2.946562350424312e-13,  2.283909299013023e-15, -1.725468981891191e-17,  1.275710762987889e-19, -9.252980111398992e-22,  6.592610497473004e-24, -4.616336705655325e-26,
  3.227877730498518e-02, -4.293456273104157e-04,  4.213915709125832e-06, -3.594752847952827e-08,  2.789705707197382e-10, -1.996301733961926e-12,  1.313172991821198e-14,
 -7.780239905725162e-17,  3.921176377792969e-19, -1.372831884196288e-21, -1.319080796293971e-24,  8.735857149059108e-26,  8.884652624300850e-02, -1.148657320977989e-03,
  1.062848478496033e-05, -8.156293841260739e-08,  5.271841744372505e-10, -2.700128099213486e-12,  7.957011009919431e-15,  3.587006840985951e-17, -8.585292016479513e-19,
  8.895701628348549e-21, -6.575475482998022e-23,  3.388509123817667e-25,  1.717547626035198e-01, -2.126568744451828e-03,  1.792180207903471e-05, -1.141310171310632e-07,
  4.829874755959185e-10, -1.497640196340919e-14, -2.397380991741255e-14,  2.712576469628129e-16, -1.757269342527213e-18,  4.420747725514172e-21,  5.597882165779978e-23,
 -9.549535403865519e-25,  2.787176242852777e-01, -3.253687106861309e-03,  2.394422530067326e-05, -1.093613281105083e-07,  1.688867270228753e-11,  5.093170949414472e-12,
 -5.035804862422048e-14,  2.063799758811264e-16,  9.977744745829071e-19, -2.366702810877243e-20,  1.829300953393428e-22, -3.277299383531903e-25,  4.067646344569912e-01,
 -4.402816127297381e-03,  2.674566263030237e-05, -5.752634661610232e-08, -7.019500758016443e-10,  8.395715832155945e-12, -2.790835463928302e-14, -2.861349841083532e-16,
  4.264668035668469e-18, -1.742364838899949e-20, -1.487633634797980e-22,  2.594991539364937e-24,  5.523075433760710e-01, -5.442748225195759e-03,  2.507790813764783e-05,
  3.066844659940963e-08, -1.276224867295067e-09,  5.975926519879980e-12,  3.914947203660748e-14, -6.360790632226929e-16,  1.470378075667807e-18,  3.576111777552694e-20,
 -3.501831357346822e-22, -3.377254127971036e-25,  7.112242961423715e-01, -6.252888280380084e-03,  1.873925741860121e-05,  1.269753979002392e-07, -1.320264605226682e-09,
 -1.797075133192840e-12,  8.868398331453045e-14, -2.523877375775526e-16, -5.188399197178935e-18,  4.134833730731477e-20,  2.137820193639474e-22, -4.219167981553315e-24,
  8.789599722126757e-01, -6.737194006003327e-03,  8.669176949915627e-06,  1.964992390024761e-07, -7.200782914049374e-10, -9.749263817785366e-12,  6.276186165469014e-14,
  5.470205739837298e-16, -5.565524971819122e-18, -3.049033288364568e-20,  4.945628830031754e-22,  1.467013895214030e-24,  1.050644077600015e+00, -6.835867991975901e-03,
 -3.243332845213722e-06,  2.122607293853121e-07,  2.620538494882958e-10, -1.181466325594375e-11, -2.321660846242737e-14,  7.964709399019901e-16,  2.150985273512574e-18,
 -5.923510959669711e-20, -2.048002853089082e-22,  4.672306765065558e-24,  1.221222881182910e+00, -6.533342963964290e-03, -1.460418752854984e-05,  1.671482688744105e-07,
  1.122986460066571e-09, -6.210024016654432e-12, -8.885222101872577e-14,  1.568134355256561e-16,  6.902671303594831e-18,  9.675460940943597e-21, -5.097929754175563e-22,
 -2.411800893743544e-24,  1.385604567637703e+00, -5.861388895898745e-03, -2.310986253269347e-05,  7.770059966484868e-08,  1.420629787426774e-09,  2.828178403271044e-12,
 -7.319175555774086e-14, -5.806013541252414e-16,  2.023628193612920e-18,  5.433147656671385e-20,  1.507443560403425e-22, -3.437755194412862e-24,  1.538813862031140e+00,
 -4.896644350249276e-03, -2.714438916455678e-05, -2.247891530081517e-08,  1.048014896161269e-09,  8.571537661038310e-12, -2.007155830357508e-16, -5.576916031427500e-16,
 -4.271348629956574e-18,  6.680033775837580e-21,  3.708965481027725e-22,  2.465376295150705e-24,  1.676151545214384e+00, -3.752511849878062e-03, -2.621567335356249e-05,
 -9.717333245128683e-08,  2.916132612611889e-10,  7.527271139770481e-12,  5.231267343690465e-14,  2.725991718757291e-17, -3.168508547320630e-18, -3.295429923195328e-20,
 -1.030453355369758e-22,  1.368572435520000e-24,  1.793353067286809e+00, -2.566097815789884e-03, -2.110159273744790e-05, -1.234495119226018e-07, -3.719867978696290e-10,
  2.075103357813201e-12,  4.216219538575964e-14,  3.433019717793255e-16,  1.267313426269610e-18, -7.557480103028794e-21, -1.720248327641942e-22, -1.503360500280313e-24,
  1.886739518526423e+00, -1.481621931914533e-03, -1.364992048729821e-05, -1.014920238911524e-07, -6.016411601235302e-10, -2.384350008818313e-12,  1.516811137960212e-15,
  1.455406793903243e-16,  1.719964706108175e-18,  1.313024767403259e-20,  6.314211694616926e-23, -6.029775215267820e-27,  1.953354223992896e+00, -6.323345333408828e-04,
 -6.273304229809666e-06, -5.344697526213247e-08, -4.070236437535199e-10, -2.779846515010577e-12, -1.659861806848135e-14, -7.948411345707670e-17, -1.999902412854991e-19,
  1.527483747515031e-21,  3.140019423788255e-23,  3.413978454675568e-25,  1.991087344411652e+00, -1.232201183884022e-04, -1.271966365944912e-06, -1.160100413566473e-08,
 -9.843621494397823e-11, -7.942875429498098e-13, -6.159929821189988e-15, -4.615074098113531e-17, -3.346505124881945e-19, -2.347117165857690e-21, -1.587206219382133e-23,
 -1.028098165299810e-25,  3.416054952237085e-03, -4.487770619504227e-05,  4.414416841174697e-07, -3.851578383173030e-09,  3.141722968439935e-11, -2.452077437786406e-13,
  1.853263211881544e-15, -1.365821205860689e-17,  9.855560180416310e-20, -6.981009281190652e-22,  4.860795496312092e-24, -3.329261199929134e-26,  3.062618869481469e-02,
 -3.972868297114959e-04,  3.808062487775165e-06, -3.178699960590091e-08,  2.420268287172327e-10, -1.705909784598530e-12,  1.112146834893234e-14, -6.604891191474495e-17,
  3.425431841534344e-19, -1.362584453522578e-21,  1.527363673541010e-24,  4.545839570813657e-26,  8.441595104673202e-02, -1.067405104948420e-03,  9.698591537145177e-06,
 -7.354934692750926e-08,  4.751577960994055e-10, -2.499933463665504e-12,  8.621442462800891e-15,  1.304203832685933e-17, -5.821208415738179e-19,  6.553845604260332e-21,
 -5.162228506926821e-23,  3.001710645295144e-25,  1.635267476980922e-01, -1.988541457555351e-03,  1.659849230645927e-05, -1.064344055224828e-07,  4.775172797510932e-10,
 -5.053989686678132e-13, -1.713929035676796e-14,  2.179278200932670e-16, -1.566966851009561e-18,  5.925597152227448e-21,  2.172737213953227e-23, -6.167282798351948e-25,
  2.660776881684184e-01, -3.067370729515356e-03,  2.263666495995629e-05, -1.083398488350576e-07,  1.071497167161574e-10,  3.956791806526703e-12, -4.425062196275073e-14,
  2.260535961218592e-16,  2.729592089266376e-19, -1.674814827182650e-20,  1.607821979918859e-22, -6.357057548437280e-25,  3.895766755107110e-01, -4.191790508688641e-03,
  2.599337575919761e-05, -6.745308013612901e-08, -5.413056120533479e-10,  7.644579695898870e-12, -3.411080746262550e-14, -1.606376633822958e-16,  3.556151242388428e-18,
 -2.127630412882736e-20, -4.869054056578896e-23,  1.936256341173213e-24,  5.309396500945075e-01, -5.240990622364175e-03,  2.532750510436435e-05,  1.125010234420315e-08,
 -1.148720917631269e-09,  6.708200797898849e-12,  2.217220155211981e-14, -5.711373814150418e-16,  2.505624015379656e-18,  2.184053267057796e-20, -3.372327577086835e-22,
  8.437586969359668e-25,  6.865217116171753e-01, -6.097240507365132e-03,  2.013539798468178e-05,  1.056765539646410e-07, -1.335585305409932e-09,  2.292024268537943e-13,
  7.952618308639046e-14, -3.933085049284501e-16, -3.589990750967811e-18,  4.627264001146831e-20,  3.587403901585032e-23, -3.751635711123294e-24,  8.521645416139574e-01,
 -6.658618751046796e-03,  1.095188422584436e-05,  1.835047795333458e-07, -8.988678855078692e-10, -8.080180446936149e-12,  7.544783923141081e-14,  3.552686864190919e-16,
 -6.297149324945737e-18, -1.003213777226048e-20,  5.133374180218160e-22, -5.860286678029391e-25,  1.023264920872818e+00, -6.851572977935750e-03, -6.789216691168361e-07,
  2.145406670281644e-07,  2.202665764734495e-11, -1.209848636155331e-11, -2.812349910434631e-16,  8.300178330240027e-16, -7.738627723831181e-20, -6.310997223862047e-20,
  1.428216235139094e-23,  5.113110627098187e-24,  1.194868963439931e+00, -6.641858077716636e-03, -1.249507036334155e-05,  1.840085297240201e-07,  9.779469350777577e-10,
 -8.264651380933741e-12, -8.134579348933160e-14,  3.791600488659309e-16,  6.863171754719644e-18, -1.230089739534899e-20, -5.745506518944332e-22, -4.308216628195458e-25,
  1.361795709874837e+00, -6.042148104148904e-03, -2.203953217581707e-05,  1.007823705756155e-07,  1.458356143570704e-09,  8.856527309725091e-13, -8.824151179717638e-14,
 -4.837085592975996e-16,  4.047702139475369e-18,  5.690889705504354e-20, -3.166144733904807e-23, -4.773981225655843e-24,  1.518791685585421e+00, -5.114580391885872e-03,
 -2.730788551838717e-05, -4.345075879248867e-09,  1.218054142302573e-09,  8.364220566927675e-12, -1.767189639522806e-14, -6.874614268301368e-16, -3.739241458701893e-18,
  2.350335556019323e-20,  4.644145004689065e-22,  1.659086911976678e-24,  1.660714789490890e+00, -3.966810352810422e-03, -2.734856932049407e-05, -9.123490207099987e-08,
  4.547115932212281e-10,  8.779355941153015e-12,  5.147321482174647e-14, -9.377260852409525e-17, -4.411608291668870e-18, -3.554569683276660e-20, -1.800008446496885e-23,
  2.536876761024494e-24,  1.782741530162643e+00, -2.740933786767562e-03, -2.261714083135888e-05, -1.290109576789677e-07, -3.195647616695904e-10,  3.206625953679214e-12,
  5.229126574094144e-14,  3.780409364610716e-16,  8.547653470999337e-19, -1.583402436695885e-20, -2.433259454827785e-22, -1.710032670909101e-24,  1.880586682893848e+00,
 -1.595860163363582e-03, -1.492714552164361e-05, -1.114962973275036e-07, -6.485999800284543e-10, -2.292371372402368e-12,  6.437008493116724e-15,  2.086255687698566e-16,
  2.237439425702672e-18,  1.558111899855881e-20,  5.739009980411612e-23, -2.833267420040809e-25,  1.950720288972063e+00, -6.852015022202784e-04, -6.955649111275754e-06,
 -6.042654256000241e-08, -4.667880001186106e-10, -3.205582923587601e-12, -1.890359098333324e-14, -8.472957398941814e-17, -1.183716544816431e-19,  3.128729397671242e-21,
  4.987234914569493e-23,  5.078255339147449e-25,  1.990573191340163e+00, -1.339807339422324e-04, -1.421179796683769e-06, -1.331156430089098e-08, -1.159116207892533e-10,
 -9.589252885436280e-13, -7.615704184469697e-15, -5.834343884130905e-17, -4.317510238928219e-19, -3.082079061972634e-21, -2.113163653479068e-23, -1.379476476495803e-25,
  3.243326066286305e-03, -4.152286063344095e-05,  3.980844481757264e-07, -3.385843191303595e-09,  2.692862908795485e-11, -2.049841565041408e-13,  1.511459889614341e-15,
 -1.087170000677769e-17,  7.659764092752900e-20, -5.300549230895297e-22,  3.607786091796704e-24, -2.417438965163169e-26,  2.909564419844947e-02, -3.682847762879899e-04,
  3.448772479009279e-06, -2.817362059400601e-08,  2.104341974255880e-10, -1.459993158829316e-12,  9.418287995713375e-15, -5.585719557889948e-17,  2.949939103733588e-19,
 -1.269850099075131e-21,  2.927115532462054e-24,  2.033985396843294e-26,  8.029609588448069e-02, -9.932212247693469e-04,  8.860001237232481e-06, -6.633548023636542e-08,
  4.272478489247359e-10, -2.290537285766182e-12,  8.758602947668715e-15, -2.184361111785519e-18, -3.802984255497666e-19,  4.738631999033560e-21, -3.950611951038755e-23,
  2.498624258441003e-25,  1.558302509129364e-01, -1.860733389384127e-03,  1.536672056831194e-05, -9.889536721044848e-08,  4.637617018186393e-10, -8.489824586300687e-13,
 -1.170633053213986e-14,  1.713175794610559e-16, -1.343803604436064e-18,  6.331789785656161e-21,  4.044718008790139e-25, -3.663450880112136e-25,  2.541622066769496e-01,
 -2.891442927691736e-03,  2.134930362284681e-05, -1.060479064118303e-07,  1.761809871949414e-10,  2.971203769249841e-12, -3.788095729454292e-14,  2.263252416091740e-16,
 -2.213384924343760e-19, -1.091615036357734e-20,  1.301490465287094e-22, -7.288888338182018e-25,  3.732200881401890e-01, -3.987217161498274e-03,  2.513687115578269e-05,
 -7.493662475660189e-08, -3.969015203798710e-10,  6.784087830868826e-12, -3.713242856135740e-14, -5.931745839442011e-17,  2.773820278901415e-18, -2.172370431051196e-20,
  2.135394185814822e-23,  1.256195506162180e-24,  5.103813552334313e-01, -5.038132670700844e-03,  2.535673574677458e-05, -6.032473475055341e-09, -1.010481337236399e-09,
  7.058127312102578e-12,  7.403008051838432e-15, -4.808933523495466e-16,  3.060221552083535e-18,  9.328014031892844e-21, -2.835031143502293e-22,  1.516190450158077e-24,
  6.624624357931248e-01, -5.931447125436190e-03,  2.127577688527431e-05,  8.444360550956157e-08, -1.312867543592568e-09,  1.994239156666345e-12,  6.715583618069789e-14,
 -4.815656421826116e-16, -1.935740691461739e-18,  4.467436895876258e-20, -1.084367521101522e-22, -2.747948128030156e-24,  8.257188825863393e-01, -6.562451567450545e-03,
  1.306264428433324e-05,  1.679314180700160e-07, -1.041676850664967e-09, -6.173026399065747e-12,  8.254774645060452e-14,  1.518613238613281e-16, -6.299834809379362e-18,
  9.453007030606907e-21,  4.487155020961768e-22, -2.256763523755813e-24,  9.958640555626311e-01, -6.846718760985913e-03,  1.889716225292024e-06,  2.129648389772988e-07,
 -2.181383908377875e-10, -1.182871436803502e-11,  2.258635688431408e-14,  7.917355521091718e-16, -2.285674139133112e-18, -5.814524282022340e-20,  2.294698851434740e-22,
  4.500332783812796e-24,  1.168115952776630e+00, -6.732733461350899e-03, -1.019887245247330e-05,  1.982313108443462e-07,  7.941167962976505e-10, -1.006530334796011e-11,
 -6.775282247899672e-14,  5.872642373704440e-16,  6.008292619481818e-18, -3.497848126561181e-20, -5.421169173648543e-22,  1.923001957300723e-24,  1.337282705218981e+00,
 -6.213229557995429e-03, -2.068994163621612e-05,  1.241383888748406e-07,  1.453877795328579e-09, -1.378159339962346e-12, -9.966819325709615e-14, -3.220740141277940e-16,
  6.020617077145915e-18,  5.119172490159294e-20, -2.587474901623314e-22, -5.392081941856308e-24,  1.497896591889163e+00, -5.332908198490954e-03, -2.723766593519619e-05,
  1.645224493863463e-08,  1.379472051667690e-09,  7.696500022385893e-12, -3.844252293220917e-14, -7.898748567030091e-16, -2.544824500778240e-18,  4.312455399364458e-20,
  5.048792704288591e-22,  4.447745043021068e-26,  1.644403229863514e+00, -4.189840726068694e-03, -2.839372719778166e-05, -8.248889341918071e-08,  6.423521462499400e-10,
  9.966071591830130e-12,  4.667919404128102e-14, -2.553161492905047e-16, -5.673825611336038e-18, -3.364925710599304e-20,  1.224244549156292e-22,  3.850459252851442e-24,
  1.771406000222775e+00, -2.928145025851116e-03, -2.419360333783349e-05, -1.335390987789384e-07, -2.420114595886686e-10,  4.591131387542019e-12,  6.315940227813202e-14,
  3.942463268662177e-16,  9.127852606236398e-20, -2.708201843679776e-20, -3.187142137508142e-22, -1.656979605827523e-24,  1.873955680618595e+00, -1.720808988397973e-03,
 -1.632884667088004e-05, -1.222301441067571e-07, -6.923852946430956e-10, -2.059160999219539e-12,  1.336820507044094e-14,  2.896098666172802e-16,  2.835568353386312e-18,
  1.750240473038658e-20,  3.514934407876203e-23, -7.686604704316599e-25,  1.947863414282934e+00, -7.438791721575266e-04, -7.727777022830126e-06, -6.843350696164582e-08,
 -5.356304037778615e-10, -3.688047287453775e-12, -2.130910080749144e-14, -8.628291941997376e-17,  3.612134542100306e-20,  5.633653548414413e-21,  7.706768250857498e-23,
  7.406469012953038e-25,  1.990013471332233e+00, -1.460221803260535e-04, -1.592712731545884e-06, -1.533009404812321e-08, -1.370587443291676e-10, -1.162975458575476e-12,
 -9.460660655948395e-15, -7.411050798762967e-17, -5.594986273025945e-19, -4.061567595100300e-21, -2.818337380024790e-23, -1.847598044818118e-25,  3.083356596173116e-03,
 -3.849368019929248e-05,  3.599103018631446e-07, -2.985910379108225e-09,  2.316839941957639e-11, -1.721017183923499e-13,  1.238686527631922e-15, -8.699988240349043e-18,
  5.987610021995959e-20, -4.049433853068980e-22,  2.695069886530210e-24, -1.767075688781049e-26,  2.767562223608563e-02, -3.419918341045386e-04,  3.129965494274774e-06,
 -2.502850399516024e-08,  1.833733759127869e-10, -1.251696961453660e-12,  7.979741092744968e-15, -4.712478151863203e-17,  2.515568265779423e-19, -1.139758887753549e-21,
  3.471817984794420e-24,  5.774597018176732e-27,  7.646008907487253e-02, -9.254125141187420e-04,  8.103516397442983e-06, -5.985462302114860e-08,  3.835277376104083e-10,
 -2.082292681855800e-12,  8.550658308758660e-15, -1.190884492067393e-17, -2.356397118748504e-19,  3.363241379229488e-21, -2.962944748967726e-23,  1.996871374614326e-25,
  1.486258451042487e-01, -1.742421841158756e-03,  1.422389176093871e-05, -9.162473601619094e-08,  4.443368604377144e-10, -1.077020862173128e-12, -7.477337885251818e-15,
  1.319380291474951e-16, -1.118932236642449e-18,  6.081731178032332e-21, -1.164464550657292e-23, -1.926995665927135e-25,  2.429300373997421e-01, -2.725686671062515e-03,
  2.009544894904816e-05, -1.028008788749545e-07,  2.270213870443546e-10,  2.136976969615013e-12, -3.169528812498066e-14,  2.138968050459050e-16, -5.283209800055727e-19,
 -6.347873606202591e-21,  9.853497163497538e-23, -6.928228519365347e-25,  3.576675750354742e-01, -3.789817112328907e-03,  2.420384863473181e-05, -8.025040914172065e-08,
 -2.702172783990219e-10,  5.882294762251759e-12, -3.766646745167708e-14,  1.719388745215919e-17,  2.018796940313832e-18, -1.994525642040518e-20,  6.331431109128677e-23,
  6.728377258642782e-25,  4.906337000265134e-01, -4.835832425214212e-03,  2.519201746846029e-05, -2.106559676542992e-08, -8.685745032746815e-10,  7.085520488667310e-12,
 -4.655360285303981e-15, -3.796452748249684e-16,  3.208894465506273e-18, -5.839236849394386e-22, -2.105026009088471e-22,  1.736760558593424e-24,  6.390829779792846e-01,
 -5.757541140280698e-03,  2.216465194251907e-05,  6.383968254463964e-08, -1.257987546471237e-09,  3.438624176806615e-12,  5.303932801869851e-14, -5.188297223926417e-16,
 -4.315022533242824e-19,  3.826857735960595e-20, -2.030776649744948e-22, -1.547726198143070e-24,  7.996904299259453e-01, -6.450181719336897e-03,  1.497409778254473e-05,
  1.503855875766965e-07, -1.145097460626052e-09, -4.163202207235044e-12,  8.405216142079006e-14, -4.104032377301020e-17, -5.663624452881863e-18,  2.507022107312269e-20,
  3.249587649446137e-22, -3.242286545525377e-24,  9.685234941220199e-01, -6.821455804116518e-03,  4.416661644794595e-06,  2.076188475853601e-07, -4.475469581316614e-10,
 -1.103074526999712e-11,  4.343105475696398e-14,  6.872391027022102e-16, -4.169381820655676e-18, -4.539252576350479e-20,  3.972674273011074e-22,  3.010713485163814e-24,
  1.141037186634201e+00, -6.804609182256767e-03, -7.750774616578055e-06,  2.092443466675868e-07,  5.779887832529513e-10, -1.147363261737723e-11, -4.883569126389895e-14,
  7.554030295360082e-16,  4.385291052714826e-18, -5.430046437864486e-20, -4.081826143806407e-22,  4.082830100319193e-24,  1.312108736885376e+00, -6.372397946408290e-03,
 -1.906204667388603e-05,  1.470473073298718e-07,  1.401783220518002e-09, -3.855022344610105e-12, -1.057289029605007e-13, -1.023877727252180e-16,  7.620396578538136e-18,
  3.615289804325182e-20, -4.895843171699008e-22, -4.893821254488062e-24,  1.476130951495407e+00, -5.549633266759445e-03, -2.690291327209197e-05,  3.969744328963639e-08,
  1.522343445853443e-09,  6.500852685473746e-12, -6.143808407104577e-14, -8.426058224358617e-16, -6.341668211270419e-19,  6.271112345659364e-20,  4.572471245297469e-22,
 -2.311544416297105e-24,  1.627183565285013e+00, -4.420759760471376e-03, -2.931516089294189e-05, -7.055863161665417e-08,  8.521868960871497e-10,  1.097899256995458e-11,
  3.681512572503290e-14, -4.549617708125039e-16, -6.752858308882740e-18, -2.499850251615794e-20,  3.185712651139003e-22,  5.003898696728085e-24,  1.759296090459420e+00,
 -3.128162024191064e-03, -2.581599844881276e-05, -1.365905945144239e-07, -1.341388730426691e-10,  6.238761622081386e-12,  7.407428522708171e-14,  3.789710054672298e-16,
 -1.129745608879996e-18, -4.117364950657501e-20, -3.819480653625967e-22, -1.114308089388339e-24,  1.866801623785082e+00, -1.857498139688054e-03, -1.786337197356648e-05,
 -1.336173933479642e-07, -7.296478191284199e-10, -1.630171698018056e-12,  2.284383297616610e-14,  3.906228285863744e-16,  3.480988516491742e-18,  1.802718239898985e-20,
 -1.456616172445713e-23, -1.546508742680746e-24,  1.944758838910126e+00, -8.091376785662466e-04, -8.602925979034645e-06, -7.762228449712975e-08, -6.146996703015923e-10,
 -4.228115813411357e-12, -2.367371522971139e-14, -8.121830346834386e-17,  3.030497757782660e-19,  9.454401235379452e-21,  1.162616269102046e-22,  1.055480576286742e-24,
  1.989402679053498e+00, -1.595388582014510e-04, -1.790641044533019e-06, -1.772219047287507e-08, -1.627679535662607e-10, -1.417098886720360e-12, -1.181003962780239e-14,
 -9.458839612487449e-17, -7.281185497029545e-19, -5.368438217828850e-21, -3.760835971162327e-23, -2.463471467988542e-25,  2.934922075526526e-03, -3.575167117435557e-05,
  3.261949714465796e-07, -2.641216110184027e-09,  2.000498264215171e-11, -1.450926879278588e-13,  1.019859775870055e-15, -6.997824058929264e-18,  4.706495152735859e-20,
 -3.112042680379386e-22,  2.025835699943960e-24, -1.300102367271914e-26,  2.635590017076912e-02, -3.181054379213715e-04,  2.846433689397788e-06, -2.228482865069596e-08,
  1.601522392717042e-10, -1.075144417948713e-12,  6.766969408065781e-15, -3.970433615575644e-17,  2.130608401705103e-19, -9.985401375916752e-22,  3.530906270476747e-24,
 -2.258019867581353e-27,  7.288368952164155e-02, -8.633561785636615e-04,  7.420741045105501e-06, -5.404032333630396e-08,  3.439030753566261e-10, -1.881826220420458e-12,
  8.128310588372364e-15, -1.772446751197240e-17, -1.339037572517912e-19,  2.340152278490789e-21, -2.185027299339153e-23,  1.550549328770864e-25,  1.418769449223199e-01,
 -1.632909529244532e-03,  1.316631211162531e-05, -8.469623422265841e-08,  4.212810525171227e-10, -1.215993131423198e-12, -4.252165952850336e-15,  9.953109355059387e-17,
 -9.100721670204412e-19,  5.483519051817542e-21, -1.744278342499352e-23, -7.941627952991216e-26,  2.323410961644950e-01, -2.569792782194926e-03,  1.888491445536770e-05,
 -9.886595154438937e-08,  2.626285003084361e-10,  1.446063564467256e-12, -2.597213463681365e-14,  1.940367514771344e-16, -6.930091620736785e-19, -2.989501610540947e-21,
  7.012114285117063e-23, -5.922398596158877e-25,  3.428893767575184e-01, -3.600103218694762e-03,  2.321862682291931e-05, -8.368154880185843e-08, -1.615373599269576e-10,
  4.990731948988178e-12, -3.638478359244560e-14,  7.084502424122931e-17,  1.352194563958835e-18, -1.696056548699089e-20,  8.273112939122402e-23,  2.349690460414426e-25,
  4.716915222160172e-01, -4.635532972923452e-03,  2.486049455980854e-05, -3.383858238447768e-08, -7.287827297364923e-10,  6.857760566050959e-12, -1.386172491640932e-14,
 -2.787729379515693e-16,  3.054652810989625e-18, -7.487852215738429e-21, -1.354769171481935e-22,  1.631515988924123e-24,  6.164118240249655e-01, -5.577496141114183e-03,
  2.281244132971911e-05,  4.432627335088621e-08, -1.177665205737243e-09,  4.536894950402325e-12,  3.851404527525651e-14, -5.122753908467417e-16,  7.866690425207903e-19,
  2.912490219854113e-20, -2.459809682504793e-22, -4.349487376503212e-25,  7.741402707501975e-01, -6.323487514756120e-03,  1.666640087058754e-05,  1.315067722200219e-07,
 -1.208384064570704e-09, -2.179302990220977e-12,  8.051763656737815e-14, -2.056144002462594e-16, -4.562688527774685e-18,  3.509626948353257e-20,  1.747335794775437e-22,
 -3.465434397276234e-24,  9.413239230623568e-01, -6.776294906515346e-03,  6.858043652300577e-06,  1.987560641665445e-07, -6.562636586975073e-10, -9.773958579885586e-12,
  6.058340687689105e-14,  5.309657742783844e-16, -5.490607167436680e-18, -2.741160921819863e-20,  4.874522933494943e-22,  1.051894983770179e-24,  1.113710838559828e+00,
 -6.856432254479381e-03, -5.192114129124859e-06,  2.166001568004442e-07,  3.385827259444609e-10, -1.237792622120194e-11, -2.603395132816667e-14,  8.616856719231739e-16,
  2.184391550588197e-18, -6.655241010490492e-20, -1.942165561845512e-22,  5.476729712087568e-24,  1.286325857375823e+00, -6.517461522157323e-03, -1.716590014950464e-05,
  1.687206998090904e-07,  1.299222610120518e-09, -6.398305493636648e-12, -1.050154341251727e-13,  1.581121934456784e-16,  8.521260073373021e-18,  1.269313291102689e-20,
 -6.705088963205584e-22, -3.126916907667627e-24,  1.453505585724986e+00, -5.762527697344326e-03, -2.627638988996850e-05,  6.500692463673085e-08,  1.635701771343318e-09,
  4.743136394052740e-12, -8.495197877665683e-14, -8.234938788512301e-16,  1.920920883683794e-18,  7.817127054410758e-20,  2.958028102809972e-22, -5.040611791009186e-24,
  1.609026470819017e+00, -4.658419090452028e-03, -3.007266580148300e-05, -5.512377579390882e-08,  1.079441153632752e-09,  1.168453740717010e-11,  2.093572282638714e-14,
 -6.825482771273120e-16, -7.368298763651378e-18, -7.636407542420083e-21,  5.532972418742627e-22,  5.510803337862431e-24,  1.746359967307373e+00, -3.341272718067722e-03,
 -2.746352280187978e-05, -1.376385060400852e-07,  9.246378845299632e-12,  8.138316491646117e-12,  8.393502448639080e-14,  3.160765629104326e-16, -2.896009332764358e-18,
 -5.711170285600518e-20, -4.054375453603073e-22,  1.966355355004091e-25,  1.859075379168657e+00, -2.007019479483468e-03, -1.953779558269001e-05, -1.455188447671477e-07,
 -7.558152294487250e-10, -9.374911684674529e-13,  3.543665798223933e-14,  5.121346100227482e-16,  4.100315648898337e-18,  1.577441624751866e-20, -1.064349734259415e-22,
 -2.695289618522417e-24,  1.941378497311544e+00, -8.818607854080721e-04, -9.596297171288878e-06, -8.816559739855783e-08, -7.051207589331229e-10, -4.822129550198054e-12,
 -2.575393667411983e-14, -6.507997795517897e-17,  7.393233943456405e-19,  1.514638591651222e-20,  1.712877765961124e-22,  1.460344124173403e-24,  1.988734461003017e+00,
 -1.747611833000324e-04, -2.019920804289919e-06, -2.056956408667849e-08, -1.941732717242071e-10, -1.735143920055631e-12, -1.481596488303204e-14, -1.212932378195541e-16,
 -9.512703270001714e-19, -7.111536110322654e-21, -5.012409089033592e-23, -3.256736746609420e-25,  2.796941179590412e-03, -3.326366064018071e-05,  2.963292282363786e-07,
 -2.343085005552629e-09,  1.733286173700591e-11, -1.228069545543555e-13,  8.434269099033763e-16, -5.656412926169959e-18,  3.719225162783232e-20, -2.405389768283437e-22,
  1.531966004634196e-24, -9.626210058650109e-27,  2.512738712500132e-02, -2.963616574838303e-04,  2.593708348591168e-06, -1.988595634136612e-08,  1.401872183961092e-10,
 -9.253396284919738e-13,  5.745487921936630e-15, -3.343457369107866e-17,  1.796183579224659e-19, -8.607103389025393e-22,  3.331158654579747e-24, -6.323245346207535e-27,
  6.954501797282188e-02, -8.064934364690904e-04,  6.804063709024235e-06, -4.882854351680477e-08,  3.081749533928861e-10, -1.693114253980300e-12,  7.583572717935357e-15,
 -2.081749924151643e-17, -6.385208295729131e-20,  1.591076596529423e-21, -1.587468637674440e-23,  1.178212886385954e-25,  1.355496901804807e-01, -1.531531743010097e-03,
  1.218958221685798e-05, -7.815495048990688e-08,  3.961501551832931e-10, -1.287716040674652e-12, -1.844323376319714e-15,  7.342723185976332e-17, -7.258515893614872e-19,
  4.738963935111181e-21, -1.928318645797977e-23, -1.030308444433788e-26,  2.223566733357243e-01, -2.423385610309365e-03,  1.772458500485935e-05, -9.446459198049403e-08,
  2.857432282284424e-10,  8.853414484262264e-13, -2.086217830608350e-14,  1.706309757017830e-16, -7.561028512738249e-19, -6.704026155189199e-22,  4.672549689427429e-23,
 -4.702027373188430e-25,  3.288540497014586e-01, -3.418407575273835e-03,  2.220208288378010e-05, -8.551431979144695e-08, -7.027143231832896e-11,  4.145649654361176e-12,
 -3.388248904699150e-14,  1.049989504479564e-16,  8.027835070675905e-19, -1.354013393802015e-20,  8.617890011875583e-23, -5.533961967952017e-26,  4.535443202323517e-01,
 -4.438461203323350e-03,  2.438892921847793e-05, -4.442239878377004e-08, -5.955306862321439e-10,  6.442174014243022e-12, -2.034607168213155e-14, -1.862469139879266e-16,
  2.704166381284362e-18, -1.154797605825325e-20, -6.966870070709148e-23,  1.339663160696782e-24,  5.944697645688533e-01, -5.393182075883497e-03,  2.323444460778673e-05,
  2.625494161740556e-08, -1.078827213356451e-09,  5.292852404699620e-12,  2.466671326012182e-14, -4.722457024149570e-16,  1.655968855003541e-18,  1.917557646864103e-20,
 -2.452913204367462e-22,  4.145339560450346e-25,  7.491225100790501e-01, -6.184175304456025e-03,  1.812737300403160e-05,  1.119266947936108e-07, -1.233192386483216e-09,
 -3.312564769965625e-13,  7.291419935513774e-14, -3.303500891828318e-16, -3.209474716534857e-18,  3.911963085303150e-20,  2.950512383325117e-23, -3.047807680256502e-24,
  9.143433066787268e-01, -6.712083089478208e-03,  9.173933131527798e-06,  1.867757002713599e-07, -8.361045647502517e-10, -8.162182043040489e-12,  7.286948435749110e-14,
  3.432955185884884e-16, -6.120676262112675e-18, -7.575018968766239e-21,  4.902437567955771e-22, -8.817106165239129e-25,  1.086218602310557e+00, -6.887499259288006e-03,
 -2.568665011042381e-06,  2.200113805194236e-07,  8.676162698653233e-11, -1.270757141544479e-11, -1.296227891089675e-15,  8.922354586099978e-16, -2.916164152782382e-19,
 -6.933886174908195e-20,  5.670391122519901e-23,  5.724372904698813e-24,  1.259994664628347e+00, -6.646347346590058e-03, -1.502118739268809e-05,  1.883496556960030e-07,
  1.146571738428928e-09, -8.834506030731408e-12, -9.674031868763336e-14,  4.327029810967641e-16,  8.469160189121275e-18, -1.611154811858427e-20, -7.491941708541195e-22,
 -3.180400599329284e-25,  1.430040629885045e+00, -5.969167121641662e-03, -2.533652883718623e-05,  9.181859673830039e-08,  1.708355532927854e-09,  2.437211337688192e-12,
 -1.067126328591505e-13, -7.151944395227449e-16,  4.887591344936085e-18,  8.480466522892218e-20,  1.814218625731572e-23, -7.459945119592795e-24,  1.589907880500408e+00,
 -4.901334846457201e-03, -3.062274344535768e-05, -3.596287004080822e-08,  1.316470272905971e-09,  1.193092514208439e-11, -1.484773400838446e-15, -9.179910402652004e-16,
 -7.187182610773489e-18,  1.923833177811217e-20,  7.851199707648355e-22,  4.771511167003734e-24,  1.732545020316565e+00, -3.567571938333108e-03, -2.910856367861873e-05,
 -1.360761868426573e-07,  1.928113895424018e-10,  1.024647621479207e-11,  9.115661903797707e-14,  1.874296138338035e-16, -5.236484634258060e-18, -7.255035631578001e-20,
 -3.495353699024242e-22,  2.526696232181920e-24,  1.850723345386426e+00, -2.170513429892162e-03, -2.135703506387121e-05, -1.577105289687059e-07, -7.648200070760147e-10,
  1.003817354941203e-13,  5.169141557365924e-14,  6.513520908770849e-16,  4.559138696307746e-18,  8.717681955612195e-21, -2.576739376995815e-22, -4.241396669208162e-24,
  1.937690532121514e+00, -9.630624549808835e-04, -1.072526888507043e-05, -1.002532179247459e-07, -8.078757590122692e-10, -5.458863142371530e-12, -2.715279155038557e-14,
 -3.124117101786333e-17,  1.424646029747123e-18,  2.342008825141408e-20,  2.458969694029531e-22,  1.939818646869150e-24,  1.988001456044895e+00, -1.919634728751483e-04,
 -2.286607295991213e-06, -2.397449924818610e-08, -2.327259086437191e-10, -2.135172515257472e-12, -1.867976141014943e-14, -1.562467462989938e-16, -1.247077453614803e-18,
 -9.430715647467953e-21, -6.655278349878619e-23, -4.242006126924064e-25,  2.668456148621194e-03, -3.100096013508334e-05,  2.697985314162042e-07, -2.084360029745539e-09,
  1.506697893150797e-11, -1.043383743533154e-13,  7.004874370496581e-16, -4.593765246271605e-18,  2.954098602736535e-20, -1.869523424752090e-22,  1.165211612862690e-24,
 -7.171867747440378e-27,  2.398198053291685e-02, -2.765297450505836e-04,  2.367947547894323e-06, -1.778383004097437e-08,  1.229867518306380e-10, -7.980601606356454e-13,
  4.885310709879915e-15, -2.815742374812011e-17,  1.509581407701470e-19, -7.336633420384861e-22,  3.008805107252424e-24, -8.039539755399228e-27,  6.642431330287851e-02,
 -7.543233835825788e-04,  6.246620009843340e-06, -4.415895526418436e-08,  2.760845278204672e-10, -1.518285293059335e-12,  6.979870104121987e-15, -2.205728451192863e-17,
 -1.683926988469287e-20,  1.050478855129466e-21, -1.137226038061291e-23,  8.800513371456415e-26,  1.296128062730781e-01, -1.437660739724495e-03,  1.128889734348311e-05,
 -7.202433379844302e-08,  3.701068145314615e-10, -1.309780622955104e-12, -8.895749766681428e-17,  5.278069701162310e-17, -5.691186611328442e-19,  3.971746825628096e-21,
 -1.879772909268045e-23,  2.829923148373904e-26,  2.129396562321514e-01, -2.286044331688552e-03,  1.661894177417703e-05, -8.977667492639122e-08,  2.988159446311319e-10,
  4.392367430834143e-13, -1.642452532710198e-14,  1.463719330438196e-16, -7.512551513911768e-19,  8.204876460966830e-22,  2.868195877538844e-23, -3.519103469315459e-25,
  3.155291346065382e-01, -3.244908693892696e-03,  2.117176084275379e-05, -8.601849524962175e-08,  4.761078214765908e-12,  3.370225631783068e-12, -3.065145263189389e-14,
  1.235458852408470e-16,  3.762689581452108e-19, -1.019845663938104e-20,  7.970151720893484e-23, -2.210979601634849e-25,  4.361771061835428e-01, -4.245634417437106e-03,
  2.380285094800070e-05, -5.294827543341066e-08, -4.719438269220972e-10,  5.900666976172917e-12, -2.441521357942756e-14, -1.067939752393202e-16,  2.251536317284219e-18,
 -1.326034437828138e-20, -1.858905586920192e-23,  9.785697183627200e-25,  5.732703793284131e-01, -5.206331490569850e-03,  2.344952196128190e-05,  9.868347446674284e-09,
 -9.680877969484203e-10,  5.732738196615866e-12,  1.227624684250706e-14, -4.100564362810826e-16,  2.175736997230210e-18,  9.906498992377779e-21, -2.143554238145424e-22,
  9.376900184978624e-25,  7.246838798065420e-01, -6.034119169587210e-03,  1.935218717349604e-05,  9.223435865605925e-08, -1.223121789465712e-09,  1.297384373504057e-12,
  6.243843462624254e-14, -4.105421000856454e-16, -1.810269260290202e-18,  3.783894758422061e-20, -8.754003304013423e-23, -2.228417862705689e-24,  8.876556155784874e-01,
 -6.629965585819906e-03,  1.132990422398150e-05,  1.721899679856200e-07, -9.811959024608642e-10, -6.320218585012221e-12,  7.972509710147014e-14,  1.467498998010406e-16,
 -6.054202557680341e-18,  1.077795339296477e-20,  4.165530395739234e-22, -2.367811781828146e-24,  1.058644235386013e+00, -6.897483718447429e-03,  7.143129816668123e-08,
  2.193731106645852e-07, -1.656924475205641e-10, -1.244222306985789e-11,  2.318638501616421e-14,  8.438846951621470e-16, -2.687947202701636e-18, -6.223191149067901e-20,
  2.916811527869113e-22,  4.773241546517533e-24,  1.233183672391884e+00, -6.757178420119503e-03, -1.265714747979899e-05,  2.051597945802928e-07,  9.478005568710847e-10,
 -1.098100334897356e-11, -8.095876382569916e-14,  6.886812567727189e-16,  7.354972308290427e-18, -4.541010818781954e-20, -6.920470000202807e-22,  2.920269049198304e-24,
  1.405766214864762e+00, -6.166984618885126e-03, -2.406956349934923e-05,  1.193966311680331e-07,  1.729969942101153e-09, -3.437141855861854e-13, -1.240923475940434e-13,
 -5.104768376321066e-16,  7.869945891369258e-18,  7.848451846509247e-20, -3.433073295151475e-22, -8.704554199620988e-24,  1.569810373404524e+00, -5.147666854692302e-03,
 -3.092007358276547e-05, -1.300153024036505e-08,  1.552519648252630e-09,  1.156172296051301e-11, -3.025883037835020e-14, -1.130460962763850e-15, -5.883919121132098e-18,
  5.424392246897616e-20,  9.468961602063299e-22,  2.260999067818155e-24,  1.717798749309536e+00, -3.806903305744949e-03, -3.071581632139937e-05, -1.312314883236360e-07,
  4.199351612924184e-10,  1.247577287735599e-11,  9.364834634905625e-14, -2.435359139214971e-17, -8.064825504608694e-18, -8.337684759859005e-20, -1.668665309671479e-22,
  5.943473073879717e-24,  1.841687300206549e+00, -2.349147224324949e-03, -2.332268187216875e-05, -1.698576819870387e-07, -7.488430241499945e-10,  1.576525110346095e-12,
  7.200249877467693e-14,  7.998804263461792e-16,  4.637706984953932e-18, -5.848274048882548e-21, -4.839952771934862e-22, -6.071347733842549e-24,  1.933658737299929e+00,
 -1.053905031302055e-03, -1.200958168245003e-05, -1.140882494689514e-07, -9.236103561694035e-10, -6.115024441237078e-12, -2.724800900323215e-14,  2.991154330471369e-17,
  2.466721048887619e-18,  3.510929829697005e-20,  3.421068186411954e-22,  2.423565136596481e-24,  1.987195100520317e+00, -2.114738201001950e-04, -2.598135360109867e-06,
 -2.806567260193117e-08, -2.802915758086153e-10, -2.640828140075613e-12, -2.366828409251700e-14, -2.021375584197136e-16, -1.639296590803095e-18, -1.249895177522788e-20,
 -8.769459001014797e-23, -5.387112557210538e-25,  2.548616257066914e-03, -2.893867581629329e-05,  2.461666215342178e-07, -1.859110958547759e-09,  1.313843656619261e-11,
 -8.896927258850325e-14,  5.841453166247246e-16, -3.747725161105724e-18,  2.357886148698253e-20, -1.460859251140037e-22,  8.911660529235336e-25, -5.376287369249555e-27,
  2.291244282055745e-02, -2.584075090679971e-04,  2.165841521969244e-06, -1.593761973468621e-08,  1.081368826645230e-10, -6.897513248396231e-13,  4.160723039815976e-15,
 -2.372682972568437e-17,  1.266255453228750e-19, -6.205688697082020e-22,  2.643243291050281e-24, -8.416512388028165e-27,  6.350371265513505e-02, -7.063972080706317e-04,
  5.742243500547697e-06, -3.997563737805631e-08,  2.473437876007402e-10, -1.358208565399569e-12,  6.359823080674241e-15, -2.207172935152841e-17,  1.365609091074349e-20,
  6.657566455747150e-22, -8.032816901414738e-24,  6.478794071111888e-26,  1.240374513204436e-01, -1.350708049215620e-03,  1.045927204852288e-05, -6.631183857697985e-08,
  3.439994651623216e-10, -1.296112225636843e-12,  1.154413532043373e-15,  3.671436387519313e-17, -4.393074849270390e-19,  3.251373473071640e-21, -1.708634962275764e-23,
  4.689769395224138e-26,  2.040546744049609e-01, -2.157320264742331e-03,  1.557053221548337e-05, -8.494541450573531e-08,  3.039768678374875e-10,  9.154706079871356e-14,
 -1.265682037785478e-14,  1.229974160913111e-16, -7.045093671271128e-19,  1.689545661880950e-21,  1.551524728544110e-23, -2.497792438607471e-25,  3.028817188611075e-01,
 -3.079657330921276e-03,  2.014209410399720e-05, -8.544185488847560e-08,  6.509511492819239e-11,  2.677145027143428e-12, -2.707452554139727e-14,  1.303067088834472e-16,
  6.390741499533301e-20, -7.232112203151111e-21,  6.808623440435081e-23, -2.942974036196126e-25,  4.195712203925079e-01, -4.057872738099056e-03,  2.312595390804116e-05,
 -5.958798327271978e-08, -3.599921547711071e-10,  5.286516374528023e-12, -2.646908829568191e-14, -4.244842666162940e-17,  1.770190507656959e-18, -1.324839288662547e-20,
  1.663774530240787e-23,  6.293081691729971e-25,  5.528206355626939e-01, -5.018516155109598e-03,  2.347883084663023e-05, -4.691569503838425e-09, -8.513748919618919e-10,
  5.897729091843954e-12,  1.811707485101869e-15, -3.362953615041234e-16,  2.388786463595196e-18,  2.242181556375765e-21, -1.672664385649420e-22,  1.157746548133903e-24,
  7.008635814975978e-01, -5.875204630934800e-03,  2.034268887132320e-05,  7.294940096003316e-08, -1.183148578685650e-09,  2.652648796844183e-12,  5.033119248161324e-14,
 -4.475263836175398e-16, -5.321811476746809e-19,  3.265659692183356e-20, -1.645720442010080e-22, -1.270042491357210e-24,  8.613297295528161e-01, -6.531337044795814e-03,
  1.329815732905700e-05,  1.555845689739773e-07, -1.088244640202291e-09, -4.378932187219994e-12,  8.120179731885569e-14, -3.778277782218186e-17, -5.394109826423019e-18,
  2.506764049257436e-20,  2.921048582944511e-22, -3.167477060486181e-24,  1.031072027504416e+00, -6.886446103754288e-03,  2.679909697303205e-06,  2.147693441311329e-07,
 -4.071169383286228e-10, -1.161390411327473e-11,  4.529245098606806e-14,  7.246586974610929e-16, -4.672099884461194e-18, -4.686148516129090e-20,  4.632272100976441e-22,
  2.912778017017442e-24,  1.205968377623523e+00, -6.848347470653954e-03, -1.011181150347720e-05,  2.184690862930431e-07,  7.104426828299709e-10, -1.266771549739007e-11,
 -5.866278695208741e-14,  8.928471994501131e-16,  5.261108976964911e-18, -6.963077621425612e-20, -4.983032495142862e-22,  5.746975266567511e-24,  1.380722899785730e+00,
 -6.353341132450341e-03, -2.247148980354613e-05,  1.468550241552286e-07,  1.692313480644191e-09, -3.462495647855641e-12, -1.344584452089145e-13, -2.168312918361729e-16,
  1.035603211364283e-17,  5.713657974634884e-20, -7.190979817755674e-22, -8.013987414764735e-24,  1.548724615639554e+00, -5.395211968892055e-03, -3.091957740691572e-05,
  1.363808322187608e-08,  1.773826764679589e-09,  1.043646921118039e-11, -6.420124914886553e-14, -1.280064776936431e-15, -3.235828162542838e-18,  9.293731775708895e-20,
  9.554538218466012e-22, -2.167971120961760e-24,  1.702069896684183e+00, -4.058794972234748e-03, -3.224165279980929e-05, -1.223950770121703e-07,  6.917083802604315e-10,
  1.468318243324534e-11,  8.889629303651309e-14, -3.311590917912809e-16, -1.111271329341357e-17, -8.362790643083021e-20,  1.846798794111196e-22,  1.009679021096207e-23,
  1.831904355635047e+00, -2.544082487998944e-03, -2.543149681669762e-05, -1.814851224344892e-07, -6.981324794327875e-10,  3.589773188505925e-12,  9.641536697361249e-14,
  9.406269949998821e-16,  4.009393254260123e-18, -3.108677204453269e-20, -7.905529332691127e-22, -7.791226439038692e-24,  1.929241925951729e+00, -1.155718666314876e-03,
 -1.347145708303251e-05, -1.298794893236764e-07, -1.052331112886929e-09, -6.748739117086380e-12, -2.509531027090771e-14,  1.319263156376828e-16,  4.003730904217451e-18,
  5.103883061175616e-20,  4.566363454999576e-22,  2.728782074485178e-24,  1.986305388894078e+00, -2.336865191572946e-04, -2.963679870861800e-06, -3.300577032691584e-08,
 -3.392794662135071e-10, -3.283154030670340e-12, -3.013529047974182e-14, -2.625199070660728e-16, -2.158429827737495e-18, -1.651567348566559e-20, -1.139884616622805e-22,
 -6.543963755571178e-25,  2.436663800203851e-03, -2.705513697081056e-05,  2.250622337276110e-07, -1.662403535912400e-09,  1.149116703089240e-11, -7.612838389251528e-14,
  4.890282215813268e-16, -3.070904367792281e-18,  1.890825958333280e-20, -1.147522403506512e-22,  6.851222739414882e-25, -4.055615066663408e-27,  2.191229517491308e-02,
 -2.418173836686561e-04,  1.984532966994053e-06, -1.431258214019328e-08,  9.528889862798110e-11, -5.974282396334842e-13,  3.549882835503720e-15, -2.001257545017567e-17,
  1.060994585052937e-19, -5.221822975189590e-22,  2.278600235038664e-24, -8.077136055922177e-27,  6.076705389519048e-02, -6.623128247854358e-04,  5.285410730446070e-06,
 -3.622736590916730e-08,  2.216562566821577e-10, -1.212919471785712e-12,  5.751124146338502e-15, -2.130803699433699e-17,  3.247527594798219e-20,  3.958802266997471e-22,
 -5.589991131767977e-24,  4.705990499997380e-26,  1.187970572893144e-01, -1.270125231911133e-03,  9.695704265574411e-06, -6.101339745448449e-08,  3.184297804032624e-10,
 -1.257555269642747e-12,  2.002286175304989e-15,  2.440160994713802e-17, -3.340387022744251e-19,  2.611702482643534e-21, -1.485289594028642e-23,  5.306162393282368e-26,
  1.956681827923105e-01, -2.036750667653916e-03,  1.458037907010276e-05, -8.008251572377542e-08,  3.030362168867826e-10, -1.733770222049284e-13, -9.518631951243837e-15,
  1.015261344671629e-16, -6.349279675101618e-19,  2.115911063307733e-21,  6.397997243071204e-24, -1.680803266085834e-25,  2.908788995422159e-01, -2.922600235202077e-03,
  1.912469692247628e-05, -8.400605325057417e-08,  1.124359047936809e-10,  2.071148144088256e-12, -2.343284910068138e-14,  1.286858572528467e-16, -1.506173584307735e-19,
 -4.774614935696182e-21,  5.470559892050157e-23, -3.061075569605132e-25,  4.037050880887124e-01, -3.875815438197147e-03,  2.237971531813909e-05, -6.453682535656932e-08,
 -2.606794495294425e-10,  4.642961728483316e-12, -2.693509713129952e-14,  6.743654776842244e-18,  1.311062729658499e-18, -1.212018220347564e-20,  3.764051189292911e-23,
  3.367912077866028e-25,  5.331215605683177e-01, -4.831133313007854e-03,  2.334469180440406e-05, -1.737061425932358e-08, -7.337034201988627e-10,  5.836883585461937e-12,
 -6.530875969503149e-15, -2.597534400500481e-16,  2.361471836079352e-18, -3.419133001074232e-21, -1.158927076705894e-22,  1.146325167704106e-24,  6.776933416483586e-01,
 -5.709278927945075e-03,  2.110645107147648e-05,  5.450479775713631e-08, -1.119036615377450e-09,  3.709342648186856e-12,  3.772916381523924e-14, -4.471093764432742e-16,
  5.139817552707679e-19,  2.522704825151743e-20, -2.004606638975398e-22, -3.872698009533805e-25,  8.354285505195763e-01, -6.417785700601664e-03,  1.505815176966747e-05,
  1.375772135293593e-07, -1.156517539051832e-09, -2.461381551017752e-12,  7.787745502275038e-14, -1.939783082859960e-16, -4.315714126343449e-18,  3.388992562846403e-20,
  1.483805625326718e-22, -3.256317345134238e-24,  1.003585265031118e+00, -6.854825869931020e-03,  5.210602816580082e-06,  2.064628859552206e-07, -6.269747498593733e-10,
 -1.030171973391373e-11,  6.326293683093069e-14,  5.519472237531001e-16, -6.000632691455218e-18, -2.642314553671612e-20,  5.422277771923850e-22,  6.618233264966477e-25,
  1.178430049258231e+00, -6.918581914565980e-03, -7.430564472844890e-06,  2.277416497253499e-07,  4.451223128835931e-10, -1.375904234047295e-11, -3.170730719834085e-14,
  1.017780184143056e-15,  2.462092737004737e-18, -8.391858141239788e-20, -2.041925016869985e-22,  7.372631560981510e-24,  1.354961793866354e+00, -6.525610110011605e-03,
 -2.054962458858068e-05,  1.732013384781967e-07,  1.590502590301858e-09, -6.723220506352136e-12, -1.356243826272011e-13,  1.412701734970647e-16,  1.181632563328202e-17,
  2.202258776227556e-20, -1.015269090971770e-21, -5.091921664432593e-24,  1.526650792324191e+00, -5.641416220963066e-03, -3.057904986750389e-05,  4.359307350697522e-08,
  1.964198250079079e-09,  8.457185497666938e-12, -1.009387034498969e-13, -1.322986692258618e-15,  7.600317216538218e-19,  1.276053053164134e-19,  7.356081991792044e-22,
 -7.957877784070024e-24,  1.685309844291692e+00, -4.322391960793620e-03, -3.363393375195247e-05, -1.088664235012523e-07,  1.005736850404464e-09,  1.666253249457262e-11,
  7.420830874668761e-14, -7.325674139588202e-16, -1.387216072956414e-17, -6.614481954158644e-20,  7.178724795786835e-22,  1.396680456118306e-23,  1.821307069060063e+00,
 -2.756429321693352e-03, -2.767353743310899e-05, -1.919459526722313e-07, -6.009942954879867e-10,  6.233021342846468e-12,  1.243333842305656e-13,  1.044226191754691e-15,
  2.235244785267959e-18, -6.989851465752682e-20, -1.155703859346492e-21, -8.546376184506871e-24,  1.924393219253469e+00, -1.270021235847563e-03, -1.513559080344257e-05,
 -1.478277702418546e-07, -1.192947056873663e-09, -7.290392216389485e-12, -1.930498504550808e-14,  2.932041555936026e-16,  6.198783510778415e-18,  7.168851949225081e-20,
  5.740037154099987e-22,  2.464051066968981e-24,  1.985320578300774e+00, -2.590777778184808e-04, -3.394621299363033e-06, -3.900148981418261e-08, -4.128131988834699e-10,
 -4.102994839349925e-12, -3.854881598094122e-14, -3.420407281010800e-16, -2.842263149803307e-18, -2.167859114570419e-20, -1.447212859591749e-22, -7.303749407828484e-25,
  2.331922170486071e-03, -2.533142058568909e-05,  2.061682872312232e-07, -1.490115764047871e-09,  1.007933913657525e-11, -6.535879448460870e-14,  4.109285414368633e-16,
 -2.526978347499329e-18,  1.523031074062103e-20, -9.060770134691975e-23,  5.291971382060236e-25, -3.080398488430590e-27,  2.097572584192213e-02, -2.266030842299179e-04,
  1.821549903222602e-06, -1.287910306699159e-08,  8.414882850778467e-11, -5.185883792695356e-13,  3.034358669499177e-15, -1.690126348677126e-17,  8.885747862822788e-20,
 -4.379627028405687e-22,  1.937308979786323e-24, -7.404044337782637e-27,  5.819969863339762e-02, -6.217099579157436e-04,  4.871184557234720e-06, -3.286763403739246e-08,
  1.987304678824693e-10, -1.081922840951394e-12,  5.170905048406777e-15, -2.008016354663742e-17,  4.316230778242588e-20,  2.094789396002612e-22, -3.827322174891165e-24,
  3.369101886613485e-26,  1.138671703912814e-01, -1.195403521415922e-03,  8.993291810988269e-06, -5.611690718466248e-08,  2.938086781211424e-10, -1.202426454914074e-12,
  2.549225466984794e-15,  1.510662667116550e-17, -2.501474736804582e-19,  2.064347204645003e-21, -1.252337802289280e-23,  5.194466656660220e-26,  1.877484958381533e-01,
 -1.923869509537819e-03,  1.364832826616263e-05, -7.527316273425193e-08,  2.975029045295313e-10, -3.699354936963545e-13, -6.948622331395026e-15,  8.246332663802269e-17,
 -5.557507076555976e-19,  2.243437775293440e-21,  4.265068056775007e-25, -1.065058776449813e-25,  2.794881563753739e-01, -2.773601412154326e-03,  1.812868942738919e-05,
 -8.190503810613469e-08,  1.485234076144935e-10,  1.551309210052316e-12, -1.992010220776308e-14,  1.215121761798542e-16, -2.863179122624355e-19, -2.850589741734690e-21,
  4.167191773156945e-23, -2.822077784647166e-25,  3.885549058992025e-01, -3.699939558324209e-03,  2.158319913728232e-05, -6.799980160309897e-08, -1.742465134441508e-10,
  4.003133929066822e-12, -2.622229474219026e-14,  4.203171447419010e-17,  9.047618497286411e-19, -1.038816236392608e-20,  4.736343448896552e-23,  1.174658147438483e-25,
  5.141689520895433e-01, -4.645400330312897e-03,  2.306962727104194e-05, -2.818680484741937e-08, -6.190787397046427e-10,  5.601261171928748e-12, -1.277035486393396e-14,
 -1.869539357920226e-16,  2.166760438166681e-18, -7.084570206028078e-21, -6.853222811336748e-23,  9.892476014278928e-25,  6.551976496188967e-01, -5.538109530158703e-03,
  2.165567713625410e-05,  3.723869271938662e-08, -1.036795844360292e-09,  4.467255633942939e-12,  2.556573324020900e-14, -4.176987751506141e-16,  1.275719649821086e-18,
  1.708439342669077e-20, -2.017445258624383e-22,  2.885684889046300e-25,  8.100083457970016e-01, -6.291034444744941e-03,  1.659675140139398e-05,  1.187785514059574e-07,
 -1.187570264891428e-09, -6.719435363515210e-13,  7.070260530540590e-14, -3.116896530878105e-16, -3.022469296442185e-18,  3.706576835991320e-20,  1.389453328224004e-23,
 -2.782029105338419e-24,  9.762647616778646e-01, -6.803416464187757e-03,  7.621449355593387e-06,  1.948703640495235e-07, -8.166895455177579e-10, -8.620381862126908e-12,
  7.591615602263900e-14,  3.489113202622107e-16, -6.560331364102566e-18, -4.793226983621698e-21,  5.240781472527108e-22, -1.416739907491058e-24,  1.150654284008528e+00,
 -6.966994891632176e-03, -4.664121052530218e-06,  2.326306268929111e-07,  1.646740497289834e-10, -1.417197256454789e-11, -2.568125924073761e-15,  1.047297647461206e-15,
 -6.265223154109199e-19, -8.548077573334308e-20,  1.258915901869385e-22,  7.347291050494979e-24,  1.328544318578776e+00, -6.681272184250576e-03, -1.832352494107343e-05,
  1.973989306154641e-07,  1.424031609668513e-09, -9.887568225055583e-12, -1.263139703605208e-13,  5.238765464225198e-16,  1.183569829732763e-17, -2.177930457900910e-20,
 -1.140311364873799e-21, -3.722103976312380e-25,  1.503599945763380e+00, -5.883409952815660e-03, -2.986224874819061e-05,  7.622928193566053e-08,  2.106149032193170e-09,
  5.597310137292213e-12, -1.369152373144405e-13, -1.220276960628280e-15,  5.783007186475056e-18,  1.482716793426625e-19,  2.557533288493641e-22, -1.368444420996296e-23,
  1.667474280000232e+00, -4.596389541352525e-03, -3.483249065413206e-05, -9.001976356035487e-08,  1.354868272061817e-09,  1.814525611459950e-11,  4.717043641623206e-14,
 -1.207783052621701e-15, -1.558118783679468e-17, -2.438657765652801e-20,  1.383339018825623e-21,  1.575477013704855e-23,  1.809823770378755e+00, -2.987183919958581e-03,
 -3.002991789834886e-05, -2.003923938545208e-07, -4.440948656768944e-10,  9.573303079001890e-12,  1.541269951065600e-13,  1.065845900721205e-15, -1.201917602943998e-18,
 -1.233941800872579e-19, -1.507141349198195e-21, -6.874523000321300e-24,  1.919059257058021e+00, -1.398537406187290e-03, -1.702893149945561e-05, -1.681033329009742e-07,
 -1.342596555437325e-09, -7.630232442012270e-12, -7.897498321401027e-15,  5.374834474340374e-16,  9.216150638065691e-18,  9.648299286413338e-20,  6.543785479801733e-22,
  8.870267368985788e-25,  1.984226821960777e+00, -2.882256850028293e-04, -3.905149414272724e-06, -4.631669860026561e-08, -5.049568866543133e-10, -5.154132351946808e-12,
 -4.952494505711309e-14, -4.466602100657517e-16, -3.734635177997705e-18, -2.810744431204151e-20, -1.763061528843973e-22, -6.701977360677777e-25,  2.233785675672592e-03,
 -2.375095424379025e-05,  1.892130501495477e-07, -1.338790997388084e-09,  8.865327255724726e-12, -5.629337562680167e-14,  3.465336186453919e-16, -2.087964177128421e-18,
  1.231889705576505e-20, -7.192249832606829e-23,  4.103015361623455e-25, -2.360193744967655e-27,  2.009751079695585e-02, -2.126267567932241e-04,  1.674749076639466e-06,
 -1.161189444860718e-08,  7.446857558225388e-11, -4.511353362997253e-13,  2.598664192785131e-15, -1.429575846289427e-17,  7.440921566634590e-20, -3.667610321714326e-22,
  1.628363244201308e-24, -6.639447785906682e-27,  5.578837401283047e-02, -5.842656748565918e-04,  4.495158331139829e-06, -2.985449962142034e-08,  1.782883190240789e-10,
 -9.644059999169221e-13,  4.628936063748705e-15, -1.860515087655181e-17,  4.827592092391611e-20,  8.286745439263020e-23, -2.576385466271941e-24,  2.363450306417423e-26,
  1.092252945305180e-01, -1.126072687952744e-03,  8.347312079970937e-06, -5.160490398966495e-08,  2.704018293675749e-10, -1.137008429132659e-12,  2.870653445938202e-15,
  8.198688501589197e-18, -1.843083728875597e-19,  1.607828335451836e-21, -1.034003731749245e-23,  4.682839734828509e-26,  1.802657837220831e-01, -1.818215691846385e-03,
  1.277333914386576e-05, -7.058061709316947e-08,  2.886134826712592e-10, -5.109298137820378e-13, -4.876509340618349e-15,  6.596651748420593e-17, -4.756787596989623e-19,
  2.180867771985406e-21, -3.235926458736684e-24, -6.264892097354051e-26,  2.686776449108315e-01, -2.632460745306930e-03,  1.716103005231735e-05, -7.930529286086945e-08,
  1.750386438001992e-10,  1.112935613065296e-12, -1.665930293292899e-14,  1.110061402751306e-16, -3.618268459042873e-19, -1.420798075174330e-21,  3.011507981162863e-23,
 -2.415777874574273e-25,  3.740952517016444e-01, -3.530579485935601e-03,  2.075300638380082e-05, -7.018098355519354e-08, -1.003663675826160e-10,  3.390860845181232e-12,
 -2.469364358551174e-14,  6.537326968477135e-17,  5.656849536299022e-19, -8.438753358838513e-21,  4.902738898083038e-23, -3.097821302718663e-26,  4.959540959597605e-01,
 -4.462356270742597e-03,  2.267559241361154e-05, -3.721415746611287e-08, -5.105029828666407e-10,  5.239538601393433e-12, -1.707599531727565e-14, -1.221459940714075e-16,
  1.872288240433294e-18, -9.019056908665102e-21, -2.984475904513631e-23,  7.632320486149362e-25,  6.333941435450597e-01, -5.363351676847755e-03,  2.200605477560243e-05,
  2.139417106533512e-08, -9.422362446347129e-10,  4.945612839966724e-12,  1.452323471471396e-14, -3.685588693053342e-16,  1.749893906489341e-18,  9.411209143855640e-21,
 -1.788466774194239e-22,  7.101022603722070e-25,  7.851183265724845e-01, -6.152882520015496e-03,  1.790793389134244e-05,  9.975896426617036e-08, -1.184798678782158e-09,
  9.104931151175564e-13,  6.082126942316946e-14, -3.871780940250889e-16, -1.705620904830259e-18,  3.539390303758880e-20, -9.162980719655184e-23, -1.981688470215799e-24,
  9.491875191026586e-01, -6.733325676489037e-03,  9.876130792470599e-06,  1.805259590881260e-07, -9.702087350846443e-10, -6.704900449424332e-12,  8.274869287076578e-14,
  1.401135575052780e-16, -6.375111899295518e-18,  1.443493009154653e-20,  4.265556287928931e-22, -2.892925235949792e-24,  1.122729393299608e+00, -6.993118312566737e-03,
 -1.866082105062019e-06,  2.330044408047078e-07, -1.170300793274808e-10, -1.388677446693147e-11,  2.602339879364085e-14,  9.795959201128059e-16, -3.538493218046546e-18,
 -7.435378482668944e-20,  4.185700488737786e-22,  5.723715551354688e-24,  1.301541581460734e+00, -6.818013969901391e-03, -1.582507463023281e-05,  2.184424569619647e-07,
  1.197370011805395e-09, -1.270132136465518e-11, -1.065233886588679e-13,  8.813331707138616e-16,  1.024105020843229e-17, -6.613818266543150e-20, -1.038430388551862e-21,
  4.984627421539780e-24,  1.479595121846406e+00, -6.118068772692167e-03, -2.874222186053218e-05,  1.106335214013402e-07,  2.182597150766538e-09,  1.927214745843169e-12,
 -1.676829067976825e-13, -9.491006304140627e-16,  1.114772101416257e-17,  1.451715577773192e-19, -4.371917239217105e-22, -1.727986687121877e-23,  1.648525117543710e+00,
 -4.878973971874696e-03, -3.577051921737616e-05, -6.538963809964258e-08,  1.726061921703571e-09,  1.881479388499482e-11,  6.324087630153395e-15, -1.708407209088069e-15,
 -1.529870807998441e-17,  4.444457421983862e-20,  2.039596247331159e-21,  1.316508091256443e-23,  1.797379176548745e+00, -3.237146984806237e-03, -3.247026290586084e-05,
 -2.057551897073130e-07, -2.132624243056306e-10,  1.362159519046516e-11,  1.826783997881435e-13,  9.441594021514296e-16, -6.790057567385456e-18, -1.883285830837590e-19,
 -1.695386907070586e-21, -7.735242343438591e-25,  1.913179337777680e+00, -1.543214641299111e-03, -1.918011455839559e-05, -1.908102540245384e-07, -1.495691079760237e-09,
 -7.602461416986379e-12,  1.183923717379361e-14,  8.930482685398547e-16,  1.316157766930593e-17,  1.224592331108383e-19,  6.144123509873771e-22, -3.265103225433578e-24,
  1.983007711973224e+00, -3.218357061203442e-04, -4.513048809830287e-06, -5.528975811937788e-08, -6.210124878654815e-10, -6.507298284369372e-12, -6.386668207060642e-14,
 -5.837727818228057e-16, -4.879844628635173e-18, -3.566567741797245e-20, -1.986891493612372e-22, -2.631506736355835e-25,  2.141710814439397e-03, -2.229918316708685e-05,
  1.739628872799497e-07, -1.205519927124589e-09,  7.818112768957299e-12, -4.863586363248117e-14,  2.932217002867046e-16, -1.732212164972414e-18,  1.000162335262600e-20,
 -5.742006672388909e-23,  3.186450069292181e-25, -1.834480846256496e-27,  1.927294496982078e-02, -1.997665440274551e-04,  1.542268193407196e-06, -1.048932164178451e-08,
  6.603846586318079e-11, -3.933134712001935e-13,  2.229819752641476e-15, -1.211390551918100e-17,  6.230977871634503e-20, -3.072578371789930e-22,  1.351745673944899e-24,
 -5.962829323615400e-27,  5.352103148311911e-02, -5.496903573137962e-04,  4.153402582641970e-06, -2.715032929609179e-08,  1.600698586409808e-10, -8.593862063247757e-13,
  4.129937181117731e-15, -1.703059236893729e-17,  4.963258075812434e-20, -1.798345507751843e-24, -1.713009188821819e-24,  1.591564622748836e-26,  1.048507403860738e-01,
 -1.061699380998428e-03,  7.753273693631013e-06, -4.745658601751055e-08,  2.483659847586041e-10, -1.065973719679203e-12,  3.025801787096935e-15,  3.151016151645719e-18,
 -1.333930171348792e-19,  1.233411361423645e-21, -8.434011070382434e-24,  3.953303245323692e-26,  1.731920400093879e-01, -1.719339160380393e-03,  1.195372246446556e-05,
 -6.605031113402862e-08,  2.773655509228994e-10, -6.074498136882862e-13, -3.230954490210751e-15,  5.197119333299655e-17, -4.000732093976388e-19,  2.005822980237972e-21,
 -5.305424539299981e-24, -3.365849670338947e-26,  2.584164204818387e-01, -2.498929992760955e-03,  1.622683724606374e-05, -7.634729588118983e-08,  1.935439515647727e-10,
  7.490625901813390e-13, -1.371937782308988e-14,  9.882178342748069e-17, -3.937350118863710e-19, -4.156704389191657e-22,  2.046473965450668e-23, -1.973099905288050e-25,
  3.602996161002930e-01, -3.367946473596708e-03,  1.990333485355936e-05, -7.127585252060916e-08, -3.831792925819016e-11,  2.821957058363804e-12, -2.265276203976850e-14,
  7.898840799297767e-17,  2.965789776015142e-19, -6.535152401477276e-21,  4.549730817648635e-23, -1.212407187646045e-25,  4.784644663576292e-01, -4.282868853664548e-03,
  2.218339731156464e-05, -4.456719105055221e-08, -4.100537855888647e-10,  4.795137154914115e-12, -1.970739220007019e-14, -6.759670283019084e-17,  1.533562169184152e-18,
 -9.612023198054304e-21, -1.548460557621966e-24,  5.241610066660712e-25,  6.122941078976868e-01, -5.186524983262700e-03,  2.217564629440867e-05,  7.125236201409852e-09,
 -8.406404472034176e-10,  5.176927599536204e-12,  5.029005030704296e-15, -3.084565032008362e-16,  1.968121269026909e-18,  2.951905888746309e-21, -1.427948843308719e-22,
  8.926538358463464e-25,  7.608004526042000e-01, -6.005151003311976e-03,  1.899214831782564e-05,  8.102339314102680e-08, -1.152896815188913e-09,  2.235092334122652e-12,
  4.940176210577736e-14, -4.222333729707431e-16, -5.160477784707071e-19,  3.024628817381025e-20, -1.592924138566683e-22, -1.098010957173025e-24,  9.224255693546912e-01,
 -6.645924766328094e-03,  1.194522922103894e-05,  1.640386659463234e-07, -1.084245972769760e-09, -4.694314655614605e-12,  8.391589638636892e-14, -5.254812642516186e-17,
 -5.581476206315487e-18,  2.869222905144898e-20,  2.813653195451192e-22, -3.572642087525198e-24,  1.094744698637452e+00, -6.996915430598826e-03,  9.097058090961526e-07,
  2.289530752367264e-07, -3.863743944938593e-10, -1.294821022371399e-11,  5.149011739413091e-14,  8.272171034627403e-16, -5.859812923906191e-18, -5.331618897947755e-20,
  6.135211366329261e-22,  3.019458959096003e-24,  1.274033359267478e+00, -6.933823808585529e-03, -1.309762599037017e-05,  2.354382848734901e-07,  9.199578789632351e-10,
 -1.492719749266286e-11, -7.767024744489968e-14,  1.163450954247307e-15,  7.178451866860110e-18, -1.018608731503422e-19, -7.151321129885348e-22,  9.434128044225708e-24,
  1.454672219492483e+00, -6.342101005069631e-03, -2.720454941827430e-05,  1.456365218144196e-07,  2.178973248988931e-09, -2.371091564649844e-12, -1.885106512965837e-13,
 -5.136351799713718e-16,  1.587351185221239e-17,  1.122838626376895e-19, -1.203381153805522e-21, -1.674006959767150e-23,  1.628432624213188e+00, -5.167778772040505e-03,
 -3.637709523529560e-05, -3.477126836089395e-08,  2.099723418819177e-09,  1.833929435386815e-11, -4.800634399283165e-14, -2.155604431488774e-15, -1.210900545215764e-17,
  1.354960129376890e-19,  2.448408985362842e-21,  4.296276085830507e-24,  1.783895374414992e+00, -3.506821049524662e-03, -3.495001317694608e-05, -2.067412587828623e-07,
  1.049984725129937e-10,  1.829183058094147e-11,  2.049608534283499e-13,  6.054249589357766e-16, -1.477086784715925e-17, -2.536625766497343e-19, -1.480504266200204e-21,
  1.170561786976174e-23,  1.906684506401704e+00, -1.706232687499612e-03, -2.161836615768386e-05, -2.159328549398063e-07, -1.642609619360145e-09, -6.966429300943247e-12,
  4.343533097941301e-14,  1.389096907067894e-15,  1.795908974104636e-17,  1.420270735594455e-19,  3.015317287291268e-22, -1.187706495816243e-23,  1.981643706119923e+00,
 -3.607733814926148e-04, -5.240723679401276e-06, -6.635629851890818e-08, -7.679068836471425e-10, -8.255133346009325e-12, -8.260250840885289e-14, -7.620128482274041e-16,
 -6.307306680902465e-18, -4.357290855378981e-20, -1.880822249992218e-22,  9.296608723593265e-25,  2.055208776174586e-03, -2.096329002032561e-05,  1.602162823350727e-07,
 -1.087845363527046e-09,  6.912019160444006e-12, -4.214622608802699e-14,  2.489063895167464e-16, -1.442924808864478e-18,  8.145571895938729e-21, -4.617002488959665e-23,
  2.465189138099646e-25, -1.468861127078113e-27,  1.849778249004900e-02, -1.879145029582636e-04,  1.422485552669136e-06, -9.492840056492192e-09,  5.868100123429591e-11,
 -3.436526172970638e-13,  1.916953773005922e-15, -1.028704164907323e-17,  5.215989092820750e-20, -2.582900807098909e-22,  1.099578524968124e-24, -5.563729886448417e-27,
  5.138672085788430e-02, -5.177240855273644e-04,  3.842415152239414e-06, -2.472148682025983e-08,  1.438356197152690e-10, -7.658110224912224e-13,  3.675219328612833e-15,
 -1.545535776120740e-17,  4.848545966540514e-20, -5.825222482733227e-23, -1.156046890910472e-24,  9.531974847354847e-27,  1.007244818094007e-01, -1.001885146560386e-03,
  7.206947096465103e-06, -4.364931858810506e-08,  2.277775223389546e-10, -9.927393026276968e-13,  3.060500166930463e-15, -4.689710073577313e-19, -9.466603768719265e-20,
  9.283406435183580e-22, -6.884327197966366e-24,  3.062615622082728e-26,  1.665010283630856e-01, -1.626805300512033e-03,  1.118733255037183e-05, -6.171339787592911e-08,
  2.645517972593784e-10, -6.689118728693731e-13, -1.944445376396008e-15,  4.028070613524711e-17, -3.319872448327707e-19,  1.769652384780237e-21, -6.384687368461983e-24,
 -1.738788107909029e-26,  2.486746031934012e-01, -2.372726294129124e-03,  1.532968885410677e-05, -7.314771766671384e-08,  2.054492829577444e-10,  4.515693106017794e-13,
 -1.112997913314679e-14,  8.612457769633323e-17, -3.959457435036467e-19,  2.413711058763921e-22,  1.267119843200342e-23, -1.584442464570487e-25,  3.471408573027727e-01,
 -3.212147356903085e-03,  1.904611500375700e-05, -7.146619686008374e-08,  1.286835956375056e-11,  2.305698198033120e-12, -2.034114901721388e-14,  8.505443242002176e-17,
  9.262761877821925e-20, -4.838852132029928e-21,  3.895891302119359e-23, -1.708106304712445e-25,  4.616843901284901e-01, -4.107645316128597e-03,  2.161230587495284e-05,
 -5.038707595837083e-08, -3.190068217014573e-10,  4.304673491272987e-12, -2.096492811081985e-14, -2.403011472559107e-17,  1.191361207488428e-18, -9.279484784870494e-21,
  1.657064252532602e-23,  3.039839608753656e-25,  5.919030474284454e-01, -5.008998558291358e-03,  2.218387794727221e-05, -5.492952297410863e-09, -7.365574537824056e-10,
  5.201159760729887e-12, -2.717493156380143e-15, -2.448010620528183e-16,  1.981152620725417e-18, -1.964760590658895e-21, -1.031014736430280e-22,  8.849137825668460e-25,
  7.370894430114356e-01, -5.849634486009636e-03,  1.985542373850877e-05,  6.299503797207520e-08, -1.097301712210993e-09,  3.277958261637792e-12,  3.750248869827821e-14,
 -4.226346193036620e-16,  4.487015096464124e-19,  2.314951881178168e-20, -1.898817962290505e-22, -3.221636864212003e-25,  8.960450360284870e-01, -6.542790419835496e-03,
  1.380685959919578e-05,  1.460482159239061e-07, -1.158211628322219e-09, -2.717147524544848e-12,  8.011302086165638e-14, -2.127666515236797e-16, -4.384205353017860e-18,
  3.677451716571474e-20,  1.232697525583848e-22, -3.504906174119743e-24,  1.066788818920985e+00, -6.978772337929689e-03,  3.611742999323377e-06,  2.207739872872328e-07,
 -6.312212419098391e-10, -1.145729026534800e-11,  7.177346416351684e-14,  6.139358573455000e-16, -7.313565378964877e-18, -2.701091805880546e-20,  6.796689615351427e-22,
  7.699954496859776e-28,  1.246106717916887e+00, -7.027076840924249e-03, -1.019419935538585e-05,  2.476794752254969e-07,  6.055308980589896e-10, -1.637797117969140e-11,
 -4.246333343310552e-14,  1.329834654816070e-15,  3.104599561901084e-18, -1.213235168874054e-19, -2.420383759996416e-22,  1.161491259442873e-23,  1.428880440995017e+00,
 -6.552159387693237e-03, -2.525010169149320e-05,  1.798710884161508e-07,  2.085455109488035e-09, -7.007161573779657e-12, -1.952476674088160e-13,  4.833177958448895e-17,
  1.888284731035087e-17,  5.070476586484644e-20, -1.834599963338081e-21, -1.112917066747603e-23,  1.607177675390509e+00, -5.459866065877473e-03, -3.658093368044534e-05,
  1.674748447007250e-09,  2.449894183707847e-09,  1.642426064265805e-11, -1.129190429228518e-13, -2.446011083696736e-15, -5.459090550474712e-18,  2.331365332304086e-19,
  2.322394909470833e-21, -1.092554519234175e-23,  1.769293256863773e+00, -3.796286611441710e-03, -3.740787687456001e-05, -2.018626305027828e-07,  5.210855569963692e-10,
  2.335208640565505e-11,  2.138484112267749e-13, -2.347053297563324e-17, -2.479775951264913e-17, -2.973498056647299e-19, -5.629705883616820e-22,  3.099947778130166e-23,
  1.899496626722875e+00, -1.890001333991404e-03, -2.437162623393105e-05, -2.432581442238464e-07, -1.768007376997321e-09, -5.387526514480251e-12,  9.115394471147494e-14,
  2.046674782392150e-15,  2.312818867646946e-17,  1.396826068252263e-19, -5.303188512988766e-22, -2.722398328524820e-23,  1.980111405589356e+00, -4.061064292885628e-04,
 -6.116536474215820e-06, -8.007902740567795e-08, -9.546865999868086e-10, -1.051793575320559e-11, -1.070100651491063e-13, -9.902789570938751e-16, -7.995593343625437e-18,
 -4.960106199396663e-20, -9.268790838721272e-23,  3.789253160664339e-24,  1.973838972692996e-03, -1.973195828952393e-05,  1.477988903842016e-07, -9.836851049525806e-10,
  6.125705563946535e-12, -3.662931188818551e-14,  2.119166983213736e-16, -1.207079065960014e-18,  6.646066324949590e-21, -3.752736685960895e-23,  1.871897170095340e-25,
 -1.252540325854176e-27,  1.776818465591986e-02, -1.769748202116307e-04,  1.313985874942875e-06, -8.606523394259266e-09,  5.224562615546681e-11, -3.009218626645415e-13,
  1.650944127744980e-15, -8.758688857544213e-18,  4.359431791275220e-20, -2.191930120285045e-22,  8.543760761301102e-25, -5.691165290886711e-27,  4.937547806175142e-02,
 -4.881334060023214e-04,  3.559075224248809e-06, -2.253799819094568e-08,  1.293672959241582e-10, -6.826256738329304e-13,  3.263816132895822e-15, -1.394558770638406e-17,
  4.564080611510725e-20, -9.789843332406398e-23, -8.710837686672829e-25,  3.361117706539140e-27,  9.682902053821532e-02, -9.462642646758602e-04,  6.704379608967389e-06,
 -4.015973587276890e-08,  2.086545479027269e-10, -9.197581431069301e-13,  3.009618246707584e-15, -3.014251096886430e-18, -6.590529977521243e-20,  6.768557179319600e-22,
 -5.770284516333183e-24,  1.957517178563558e-26,  1.601682144924644e-01, -1.540197956518961e-03,  1.047172005062390e-05, -5.758976796535255e-08,  2.507922886436471e-10,
 -7.031876412654121e-13, -9.560978783020488e-16,  3.062579270262940e-17, -2.730400624383660e-19,  1.501107962404473e-21, -7.010787689300730e-24, -1.302963411507117e-26,
  2.394234934955373e-01, -2.253543395480710e-03,  1.447189257453629e-05, -6.980199726059553e-08,  2.119974510366665e-10,  2.119671287686904e-13, -8.893947160216364e-15,
  7.367808288580762e-17, -3.797301724762495e-19,  6.177112115568405e-22,  6.340304590668034e-24, -1.318168554798734e-25,  3.345915836341703e-01, -3.063201977759826e-03,
  1.819119406640228e-05, -7.091710246825430e-08,  5.429443716238640e-11,  1.846273271072438e-12, -1.794225927817569e-14,  8.551683040019663e-17, -5.541716658855301e-20,
 -3.439956732553493e-21,  3.078476777048584e-23, -1.986963824321583e-25,  4.455956622433844e-01, -3.937245853976205e-03,  2.097978839019472e-05, -5.482993077820490e-08,
 -2.379784620669428e-10,  3.797445543282997e-12, -2.115321590696392e-14,  8.899016975267628e-18,  8.719193896892876e-19, -8.407451953361453e-21,  2.564157395485423e-23,
  1.131442561987368e-25,  5.722213053206335e-01, -4.831983668361186e-03,  2.205066823102771e-05, -1.645143232917734e-08, -6.337050169487946e-10,  5.060758656136392e-12,
 -8.700242342369763e-15, -1.832575287224223e-16,  1.845278347856389e-18, -5.343964335818983e-21, -6.689946511567076e-23,  7.428029000065072e-25,  7.140129650513203e-01,
 -5.688060519951145e-03,  2.050833418994078e-05,  4.600760219608606e-08, -1.023689024448752e-09,  4.038352422443296e-12,  2.598446654202019e-14, -3.964244837196285e-16,
  1.143632788720867e-18,  1.545165375254950e-20, -1.909932302436728e-22,  2.288646788059289e-25,  8.701054344101046e-01, -6.425643724746514e-03,  1.544678876766290e-05,
  1.271842588303758e-07, -1.193886649393360e-09, -8.805279387353373e-13,  7.239553105300218e-14, -3.312209819117270e-16, -3.007462077784324e-18,  3.876678797179710e-20,
 -1.931460878157767e-23, -2.913649260273588e-24,  1.038948031729930e+00, -6.939469714689240e-03,  6.193189770014857e-06,  2.089402327785005e-07, -8.418888174497841e-10,
 -9.555602350965442e-12,  8.557817147518437e-14,  3.695408200810303e-16, -7.804108776968470e-18, -6.404732421552289e-22,  6.198267103256512e-22, -2.604005018861969e-24,
  1.217854326330263e+00, -7.096602307325278e-03, -7.174868548446281e-06,  2.547049318749313e-07,  2.708370694467371e-10, -1.694311815505410e-11, -4.501212160822582e-15,
  1.358434594776754e-15, -1.313789914958264e-18, -1.207866148840221e-19,  2.634778795658960e-22,  1.087777029888542e-23,  1.402282256717418e+00, -6.744971442882260e-03,
 -2.289689014157894e-05,  2.118643263781538e-07,  1.898920181773497e-09, -1.160742638888390e-11, -1.852662252437639e-13,  6.668211896928707e-16,  1.929291125403572e-17,
 -2.982991354895499e-20, -2.120817130100193e-21, -1.384279216991526e-24,  1.584754015795256e+00, -5.751742884638369e-03, -3.631534806700741e-05,  4.333015487103179e-08,
  2.745664404627846e-09,  1.288097071163072e-11, -1.824704795250207e-13, -2.469746380700246e-15,  4.441314293595843e-18,  3.110381000568563e-19,  1.437453705729523e-21,
 -2.938619796179197e-23,  1.753494491995054e+00, -4.105059998640585e-03, -3.976389332689499e-05, -1.895120337448840e-07,  1.038891947565927e-09,  2.837692041035558e-11,
  2.004589958994199e-13, -9.895537178492435e-16, -3.551846218923667e-17, -2.859239367067543e-19,  1.300640829410797e-21,  5.369189817690375e-23,  1.891527499135015e+00,
 -2.097138946530145e-03, -2.746356641986894e-05, -2.722683552189668e-07, -1.848787904914769e-09, -2.424082262882390e-12,  1.595336770213033e-13,  2.860428867573634e-15,
  2.742954497629485e-17,  8.816480972603736e-20, -2.217804047959807e-21, -5.084758255895312e-23,  1.978382640403255e+00, -4.591591319957555e-04, -7.176555622587249e-06,
 -9.718639277524890e-08, -1.193130169280648e-09, -1.344948903525397e-11, -1.385911473532097e-13, -1.275013093248035e-15, -9.794598214373647e-18, -4.846735659215779e-20,
  1.944076821174199e-22,  1.002116448449734e-23,  1.897203442772907e-03, -1.859517179611985e-05,  1.365594262575784e-07, -8.912692409834472e-10,  5.441360762613225e-12,
 -3.192605679294086e-14,  1.809025129705778e-16, -1.014681352102096e-18,  5.416875705282547e-21, -3.111103876755391e-23,  1.341491724214512e-25, -1.179875016944370e-27,
  1.708067452969495e-02, -1.668622793419002e-04,  1.215531318278235e-06, -7.816668680459896e-09,  4.660433535591071e-11, -2.640915537409384e-13,  1.424088957937081e-15,
 -7.483830662331225e-18,  3.625646813833582e-20, -1.902237418051485e-22,  5.878949717483073e-25, -6.535656120679280e-27,  4.747822509656935e-02, -4.607084508041959e-04,
  3.300601404080186e-06, -2.057321538454437e-08,  1.164673079841696e-10, -6.088182588473702e-13,  2.893210094081882e-15, -1.254802298103874e-17,  4.150719134128767e-20,
 -1.317437762457292e-22, -8.711902945052982e-25, -3.493519471546106e-27,  9.314825972540544e-02, -8.945015137828004e-04,  6.241899199216143e-06, -3.696453257722722e-08,
  1.909737153242425e-10, -8.487574473097303e-13,  2.899047826806517e-15, -4.776442554827292e-18, -4.552058992019007e-20,  4.593781014927072e-22, -5.204963433026762e-24,
  5.690468951671005e-27,  1.541706882513621e-01, -1.459121365041555e-03,  9.804251507583456e-06, -5.369057370639002e-08,  2.365636338035219e-10, -7.167830678365210e-13,
 -2.131662917799313e-16,  2.269784127582146e-17, -2.241966094116589e-19,  1.207902852845737e-21, -7.700941002400986e-24, -2.001706350696462e-26,  2.306356469840301e-01,
 -2.141060837222783e-03,  1.365472455063117e-05, -6.638704402074395e-08,  2.142623444656910e-10,  2.191715039869543e-14, -6.997452249128454e-15,  6.192039824456996e-17,
 -3.542846515639700e-19,  7.595540661625866e-22,  8.266091206050757e-25, -1.214709382883905e-25,  3.226244694908266e-01, -2.921059019709247e-03,  1.734654606775534e-05,
 -6.977557532678247e-08,  8.710622088111058e-11,  1.444085954268452e-12, -1.558963857337803e-14,  8.198222604354123e-17, -1.592579250570313e-19, -2.390029646789857e-21,
  2.155003762187748e-23, -2.209109384364929e-25,  4.301781043683606e-01, -3.772098520127748e-03,  2.030140061172996e-05, -5.805744074621910e-08, -1.670710059937179e-10,
  3.295638888350592e-12, -2.055747191449837e-14,  3.216240317483061e-17,  5.884536484823474e-19, -7.332288536299167e-21,  2.692420754923102e-23, -5.050230754552358e-26,
  5.532446977262226e-01, -4.656532748567022e-03,  2.179571422911923e-05, -2.579396334234043e-08, -5.349598621734058e-10,  4.796856127278943e-12, -1.303701952147610e-14,
 -1.277429008107744e-16,  1.612048148922387e-18, -7.428347626661116e-21, -3.896986087863845e-23,  5.171315226011212e-25,  6.915919681474400e-01, -5.522057584917904e-03,
  2.096491622157031e-05,  3.030490444550643e-08, -9.375614315073464e-10,  4.533378248789054e-12,  1.547018726707267e-14, -3.523763182378865e-16,  1.565775636186692e-18,
  8.116229462827837e-21, -1.737103883876319e-22,  5.133798786447913e-25,  8.446592146706595e-01, -6.296290048809881e-03,  1.685810235470217e-05,  1.080322592799694e-07,
 -1.194924259868032e-09,  7.360778266097079e-13,  6.198135888276846e-14, -4.055160864679827e-16, -1.654536760376145e-18,  3.566533680336848e-20, -1.297271420191006e-22,
 -2.089473337452756e-24,  1.011304781862588e+00, -6.880137843203387e-03,  8.613714414539144e-06,  1.940557209415123e-07, -1.011769315137980e-09, -7.405636631680003e-12,
  9.245824557812097e-14,  1.239652995637155e-16, -7.413909924184262e-18,  2.128131596952907e-20,  4.637169761187759e-22, -4.324094190905853e-24,  1.189372546856063e+00,
 -7.141727479292060e-03, -4.103575459048272e-06,  2.563343527652397e-07, -6.606591961685901e-11, -1.660338665381412e-11,  3.231238326934454e-14,  1.249744310895377e-15,
 -5.364277394192635e-18, -1.015015041490690e-19,  6.762180572923236e-22,  7.524451843931397e-24,  1.374952826383755e+00, -6.917479746370390e-03, -2.018064502609829e-05,
  2.401558587100373e-07,  1.624174314830295e-09, -1.576157766575285e-11, -1.582299035690375e-13,  1.250716648036494e-15,  1.670723209025988e-17, -1.125995133633486e-19,
 -1.936745380438554e-21,  9.663932005778932e-24,  1.561170369840292e+00, -6.039421082922565e-03, -3.552413499181896e-05,  8.906071196526090e-08,  2.954017649630610e-09,
  7.698578990907541e-12, -2.478873777575604e-13, -2.140204763618395e-15,  1.631588433753533e-17,  3.376903254405141e-19, -2.167047845894194e-22, -4.461260241010528e-23,
  1.736424084665181e+00, -4.431940369623117e-03, -4.191876015825694e-05, -1.680999053551638e-07,  1.651593773862663e-09,  3.271798069625529e-11,  1.553919400551303e-13,
 -2.275814437856723e-15, -4.425190777539783e-17, -1.808661722137379e-19,  4.074767040941468e-21,  7.026053436424430e-23,  1.882678120974900e+00, -2.330421419733060e-03,
 -3.090911757614563e-05, -3.019997365770313e-07, -1.851971572012228e-09,  2.467218292774879e-12,  2.522413850724199e-13,  3.766955114698258e-15,  2.839031294088788e-17,
 -5.383059942044977e-20, -5.100180516554386e-21, -8.064251560348613e-23,  1.976423306149017e+00, -5.215827355230532e-04, -8.466829647103244e-06, -1.186219118378314e-07,
 -1.498463164568851e-09, -1.724103227003172e-11, -1.789252494704145e-13, -1.613817491987716e-15, -1.126567132658492e-17, -2.873892231405152e-20,  8.843510800339983e-22,
  2.278479164234779e-23,  1.824941997322717e-03, -1.754404430107086e-05,  1.263662333599261e-07, -8.090890612674964e-10,  4.844051898375564e-12, -2.790674235749851e-14,
  1.547566182869040e-16, -8.583271378922284e-19,  4.380961907342581e-21, -2.678269944791199e-23,  8.229606677811121e-26, -1.170879557704087e-27,  1.643209722820306e-02,
 -1.575009422118126e-04,  1.126036836067973e-06, -7.111465918284980e-09,  4.164796355767843e-11, -2.323030621123847e-13,  1.229784104499225e-15, -6.429237135205640e-18,
  2.975926602578958e-20, -1.727992224469947e-22,  2.756674042021050e-25, -7.543499286760304e-27,  4.568668088498913e-02, -4.352603762770234e-04,  3.064513761874530e-06,
 -1.880349344769542e-08,  1.049576104972227e-10, -5.434518948361983e-13,  2.559697371330692e-15, -1.130282759865157e-17,  3.608135280715597e-20, -1.717027589478357e-22,
 -1.173421730904547e-24, -9.779731598386384e-27,  8.966738641663241e-02, -8.462899386899411e-04,  5.816110219648371e-06, -3.404102221670888e-08,  1.746827138328457e-10,
 -7.809359352037148e-13,  2.747115430390286e-15, -6.008454116180729e-18, -3.270987814389955e-20,  2.518681586698820e-22, -5.271029186565959e-24, -7.861419745900017e-27,
  1.484870797346823e-01, -1.383201245511331e-03,  9.182201311098175e-06, -5.002031683378326e-08,  2.222242640673658e-10, -7.150452715643439e-13,  3.280354590256278e-16,
  1.615791218856853e-17, -1.865019397347142e-19,  8.786361339466972e-22, -8.849145171672588e-24, -3.149302281143508e-26,  2.222849160620472e-01, -2.034951362707260e-03,
  1.287863567142830e-05, -6.296389768535052e-08,  2.131552207397069e-10, -1.264723074360946e-13, -5.418304835028240e-15,  5.101674514328657e-17, -3.276300820919614e-19,
  6.860783386915481e-22, -4.491812586788273e-24, -1.196462146560678e-25,  3.112125113863838e-01, -2.785610119126219e-03,  1.651849071260432e-05, -6.817038178212534e-08,
  1.124290689440174e-10,  1.096830748296188e-12, -1.337734443186677e-14,  7.565630841102557e-17, -2.321794226094197e-19, -1.728161843268968e-21,  1.143080245878247e-23,
 -2.355518509533596e-25,  4.154100625639712e-01, -3.612514678830176e-03,  1.959076171519809e-05, -6.022974014660318e-08, -1.060090885506640e-10,  2.814957353581938e-12,
 -1.943153548966296e-14,  4.697050530548509e-17,  3.429607463510966e-19, -6.340881452592681e-21,  2.171979409368410e-23, -1.765708049775904e-25,  5.349651418607200e-01,
 -4.483543478908327e-03,  2.143793830142365e-05, -3.360393893110519e-08, -4.424123036727998e-10,  4.446618377732461e-12, -1.593373432818576e-14, -8.069686805284246e-17,
  1.321377956334134e-18, -8.606091637516833e-21, -2.172068226221981e-23,  2.716549626901661e-25,  6.698411288466474e-01, -5.353131630873364e-03,  2.124161763901970e-05,
  1.604618542168740e-08, -8.439499751741053e-10,  4.792149313184291e-12,  6.339748520630231e-15, -2.988912957887620e-16,  1.738637899968904e-18,  1.650527310157855e-21,
 -1.491222930929329e-22,  5.785367102792160e-25,  8.197515378266209e-01, -6.156563076532987e-03,  1.804051358272692e-05,  8.910811392408403e-08, -1.166272917236797e-09,
  2.082540619368479e-12,  5.007058853919905e-14, -4.390844144581313e-16, -4.838760777511211e-19,  2.888610603334573e-20, -2.031607203395790e-22, -1.255581068754648e-24,
  9.839363957864548e-01, -6.802199123861702e-03,  1.084075812072302e-05,  1.768037836678817e-07, -1.137546027262896e-09, -5.170968761025314e-12,  9.274629463764109e-14,
 -9.783187780765592e-17, -6.362383416790475e-18,  3.575187863685240e-20,  2.550081288845692e-22, -4.982814367577138e-24,  1.160759402914864e+00, -7.162294909852842e-03,
 -1.044695724017645e-06,  2.526743988320751e-07, -3.876581086520169e-10, -1.543054773423648e-11,  6.439327842474970e-14,  1.025410191091443e-15, -8.463978127694980e-18,
 -6.919729879015437e-20,  9.036363988752759e-22,  2.697778406056706e-24,  1.346978859408340e+00, -7.066980884723246e-03, -1.715388995652571e-05,  2.634274042242035e-07,
  1.274098669771244e-09, -1.908269740650964e-11, -1.164353001163250e-13,  1.706545973509455e-15,  1.138802982744907e-17, -1.787208165945229e-19, -1.305737388826347e-21,
  1.834843501804810e-23,  1.536452214970490e+00, -6.318526250491429e-03, -3.416783957252699e-05,  1.372143510491190e-07,  3.043994319639189e-09,  1.100246404319379e-12,
 -2.987109640005896e-13, -1.429253765236608e-15,  2.782126385017330e-17,  2.874999420262006e-19, -2.323444760829806e-21, -4.872252284684816e-23,  1.718013548723203e+00,
 -4.774859084515647e-03, -4.375522204969911e-05, -1.362615063855717e-07,  2.337237980020702e-09,  3.551795854828830e-11,  7.112517202202603e-14, -3.758470440888182e-15,
 -4.707427220139559e-17,  4.466119954748773e-20,  7.168358479317926e-21,  6.543989385262047e-23,  1.872838234139772e+00, -2.592688011387976e-03, -3.470810750274403e-05,
 -3.308699338413330e-07, -1.733028568178818e-09,  9.885988097407695e-12,  3.698202098461057e-13,  4.597612521150781e-15,  2.184803548780431e-17, -3.371154709566420e-19,
 -9.246867736166868e-21, -1.053068700449890e-22,  1.974191878700315e+00, -5.954466079587777e-04, -1.004632367850257e-05, -1.456053120217859e-07, -1.890099533866609e-09,
 -2.211887463380351e-11, -2.292529687135679e-13, -1.981734624693060e-15, -1.136754590202008e-17,  3.286142952121743e-20,  2.375232415540779e-21,  4.757674004472723e-23,
  1.756727994877783e-03, -1.657067427361569e-05,  1.171044071837612e-07, -7.358554045129258e-10,  4.321190119322019e-12, -2.446601052570038e-14,  1.325451367568568e-16,
 -7.330265542189480e-19,  3.463976518716393e-21, -2.447533640488374e-23,  3.519191856075894e-26, -8.648667035283447e-28,  1.581958511736859e-02, -1.488230126194445e-04,
  1.044549161400991e-06, -6.480722696139467e-09,  3.728300096551767e-11, -2.048465457439973e-13,  1.062173847891430e-15, -5.574990681620247e-18,  2.365785913285554e-20,
 -1.682481273689470e-22, -3.473078385743917e-26, -5.572160771086158e-27,  4.399328177589060e-02, -4.116190902835331e-04,  2.848599616496127e-06, -1.720789146964846e-08,
  9.467791395863004e-11, -4.856924949733284e-13,  2.258383701695254e-15, -1.025706726334626e-17,  2.894622824645106e-20, -2.276266077207044e-22, -1.604689632858706e-24,
 -6.924077017709219e-27,  8.637276284982610e-02, -8.013486763423508e-04,  5.423883518464679e-06, -3.136752554208792e-08,  1.597090945694285e-10, -7.171353800854190e-13,
  2.565293194813420e-15, -6.951569821886944e-18, -2.753523849530381e-20,  3.294629179410560e-23, -5.649595031548218e-24, -3.617894125092719e-27,  1.430974723350766e-01,
 -1.312085248604802e-03,  8.602820886045158e-06, -4.657856605388313e-08,  2.080353628531376e-10, -7.023910366008239e-13,  7.011563509123015e-16,  1.062489128539328e-17,
 -1.615772493046867e-19,  4.974651848649516e-22, -1.011132201730092e-23, -1.674990133297424e-26,  2.143464650689052e-01, -1.934886802020814e-03,  1.214342671810016e-05,
 -5.958025054899518e-08,  2.094350561770707e-10, -2.405333762244289e-13, -4.133206851536224e-15,  4.088305619442597e-17, -3.073887503814150e-19,  4.069789758352857e-22,
 -9.192819778278532e-24, -8.057451720692729e-26,  3.003292310445975e-01, -2.656702233682300e-03,  1.571190865428752e-05, -6.621276338222116e-08,  1.313221367265894e-10,
  8.003006116699784e-13, -1.137182422579433e-14,  6.729936161920083e-17, -2.886161637023263e-19, -1.471890471829970e-21,  1.737668341575954e-24, -1.840856511378458e-25,
  4.012688433049576e-01, -3.458704330695090e-03,  1.885960502371035e-05, -6.150036428375934e-08, -5.426144614397465e-11,  2.365417409296366e-12, -1.799593049847993e-14,
  5.444418406647855e-17,  1.282856805512423e-19, -5.643722777946392e-21,  1.305792740808635e-23, -1.838454942271128e-25,  5.173712599089544e-01, -4.313766677320720e-03,
  2.099508501687276e-05, -3.999254043051995e-08, -3.574635939031810e-10,  4.041580954774672e-12, -1.764892262063556e-14, -4.351758853945023e-17,  9.982984844913213e-19,
 -9.288132446008486e-21, -1.327513998555509e-23,  1.544020431423052e-25,  6.487693732931283e-01, -5.182650703143085e-03,  2.135633476236940e-05,  3.315264713587084e-09,
 -7.472307559982215e-10,  4.850177695875470e-12, -1.249284065951954e-15, -2.434054734957955e-16,  1.696851074650282e-18, -3.800881340655713e-21, -1.231137421556597e-22,
  6.323412620066141e-25,  7.954202627880276e-01, -6.008275435816249e-03,  1.899942325320072e-05,  7.084204596770090e-08, -1.113606184343131e-09,  3.135855069257351e-12,
  3.770404318992890e-14, -4.395920440598377e-16,  3.986420548609059e-19,  1.989875321530018e-20, -2.399317805857595e-22, -3.862577150640758e-25,  9.569140423104168e-01,
 -6.707302970175383e-03,  1.285017452035758e-05,  1.578953039646648e-07, -1.219041805937631e-09, -2.999686546362931e-12,  8.736170118320933e-14, -2.792935994083978e-16,
 -4.944198040121012e-18,  4.162282298753180e-20,  4.212460300566239e-23, -4.484294472456301e-24,  1.132112532358174e+00, -7.158652410265537e-03,  1.940295007359362e-06,
  2.440961345691249e-07, -6.786560664909484e-10, -1.357322520620566e-11,  8.898905788348171e-14,  7.218265280237460e-16, -1.028901803852493e-17, -3.211047954762320e-20,
  9.171390814476379e-22, -1.876082855697996e-24,  1.318456943984034e+00, -7.191250842881836e-03, -1.388348803509116e-05,  2.806248275504921e-07,  8.685571067570003e-10,
 -2.126883045794643e-11, -6.457964850733334e-14,  1.959615321374331e-15,  4.222772707596647e-18, -2.133160914645127e-19, -3.971451588984688e-22,  2.204276555209551e-23,
  1.510643020663766e+00, -6.584455629868200e-03, -3.222961206540705e-05,  1.856930993039373e-07,  2.991624910545548e-09, -6.439624032146240e-12, -3.248618089847827e-13,
 -3.953841963230740e-16,  3.600138319798119e-17,  1.540983975833658e-19, -4.254672466200699e-21, -3.609279112504230e-23,  1.698204642163038e+00, -5.130751284569567e-03,
 -4.514234804969864e-05, -9.312888171533282e-08,  3.055277191897267e-09,  3.579549107357734e-11, -5.453472938549442e-14, -5.178639048974469e-15, -3.968893539355331e-17,
  3.798971665262737e-19,  9.296820703568928e-21,  2.468404613460369e-23,  1.861886364805618e+00, -2.886687629692820e-03, -3.883670793139338e-05, -3.564893671348390e-07,
 -1.435773887828102e-09,  2.037147990777159e-11,  5.059545990745015e-13,  5.021981051921762e-15,  1.919641541546312e-18, -8.009680112168996e-19, -1.389013692640551e-20,
 -9.688200527033736e-23,  1.971637512397182e+00, -6.833560189551018e-04, -1.199065708374189e-05, -1.797044547004147e-07, -2.392197362798152e-09, -2.832605185123131e-11,
 -2.894987224520657e-13, -2.303480377095574e-15, -7.868085534996662e-18,  1.812571853405210e-19,  5.374244639078555e-21,  9.302721278643835e-23,  1.692264654967964e-03,
 -1.566802081102985e-05,  1.086733703371848e-07, -6.704648488337460e-10,  3.862079547631532e-12, -2.151950441135624e-14,  1.134413799859683e-16, -6.360629872815985e-19,
  2.601734571876235e-21, -2.350748437338252e-23,  2.445033770315955e-26,  7.083851259267935e-28,  1.524052723572960e-02, -1.407678556668964e-04,  9.702288035737418e-07,
 -5.915636659984470e-09,  3.342876599788825e-11, -1.811476390760324e-13,  9.157582484405551e-16, -4.915456634858082e-18,  1.753956696696895e-20, -1.718207950010809e-22,
 -4.641404641323094e-26,  8.071586079718286e-27,  4.239111061537898e-02, -3.896312393465684e-04,  2.650882718472272e-06, -1.576790657870897e-08,  8.548332029204372e-11,
 -4.348410145118858e-13,  1.982831714839726e-15, -9.474528560811604e-18,  1.958067620560745e-20, -2.909244459632105e-22, -1.301741695716440e-24,  2.928659546101740e-26,
  8.325182626693151e-02, -7.594208771953771e-04,  5.062342626349164e-06, -2.892364451900306e-08,  1.459657755753817e-10, -6.580040977896297e-13,  2.358182199712355e-15,
 -7.856964764656557e-18, -3.034439182986385e-20, -1.827847176736329e-22, -4.634013336780317e-24,  6.688169157892836e-26,  1.379833149898467e-01, -1.245442928302376e-03,
  8.063389123310019e-06, -4.336137768443696e-08,  1.941769573456084e-10, -6.825638414011840e-13,  9.283999904423073e-16,  5.662707449074659e-18, -1.509244209258903e-19,
  1.025371049303895e-22, -8.751104178133145e-24,  1.070785395248449e-25,  2.067967644884529e-01, -1.840542672742745e-03,  1.144839428184764e-05, -5.627279533553643e-08,
  2.037194450598806e-10, -3.270942851652990e-13, -3.124524737174453e-15,  3.120530000468364e-17, -2.998632127451795e-19,  9.701341111463314e-24, -9.218575499515998e-24,
  1.226384218834428e-25,  2.899488323922477e-01, -2.534148334251917e-03,  1.493044428667200e-05, -6.399776866688555e-08,  1.447459453110215e-10,  5.488969603774567e-13,
 -9.624689288031523e-15,  5.721654243351732e-17, -3.418018871027597e-19, -1.504446383292208e-21, -1.252142557119430e-24,  1.115056842425330e-25,  3.877310893498879e-01,
 -3.310790821532549e-03,  1.811787814526698e-05, -6.201302304715856e-08, -1.114702909163921e-11,  1.952087738588120e-12, -1.644392294841343e-14,  5.538678102702308e-17,
 -6.690263070548963e-20, -5.217812465211110e-21,  1.076973471167766e-23,  1.713088235850374e-25,  5.004489457696175e-01, -4.147816877349462e-03,  2.048344993673238e-05,
 -4.508867250732812e-08, -2.809490811833584e-10,  3.606682490950671e-12, -1.847108784645210e-14, -1.700881324452476e-17,  6.564194075374188e-19, -9.628550714845450e-21,
 -1.151573330852418e-24,  5.209988957234049e-25,  6.283804465531844e-01, -5.011836788479934e-03,  2.132757355675149e-05, -7.868236788800220e-09, -6.510480188056733e-10,
  4.744387472505108e-12, -7.331455861365498e-15, -1.921865251147806e-16,  1.478907327761382e-18, -8.068008596158744e-21, -8.631938781757096e-23,  1.185669348607854e-24,
  7.716961148489883e-01, -5.853177467182068e-03,  1.974483918228215e-05,  5.357109874190915e-08, -1.042827091505812e-09,  3.895085888090517e-12,  2.566844628665513e-14,
 -4.172397231007128e-16,  9.411974414681166e-19,  1.030772908908001e-20, -2.294645920612670e-22,  1.026244119501907e-24,  9.303019600564637e-01, -6.597258012633785e-03,
  1.462627137677167e-05,  1.380216421284672e-07, -1.258788675463517e-09, -1.013339520983228e-12,  7.755194880894601e-14, -4.135681978165718e-16, -3.458934599200980e-18,
  3.983397978699605e-20, -1.164404677211198e-22, -2.389151089199740e-24,  1.103527231926791e+00, -7.131617876226664e-03,  4.795732340848410e-06,  2.311881543970356e-07,
 -9.273220021227222e-10, -1.123297927715574e-11,  1.044661936067770e-13,  3.809434659754650e-16, -1.081306461323732e-17,  2.034994616806468e-21,  7.742893180380325e-22,
 -4.009325821719081e-24,  1.289491422618722e+00, -7.288645290231271e-03, -1.044686739972579e-05,  2.910533552025614e-07,  4.321743463308358e-10, -2.215220000377557e-11,
 -8.983930702394590e-15,  1.970708491994530e-15, -3.508636039008039e-18, -2.098407088764002e-19,  5.634202634395303e-22,  2.108189876214788e-23,  1.483804769427584e+00,
 -6.832578085090766e-03, -2.971972577818416e-05,  2.321037698352023e-07,  2.784658908075703e-09, -1.423509305762829e-11, -3.192200404369398e-13,  8.099006867444344e-16,
  3.816995213868268e-17, -4.025226919700626e-20, -5.246675774277848e-21, -6.499595949991091e-24,  1.676953525729400e+00, -5.495475527374466e-03, -4.594333386824280e-05,
 -3.863997670277340e-08,  3.745674895479383e-09,  3.261835373379620e-11, -2.147430083095822e-13, -6.157150513146478e-15, -1.923978141916633e-17,  7.529833672327129e-19,
  8.795373652620616e-21, -5.203339783217512e-23,  1.849690628943351e+00, -3.214847825606674e-03, -4.323670219240265e-05, -3.754949939937485e-07, -8.956170995115020e-10,
  3.417805051725504e-11,  6.422870234658684e-13,  4.507454385215197e-15, -3.778734270019793e-17, -1.423258931650138e-18, -1.657665786404724e-20, -6.992365405404260e-24,
  1.968697601675891e+00, -7.886033859981958e-04, -1.439674047301285e-05, -2.229116346482624e-07, -3.033537738793770e-09, -3.606870986061144e-11, -3.561923543749086e-13,
 -2.400209699141183e-15,  3.690933853475395e-18,  4.981256226452464e-19,  1.102992141136959e-20,  1.701596331302291e-22,  1.631281831408957e-03, -1.482979745342076e-05,
  1.009848119317256e-07, -6.119726652083835e-10,  3.457518135159766e-12, -1.900199324309543e-14,  9.667194984609516e-17, -5.660397569645536e-19,  1.789752220698779e-21,
 -2.084663571716370e-23,  1.416749999820975e-25,  5.281815177004182e-27,  1.469254236865424e-02, -1.332811509876858e-04,  9.023345106371246e-07, -5.408611604732772e-09,
  3.001475050149334e-11, -1.607633133197653e-13,  7.850572552530350e-16, -4.452303826885391e-18,  1.148788710705833e-20, -1.571275410635839e-22,  1.077211232728058e-24,
  4.901226246318699e-26,  4.087383339538231e-02, -3.691584302543108e-04,  2.469595375026078e-06, -1.446725145427584e-08,  7.724121520578582e-11, -3.903756401544680e-13,
  1.724692367650440e-15, -9.021622168559033e-18,  8.705352481668989e-21, -2.912104807520193e-22,  2.106999841240694e-24,  1.426020043933511e-25,  8.029299680010960e-02,
 -7.202717489979230e-04,  4.728847075513332e-06, -2.669047455721454e-08,  1.333532408185845e-10, -6.041645573380781e-13,  2.123395437048294e-15, -8.960475855100807e-18,
 -3.910880405299999e-20, -2.579558853638929e-22,  2.496390547569016e-24,  2.910153631786086e-25,  1.331273352441867e-01, -1.182965374716135e-03,  7.561247132142447e-06,
 -4.036250183517845e-08,  1.807585257176943e-10, -6.589240058082353e-13,  1.019491380517854e-15,  8.386537657491178e-19, -1.516409901424827e-19, -6.560509540404980e-23,
  3.103523198599932e-24,  4.886512126290436e-25,  1.996135689146750e-01, -1.751601723233698e-03,  1.079244948904163e-05, -5.306941613180846e-08,  1.964928365283829e-10,
 -3.926840292855221e-13, -2.385472410905075e-15,  2.156223310473721e-17, -3.036582367537259e-19, -1.132759493257695e-22,  7.383135729792959e-24,  7.190342937067355e-25,
  2.800463189163132e-01, -2.417736546562674e-03,  1.417668972411363e-05, -6.160603879898873e-08,  1.535371263233589e-10,  3.358432641636089e-13, -8.183855715016631e-15,
  4.542329430269697e-17, -3.939437783861571e-19, -1.255631021925353e-21,  1.997293209087046e-23,  9.797835851563464e-25,  3.747730985835274e-01, -3.168824623015642e-03,
  1.737387209814505e-05, -6.189996360926943e-08,  2.407182733508756e-11,  1.575631657040581e-12, -1.495055607808349e-14,  5.035292943966760e-17, -2.428697677093252e-19,
 -4.369173546363897e-21,  4.012888872730495e-23,  1.342166714820995e-24,  4.841818858655275e-01, -3.986184627260405e-03,  1.991771679484941e-05, -4.903099822019096e-08,
 -2.132761570760989e-10,  3.159715856490740e-12, -1.870508678467225e-14, -1.495633643684156e-18,  3.173146323954148e-19, -8.886238810045855e-21,  4.897606180384822e-23,
  2.002923991598744e-24,  6.086735020066236e-01, -4.841763819801378e-03,  2.117374965766551e-05, -1.753720036460707e-08, -5.583292762579939e-10,  4.508916333166301e-12,
 -1.209783891916091e-14, -1.500493444898596e-16,  1.142623089843308e-18, -1.004181463688869e-20,  1.666312136004839e-24,  3.129324765764255e-24,  7.486030014210303e-01,
 -5.692924871417780e-03,  2.029024944913272e-05,  3.753864357366791e-08, -9.596924237234773e-10,  4.374621885812471e-12,  1.445125588618451e-14, -3.828262308754223e-16,
  1.164361334472186e-18,  2.766916738626840e-21, -1.254459360066124e-22,  4.086572406229798e-24,  9.041569533899565e-01, -6.473966096976035e-03,  1.616133488171809e-05,
  1.178158711663153e-07, -1.261440118669982e-09,  6.977298086939207e-13,  6.463073434487434e-14, -5.023488003649176e-16, -2.123861935564641e-18,  3.424168948493614e-20,
 -1.283533316679941e-22,  2.415684987781033e-24,  1.075094684969960e+00, -7.082423391607197e-03,  7.474003001977242e-06,  2.146928756208647e-07, -1.126246757345931e-09,
 -8.636620589483401e-12,  1.103400554084317e-13,  4.174559749045632e-17, -1.022197273688712e-17,  2.987661088738389e-20,  6.386474278275445e-22, -1.106642554637838e-24,
  1.260191933212570e+00, -7.358165772501550e-03, -6.927346278926503e-06,  2.944305230704780e-07, -8.650710925778133e-12, -2.172512393890223e-11,  4.352970995221784e-14,
  1.743689630669195e-15, -1.043941140486520e-17, -1.693602974135090e-19,  1.448886564994191e-21,  1.958065127635110e-23,  1.456017618795008e+00, -7.058461776653546e-03,
 -2.667786985317498e-05,  2.739745965888264e-07,  2.425883447689898e-09, -2.148901335524633e-11, -2.799492250045218e-13,  1.967769343075942e-15,  3.297847255718387e-17,
 -2.442712880736814e-19, -4.652257930286531e-21,  3.483716829174719e-23,  1.654235094694894e+00, -5.863810627945740e-03, -4.602697018647297e-05,  2.617020913851989e-08,
  4.332294366095596e-09,  2.535348314576563e-11, -3.912369788770472e-13, -6.277235912503552e-15,  1.341280902063534e-17,  1.033245434924808e-18,  4.602856872048249e-21,
 -1.354804197510384e-22,  1.836110644461895e+00, -3.578951217804768e-03, -4.780324091148464e-05, -3.834790355365096e-07, -4.860791963534923e-11,  5.091892656127160e-11,
  7.429633938718683e-13,  2.352980669374413e-15, -1.005510361162339e-16, -2.037281620767951e-18, -1.248213802826231e-20,  2.187919489822502e-22,  1.965294657902442e+00,
 -9.153601442414832e-04, -1.738827094369450e-05, -2.777060715733222e-07, -3.845690135451441e-09, -4.539044066452204e-11, -4.183480521234694e-13, -1.893563730963874e-15,
  3.164953981101045e-17,  1.120383029217553e-18,  2.092655508293884e-20,  2.857524574055223e-22,  1.573533179270187e-03, -1.405038129129898e-05,  9.396091425503022e-08,
 -5.595719143982185e-10,  3.099426450007392e-12, -1.686622473086094e-14,  8.152290338555682e-17, -5.190930841736482e-19,  1.218085801555559e-21, -8.176453696458198e-24,
  5.590819681689829e-25,  1.450186893765459e-26,  1.417345527401115e-02, -1.263141621643301e-04,  8.402096855709291e-07, -4.953115713802801e-09,  2.697799413953438e-11,
 -1.433811762831559e-13,  6.647785104462256e-16, -4.161456816506161e-18,  7.313856594823297e-21, -4.969994189092507e-23,  4.900335468395557e-24,  1.321205894408431e-25,
  3.943564258545709e-02, -3.500756648972545e-04,  2.303152917851528e-06, -1.329168854960912e-08,  6.982729238342575e-11, -3.519915506658702e-13,  1.474614252502066e-15,
 -8.878887199453169e-18,  1.773135244445190e-21, -2.227781890549491e-23,  1.303289526974913e-23,  3.747557136826624e-25,  7.748559290029026e-02, -6.836867438659680e-04,
  4.420973273139719e-06, -2.465080807105604e-08,  1.217584797948514e-10, -5.563623554766501e-13,  1.853900098037499e-15, -1.030954933106187e-17, -4.247538263229984e-20,
  2.154523669818884e-22,  2.453833593521835e-23,  7.522841119633722e-25,  1.285134542509678e-01, -1.124364624355921e-03,  7.093819343117825e-06, -3.757446573898654e-08,
  1.678237895358641e-10, -6.347228394252641e-13,  9.751526764657477e-16, -3.974316895344004e-18, -1.448291031417813e-19,  6.876882235145094e-22,  4.026247796597628e-23,
  1.270368328253995e-24,  1.927758825799385e-01, -1.667756629394787e-03,  1.017421107335511e-05, -4.999128534442837e-08,  1.881098682259557e-10, -4.437883668798394e-13,
 -1.917532030119728e-15,  1.191634930653027e-17, -2.920709426687117e-19,  1.123451645941527e-21,  6.327960189073060e-23,  1.929283752530206e-24,  2.705975772531398e-01,
 -2.307237913344463e-03,  1.345234502943519e-05, -5.910597526326061e-08,  1.583853751383618e-10,  1.532347463185327e-13, -7.093574386984701e-15,  3.235789116940822e-17,
 -4.104124230172976e-19,  8.545170829411171e-22,  9.837463042073431e-23,  2.740457137003199e-24,  3.623710898922143e-01, -3.032796026338037e-03,  1.663436146395556e-05,
 -6.128174699787650e-08,  5.210542335332099e-11,  1.232727909653609e-12, -1.367007808750094e-14,  4.052483411094400e-17, -3.515852954852915e-19, -9.651053166039463e-22,
  1.478025317375445e-22,  3.773108974235623e-24,  4.685520287037431e-01, -3.829249747631787e-03,  1.931087671017613e-05, -5.196225083833588e-08, -1.545697118731202e-10,
  2.711161670643746e-12, -1.864898351709393e-14,  4.136378787519655e-18,  6.105775442769082e-20, -4.353232156588555e-21,  2.011151291707959e-22,  5.217382237946106e-24,
  5.896436883947261e-01, -4.673360729465476e-03,  2.091262469292405e-05, -2.576617610203191e-08, -4.713747806923950e-10,  4.171957521470262e-12, -1.583972954893347e-14,
 -1.189272518685528e-16,  8.248435312305668e-19, -6.160161252052509e-21,  2.231264615830487e-22,  7.341433047976806e-24,  7.261584392408407e-01, -5.529055303199104e-03,
  2.065152121819635e-05,  2.289878089440820e-08, -8.695778779012115e-10,  4.597100414535671e-12,  4.264278303434899e-15, -3.445038599064028e-16,  1.230295843366571e-18,
  2.851506574877657e-21,  1.725526617587998e-22,  9.969035797591997e-24,  8.785281420317937e-01, -6.339361783972101e-03,  1.745474721774384e-05,  9.782383827942048e-08,
 -1.233148436274464e-09,  2.073509439573716e-12,  4.979356491955025e-14, -5.512420534009557e-16, -9.378114106560171e-19,  3.350658753201417e-20,  1.554964965480877e-22,
  1.118006083613858e-23,  1.046900443500367e+00, -7.012644642220216e-03,  9.936963243832420e-06,  1.954346985135672e-07, -1.272589046554717e-09, -6.010225281319773e-12,
  1.071264241119586e-13, -2.631795736285841e-16, -8.677313610093469e-18,  5.686425699407491e-20,  7.842035175688575e-22,  8.967371970073789e-24,  1.230670763004307e+00,
 -7.399486804606017e-03, -3.409121609575644e-06,  2.908887074978688e-07, -4.289687772459667e-10, -2.013747167101472e-11,  8.684920699597360e-14,  1.324973531569364e-15,
 -1.528097835596358e-17, -9.356459514216217e-20,  2.370012543062474e-21,  2.362872944045983e-23,  1.427378633451029e+00, -7.258109048255171e-03, -2.317259903841600e-05,
  3.090061984564979e-07,  1.933955694152242e-09, -2.743669471724010e-11, -2.116341181706059e-13,  2.850257186916965e-15,  2.132540645155462e-17, -3.864152028770514e-19,
 -2.125873469012300e-21,  7.985926731767369e-23,  1.630047119474452e+00, -6.229556904178468e-03, -4.528210690548805e-05,  9.897486679042154e-08,  4.731630528828929e-09,
  1.393847693475976e-11, -5.552180871550356e-13, -5.230029403085006e-15,  5.233674917038540e-17,  1.082666150368431e-18, -2.375704775231666e-21, -1.680184994665834e-22,
  1.821000934734745e+00, -3.979713587467222e-03, -5.237286742474596e-05, -3.751259481225788e-07,  1.151240975433042e-09,  6.910641559027108e-11,  7.522245792908752e-13,
 -2.109846006031381e-15, -1.796647443645973e-16, -2.243838687707486e-18,  4.854779105713019e-21,  5.875662076853483e-22,  1.961332327059852e+00, -1.068914847945743e-03,
 -2.112169798167621e-05, -3.470605387348327e-07, -4.857424343593111e-09, -5.590888948085435e-11, -4.498194039557838e-13, -4.691049350125363e-17,  9.044334812849877e-17,
  2.248786883840332e-18,  3.647505517951120e-20,  4.189610144621095e-22,  1.518793658487893e-03, -1.332473535537428e-05,  8.753279554995237e-08, -5.125782455088177e-10,
  2.780512431428960e-12, -1.507976858579266e-14,  6.752879305054337e-17, -4.790464806252034e-19,  1.512678028736247e-21,  3.055748588168050e-23,  1.469210866874852e-24,
  2.693102894747983e-26,  1.368127562259955e-02, -1.198231087217843e-04,  7.832702537736013e-07, -4.543581071285300e-09,  2.426061487365181e-11, -1.287982784659046e-13,
  5.516103489137558e-16, -3.904913392287330e-18,  1.074850640726128e-20,  2.951680092365772e-22,  1.317040637505681e-23,  2.443853298016520e-25,  3.807120632773921e-02,
 -3.322699725346089e-04,  2.150129759055980e-06, -1.222893200144055e-08,  6.312127742684596e-11, -3.195739495126229e-13,  1.227609730337500e-15, -8.696720141012805e-18,
  1.515361587046827e-20,  9.200809313860553e-22,  3.640298457674682e-23,  6.892767181961538e-25,  7.481975369526732e-02, -6.494699086242274e-04,  4.136492747603653e-06,
 -2.278937362339441e-08,  1.110520536852950e-10, -5.154706134000880e-13,  1.549147860289310e-15, -1.127975137687235e-17, -7.432749877816522e-21,  2.040614824790195e-21,
  7.133489929492941e-23,  1.378508378016105e-24,  1.241267043861223e-01, -1.069372952637610e-03,  6.658621914859083e-06, -3.498961599341599e-08,  1.553517963051958e-10,
 -6.131412194820141e-13,  8.056483752716745e-16, -7.774403141574695e-18, -7.483120490893843e-20,  3.723832521366684e-21,  1.193662185436621e-22,  2.331715039530945e-24,
  1.862639154268181e-01, -1.588712046935639e-03,  9.592073462279986e-06, -4.705493892455254e-08,  1.787956981916650e-10, -4.868019083867237e-13, -1.704059783157881e-15,
  3.899851189240509e-18, -1.813073363801746e-19,  5.828181579604919e-21,  1.840524045388891e-22,  3.570747473066955e-24,  2.615794321192150e-01, -2.202412984856382e-03,
  1.275835027281224e-05, -5.655625969346938e-08,  1.598135706199448e-10, -7.560672695452310e-15, -6.359812807543863e-15,  2.075310823685652e-17, -2.735011238832875e-19,
  7.893745456868376e-21,  2.712069332347381e-22,  5.131873180284104e-24,  3.505014204927207e-01, -2.902646726051155e-03,  1.590473947774842e-05, -6.026828655683788e-08,
  7.356454397197609e-11,  9.170088201719916e-13, -1.268782220854338e-14,  3.024079902905714e-17, -2.312034088480576e-19,  9.230169920249493e-21,  3.864970145391430e-22,
  7.103189276626949e-24,  4.535400004891439e-01, -3.677295001773567e-03,  1.867420171556611e-05, -5.402585649719601e-08, -1.048120846100964e-10,  2.265119888229662e-12,
 -1.851532867293718e-14,  5.660449747654563e-18,  1.161127820768006e-19,  9.572329972392756e-21,  5.281189835280511e-22,  9.689960948203782e-24,  5.712827164196104e-01,
 -4.507418520544010e-03,  2.056086221709073e-05, -3.266239480693709e-08, -3.919920672178892e-10,  3.754701240128992e-12, -1.881707142651805e-14, -9.362601039181676e-17,
  8.569119831030899e-19,  1.092449638325964e-20,  6.746036113986916e-22,  1.324453941706153e-23,  7.043740579956167e-01, -5.362973509385187e-03,  2.084587044661869e-05,
  9.723433761795207e-09, -7.773701341450095e-10,  4.588304767744301e-12, -4.800090818464198e-15, -3.011654075021000e-16,  1.583783220080786e-18,  2.083866353548242e-20,
  7.858145575426941e-22,  1.798102454468807e-23,  8.534569365888071e-01, -6.195360131032183e-03,  1.851181541808788e-05,  7.848486169145301e-08, -1.180990561404507e-09,
  3.081131487764339e-12,  3.413508912427412e-14, -5.595909683527518e-16,  5.293224861634867e-19,  5.292694989996187e-20,  9.010890708385303e-22,  2.280825980732381e-23,
  1.019023209787254e+00, -6.924122457569390e-03,  1.215648868358984e-05,  1.742482871316679e-07, -1.367833373022963e-09, -3.556864794588512e-12,  9.622660495653828e-14,
 -5.010151211694299e-16, -5.930732556957685e-18,  1.005469657805062e-19,  1.515596850625542e-21,  2.468043202988732e-23,  1.201040173300665e+00, -7.412943613732311e-03,
  2.746999638418163e-08,  2.809280495720461e-07, -8.081655857172880e-10, -1.766556037966120e-11,  1.167392674678783e-13,  8.025902884629926e-16, -1.666569427875356e-17,
  2.505122082723291e-20,  3.646657749929233e-21,  3.524385459396932e-23,  1.397999605712042e+00, -7.428174864064592e-03, -1.929778995886562e-05,  3.353120003795940e-07,
  1.341236430930437e-09, -3.149437090114190e-11, -1.244379373940245e-13,  3.301300511939245e-15,  6.842960516476818e-18, -3.890062007624280e-19,  2.274144178124299e-21,
  1.176809042735770e-22,  1.604413738907567e+00, -6.585759711423243e-03, -4.363344467853645e-05,  1.761411741144092e-07,  4.866413398773518e-09, -9.197878324264896e-13,
 -6.725644989649859e-13, -2.963852220767673e-15,  8.791929018835358e-17,  8.522456023635003e-19, -8.631414262999064e-21, -9.762284710847140e-23,  1.804216193345690e+00,
 -4.416278170675021e-03, -5.671515709507747e-05, -3.447008710812283e-07,  2.705453053407241e-09,  8.572931629794035e-11,  6.011110799096220e-13, -9.056305529372427e-15,
 -2.496240786296614e-16, -1.413606523519741e-18,  3.942863296992592e-20,  9.623075620145721e-22,  1.956690361836570e+00, -1.255957324128650e-03, -2.579152183980186e-05,
 -4.343048136296614e-07, -6.081617907254235e-09, -6.630747626664871e-11, -3.962185753490124e-13,  4.461971282095273e-15,  2.023585776801967e-16,  4.102221083803526e-18,
  5.652483235522577e-20,  4.591054651155837e-22,  1.466857324039058e-03, -1.264834281870524e-05,  8.163910620490687e-08, -4.704191966702173e-10,  2.494071746910315e-12,
 -1.361308447568648e-14,  5.505375248862936e-17, -3.991974275747469e-19,  3.982950212894592e-21,  1.157993650355575e-22,  2.837565607201969e-24,  3.269591033627511e-26,
  1.321417926324152e-02, -1.137686309770752e-04,  7.309935235477096e-07, -4.175335967717063e-09,  2.180843698656217e-11, -1.168188085305177e-13,  4.495405349498894e-16,
 -3.266590063189612e-18,  3.369084765244084e-20,  1.062112827757644e-21,  2.558055231504420e-23,  2.964672324447348e-25,  3.677562272566452e-02, -3.156392299682028e-04,
  2.009236261520176e-06, -1.126860389555220e-08,  5.700515526026326e-11, -2.929364082904959e-13,  9.982402397151374e-16, -7.336868906431943e-18,  8.247480987404756e-20,
  3.053069679279487e-21,  7.137885919422835e-23,  8.353517192692892e-25,  7.228636757920662e-02, -6.174424213410783e-04,  3.873347302032994e-06, -2.109310275347081e-08,
  1.010890852566175e-10, -4.820172564927627e-13,  1.245688370069064e-15, -9.663656834509138e-18,  1.333621789283812e-19,  6.247306963034327e-21,  1.412612803336642e-22,
  1.670280094267983e-24,  1.199531497498830e-01, -1.017742148727628e-03,  6.253258815483345e-06, -3.260111621150360e-08,  1.432639592482643e-10, -5.965263644335454e-13,
  5.824047216472318e-16, -6.886263931351300e-18,  1.721954262298100e-19,  1.078860565014809e-20,  2.377286611153648e-22,  2.829483247571171e-24,  1.800590319031048e-01,
 -1.514186218104813e-03,  9.044250174597242e-06, -4.427428977635920e-08,  1.686571758349384e-10, -5.267918597325004e-13, -1.632515775682201e-15,  3.207478165507342e-18,
  2.024562610981065e-19,  1.670231894273961e-20,  3.656767660149139e-22,  4.348865126089342e-24,  2.529696767949319e-01, -2.103017478297714e-03,  1.209498591136852e-05,
 -5.400856150150255e-08,  1.581793830415259e-10, -1.538630700623138e-13, -5.840870213177512e-15,  1.911870253632263e-17,  2.655815078571378e-19,  2.379970586422463e-20,
  5.329798795757311e-22,  6.281676864622097e-24,  3.391407589831379e-01, -2.778280390680317e-03,  1.518913462909692e-05, -5.896079940525868e-08,  8.892565140020724e-11,
  6.222557571937650e-13, -1.186964280227859e-14,  3.180359990274091e-17,  4.619980984808634e-19,  3.170047490362405e-20,  7.495737732712595e-22,  8.728668840743314e-24,
  4.391254658386540e-01, -3.530519851610296e-03,  1.801724642539185e-05, -5.536450753493769e-08, -6.393640556463510e-11,  1.823559884180924e-12, -1.821877770716243e-14,
  1.986788863100816e-17,  9.536098134306588e-19,  4.025231318991473e-20,  1.022944755526873e-21,  1.189939356598539e-23,  5.535793905844542e-01, -4.344600496048933e-03,
  2.013367857355268e-05, -3.835888200051463e-08, -3.216081532896939e-10,  3.275311290558340e-12, -2.095140137371512e-14, -5.347548657303027e-17,  1.889476335480417e-18,
  5.092765221320427e-20,  1.348242634210790e-21,  1.618161129262037e-23,  6.832561474829792e-01, -5.195944345888819e-03,  2.089092456283796e-05, -1.989371674355919e-09,
 -6.874056443728706e-10,  4.378588660419626e-12, -1.235758880110689e-14, -2.307464302942856e-16,  3.108260629892262e-18,  6.995005282812250e-20,  1.701030603363601e-21,
  2.204011822646461e-23,  8.289772029673775e-01, -6.043814617468320e-03,  1.934242197960894e-05,  6.012123842936475e-08, -1.112426227364007e-09,  3.716326342622240e-12,
  1.905197306754452e-14, -5.030696498521645e-16,  3.351630344551243e-18,  1.117931927383200e-19,  2.090826610897387e-21,  2.916936838596546e-23,  9.915339352661469e-01,
 -6.818883297282811e-03,  1.411420119718415e-05,  1.519142261848714e-07, -1.417107519506374e-09, -1.433392496120112e-12,  8.018238260179156e-14, -6.188006307970577e-16,
 -9.196800205260519e-19,  1.869436058183241e-19,  2.880565009932426e-21,  3.473237101255180e-23,  1.171409844447012e+00, -7.399484957458511e-03,  3.309874843240789e-06,
  2.653297161763275e-07, -1.131943087389013e-09, -1.465249185957767e-11,  1.321004748140399e-13,  3.151135807063664e-16, -1.273338896764052e-17,  2.051805269944324e-19,
  5.414482349955438e-21,  4.218314950237091e-23,  1.368004076112293e+00, -7.566146159800722e-03, -1.516651256785503e-05,  3.516021329032343e-07,  6.890473453709018e-10,
 -3.335895384929522e-11, -3.085529870504748e-14,  3.324295489884650e-15, -4.217787043920246e-18, -1.886501458180712e-19,  7.811663723575433e-21,  1.262929133369866e-22,
  1.577387811216356e+00, -6.925056039760407e-03, -4.105608545962050e-05,  2.529574404513533e-07,  4.681634263608145e-09, -1.771347061328181e-11, -7.120639143971566e-13,
  2.678884281741233e-16,  1.117312253627431e-16,  4.638100654957478e-19, -9.633795021133910e-21,  5.900388659721401e-23,  1.785618657391463e+00, -4.885674280555838e-03,
 -6.053299934565128e-05, -2.870160169494238e-07,  4.538948278570408e-09,  9.617640604209740e-11,  2.307209225614380e-13, -1.746769985934176e-14, -2.614133337085936e-16,
  1.058896806673085e-18,  8.441919379958693e-20,  9.845308080396967e-22,  1.951218388903283e+00, -1.484894203176572e-03, -3.163229959119065e-05, -5.426790146023847e-07,
 -7.488319577610403e-09, -7.343278458498164e-11, -1.550993753826436e-13,  1.377319103024379e-14,  3.950989268454984e-16,  6.703333415684333e-18,  7.081038277086215e-20,
  7.394479023729455e-23,  1.417535357613508e-03, -1.201715194608274e-05,  7.622474500789460e-08, -4.326238358324537e-10,  2.234211426398913e-12, -1.240682038038490e-14,
  4.645897915132189e-17, -1.804975703455215e-19,  1.051167086523605e-20,  2.542360552540534e-22,  3.913598494307022e-24,  8.701834459900071e-27,  1.277049145513328e-02,
 -1.081153409200566e-04,  6.829078217736671e-07, -3.844534163955393e-09,  1.957334913485743e-11, -1.069625867913960e-13,  3.804662448344420e-16, -1.355291985781682e-18,
  9.321887731478072e-20,  2.311493650164384e-21,  3.534428798076723e-23,  7.937107899612723e-26,  3.554437848527736e-02, -3.000911645868723e-04,  1.879296213540156e-06,
 -1.040215250525113e-08,  5.137141426939430e-11, -2.710226339180330e-13,  8.506048463716836e-16, -2.320610802124522e-18,  2.518791098742380e-19,  6.545859715221623e-21,
  9.892649547269745e-23,  2.260107638121083e-25,  6.987700623990298e-02, -5.874413381495541e-04,  3.629621527721447e-06, -1.955125602328787e-08,  9.172931535029431e-11,
 -4.546352684925275e-13,  1.077230374749207e-15, -5.721565556428810e-19,  4.761804691200549e-19,  1.317382646487637e-20,  1.964408866884573e-22,  4.577968491457115e-25,
  1.159798094350034e-01, -9.692428660328334e-04,  5.875407372970013e-06, -3.040362669449479e-08,  1.314625896440417e-10, -5.838094966031016e-13,  5.395488657203155e-16,
  6.902186969290131e-18,  7.592254914898054e-19,  2.246179584785779e-20,  3.313950766209265e-22,  7.856151972695477e-25,  1.741436938789796e-01, -1.443912322186713e-03,
  8.528795340589361e-06, -4.166213857760023e-08,  1.577433469882255e-10, -5.634970193297724e-13, -1.339420077284172e-15,  2.248138836512060e-17,  1.109294403789172e-18,
  3.465962832106066e-20,  5.099474518143824e-22,  1.221095408560424e-24,  2.447470823770883e-01, -2.008807259508613e-03,  1.146194273680504e-05, -5.150971498518549e-08,
  1.537525741257800e-10, -2.857080722262566e-13, -5.025440402335378e-15,  4.594903673219975e-17,  1.567230267670074e-18,  4.993572705567389e-20,  7.418252299952345e-22,
  1.781260730245626e-24,  3.282662178235456e-01, -2.659572397293873e-03,  1.449050338366742e-05, -5.745355757116213e-08,  9.860810283019773e-11,  3.510202006458968e-13,
 -1.055519461779595e-14,  7.134089989603205e-17,  2.227920878329074e-18,  6.838668667524450e-20,  1.040515340615115e-21,  2.507346327098490e-24,  4.252874335823746e-01,
 -3.389054148549962e-03,  1.734786174297865e-05, -5.611920643359265e-08, -3.176804387844185e-11,  1.398078799419556e-12, -1.695544554264339e-14,  8.243088065069327e-17,
  3.255260594828280e-18,  9.032679730596777e-20,  1.421156610140802e-21,  3.509746157117235e-24,  5.365200950226169e-01, -4.185454972182207e-03,  1.964456977369064e-05,
 -4.300824382455459e-08, -2.612075840193133e-10,  2.763441669085560e-12, -2.124468777980740e-14,  4.804488947993682e-17,  4.851766505229882e-18,  1.173537633032524e-19,
  1.893876355450624e-21,  5.037373444103276e-24,  6.628062183670442e-01, -5.029092872766481e-03,  2.080389339057199e-05, -1.230536181870670e-08, -6.032532075199920e-10,
  4.018556902868735e-12, -1.694325777034770e-14, -7.606251503934788e-17,  7.067621189507443e-18,  1.551317601624956e-19,  2.454567104676114e-21,  7.470944955452943e-24,
  8.051155729147454e-01, -5.886486214603580e-03,  1.995960472918152e-05,  4.293735737134826e-08, -1.034587476337235e-09,  4.021017935238826e-12,  7.201681785055127e-15,
 -3.128895779664607e-16,  9.170481436597526e-18,  2.183816352391188e-19,  3.108069388299904e-21,  1.076962733136815e-23,  9.644952285556641e-01, -6.699064786732864e-03,
  1.580050619124379e-05,  1.291098581081040e-07, -1.427922706761694e-09,  2.868279760142462e-13,  6.363104139248200e-14, -5.154419382384907e-16,  8.231079022313917e-18,
  3.297428855551229e-19,  4.101496911750493e-21,  1.240110488017670e-23,  1.141884565067701e+00, -7.360599161608494e-03,  6.376058673006045e-06,  2.450487613667200e-07,
 -1.392777410050164e-09, -1.141384043823683e-11,  1.366475337303507e-13,  7.102816679159048e-17, -1.040801734205752e-18,  4.537323859472768e-19,  6.778378255555195e-21,
  9.049021484167511e-24,  1.337523746637657e+00, -7.670464748305740e-03, -1.090319998788608e-05,  3.572805382789605e-07,  2.190573958861404e-11, -3.300162904673263e-11,
  5.980462957753407e-14,  3.151253976357494e-15, -4.142274332638212e-18,  2.229904764577817e-19,  1.229545665838951e-20,  5.995911718114115e-23,  1.549051669157327e+00,
 -7.240122276063031e-03, -3.758583308614006e-05,  3.241108939260657e-07,  4.159221455824221e-09, -3.429602814626449e-11, -6.524847142947935e-13,  4.043843850702870e-15,
  1.225194090336619e-16,  1.729098883277184e-19, -4.086654598820603e-21,  1.685248578168456e-22,  1.765087556132209e+00, -5.382333199749413e-03, -6.347749535439646e-05,
 -1.988863628975211e-07,  6.473588061296704e-09,  9.495976760745296e-11, -3.646595703668416e-13, -2.449498530441591e-14, -1.534349666635841e-16,  5.138354457548661e-18,
  1.137007332870942e-19,  1.770144513426893e-22,  1.944728428292958e+00, -1.766150181483713e-03, -3.891202046152325e-05, -6.742837519338542e-07, -8.954560922723476e-09,
 -7.085633582691394e-11,  4.476806335508283e-13,  3.081239256447426e-14,  6.853110379777049e-16,  9.263679176966662e-18,  4.601205656788195e-20, -1.483101122791336e-21,
  1.370654299900890e-03, -1.142753069474261e-05,  7.123974822504668e-08, -3.988018773199909e-10,  1.997052072779321e-12, -1.130490544471255e-14,  4.770473416992483e-17,
  3.321906848993465e-19,  2.240274891765156e-20,  3.985486460305362e-22,  2.672514555624703e-24, -7.815374561301356e-26,  1.234867173783389e-02, -1.028314514303029e-04,
  6.385834467930601e-07, -3.547984220950361e-09,  1.752443942417030e-11, -9.786305547283021e-14,  3.987277129912386e-16,  3.228985831363432e-18,  2.011706435652090e-19,
  3.615162007855032e-21,  2.414335777469900e-23, -7.064869287312938e-25,  3.437331119528521e-02, -2.855425299548128e-04,  1.759226742974308e-06, -9.622466958362349e-09,
  4.615557430208846e-11, -2.502320084910128e-13,  9.393210438288694e-16,  1.026548886139239e-17,  5.567980989885689e-19,  1.019662844159229e-20,  6.762105933559461e-23,
 -1.980295061285741e-24,  6.758386326089612e-02, -5.593185576425172e-04,  3.403517033675626e-06, -1.815489223498455e-08,  8.290480385508035e-11, -4.267596785569851e-13,
  1.356612424595932e-15,  2.375468220632638e-17,  1.088056193852920e-18,  2.042826029482997e-20,  1.344305680167641e-22, -3.936698200580317e-24,  1.121945831313275e-01,
 -9.236641055625492e-04,  5.522801547170187e-06, -2.839280563758737e-08,  1.199492384156606e-10, -5.649571599628372e-13,  1.212693043427121e-15,  4.666852900075882e-17,
  1.800136834991068e-18,  3.470979756376375e-20,  2.271980971952479e-22, -6.638400287642204e-24,  1.685013984247623e-01, -1.377639702375142e-03,  8.043616266757820e-06,
 -3.922984881247220e-08,  1.462290702198435e-10, -5.827843956423203e-13,  2.593921486314050e-18,  8.184212163474804e-17,  2.714665631179634e-18,  5.352353009715187e-20,
  3.506055046430206e-22, -1.018162896589142e-23,  2.368913881025359e-01, -1.919542837419137e-03,  1.085837810047503e-05, -4.910137758318533e-08,  1.469736039774594e-10,
 -3.833466918820873e-13, -2.725764464453373e-15,  1.305376971083766e-16,  3.885433131819407e-18,  7.740705576858748e-20,  5.122588582974030e-22, -1.470489008455477e-23,
  3.178554482793841e-01, -2.546378871386415e-03,  1.381071643279638e-05, -5.583257260070182e-08,  1.033093984961105e-10,  1.322845332982452e-13, -7.132281177987366e-15,
  1.899879325884655e-16,  5.420508859162472e-18,  1.069811562496045e-19,  7.232304357685596e-22, -2.039477651246809e-23,  4.120045081441894e-01, -3.252971631087899e-03,
  1.667223539154273e-05, -5.642487356730789e-08, -7.613804086801705e-12,  1.034013438320826e-12, -1.262205637596012e-14,  2.495144775552296e-16,  7.506497693975755e-18,
  1.431846081012569e-19,  9.971307220445293e-22, -2.748255191847316e-23,  5.200892246357530e-01, -4.030429833970433e-03,  1.910513118275649e-05, -4.677228939999499e-08,
 -2.108193627003916e-10,  2.291684264471504e-12, -1.698643379313192e-14,  2.854372959805580e-16,  1.041235870516857e-17,  1.881224020902057e-19,  1.345483434504708e-21,
 -3.623179143792582e-23,  6.430215501839974e-01, -4.863410504695764e-03,  2.060089670611834e-05, -2.133672958068280e-08, -5.269644993981767e-10,  3.617759968834211e-12,
 -1.493156153086177e-14,  2.583721393136073e-16,  1.439194528362884e-17,  2.474740402986685e-19,  1.767950584023506e-21, -4.698123799357344e-23,  7.818918558098027e-01,
 -5.725023630465874e-03,  2.037821042912821e-05,  2.703443103224406e-08, -9.529429903498661e-10,  4.130017324773068e-12,  3.903239823812918e-15,  1.303917414680407e-16,
  1.924472962097823e-17,  3.359692029370571e-19,  2.254051517380570e-21, -6.061357940096614e-23,  9.379610427620562e-01, -6.566850905593676e-03,  1.721319020320877e-05,
  1.063877422919198e-07, -1.407879201693417e-09,  1.682655037109665e-12,  5.489724089012600e-14, -3.052350449757142e-17,  2.300623983331235e-17,  4.837347372338092e-19,
  2.923351921193101e-21, -8.073467354574183e-23,  1.112562252828954e+00, -7.298223374683723e-03,  9.175983385997564e-06,  2.211171168299813e-07, -1.588046325548396e-09,
 -8.097242075082440e-12,  1.409957761592240e-13,  3.506216449484897e-16,  2.002364768067519e-17,  7.041886615607413e-19,  4.828128735622037e-21, -1.174590040424600e-22,
  1.306694532861115e+00, -7.740584431540784e-03, -6.635177440329335e-06,  3.524586141746194e-07, -6.166599866653659e-10, -3.051158370748157e-11,  1.480845744642065e-13,
  3.244543655997936e-15,  1.295249731639664e-17,  7.189589899231535e-19,  1.099746474511923e-20, -1.475704554115084e-22,  1.519515960871940e+00, -7.524177743690372e-03,
 -3.332248405356834e-05,  3.843667660539718e-07,  3.328187077718534e-09, -4.814892491848345e-11, -4.835761249298312e-13,  8.046365763450768e-15,  1.274623650957073e-16,
  1.390696171788833e-19,  1.303131072481027e-21,  1.593522290009595e-23,  1.742530138859640e+00, -5.897798832318567e-03, -6.518218992444653e-05, -8.083158443018211e-08,
  8.227682520691497e-09,  7.762500186837724e-11, -1.085232524619644e-12, -2.557895388212002e-14,  1.111363612891811e-16,  9.372637405582278e-18,  8.472878821532192e-20,
 -1.636729591942303e-21,  1.936986415912098e+00, -2.112349863313592e-03, -4.790701988904010e-05, -8.279680074361691e-07, -1.018021368510168e-08, -4.696419850209484e-11,
  1.669123448582471e-12,  5.825355666055526e-14,  1.028030472649403e-15,  8.861898760954811e-18, -9.440040488447704e-20, -5.382758206335415e-21,  1.326054448899810e-03,
 -1.087622875796366e-05,  6.663859549490123e-08, -3.685908267610691e-10,  1.783633446209127e-12, -9.953584731037224e-15,  6.929530052141690e-17,  1.290015417713251e-18,
  3.745342849823148e-20,  3.923511032064345e-22, -4.229921808307690e-24, -2.488841489404308e-25,  1.194730015823873e-02, -9.788846561358149e-05,  5.976271958985382e-07,
 -3.282685919963302e-09,  1.567448430591907e-11, -8.635621885030645e-14,  5.996945292041396e-16,  1.185144565304447e-17,  3.376563076190858e-19,  3.558142181365674e-21,
 -3.828258194428179e-23, -2.251338665033748e-24,  3.325857462894949e-02, -2.719184118556796e-04,  1.648027253171028e-06, -8.922651579800621e-09,  4.141154908545650e-11,
 -2.218732544260843e-13,  1.533807005247657e-15,  3.424353936466256e-17,  9.415919227747000e-19,  1.003272486069226e-20, -1.075136378344006e-22, -6.318264447565462e-24,
  6.539969652749839e-02, -5.329399418338605e-04,  3.193342064848304e-06, -1.689462198506819e-08,  7.477239145659295e-11, -3.815790700252004e-13,  2.624565243914755e-15,
  7.090995244709624e-17,  1.858649698230117e-18,  2.009763766117771e-20, -2.141189954093543e-22, -1.258019196932586e-23,  1.085861786251959e-01, -8.808127673896046e-04,
  5.193236786208492e-06, -2.656185295845390e-08,  1.090856977099558e-10, -5.124633694593772e-13,  3.521867367719334e-15,  1.252317117489024e-16,  3.109296007867715e-18,
  3.416379852240828e-20, -3.612627599165791e-22, -2.124998746878783e-23,  1.631166109967759e-01, -1.315134911820232e-03,  7.586514050302546e-06, -3.698244652781291e-08,
  1.348181747509627e-10, -5.435574904885295e-13,  3.812619367544162e-15,  2.010383378344181e-16,  4.734364761788632e-18,  5.275900342422160e-20, -5.529716987632613e-22,
 -3.264570542279422e-23,  2.293832747472003e-01, -1.834993300384301e-03,  1.028301059124383e-05, -4.681316023940920e-08,  1.390324724052163e-10, -3.881784272671993e-13,
  3.107418905778583e-15,  3.016651385088826e-16,  6.810281264361543e-18,  7.652103723662971e-20, -7.941745591652238e-22, -4.722514588501199e-23,  3.078867008538803e-01,
 -2.438544852029608e-03,  1.315070633836244e-05, -5.416554876239718e-08,  1.047911857820595e-10,  4.824896944520168e-14,  1.221140246724188e-15,  4.282232280007280e-16,
  9.472405343981833e-18,  1.062305059769706e-19, -1.091320064407706e-21, -6.563602152401834e-23,  3.992550881264650e-01, -3.122302734079953e-03,  1.599504292029473e-05,
 -5.639478459654195e-08,  1.076432900763085e-11,  8.470276023812560e-13, -1.461045642898626e-15,  5.766215056563774e-16,  1.294693278485254e-17,  1.429916812511493e-19,
 -1.454700915032241e-21, -8.878837259985256e-23,  5.042695561814798e-01, -3.879887841285452e-03,  1.852507504834982e-05, -4.979740225014974e-08, -1.681928684129283e-10,
  2.024097894525412e-12, -3.261207836715038e-15,  7.330503090335521e-16,  1.758176774735962e-17,  1.888745055181668e-19, -1.905054367035071e-21, -1.179674262339800e-22,
  6.238957056771931e-01, -4.699765439522730e-03,  2.029660122244547e-05, -2.920528551518202e-08, -4.573016265445943e-10,  3.406847776035061e-12,  1.559135530337122e-16,
  8.694657493694162e-16,  2.382788394046179e-17,  2.488497642909450e-19, -2.488804670843818e-21, -1.550625033848106e-22,  7.593195096738280e-01, -5.560953172381626e-03,
  2.061389010108258e-05,  1.245587705561071e-08, -8.687013286108541e-10,  4.348726273800425e-12,  1.807774269869409e-14,  9.498188792015828e-16,  3.199309074057480e-17,
  3.358781812363936e-19, -3.300729176780592e-21, -2.032566488951106e-22,  9.119765989899697e-01, -6.424418687383715e-03,  1.835603241714833e-05,  8.420390428322787e-08,
 -1.360619528588558e-09,  3.089799099157180e-12,  6.707452445469145e-14,  9.971463751885862e-16,  4.123806516474607e-17,  4.808622790055960e-19, -4.446702421865368e-21,
 -2.695904555994978e-22,  1.083532355461076e+00, -7.214644924941528e-03,  1.167220065986380e-05,  1.946016265967692e-07, -1.714879517870146e-09, -4.498690466107848e-12,
  1.637838024370873e-13,  1.420394695476709e-15,  4.702189799998164e-17,  7.280144304634022e-19, -5.502736341001188e-21, -3.728801612306932e-22,  1.275652522980680e+00,
 -7.776960534214370e-03, -2.484298416823648e-06,  3.379353668653347e-07, -1.183639460181051e-09, -2.579402016220493e-11,  2.491289306411519e-13,  4.139508978503586e-15,
  4.428522218340251e-17,  9.272118181699010e-19, -3.426165851885297e-21, -5.364722978882086e-22,  1.488916478903227e+00, -7.771479613488644e-03, -2.842416841838261e-05,
  4.293683038152046e-07,  2.269802150449576e-09, -5.658538245132071e-11, -2.003783974239165e-13,  1.220921687353985e-14,  1.324022729092026e-16,  7.026243100903999e-20,
 -8.839022668868083e-21, -5.443774223508743e-22,  1.717893187277930e+00, -6.420790707314054e-03, -6.531630177530708e-05,  6.158410134000796e-08,  9.465185432916385e-09,
  4.371770816704959e-11, -1.697274454717312e-12, -1.614993385961215e-14,  4.862299090256703e-16,  1.066619871550776e-17, -3.603698155476129e-20, -3.806666305799178e-21,
  1.927703596760938e+00, -2.538171712694414e-03, -5.884219866814405e-05, -9.955642918196613e-07, -1.056646357225905e-08,  1.664067244379971e-11,  3.800352439838147e-12,
  9.495814771540280e-14,  1.205838698415103e-15, -1.464473323107397e-18, -4.711923207746141e-19, -1.209200150454120e-20,  1.283588404287557e-03, -1.036034167637031e-05,
  6.238049747627689e-08, -3.415400355710879e-10,  1.604867529520663e-12, -7.710336500525953e-15,  1.239429837651974e-16,  2.656691956099089e-18,  4.532154403366194e-20,
 -5.871886364589124e-23, -1.986460129844049e-23, -4.572447771045413e-25,  1.156506469992769e-02, -9.326087903746326e-05,  5.596856175363165e-07, -3.044793002217082e-09,
  1.412492231256065e-11, -6.665813001663326e-14,  1.098665784075554e-15,  2.418268004591405e-17,  4.091382915314237e-19, -5.231371152491811e-22, -1.797276367968401e-22,
 -4.137017078000216e-24,  3.219660677211242e-02, -2.591515395368114e-04,  1.544792032098849e-06, -8.293175311836303e-09,  3.743871811794235e-11, -1.698624261134853e-13,
  2.959221444606064e-15,  6.868418350938474e-17,  1.143828675183556e-18, -1.425414521547162e-21, -5.045681839692458e-22, -1.161520969641490e-23,  6.331777422255552e-02,
 -5.081843629748348e-04,  2.997546147243792e-06, -1.575509021507745e-08,  6.796878905661572e-11, -2.874637599982038e-13,  5.532498823418753e-15,  1.390372102557005e-16,
  2.265633468360636e-18, -2.721845758821429e-21, -1.004954930499682e-21, -2.314058071605425e-23,  1.051440415511573e-01, -8.405129130522400e-04,  4.884647201735723e-06,
 -2.489247575812807e-08,  1.000281067184499e-10, -3.736319691627213e-13,  8.574160847650493e-15,  2.394682845654714e-16,  3.804762650919248e-18, -4.372047218769128e-21,
 -1.697659294096716e-21, -3.911680650451095e-23,  1.579746956430996e-01, -1.256182069389844e-03,  7.155330609028058e-06, -3.490511102550781e-08,  1.254131251520685e-10,
 -3.658625974720946e-13,  1.179908548782589e-14,  3.753541755194185e-16,  5.814017622784141e-18, -6.373084420537373e-21, -2.606986172530590e-21, -6.014484243762039e-23,
  2.222043245783142e-01, -1.754938978056904e-03,  9.734365692287264e-06, -4.464335269219326e-08,  1.328357719992565e-10, -1.854025304766833e-13,  1.494841457058053e-14,
  5.527585319568016e-16,  8.383284316858619e-18, -8.808048573440439e-21, -3.767061742012890e-21, -8.709040378612924e-23,  2.983388565428328e-01, -2.335910537889630e-03,
  1.251082942233971e-05, -5.247484359902739e-08,  1.072108634943329e-10,  2.587657746722902e-13,  1.793227086205505e-14,  7.774577309133649e-16,  1.166293273079831e-17,
 -1.189847653763939e-20, -5.225887065842364e-21, -1.211896335517506e-22,  3.870175177261216e-01, -2.997045106507391e-03,  1.531990889600295e-05, -5.608254909895081e-08,
  2.892199985009063e-11,  1.056664311451047e-12,  2.112749198389082e-14,  1.053062032292964e-15,  1.589953381910155e-17, -1.600816805574866e-20, -7.052945702573704e-21,
 -1.642163369881035e-22,  4.890425608980404e-01, -3.734120176116883e-03,  1.791270381781089e-05, -5.216068957219686e-08, -1.264786349323341e-10,  2.261181792264144e-12,
  2.599050787885880e-14,  1.377793437060853e-15,  2.148346143968483e-17, -2.141236538917557e-20, -9.354363788820455e-21, -2.187578850584668e-22,  6.054190012201179e-01,
 -4.538913642030716e-03,  1.990451257867103e-05, -3.596688876775116e-08, -3.866785755437199e-10,  3.796108221363438e-12,  3.629661827123948e-14,  1.740346196178857e-15,
  2.898580265259124e-17, -2.725292233737555e-20, -1.230420448790711e-20, -2.887178636705358e-22,  7.374061412643688e-01, -5.395673639212165e-03,  2.068294182201709e-05,
 -7.127206815730595e-10, -7.745935400835461e-10,  5.227188581783422e-12,  6.052484875937566e-14,  2.120926498260715e-15,  3.907062521660454e-17, -2.808239716855558e-20,
 -1.620659917865622e-20, -3.804295276184330e-22,  8.865785047569127e-01, -6.273893405716430e-03,  1.923821519318313e-05,  6.302818821139452e-08, -1.279632144817603e-09,
  5.197861956091412e-12,  1.156719472642847e-13,  2.532004465394473e-15,  5.184723424501318e-17, -4.864678248075225e-21, -2.158542182765638e-20, -5.058647951941529e-22,
  1.054874655012099e+00, -7.112398258677197e-03,  1.384055937727171e-05,  1.666742073611925e-07, -1.761350646460504e-09,  1.012031562312538e-13,  2.280440113806759e-13,
  3.264163809818792e-15,  6.444568071633221e-17,  8.411615037963087e-20, -2.905975749535591e-20, -6.933666601920275e-22,  1.244530111860981e+00, -7.780972861495360e-03,
  1.441440301297558e-06,  3.152376211647952e-07, -1.629389609539488e-09, -1.823531707225675e-11,  3.893955736115641e-13,  6.009637158224922e-15,  6.822097415618554e-17,
  1.763749727654752e-19, -3.760560857031502e-20, -1.009201673995872e-21,  1.457409162559368e+00, -7.977732991413725e-03, -2.309170219896652e-05,  4.564950240063522e-07,
  1.120165077625113e-09, -5.681491827255937e-11,  2.003500968359581e-13,  1.635753014273747e-14,  1.206610467709378e-16, -9.985499209340852e-19, -5.060475270138624e-20,
 -1.357503424512199e-21,  1.691173347380194e+00, -6.937739102139137e-03, -6.364728471135617e-05,  2.176909185908555e-07,  9.906093942020768e-09, -3.488646676837517e-13,
 -1.877943542646601e-12,  4.918129148248350e-15,  7.995927826521492e-16,  5.425621676650562e-18, -2.338873244355408e-19, -4.865048584928725e-21,  1.916529794072151e+00,
 -3.059508175709785e-03, -7.177366059801704e-05, -1.156029213647078e-06, -9.084435924323281e-09,  1.439085219515735e-10,  6.958894089114712e-12,  1.278994561634946e-13,
  6.671498089356601e-16, -3.291780872328345e-17, -1.139991459728192e-18, -1.711543047221646e-20,  1.243119770806360e-03, -9.877265626699459e-06,  5.843159507047821e-08,
 -3.169060340360511e-10,  1.487247923789933e-12, -3.687632202049431e-15,  2.169828700829007e-16,  3.878010695425918e-18,  2.370806843920529e-20, -1.289756071780566e-21,
 -4.194146857348379e-23, -4.839355646316663e-25,  1.120075005302185e-02, -8.892579294626744e-05,  5.244654319574728e-07, -2.827770832544608e-09,  1.311764759548626e-11,
 -3.076158613509323e-14,  1.944176142193946e-15,  3.520812405877356e-17,  2.138769029056125e-19, -1.166147471753104e-20, -3.794997359636352e-22, -4.379954929158358e-24,
  3.118410107710911e-02, -2.471813219423800e-04,  1.448770397120895e-06, -7.716748878044924e-09,  3.492804256963305e-11, -7.183979798104602e-14,  5.353220382199218e-15,
  9.950856991119816e-17,  5.971811341132822e-19, -3.269798075987280e-20, -1.065606355807530e-21, -1.230547197422007e-23,  6.133182571384527e-02, -4.849421335335943e-04,
  2.814847674261499e-06, -1.470490267624115e-08,  6.390342962244779e-11, -1.001944281341457e-13,  1.035833161019325e-14,  2.000957048774771e-16,  1.180965996405519e-18,
 -6.501950263111004e-20, -2.123148803449532e-21, -2.454052579065354e-23,  1.018582901945267e-01, -8.026038496089763e-04,  4.595336621293498e-06, -2.333810635096100e-08,
  9.522487894576731e-11, -7.433424651915103e-14,  1.684613117062151e-14,  3.420193356660616e-16,  1.980179982293547e-18, -1.096478938645970e-19, -3.588892964751866e-21,
 -4.154019868722295e-23,  1.530618474416374e-01, -1.200581194383201e-03,  6.748327958809696e-06, -3.293771226144855e-08,  1.218836573339659e-10,  6.339183543794080e-14,
  2.470406144654848e-14,  5.321045142627915e-16,  3.023322113441594e-18, -1.681352442850289e-19, -5.516930984833955e-21, -6.398375958411892e-23,  2.153369764537116e-01,
 -1.679170928994691e-03,  9.211354130080717e-06, -4.252235986279968e-08,  1.341200086169788e-10,  3.878726176115970e-13,  3.388052862592208e-14,  7.789000495030301e-16,
  4.362757280956849e-18, -2.427701210389593e-19, -7.984372463520785e-21, -9.285417810003372e-23,  2.891914415012221e-01, -2.238312948642208e-03,  1.189169207943258e-05,
 -5.068654480193404e-08,  1.186633518330147e-10,  9.904297865555436e-13,  4.451026317802425e-14,  1.092381789357369e-15,  6.092076991740139e-18, -3.368966645134409e-19,
 -1.110079402352301e-20, -1.295652477865194e-22,  3.752702070833524e-01, -2.877168091907686e-03,  1.465051128309318e-05, -5.541214987731512e-08,  5.780083004588692e-11,
  1.972198803384526e-12,  5.717491784762121e-14,  1.483140066463764e-15,  8.374233420764815e-18, -4.553898969619779e-19, -1.502450999816138e-20, -1.761675548030187e-22,
  4.743886755692482e-01, -3.593352932998337e-03,  1.727627488317120e-05, -5.377419112775242e-08, -7.150495680191844e-11,  3.421792581574698e-12,  7.344731642888570e-14,
  1.960670671821330e-15,  1.148326970564653e-17, -6.053091839339241e-19, -1.999216973129250e-20, -2.356938821589384e-22,  5.875789449891170e-01, -4.381502961287585e-03,
  1.943849722559107e-05, -4.148063411949498e-08, -2.975747225548422e-10,  5.351846287965310e-12,  9.703502292605181e-14,  2.530729487539255e-15,  1.585039887876853e-17,
 -7.966075776181335e-19, -2.637608910586217e-20, -3.127785528163133e-22,  7.161540334214710e-01, -5.230446436206531e-03,  2.060379495630052e-05, -1.216827234312630e-08,
 -6.500063845227163e-10,  7.527434986400452e-12,  1.361697020703075e-13,  3.194973650531754e-15,  2.204323775083386e-17, -1.042233069857629e-18, -3.480120741134290e-20,
 -4.149218517458347e-22,  8.617950531536355e-01, -6.117301377196755e-03,  1.987570179575541e-05,  4.356397618387232e-08, -1.141228158497613e-09,  9.004966713399629e-12,
  2.083141114962754e-13,  3.975193060425466e-15,  3.034233419193441e-17, -1.355646653870719e-18, -4.638167726683813e-20, -5.557162512605852e-22,  1.026658504653231e+00,
 -6.994150252109287e-03,  1.567268515181668e-05,  1.388413711742743e-07, -1.696010866360600e-09,  6.897275136202093e-12,  3.468019349228836e-13,  5.086827840712716e-15,
  3.861667029093002e-17, -1.746484944476394e-18, -6.308281892409694e-20, -7.654662256894141e-22,  1.213452583813132e+00, -7.754777244001271e-03,  5.057646781654494e-06,
  2.868191138387884e-07, -1.885756418717701e-09, -6.630677279549084e-12,  5.865798445293466e-13,  7.911170407560735e-15,  3.593165656726984e-17, -2.302252198081337e-18,
 -8.729542426376508e-20, -1.125617498353711e-21,  1.425163776383082e+00, -8.140334021224643e-03, -1.754243449333666e-05,  4.657515213271672e-07,  7.110273500283839e-11,
 -4.612437329632628e-11,  7.034928338426812e-13,  1.912447061094456e-14,  3.219268562478390e-17, -4.390734657059374e-18, -1.215588096876925e-19, -1.681683168302900e-21,
  1.662424362667277e+00, -7.433789748812893e-03, -6.009191459000809e-05,  3.737842000451542e-07,  9.475005050148457e-09, -4.076999072492261e-11, -1.367910766220337e-12,
  3.141571879351366e-14,  7.766742974466682e-16, -7.974377705806745e-18, -4.243933280085058e-19, -3.233263653819236e-21,  1.903052406325743e+00, -3.691373970306309e-03,
 -8.639034899153573e-05, -1.268036817745865e-06, -4.239494620405564e-09,  3.548634854848705e-10,  1.058982435323564e-11,  1.200822553699893e-13, -1.507610486186130e-15,
 -9.181341137133098e-17, -1.708528053011959e-18, -3.395041613786963e-21,  1.204522095219213e-03, -9.424623403981098e-06,  5.477008430601592e-08, -2.933793523505110e-10,
  1.474582301854618e-12,  2.853288314636321e-15,  3.266866639681507e-16,  3.534376260220532e-18, -5.705991439008396e-20, -3.271385582241518e-21, -5.240933182944467e-23,
  1.764733385583070e-25,  1.085322841591574e-02, -8.486226307699892e-05,  4.917803219710010e-07, -2.619932088109243e-09,  1.305081207183678e-11,  2.800088202750265e-14,
  2.939891895222397e-15,  3.208312824269287e-17, -5.166452996909151e-19, -2.959368185579207e-20, -4.743271094119761e-22,  1.592792417883865e-24,  3.021798297416466e-02,
 -2.359521213248375e-04,  1.359500345756016e-06, -7.161444801883563e-09,  3.500710119656843e-11,  9.082634665883788e-14,  8.165963877768758e-15,  9.065198276972246e-17,
 -1.452505775916454e-18, -8.306069426244340e-20, -1.332514591242969e-21,  4.449678434719141e-24,  5.943600163033563e-02, -4.631118606204801e-04,  2.644506513711645e-06,
 -1.368302374004151e-08,  6.484996150586321e-11,  2.171120635144271e-13,  1.601052415972326e-14,  1.822370888957972e-16, -2.898609724891285e-18, -1.653968721490295e-19,
 -2.656948697149186e-21,  8.795974599194324e-24,  9.871966310322496e-02, -7.669354383496201e-04,  4.324452114836811e-06, -2.180110664780595e-08,  9.857462512110646e-11,
  4.473339293656899e-13,  2.650052551924283e-14,  3.114594909221441e-16, -4.907349529832521e-18, -2.794025284009941e-19, -4.496011606969488e-21,  1.470575421130174e-23,
  1.483650398705851e-01, -1.148142097247467e-03,  6.364936557537843e-06, -3.094004220670545e-08,  1.303141007691143e-10,  8.387700221590303e-13,  3.971559383348512e-14,
  4.846927069861715e-16, -7.551161214527658e-18, -4.292551979318077e-19, -6.921324980092506e-21,  2.227913698430252e-23,  2.087644953911750e-01, -1.607483774446116e-03,
  8.714381111700807e-06, -4.026262744912058e-08,  1.518139861823398e-10,  1.468033289971052e-12,  5.584988426712667e-14,  7.101723875017242e-16, -1.092446869544106e-17,
 -6.210000875397808e-19, -1.003569746970868e-20,  3.164320791938221e-23,  2.804246526932533e-01, -2.145578154538093e-03,  1.129571590992877e-05, -4.856080084429156e-08,
  1.516862524062826e-10,  2.433224979639102e-12,  7.533460534067442e-14,  9.979884358220654e-16, -1.514579604241079e-17, -8.633378919464602e-19, -1.398619940009930e-20,
  4.295324277474866e-23,  3.639917584179999e-01, -2.762604509378283e-03,  1.399269690244272e-05, -5.408280187023922e-08,  1.144065519971855e-10,  3.853377875762916e-12,
  9.908490599578209e-14,  1.359757195538921e-15, -2.036037837729884e-17, -1.168898295851858e-18, -1.898632004489006e-20,  5.639546733682865e-23,  4.602875776954091e-01,
 -3.457737426454458e-03,  1.662674085858301e-05, -5.425591140734528e-08,  1.911262467522237e-11,  5.858728012994462e-12,  1.290096408938495e-13,  1.807615790357565e-15,
 -2.674648601298077e-17, -1.556324476071770e-18, -2.535541407254751e-20,  7.219523596555227e-23,  5.703606942125266e-01, -4.228057914970110e-03,  1.891617195473317e-05,
 -4.523429262745737e-08, -1.613544210879158e-10,  8.553942252282041e-12,  1.690942310834462e-13,  2.352151563695036e-15, -3.454192043562528e-17, -2.053717352143521e-18,
 -3.359357365989401e-20,  9.063812660280158e-23,  6.955607507318737e-01, -5.066364205053459e-03,  2.040100375130070e-05, -2.115511422400096e-08, -4.593035403384600e-10,
  1.190364674094603e-11,  2.277631050661221e-13,  3.000318878026406e-15, -4.416433250449219e-17, -2.704311958887710e-18, -4.453428836761047e-20,  1.120934005831664e-22,
  8.376467520090461e-01, -5.956499460163074e-03,  2.029584142752065e-05,  2.705586777415723e-08, -9.017921721787439e-10,  1.539090914215539e-11,  3.230743839250608e-13,
  3.765471700276665e-15, -5.674550171487210e-17, -3.575756265984104e-18, -5.967452475581161e-20,  1.367916163626031e-22,  9.989425851080928e-01, -6.862552030586762e-03,
  1.718211803026906e-05,  1.133110028767707e-07, -1.462889120021308e-09,  1.699233003161068e-11,  4.932650482806493e-13,  4.771764372903480e-15, -7.646033547478421e-17,
 -4.778069146089174e-18, -8.186986093200824e-20,  1.622822784961628e-22,  1.182535464742254e+00, -7.701066407931644e-03,  8.316753758580264e-06,  2.564274196380279e-07,
 -1.859396711685582e-09,  1.013243001405384e-11,  8.064155901136538e-13,  6.975172851927054e-15, -1.199009098952249e-16, -6.556150838239290e-18, -1.161699010636288e-19,
  1.674125966835605e-22,  1.392357101943182e+00, -8.258361328441799e-03, -1.197356319820607e-05,  4.606085524936552e-07, -6.393233982582978e-10, -2.288126999250621e-11,
  1.222174211850792e-12,  1.655673723773654e-14, -2.288150024487686e-16, -1.042664575841940e-17, -1.671219625404857e-19,  1.600538349481867e-22,  1.631759684774923e+00,
 -7.894078107300438e-03, -5.472866095722854e-05,  5.174223385609767e-07,  8.415501371212309e-09, -6.062367510436684e-11, -2.080896121783446e-13,  4.819622408575712e-14,
  1.615244571891466e-16, -2.643179359706536e-17, -4.555101574697076e-19,  2.709482474849291e-21,  1.886807496528798e+00, -4.443881435413493e-03, -1.017320481562578e-04,
 -1.264280055346816e-06,  5.628841459346992e-09,  6.403953665252429e-10,  1.268758689504516e-11,  6.202837337833750e-15, -5.963415422671317e-15, -1.496825791201815e-16,
 -7.548124943914515e-19,  5.560425421652635e-20,  1.167678201745005e-03, -9.000136600663530e-06,  5.139443475666938e-08, -2.688751044624617e-10,  1.616490574479797e-12,
  1.155254034792377e-14,  3.797089341506852e-16, -5.395420439127651e-19, -2.066670111252476e-19, -4.751459999184955e-21, -7.845355685120982e-24,  2.054387118530829e-24,
  1.052145383455167e-02, -8.105015862022312e-05,  4.616256371857143e-07, -2.402547352548114e-09,  1.437488202198239e-11,  1.063622537852954e-13,  3.422409801053663e-15,
 -4.787437749503273e-18, -1.870218480506956e-18, -4.299430335753996e-20, -7.129805532932507e-23,  1.858501156660447e-23,  2.929539594109411e-02, -2.254101349725342e-04,
  1.277020174603187e-06, -6.575420881227629e-09,  3.894891392200463e-11,  3.089067079662083e-13,  9.535996574334149e-15, -1.292182590131666e-17, -5.252666575331954e-18,
 -1.207368444068265e-19, -2.019629964222916e-22,  5.216482202278177e-23,  5.762485189989134e-02, -4.425944812280997e-04,  2.486750866209336e-06, -1.258833973603208e-08,
  7.336798285285411e-11,  6.459217889033818e-13,  1.878387256857733e-14, -2.424037150106879e-17, -1.046897803122585e-17, -2.406124597802331e-19, -4.077618353681266e-22,
  1.038761780789890e-22,  9.571949474736718e-02, -7.333585448175210e-04,  4.072716227420887e-06, -2.011526739466881e-08,  1.144523666804214e-10,  1.159787526510815e-12,
  3.128123274742762e-14, -3.775663444242204e-17, -1.770294055990968e-17, -4.068925427606517e-19, -7.016676666836069e-22,  1.754637342475976e-22,  1.438720111934151e-01,
 -1.098670649754496e-03,  6.006898541353044e-06, -2.866510207917219e-08,  1.575121880342013e-10,  1.911414656718233e-12,  4.722736605296558e-14, -5.233296772109164e-17,
 -2.722275953122397e-17, -6.259407725173313e-19, -1.103281093630690e-21,  2.695047253162898e-22,  2.024709923023566e-01, -1.539657304015924e-03,  8.247024668812212e-06,
 -3.752013059392454e-08,  1.958878613113219e-10,  2.984273230676654e-12,  6.696663674239229e-14, -6.697330067814148e-17, -3.940581191419750e-17, -9.069560171090293e-19,
 -1.641491427804909e-21,  3.896862459850730e-22,  2.720194448875998e-01, -2.057497708525317e-03,  1.072949503326076e-05, -4.563815712556552e-08,  2.202761699411643e-10,
  4.489446625036092e-12,  9.110488634012892e-14, -8.144749347634999e-17, -5.477761781178324e-17, -1.263177579671847e-18, -2.359008891904733e-21,  5.412545757358180e-22,
  3.531611660194668e-01, -2.653221036480048e-03,  1.335767906759151e-05, -5.149547691683038e-08,  2.177746984511858e-10,  6.570832179919069e-12,  1.207379071579802e-13,
 -9.759761317241098e-17, -7.407473338988836e-17, -1.713870241901413e-18, -3.320382551674586e-21,  7.317596083776845e-22,  4.467185529438281e-01, -3.327312510603290e-03,
  1.598195768112787e-05, -5.282974493996766e-08,  1.706052840007282e-10,  9.407206585140451e-12,  1.579168449428605e-13, -1.220343041961759e-16, -9.835188340839689e-17,
 -2.287684091796397e-18, -4.627033187377216e-21,  9.723385261457376e-22,  5.537476406050887e-01, -4.078929140488220e-03,  1.836428396250080e-05, -4.620765091981575e-08,
  5.467398505927990e-11,  1.320051592197228e-11,  2.066386031309436e-13, -1.715860409789854e-16, -1.291815175727344e-16, -3.028539798141351e-18, -6.447564816179009e-21,
  1.280054292951446e-21,  6.756199522499680e-01, -4.904276402161839e-03,  2.011193609697440e-05, -2.627796278778029e-08, -1.610127206404066e-10,  1.811673779329236e-11,
  2.750572155665114e-13, -2.836212168691672e-16, -1.690790911781195e-16, -4.006341380113059e-18, -9.083887519673018e-21,  1.682459440723426e-21,  8.141472320726463e-01,
 -5.793053046090715e-03,  2.054554787861520e-05,  1.554150371747473e-08, -5.095188549945385e-10,  2.407007699249074e-11,  3.806521957502132e-13, -5.308984670151593e-16,
 -2.225915514280960e-16, -5.337357545068697e-18, -1.312442978439921e-20,  2.227247960668963e-21,  9.717753803197116e-01, -6.720023859170622e-03,  1.841481847061763e-05,
  9.330497020145163e-08, -9.960191298877959e-10,  2.997700895374110e-11,  5.625183557045576e-13, -1.007302662753915e-15, -2.997499252185359e-16, -7.226411468303979e-18,
 -1.978074815881771e-20,  3.004431081249826e-21,  1.151883070909534e+00, -7.622707097035311e-03,  1.122563035976045e-05,  2.294053316475664e-07, -1.450667716511814e-09,
  3.114765915053538e-11,  9.064691912796801e-13, -1.467001104926315e-15, -4.294022560757032e-16, -1.009035863214382e-17, -3.108141460997579e-20,  4.201589156746508e-21,
  1.359166808419642e+00, -8.332238239460032e-03, -6.517190535195505e-06,  4.484499417990900e-07, -7.719869769670700e-10,  1.079538683573462e-11,  1.518091859062610e-12,
  2.032846555276868e-15, -7.101687889046917e-16, -1.551262069814208e-17, -4.218747405606385e-20,  6.325360413064039e-21,  1.599350148488483e+00, -8.304873739373952e-03,
 -4.775134332327816e-05,  6.425561322974112e-07,  7.261252951203253e-09, -4.983579295772125e-11,  1.047861257120621e-12,  3.503532561286550e-14, -1.061507077657460e-15,
 -3.911629304972102e-17, -8.756486693314978e-20,  1.520325298909935e-20,  1.867311751182140e+00, -5.315812835565669e-03, -1.158877004687884e-04, -1.055604304842785e-06,
  2.136297185671824e-08,  9.203779442947900e-10,  9.373471855995386e-12, -2.703076848567891e-13, -1.106492101808279e-14, -1.044174547429950e-16,  3.665988870128376e-18,
  1.419641212649464e-19,  1.132480179622219e-03, -8.601426752530565e-06,  4.833229438005862e-08, -2.406882951019797e-10,  1.932923506006760e-12,  1.958192171847238e-14,
  2.471053688398383e-16, -9.730206709310844e-18, -3.550276055546945e-19, -2.544714966277241e-21,  1.343874396231008e-22,  4.204562384992815e-24,  1.020446238535787e-02,
 -7.746837594615619e-05,  4.342592558726635e-07, -2.151253849318326e-09,  1.727170504399732e-11,  1.787258138229068e-13,  2.225087154272378e-15, -8.795832485744815e-17,
 -3.212928302569572e-18, -2.303975902811569e-20,  1.215757029554614e-21,  3.805488804832825e-23,  2.841370366660743e-02, -2.154984515225364e-04,  1.202097108066783e-06,
 -5.890893943858127e-09,  4.727139047405283e-11,  5.104948534251770e-13,  6.187869701790344e-15, -2.465203596610804e-16, -9.024674929011365e-18, -6.477755579376911e-20,
  3.412545420900168e-21,  1.069177018654032e-22,  5.589333493811103e-02, -4.232836218422769e-04,  2.343237275001224e-06, -1.128762377425565e-08,  9.051038440564007e-11,
  1.042879864250904e-12,  1.215299357100015e-14, -4.898522126186895e-16, -1.799037611914272e-17, -1.293300612534450e-19,  6.795884311850613e-21,  2.132258550869473e-22,
  9.284974186672978e-02, -7.017091959586939e-04,  3.843213907338041e-06, -1.805935573918830e-08,  1.446824129359279e-10,  1.820551238206483e-12,  2.015817912148364e-14,
 -8.252175780107242e-16, -3.043212715737302e-17, -2.192613921221767e-19,  1.148059477395823e-20,  3.609199921486633e-22,  1.395713252298165e-01, -1.051945248135714e-03,
  5.679493305844400e-06, -2.578002983906477e-08,  2.063603137394031e-10,  2.908404599652330e-12,  3.028048152941362e-14, -1.263594711357164e-15, -4.682461828976211e-17,
 -3.384213645805034e-19,  1.763661117224614e-20,  5.558606209203646e-22,  1.964415458493520e-01, -1.475423702912040e-03,  7.817832072521329e-06, -3.382470098066643e-08,
  2.706304588900758e-10,  4.396840357846521e-12,  4.267399086730062e-14, -1.821178724261365e-15, -6.784450788579825e-17, -4.924294946512203e-19,  2.550756936830962e-20,
  8.065034942697619e-22,  2.639577520051739e-01, -1.973784889067581e-03,  1.020631965724326e-05, -4.128149910692265e-08,  3.305455334918822e-10,  6.409220490798440e-12,
  5.764480220784675e-14, -2.521931801070001e-15, -9.444948304359623e-17, -6.894678156376302e-19,  3.544084993928187e-20,  1.125001847313486e-21,  3.427581891324688e-01,
 -2.548761168268045e-03,  1.276547073772832e-05, -4.680877930586927e-08,  3.763233940660790e-10,  9.111819920445818e-12,  7.580402012288002e-14, -3.402023639185874e-15,
 -1.280074924891686e-16, -9.416004268208207e-19,  4.793706441936314e-20,  1.529045116108144e-21,  4.336610851715670e-01, -3.201930670576888e-03,  1.537123395274714e-05,
 -4.839751199797039e-08,  3.942149282341060e-10,  1.272565563827746e-11,  9.839146302210102e-14, -4.517862888575809e-15, -1.705168422989866e-16, -1.267030543143438e-18,
  6.373449377834448e-20,  2.045048278285513e-21,  5.377222904032407e-01, -3.934196195993676e-03,  1.782459853806404e-05, -4.296264796799540e-08,  3.650505911856774e-10,
  1.753579589159235e-11,  1.279920373828988e-13, -5.961292693107611e-15, -2.250051340909721e-16, -1.694089002869278e-18,  8.396043269823664e-20,  2.713989625874127e-21,
  6.563226178297628e-01, -4.744656247330456e-03,  1.979422464191312e-05, -2.561221166524263e-08,  2.629716767234237e-10,  2.387992658084503e-11,  1.702088211985907e-13,
 -7.889687920727206e-15, -2.963207318634210e-16, -2.268510074088240e-18,  1.104207404997534e-19,  3.602865489983206e-21,  7.913047863423537e-01, -5.628041540407651e-03,
  2.070057261782141e-05,  1.171498423754701e-08,  5.712674272671996e-11,  3.204696677795082e-11,  2.378153271392678e-13, -1.058746494240046e-14, -3.929225494755483e-16,
 -3.066982695754297e-18,  1.462060559647322e-19,  4.829238415443579e-21,  9.451966965972950e-01, -6.568447396842328e-03,  1.946094131946670e-05,  8.286634657564088e-08,
 -2.703764317471494e-10,  4.181693883313214e-11,  3.616653321265965e-13, -1.458664125527290e-14, -5.317591331954269e-16, -4.222292746491574e-18,  1.971545882099154e-19,
  6.619992910950319e-21,  1.121588802212691e+00, -7.522230353573608e-03,  1.386350181733078e-05,  2.123141088157700e-07, -6.229351320456873e-10,  5.052385216238670e-11,
  6.192846035251110e-13, -2.079861709762895e-14, -7.553108894625322e-16, -5.973956159771538e-18,  2.764817361936767e-19,  9.472513423647617e-21,  1.325767403867919e+00,
 -8.363030991268500e-03, -1.196437364301070e-06,  4.397715589093132e-07, -2.025786740680117e-10,  4.483334878725763e-11,  1.174497736104435e-12, -2.925308977489965e-14,
 -1.208139079821081e-15, -9.022039322238480e-18,  4.296050238069332e-19,  1.470389106776162e-20,  1.565418167554627e+00, -8.654132286140991e-03, -3.937134610765297e-05,
  7.523767336314485e-07,  6.570156730024110e-09, -1.804130517474150e-11,  1.345766597462008e-12, -2.054447207973797e-14, -2.327914540064102e-15, -2.447386931216004e-17,
  9.314817859745628e-19,  3.006724402692582e-20,  1.844124199364146e+00, -6.286310147740119e-03, -1.258659002591741e-04, -5.576385033474142e-07,  4.119028473352998e-08,
  1.012361005862961e-09, -3.441617080317951e-12, -6.434364509998080e-13, -1.060861151491466e-14,  1.718636116555071e-16,  9.850817666543576e-18,  9.717914125385141e-20,
  1.098830280458427e-03, -8.225764378609138e-06,  4.564325314021430e-08, -2.064225621172442e-10,  2.354969575602264e-12,  2.092086475925393e-14, -1.886426059732399e-16,
 -2.115366474903350e-17, -3.052087117700772e-19,  6.451167601807826e-21,  3.014458506008380e-22,  2.197232800071218e-24,  9.901380542517015e-03, -7.409257869438228e-05,
  4.102268464929753e-07, -1.844461175754623e-09,  2.111894488622717e-11,  1.906074834149300e-13, -1.715674255543159e-15, -1.913468980396024e-16, -2.762654104671788e-18,
  5.836498676025436e-20,  2.728300466040809e-21,  1.991025143407712e-23,  2.757051493047209e-02, -2.061507654718081e-04,  1.136299634479489e-06, -5.047754033733122e-09,
  5.823364745233725e-11,  5.425582261577395e-13, -4.866438744509767e-15, -5.369739477367925e-16, -7.763206152793949e-18,  1.638454221532439e-19,  7.665103759858994e-21,
  5.607228406924956e-23,  5.423687132931886e-02, -4.050532506520085e-04,  2.217198785951950e-06, -9.662616135794099e-09,  1.128275746652871e-10,  1.102943528299035e-12,
 -9.840588893150103e-15, -1.069014160535883e-15, -1.548577239171032e-17,  3.263420460950520e-19,  1.528582134070187e-20,  1.122311098348502e-22,  9.010308335856336e-02,
 -6.717880893971473e-04,  3.641651501270938e-06, -1.543675463021120e-08,  1.834742013553135e-10,  1.913688844195214e-12, -1.695361267155861e-14, -1.805278023355454e-15,
 -2.621898386818312e-17,  5.514145049769907e-19,  2.587227972040607e-20,  1.909125851103864e-22,  1.354525421539311e-01, -1.007686008227330e-03,  5.391950587845149e-06,
 -2.198859680667044e-08,  2.680286701646852e-10,  3.036065702893845e-12, -2.665696526320560e-14, -2.772317104978927e-15, -4.038956210707166e-17,  8.472736075704118e-19,
  3.984368170526839e-20,  2.959115755083066e-22,  1.906624787355281e-01, -1.414424080243623e-03,  7.440940064809318e-06, -2.875735040428280e-08,  3.633724787432125e-10,
  4.556183291599152e-12, -3.956579624697407e-14, -4.008580558822388e-15, -5.860820802752700e-17,  1.225661208173411e-18,  5.780494516965640e-20,  4.327727536511460e-22,
  2.562229163824177e-01, -1.894015849824636e-03,  9.747066813752119e-06, -3.492245809522634e-08,  4.650260516843726e-10,  6.593086141349032e-12, -5.649286586237251e-14,
 -5.569620278101356e-15, -8.174326949182373e-17,  1.703274041181515e-18,  8.062548022902205e-20,  6.095823804682567e-22,  3.327639978638444e-01, -2.448767567170239e-03,
  1.224611732534412e-05, -3.927182519765968e-08,  5.665707381318229e-10,  9.310392181899757e-12, -7.848122473421139e-14, -7.536878192280656e-15, -1.110412848146187e-16,
  2.304120920110491e-18,  1.095702757342400e-19,  8.383007106641913e-22,  4.210958016369414e-01, -3.081156736336535e-03,  1.483697799446536e-05, -3.998010079194256e-08,
  6.588084037229552e-10,  1.293235168934489e-11, -1.068098895165121e-13, -1.003311953805355e-14, -1.483318066736387e-16,  3.063593985134783e-18,  1.465263491455383e-19,
  1.137089835335687e-21,  5.222676103054726e-01, -3.793534925159191e-03,  1.735601455286332e-05, -3.422104634822088e-08,  7.286237927934809e-10,  1.776372333476209e-11,
 -1.428918625624999e-13, -1.325099304718636e-14, -1.963954675707013e-16,  4.035944607592286e-18,  1.944146631122026e-19,  1.534592244969531e-21,  6.376589040091002e-01,
 -4.587423022022852e-03,  1.952835007633508e-05, -1.745691649375182e-08,  7.578049622612120e-10,  2.420538347803802e-11, -1.878157769499559e-13, -1.750936918402480e-14,
 -2.596802853441955e-16,  5.309216505100958e-18,  2.579914664942481e-19,  2.078317054423359e-21,  7.691248076408692e-01, -5.461808982905911e-03,  2.086845329633746e-05,
  1.793945656302436e-08,  7.235344818087712e-10,  3.272522830106865e-11, -2.407448191721018e-13, -2.337301604547625e-14, -3.458671296342652e-16,  7.038716391403235e-18,
  3.455501317195255e-19,  2.852438645803897e-21,  9.192405627368462e-01, -6.408790032485337e-03,  2.045804285937903e-05,  8.552803686117608e-08,  6.093908864879628e-10,
  4.360142790364256e-11, -2.935931031473962e-13, -3.192713405020868e-14, -4.699409406883142e-16,  9.534837250918809e-18,  4.729962357033679e-19,  4.019324865046799e-21,
  1.091737699908266e+00, -7.401219846020233e-03,  1.638676791926237e-05,  2.109897388198246e-07,  4.743853812868741e-10,  5.556556259891554e-11, -3.136932921914712e-13,
 -4.543325167031443e-14, -6.679142601723023e-16,  1.354650384446306e-17,  6.755670761182192e-19,  5.925988565706707e-21,  1.292329582057276e+00, -8.351472170632724e-03,
  4.094969189525758e-06,  4.448756720153507e-07,  8.863067358746791e-10,  5.867453187769989e-11, -2.034177755812789e-13, -6.848084562365217e-14, -1.062230839474200e-15,
  2.138939846842425e-17,  1.055231311685892e-18,  9.373078919023728e-21,  1.530231376704006e+00, -8.931219523764702e-03, -2.971922865209474e-05,  8.560131007160288e-07,
  6.439908250048519e-09, -1.555121832226686e-12, -3.382599734517191e-13, -9.930597694515294e-14, -2.215406701227423e-15,  3.905675683431753e-17,  2.153447498049188e-18,
  1.663837563155081e-20,  1.816940492934622e+00, -7.307323483943475e-03, -1.279678566914887e-04,  2.521813204701468e-07,  5.898855439508142e-08,  6.837717279156158e-10,
 -2.471093329209523e-11, -8.039455741285201e-13,  2.998714798532726e-15,  5.697016994828018e-16,  7.478202490845431e-18, -2.489716468645853e-19,  1.066642769799163e-03,
 -7.869856951537923e-06,  4.340468006016625e-08, -1.658593522844237e-10,  2.675654298018841e-12,  8.482281697956509e-15, -8.657202512188418e-16, -2.482203941898208e-17,
  1.463244663588974e-19,  1.801851390114869e-20,  2.036740810060031e-22, -7.694433002792724e-24,  9.611442139808763e-03, -7.089328818177701e-05,  3.902339446252259e-07,
 -1.480266995598722e-09,  2.404478556845967e-11,  7.786445454935518e-14, -7.840905441340553e-15, -2.245687320527082e-16,  1.323490610299391e-18,  1.630789834233240e-19,
  1.844340585866099e-21, -6.963316667712677e-23,  2.676373239747572e-02, -1.972860647002382e-04,  1.081639560616275e-06, -4.041078104864808e-09,  6.658497544853411e-11,
  2.248937340315656e-13, -2.205937756832243e-14, -6.304232885941348e-16,  3.713557476562223e-18,  4.581578927867139e-19,  5.186998219137477e-21, -1.955938517775865e-22,
  5.265144451376901e-02, -3.877472377379146e-04,  2.112735372371399e-06, -7.704739003148936e-09,  1.298726373715135e-10,  4.667776237881317e-13, -4.407970875968118e-14,
 -1.255702837961133e-15,  7.391458960568662e-18,  9.136302714680088e-19,  1.036027255245825e-20, -3.899381539540007e-22,  8.747309822876979e-02, -6.433432626655720e-04,
  3.475164984511862e-06, -1.223566973729824e-08,  2.131993292316292e-10,  8.311077975449414e-13, -7.479911505944191e-14, -2.121981578181197e-15,  1.247895153134346e-17,
  1.546290326216298e-18,  1.757315930707561e-20, -6.597332520062818e-22,  1.315065067492668e-01, -9.655287034990717e-04,  5.155631955449273e-06, -1.727767642229877e-08,
  3.154706787048154e-10,  1.358250210086943e-12, -1.155351386192249e-13, -3.261356759407855e-15,  1.915801942379420e-17,  2.381090475419709e-18,  2.713776417673638e-20,
 -1.015495647369380e-21,  1.851217998935914e-01, -1.356171687672123e-03,  7.133463587463585e-06, -2.230728658075148e-08,  4.350464061035471e-10,  2.104987974738589e-12,
 -1.681547536142316e-13, -4.720173382693075e-15,  2.769320817622628e-17,  3.453985659351380e-18,  3.950660260082572e-20, -1.472414142871125e-21,  2.488003427820523e-01,
 -1.817579844964242e-03,  9.376596986582909e-06, -2.655820458873165e-08,  5.694938120079928e-10,  3.149859933721600e-12, -2.352747580467691e-13, -6.565124833923082e-15,
  3.846883858161350e-17,  4.816562697493951e-18,  5.533344665340262e-20, -2.052354524782014e-21,  3.231621157331071e-01, -2.352516463247877e-03,  1.183484888698994e-05,
 -2.889705807434795e-08,  7.152129812866513e-10,  4.600742402681574e-12, -3.205741402075932e-13, -8.893470998483352e-15,  5.205263623270532e-17,  6.543737168113536e-18,
  7.557454067352321e-20, -2.787223360401007e-21,  4.090058049927469e-01, -2.964182516660981e-03,  1.442826604006335e-05, -2.761272140610134e-08,  8.668781746816566e-10,
  6.605046809372999e-12, -4.292884688966512e-13, -1.185083311814895e-14,  6.930916489101399e-17,  8.747053543747319e-18,  1.016629737216011e-19, -3.724848434026676e-21,
  5.073688790867743e-01, -3.656106113557595e-03,  1.702605976798637e-05, -2.004386486061875e-08,  1.016652023772135e-09,  9.361484368610639e-12, -5.690081112715760e-13,
 -1.566386350271755e-14,  9.161327894122873e-17,  1.159893990578768e-17,  1.358237414318396e-19, -4.939857951809581e-21,  6.196206752179514e-01, -4.431793715552276e-03,
  1.940630884240993e-05, -1.884687572767436e-09,  1.153289947068185e-09,  1.312588544121540e-11, -7.509909018017607e-13, -2.070436437753882e-14,  1.212786669399657e-16,
  1.538020539018569e-17,  1.816784656762582e-19, -6.555362695942672e-21,  7.476131697699565e-01, -5.293756941188005e-03,  2.117311417920851e-05,  3.419706731201853e-08,
  1.262139488330604e-09,  1.817626267938347e-11, -9.923334597396258e-13, -2.762591360770701e-14,  1.624834460187753e-16,  2.058226308186110e-17,  2.454972626274391e-19,
 -8.790622837818601e-21,  8.939395477071084e-01, -6.240792417665034e-03,  2.156952508404700e-05,  1.015425428763111e-07,  1.331602472139634e-09,  2.458096673421915e-11,
 -1.319447640946279e-12, -3.768505305259549e-14,  2.234177972756984e-16,  2.815738702443751e-17,  3.390517975307417e-19, -1.208085751814697e-20,  1.062411331402573e+00,
 -7.259789658303326e-03,  1.899826401921989e-05,  2.265930297729421e-07,  1.397502392528459e-09,  3.100058074396670e-11, -1.773037507132030e-12, -5.357936338593863e-14,
  3.213900758709313e-16,  4.025472436828405e-17,  4.870229404266636e-19, -1.744337011992984e-20,  1.259023474954579e+00, -8.297033324093105e-03,  9.554506836666697e-06,
  4.674702813489982e-07,  1.839931828685307e-09,  2.795624855515522e-11, -2.420530245019855e-12, -8.167660761144827e-14,  4.912960471265496e-16,  6.304913033829212e-17,
  7.512059263825613e-19, -2.801599121710265e-20,  1.494098507813951e+00, -9.126143501363378e-03, -1.883417712526355e-05,  9.572948430961407e-07,  6.068736821532368e-09,
 -4.913986716934039e-11, -3.777966949226051e-12, -1.306558895006943e-13,  7.580157431472808e-16,  1.213557646904844e-16,  1.390062351744286e-18, -6.048887884135418e-20,
  1.785706592893636e+00, -8.302123078967417e-03, -1.189517509469178e-04,  1.265977963182181e-06,  6.505187790047707e-08, -1.482265669238172e-10, -4.254356426090270e-11,
 -3.508174400732869e-13,  2.516977133563000e-14,  5.358371516951144e-16, -1.123903819453404e-17, -5.166894523338153e-19,  };
  constexpr double w[6912] = {  1.693712153054142e-01, -1.286904891142592e-03,  1.066944677592611e-05, -9.284830755802758e-08,  8.240568920529712e-10,
 -7.339058859275079e-12,  6.506315638622089e-14, -5.722874546045780e-16,  4.988712949997466e-18, -4.309807302322692e-20,  3.691269638578896e-22, -3.135842872058637e-24,
  1.658753338103501e-01, -2.371154576189881e-03,  3.730676862543504e-05, -5.497835946616177e-07,  7.604397122363451e-09, -1.000754430735439e-10,  1.265373736736954e-12,
 -1.547398158021668e-14,  1.838706147012919e-16, -2.130468087762007e-18,  2.413670074931832e-20, -2.679298215932899e-22,  1.591788441882896e-01, -4.380034679876163e-03,
  1.064879624101988e-04, -2.231249759535270e-06,  4.224008542385857e-08, -7.409620078916470e-10,  1.222901944369263e-11, -1.918572043534749e-13,  2.882442466071154e-15,
 -4.170040211831201e-17,  5.834115052203525e-19, -7.918933281572526e-21,  1.498195292425754e-01, -7.027866072713712e-03,  2.426003770112212e-04, -6.861936811752115e-06,
  1.698140020999322e-07, -3.802333055100798e-09,  7.862934033180188e-11, -1.522454335233047e-12,  2.787262500269564e-14, -4.860142597107365e-16,  8.116995700920172e-18,
 -1.303903129593805e-19,  1.384868418988040e-01, -9.959820279570654e-03,  4.668453517689280e-04, -1.718886671067241e-05,  5.381509846366224e-07, -1.492844767240911e-08,
  3.762327671580281e-10, -8.759624017316957e-12,  1.906572992017172e-13, -3.913724066914455e-15,  7.628568506585706e-17, -1.419091073991755e-18,  1.259167167151878e-01,
 -1.281591603910054e-02,  7.861244169249283e-04, -3.655266315096297e-05,  1.410361442460290e-06, -4.734448408259942e-08,  1.423111859134779e-09, -3.904650991597229e-11,
  9.913489947589441e-13, -2.352775667852658e-14,  5.260640195768952e-16, -1.114597359685614e-17,  1.127962869743674e-01, -1.528595128387072e-02,  1.186651985958432e-03,
 -6.785359606117237e-05,  3.154489478443241e-06, -1.255972555846691e-07,  4.421089660051024e-09, -1.405451967518169e-10,  4.096576885794681e-12, -1.107257996241386e-13,
  2.799509005006285e-15, -6.663592207782650e-17,  9.969581833054357e-02, -1.714458895470433e-02,  1.634175486848704e-03, -1.121945436476263e-04,  6.158044109164012e-06,
 -2.856232792592097e-07,  1.158331417748392e-08, -4.202612765787936e-10,  1.386668162840339e-11, -4.212244348049849e-13,  1.189205686541258e-14, -3.142073112186075e-16,
  8.703461832795889e-02, -1.826346361494754e-02,  2.080018084576869e-03, -1.677439888097622e-04,  1.066835604670399e-05, -5.669463894943779e-07,  2.609396191443135e-08,
 -1.065643396993415e-09,  3.929257140929066e-11, -1.325258929945790e-12,  4.130248128475607e-14, -1.198208887001254e-15,  7.507791884567595e-02, -1.860386032369410e-02,
  2.470337196471213e-03, -2.293308139497205e-04,  1.660722222963009e-05, -9.955687783021278e-07,  5.127262276757677e-08, -2.326407952627720e-09,  9.470347110607475e-11,
 -3.506455447199349e-12,  1.193483709944310e-13, -3.763130948153669e-15,  6.395566919960266e-02, -1.819723593124609e-02,  2.755551760375719e-03, -2.889963046783179e-04,
  2.344009095934547e-05, -1.561863812934116e-06,  8.880103958650950e-08, -4.421233731738351e-09,  1.964149044801533e-10, -7.897200161628472e-12,  2.905687911690088e-13,
 -9.861634669509902e-15,  5.369249398955862e-02, -1.712133694439725e-02,  2.897615858474218e-03, -3.373630425134764e-04,  3.017310735751100e-05, -2.203291729234967e-06,
  1.365128577725969e-07, -7.368985220909132e-09,  3.532847336227569e-10, -1.526360120062570e-11,  6.011197183482363e-13, -2.175514088116221e-14,  4.423968797483763e-02,
 -1.547791085889946e-02,  2.874071184089388e-03, -3.654170625994403e-04,  3.550657977685388e-05, -2.802969013381768e-06,  1.868912785118612e-07, -1.081079787968717e-08,
  5.532446495922407e-10, -2.542304293888719e-11,  1.061353280226528e-12, -4.058758411978614e-14,  3.550328695012522e-02, -1.337540280278263e-02,  2.678971494133608e-03,
 -3.662269918284465e-04,  3.811356267669974e-05, -3.210170400910048e-06,  2.275375301966427e-07, -1.394416605499551e-08,  7.535983801101027e-10, -3.646277130641973e-11,
  1.598378343076363e-12, -6.400924388385703e-14,  2.736545845863928e-02, -1.091768031684812e-02,  2.321485959465626e-03, -3.362199642537594e-04,  3.696560966279057e-05,
 -3.279634068794441e-06,  2.441768220420354e-07, -1.567606019713599e-08,  8.852885454699911e-10, -4.465497732717943e-11,  2.036167084704394e-12, -8.463474757416183e-14,
  1.969887574583154e-02, -8.198284263559195e-03,  1.823207619975235e-03, -2.758144110455905e-04,  3.161209948867685e-05, -2.917605924140824e-06,  2.255019743732297e-07,
 -1.499906392606546e-08,  8.759409364102131e-10, -4.560893050460072e-11,  2.143163258517168e-12, -9.165050448259809e-14,  1.237542604219100e-02, -5.299123502910904e-03,
  1.215084215933840e-03, -1.893915608629995e-04,  2.233645664015596e-05, -2.118346653793257e-06,  1.680059202264839e-07, -1.145136342365217e-08,  6.844294732970565e-10,
 -3.642801808332737e-11,  1.747721885328522e-12, -7.622332218573848e-14,  5.277969220488509e-03, -2.295409997289723e-03,  5.352786679694408e-04, -8.482034238834221e-05,
  1.016306325002374e-05, -9.784753752921899e-07,  7.872086342757632e-08, -5.438939313301173e-09,  3.292838897244745e-10, -1.774067546358525e-11,  8.610393968095052e-13,
 -3.796467905884916e-14,  1.643875528111282e-01, -1.205792522169074e-03,  9.629793451578243e-06, -8.075794538746399e-08,  6.916804206256660e-10, -5.953130530213435e-12,
  5.105966088833271e-14, -4.348725805103040e-16,  3.672821069381518e-18, -3.075659647461180e-20,  2.554327953302972e-22, -2.104810523382802e-24,  1.569485724543825e-01,
 -2.097163723884765e-03,  3.137830718912549e-05, -4.426114610754321e-07,  5.874640959889632e-09, -7.430558967151316e-11,  9.041522984564223e-13, -1.065174639408978e-14,
  1.220476835519875e-16, -1.364717642145811e-18,  1.493167447819459e-20, -1.601765100148906e-22,  1.432077934815736e-01, -3.624772687379878e-03,  8.332605895992710e-05,
 -1.659670940205556e-06,  2.996919507538473e-08, -5.027481270849536e-10,  7.951226963161201e-12, -1.197369571146087e-13,  1.729118496731766e-15, -2.407371013856210e-17,
  3.244738446374861e-19, -4.247113613156700e-21,  1.251265118774003e-01, -5.375425263861612e-03,  1.743462217021998e-04, -4.663620947849994e-06,  1.096450836648755e-07,
 -2.340161931879353e-09,  4.624650996743932e-11, -8.575301003183858e-13,  1.506134249689138e-14, -2.523376210448884e-16,  4.054746259830933e-18, -6.274559027038488e-20,
  1.049910300974572e-01, -6.923618655446251e-03,  3.037766181318565e-04, -1.054886539740311e-05,  3.130895986922345e-07, -8.264481336236811e-09,  1.987805161736391e-10,
 -4.427614720564913e-12,  9.238377076249107e-14, -1.821223782930541e-15,  3.414523914149492e-17, -6.118332514117997e-19,  8.491295403782557e-02, -7.959351719708574e-03,
  4.567712823124958e-04, -2.002225394588986e-05,  7.321277108979455e-07, -2.338280853712924e-08,  6.708095556229067e-10, -1.761185288595322e-11,  4.288209208119492e-13,
 -9.779051594864196e-15,  2.104584658710187e-16, -4.298705570079653e-18,  6.648186998787356e-02, -8.350842967357346e-03,  6.079164976802012e-04, -3.282427883449781e-05,
  1.448192943296753e-06, -5.493326675705974e-08,  1.848034191255579e-09, -5.629511360015861e-11,  1.575935402451280e-12, -4.099167584626022e-14,  9.991480676890784e-16,
 -2.296496954881524e-17,  5.063291345533989e-02, -8.134285688766200e-03,  7.303342016373178e-04, -4.751151358528107e-05,  2.482207573054728e-06, -1.099842167404608e-07,
  4.273827350826020e-09, -1.489579465481999e-10,  4.731996932199343e-12, -1.386652174344390e-13,  3.783183207601903e-15, -9.675402455129386e-17,  3.770046357433596e-02,
 -7.455579872054458e-03,  8.046834210291711e-04, -6.179385863933643e-05,  3.756887442546739e-06, -1.914736250149862e-07,  8.474909681301887e-09, -3.336309448834511e-10,
  1.188312500281762e-11, -3.878766432903743e-13,  1.171838132006818e-14, -3.300636175270837e-16,  2.757858038450331e-02, -6.500042830473325e-03,  8.237678286528837e-04,
 -7.325724203668954e-05,  5.098228401386513e-06, -2.945282420695334e-07,  1.465264572681052e-08, -6.435861126685496e-10,  2.540918147765425e-11, -9.139605605943092e-13,
  3.026711734311780e-14, -9.298622526492656e-16,  1.990618260132020e-02, -5.437385820238785e-03,  7.918462485584333e-04, -8.008482800020346e-05,  6.279762056770693e-06,
 -4.054465045073080e-07,  2.238132577993282e-08, -1.083842152510540e-09,  4.690840388692831e-11, -1.840074932187242e-12,  6.614142242500542e-14, -2.195732560970481e-15,
  1.422214575852885e-02, -4.392614864165412e-03,  7.204961463247078e-04, -8.145424513759100e-05,  7.087451906218930e-06, -5.043837049527266e-07,  3.050534516409556e-08,
 -1.609728435276575e-09,  7.554123718088215e-11, -3.198542861427114e-12,  1.235862284772820e-13, -4.392781733531700e-15,  1.006869311958964e-02, -3.439919481908390e-03,
  6.236930207523677e-04, -7.752390119850064e-05,  7.374293846237590e-06, -5.706375544913542e-07,  3.734097014162771e-08, -2.122219768431216e-09,  1.068139305370889e-10,
 -4.831952249158994e-12,  1.987531471498134e-13, -7.494887479106558e-15,  7.045452905035347e-03, -2.610508551666153e-03,  5.140192894743438e-04, -6.913201372731291e-05,
  7.084692561589097e-06, -5.881298885200198e-07,  4.112171740490812e-08, -2.487869065240514e-09,  1.328342740707035e-10, -6.354039026151797e-12,  2.755389193433210e-13,
 -1.092226934436561e-14,  4.827570885956136e-03, -1.905519835292777e-03,  4.006768946509382e-04, -5.740825671738189e-05,  6.247591880362236e-06, -5.489729797351176e-07,
  4.050214945992128e-08, -2.577994279383082e-09,  1.444141945084553e-10, -7.228850651546313e-12,  3.272412672880350e-13, -1.350935147400912e-14,  3.162561707087953e-03,
 -1.308216634772641e-03,  2.890575523368946e-04, -4.345502224530892e-05,  4.950850048817223e-06, -4.543518727895691e-07,  3.492914528487790e-08, -2.311531732378038e-09,
  1.343468106359459e-10, -6.963546878729025e-12,  3.258126902503255e-13, -1.387655381933477e-14,  1.857199670870345e-03, -7.929717798003710e-04,  1.812657005698254e-04,
 -2.816789685403670e-05,  3.312427837948299e-06, -3.132755843262628e-07,  2.478050441221279e-08, -1.684826638371573e-09,  1.004598983863088e-10, -5.334774648818655e-12,
  2.553976267516390e-13, -1.111586994501203e-14,  7.623104712600611e-04, -3.311759825850452e-04,  7.713728114651518e-05, -1.220880811077359e-05,  1.461168602496833e-06,
 -1.405220624486358e-07,  1.129328839264133e-08, -7.794666729398685e-10,  4.714361145223985e-11, -2.537506258952765e-12,  1.230437219832918e-13, -5.420394269511934e-15,
  1.597125760099873e-01, -1.132451054668473e-03,  8.723375273192253e-06, -7.058089123639177e-08,  5.839503768775274e-10, -4.861491752295904e-12,  4.037527479301707e-14,
 -3.332537570531325e-16,  2.729212479018312e-18, -2.217208812714038e-20,  1.786971259453779e-22, -1.429437194087342e-24,  1.490304480279731e-01, -1.865890471780050e-03,
  2.658545348696666e-05, -3.594210936074720e-07,  4.583469727740669e-09, -5.578518839710862e-11,  6.539433824790226e-13, -7.429506946189448e-15,  8.216540082382639e-17,
 -8.874731509640689e-19,  9.385749643227186e-21, -9.738136829830579e-23,  1.299263638077767e-01, -3.030378849631927e-03,  6.598595808632040e-05, -1.251271968326782e-06,
  2.158017848077183e-08, -3.466173105600033e-10,  5.258896905072227e-12, -7.609110395714914e-14,  1.057187251347504e-15, -1.417718305517440e-17,  1.842409012005651e-19,
 -2.327332560254387e-21,  1.060977776641548e-01, -4.177887972024334e-03,  1.275393751276063e-04, -3.230701403828538e-06,  7.224566053277263e-08, -1.471309054985194e-09,
  2.781288768811488e-11, -4.943105583833711e-13,  8.335558677401841e-15, -1.342799047480614e-16,  2.077365424632486e-18, -3.098579199652072e-20,  8.146082440362384e-02,
 -4.925656117161040e-03,  2.025296987417579e-04, -6.639372470607428e-06,  1.869654102769570e-07, -4.699681681990988e-09,  1.079517438633479e-10, -2.301689966209683e-12,
  4.606332906460169e-14, -8.724734420656196e-16,  1.574010200900615e-17, -2.717678417332915e-19,  5.910273792497572e-02, -5.097701695524206e-03,  2.737903143619292e-04,
 -1.131815213538636e-05,  3.923410131148337e-07, -1.192555583507448e-08,  3.266087429622023e-10, -8.207090241512242e-12,  1.916724670840683e-13, -4.200505618488858e-15,
  8.702007669143344e-17, -1.713571060416380e-18,  4.077344780167268e-02, -4.739307582160572e-03,  3.233509729933722e-04, -1.648118011270305e-05,  6.899100333420363e-07,
 -2.492694033367747e-08,  8.012712268902467e-10, -2.338411003856416e-11,  6.285666536879424e-13, -1.573007509725342e-14,  3.695309602127613e-16, -8.199216591952225e-18,
  2.694130793979027e-02, -4.033940286079247e-03,  3.407064648434759e-04, -2.098107303528678e-05,  1.042494009164013e-06, -4.409462248524524e-08,  1.640670620462300e-09,
 -5.489647240342468e-11,  1.677946109845366e-12, -4.740389813799941e-14,  1.249064372067329e-15, -3.090188827687731e-17,  1.719005700980248e-02, -3.194704016955869e-03,
  3.261206586196173e-04, -2.380952785009910e-05,  1.381892475334966e-06, -6.746238100266744e-08,  2.868330492532843e-09, -1.087337775204576e-10,  3.737344476322925e-12,
 -1.179467832079643e-13,  3.451129924510255e-15, -9.429310696971478e-17,  1.068456851645002e-02, -2.387919098167270e-03,  2.881436675291087e-04, -2.449764169821072e-05,
  1.635550116360198e-06, -9.091116980237821e-08,  4.362648620652857e-09, -1.852441542129138e-10,  7.084052032918873e-12, -2.472474847491881e-13,  7.957473955567938e-15,
 -2.379378847361699e-16,  6.527139222508555e-03, -1.706350637157595e-03,  2.383743773388196e-04, -2.319710098437112e-05,  1.755078349312039e-06, -1.096016469759831e-07,
  5.864535666106380e-09, -2.758082887100388e-10,  1.161254893786793e-11, -4.438309298208407e-13,  1.556571182080223e-14, -5.048479871669691e-16,  3.951890415489235e-03,
 -1.178888155596682e-03,  1.869445049317199e-04, -2.047692939403022e-05,  1.729948181979737e-06, -1.197667929859261e-07,  7.058958710811801e-09, -3.635705822863029e-10,
  1.667665260334775e-11, -6.910778661412374e-13,  2.616423070953977e-14, -9.122776092299017e-16,  2.387456593525135e-03, -7.946070795651478e-04,  1.403663561230306e-04,
 -1.702313010212011e-05,  1.582351621507549e-06, -1.198262572509889e-07,  7.683622874462986e-09, -4.284395335726671e-10,  2.118021498670878e-11, -9.420467666774101e-13,
  3.813462194678390e-14, -1.416498347328749e-15,  1.444013779321466e-03, -5.252572121638215e-04,  1.014984786498315e-04, -1.340835285717544e-05,  1.351089650520371e-06,
 -1.103937536333742e-07,  7.604390723002350e-09, -4.536552793555561e-10,  2.390384301298854e-11, -1.129258100189394e-12,  4.839649788430286e-14, -1.897238533262651e-15,
  8.713445048797928e-04, -3.398511839433507e-04,  7.057900006060377e-05, -9.992480848978519e-06,  1.075244417157229e-06, -9.348077557677764e-08,  6.828020820115591e-09,
 -4.305226032728284e-10,  2.390317451603826e-11, -1.186490976404388e-12,  5.328623585408312e-14, -2.183379553010364e-15,  5.149040666028419e-04, -2.115479476401588e-04,
  4.640665571624733e-05, -6.927925380874326e-06,  7.840779085877571e-07, -7.150621291445261e-08,  5.464654920361859e-09, -3.596179387653704e-10,  2.079074602960442e-11,
 -1.072260099780098e-12,  4.993233485136955e-14, -2.117162629734193e-15,  2.806565239142393e-04, -1.194498681191467e-04,  2.721124283337857e-05, -4.214319577131088e-06,
  4.939946657302948e-07, -4.657716047168538e-08,  3.673620599632639e-09, -2.490814333849189e-10,  1.481295352743545e-11, -7.846663018154967e-13,  3.747653781363887e-14,
 -1.627468995576722e-15,  1.103954927828017e-04, -4.790382950979849e-05,  1.114338086661587e-05, -1.761454779021899e-06,  2.105522287787529e-07, -2.022478872036652e-08,
  1.623525399907947e-09, -1.119320083289961e-10,  6.762633868599128e-12, -3.636250771807503e-13,  1.761474650159277e-14, -7.752378071653968e-16,  1.553171965549673e-01,
 -1.065900163229095e-03,  7.929417514279969e-06, -6.196587853660209e-08,  4.957028323637227e-10, -3.995280676222319e-12,  3.215602878324438e-14, -2.574246048577697e-16,
  2.045867642802732e-18, -1.613699834106924e-20,  1.263100299410000e-22, -9.816032367276933e-25,  1.419665922275054e-01, -1.669291936567960e-03,  2.267817632477593e-05,
 -2.942242036678927e-07,  3.609281293015621e-09, -4.231687488943536e-11,  4.783961526062057e-13, -5.246552456479990e-15,  5.605672793997337e-17, -5.853741188548035e-19,
  5.989159024746102e-21, -6.015135279829599e-23,  1.187731712839423e-01, -2.557168072407989e-03,  5.283401179591178e-05, -9.552514684585380e-07,  1.575531885137564e-08,
 -2.425728924085307e-10,  3.534328097787342e-12, -4.918329873377209e-14,  6.580446415771229e-16, -8.507198291347524e-18,  1.066825581033743e-19, -1.301532336021623e-21,
  9.120638704140882e-02, -3.295017921222491e-03,  9.484129236984365e-05, -2.278127891591259e-06,  4.851219067958917e-08, -9.436997249250573e-10,  1.708036302775151e-11,
 -2.912122334703388e-13,  4.718550918389219e-15, -7.314064288407272e-17,  1.090113532539690e-18, -1.568264652712392e-20,  6.455749189196336e-02, -3.579580551767388e-03,
  1.381067160815349e-04, -4.278354479334661e-06,  1.144117804645715e-07, -2.740836242954721e-09,  6.016644595615246e-11, -1.228758503474063e-12,  2.359946422977533e-14,
 -4.296812875191997e-16,  7.462503498802869e-18, -1.242037093945133e-19,  4.236222310132558e-02, -3.359636366749599e-03,  1.689590103997111e-04, -6.590128656254212e-06,
  2.166683794051090e-07, -6.270354506589123e-09,  1.639987568917466e-10, -3.945364414559192e-12,  8.840261237418451e-14, -1.862154125125232e-15,  3.714074430537859e-17,
 -7.051724542960370e-19,  2.595961236174244e-02, -2.788001198191553e-03,  1.782182981792811e-04, -8.573619255004712e-06,  3.404895097006984e-07, -1.171696406322958e-08,
  3.598528249409496e-10, -1.006009433124226e-11,  2.596216406048950e-13, -6.249969029733650e-15,  1.414844804673971e-16, -3.029912933486229e-18,  1.498904247472920e-02,
 -2.087158117374824e-03,  1.656374580371926e-04, -9.647593402139950e-06,  4.555954376578411e-07, -1.838451823589622e-08,  6.546303154008367e-10, -2.101667870633283e-11,
  6.177660597753522e-13, -1.681701351748679e-14,  4.277371069044833e-16, -1.023153765681549e-17,  8.240443841660283e-03, -1.435265138705374e-03,  1.383221707551685e-04,
 -9.587203002903121e-06,  5.305470562590688e-07, -2.478239182133139e-08,  1.011150456973663e-09, -3.687617578288835e-11,  1.222051925926281e-12, -3.725622342488032e-14,
  1.054905643617497e-15, -2.793628771589880e-17,  4.364983056529784e-03, -9.222046660938332e-04,  1.057091967508992e-04, -8.575587485773532e-06,  5.483377112931005e-07,
 -2.928161393034274e-08,  1.353548809846534e-09, -5.549010946050798e-11,  2.052971676876325e-12, -6.944654221330092e-14,  2.169805448789443e-15, -6.308070643622430e-17,
  2.256756876056917e-03, -5.628606710689953e-04,  7.523447336233050e-05, -7.029059904917799e-06,  5.121306629660064e-07, -3.087904713072175e-08,  1.598970997264790e-09,
 -7.292136799723854e-11,  2.982636031785564e-12, -1.109228555072343e-13,  3.790902460058169e-15, -1.199786968051525e-16,  1.154129368181162e-03, -3.315399889720779e-04,
  5.069790987288600e-05, -5.368171530630819e-06,  4.394416960902627e-07, -2.954143609963946e-08,  1.693889381795583e-09, -8.501960879519875e-11,  3.806177956550478e-12,
 -1.541554274195476e-13,  5.711366572536873e-15, -1.951091837635523e-16,  5.912645113449687e-04, -1.912136929609162e-04,  3.283230430829417e-05, -3.876799648844461e-06,
  3.514663071598646e-07, -2.600042198705873e-08,  1.631105019764925e-09, -8.909937054758922e-11,  4.320305240491590e-12, -1.886859068665955e-13,  7.507807676697623e-15,
 -2.743840591814796e-16,  3.064677118285047e-04, -1.092168321272804e-04,  2.067173471676770e-05, -2.677589479721684e-06,  2.648610875966222e-07, -2.126871250166066e-08,
  1.441408527544227e-09, -8.468404911076815e-11,  4.398342604744628e-12, -2.049847703242802e-13,  8.673263515409631e-15, -3.359310733818163e-16,  1.612695572536420e-04,
 -6.206575824950227e-05,  1.271279942615410e-05, -1.776210351076507e-06,  1.887573383601854e-07, -1.621866451058269e-08,  1.171623486952588e-09, -7.310947249804055e-11,
  4.019585288685261e-12, -1.976888516853233e-13,  8.801385400784670e-15, -3.576859140736570e-16,  8.514646373888617e-05, -3.471587448681591e-05,  7.554356844787020e-06,
 -1.119024505010346e-06,  1.257151786007691e-07, -1.138527192467797e-08,  8.643834108844573e-10, -5.653172977535245e-11,  3.249233188303093e-12, -1.666529793201183e-13,
  7.720214591230148e-15, -3.257354741325712e-16,  4.274099412855969e-05, -1.812596519995241e-05,  4.113353903484507e-06, -6.346742217785246e-07,  7.413002623412808e-08,
 -6.965809829504871e-09,  5.476417251945824e-10, -3.701865509034921e-11,  2.195165425432336e-12, -1.159636540612178e-13,  5.524188460291165e-15, -2.393060510568838e-16,
  1.603345665632694e-05, -6.948495893165047e-06,  1.614092344059493e-06, -2.547884141047373e-07,  3.041466042756329e-08, -2.917718383944616e-09,  2.339249144659243e-10,
 -1.610834754157915e-11,  9.721031018993962e-13, -5.221190409928414e-14,  2.526561412523314e-15, -1.110823224349104e-16,  1.511759398478064e-01, -1.005310166164197e-03,
  7.230906995495515e-06, -5.463427079963095e-08,  4.229669026393386e-10, -3.303136693508008e-12,  2.578384758278516e-14, -2.003551306752391e-16,  1.546370237080883e-18,
 -1.185131884745187e-20,  9.015613455151419e-23, -6.812002409205717e-25,  1.356312202437109e-01, -1.501068065892830e-03,  1.946794028513440e-05, -2.426691088295219e-07,
  2.866830282656947e-09, -3.241344606843538e-11,  3.537400032873066e-13, -3.748391817962141e-15,  3.872676930316091e-17, -3.913161962034878e-19,  3.876457496108173e-21,
 -3.771640140729734e-23,  1.093228430749392e-01, -2.176403532261922e-03,  4.273715201149191e-05, -7.377980364943621e-07,  1.165174767687795e-08, -1.721512056803048e-10,
  2.411240689751515e-12, -3.230260324497735e-14,  4.165652595026932e-16, -5.196038181064321e-18,  6.292659112452115e-20, -7.420104920930770e-22,  7.938754268790449e-02,
 -2.633744740949887e-03,  7.160333506015564e-05, -1.633145821602583e-06,  3.315586723241496e-08, -6.167184244692472e-10,  1.069749590116601e-11, -1.751172334887445e-13,
  2.728583716946011e-15, -4.072674298877201e-17,  5.851919146590634e-19, -8.124868876762254e-21,  5.216274171663687e-02, -2.652676594755475e-03,  9.616655550432264e-05,
 -2.818169971179399e-06,  7.163528366935975e-08, -1.636838682376624e-09,  3.436451143984774e-11, -6.726777527159166e-13,  1.240595513477548e-14, -2.172482120828516e-16,
  3.634024330953087e-18, -5.832919699878450e-20,  3.119835461502791e-02, -2.273663795039977e-03,  1.071415969427949e-04, -3.945349021577457e-06,  1.230951326248748e-07,
 -3.393379648067283e-09,  8.479434606694219e-11, -1.953710849641344e-12,  4.201305263731227e-14, -8.508650121420404e-16,  1.634219221934170e-17, -2.992236288254257e-19,
  1.711810508142732e-02, -1.696351588979839e-03,  1.015825343234929e-04, -4.612459973730505e-06,  1.737921042035163e-07, -5.696356336590910e-09,  1.671545936971586e-10,
 -4.476429733884748e-12,  1.109090203737300e-13, -2.568246085283849e-15,  5.601978561547327e-17, -1.157745394777554e-18,  8.701442122012510e-03, -1.124471287622722e-03,
  8.377135238789022e-05, -4.611997370489785e-06,  2.068904377108425e-07, -7.961170613943468e-09,  2.711714797892521e-10, -8.349820645781164e-12,  2.359309177297890e-13,
 -6.186125553351783e-15,  1.518175506037478e-16, -3.509651062189775e-18,  4.146971210895170e-03, -6.751350417603035e-04,  6.132548541177391e-05, -4.030073410077627e-06,
  2.124148908683684e-07, -9.484611914860183e-09,  3.710341918273607e-10, -1.300703374928233e-11,  4.152624812306457e-13, -1.222039979771242e-14,  3.345924521285685e-16,
 -8.582040851575729e-18,  1.879438706288308e-03, -3.742197988321894e-04,  4.065775734475258e-05, -3.141538699027201e-06,  1.920834382782702e-07, -9.840570776256691e-09,
  4.376089383802119e-10, -1.730034448902586e-11,  6.185316224879990e-13, -2.025727809340815e-14,  6.138076560313605e-16, -1.733271433356956e-17,  8.232723911968325e-04,
 -1.952658792623035e-04,  2.490879059862143e-05, -2.229425503207243e-06,  1.561220070470583e-07, -9.073167261097812e-09,  4.539498464308961e-10, -2.004586744719035e-11,
  7.954242430833624e-13, -2.874671446872609e-14,  9.561970171918121e-16, -2.949661021364426e-17,  3.548530985771639e-04, -9.785432481198571e-05,  1.439109934186107e-05,
 -1.469621563659838e-06,  1.163283921490480e-07, -7.579238553284907e-09,  4.220639161174996e-10, -2.061123888659654e-11,  8.992429571169348e-13, -3.554612269277544e-14,
  1.287072792711417e-15, -4.302498115730501e-17,  1.533121674534487e-04, -4.804209917671540e-05,  7.998242055881014e-06, -9.174752933270446e-07,  8.096112009521860e-08,
 -5.840130113099981e-09,  3.578306314269038e-10, -1.911879075487114e-11,  9.079623353247703e-13, -3.888537331332036e-14,  1.518917587729452e-15, -5.455196424406290e-17,
  6.753450962164039e-05, -2.352666824145693e-05,  4.352479360592462e-06, -5.517266668612571e-07,  5.348161396941400e-08, -4.213993630203060e-09,  2.805588499396619e-10,
 -1.621054646899673e-11,  8.288564380507107e-13, -3.806318984444782e-14,  1.588277786667419e-15, -6.071626821701344e-17,  3.068075636443468e-05, -1.163252870250278e-05,
  2.346340567011181e-06, -3.230532105587388e-07,  3.385966599027847e-08, -2.871829603397825e-09,  2.049468337027923e-10, -1.264319072697037e-11,  6.876862230066888e-13,
 -3.348041285751233e-14,  1.476427123865303e-15, -5.946457884067629e-17,  1.432526884165981e-05, -5.790654163352639e-06,  1.248749729229297e-06, -1.833759396276453e-07,
  2.043226621109623e-08, -1.836134268604506e-09,  1.383877376274478e-10, -8.988757512171020e-12,  5.133078519934728e-13, -2.616742123762390e-14,  1.205251608450634e-15,
 -5.057768389490005e-17,  6.565212064159429e-06, -2.773067435531665e-06,  6.265986759396988e-07, -9.627900378956730e-08,  1.120075549079364e-08, -1.048546436868935e-09,
  8.214174831097810e-11, -5.533800958033031e-12,  3.271031594874710e-13, -1.722772683902834e-14,  8.183371952543069e-16, -3.535435112263120e-17,  2.336010658964817e-06,
 -1.010949434110223e-06,  2.344771774085608e-07, -3.695671608739248e-08,  4.405135699009148e-09, -4.219943950969284e-10,  3.378714673804050e-11, -2.323602569814603e-12,
  1.400496645968413e-13, -7.513115788531048e-15,  3.631465896570223e-16, -1.594849061667116e-17,  1.472663975543871e-01, -9.499751196059391e-04,  6.613824429298093e-06,
 -4.836349168665062e-08,  3.626651986046121e-10, -2.746422715005201e-12,  2.080718113524584e-14, -1.570562164437673e-16,  1.178020460867462e-18, -8.778847667334768e-21,
  6.494749731155578e-23, -4.774800306232744e-25,  1.299210316493476e-01, -1.356239322031679e-03,  1.681113622768850e-05, -2.015580207929272e-07,  2.295629751795633e-09,
 -2.505513154712859e-11,  2.642127765305003e-13, -2.707571995083977e-15,  2.707264476632516e-17, -2.649199260455873e-19,  2.542957676244985e-21, -2.398724999371281e-23,
  1.012491040011589e-01, -1.866994012241422e-03,  3.489792910874328e-05, -5.760524841240292e-07,  8.721268865218503e-09, -1.237857345012733e-10,  1.668394244433999e-12,
 -2.153695131079227e-14,  2.679262160748261e-16, -3.227144536969015e-18,  3.777215740026153e-20, -4.308048090147826e-22,  6.988569881652508e-02, -2.131145058409175e-03,
  5.482253778209145e-05, -1.188882855028356e-06,  2.303751185181995e-08, -4.101603252325910e-10,  6.824776047247349e-12, -1.073601443997746e-13,  1.609924308085337e-15,
 -2.315576841326443e-17,  3.209813682452493e-19, -4.303715407986016e-21,  4.290107856153129e-02, -2.001357180275623e-03,  6.827460661380441e-05, -1.894768708871332e-06,
  4.582482600132120e-08, -9.995853126706000e-10,  2.008594335389768e-11, -3.771167075675515e-13,  6.682815021418636e-15, -1.126197112855551e-16,  1.815363675536040e-18,
 -2.811333918542868e-20,  2.355939087400237e-02, -1.576947831796086e-03,  6.968813146285451e-05, -2.424384687456505e-06,  7.182678917108726e-08, -1.887200204705321e-09,
  4.507693491907388e-11, -9.951396238216242e-13,  2.054561590980479e-14, -4.001885218301752e-16,  7.403751636296738e-18, -1.307620940989495e-19,  1.166434980041314e-02,
 -1.065245923321503e-03,  5.976233627280070e-05, -2.561593751726676e-06,  9.158896534089076e-08, -2.859801686058524e-09,  8.019093639733437e-11, -2.057392143118389e-12,
  4.894128436233214e-14, -1.090159745609921e-15,  2.291221074194905e-17, -4.569546271075077e-19,  5.259356073214929e-03, -6.295461080000063e-04,  4.399465434988139e-05,
 -2.288347739245512e-06,  9.747823674279898e-08, -3.575777353504194e-09,  1.164743634101581e-10, -3.438736749745317e-12,  9.337318289522969e-14, -2.357374895431008e-15,
  5.580403811735659e-17, -1.246344207796630e-18,  2.187235716427026e-03, -3.319917469137695e-04,  2.838076112995087e-05, -1.766381445844549e-06,  8.859194769626580e-08,
 -3.778224524543510e-09,  1.416040240759201e-10, -4.768303321241087e-12,  1.465583932960290e-13, -4.160418306363332e-15,  1.100777504237200e-16, -2.732831771117689e-18,
  8.522039040628158e-04, -1.594349937990037e-04,  1.638388068137999e-05, -1.203730885507074e-06,  7.027657006177818e-08, -3.449550830411412e-09,  1.474011320358242e-10,
 -5.613276260310656e-12,  1.937359043549457e-13, -6.136895424601718e-15,  1.801632449529172e-16, -4.936946155450276e-18,  3.169789232980421e-04, -7.126121933894927e-05,
  8.653424135309227e-06, -7.403968785366106e-07,  4.974110887691257e-08, -2.781609158787255e-09,  1.342620020836851e-10, -5.732669743098740e-12,  2.203852681914681e-13,
 -7.730298011150161e-15,  2.499633590873708e-16, -7.507088548966272e-18,  1.150315566673546e-04, -3.035096621318933e-05,  4.281183735656081e-06, -4.206561848771690e-07,
  3.212948707122056e-08, -2.025028674359237e-09,  1.093276700752531e-10, -5.186224471691448e-12,  2.201801071927076e-13, -8.482621024472450e-15,  2.997761830231683e-16,
 -9.793826586308056e-18,  4.172026862866915e-05, -1.262982436608300e-05,  2.033368543556253e-06, -2.260624526962999e-07,  1.937620782677227e-08, -1.360294748519562e-09,
  8.126037097892650e-11, -4.239817018479964e-12,  1.969097238270556e-13, -8.257859349227656e-15,  3.162397921617725e-16, -1.114768567182156e-17,  1.549559184898016e-05,
 -5.263777455207620e-06,  9.496665151693774e-07, -1.175655004424544e-07,  1.114677830796670e-08, -8.603146376113501e-10,  5.618028610609675e-11, -3.187728964338878e-12,
  1.602388447951793e-13, -7.241661948816893e-15,  2.976510962807113e-16, -1.121806895565018e-17,  6.015424984104681e-06, -2.242857281570554e-06,  4.447268251096746e-07,
 -6.024370215955395e-08,  6.218445858912299e-09, -5.199199681429046e-10,  3.660904150637385e-11, -2.230151340555151e-12,  1.198756930749800e-13, -5.771664402975611e-15,
  2.518686455291008e-16, -1.004483765413296e-17,  2.456779433407640e-06, -9.835070327445770e-07,  2.099549134378712e-07, -3.053309815594236e-08,  3.370990968506150e-09,
 -3.003279954085510e-10,  2.245258210967100e-11, -1.447298290874531e-12,  8.205844936077155e-14, -4.155049243577070e-15,  1.901657006052949e-16, -7.932610154297961e-18,
  1.018178058080345e-06, -4.281240361238853e-07,  9.627302308433799e-08, -1.472373223988717e-08,  1.705315084419024e-09, -1.589721127649446e-10,  1.240438535799092e-11,
 -8.325484997555972e-13,  4.903837190664876e-14, -2.574121841794533e-15,  1.218882842621728e-16, -5.250224237599594e-18,  3.415275017611342e-07, -1.475739431180885e-07,
  3.417032250403462e-08, -5.376758201160720e-09,  6.398669753314980e-10, -6.120238722045536e-11,  4.892971669997141e-12, -3.360236957697062e-13,  2.022567932099466e-14,
 -1.083624594949800e-15,  5.231206093551039e-17, -2.294689931506436e-18,  1.435687766144282e-01, -8.992913322469044e-04,  6.066549729985512e-06, -4.297456568857066e-08,
  3.123951020957818e-10, -2.295836593847256e-12,  1.689319951005273e-14, -1.239531120366980e-16,  9.040968985241013e-19, -6.556228996354172e-21,  4.719768809948106e-23,
 -3.378944465762409e-25,  1.247505681143475e-01, -1.230836572494654e-03,  1.459733365960599e-05, -1.685163535467742e-07,  1.852268353529623e-09, -1.953403269195397e-11,
  1.992244287072074e-13, -1.976100225836480e-15,  1.913817205550637e-17, -1.815074522738244e-19,  1.689527146860585e-21, -1.546219267357511e-23,  9.429883237273341e-02,
 -1.613263884771414e-03,  2.874736875640214e-05, -4.543311944923283e-07,  6.601709677034424e-09, -9.010963796788066e-11,  1.169807827125149e-12, -1.456393229406603e-14,
  1.749290474481327e-16, -2.036223268310718e-18,  2.305146612147952e-20, -2.544788576480894e-22,  6.215601564968270e-02, -1.743935234853987e-03,  4.252310627340245e-05,
 -8.779352046694784e-07,  1.625587193325221e-08, -2.773072525233428e-10,  4.430351886933124e-12, -6.703027166531645e-14,  9.681211790753904e-16, -1.342804588326252e-17,
  1.796932561640749e-19, -2.328185024474639e-21,  3.585982923549846e-02, -1.535010285428302e-03,  4.935282354275662e-05, -1.298511958137188e-06,  2.990908617423742e-08,
 -6.233679269923647e-10,  1.199854653272228e-11, -2.162269562276993e-13,  3.684143883757144e-15, -5.978302165176847e-17,  9.291362892832639e-19, -1.388968786792015e-20,
  1.820658549662431e-02, -1.118805153128141e-03,  4.641273647696135e-05, -1.526617301419076e-06,  4.297837562517908e-08, -1.076943829060813e-09,  2.460210123758292e-11,
 -5.206563705980441e-13,  1.032489583692494e-14, -1.934932075973366e-16,  3.449335540883705e-18, -5.878078056616180e-20,  8.195072415299879e-03, -6.889448075929226e-04,
  3.622025566941014e-05, -1.465981272228707e-06,  4.975356980149977e-08, -1.480324267275374e-09,  3.967452558101956e-11, -9.753524001374556e-13,  2.227950133689337e-14,
 -4.774317039902150e-16,  9.669202607768070e-18, -1.861000603904679e-19,  3.302508068182256e-03, -3.655048304568886e-04,  2.394761949809926e-05, -1.176471686320749e-06,
  4.757827855855234e-08, -1.663480301021024e-09,  5.180740938986747e-11, -1.466270274724053e-12,  3.825295732673793e-14, -9.297138729908353e-16,  2.122353381599903e-17,
 -4.578359917092859e-19,  1.206839880090180e-03, -1.703701918141817e-04,  1.368909427938272e-05, -8.061486743105161e-07,  3.844395121332082e-08, -1.564894897096302e-09,
  5.615568826794518e-11, -1.815292545927822e-12,  5.368395583203733e-14, -1.469223447606724e-15,  3.754381769860323e-17, -9.016703600188182e-19,  4.064971495684564e-04,
 -7.124424467185985e-05,  6.911050274153616e-06, -4.820555747172778e-07,  2.683737096135211e-08, -1.260680250907795e-09,  5.170704729806574e-11, -1.894859835549495e-12,
  6.307320587936121e-14, -1.930670878303890e-15,  5.486703471536645e-17, -1.457781371997331e-18,  1.288053589870417e-04, -2.735626087584157e-05,  3.154438590859405e-06,
 -2.574803577615087e-07,  1.656536853074971e-08, -8.899689321982968e-10,  4.138153305517579e-11, -1.706120145934309e-12,  6.346522872760127e-14, -2.158006672544657e-15,
  6.775762002842353e-17, -1.979017934862292e-18,  3.936117861849453e-05, -9.902994612178872e-06,  1.336086677113343e-06, -1.260149645196394e-07,  9.268029291149788e-09,
 -5.640067373032133e-10,  2.947007597533836e-11, -1.355832240850192e-12,  5.592956643646273e-14, -2.097127430825819e-15,  7.223986896619474e-17, -2.303716754927585e-18,
  1.194158588666113e-05, -3.481154752243399e-06,  5.404888914433237e-07, -5.809710395145349e-08,  4.826216174174478e-09, -3.291023974607687e-10,  1.913293069420518e-11,
 -9.732164822008950e-13,  4.413345085288826e-14, -1.809757960211155e-15,  6.785475490636081e-17, -2.344690436848408e-18,  3.712519328317580e-06, -1.226395564990687e-06,
  2.152420047725657e-07, -2.596513290876378e-08,  2.403109334156297e-09, -1.813433628928450e-10,  1.159556981886271e-11, -6.451150937026558e-13,  3.183477108790366e-14,
 -1.413948888699283e-15,  5.717506573995650e-17, -2.121976403461882e-18,  1.218915210400810e-06, -4.460214806896434e-07,  8.677277059474271e-08, -1.154431144887055e-08,
  1.171646481862766e-09, -9.642402774908013e-11,  6.689807356572896e-12, -4.019231838068235e-13,  2.132537609892713e-14, -1.014299422593939e-15,  4.375763367819672e-17,
 -1.726387101307198e-18,  4.304133513155923e-07, -1.704258857887640e-07,  3.597003769111812e-08, -5.174362674835029e-09,  5.654430706601334e-10, -4.989387281896919e-11,
  3.696565573940948e-12, -2.362727700806414e-13,  1.329006643903836e-14, -6.679375244884307e-16,  3.035564539108732e-17, -1.257927027614607e-18,  1.596132666486473e-07,
 -6.677169056201753e-08,  1.493378195418905e-08, -2.271985647278396e-09,  2.618377382999500e-10, -2.429465281001166e-11,  1.887318862618453e-12, -1.261453557590108e-13,
  7.401052899831910e-15, -3.870607126528349e-16,  1.826393667856211e-17, -7.841154479563028e-19,  5.012216823224658e-08, -2.162083041078519e-08,  4.996951751889439e-09,
 -7.848441060753620e-10,  9.323699474782358e-11, -8.902970337923496e-12,  7.106235780977689e-13, -4.872685561879634e-14,  2.928618860780247e-15, -1.566851643564309e-16,
  7.553818306519537e-18, -3.309259125707235e-19,  1.400655255464051e-01, -8.527400942737038e-04,  5.579397887719521e-06, -3.832267306511628e-08,  2.702676279825485e-10,
 -1.928984580710603e-12,  1.379450424646937e-14, -9.846120600779682e-17,  6.987589936224554e-19, -4.934670851448635e-21,  3.458199235474828e-23, -2.413251628108519e-25,
  1.200486460628617e-01, -1.121670963693239e-03,  1.274085567628797e-05, -1.417633568785269e-07,  1.505253398703152e-09, -1.535301469497468e-11,  1.515710298905597e-13,
 -1.456405602250082e-15,  1.367276017943401e-17, -1.257737177272572e-19,  1.136115118685245e-21, -1.009485960336681e-23,  8.827357173634963e-02, -1.403424868025096e-03,
  2.387427424230564e-05, -3.617240297759916e-07,  5.050242987567981e-09, -6.635706092960170e-11,  8.305183203383143e-13, -9.980893724423740e-15,  1.158406316561177e-16,
 -1.304130951141975e-18,  1.429005576807441e-20, -1.528042387744081e-22,  5.579965156681045e-02, -1.441856581214694e-03,  3.338253499605789e-05, -6.570136512852161e-07,
  1.163734935452381e-08, -1.904018671786845e-10,  2.923390638216727e-12, -4.257581139213505e-14,  5.927299504748260e-16, -7.933866356702057e-18,  1.025645237980311e-19,
 -1.284933965525827e-21,  3.042109887223155e-02, -1.195236194901482e-03,  3.627611290873853e-05, -9.059013131849000e-07,  1.989223356484223e-08, -3.964921324548150e-10,
  7.316107723257169e-12, -1.266415577927930e-13,  2.076039278330719e-15, -3.245847070814317e-17,  4.866590894256688e-19, -7.026266623667254e-21,  1.437252674439837e-02,
 -8.105414397678052e-04,  3.160030017351546e-05, -9.835520992486037e-07,  2.633189692127843e-08, -6.296952116242892e-10,  1.376618983903028e-11, -2.794313017119347e-13,
  5.324961240321066e-15, -9.605406533566360e-17,  1.650562133787418e-18, -2.714850953524180e-20,  5.923914961139672e-03, -4.579717092721302e-04,  2.257311620143164e-05,
 -8.630564039844369e-07,  2.781441938047327e-08, -7.888531008251064e-10,  2.021389470393221e-11, -4.762897906527416e-13,  1.044949218683985e-14, -2.154609143837147e-16,
  4.205429081839894e-18, -7.811953232355571e-20,  2.149654244811886e-03, -2.196032150331236e-04,  1.348550023712332e-05, -6.256349356328200e-07,  2.401915461335780e-08,
 -8.003620298214697e-10,  2.383117731979938e-11, -6.465236985240747e-13,  1.620382111168365e-14, -3.790741654614236e-16,  8.343705225399601e-18, -1.738184463987923e-19,
  6.952530854448282e-04, -9.107222239689820e-05,  6.870302375620686e-06, -3.825282520426000e-07,  1.733455377033421e-08, -6.731303348232638e-10,  2.311591797210154e-11,
 -7.170013634840611e-13,  2.039221514782561e-14, -5.378010579662770e-16,  1.326651757798117e-17, -3.080755278371207e-19,  2.036994674410664e-04, -3.334827231077704e-05,
  3.048185711818521e-06, -2.015713788786187e-07,  1.068867714266616e-08, -4.800101877731884e-10,  1.887939573624272e-11, -6.651806667887343e-13,  2.133599133633194e-14,
 -6.305889079265674e-16,  1.733371960839183e-17, -4.461964822419099e-19,  5.522051128612128e-05, -1.104277843279201e-05,  1.206235050929881e-06, -9.374573011868537e-08,
  5.766123800086096e-09, -2.971657140470254e-10,  1.329258414521775e-11, -5.285164617899417e-13,  1.900052623426796e-14, -6.255949332684623e-16,  1.905258249009534e-17,
 -5.406185200954164e-19,  1.422901788999269e-05, -3.401635959217027e-06,  4.377488119710554e-07, -3.953804311448073e-08,  2.794300392964849e-09, -1.638831831728004e-10,
  8.273589915967296e-12, -3.685888963154587e-13,  1.475203986560492e-14, -5.376142087610491e-16,  1.802788290418363e-17, -5.604789285939118e-19,  3.602546613470406e-06,
 -1.007860364271385e-06,  1.504721120273732e-07, -1.559867696637236e-08,  1.253084694703653e-09, -8.282976473058220e-11,  4.677765049472644e-12, -2.315714946865014e-13,
  1.023749443097014e-14, -4.098790499993469e-16,  1.502529778200060e-17, -5.082737667344066e-19,  9.314283249000187e-07, -2.983247790306990e-07,  5.079848076397079e-08,
 -5.957104818500035e-09,  5.370319512869150e-10, -3.954589916837741e-11,  2.471609875653412e-12, -1.346039625421385e-13,  6.510861139642376e-15, -2.838024979663874e-16,
  1.127504297612407e-17, -4.115645946511123e-19,  2.560291986668612e-07, -9.173357553002160e-08,  1.747270904384833e-08, -2.278568679808997e-09,  2.269739531847664e-10,
 -1.835660356248075e-11,  1.252993930406930e-12, -7.414208886244154e-14,  3.878139503190527e-15, -1.820039346651900e-16,  7.753671117119472e-18, -3.023185381735927e-19,
  7.721421396451304e-08, -3.019641332194126e-08,  6.292128436376356e-09, -8.941497097120383e-10,  9.659616466680356e-11, -8.432451611229467e-12,  6.185008849828532e-13,
 -3.916233990480311e-14,  2.183490476587784e-15, -1.088341171123791e-16,  4.907847629248237e-18, -2.019006037244312e-19,  2.532547068520376e-08, -1.053317077647091e-08,
  2.341389735526200e-09, -3.541155625759441e-10,  4.058316533265156e-11, -3.745772378582616e-12,  2.895543802647739e-13, -1.926367227859713e-14,  1.125289113169938e-15,
 -5.860890594822652e-17,  2.754836100308076e-18, -1.178413602057485e-19,  7.386856145433500e-09, -3.180377732697001e-09,  7.335313126922390e-10, -1.149797327514177e-10,
  1.363278236470388e-11, -1.299352462389729e-12,  1.035296447272149e-13, -7.086998450495405e-15,  4.252648903624441e-16, -2.271742826683481e-17,  1.093609752768917e-18,
 -4.784327805783624e-20,  1.367410230711972e-01, -8.098737063498558e-04,  5.144254185239418e-06, -3.428993442135680e-08,  2.347877023995362e-10, -1.628627822915981e-12,
  1.132571774174419e-14, -7.869575701397520e-17,  5.436507464473046e-19, -3.742163600595405e-21,  2.553322779859856e-23, -1.739248436490250e-25,  1.157555906713778e-01,
 -1.026161448361335e-03,  1.117467111256808e-05, -1.199511623764826e-07,  1.231505863416550e-09, -1.215911193264789e-11,  1.162942254913025e-13, -1.083351665522638e-15,
  9.866262432090425e-18, -8.809349041275695e-20,  7.727513485387510e-22, -6.670955084808624e-24,  8.301618426202446e-02, -1.228514030952592e-03,  1.997787904062773e-05,
 -2.905422770753373e-07,  3.901783626049857e-09, -4.939906064167792e-11,  5.966084367335072e-13, -6.926768816346399e-15,  7.774552467969749e-17, -8.471476145680721e-19,
  8.991301486840541e-21, -9.318978789688398e-23,  5.052052885960714e-02, -1.203434107996073e-03,  2.650121837906092e-05, -4.978381421402725e-07,  8.444415784173392e-09,
 -1.326407696450442e-10,  1.958936885368856e-12, -2.748521145919717e-14,  3.691156043211153e-16, -4.771415822547625e-18,  5.962733290818086e-20, -7.227719527847684e-22,
  2.615863882706941e-02, -9.436460344747406e-04,  2.708117320554714e-05, -6.426072995288915e-07,  1.346569407252960e-08, -2.569091076517397e-10,  4.548195373793044e-12,
 -7.567830896053256e-14,  1.194421075563552e-15, -1.800409884587949e-17,  2.605627494095077e-19, -3.635197303632794e-21,  1.157019769992665e-02, -5.986397024597033e-04,
  2.196157092804958e-05, -6.473925003028049e-07,  1.649557280738975e-08, -3.767319038026131e-10,  7.886754982650401e-12, -1.536354081507838e-13,  2.814902415694830e-15,
 -4.889704906953302e-17,  8.102614545333907e-19, -1.286808771208220e-20,  4.396896796089133e-03, -3.122958072955322e-04,  1.444043170425093e-05, -5.218193276652502e-07,
  1.597708100633260e-08, -4.321211775668182e-10,  1.059067740234126e-11, -2.392543187027471e-13,  5.042971229813846e-15, -1.000762708458072e-16,  1.882875304077884e-18,
 -3.376242891459651e-20,  1.447302141947229e-03, -1.362579075905457e-04,  7.841552302767280e-06, -3.435527729493317e-07,  1.252172213305871e-08, -3.976824094127803e-10,
  1.132129626250797e-11, -2.944130949560979e-13,  7.088683806275470e-15, -1.596159970827743e-16,  3.387252478111144e-18, -6.813768485668917e-20,  4.173353693213610e-04,
 -5.061267992969601e-05,  3.581562903107393e-06, -1.884300404574019e-07,  8.110274972538640e-09, -3.003149180772096e-10,  9.865729051119620e-12, -2.935182313686845e-13,
  8.025414341734201e-15, -2.038816915348426e-16,  4.853274253080781e-18, -1.089327249183455e-19,  1.070693466210921e-04, -1.632717135487556e-05,  1.403916763151637e-06,
 -8.790814226425381e-08,  4.435401565758343e-09, -1.902520902705757e-10,  7.169697150505688e-12, -2.426826828891107e-13,  7.495392542676241e-15, -2.137398741671003e-16,
  5.678955238952730e-18, -1.415327423261265e-19,  2.495960452536640e-05, -4.684133727656602e-06,  4.835881648844181e-07, -3.571882761593356e-08,  2.097130273880470e-09,
 -1.035324636976413e-10,  4.449530537864715e-12, -1.704103940594774e-13,  5.914263561684691e-15, -1.883559728890882e-16,  5.558471457070718e-18, -1.530785175349269e-19,
  5.437063073400419e-06, -1.230622158268988e-06,  1.506358821977416e-07, -1.299923853122004e-08,  8.810369838016239e-10, -4.970921491733833e-11,  2.420721504832673e-12,
 -1.042692204977899e-13,  4.043182964315678e-15, -1.430200068404151e-16,  4.662759962032444e-18, -1.411553463294314e-19,  1.147559910680193e-06, -3.069942556240652e-07,
  4.394237361007381e-08, -4.381906023607265e-09,  3.396316651058260e-10, -2.171729410483281e-11,  1.189177129913691e-12, -5.719561655112919e-14,  2.461078305477722e-15,
 -9.606083803586509e-17,  3.438035485034921e-18, -1.137047523650650e-19,  2.454010041357639e-07, -7.595975753117496e-08,  1.251323990549996e-08, -1.422910226535774e-09,
  1.246636982529713e-10, -8.939691239733629e-12,  5.450968473701742e-13, -2.900908076013979e-14,  1.373207070348771e-15, -5.865617683383539e-17,  2.286345762007597e-18,
 -8.197543132191294e-20,  5.592304437253259e-08, -1.956925794849666e-08,  3.640650101117360e-09, -4.643706085815850e-10,  4.531248097779197e-11, -3.594934716162838e-12,
  2.410295669578578e-13, -1.402567310289276e-14,  7.222512372232734e-16, -3.340247750672021e-17,  1.403552910353862e-18, -5.402315523805006e-20,  1.422172045048595e-08,
 -5.483944453390874e-09,  1.126330849179731e-09, -1.578790554404366e-10,  1.683822602999825e-11, -1.452382447942626e-12,  1.053423309609089e-13, -6.600620158348808e-15,
  3.644290831193981e-16, -1.799867386952633e-17,  8.046862004453107e-19, -3.283735580240938e-20,  4.073314161086260e-09, -1.682974414608832e-09,  3.715134538856492e-10,
 -5.581480978305295e-11,  6.356504704155723e-12, -5.832425458718326e-13,  4.483664086785154e-14, -2.967470598924541e-15,  1.725020559960236e-16, -8.943437981564633e-18,
  4.185675156220324e-19, -1.783241208017560e-20,  1.093739351793256e-09, -4.699093475461617e-10,  1.081337799049603e-10, -1.691193684488108e-11,  2.000902863098824e-12,
 -1.903187550525391e-13,  1.513476012998122e-14, -1.034119063748159e-15,  6.194467394266600e-17, -3.303514974134597e-18,  1.587765128405833e-19, -6.935620037594000e-21,
  1.335813172889508e-01, -7.703041106090899e-04,  4.754285571843328e-06, -3.077985824235183e-08,  2.047644922614807e-10, -1.381404315543470e-12,  9.346862755088237e-15,
 -6.327133958289527e-17,  4.256127722440089e-19, -2.858727946071227e-21,  1.898300493285046e-23, -1.265370341403024e-25,  1.118210730404012e-01, -9.422043109864051e-04,
  9.845921226985591e-06, -1.020505859901758e-07,  1.013949876506911e-09, -9.699110712140735e-12,  8.994313041702661e-14, -8.129370276119710e-16,  7.187233903366246e-18,
 -6.233301496442843e-20,  5.313296274819991e-22, -4.459393813351581e-24,  7.840109826988856e-02, -1.081646082914614e-03,  1.683569089306353e-05, -2.353008343876771e-07,
  3.042620293346311e-09, -3.715260732831964e-11,  4.333562097125713e-13, -4.864743643757128e-15,  5.284357634878112e-17, -5.577193493085053e-19,  5.737631607856343e-21,
 -5.767800112793940e-23,  4.609597249662632e-02, -1.013209936681873e-03,  2.125789495971318e-05, -3.816350874926771e-07,  6.205688637942849e-09, -9.367026952853507e-11,
  1.331845893089830e-12, -1.801720751225013e-14,  2.335871356374427e-16, -2.918085249255534e-18,  3.527532930882409e-20, -4.139719472946239e-22,  2.277321581020132e-02,
 -7.545343858655861e-04,  2.051044689889533e-05, -4.629805784284332e-07,  9.267459372000163e-09, -1.693953215492200e-10,  2.879579046692135e-12, -4.609146167177013e-14,
  7.008580604158879e-16, -1.019152262980072e-17,  1.424548600256290e-19, -1.921510629513860e-21,  9.483477645407169e-03, -4.500475790245998e-04,  1.555750957625493e-05,
 -4.347544274235342e-07,  1.055174788033341e-08, -2.303201140399885e-10,  4.620322239420907e-12, -8.642899806753602e-14,  1.523347798442864e-15, -2.549484792674303e-17,
  4.075818193496179e-19, -6.252483163819970e-21,  3.344472098251174e-03, -2.180511249250368e-04,  9.466417154240125e-06, -3.235028481692337e-07,  9.415592543404960e-09,
 -2.429720969137477e-10,  5.698125869771243e-12, -1.234673993958232e-13,  2.501091350276403e-15, -4.778299561617305e-17,  8.668063721245068e-19, -1.500684049787689e-20,
  1.005742559575269e-03, -8.713093026817844e-05,  4.699675158274784e-06, -1.944729320750736e-07,  6.730388717107941e-09, -2.037631747329842e-10,  5.546818052452255e-12,
 -1.382836235590253e-13,  3.198780234901107e-15, -6.932902776711419e-17,  1.418486599740559e-18, -2.755226615389699e-20,  2.604720714530326e-04, -2.918373847199086e-05,
  1.935909551214088e-06, -9.619863777121365e-08,  3.931475585790453e-09, -1.387825957658151e-10,  4.360304471455040e-12, -1.243967069172959e-13,  3.269001414215582e-15,
 -7.997614503777725e-17,  1.836597121195748e-18, -3.983177743220312e-20,  5.892880385299476e-05, -8.347205132720013e-06,  6.742255685441234e-07, -3.993323706609217e-08,
  1.915454575002181e-09, -7.841666942999647e-11,  2.829503849843195e-12, -9.194921571070987e-14,  2.732812769276504e-15, -7.514316019337885e-17,  1.928613045009803e-18,
 -4.650776195773425e-20,  1.188291305562499e-05, -2.085916115344846e-06,  2.030946688538375e-07, -1.423270452700647e-08,  7.965070143138602e-10, -3.762062410313031e-11,
  1.551627137934883e-12, -5.717857560912446e-14,  1.913782839637370e-15, -5.889793202937638e-17,  1.682617155868271e-18, -4.493379814450458e-20,  2.196394443689123e-06,
 -4.689446942721832e-07,  5.445122215226537e-08, -4.479430093926557e-09,  2.905863248396969e-10, -1.574518775180227e-11,  7.384465936788597e-13, -3.070857963926534e-14,
  1.152104205720076e-15, -3.950581619440911e-17,  1.250688856042169e-18, -3.682455437870442e-20,  3.865633170957796e-07, -9.851370807653244e-08,  1.347787764490830e-08,
 -1.289492173684395e-09,  9.621046008685490e-11, -5.939073208173170e-12,  3.147274898690879e-13, -1.468150193003254e-14,  6.138897218108974e-16, -2.332481774862113e-17,
  8.138901973903124e-19, -2.628143629760913e-20,  6.808239564869158e-08, -2.029458612664568e-08,  3.224573555502755e-09, -3.546063487658314e-10,  3.012139847681066e-11,
 -2.098974170710319e-12,  1.246180421103147e-13, -6.469073388685143e-15,  2.991869028292333e-16, -1.250396956771369e-17,  4.775011695960926e-19, -1.679386275888828e-20,
  1.274433577163083e-08, -4.343111088776349e-09,  7.871198461209668e-10, -9.796911306570219e-11,  9.344586011333222e-12, -7.258609746284652e-13,  4.771899329162659e-14,
 -2.726344053382864e-15,  1.380080213274451e-16, -6.281003465863365e-18,  2.599840690964516e-19, -9.866766057236986e-21,  2.697275045780165e-09, -1.023560550313751e-09,
  2.068298728601600e-10, -2.854836531610313e-11,  3.001264664117066e-12, -2.554274654189911e-13,  1.829637897249389e-14, -1.133148570197466e-15,  6.188540037668162e-17,
 -3.025474476730842e-18,  1.339789285199212e-19, -5.418766398181629e-21,  6.652702187222075e-10, -2.728000614462271e-10,  5.974625149920526e-11, -8.908493751795607e-12,
  1.007366499006150e-12, -9.181833955884235e-14,  7.014731595229194e-15, -4.615680595405778e-16,  2.668549110441771e-17, -1.376463301429481e-18,  6.411221642643656e-20,
 -2.719134880631375e-21,  1.627882024097149e-10, -6.977386510035351e-11,  1.601515815038610e-11, -2.498517002173368e-12,  2.949047320973669e-13, -2.798692813222482e-14,
  2.220839635429733e-15, -1.514355545489911e-16,  9.053607797037464e-18, -4.819435799864542e-19,  2.312317130359986e-20, -1.008384097316835e-21,  1.305739061039008e-01,
 -7.336935867180994e-04,  4.403710836774664e-06, -2.771303857054348e-08,  1.792437221874482e-10, -1.176889874365603e-12,  7.751453336540025e-15, -5.116204216728429e-17,
  3.351235138206001e-19, -2.200062948497044e-21,  1.419336974358685e-23, -9.309419632657718e-26,  1.082024055264685e-01, -8.680735921934082e-04,  8.712611814240082e-06,
 -8.726925661149246e-08,  8.398362938020234e-10, -7.789569138775298e-12,  7.009059357871473e-14, -6.151022509805482e-16,  5.282877517966896e-18, -4.453416711300642e-20,
  3.691095411942164e-22, -3.013909202260828e-24,  7.432710040160560e-02, -9.574804204155638e-04,  1.428136344950307e-05, -1.920413278960942e-07,  2.393454609597300e-09,
 -2.821261275545882e-11,  3.180881716105929e-13, -3.455223763846886e-15,  3.635130560960582e-17, -3.718683255063437e-19,  3.710688919334970e-21, -3.620276822628555e-23,
  4.235646331569094e-02, -8.599092031969320e-04,  1.721738874377928e-05, -2.957520669839974e-07,  4.615049423144037e-09, -6.700324347706670e-11,  9.179716879632005e-13,
 -1.198290903462567e-14,  1.500875165127117e-16, -1.813258211605749e-18,  2.121744095170696e-20, -2.412151878884375e-22,  2.005130640802414e-02, -6.103882218569479e-04,
  1.574362056292156e-05, -3.384466901429264e-07,  6.477906574241716e-09, -1.135412806835190e-10,  1.854823586404377e-12, -2.858092582599174e-14,  4.189935346132064e-16,
 -5.881481151390085e-18,  7.944706618856298e-20, -1.036645840498208e-21,  7.902801221489593e-03, -3.439002998144026e-04,  1.121889792927754e-05, -2.974863336632202e-07,
  6.883442155290696e-09, -1.437116789860254e-10,  2.764453162903480e-12, -4.968938543757934e-14,  8.429819594643071e-16, -1.359973620045372e-17,  2.098539825335346e-19,
 -3.110923732242929e-21,  2.602327134469357e-03, -1.556131651928818e-04,  6.349127096068609e-06, -2.053294821181221e-07,  5.684450815355493e-09, -1.400368769982620e-10,
  3.144072092236820e-12, -6.537157841287565e-14,  1.273169476377389e-15, -2.342492283964379e-17,  4.098410036034588e-19, -6.852517148912106e-21,  7.198619507032508e-04,
 -5.730607405659514e-05,  2.897909782539532e-06, -1.132902380506843e-07,  3.723984364919779e-09, -1.075023454103644e-10,  2.798918012186460e-12, -6.690550216891734e-14,
  1.487110882920628e-15, -3.102709537728179e-17,  6.121005297547712e-19, -1.148061913933584e-20,  1.686724097596687e-04, -1.742376490951015e-05,  1.082979664990010e-06,
 -5.081568511721505e-08,  1.971572673253408e-09, -6.633895138598745e-11,  1.993053679594162e-12, -5.451701634112857e-14,  1.376703687251374e-15, -3.242957107729637e-17,
  7.182974525692539e-19, -1.504931256370258e-20,  3.389669705366554e-05, -4.448135060594694e-06,  3.370827570413419e-07, -1.886800205254715e-08,  8.597866609469729e-10,
 -3.357371282049081e-11,  1.159270443096768e-12, -3.614821861087832e-14,  1.033299124265351e-15, -2.738220566352083e-17,  6.785355960765790e-19, -1.582414811841688e-20,
  5.951322423981168e-06, -9.739885118084612e-07,  8.925692540674399e-08, -5.925595243221596e-09,  3.156822050123948e-10, -1.424881902231806e-11,  5.633960846405850e-13,
 -1.995737802259348e-14,  6.436042330465498e-16, -1.912373984519470e-17,  5.284431305737742e-19, -1.367275436999551e-20,  9.378455228714412e-07, -1.881812265446800e-07,
  2.067245723143882e-08, -1.617710661286891e-09,  1.002604621204946e-10, -5.208599487862494e-12,  2.349133498433714e-13, -9.418415391145848e-15,  3.414385888769216e-16,
 -1.133565139608197e-17,  3.480736519792860e-19, -9.956566154706905e-21,  1.378680029753253e-07, -3.333860568449174e-08,  4.346092697180947e-09, -3.979076027683792e-10,
  2.851383619468478e-11, -1.695766268479311e-12,  8.680638623441351e-14, -3.920711336272707e-15,  1.590565874507574e-16, -5.874081824705376e-18,  1.995548107193943e-19,
 -6.283253682509569e-21,  1.994079713414017e-08, -5.702666490173958e-09,  8.711325222576767e-10, -9.238824924055738e-11,  7.589974147552865e-12, -5.128110591700737e-13,
  2.958528677599774e-14, -1.495309666087087e-15,  6.745030560662368e-17, -2.753739393961281e-18,  1.028725023206263e-19, -3.544069700783057e-21,  3.040572624924804e-09,
 -1.005891421463505e-09,  1.770837700128330e-10, -2.145252150379228e-11,  1.995581952888903e-12, -1.514539406278556e-13,  9.744384346953485e-15, -5.456646674024139e-16,
  2.710903577830855e-17, -1.212357446867281e-18,  4.936506312028931e-20, -1.844889623416157e-21,  5.284705165835366e-10, -1.969221629784194e-10,  3.906673579044050e-11,
 -5.299718108198767e-12,  5.482424914965091e-13, -4.596516761747652e-14,  3.246956063371721e-15, -1.985021891890094e-16,  1.071059840908347e-17, -5.177407682975098e-19,
  2.268636567659188e-20, -9.085269368401536e-22,  1.105557415811189e-10, -4.494277545861473e-11,  9.754667028190746e-12, -1.442040622720187e-12,  1.617579555857167e-13,
 -1.463338296694224e-14,  1.110151467622629e-15, -7.257134446964829e-17,  4.170123592997720e-18, -2.138717508784329e-19,  9.908350628431397e-21, -4.181312573581990e-22,
  2.437000382349305e-11, -1.041750440207457e-11,  2.384280000364560e-12, -3.709359963946163e-13,  4.366625808484918e-14, -4.133588584899496e-15,  3.272318450623528e-16,
 -2.226321809236926e-17,  1.328174953710493e-18, -7.055885825055985e-20,  3.378852956746373e-21, -1.470815621077950e-22,  1.277075514904643e-01, -6.997470971178682e-04,
  4.087616485765282e-06, -2.502379966141795e-08,  1.574562038787606e-10, -1.006903088969320e-12,  6.457881839601692e-15, -4.160330221786510e-17,  2.652229843936281e-19,
 -1.706724655787771e-21,  1.064399936071103e-23, -6.965408158077253e-26,  1.048631880842074e-01, -8.023444606018398e-04,  7.741144753967104e-06, -7.499233894922922e-08,
  6.995643931154259e-10, -6.296351935850850e-12,  5.501234900284291e-14, -4.690925845665196e-16,  3.916321614839326e-18, -3.211219174761357e-20,  2.589280516836479e-22,
 -2.058528143340660e-24,  7.071195114904739e-02, -8.518368194572888e-04,  1.218927792638485e-05, -1.578759630054728e-07,  1.898337406184632e-09, -2.161942323549534e-11,
  2.358022678867864e-13, -2.480377788917012e-15,  2.529227667231389e-17, -2.509557074846313e-19,  2.430523816268476e-21, -2.302829618476877e-23,  3.917147462047386e-02,
 -7.352054961151723e-04,  1.407077428478703e-05, -2.315397920564018e-07,  3.470689189336822e-09, -4.851039931375817e-11,  6.409338765504195e-13, -8.079450373460714e-15,
  9.783665471211913e-17, -1.143873486392450e-18,  1.296441815557043e-20, -1.428693037435909e-22,  1.783820775042727e-02, -4.990808248069563e-04,  1.223635394820517e-05,
 -2.507952387472963e-07,  4.594490320687300e-09, -7.728935971324146e-11,  1.214341817214238e-12, -1.802678673054977e-14,  2.549578574860803e-16, -3.456954284418460e-18,
  4.515385191979095e-20, -5.702602661246947e-22,  6.686475553424547e-03, -2.667533297431438e-04,  8.225527623839622e-06, -2.071637559226225e-07,  4.574007210660168e-09,
 -9.141267208110796e-11,  1.687370557336249e-12, -2.916169502360740e-14,  4.764728896462359e-16, -7.413827875331190e-18,  1.104757629801508e-19, -1.583318667776600e-21,
  2.067787811452084e-03, -1.133187973078086e-04,  4.350216016488231e-06, -1.332327832496349e-07,  3.510883722013907e-09, -8.261936172707216e-11,  1.776820594890502e-12,
 -3.546724542638048e-14,  6.644047760444848e-16, -1.177714246874979e-17,  1.987988293387799e-19, -3.211044534659037e-21,  5.296351617975843e-04, -3.869030523503644e-05,
  1.835267223442640e-06, -6.780900277384689e-08,  2.117892427610271e-09, -5.831591773499667e-11,  1.452589477772878e-12, -3.330196821262754e-14,  7.113965602517534e-16,
 -1.429065517789318e-17,  2.718723643447658e-19, -4.924505041352177e-21,  1.130856843938487e-04, -1.074901837275509e-05,  6.258682246247304e-07, -2.772734664472444e-08,
  1.021262960574182e-09, -3.275365649658120e-11,  9.409458054722274e-13, -2.467610265972313e-14,  5.987637139364413e-16, -1.357906555236022e-17,  2.900621083228876e-19,
 -5.869996137387575e-21,  2.033696095986229e-05, -2.465956880367787e-06,  1.751437005643570e-07, -9.258490943076976e-09,  4.005856434337199e-10, -1.491316133362682e-11,
  4.925463690124857e-13, -1.473089128058263e-14,  4.048212346916624e-16, -1.033442068666988e-17,  2.471468481944995e-19, -5.571644014548471e-21,  3.130837427083192e-06,
 -4.761789262182179e-07,  4.099722889337725e-08, -2.574861874510837e-09,  1.304362545317787e-10, -5.620675102330803e-12,  2.128643896451445e-13, -7.242142756528526e-15,
  2.248467491341328e-16, -6.445368669633621e-18,  1.721407039945241e-19, -4.312096183092062e-21,  4.230507506491679e-07, -7.947694944007817e-08,  8.239101804488323e-09,
 -6.120728767817724e-10,  3.617933907534448e-11, -1.799316673646208e-12,  7.793030220385762e-14, -3.008475709399893e-15,  1.052588205545590e-16, -3.379548838324759e-18,
  1.005412025849903e-19, -2.791102379677882e-21,  5.210300930141137e-08, -1.190637838174087e-08,  1.474376958902556e-09, -1.288422763411114e-10,  8.847704068166532e-12,
 -5.059279490259446e-13,  2.497218237172981e-14, -1.090237796283406e-15,  4.284490591746081e-17, -1.535726953487577e-18,  5.072389425197007e-20, -1.555273955863712e-21,
  6.180452511899877e-09, -1.688810014171348e-09,  2.471982889008200e-10, -2.521079626263875e-11,  1.998038695447376e-12, -1.305924798176427e-13,  7.306057650364320e-15,
 -3.588460878004079e-16,  1.575979655820106e-17, -6.274993916961521e-19,  2.289685913682430e-20, -7.715834118060372e-22,  7.621086351106235e-10, -2.438836969633797e-10,
  4.157552148080023e-11, -4.888635367425994e-12,  4.424122251350352e-13, -3.273323945122104e-14,  2.056931279655612e-15, -1.126856477494790e-16,  5.485052701604920e-18,
 -2.406603582479865e-19,  9.625633705858130e-21, -3.537623720876826e-22,  1.073433687073759e-10, -3.917670642653709e-11,  7.612306471679942e-12, -1.012750892898966e-12,
  1.028901520923236e-13, -8.483143448089415e-15,  5.900074495958502e-16, -3.555305871761102e-17,  1.892730767418229e-18, -9.035328923597744e-20,  3.913009364284265e-21,
 -1.550013947580771e-22,  1.873717709758882e-11, -7.541227720939572e-12,  1.620002189485123e-12, -2.371544493019086e-13,  2.636026801319022e-14, -2.364472134626405e-15,
  1.779647623627877e-16, -1.154824015856955e-17,  6.590448146723039e-19, -3.358402855126410e-20,  1.546589903149579e-21, -6.490121926494594e-23,  3.672204196092919e-12,
 -1.565011279457723e-12,  3.570309913242066e-13, -5.537167881605533e-14,  6.498948596368733e-15, -6.134852260642115e-16,  4.843741839143370e-17, -3.287204063598474e-18,
  1.956444639542362e-19, -1.037034581993307e-20,  4.955553124765742e-22, -2.152843651507611e-23,  1.249721216689408e-01, -6.682059572082612e-04,  3.801808365275054e-06,
 -2.265756332412269e-08,  1.387784032627232e-10, -8.649875651883742e-13,  5.403125182023732e-15, -3.402274507412617e-17,  2.107537560784122e-19, -1.337111985205979e-21,
  7.951382364297564e-24, -5.388402141508640e-26,  1.017722257161780e-01, -7.438337788969507e-04,  6.904460030989322e-06, -6.473921285852334e-08,  5.858453184063426e-10,
 -5.120510111241193e-12,  4.347176592363630e-14, -3.604324189065259e-16,  2.926796913743456e-18, -2.336012821495989e-20,  1.833095642375194e-22, -1.420521946280920e-24,
  6.748832176217381e-02, -7.614152692046229e-04,  1.046367319142288e-05, -1.306762545378704e-07,  1.517355521340704e-09, -1.670984175698034e-11,  1.764475830784545e-13,
 -1.798626685931967e-15,  1.778871012770562e-17, -1.713064246411190e-19,  1.611397528677074e-21, -1.483475731667036e-23,  3.643942993352226e-02, -6.328778478197084e-04,
  1.159597754591542e-05, -1.830056570707673e-07,  2.637660163013804e-09, -3.552365795815193e-11,  4.529976741698397e-13, -5.518574647428011e-15,  6.465395454521841e-17,
 -7.320147275258300e-19,  8.041106076549477e-21, -8.594664054572004e-23,  1.602022706781969e-02, -4.120864446567665e-04,  9.621568588101117e-06, -1.882225771726460e-07,
  3.303578860812012e-09, -5.338387291683343e-11,  8.073313855173147e-13, -1.155450483728582e-14,  1.577672688026326e-16, -2.067578510656408e-18,  2.612948996192256e-20,
 -3.195754221424842e-22,  5.736915923798363e-03, -2.097747534633846e-04,  6.124772064795123e-06, -1.466548423600495e-07,  3.092542892390980e-09, -5.921036582426596e-11,
  1.049552873056306e-12, -1.745182041772725e-14,  2.747886876228942e-16, -4.126053399418627e-18,  5.940426912796222e-20, -8.234744157626837e-22,  1.675190105685748e-03,
 -8.406932729973886e-05,  3.040615487207250e-06, -8.825972003519259e-08,  2.215427548507986e-09, -4.983319952896023e-11,  1.027179365753876e-12, -1.969449393684214e-14,
  3.550274591148700e-16, -6.065504218502360e-18,  9.881912379534834e-20, -1.542470347185865e-21,  3.997949220262249e-04, -2.676467182132025e-05,  1.191757312843343e-06,
 -4.163527446081314e-08,  1.236187021784187e-09, -3.248045191445904e-11,  7.743209477649471e-13, -1.703106971944194e-14,  3.497543985414220e-16, -6.766236172134091e-18,
  1.241582804902904e-19, -2.172183417232586e-21,  7.833153779518339e-05, -6.838041578893366e-06,  3.729791404263018e-07, -1.560178159290330e-08,  5.455802055638096e-10,
 -1.667958309446286e-11,  4.582196357108910e-13, -1.152132273375175e-14,  2.686317609984971e-16, -5.865146112203239e-18,  1.208201818637637e-19, -2.361513241661101e-21,
  1.270024529073050e-05, -1.419353454483001e-06,  9.440766400414844e-08, -4.710663914642505e-09,  1.934453665086077e-10, -6.863596792784350e-12,  2.167623043733242e-13,
 -6.215988354736467e-15,  1.641734465722905e-16, -4.036140755759065e-18,  9.312273653666350e-20, -2.028686583188657e-21,  1.727126897849669e-06, -2.433470151621319e-07,
  1.965191863396979e-08, -1.166275035526086e-09,  5.612462406488420e-11, -2.306950387366747e-12,  8.361735872898944e-14, -2.730350976095072e-15,  8.155273048688281e-17,
 -2.253782265533930e-18,  5.813923673718206e-20, -1.409082131798380e-21,  2.014244593572251e-07, -3.529625090212021e-08,  3.444630768624907e-09, -2.424738146198654e-10,
  1.364783301382319e-11, -6.488722451791873e-13,  2.695362666297210e-14, -1.000722963029751e-15,  3.375353707208181e-17, -1.046948774720750e-18,  3.014602240845125e-20,
 -8.113888646593409e-22,  2.087405636013015e-08, -4.488785587378762e-09,  5.263769253323220e-10, -4.379458158040412e-11,  2.875746171679721e-12, -1.578047081465326e-13,
  7.497391168741895e-15, -3.158826906661636e-16,  1.200719890398483e-17, -4.171275500315232e-19,  1.337712658523955e-20, -3.989116173340487e-22,  2.031248650173074e-09,
 -5.280447672729582e-10,  7.380499606424016e-11, -7.217000989876468e-12,  5.503621207430466e-13, -3.471836047842502e-14,  1.879586652354481e-15, -8.954136093739004e-17,
  3.821943675865380e-18, -1.481672326667293e-19,  5.272638706384467e-21, -1.735428156027649e-22,  2.013771380921196e-10, -6.209294625228083e-11,  1.021530480162029e-11,
 -1.162422432681599e-12,  1.020725198338145e-13, -7.345047269064941e-15,  4.498322474972891e-16, -2.406162328683277e-17,  1.145453478194843e-18, -4.922479287912310e-20,
  1.930953981499079e-21, -6.968834708328296e-23,  2.269111654966680e-11, -8.087531404875247e-12,  1.534995326386232e-12, -1.997940633820252e-13,  1.989119298501618e-14,
 -1.609602171870768e-15,  1.100269918937971e-16, -6.524459554383122e-18,  3.421958540817467e-19, -1.610993296248262e-20,  6.886980913990100e-22, -2.695266203874919e-23,
  3.247332527200398e-12, -1.291946412013677e-12,  2.742682937915045e-13, -3.970403094063908e-14,  4.367498833825199e-15, -3.879924000590504e-16,  2.894222606730483e-17,
 -1.862514824759305e-18,  1.054720553704364e-19, -5.336097266914780e-21,  2.440867664236304e-22, -1.017883785392556e-23,  5.574526731951502e-13, -2.367529519005596e-13,
  5.381319695911146e-14, -8.316355232147998e-15,  9.728222991228978e-16, -9.154288325674378e-17,  7.206309419122724e-18, -4.876925235683049e-19,  2.894976108587126e-20,
 -1.530712765230892e-21,  7.297526064399237e-23, -3.163275494553793e-24,  1.223584564123768e-01, -6.388425761600346e-04,  3.542691409911322e-06, -2.056877194179664e-08,
  1.227019958753401e-10, -7.460245117313409e-13,  4.538081320332054e-15, -2.799185651443003e-17,  1.678008607064288e-19, -1.063324003060299e-21,  5.804275922092307e-24,
 -4.478538873400577e-26,  9.890265692804989e-02, -6.915536621174813e-04,  6.180625777352707e-06, -5.613153258758346e-08,  4.931024528144979e-10, -4.188439047479548e-12,
  3.457386187709785e-14, -2.789288958338554e-16,  2.204039272821756e-18, -1.713894981187298e-20,  1.308726980227900e-22, -9.905999668455073e-25,  6.460069902377866e-02,
 -6.835896078357849e-04,  9.030896935123646e-06, -1.088580877402512e-07,  1.221736598985856e-09, -1.302039757857451e-11,  1.332100842255874e-13, -1.316792380269950e-15,
  1.264031016512320e-17, -1.182129151113026e-19,  1.080751453539321e-21, -9.671698330604078e-24,  3.408049196063206e-02, -5.482272583587841e-04,  9.631458821632129e-06,
 -1.459447928842277e-07,  2.024502774216315e-09, -2.629446660519932e-11,  3.238840763141513e-13, -3.815914771186187e-15,  4.328350550468362e-17, -4.748649329757902e-19,
  5.059066470063572e-21, -5.247379888240493e-23,  1.451269105997336e-02, -3.433248172656538e-04,  7.647940407263715e-06, -1.429545251308009e-07,  2.406136053231902e-09,
 -3.738193715903567e-11,  5.445885531876405e-13, -7.519759529725101e-15,  9.919278055554949e-17, -1.257232044651411e-18,  1.538194594348781e-20, -1.822855679872217e-22,
  4.985746648755436e-03, -1.670567035436535e-04,  4.626738085845495e-06, -1.054290719180916e-07,  2.125254891992296e-09, -3.901372297645171e-11,  6.645776875014854e-13,
 -1.063912229419622e-14,  1.615336851753065e-16, -2.341933806540768e-18,  3.259432823347080e-20, -4.372326552364744e-22,  1.381615693105488e-03, -6.344616312946243e-05,
  2.165166948332012e-06, -5.961348417742028e-08,  1.426487768303414e-09, -3.069191311959667e-11,  6.067156896274930e-13, -1.117992312984628e-14,  1.940370845624510e-16,
 -3.196560456422997e-18,  5.028447126563624e-20, -7.587724512530310e-22,  3.090570573037648e-04, -1.893639548410024e-05,  7.922476941337373e-07, -2.618540129030922e-08,
  7.394810462285650e-10, -1.854939995626242e-11,  4.234069452688321e-13, -8.937909797824222e-15,  1.765139998782998e-16, -3.289502508641398e-18,  5.823453182263131e-20,
 -9.842701453976494e-22,  5.594168076287198e-05, -4.476648429659268e-06,  2.287979729954452e-07, -9.038127006351912e-09,  3.001302108946108e-10, -8.748278408491568e-12,
  2.298602356222803e-13, -5.541963729680242e-15,  1.241751606310794e-16, -2.610291789904872e-18,  5.185631084341951e-20, -9.789391652299187e-22,  8.237872513314908e-06,
 -8.464388280026919e-07,  5.269680188305837e-08, -2.481048672348333e-09,  9.667823575993582e-11, -3.268527803974594e-12,  9.868546847051668e-14, -2.712915992454354e-15,
  6.884853843095755e-17, -1.629669528909884e-18,  3.626632193116294e-20, -7.632733892855102e-22,  9.972186113009138e-07, -1.297555393679177e-07,  9.815127380153007e-09,
 -5.498669393027333e-10,  2.511731850713253e-11, -9.841273612137463e-13,  3.411741721451635e-14, -1.068546129670781e-15,  3.068734028335046e-17, -8.171377721063250e-19,
  2.034825676037230e-20, -4.768810945977569e-22,  1.011049975005618e-07, -1.646338428355881e-08,  1.509157584378976e-09, -1.004876893845245e-10,  5.378159696366671e-12,
 -2.441362498268112e-13,  9.715221381394806e-15, -3.465317666332632e-16,  1.125651941395309e-17, -3.369749272010890e-19,  9.382489136064282e-21, -2.446206874648074e-22,
  8.865574294769707e-09, -1.786332170583986e-09,  1.977695245203081e-10, -1.562805313736531e-11,  9.792532758150154e-13, -5.147306864764605e-14,  2.350013322871351e-15,
 -9.540477290296473e-17,  3.502683720022249e-18, -1.177750386405797e-19,  3.662565712972812e-21, -1.060931347505578e-22,  7.091077192452904e-10, -1.745750833974727e-10,
  2.321678109125950e-11, -2.170251799080442e-12,  1.588373130277395e-13, -9.648465769113414e-15,  5.044196984377697e-16, -2.326251969920486e-17,  9.633058212253147e-19,
 -3.630092923719185e-20,  1.257858923609235e-21, -4.037817228122722e-23,  5.628684548632011e-11, -1.665071075574761e-11,  2.633987037894612e-12, -2.891484464267613e-13,
  2.456768393967613e-14, -1.715115048778030e-15,  1.021400282773161e-16, -5.323559748723036e-18,  2.473848788164445e-19, -1.039447018615948e-20,  3.992526827157282e-22,
 -1.412813355086034e-23,  5.012485176790370e-12, -1.738853759447351e-12,  3.213920134129716e-13, -4.081549707188662e-14,  3.972478349587179e-15, -3.148117612540572e-16,
  2.110854922133224e-17, -1.229569929529321e-18,  6.342963387511711e-20, -2.940518439339313e-21,  1.239160859353153e-22, -4.785151737779297e-24,  5.772776285828959e-13,
 -2.266074360524877e-13,  4.745512263760402e-14, -6.782292708811714e-15,  7.372500455593298e-16, -6.477894861606578e-17,  4.783314584721270e-18, -3.049358050851728e-19,
  1.711799005950245e-20, -8.590398811443892e-22,  3.899878570779569e-23, -1.614919832468353e-24,  8.533746425447389e-14, -3.609944260452750e-14,  8.170943123699644e-15,
 -1.257674250013697e-15,  1.465618295183498e-16, -1.374251113974272e-17,  1.078214974776926e-18, -7.274102671653853e-20,  4.305286597768559e-21, -2.270129871670607e-22,
  1.079450006085988e-23, -4.667678372245945e-25,  1.198582516130292e-01, -6.114560677819034e-04,  3.307171628088093e-06, -1.871924227564065e-08,  1.088101509266936e-10,
 -6.459429181264236e-13,  3.824026978481793e-15, -2.319366559050600e-17,  1.332375357985819e-19, -8.693161857733020e-22,  3.915954508390933e-24, -4.203609090651737e-26,
  9.623124760681358e-02, -6.446749317385599e-04,  5.551759966416142e-06, -4.886947825392649e-08,  4.170376828697037e-10, -3.444952655978921e-12,  2.766524456490396e-14,
 -2.173407921388193e-16,  1.671633310910737e-18, -1.268166107059164e-20,  9.411197774122122e-23, -6.987761764618911e-25,  6.200300613221965e-02, -6.162540297233620e-04,
  7.833823435621178e-06, -9.123162093970632e-08,  9.905331417920440e-10, -1.022374373442344e-11,  1.014179822509160e-13, -9.728154245595156e-16,  9.070234279307553e-18,
 -8.241706566217580e-20,  7.329602777878206e-22, -6.376734017642093e-24,  3.203132242845735e-02, -4.776676663151237e-04,  8.058394415294099e-06, -1.173712193926176e-07,
  1.568437725638787e-09, -1.966138662212098e-11,  2.341138449897890e-13, -2.669412742289470e-15,  2.933622794606547e-17, -3.120511944435714e-19,  3.226542127657225e-21,
 -3.249000282872519e-23,  1.325174874400785e-02, -2.884011799439654e-04,  6.140922270536461e-06, -1.097929465501457e-07,  1.773834296334783e-09, -2.651770314914495e-11,
  3.724332744277931e-13, -4.965085883059047e-15,  6.331527433033751e-17, -7.765985228029967e-19,  9.204166020565832e-21, -1.057418077339475e-22,  4.384279475151407e-03,
 -1.345794589169891e-04,  3.542418352024406e-06, -7.689227190477799e-08,  1.483067711707263e-09, -2.612425409525189e-11,  4.279722691995058e-13, -6.600698015397450e-15,
  9.669779545643233e-17, -1.354406728673956e-18,  1.823194594632655e-20, -2.367830972055590e-22,  1.158435238183714e-03, -4.864026320910194e-05,  1.568790924760996e-06,
 -4.100427555245929e-08,  9.361259524050745e-10, -1.927946474175544e-11,  3.657372899290075e-13, -6.480800225077095e-15,  1.083506026228052e-16, -1.721981621628608e-18,
  2.616642092467886e-20, -3.818501722191156e-22,  2.442481895386214e-04, -1.367916256320712e-05,  5.383513081180566e-07, -1.684435013213760e-08,  4.527263323828430e-10,
 -1.084771877496898e-11,  2.371944773531552e-13, -4.807552883338089e-15,  9.133816182402670e-17, -1.640263554553709e-18,  2.802279365217769e-20, -4.576848888398057e-22,
  4.110884408071241e-05, -3.010041932383938e-06,  1.442231327955281e-07, -5.381697930047726e-09,  1.697601774607541e-10, -4.719072368607306e-12,  1.186194202014664e-13,
 -2.742929160966782e-15,  5.907080284943303e-17, -1.195681308498640e-18,  2.290976305368722e-20, -4.177381710788504e-22,  5.538196613998928e-06, -5.219025432894097e-07,
  3.040382275432583e-08, -1.350430887521059e-09,  4.992773339069478e-11, -1.608276580586920e-12,  4.641884267192676e-14, -1.223182406023909e-15,  2.982387427477571e-17,
 -6.795948606877341e-19,  1.458475813811910e-20, -2.964928702580720e-22,  6.014323933474280e-07, -7.204650952007926e-08,  5.098923547051769e-09, -2.694373177889570e-10,
  1.167523178536917e-11, -4.358133643244428e-13,  1.444354169047174e-14, -4.336870090669291e-16,  1.196968516789163e-17, -3.069565020144721e-19,  7.375275804253890e-21,
 -1.670590266598826e-22,  5.342362707764818e-08, -8.053288196346001e-09,  6.919958754910621e-10, -4.351867764863941e-11,  2.211938016721837e-12, -9.576252954805524e-14,
  3.647048813616574e-15, -1.248582019066344e-16,  3.902521717016474e-18, -1.126555230197762e-19,  3.030586241743670e-21, -7.647583178982661e-23,  3.990216252862564e-09,
 -7.500273283293139e-10,  7.816991897955286e-11, -5.853438700715381e-12,  3.493157313924343e-13, -1.755796273214225e-14,  7.691101467840825e-16, -3.004329123831063e-17,
  1.063917320979777e-18, -3.458054211466495e-20,  1.041537733380458e-21, -2.927250994534973e-23,  2.632876253626278e-10, -6.109125022288038e-11,  7.702611314954545e-12,
 -6.862673291583360e-13,  4.808098327980123e-14, -2.805987449412961e-15,  1.413693417747928e-16, -6.299438622101307e-18,  2.526354821962751e-19, -9.238931164473191e-21,
  3.112469749454737e-22, -9.730254883327469e-24,  1.669565358762418e-11, -4.716049486414921e-12,  7.145738230211413e-13, -7.542412474832085e-14,  6.182886964633754e-15,
 -4.176752710309792e-16,  2.413078868393120e-17, -1.222873540735532e-18,  5.536275111891559e-20, -2.270283629945474e-21,  8.524111533036324e-23, -2.952911905598664e-24,
  1.162157233637701e-12, -3.908939280962460e-13,  7.011810194931429e-14, -8.662242276280696e-15,  8.219911771647574e-16, -6.364310187131895e-17,  4.176858726624435e-18,
 -2.385307646878861e-19,  1.208137489446766e-20, -5.506167634214969e-22,  2.283847784808394e-23, -8.690142843352312e-25,  1.056361198062410e-13, -4.082347745206258e-14,
  8.415491476680646e-15, -1.185167275860512e-15,  1.270911605353025e-16, -1.102796967243017e-17,  8.049612247126630e-19, -5.077165532384567e-20,  2.822134302287714e-21,
 -1.403336787348032e-22,  6.316920446614784e-24, -2.595225870901187e-25,  1.319009720676532e-14, -5.554071116901957e-15,  1.251091506945444e-15, -1.916836861518360e-16,
  2.224134338070071e-17, -2.077076314392998e-18,  1.623505635000266e-19, -1.091432570165223e-20,  6.438528504610536e-22, -3.384480240488643e-23,  1.604658165129456e-24,
 -6.919868407186826e-26,  1.174639599536803e-01, -5.858685725237336e-04,  3.092575742397662e-06, -1.707685669275748e-08,  9.675882668646877e-11, -5.615054812362329e-13,
  3.229784539804312e-15, -1.940419037124223e-17,  1.043136524280971e-19, -7.499494200361257e-22,  2.042237937288886e-24, -4.326212482244467e-26,  9.373781548098283e-02,
 -6.024981645104988e-04,  5.003199631190165e-06, -4.271395776728823e-08,  3.543148989402983e-10, -2.848365948716831e-12,  2.226481215685586e-14, -1.704828008689325e-16,
  1.276039587828207e-18, -9.467844600903656e-21,  6.803096955520806e-23, -4.988793267116838e-25,  5.965675849043566e-02, -5.577078596050530e-04,  6.827791927436547e-06,
 -7.689534497516491e-08,  8.083508036812367e-10, -8.086332178950272e-12,  7.783395038889704e-14, -7.248876050149017e-16,  6.569776136914872e-18, -5.801637560703218e-20,
  5.025279078345689e-22, -4.248341942270310e-24,  3.024123109317788e-02, -4.184357352098360e-04,  6.788457070027233e-06, -9.514038220764081e-08,  1.225850309356862e-09,
 -1.484305130975789e-11,  1.709867249098613e-13, -1.888033630623029e-15,  2.011824248019652e-17, -2.075786575142732e-19,  2.084884677957056e-21, -2.038582624848578e-23,
  1.218868623464019e-02, -2.440987509579186e-04,  4.977646567477897e-06, -8.521223346243602e-08,  1.322685594902755e-09, -1.904212597129898e-11,  2.580315653967757e-13,
 -3.323453623198393e-15,  4.099941078465346e-17, -4.869249687346784e-19,  5.594044289246679e-21, -6.233182794106288e-23,  3.897317880602619e-03, -1.095639181093871e-04,
  2.746493616405798e-06, -5.684207249112679e-08,  1.049958323444603e-09, -1.776157762576331e-11,  2.800400153419835e-13, -4.163869933228545e-15,  5.889358409384391e-17,
 -7.973781210367081e-19,  1.038734205397227e-20, -1.306702306822917e-22,  9.861829125098901e-04, -3.783000106681314e-05,  1.155275058030074e-06, -2.868937020136508e-08,
  6.254208452325929e-10, -1.233831808203913e-11,  2.247665780216244e-13, -3.832261507242494e-15,  6.175215238334811e-17, -9.472432294484283e-19,  1.391042254142205e-20,
 -1.963981607979949e-22,  1.970193781031279e-04, -1.007242366879619e-05,  3.734111146334153e-07, -1.106751789275115e-08,  2.832958189300051e-10, -6.487811800887149e-12,
  1.359662207097606e-13, -2.647247056110366e-15,  4.840482824707949e-17, -8.379544445616646e-19,  1.382000954911755e-20, -2.181774587092685e-22,  3.102409285954118e-05,
 -2.074687280161802e-06,  9.326309876614813e-08, -3.288630371379777e-09,  9.858202414294863e-11, -2.614469080088088e-12,  6.288950102107574e-14, -1.395126212592683e-15,
  2.888407358701508e-17, -5.630816386867487e-19,  1.040724001405265e-20, -1.833157157457014e-22,  3.850797339491378e-06, -3.320144500867579e-07,  1.809861781838775e-08,
 -7.583401691554995e-10,  2.660282340183748e-11, -8.165038496831943e-13,  2.252857697402282e-14, -5.690409263019110e-16,  1.332964581545425e-17, -2.923897641906092e-19,
  6.050923463258611e-21, -1.188034097596377e-22,  3.780942588099422e-07, -4.157025520753768e-08,  2.750214376706729e-09, -1.369926390125550e-10,  5.628583369838926e-12,
 -2.000869976403047e-13,  6.336938438631644e-15, -1.823520063754310e-16,  4.835035206174886e-18, -1.193690634879783e-19,  2.766298848490075e-21, -6.053843098934041e-23,
  2.966524837675496e-08, -4.124246735472123e-09,  3.315927038919437e-10, -1.966959509344066e-11,  9.484223526668758e-13, -3.912363635035852e-14,  1.424742846666833e-15,
 -4.677839034779187e-17,  1.405736187007337e-18, -3.910193244402410e-20,  1.015563582508006e-21, -2.478638971767019e-23,  1.901675292212719e-09, -3.319739418544780e-10,
  3.248129816257371e-11, -2.299873326140665e-12,  1.304820773543741e-13, -6.261717279082878e-15,  2.627910987737315e-16, -9.863997394883957e-18,  3.365128042556986e-19,
 -1.056046821825337e-20,  3.077130284304185e-22, -8.381870047216192e-24,  1.040596408862810e-10, -2.264304989812539e-11,  2.696920922536021e-12, -2.283507121560134e-13,
  1.527685739623918e-14, -8.546569218762125e-16,  4.141210987663375e-17, -1.779741253690187e-18,  6.900685121503723e-20, -2.445109083721765e-21,  7.996420762017713e-23,
 -2.431076202905293e-24,  5.270825249967539e-12, -1.414441142909870e-12,  2.044411703199651e-13, -2.067723550159537e-14,  1.630459186324075e-15, -1.062965039266861e-16,
  5.943439536591135e-18, -2.922128286217247e-19,  1.286246343905628e-20, -5.138168154922367e-22,  1.882545277371145e-23, -6.373906865678791e-25,  2.841001047810287e-13,
 -9.224726428140039e-14,  1.599829042338134e-14, -1.916224337634580e-15,  1.767727914022235e-16, -1.333715267014727e-17,  8.547405229865559e-19, -4.775352038878522e-20,
  2.370108668450393e-21, -1.060061194807361e-22,  4.320683519443791e-24, -1.617518366050406e-25,  1.997865928514285e-14, -7.580903678750691e-15,  1.534516897778152e-15,
 -2.124773973379528e-16,  2.243284321975957e-17, -1.918910926069639e-18,  1.382375240451570e-19, -8.614187092846867e-21,  4.734964417189615e-22, -2.330291866887713e-23,
  1.038940634448396e-24, -4.230606960753510e-26,  2.061411811715578e-15, -8.633763855067815e-16,  1.933989394001173e-16, -2.947458662817183e-17,  3.403086281710992e-18,
 -3.163467710139710e-19,  2.462086939085356e-20, -1.648591768959131e-21,  9.689159724100194e-23, -5.075523899070259e-24,  2.398597836817089e-25, -1.031217548560412e-26,
  1.151687050978690e-01, -5.619221643211957e-04,  2.896584869345864e-06, -1.561452296006933e-08,  8.626170195752172e-11, -4.901577367139608e-13,  2.729231907780615e-15,
 -1.648606290795319e-17,  7.833109875735968e-20, -7.056856451243159e-22,  2.171558063467991e-25, -3.637819518015843e-26,  9.140475833321629e-02, -5.644306124040627e-04,
  4.522856250115224e-06, -3.747316846025086e-08,  3.023270551860915e-10, -2.366975691841689e-12,  1.801522887085331e-14, -1.346179938801469e-16,  9.793044042404378e-19,
 -7.140711838853389e-21,  4.935469363895368e-23, -3.571111476045306e-25,  5.752962266917499e-02, -5.065682937485572e-04,  5.977623378040293e-06, -6.516054674170156e-08,
  6.637753272292195e-10, -6.439922979451712e-12,  6.019205239324998e-14, -5.445303935166520e-16,  4.802151476990591e-18, -4.120205770923305e-20,  3.482666194205579e-22,
 -2.860594930303233e-24,  2.866931549940657e-02, -3.683825827611060e-04,  5.755333804240871e-06, -7.769544715002110e-08,  9.660926697323200e-10, -1.130737168653299e-11,
  1.261166849875738e-13, -1.349322317754192e-15,  1.395315657405914e-17, -1.396732995290911e-19,  1.364278258466719e-21, -1.295761697704697e-23,  1.128592977127960e-02,
 -2.080349000543905e-04,  4.070519252414649e-06, -6.678869621710268e-08,  9.969357468867140e-10, -1.383257104301733e-11,  1.809867778398430e-13, -2.253598441256522e-15,
  2.691490326963631e-17, -3.096524086698915e-19,  3.450920566576076e-21, -3.731206372395472e-23,  3.499056464173383e-03, -9.005960743271411e-05,  2.154545217559459e-06,
 -4.255554180522681e-08,  7.534903775988968e-10, -1.225063089753387e-11,  1.860332026594559e-13, -2.668405380374406e-15,  3.646285781553734e-17, -4.774658084398282e-19,
  6.022686757540816e-21, -7.342237463419797e-23,  8.513845484133741e-04, -2.981179203032959e-05,  8.637583165459653e-07, -2.039650662599392e-08,  4.249399546629279e-10,
 -8.036314378906889e-12,  1.406795284666872e-13, -2.309299925502210e-15,  3.588547114780380e-17, -5.315656705799030e-19,  7.547562361214708e-21, -1.031424929055367e-22,
  1.619602262879321e-04, -7.548142180875167e-06,  2.640276745820270e-07, -7.417910382716409e-09,  1.809663578943815e-10, -3.963543124300755e-12,  7.965786858564905e-14,
 -1.490572471213842e-15,  2.624280447698866e-17, -4.381130323237682e-19,  6.977857521848005e-21, -1.065147078229422e-22,  2.400083246823196e-05, -1.463122692811202e-06,
  6.177126582243608e-08, -2.059242123729200e-09,  5.869160947234352e-11, -1.485643957882008e-12,  3.421143944111987e-14, -7.283281679370730e-16,  1.450051755106514e-17,
 -2.723156947600655e-19,  4.856077627192366e-21, -8.264258207233616e-23,  2.763474151347398e-06, -2.174638522030553e-07,  1.109571847206325e-08, -4.386184026369182e-10,
  1.460220902879405e-11, -4.270941328468613e-13,  1.126660107181089e-14, -2.728055856479807e-16,  6.139806152101846e-18, -1.296480569866102e-19,  2.587219418878261e-21,
 -4.905883879241479e-23,  2.472240855775603e-07, -2.487115530672755e-08,  1.537272811067793e-09, -7.215156144393939e-11,  2.810057366748809e-12, -9.510626467305647e-14,
  2.877741880225044e-15, -7.934223456910148e-17,  2.020529550193602e-18, -4.801074805247529e-20,  1.072823654595341e-21, -2.267619712540091e-23,  1.727753787778057e-08,
 -2.206962274832215e-09,  1.657744749220405e-10, -9.264905185862475e-12,  4.234188111762166e-13, -1.662970286841245e-14,  5.786592518100498e-16, -1.820836902955593e-17,
  5.257458091711925e-19, -1.408248830756753e-20,  3.528975797851287e-22, -8.325124409035168e-24,  9.585727124958672e-10, -1.547085120714640e-10,  1.417414384423765e-11,
 -9.471554700899300e-13,  5.100430383582846e-14, -2.333565342198998e-15,  9.370870219392904e-17, -3.375863330576683e-18,  1.108230701350689e-19, -3.354287738047105e-21,
  9.445641796276624e-23, -2.491151308476802e-24,  4.379461051295091e-11, -8.890384304307669e-12,  9.967517227237508e-13, -7.997837987130717e-14,  5.096988659061312e-15,
 -2.727703254293293e-16,  1.268722813270709e-17, -5.249449651364238e-19,  1.964623306321648e-20, -6.734331463952879e-22,  2.134876796848951e-23, -6.303153858248493e-25,
  1.775623091757992e-12, -4.501941479361983e-13,  6.180920129573955e-14, -5.969049000132318e-15,  4.513716801021769e-16, -2.832248063677465e-17,  1.528897880821140e-18,
 -7.276559664772701e-20,  3.107784180532867e-21, -1.207069710601201e-22,  4.307931994844609e-24, -1.423208448279036e-25,  7.356958026898317e-14, -2.294675229677620e-14,
  3.831480200828832e-15, -4.433450116210263e-16,  3.963393308989192e-17, -2.905733590858849e-18,  1.813851527473333e-19, -9.891339039714167e-21,  4.800678279874071e-22,
 -2.103121788979574e-23,  8.408633051772738e-25, -3.092104086208051e-26,  3.923252828008978e-15, -1.457073310645418e-15,  2.887648738791304e-16, -3.921039364011299e-17,
  4.066412138684805e-18, -3.422031860915180e-19,  2.428577036885591e-20, -1.492681252459785e-21,  8.101575551377733e-23, -3.940819610086872e-24,  1.738084057239518e-25,
 -7.007116581176043e-27,  3.263280087679253e-16, -1.358170012810960e-16,  3.022611131178569e-17, -4.578331741547409e-18,  5.255966396622998e-19, -4.860113197526225e-20,
  3.764082488160285e-21, -2.508972056978787e-22,  1.468369635302026e-23, -7.661663894848605e-25,  3.607505974696065e-26, -1.545663835103343e-27,  1.129662072651660e-01,
 -5.394762419628317e-04,  2.717179324158157e-06, -1.430935420021904e-08,  7.707753672341274e-11, -4.299357256807545e-13,  2.298891498215861e-15, -1.438689350631683e-17,
  5.277846175988004e-20, -7.192040888069528e-22, -5.328130838851054e-25,  1.422672678330515e-26,  8.921666515776555e-02, -5.299676928222622e-04,  4.100712163564101e-06,
 -3.299238059716815e-08,  2.590232232277029e-10, -1.976525308595344e-12,  1.464855668895654e-14, -1.070409231985778e-16,  7.543047421718280e-19, -5.446149461735249e-21,
  3.620577757904901e-23, -2.422672427152319e-25,  5.559428186322805e-02, -4.617037693407678e-04,  5.255409701859194e-06, -5.549692692137095e-08,  5.482722234088939e-10,
 -5.162191529757339e-12,  4.689141271479187e-14, -4.121332842568580e-16,  3.542032218947440e-18, -2.949411478336717e-20,  2.436812709280920e-22, -1.958975837878400e-24,
  2.728231524717485e-02, -3.258226956122645e-04,  4.908770150116690e-06, -6.389468156974591e-08,  7.673953058240041e-10, -8.687784321071208e-12,  9.389985953914010e-14,
 -9.737621035138303e-16,  9.783891895795081e-18, -9.499006432324880e-20,  9.032543719956324e-22, -8.359438277279156e-24,  1.051419945062027e-02, -1.784250289522820e-04,
  3.356341045122776e-06, -5.283475530915083e-08,  7.590724972859597e-10, -1.015819475857065e-11,  1.284409074861106e-13, -1.546947751455429e-15,  1.790190471583778e-17,
 -1.995738111993693e-19,  2.159090584979332e-21, -2.267969555447837e-23,  3.170323169049905e-03, -7.467812434707965e-05,  1.708850066657024e-06, -3.224042873861129e-08,
  5.476933922097388e-10, -8.564932608716401e-12,  1.253673604031975e-13, -1.735773878320998e-15,  2.293116408036695e-17, -2.905498916547012e-19,  3.550813744229315e-21,
 -4.197772749661571e-23,  7.445558297029752e-04, -2.377629790294817e-05,  6.550298299793347e-07, -1.471968912262718e-08,  2.933417914475058e-10, -5.321967754424590e-12,
  8.958812496811163e-14, -1.416725591967377e-15,  2.124346149701469e-17, -3.040235220043081e-19,  4.175816785356407e-21, -5.526046272837532e-23,  1.354906590739184e-04,
 -5.748171469015968e-06,  1.900710214939664e-07, -5.065394070973892e-09,  1.178676966458839e-10, -2.470544918499823e-12,  4.764435312289791e-14, -8.572829174219423e-16,
  1.453972900115732e-17, -2.341858956979332e-19,  3.603419684057391e-21, -5.320396079833989e-23,  1.900006715893106e-05, -1.053831368564361e-06,  4.184183555195866e-08,
 -1.319362142687323e-09,  3.577454364186967e-11, -8.647290025355872e-13,  1.907176975542391e-14, -3.897924852321155e-16,  7.465329658885515e-18, -1.350955535004974e-19,
  2.324946724142282e-21, -3.823664758148888e-23,  2.042672835493941e-06, -1.463451634597447e-07,  6.993575222753008e-09, -2.608731141984579e-10,  8.244327730989861e-12,
 -2.298475869604019e-13,  5.798208320659550e-15, -1.346101210390098e-16,  2.911137663578900e-18, -5.918113742549062e-20,  1.138899604190449e-21, -2.085736079427551e-23,
  1.677674800454957e-07, -1.539537273241345e-08,  8.888181914045983e-10, -3.929684720565554e-11,  1.450565686154657e-12, -4.673621172856781e-14,  1.350907995934746e-15,
 -3.568132848937658e-17,  8.725829509527222e-19, -1.995195351057935e-20,  4.298067218689155e-22, -8.772650375088270e-24,  1.053248454106156e-08, -1.231426702534594e-09,
  8.630977322369385e-11, -4.540692186431659e-12,  1.965486877148756e-13, -7.345058079553411e-15,  2.440781219622919e-16, -7.356656328558946e-18,  2.039860183221555e-19,
 -5.258765931307074e-21,  1.270820431981506e-22, -2.896217785080130e-24,  5.102856815496599e-10, -7.579333023780298e-11,  6.487235159564108e-12, -4.083988721510892e-13,
  2.084448948109673e-14, -9.080995469996770e-16,  3.485321972515792e-17, -1.203787206037389e-18,  3.798868060649015e-20, -1.107880104910988e-21,  3.012213572270617e-23,
 -7.684787307239113e-25,  1.962368982229995e-11, -3.696541591469452e-12,  3.887797179948177e-13, -2.948315995409332e-14,  1.785839524759667e-15, -9.124040216994521e-17,
  4.066387577966927e-18, -1.617157193162871e-19,  5.832764172121692e-21, -1.931362372867045e-22,  5.926798340365558e-24, -1.697117495331502e-25,  6.396406380981843e-13,
 -1.523257487824780e-13,  1.977893014209968e-14, -1.817330857171008e-15,  1.313852733560873e-16, -7.913319161177220e-18,  4.114129383347969e-19, -1.891243121957610e-20,
  7.821365080182788e-22, -2.948049887835755e-23,  1.023052808295472e-24, -3.292395258438218e-26,  2.027532702068896e-14, -6.041079429780299e-15,  9.666951673803501e-16,
 -1.076392986424003e-16,  9.293433151222378e-18, -6.600837349397633e-19,  4.002659772384317e-20, -2.125322332389358e-21,  1.006448111991489e-22, -4.309900260839187e-24,
  1.687145195979376e-25, -6.083595920260223e-27,  8.041036637369995e-16, -2.911929141056824e-16,  5.630764046719607e-17, -7.475381331379789e-18,  7.595070289119757e-19,
 -6.273171309716209e-20,  4.376656052685321e-21, -2.648310358028862e-22,  1.416890105834814e-23, -6.801603794015976e-25,  2.963431513784773e-26, -1.181327272059072e-27,
  5.243814017993796e-17, -2.166229711926756e-17,  4.784236929017226e-18, -7.194864558429463e-19,  8.205205173725514e-20, -7.541034631365731e-21,  5.807622406657910e-22,
 -3.851028146129250e-23,  2.242983544891329e-24, -1.165131492255333e-25,  5.463317331865885e-27, -2.331789810247394e-28,  1.108507184154849e-01, -5.184053259743873e-04,
  2.552592103582683e-06, -1.314203941126222e-08,  6.899881116383856e-11, -3.794294835739563e-13,  1.915798368091031e-15, -1.311310755127014e-17,  2.697411311414158e-20,
 -6.908503946092912e-22,  3.138167086695613e-24,  1.787777209927662e-25,  8.715999401451803e-02, -4.986780605492424e-04,  3.728424523536800e-06, -2.914612354031131e-08,
  2.227789643766715e-10, -1.658369779002781e-12,  1.196174673200708e-14, -8.577946875692713e-17,  5.820524195307814e-19, -4.176785307970162e-21,  2.815335575739687e-23,
 -1.193662416634706e-25,  5.382753624389015e-02, -4.221826820253378e-04,  4.638861543319209e-06, -4.749308060361913e-08,  4.554098759388504e-10, -4.163384211130691e-12,
  3.679138219629510e-14, -3.140526715399017e-16,  2.636655673744571e-18, -2.128468215010401e-20,  1.708489289733223e-22, -1.400621308601768e-24,  2.605298700970913e-02,
 -2.894232010883098e-04,  4.210342735102882e-06, -5.289262861743286e-08,  6.141373799513461e-10, -6.728920372179841e-12,  7.054945471648160e-14, -7.090800215822191e-16,
  6.934667000040746e-18, -6.527991612716021e-20,  6.028033075125500e-22, -5.528499575654009e-24,  9.850457763822491e-03, -1.539183220949068e-04,  2.788995456960934e-06,
 -4.216106141503662e-08,  5.835343466375897e-10, -7.536741796256165e-12,  9.217475105274235e-14, -1.074145915824331e-15,  1.205813098504973e-17, -1.302902580722139e-19,
  1.367822323720347e-21, -1.402847187092641e-23,  2.896696394911437e-03, -6.241792475904336e-05,  1.369378371944363e-06, -2.469939221469734e-08,  4.029369975665997e-10,
 -6.065184192408823e-12,  8.564274518556844e-14, -1.145164597099699e-15,  1.463805464035107e-17, -1.795473721038605e-19,  2.126509973056923e-21, -2.441811630010206e-23,
  6.589152776534783e-04, -1.917020753902944e-05,  5.033865075803994e-07, -1.077313666178241e-08,  2.055483836180702e-10, -3.580124306179672e-12,  5.799646739255521e-14,
 -8.840341193093616e-16,  1.279938893157408e-17, -1.770638641504677e-19,  2.353596165215624e-21, -3.018278106220824e-23,  1.151949130708090e-04, -4.442070780250630e-06,
  1.391520594291759e-07, -3.519976136751731e-09,  7.818907550079470e-11, -1.569449860193628e-12,  2.906146017086608e-14, -5.030948562237102e-16,  8.224034566506407e-18,
 -1.278531490416620e-19,  1.901321269240724e-21, -2.716533111739711e-23,  1.536612724319882e-05, -7.738648361427676e-07,  2.894459988813494e-08, -8.637334961657398e-10,
  2.229568096072582e-11, -5.149072774875391e-13,  1.088205145474396e-14, -2.136112563107595e-16,  3.937018768489239e-18, -6.867639189891445e-20,  1.140944951351009e-21,
 -1.813831878163987e-23,  1.552123179755923e-06, -1.009819319893529e-07,  4.524250570704812e-09, -1.592931650794570e-10,  4.780716367448205e-12, -1.270865326347709e-13,
  3.066651802637864e-15, -6.827726950405111e-17,  1.419164102882241e-18, -2.777999728643740e-20,  5.156120203985295e-22, -9.120676497606919e-24,  1.178964818101664e-07,
 -9.837598371372671e-09,  5.305627264734613e-10, -2.209439271773523e-11,  7.730033241674638e-13, -2.370948563666996e-14,  6.546681556124412e-16, -1.656475772286488e-17,
  3.889831397886845e-19, -8.558116147250313e-21,  1.777116012945616e-22, -3.502110926730189e-24,  6.705633663923157e-09, -7.148378142286637e-10,  4.670969684496695e-11,
 -2.311548486183177e-12,  9.472152544917786e-14, -3.366579495991653e-15,  1.067911006115508e-16, -3.081849055997301e-18,  8.202905348944272e-20, -2.034463425972897e-21,
  4.739108916198017e-23, -1.042940283994354e-24,  2.863671227094339e-10, -3.896220829519124e-11,  3.109143597298415e-12, -1.841246629099695e-13,  8.896363632459061e-15,
 -3.686560024139141e-16,  1.351006733234875e-17, -4.469601272888459e-19,  1.354728165728809e-20, -3.803566164927763e-22,  9.976692932373662e-24, -2.460125674737734e-25,
  9.355821193928651e-12, -1.626327891831669e-12,  1.599352217543179e-13, -1.143437318968756e-14,  6.569035578152472e-16, -3.198243067524677e-17,  1.363526913578805e-18,
 -5.203992057349484e-20,  1.806300273349551e-21, -5.769802806756633e-23,  1.711710052535542e-24, -4.747733374779886e-26,  2.467809574262467e-13, -5.485582525599147e-14,
  6.706794063112142e-15, -5.842340166915528e-16,  4.026001203438084e-17, -2.321390200580178e-18,  1.159582610055357e-19, -5.137409686743766e-21,  2.053113546412306e-22,
 -7.495816121664426e-24,  2.524892037076572e-25, -7.902228058753068e-27,  5.973633045953518e-15, -1.689688571402198e-15,  2.578412964659821e-16, -2.751252797714277e-17,
  2.285875455863181e-18, -1.567946148543878e-19,  9.209819608907634e-21, -4.749355168867808e-22,  2.189290472265411e-23, -9.144505039169510e-25,  3.497915785096571e-26,
 -1.234527474754412e-27,  1.730176181790439e-16, -6.081691804800145e-17,  1.142863857544489e-17, -1.478290208097024e-18,  1.466987607148552e-19, -1.186043097801316e-20,
  8.115376287897905e-22, -4.824151386339059e-23,  2.539338672878007e-24, -1.200885420788186e-25,  5.160620395973546e-27, -2.031251587381346e-28,  8.575979772201968e-18,
 -3.511250838425014e-18,  7.684893023975168e-19, -1.146000573800405e-19,  1.296843738486871e-20, -1.183440543135883e-21,  9.054947541622258e-23, -5.968490232765994e-24,
  3.457148048455732e-25, -1.786706557307231e-26,  8.338434077690228e-28, -3.543389457720547e-29,  1.088169655451133e-01, -4.985972004766387e-04,  2.401268847900284e-06,
 -1.209639231307856e-08,  6.184068379279887e-11, -3.377804305447209e-13,  1.557263292310076e-15, -1.260317064612289e-17,  7.050177630171642e-21, -3.179518222415246e-22,
  1.813509445830996e-23,  5.398530677486819e-25,  8.522280380594636e-02, -4.701915057011617e-04,  3.399011680123354e-06, -2.583218161645072e-08,  1.922981556121064e-10,
 -1.398136430456835e-12,  9.799579052908891e-15, -6.934995349105747e-17,  4.510917801717895e-19, -3.111164315863963e-21,  2.632107328284321e-23,  4.458021654718364e-26,
  5.220958473565949e-02, -3.872336168857881e-04,  4.110063722270923e-06, -4.082751497828749e-08,  3.803062838283025e-10, -3.377042308503624e-12,  2.907267429549300e-14,
 -2.407347356566866e-16,  1.979537239748448e-18, -1.558012677122454e-20,  1.164922667794033e-22, -1.109524736369448e-24,  2.495886290745370e-02, -2.581219220513032e-04,
  3.630427877491982e-06, -4.405738687362752e-08,  4.950035984694198e-10, -5.250924804791126e-12,  5.347924669438489e-14, -5.205590109451295e-16,  4.965233748287886e-18,
 -4.547036651194974e-20,  3.998535410958067e-22, -3.850238189865355e-24,  9.276414061011189e-03, -1.334820907524362e-04,  2.334470947461915e-06, -3.391968811684981e-08,
  4.526935236024582e-10, -5.645842939045333e-12,  6.686439722415506e-14, -7.538743813903695e-16,  8.219678437653420e-18, -8.621466892415199e-20,  8.731731879130405e-22,
 -8.896951316183782e-24,  2.667201021492364e-03, -5.254741376765583e-05,  1.107998698908954e-06, -1.912117236918974e-08,  2.998405324508395e-10, -4.347036049685697e-12,
  5.927018165576015e-14, -7.656426181824277e-16,  9.477687201719004e-18, -1.126364685133371e-19,  1.291105669521050e-21, -1.447150376731094e-23,  5.895422009744334e-04,
 -1.560930596567403e-05,  3.917024638487672e-07, -7.989207872225538e-09,  1.460764360117924e-10, -2.444261148101149e-12,  3.813528350040242e-14, -5.605853364870617e-16,
  7.842200104587370e-18, -1.049330141259124e-19,  1.349796156330534e-21, -1.680098212795825e-23,  9.941270767454694e-05, -3.478706865898630e-06,  1.034935079113290e-07,
 -2.486470938718641e-09,  5.277119346167642e-11, -1.015057265693488e-12,  1.805974304003401e-14, -3.009468987332980e-16,  4.744269475418356e-18, -7.122575204841071e-20,
  1.023994586783731e-21, -1.416686624622574e-23,  1.267577237069689e-05, -5.784024347979818e-07,  2.042131225985358e-08, -5.770014669731782e-10,  1.418967217935136e-11,
 -3.132794491470585e-13,  6.347830020171810e-15, -1.197307902928316e-16,  2.124536030917509e-18, -3.573699867043228e-20,  5.733094498895952e-22, -8.813316458361859e-24,
  1.210087489297257e-06, -7.130372466383814e-08,  2.999180738128233e-09, -9.970488549787236e-11,  2.843191339491491e-12, -7.209539364146991e-14,  1.664729051608633e-15,
 -3.555609303967922e-17,  7.104887060475277e-19, -1.339468477657770e-20,  2.398210465332904e-22, -4.098164012452868e-24,  8.561137861708581e-08, -6.474554054991044e-09,
  3.263783406227125e-10, -1.280177796608409e-11,  4.245836510161139e-13, -1.239882648492971e-14,  3.270773829148543e-16, -7.928485462814008e-18,  1.787844911940000e-19,
 -3.784825506545318e-21,  7.575632544878336e-23, -1.441330599690630e-24,  4.448571060462136e-09, -4.306894267786479e-10,  2.622454395557006e-11, -1.220157788010070e-12,
  4.731730069710488e-14, -1.598996440387930e-15,  4.840442868816200e-17, -1.337095765650937e-18,  3.415287436286480e-20, -8.146556608417092e-22,  1.828632000599087e-23,
 -3.884691357998835e-25,  1.690706370064025e-10, -2.097116823464512e-11,  1.557641419786417e-12, -8.666303511079740e-14,  3.960003040725669e-15, -1.559516332998958e-16,
  5.452590814602362e-18, -1.726578794059360e-19,  5.022587195081013e-21, -1.356601425131359e-22,  3.430367275240137e-24, -8.170117840295357e-26,  4.740653876371875e-12,
 -7.561352346232116e-13,  6.932023919616026e-14, -4.661606932213111e-15,  2.535296160028160e-16, -1.174320510434180e-17,  4.782100092693326e-19, -1.749107636824008e-20,
  5.834869373948112e-22, -1.795729789092394e-23,  5.144014030021631e-25, -1.380447047493468e-26,  1.020674440971719e-13, -2.103797927148682e-14,  2.411352535920443e-15,
 -1.984601044204617e-16,  1.299776109652638e-17, -7.156371419692010e-19,  3.426723404170349e-20, -1.460081584292204e-21,  5.627673904453004e-23, -1.986521485627131e-24,
  6.483796496648472e-26, -1.970249716868879e-27,  1.889445736624106e-15, -5.038781391396464e-16,  7.293544169884768e-17, -7.425272223241381e-18,  5.914541495467594e-19,
 -3.905015981258585e-20,  2.215301672795748e-21, -1.106536609188081e-22,  4.953131037249518e-24, -2.013475946515357e-25,  7.510386580429974e-27, -2.589438651335003e-28,
  3.933390521220248e-17, -1.334808676425905e-17,  2.426333762715959e-18, -3.045663608560963e-19,  2.941802391054157e-20, -2.321062475426088e-21,  1.553385530354548e-22,
 -9.049701288321363e-24,  4.676593339034168e-25, -2.174556899405516e-26,  9.200710640267865e-28, -3.570042807830148e-29,  1.432087468827519e-18, -5.800444216822502e-19,
  1.255858042826087e-19, -1.854161437633104e-20,  2.079176523217006e-21, -1.881671366765388e-22,  1.428869791070415e-23, -9.353215133720243e-25,  5.383351855876347e-26,
 -2.765968755237724e-27,  1.283910100083196e-28, -5.428832379433826e-30,  1.068601008047626e-01, -4.799513566856978e-04,  2.261832161676633e-06, -1.115907516959279e-08,
  5.543034366096180e-11, -3.046195415014776e-13,  1.207122956463195e-15, -1.236533486903965e-17,  1.575391243672751e-20,  1.034895122773535e-21,  5.351619950947409e-23,
  1.085569569292782e-24,  8.339452986556847e-02, -4.441890971877298e-04,  3.106603011009793e-06, -2.296696642263289e-08,  1.665380580737368e-10, -1.184713036016995e-12,
  8.044519764923552e-15, -5.649654397044356e-17,  3.590439822350282e-19, -1.960452762009589e-21,  3.270759072852511e-23,  2.480981727828014e-25,  5.072344796354148e-02,
 -3.562142821951852e-04,  3.654530934968380e-06, -3.524719979289163e-08,  3.192317970967848e-10, -2.753515410114930e-12,  2.314048614142612e-14, -1.855573411112575e-16,
  1.491131290849694e-18, -1.185863522843388e-20,  7.023620289665223e-23, -1.017527835127638e-24,  2.398129380463217e-02, -2.310661643079826e-04,  3.146007063037048e-06,
 -3.691239138210407e-08,  4.017262422076088e-10, -4.125786422462278e-12,  4.090212046463888e-14, -3.850872058145106e-16,  3.578318541270164e-18, -3.254917725850062e-20,
  2.529218958065348e-22, -2.922039067047695e-24,  8.777422529483239e-03, -1.163193843500912e-04,  1.967431049037892e-06, -2.749941208383361e-08,  3.542565927854675e-10,
 -4.267321459784245e-12,  4.901567358618985e-14, -5.344662479487803e-16,  5.659711014807602e-18, -5.810692172749156e-20,  5.542217334822520e-22, -5.861155308076506e-24,
  2.473393155013799e-03, -4.452582302286790e-05,  9.046921053413671e-07, -1.494867835221272e-08,  2.255506023302995e-10, -3.150955275204621e-12,  4.153304412505736e-14,
 -5.183943077156666e-16,  6.216736558191779e-18, -7.181801309671227e-20,  7.911538832464948e-22, -8.767294228042954e-24,  5.328166087574990e-04, -1.282285220526282e-05,
  3.083897338479143e-07, -5.998206168308893e-09,  1.052052666345674e-10, -1.692164458800958e-12,  2.545098633149214e-14, -3.609478657093802e-16,  4.881327423111487e-18,
 -6.326548695286478e-20,  7.861948465830943e-22, -9.533534142956869e-24,  8.698321127776604e-05, -2.757158595908559e-06,  7.812109149925048e-08, -1.783575260655967e-09,
  3.620138584989190e-11, -6.677004254010947e-13,  1.142319947136270e-14, -1.833274055207123e-16,  2.788518901583548e-18, -4.045925810436918e-20,  5.622373188163540e-22,
 -7.541289344398905e-24,  1.064993399363979e-05, -4.392959683760635e-07,  1.467673991617945e-08, -3.928292837640018e-10,  9.211193002274585e-12, -1.945262061623220e-13,
  3.781399091888979e-15, -6.856525888148119e-17,  1.171844402865948e-18, -1.901737813443054e-20,  2.946605908882843e-22, -4.382413776022362e-24,  9.662451367196703e-07,
 -5.141975744068407e-08,  2.034292458466161e-09, -6.387567195716528e-11,  1.731779788497572e-12, -4.190677697775839e-14,  9.263699444666447e-16, -1.898748211049243e-17,
  3.648661645365529e-19, -6.626943406992534e-21,  1.144763518772194e-22, -1.890242126692910e-24,  6.410355757997729e-08, -4.378933663791578e-09,  2.065340021067638e-10,
 -7.631020000442598e-12,  2.399980841381220e-13, -6.674153074906258e-15,  1.682384127297590e-16, -3.907557557838097e-18,  8.462285669068736e-20, -1.723883874083589e-21,
  3.326067032966862e-23, -6.109603582690634e-25,  3.068088522132445e-09, -2.686659783591834e-10,  1.524413360935869e-11, -6.666116595830571e-13,  2.446118771047300e-14,
 -7.858293478633107e-16,  2.269839786527663e-17, -6.000711137189566e-19,  1.470605528576485e-20, -3.373020849136052e-22,  7.294192709542705e-24, -1.495431427218468e-25,
  1.047795637504232e-10, -1.179060300588413e-11,  8.141346851364824e-13, -4.251172981038600e-14,  1.835677585225150e-15, -6.865581653676340e-17,  2.288708877981582e-18,
 -6.932338388713078e-20,  1.934269515950693e-21, -5.023056918134595e-23,  1.223740622063474e-24, -2.813408854144029e-26,  2.549028778325305e-12, -3.708640770025885e-13,
  3.161137742815573e-14, -1.995473288854137e-15,  1.025715719107872e-16, -4.513403087225978e-18,  1.753246831531545e-19, -6.138054263904758e-21,  1.965615740249110e-22,
 -5.821835314202640e-24,  1.608577165062823e-25, -4.172178375852371e-27,  4.526754928228111e-14, -8.591930540256333e-15,  9.193280953599776e-16, -7.125108648410569e-17,
  4.422792057142719e-18, -2.319635280385905e-19,  1.062406130051927e-20, -4.344834915719025e-22,  1.612120964551382e-23, -5.492362449688933e-25,  1.734154941409537e-26,
 -5.108356562782280e-28,  6.439756374622752e-16, -1.606874639809177e-16,  2.194039047769078e-17, -2.121540318964196e-18,  1.613899474474331e-19, -1.022204922033677e-20,
  5.583814116560478e-22, -2.694199815603681e-23,  1.168172841016299e-24, -4.610913348194222e-26,  1.673579824793820e-27, -5.625791530126370e-29,  9.513874946485907e-18,
 -3.096978123121180e-18,  5.416267988076671e-19, -6.567916767602055e-20,  6.150752381849012e-21, -4.719759216904309e-22,  3.080267739010219e-23, -1.753964688330627e-24,
  8.877005250867184e-26, -4.049718307413943e-27,  1.683724444912594e-28, -6.428905604768494e-30,  2.451588588963600e-19, -9.799833505543105e-20,  2.094302501174930e-20,
 -3.055373527347009e-21,  3.389345840905310e-22, -3.037536178865257e-23,  2.286217842493508e-24, -1.484498576636232e-25,  8.481458935476638e-27, -4.328457585059258e-28,
  1.996765146290018e-29, -8.395050130421636e-31,  1.049756572898653e-01, -4.623777113201483e-04,  2.133048304734704e-06, -1.031947079701982e-08,  4.960012001874926e-11,
 -2.796946903661819e-13,  8.770857811502257e-16, -1.074908808109046e-17,  1.044659689656859e-19,  4.281332093645028e-21,  1.118391406918923e-22,  1.487903130387913e-24,
  8.166579529470011e-02, -4.203951243247877e-04,  2.846237721966974e-06, -2.048193675648970e-08,  1.446528157832550e-10, -1.009384691219920e-12,  6.614798653766840e-15,
 -4.585918573738811e-17,  3.151433360637812e-19, -3.811368848550734e-22,  4.731379244842928e-23,  3.886396359990249e-25,  4.935450184621204e-02, -3.285870669471223e-04,
  3.260486611349993e-06, -3.055155268846279e-08,  2.693206175030174e-10, -2.255476318435455e-12,  1.855208929514913e-14, -1.442166066817537e-16,  1.104071158189697e-18,
 -9.936478576802060e-21,  2.615813013294732e-23, -9.729225602993581e-25,  2.310470632885135e-02, -2.075665750262508e-04,  2.739064351757935e-06, -3.109500743694274e-08,
  3.282161567730001e-10, -3.261604560145615e-12,  3.155912823247959e-14, -2.876172167016985e-16,  2.559329507690743e-18, -2.482372121236499e-20,  1.375323399374013e-22,
 -2.338598278060934e-24,  8.341661910347388e-03, -1.018096448596748e-04,  1.668824279631086e-06, -2.245490486096390e-08,  2.795598412703694e-10, -3.251852120902961e-12,
  3.629946398293965e-14, -3.830132859275074e-16,  3.910398027167857e-18, -4.048824933150884e-20,  3.402192047990558e-22, -3.994724808078452e-24,  2.308709549173907e-03,
 -3.794893352019848e-05,  7.450440544460333e-07, -1.179442173717473e-08,  1.714304888348656e-10, -2.308050958459042e-12,  2.945394028940356e-14, -3.554036888830893e-16,
  4.118295902552617e-18, -4.677750368632677e-20,  4.850741178768034e-22, -5.426961992264630e-24,  4.860408319784897e-04, -1.061740472488312e-05,  2.454929625237127e-07,
 -4.555623764388649e-09,  7.673460586947555e-11, -1.186874577110561e-12,  1.722782916356269e-14, -2.358526630415506e-16,  3.081405527053354e-18, -3.885191295116324e-20,
  4.636083923960359e-22, -5.511639806161719e-24,  7.708163805411371e-05, -2.208880810326114e-06,  5.979672395422120e-08, -1.297869000101986e-09,  2.522007691056578e-11,
 -4.462636921469928e-13,  7.347877480577412e-15, -1.136339762048525e-16,  1.667864343496049e-18, -2.342858482984568e-20,  3.142292620626088e-22, -4.094430339702487e-24,
  9.100906942760524e-06, -3.384990109265745e-07,  1.073303217527478e-08, -2.722273210049275e-10,  6.092182383289138e-12, -1.231328793994082e-13,  2.297904368665121e-15,
 -4.007555421577540e-17,  6.599197878807288e-19, -1.034087202949167e-20,  1.547263655937799e-22, -2.228029883547184e-24,  7.888501537418540e-07, -3.779706597834372e-08,
  1.409847416745029e-09, -4.182385930221907e-11,  1.078895943208795e-12, -2.492678537862409e-14,  5.277849179637249e-16, -1.038558880191662e-17,  1.919799455953642e-19,
 -3.360684967405770e-21,  5.601946429384702e-23, -8.940926146412766e-25,  4.939278786739401e-08, -3.036555154139722e-09,  1.342174469160067e-10, -4.671880534924226e-12,
  1.393976745312122e-13, -3.692689905147784e-15,  8.897358746382659e-17, -1.980533375690002e-18,  4.119853131926184e-20, -8.077609589023989e-22,  1.502414289561686e-23,
 -2.664699821414643e-25,  2.194698313512577e-09, -1.730839069947889e-10,  9.156714422207254e-12, -3.762487800195984e-13,  1.306489309098825e-14, -3.989998576109424e-16,
  1.099672405909199e-17, -2.782145824035273e-19,  6.541335624881542e-21, -1.442518972344011e-22,  3.004860645741694e-24, -5.944328547011960e-26,  6.800069091868960e-11,
 -6.906581939476137e-12,  4.430325203051191e-13, -2.169396642902262e-14,  8.847446976714493e-16, -3.140987491075184e-17,  9.978744519088077e-19, -2.889810218423317e-20,
  7.730362967228911e-22, -1.929178108393132e-23,  4.526020658257101e-25, -1.003924594777885e-26,  1.451611577892850e-12, -1.914769562599653e-13,  1.514076477591248e-14,
 -8.956014304584715e-16,  4.344895652173971e-17, -1.814015300530676e-18,  6.714251457370514e-20, -2.247574626098996e-21,  6.902298658729121e-23, -1.965526959633772e-24,
  5.233169146536297e-26, -1.310629447162715e-27,  2.152009391095573e-14, -3.733901486635206e-15,  3.714762810515643e-16, -2.702865381836707e-17,  1.586104618672924e-18,
 -7.906473864389146e-20,  3.456691953532354e-21, -1.354310440791714e-22,  4.829005284536944e-24, -1.585262677253933e-25,  4.834399587923366e-27, -1.378438512486874e-28,
  2.372311537639667e-16, -5.492843258187218e-17,  7.034287293469684e-18, -6.430939415304001e-19,  4.654136161226198e-20, -2.818345756933522e-21,  1.477951567700887e-22,
 -6.869684423679226e-24,  2.877981873370299e-25, -1.100460963153671e-26,  3.878307763283184e-28, -1.268529379585680e-29,  2.466304278246877e-18, -7.642929569525057e-19,
  1.278189119921995e-19, -1.489727967200031e-20,  1.346753622623132e-21, -1.001281046664903e-22,  6.351174784435234e-24, -3.524328614078618e-25,  1.742279420095625e-26,
 -7.779501066231073e-28,  3.171387042491723e-29, -1.189244015770981e-30,  4.324029179024112e-20, -1.700593854424528e-20,  3.577204545341859e-21, -5.144384125895589e-22,
  5.633583644197616e-23, -4.990646924504115e-24,  3.717188926381415e-25, -2.390945111351894e-26,  1.354345476460077e-27, -6.857894740173369e-29,  3.141040322006519e-30,
 -1.311964380358677e-31,  1.031595094324000e-01, -4.457955864262451e-04,  2.013795114401281e-06, -9.569569690567564e-09,  4.419502704452649e-11, -2.617021458828149e-13,
  6.529721006330971e-16, -3.950777990491992e-18,  3.544602206708838e-19,  9.995815255503989e-21,  1.694016424948161e-22,  8.477641383198969e-25,  8.002825156568252e-02,
 -3.985704902559996e-04,  2.613701754599225e-06, -1.832078366220490e-08,  1.259545508164669e-10, -8.648974484891329e-13,  5.472658712154798e-15, -3.559601802815765e-17,
  3.394816392934270e-19,  1.832752393403245e-21,  6.197447487418952e-23,  1.880506163422336e-25,  4.809009853535050e-02, -3.038996710671821e-04,  2.918308920442334e-06,
 -2.658041238872370e-08,  2.283557593507249e-10, -1.855015962689751e-12,  1.495584098773181e-14, -1.144884837697463e-16,  7.553735056662606e-19, -9.685372608698910e-21,
 -1.124553514987361e-23, -6.404687981102726e-25,  2.231602165754501e-02, -1.870620489979357e-04,  2.395406557226389e-06, -2.632683441151034e-08,  2.699503880168619e-10,
 -2.592362886428770e-12,  2.452453902687075e-14, -2.191452664255453e-16,  1.741671035768812e-18, -2.117893496382982e-20,  5.067641430287210e-23, -1.505416470434199e-24,
  7.959519147358717e-03, -8.946549819210734e-05,  1.424200886152331e-06, -1.845831752086571e-08,  2.224336744163945e-10, -2.496478374521431e-12,  2.712469143557422e-14,
 -2.788928888343503e-16,  2.659389354873894e-18, -2.996091132152255e-20,  1.966999342031548e-22, -2.533864137928721e-24,  2.167999642955243e-03, -3.251135871383933e-05,
  6.185607795363122e-07, -9.385548353432318e-09,  1.316031721992384e-10, -1.707113172997636e-12,  2.111867529360158e-14, -2.472423415896553e-16,  2.732322796800335e-18,
 -3.147027927045356e-20,  2.955299021787436e-22, -3.322388039346258e-24,  4.471801318346243e-04, -8.852927634846684e-06,  1.974757464666848e-07, -3.497365148699951e-09,
  5.664941142407022e-11, -8.426860667285279e-13,  1.181716464873074e-14, -1.564739242335627e-16,  1.965239146893228e-18, -2.439168198053547e-20,  2.760298291689590e-22,
 -3.215987816787777e-24,  6.911308690384573e-05, -1.786565901732456e-06,  4.637721190288044e-08, -9.571508121908898e-10,  1.782872368046947e-11, -3.027652385759543e-13,
  4.801982405847371e-15, -7.164466465465326e-17,  1.013096864100039e-18, -1.383941131274874e-20,  1.785005465918507e-22, -2.260417317513506e-24,  7.900065181923400e-06,
 -2.642140193403605e-07,  7.978644549410677e-09, -1.917998044178279e-10,  4.101144916108097e-12, -7.936787204590034e-14,  1.422989569447541e-15, -2.388846162535787e-17,
  3.788949231562343e-19, -5.742950110103525e-21,  8.291362125315975e-23, -1.156465378957658e-24,  6.574102670095415e-07, -2.826623420155832e-08,  9.970698721585541e-10,
 -2.794925334428835e-11,  6.866381810123103e-13, -1.515334561670670e-14,  3.074959865892238e-16, -5.812254288420644e-18,  1.033678960911136e-19, -1.745336662153673e-21,
  2.807315360492198e-23, -4.332189630314190e-25,  3.908595911538462e-08, -2.154092586143777e-09,  8.942996416999187e-11, -2.932808503155735e-12,  8.307504407458381e-14,
 -2.097036345485779e-15,  4.831472398587760e-17, -1.031069146186384e-18,  2.060525252061033e-20, -3.889543881241373e-22,  6.974735308349481e-24, -1.194601750614117e-25,
  1.624595689274703e-09, -1.148614099370356e-10,  5.672737172817178e-12, -2.189879973534595e-13,  7.197659428566031e-15, -2.089853198415209e-16,  5.496371182189498e-18,
 -1.330857077164432e-19,  3.001992062627647e-21, -6.365042825150608e-23,  1.277085751557585e-24, -2.437546626633513e-26,  4.610013611358980e-11, -4.203457430127054e-12,
  2.504785384135894e-13, -1.149436413462213e-14,  4.426140426519665e-16, -1.491066052948549e-17,  4.513046417076645e-19, -1.249194949626779e-20,  3.202630705162487e-22,
 -7.678037041957208e-24,  1.734026051310907e-25, -3.709474073414343e-27,  8.735451552808959e-13, -1.038005833346646e-13,  7.601774990502384e-15, -4.207281036673640e-16,
  1.924264399251689e-17, -7.615063701640232e-19,  2.683154130019538e-20, -8.580399509929334e-22,  2.524796089261741e-23, -6.906706203169173e-25,  1.770518116598467e-26,
 -4.278114885536987e-28,  1.095491835728667e-14, -1.724264661602553e-15,  1.589254931635755e-16, -1.082538852948952e-17,  5.991828141809510e-19, -2.833115166037180e-20,
  1.180201566422197e-21, -4.422346806031521e-23,  1.512915156554049e-24, -4.778389014786621e-26,  1.405416068900863e-27, -3.873419876512577e-29,  9.467076973435870e-17,
 -2.015737806008580e-17,  2.407232476923222e-18, -2.071361701901817e-19,  1.420739541503745e-20, -8.198351206212393e-22,  4.115093565104680e-23, -1.837656801341668e-24,
  7.420160408746448e-26, -2.742255435830614e-27,  9.363783648530412e-29, -2.974108306171467e-30,  6.903911383785206e-19, -2.018701333434966e-19,  3.206237466332792e-20,
 -3.571481516678422e-21,  3.101992124550818e-22, -2.225319225471430e-23,  1.366919841304375e-24, -7.368049847251778e-26,  3.547571633975246e-27, -1.546336892342137e-28,
  6.166250662607564e-30, -2.265997465438521e-31,  7.906858995067987e-21, -3.047242904626872e-21,  6.286639873219730e-22, -8.884846320591070e-23,  9.580160543141613e-24,
 -8.370324263027498e-25,  6.157763970949425e-26, -3.916877941060965e-27,  2.196485384801240e-28, -1.102106857802833e-29,  5.006048646483155e-31, -2.075160720860000e-32,
  1.014078369745395e-01, -4.301329361409430e-04,  1.903032998431427e-06, -8.903479949847061e-09,  3.911694642609906e-11, -2.456961355139856e-13,  7.648153626497490e-16,
  1.449316728211682e-17,  8.393711806123420e-19,  1.682661134060878e-20,  1.493067430195851e-22, -2.311450464965909e-24,  7.847444314293019e-02, -3.785072840664033e-04,
  2.405395401013946e-06, -1.643707393217403e-08,  1.098959741047138e-10, -7.442080702357954e-13,  4.641425820643849e-15, -2.319402104443815e-17,  4.502166439237921e-19,
  4.259310662227741e-21,  5.217163527467753e-23, -8.054347962526262e-25,  4.691925680685848e-02, -2.817696448761928e-04,  2.620102118751787e-06, -2.320506533092206e-08,
  1.945979163391251e-10, -1.532138872807582e-12,  1.203528287632847e-14, -9.602313191631374e-17,  3.940413170830604e-19, -1.043952785121913e-20, -1.814981952940847e-23,
  5.095447846926480e-25,  2.160419784251569e-02, -1.690928006345192e-04,  2.103786966582844e-06, -2.239240813034901e-08,  2.235215989082359e-10, -2.071802143625021e-12,
  1.905628015128467e-14, -1.753239781374260e-16,  1.003701448107224e-18, -2.002353590812111e-20,  2.087490726008876e-23,  3.997326841238143e-25,  7.623122222414122e-03,
 -7.890096575294605e-05,  1.222514742681260e-06, -1.526593899331459e-08,  1.784271551122854e-10, -1.930524657231633e-12,  2.035464833119608e-14, -2.097214879713812e-16,
  1.699854062386566e-18, -2.384185003921360e-20,  1.222851746329797e-22, -7.343693590472031e-25,  2.047185205398577e-03, -2.798000963828161e-05,  5.175245833110239e-07,
 -7.527685604365181e-09,  1.020155404835340e-10, -1.274430098018010e-12,  1.526441014779204e-14, -1.759095223458413e-16,  1.781455053123261e-18, -2.208117248314916e-20,
  1.856597778240688e-22, -1.703330304551729e-24,  4.146824157921448e-04, -7.426774228426613e-06,  1.604356673870949e-07, -2.711766228660273e-09,  4.231046704848558e-11,
 -6.052845475121902e-13,  8.198044707304960e-15, -1.057532909008759e-16,  1.256042876447888e-18, -1.572171460408729e-20,  1.676599298029274e-22, -1.809441409681250e-24,
  6.264240212816893e-05, -1.457064691055362e-06,  3.642170122643368e-08, -7.146934829760598e-10,  1.278054890604218e-11, -2.083424138741132e-13,  3.183703689606774e-15,
 -4.599237021342835e-17,  6.226011203382200e-19, -8.349204719945600e-21,  1.033056814789197e-22, -1.252564438259202e-24,  6.957720338071835e-06, -2.085853625527923e-07,
  6.023817751978864e-09, -1.372297755091020e-10,  2.807472134339272e-12, -5.204295225336064e-14,  8.968224406792670e-16, -1.451942965897229e-17,  2.213397651129561e-19,
 -3.256829905035990e-21,  4.534065571956488e-23, -6.103765875616599e-25,  5.584105830353769e-07, -2.146515154643739e-08,  7.187572703644741e-10, -1.903588508376410e-11,
  4.458989992175055e-13, -9.403721703918430e-15,  1.829690992135117e-16, -3.325546816187782e-18,  5.687073236721497e-20, -9.275156192912703e-22,  1.439570436063182e-23,
 -2.146586683153887e-25,  3.170573516992798e-08, -1.559653252904061e-09,  6.100758359298023e-11, -1.884755122761914e-12,  5.072782541410983e-14, -1.220653779317709e-15,
  2.690249840826106e-17, -5.507258998812878e-19,  1.057333431140906e-20, -1.922649038086889e-22,  3.324332369524168e-24, -5.498325047173465e-26,  1.241667683699494e-09,
 -7.830984711233691e-11,  3.618098284946232e-12, -1.311915325090789e-13,  4.083494807622792e-15, -1.127445696042304e-16,  2.830148076165007e-18, -6.559944367734488e-20,
  1.419634780690240e-21, -2.894468576566604e-23,  5.593787525505809e-25, -1.030090710953363e-26,  3.256465949052018e-11, -2.650324212923746e-12,  1.468213109454554e-13,
 -6.310688827262851e-15,  2.294353582386146e-16, -7.332985651607354e-18,  2.114208330439358e-19, -5.592489468696182e-21,  1.373814158768658e-22, -3.163352753576586e-24,
  6.875414672382667e-26, -1.418080859556633e-27,  5.541027940981662e-13, -5.891228247367840e-14,  3.992151137840348e-15, -2.064770771324912e-16,  8.895642632715739e-18,
 -3.334214352815649e-19,  1.117547430312139e-20, -3.411689549845487e-22,  9.612225789765449e-24, -2.524226704702763e-25,  6.225862580529082e-27, -1.450389649855806e-28,
  5.961699913207684e-15, -8.443173950692803e-16,  7.187777212052321e-17, -4.572159393852615e-18,  2.382238137652214e-19, -1.066548581048986e-20,  4.226594061311833e-22,
 -1.512429904670742e-23,  4.957249379998030e-25, -1.504312850799690e-26,  4.261585159109985e-28, -1.133835618847011e-29,  4.097992763144705e-17, -7.945811338924861e-18,
  8.799398202238399e-19, -7.095476142094171e-20,  4.595800366095993e-21, -2.519162534604594e-22,  1.206879482826954e-23, -5.164524952863452e-25,  2.005095678508924e-26,
 -7.146047089635259e-28,  2.359244229139162e-29, -7.262154617953533e-31,  2.102356462694009e-19, -5.740401170930688e-20,  8.593406112733973e-21, -9.093124189272022e-22,
  7.549067831379573e-23, -5.202461776505407e-24,  3.082650629230052e-25, -1.608488612757289e-26,  7.519398497208153e-28, -3.190602592416922e-29,  1.241358453365533e-30,
 -4.460022965099477e-32,  1.510711946256257e-21, -5.675010806097344e-22,  1.143027122151881e-22, -1.581480027037761e-23,  1.673608531108641e-24, -1.438220064697210e-25,
  1.042562249820523e-26, -6.544726939046664e-28,  3.626874722455513e-29, -1.800451641712483e-30,  8.099184535599260e-32, -3.327938860498566e-33,  9.971709163129833e-02,
 -4.153257654274622e-04,  1.799788061834654e-06, -8.315722766445653e-09,  3.443764028512573e-11, -2.188414849104057e-13,  1.644310904429698e-15,  5.189912117934023e-17,
  1.512597130052715e-18,  1.900159373271109e-20, -9.158193184379164e-23, -9.308205753318260e-24,  7.699769187246905e-02, -3.600243015467777e-04,  2.218228426795742e-06,
 -1.479194879769116e-08,  9.608221102397241e-11, -6.388252545660448e-13,  4.219060584596236e-15, -6.031511877381375e-18,  6.277162523649808e-19,  5.085689781074712e-21,
 -2.679771068451287e-23, -2.991903316638108e-24,  4.583240805449478e-02, -2.618719717668842e-04,  2.359359914303203e-06, -2.032183986942397e-08,  1.666317036281390e-10,
 -1.274481556494362e-12,  9.466091604398346e-15, -8.948820641354679e-17,  1.599985566854244e-20, -1.009923922537557e-20,  5.295221929161883e-23,  2.948914398366214e-24,
  2.095986728237374e-02, -1.532795383624120e-04,  1.855244825009241e-06, -1.912431374928226e-08,  1.862773857588292e-10, -1.670389369859195e-12,  1.449010906133926e-14,
 -1.544896533231171e-16,  3.104811448477813e-19, -1.789135048463817e-20,  1.126061690735114e-22,  4.085418590219691e-24,  7.325983236811192e-03, -6.980785214732219e-05,
  1.055259102836914e-06, -1.269534179076640e-08,  1.442546507671850e-10, -1.507092973596243e-12,  1.512151735523995e-14, -1.681363951416299e-16,  9.282564679845984e-19,
 -1.887331362444136e-20,  1.459352530239129e-22,  1.982126574758929e-24,  1.943010229370159e-03, -2.417520934216280e-05,  4.362048846185487e-07, -6.081008674643789e-09,
  7.982178552306876e-11, -9.614344956894958e-13,  1.102703792628603e-14, -1.303072662363592e-16,  1.106376625497430e-18, -1.568739788350638e-20,  1.457959113820766e-22,
 -8.589410406455766e-26,  3.873513113167510e-04, -6.262800488354747e-06,  1.315888503178997e-07, -2.121885362705805e-09,  3.195386922467029e-11, -4.400029221703426e-13,
  5.722993865201556e-15, -7.345802021158937e-17,  7.944528657114001e-19, -1.029742935855792e-20,  1.107055453861675e-22, -8.242657295413608e-25,  5.734709559970563e-05,
 -1.196811788090493e-06,  2.894714801310477e-08, -5.397885769686900e-10,  9.284031355914600e-12, -1.453872930830780e-13,  2.134778265069794e-15, -3.017648465990199e-17,
  3.849361931409293e-19, -5.125225504550975e-21,  6.213070064650115e-23, -6.676960607341540e-25,  6.210313082696936e-06, -1.662903569832271e-07,  4.615671786407617e-09,
 -9.959273682583597e-11,  1.952638809471353e-12, -3.469438349548260e-14,  5.740344191992399e-16, -9.008871895725395e-18,  1.311808818331122e-19, -1.882736956830496e-21,
  2.543795369541784e-23, -3.236840111973733e-25,  4.827575234704981e-07, -1.652041829743138e-08,  5.276209708072561e-10, -1.319582372882020e-11,  2.951398102886131e-13,
 -5.951495560157378e-15,  1.110090727435086e-16, -1.944950110039294e-18,  3.191486352733093e-20, -5.037648311654324e-22,  7.559664441505707e-24, -1.083569345769566e-25,
  2.631729378821047e-08, -1.149913832483693e-09,  4.255556622767572e-11, -1.237962457026467e-12,  3.169575843658377e-14, -7.273873837741198e-16,  1.533728758857061e-17,
 -3.015439658555617e-19,  5.558660805167969e-21, -9.745172457837373e-23,  1.625749387609907e-24, -2.593846353087701e-26,  9.777162573149334e-10, -5.470170256976532e-11,
  2.371850329942016e-12, -8.074735613836591e-14,  2.382002822739368e-15, -6.255687794341032e-17,  1.499029153262665e-18, -3.327852153326928e-20,  6.908682506463780e-22,
 -1.354931779826035e-23,  2.522614632727513e-25, -4.480955502181593e-27,  2.390827144705717e-11, -1.725847548137629e-12,  8.904554803079733e-14, -3.582793686561914e-15,
  1.230142396987809e-16, -3.730078663521088e-18,  1.024359614451483e-19, -2.589535855678481e-21,  6.094232340189581e-23, -1.347651214707258e-24,  2.818455909492382e-26,
 -5.603481011707595e-28,  3.694858167142422e-13, -3.489239346833070e-14,  2.187981089367958e-15, -1.056368183485179e-16,  4.284949272150171e-18, -1.520288367422639e-19,
  4.844680180402333e-21, -1.411208031247065e-22,  3.804893784740168e-24, -9.586781148262705e-26,  2.273753169387581e-27, -5.103991694160905e-29,  3.460867308836919e-15,
 -4.371958057604879e-16,  3.429968830723967e-17, -2.033061022519789e-18,  9.955283631863740e-20, -4.214023628345304e-21,  1.586474587141000e-22, -5.414378418067728e-24,
  1.698166355750163e-25, -4.945248324940057e-27,  1.347792376892565e-28, -3.457747752495563e-30,  1.924740141031590e-17, -3.362732237393731e-18,  3.435443494634416e-19,
 -2.585393765874874e-20,  1.576049698978786e-21, -8.182203697821303e-23,  3.731478495948862e-24, -1.526408642175462e-25,  5.685199958993069e-27, -1.949786150954143e-28,
  6.211302658450916e-30, -1.849405227684727e-31,  7.012301962413088e-20, -1.766664239527083e-20,  2.472542064487113e-21, -2.469398778894312e-22,  1.949072663508096e-23,
 -1.284392119468293e-24,  7.311541890219954e-26, -3.679665110523907e-27,  1.664703932077498e-28, -6.855691729794890e-30,  2.595395610779669e-31, -9.094203446001310e-33,
  3.045373398759933e-22, -1.107222087184939e-22,  2.164466474119731e-23, -2.917678702469915e-24,  3.018210814949410e-25, -2.542438476702976e-26,  1.810784202649573e-27,
 -1.119043597043439e-28,  6.115078892511956e-30, -2.997674872889376e-31,  1.333252770812125e-32, -5.422370172219249e-34,  9.808396599018897e-02, -4.013175644163618e-04,
  1.703169516009978e-06, -7.796990825664285e-09,  3.060393722325529e-11, -1.558864507670602e-13,  3.867473757456149e-15,  1.095729723498388e-16,  2.006581632557916e-18,
  4.329692250185286e-21, -7.140910258635793e-22, -1.908797427459786e-23,  7.559199779324918e-02, -3.429632886958727e-04,  2.049545076014071e-06, -1.335135835322347e-08,
  8.431699940942684e-11, -5.371701163136192e-13,  4.355699251965608e-15,  1.646859736356886e-17,  7.518491539783145e-19,  5.021746939791226e-22, -2.248597701310111e-22,
 -6.042590276956043e-24,  4.482118699459253e-02, -2.439290781977419e-04,  2.130690972107611e-06, -1.784816086583619e-08,  1.432099251958192e-10, -1.077619530151355e-12,
  6.917598031551941e-15, -9.407335549786112e-17, -2.693842458974657e-19, -4.412283793905205e-21,  2.562690928628937e-22,  6.324058419292853e-24,  2.037504792713865e-02,
 -1.393073028501141e-04,  1.642590452457562e-06, -1.639370055422055e-08,  1.560002645705567e-10, -1.373966369362070e-12,  1.021531689489479e-14, -1.535536745862110e-16,
 -1.961904185925989e-19, -8.350941580067893e-21,  4.011210274940157e-22,  9.068143633417183e-24,  7.062723653410956e-03, -6.193808886555012e-05,  9.158283948843580e-07,
 -1.061023166941199e-08,  1.173754687373541e-10, -1.197896027930347e-12,  1.073672369289651e-14, -1.479470942579033e-16,  3.839108005646860e-19, -1.029743890372457e-20,
  3.079372674583239e-22,  5.390076474952167e-24,  1.852855348840342e-03, -2.095712100382363e-05,  3.703044733055153e-07, -4.944485202391960e-09,  6.296265700591911e-11,
 -7.370493826474224e-13,  7.797320374358613e-15, -1.027909643373219e-16,  6.502630061512288e-19, -9.429459891483419e-21,  1.794014925164262e-22,  1.590472262270242e-24,
  3.642557132763041e-04, -5.303872326396100e-06,  1.089257740449256e-07, -1.674212873901651e-09,  2.437422612854310e-11, -3.247736846065447e-13,  3.972109177883167e-15,
 -5.316849548597176e-17,  4.969248586167298e-19, -6.354369184052287e-21,  9.203396206741178e-23, -5.891927191622699e-26,  5.298527375166712e-05, -9.888234336480100e-07,
  2.327328467814815e-08, -4.119865543697797e-10,  6.826720515904408e-12, -1.030546059620881e-13,  1.437673758063326e-15, -2.038110944043269e-17,  2.391867303517661e-19,
 -3.108769297209202e-21,  4.131791990151510e-23, -3.061701626616057e-25,  5.612119286250487e-06, -1.336625822710624e-07,  3.587323282822473e-09, -7.323104487145837e-11,
  1.378296557433229e-12, -2.352642226615612e-14,  3.716208197212315e-16, -5.723720656778625e-18,  7.877806885734867e-20, -1.097378965118464e-21,  1.495822513945122e-23,
 -1.678793623303800e-25,  4.242173919348776e-07, -1.286076202710341e-08,  3.940993989743711e-10, -9.297705696994588e-12,  1.988731640838212e-13, -3.840256769700682e-15,
  6.848975805133454e-17, -1.163657105363745e-18,  1.824492063047826e-20, -2.784465714866034e-22,  4.089905792771828e-24, -5.527635242678495e-26,  2.231530375357748e-08,
 -8.612588609549808e-10,  3.032046288092283e-11, -8.297590638321197e-13,  2.023665509392183e-14, -4.433536893308217e-16,  8.934963985423696e-18, -1.691830386717609e-19,
  2.990173553075679e-21, -5.054448162689353e-23,  8.165275455401985e-25, -1.250607468380830e-26,  7.915258541773134e-10, -3.903866342337988e-11,  1.595829894002999e-12,
 -5.096670075124218e-14,  1.426380892670243e-15, -3.565314323929800e-17,  8.153418874336095e-19, -1.735720831817742e-20,  3.455406787875897e-22, -6.519774847374945e-24,
  1.170531812197540e-25, -2.003550078418378e-27,  1.819804113173438e-11, -1.156907343796006e-12,  5.577329853009639e-14, -2.098995858488014e-15,  6.809780665641167e-17,
 -1.959428584814100e-18,  5.124817028308158e-20, -1.238561005987992e-21,  2.791989866787903e-23, -5.929348963959551e-25,  1.193343031483122e-26, -2.286220789771334e-28,
  2.582809164882892e-13, -2.148943528869259e-14,  1.248666193939773e-15, -5.621615978362178e-17,  2.146586137183112e-18, -7.206991814231224e-20,  2.182649608872091e-21,
 -6.064753190275682e-23,  1.564147719083552e-24, -3.779743505645571e-26,  8.617013528088758e-28, -1.862925108303855e-29,  2.137576877456941e-15, -2.385854905572232e-16,
  1.723069808701699e-17, -9.498726647282558e-19,  4.365847550472670e-20, -1.745202846085580e-21,  6.234787716606809e-23, -2.027275822830989e-24,  6.077947610336028e-26,
 -1.696809345084811e-27,  4.444598380053978e-29, -1.098393485025309e-30,  9.802041611431664e-18, -1.525394099188245e-18,  1.431245586313989e-19, -1.001499726150788e-20,
  5.728709675413936e-22, -2.809388794788559e-23,  1.216691397629061e-24, -4.747078620498747e-26,  1.692630610907448e-27, -5.575101468384583e-29,  1.710473954842358e-30,
 -4.917418624708116e-32,  2.577100261171432e-20, -5.909066224233666e-21,  7.666707265505504e-22, -7.179397242310728e-23,  5.358045091428479e-24, -3.360328244444573e-25,
  1.830128298734098e-26, -8.850481822504719e-28,  3.861823968238421e-29, -1.538838483094783e-30,  5.652558812677205e-32, -1.926624253304996e-33,  6.555220959007077e-23,
 -2.284942038443875e-23,  4.302827990309705e-24, -5.616874856298775e-25,  5.651593134759396e-26, -4.647253357501172e-27,  3.240576371428095e-28, -1.965543441324133e-29,
  1.056377564420554e-30, -5.102106509581427e-32,  2.239146841781442e-33, -8.997951196440200e-35,  9.650536536121092e-02, -3.880583380505823e-04,  1.612460219161945e-06,
 -7.326053233281365e-09,  2.870016653412354e-11, -1.909129443742914e-14,  7.808348881270080e-15,  1.689764355613732e-16,  1.424515441859739e-18, -4.324000259241504e-20,
 -1.698994237894944e-21, -2.349734826848505e-23,  7.425195400535375e-02, -3.271856376863642e-04,  1.897087619075706e-06, -1.208234855942126e-08,  7.467016705304612e-11,
 -4.244403042122980e-13,  5.140749523290564e-15,  3.851558711994049e-17,  5.372689167863470e-19, -1.450041378674515e-20, -5.361273336244702e-22, -7.426544908241937e-24,
  4.387825817850506e-02, -2.277028929401331e-04,  1.929576693869933e-06, -1.572111481503741e-08,  1.230990465122876e-10, -9.442415219457482e-13,  4.156489435644700e-15,
 -1.026624016065910e-16, -1.692962005419438e-19,  1.216359503022974e-20,  5.844449533347824e-22,  7.844654170443164e-24,  1.984291149250549e-02, -1.269130539877885e-04,
  1.459974372674183e-06, -1.410568706918198e-08,  1.306199779296715e-10, -1.181248559200508e-12,  5.809694241093755e-15, -1.606909247907007e-16, -1.009922482925807e-19,
  1.679778509818589e-20,  8.741520633969387e-22,  1.134892003810624e-23,  6.828860952418947e-03, -5.509056344309954e-05,  7.990246044108254e-07, -8.911273781799178e-09,
  9.566488819600695e-11, -9.887817576335855e-13,  6.730354803026018e-15, -1.387019054047321e-16,  2.994677003657458e-19,  7.530239336558994e-21,  5.959691520481442e-22,
  7.002502414888250e-24,  1.774598733615180e-03, -1.821595361943622e-05,  3.165589695468617e-07, -4.045782653091002e-09,  4.987091002353367e-11, -5.823604050582439e-13,
  5.170246377402188e-15, -8.586801074443685e-17,  4.603903822940163e-19, -4.826751869877031e-22,  2.744054546573965e-22,  2.437007931342560e-24,  3.446645445058621e-04,
 -4.506660957067314e-06,  9.097626222341228e-08, -1.331485708399029e-09,  1.871995474607543e-11, -2.456966986331507e-13,  2.676711375848629e-15, -4.021128390550668e-17,
  3.353379638373059e-19, -2.563268024586927e-21,  1.006234829515764e-22,  3.569744291796220e-25,  4.937347077157303e-05, -8.207010102472529e-07,  1.892237252136487e-08,
 -3.175527210929220e-10,  5.068516521619084e-12, -7.462616310114555e-14,  9.594775545290128e-16, -1.422067304798363e-17,  1.544429054743965e-19, -1.654207286529636e-21,
  3.287924630297189e-23, -1.055885056115791e-25,  5.129786348303264e-06, -1.081370525074924e-07,  2.826772009995012e-09, -5.450772835631162e-11,  9.853069968208457e-13,
 -1.627852947826928e-14,  2.414588239870079e-16, -3.732074278898668e-18,  4.853232048216300e-20, -6.179623081020675e-22,  9.619889794148225e-24, -8.425184867805489e-26,
  3.784426491517476e-07, -1.010547071219240e-08,  2.993458357456524e-10, -6.650864979179191e-12,  1.361718169985523e-13, -2.529757896940836e-15,  4.277459308442839e-17,
 -7.128043439589919e-19,  1.066650424911530e-20, -1.542152198707804e-22,  2.316365587541139e-24, -2.836754720823752e-26,  1.929930288587123e-08, -6.536246981563388e-10,
  2.204722545928520e-11, -5.666935860598814e-13,  1.317975393591718e-14, -2.764275286894739e-16,  5.303296414642360e-18, -9.724371965722459e-20,  1.646723770065691e-21,
 -2.667091671893251e-23,  4.230678004271079e-25, -6.146537010773292e-27,  6.575150903422884e-10, -2.837847334241840e-11,  1.100672119274887e-12, -3.293115564628090e-14,
  8.752763567396996e-16, -2.085585785800762e-17,  4.544229309002484e-19, -9.299694024604928e-21,  1.774856611190564e-22, -3.216736363428371e-24,  5.591128773999554e-26,
 -9.192935541027121e-28,  1.432596711075907e-11, -7.955462609044628e-13,  3.601764950961512e-14, -1.266310377634627e-15,  3.884840677585917e-17, -1.061529431908710e-18,
  2.642573223161856e-20, -6.111530535687711e-22,  1.319449592524158e-23, -2.690080240804808e-25,  5.214742618318148e-27, -9.619612683741568e-29,  1.887294992373982e-13,
 -1.370816758345525e-14,  7.404343466083536e-16, -3.104544655114088e-17,  1.116124249893359e-18, -3.546185174872773e-20,  1.020215892519474e-21, -2.704237277829764e-23,
  6.669431209667309e-25, -1.545189378754379e-26,  3.385607200592234e-28, -7.046029314588947e-30,  1.400568326718817e-15, -1.366651314031848e-16,  9.090383018131892e-18,
 -4.652320844802900e-19,  2.005453485720293e-20, -7.564097783617531e-22,  2.561969780401595e-23, -7.930516411955057e-25,  2.270848161091695e-26, -6.072485487211105e-28,
  1.527469396137153e-29, -3.633093377526571e-31,  5.403699382875685e-18, -7.395582381218480e-19,  6.352397744219957e-20, -4.119150681277516e-21,  2.205311918426595e-22,
 -1.019257581781499e-23,  4.183028991683531e-25, -1.553595682058908e-26,  5.293202518897998e-28, -1.671390921109933e-29,  4.930133815785364e-31, -1.366230526248174e-32,
  1.048344898260330e-20, -2.153656045179833e-21,  2.568909425672598e-22, -2.240849355095009e-23,  1.572805695180547e-24, -9.344009657633289e-26,  4.848723064729865e-27,
 -2.244819026942995e-28,  9.415187713733709e-30, -3.618771529285692e-31,  1.286061690162771e-32, -4.252509991299114e-34,  1.528754970279043e-23, -5.044145589817779e-24,
  9.063486133364064e-25, -1.137204864316319e-25,  1.106215630066395e-26, -8.834857812439232e-28,  6.006040365257686e-29, -3.562481122547159e-30,  1.877209711824129e-31,
 -8.908661286149990e-33,  3.848761765900939e-34, -1.524978963136781e-35,  9.497838566849857e-02, -3.755024549899395e-04,  1.527327746852700e-06, -6.858045164505239e-09,
  3.059423898118427e-11,  2.282815320200894e-13,  1.283938503784083e-14,  1.746822622297647e-16, -1.576373088429076e-18, -1.282637614235555e-19, -2.393235509882185e-21,
 -1.145410349938245e-24,  7.297267447800876e-02, -3.125691788399078e-04,  1.759010425691550e-06, -1.094843892718813e-08,  6.750990027924743e-11, -2.868236271291159e-13,
  6.348430338030176e-15,  4.262962208681778e-17, -4.407213990166295e-19, -4.135347286993399e-20, -7.567924382025989e-22, -4.300629700918183e-25,  4.299717044530997e-02,
 -2.129888148667235e-04,  1.752132499939722e-06, -1.389817011961487e-08,  1.049781271817184e-10, -8.790107856186184e-13,  1.307749060834488e-15, -9.594303118330150e-17,
  7.629977734958933e-19,  4.121682651971595e-20,  8.142388312740301e-22,  2.575661998900571e-25,  1.935759467789626e-02, -1.158765572187274e-04,  1.302486386862480e-06,
 -1.219871798989810e-08,  1.080263231286686e-10, -1.095350307703400e-12,  1.409418906637477e-15, -1.466025579861327e-16,  1.239753311917354e-18,  5.998956297387023e-20,
  1.207464756336357e-21,  3.831189796419616e-25,  6.620640653254577e-03, -4.910153928851442e-05,  7.006454308153565e-07, -7.531360292886158e-09,  7.719726663605717e-11,
 -8.723450889805258e-13,  3.057687400906562e-15, -1.196271952971476e-16,  1.065491709028106e-18,  3.644255181546871e-20,  8.006233249438138e-22,  1.033184961587676e-25,
  1.706510416922861e-03, -1.586495986351346e-05,  2.724325059546567e-07, -3.335070690979036e-09,  3.927863990441453e-11, -4.853967534404719e-13,  2.985828820922015e-15,
 -6.910207262644078e-17,  6.635169786883162e-19,  1.225244791275821e-20,  3.439435886200589e-22, -1.575415532086353e-25,  3.279990503963056e-04, -3.838022942359058e-06,
  7.664370070516225e-08, -1.068149281642079e-09,  1.436324083129571e-11, -1.938107881807151e-13,  1.692863206023901e-15, -3.015135224582827e-17,  3.188899978535426e-19,
  1.713070166928976e-21,  1.091886093189989e-22, -2.105284259060372e-25,  4.637109690967393e-05, -6.832918607676499e-07,  1.555276993754776e-08, -2.472714346888345e-10,
  3.776700512998153e-12, -5.586453358644777e-14,  6.232997685481689e-16, -9.985426661930251e-18,  1.175984202425061e-19, -4.189878990131161e-22,  2.868656644800198e-23,
 -1.352748314128314e-25,  4.738672014845219e-06, -8.789410601913344e-08,  2.257454831453500e-09, -4.106512934551388e-11,  7.100510614787192e-13, -1.158006627675531e-14,
  1.558504248431902e-16, -2.467151432161496e-18,  3.243885088635572e-20, -2.948768679089453e-22,  6.742256226370106e-24, -5.588247165559150e-26,  3.423524727997828e-07,
 -7.996420738595889e-09,  2.311019875428994e-10, -4.827250939727743e-12,  9.440563803950029e-14, -1.708645321640675e-15,  2.687484013603737e-17, -4.445758284325944e-19,
  6.524440554092320e-21, -8.200280000882795e-23,  1.385061074172443e-24, -1.584085240941378e-26,  1.699904952094056e-08, -5.012427311187648e-10,  1.634982348255778e-11,
 -3.939593707674303e-13,  8.730841742381391e-15, -1.766499954560793e-16,  3.194416623030186e-18, -5.710709151710424e-20,  9.359497748921431e-22, -1.410058763558762e-23,
  2.272003573666973e-25, -3.136484297879487e-27,  5.594078584384921e-10, -2.094396470508641e-11,  7.774625783494031e-13, -2.174932323248787e-14,  5.490422829319207e-16,
 -1.252593910281432e-17,  2.588094480838831e-19, -5.109611714499959e-21,  9.380652915548277e-23, -1.617963137851596e-24,  2.752575214303510e-26, -4.341343492830648e-28,
  1.163686587790506e-11, -5.590366005021074e-13,  2.394832958056825e-14, -7.851831508067521e-16,  2.278715640896229e-17, -5.926382704617604e-19,  1.401400582185330e-20,
 -3.106532728022096e-22,  6.429606442389511e-24, -1.255312911258750e-25,  2.350960701834620e-27, -4.172332194729674e-29,  1.437513658784197e-13, -9.017669462246441e-15,
  4.553297922044644e-16, -1.775081913584544e-17,  6.009872319935600e-19, -1.808488103606308e-20,  4.938211411076485e-22, -1.249244105753105e-23,  2.946348691839650e-25,
 -6.539961286565934e-27,  1.377821174764596e-28, -2.759002509111574e-30,  9.704153168012644e-16, -8.178333643367476e-17,  5.024256684304481e-18, -2.382722156294464e-19,
  9.628271364771198e-21, -3.425353998467826e-22,  1.098992203859596e-23, -3.237097320397601e-25,  8.847308059815333e-27, -2.264494263022044e-28,  5.466821589534762e-30,
 -1.250519719282903e-31,  3.216763090552567e-18, -3.816656563955107e-19,  2.997052796627133e-20, -1.795446401672736e-21,  8.978522181915692e-23, -3.903644141668616e-24,
  1.515392785718340e-25, -5.348737766165781e-27,  1.738471272320384e-28, -5.254201967262758e-30,  1.487779954345910e-31, -3.968175270588587e-33,  4.733985028928465e-21,
 -8.558515892561206e-22,  9.314656405898643e-23, -7.521173549011874e-24,  4.939513437062260e-25, -2.767577015603513e-26,  1.362900869457980e-27, -6.018950110462860e-29,
  2.418515704174295e-30, -8.938753897259969e-32,  3.064659188113602e-33, -9.804716646029172e-35,  3.929440623657729e-24, -1.206457397802624e-24,  2.044167807720993e-25,
 -2.442938460573422e-26,  2.280706805722647e-27, -1.758525692389447e-28,  1.159584801485199e-29, -6.697288318341928e-31,  3.447248230548217e-32, -1.602304568926922e-33,
  6.795327653549815e-35, -2.648300974565195e-36,  9.350030423306857e-02, -3.636042341567204e-04,  1.448177315990169e-06, -6.313770345027692e-09,  3.858757420915650e-11,
  5.845079467325496e-13,  1.620259558759587e-14,  3.277984150814508e-17, -7.772514640489635e-18, -2.069272763708976e-19, -9.825356185076026e-22,  7.519004976350861e-23,
  7.174973526709881e-02, -2.990046381670695e-04,  1.633948618494814e-06, -9.905536425952576e-09,  6.337891380686292e-11, -1.233112202458770e-13,  7.080447108029145e-15,
 -8.591925922827438e-19, -2.429597158437716e-18, -6.631149495330465e-20, -3.151118299088060e-22,  2.368062900830555e-23,  4.217223160372233e-02, -1.996116422648357e-04,
  1.594855402059783e-06, -1.235830051543386e-08,  8.751505239943019e-11, -8.755123199276447e-13, -7.704406475624581e-16, -4.181496062690635e-17,  2.782822139365265e-18,
  6.790442876427998e-20,  3.321838644415883e-22, -2.547424829295352e-23,  1.891404042276771e-02, -1.060144809220355e-04,  1.165751763202886e-06, -1.064500121236533e-08,
  8.615791064067407e-11, -1.103978888442081e-12, -1.751085966483586e-15, -6.351268592018614e-17,  4.195605489034263e-18,  9.971460086520575e-20,  5.038157784368108e-22,
 -3.727409500050904e-23,  6.434900361325396e-03, -4.383818885133493e-05,  6.171143061305387e-07, -6.432843891136082e-09,  6.023874087415363e-11, -8.338746379771010e-13,
  4.253079373051133e-16, -5.866409503225845e-17,  2.905668780976811e-18,  6.286474953261199e-20,  3.442567255654799e-22, -2.403733135807953e-23,  1.647170170569752e-03,
 -1.383561499587750e-05,  2.358729770481999e-07, -2.780990963455995e-09,  3.014504796953755e-11, -4.340558912081571e-13,  1.432800444391859e-15, -3.829311996562632e-17,
  1.331246391069318e-18,  2.363615616560512e-20,  1.556437644208233e-22, -9.693986556056669e-24,  3.137972220133129e-04, -3.272519288580941e-06,  6.508328379969510e-08,
 -8.674049374584962e-10,  1.083123693301150e-11, -1.620736955960701e-13,  1.006515277668932e-15, -1.816640056360969e-17,  4.520353483201647e-19,  5.325429418212169e-21,
  5.341437387458981e-23, -2.679614166788488e-24,  4.386932556996499e-05, -5.697915423565530e-07,  1.291359663459584e-08, -1.950572833060301e-10,  2.788521045303355e-12,
 -4.384159699170941e-14,  3.956132877650528e-16, -6.258541472633378e-18,  1.209774944817932e-19,  5.202577844169143e-22,  1.530611870155997e-23, -5.422607658302358e-25,
  4.420344902204743e-06, -7.162884944281910e-08,  1.825794315208091e-09, -3.137537926146722e-11,  5.108293171494610e-13, -8.559390198046862e-15,  1.000492266779409e-16,
 -1.551929496052853e-18,  2.604733940801496e-20, -7.942727223608231e-23,  3.789400324648995e-24, -8.879660561629144e-26,  3.137306413245142e-07, -6.356023406178301e-09,
  1.812131192569581e-10, -3.558938533516673e-12,  6.578603789525125e-14, -1.191811591160059e-15,  1.697469249082841e-17, -2.736022487175669e-19,  4.415398397489133e-21,
 -3.915567768746997e-23,  7.753317974729858e-25, -1.332017413187144e-26,  1.522876456837218e-08, -3.872233199308180e-10,  1.235602520684470e-11, -2.788525935501716e-13,
  5.850692111540170e-15, -1.162000309892706e-16,  1.949502800097760e-18, -3.376461853556003e-20,  5.630936824535605e-22, -7.304789498725607e-24,  1.217427323873146e-25,
 -1.868342116762614e-27,  4.866066770538060e-10, -1.563595778642271e-11,  5.618852632105833e-13, -1.467447163872528e-14,  3.505988004590553e-16, -7.739192643093376e-18,
  1.503322061038483e-19, -2.859735158728443e-21,  5.149992921039755e-23, -8.221516713185706e-25,  1.382394787167853e-26, -2.179766180302516e-28,  9.731914930593043e-12,
 -3.997358840202246e-13,  1.637457384012750e-14, -4.997233860632322e-16,  1.369773364791405e-17, -3.410379533634455e-19,  7.628011277867321e-21, -1.621311370813742e-22,
  3.238265951402687e-24, -6.000785194223129e-26,  1.090401060027711e-27, -1.877737889140664e-29,  1.138160720962514e-13, -6.087428529476225e-15,  2.898803986153678e-16,
 -1.048687623326356e-17,  3.341785088255128e-19, -9.549901539069736e-21,  2.470345525944352e-22, -5.966686169903883e-24,  1.348052699935892e-25, -2.859712083583327e-27,
  5.800580788182678e-29, -1.118760493922101e-30,  7.086732708720053e-16, -5.084826386452279e-17,  2.902433255833264e-18, -1.272843409664268e-19,  4.819090293798581e-21,
 -1.618051252045349e-22,  4.912354756909130e-24, -1.376564740407706e-25,  3.590585212642435e-27, -8.787993155049712e-29,  2.035787324812310e-30, -4.476382205045633e-32,
  2.061185407052683e-18, -2.085245507996121e-19,  1.499216194525118e-20, -8.273619918649795e-22,  3.858425841900749e-23, -1.576081448477833e-24,  5.778203073146706e-26,
 -1.935642450093323e-27,  5.993746940484651e-29, -1.731446876904428e-30,  4.700392002986792e-32, -1.205019168220398e-33,  2.375236511125471e-21, -3.701778673284967e-22,
  3.654679510259483e-23, -2.715688633203071e-24,  1.661220543685615e-25, -8.742796613793615e-27,  4.070855911917799e-28, -1.709158307732853e-29,  6.558828226510221e-31,
 -2.324183468903569e-32,  7.666150896994066e-34, -2.366807667561361e-35,  1.134785315804554e-24, -3.168930186747085e-25,  4.991994768932909e-26, -5.621663792560458e-27,
  4.994325032204868e-28, -3.691727259469832e-29,  2.347410523229700e-30, -1.313518049762940e-31,  6.575725554053614e-33, -2.982341590392600e-34,  1.237524533934222e-35,
 -4.730148566405693e-37,  9.206859444793107e-02, -3.523103558795204e-04,  1.376570134483085e-06, -5.582002596343722e-09,  5.406587014010659e-11,  9.493199460662877e-13,
  1.251126553890999e-14, -3.343260182063340e-16, -1.483960295864477e-17, -1.479608743365541e-19,  4.703943882585200e-21,  1.783827768199430e-22,  7.057913123657839e-02,
 -2.863914041325792e-04,  1.521114614185663e-06, -8.902165565030047e-09,  6.255516194454484e-11,  3.531432763620894e-14,  5.606507686066786e-15, -1.165854082290043e-16,
 -4.699423130277923e-18, -4.783964065465290e-20,  1.486655959734584e-21,  5.679621257934993e-23,  4.139839533187213e-02, -1.874235318238881e-04,  1.454375560546576e-06,
 -1.109933402295023e-08,  6.978677908428896e-11, -8.957056739851328e-13, -3.246203890754877e-16,  8.607847598451711e-17,  5.098667323294413e-18,  4.805296955114910e-20,
 -1.581521174657021e-21, -5.972779788461517e-23,  1.850785635860877e-02, -9.717768654951651e-05,  1.045545984457278e-06, -9.445683272953969e-09,  6.360670813597742e-11,
 -1.148814791560974e-12, -1.105651090776770e-15,  1.279163276332702e-16,  7.608429280414172e-18,  7.121317334664948e-20, -2.310800008031135e-21, -8.825262813459144e-23,
  6.268954001456231e-03, -3.919493176811419e-05,  5.451535263070550e-07, -5.602231595777344e-09,  4.359359505281744e-11, -8.307478029067815e-13,  4.286426878112984e-16,
  7.050434682541387e-17,  5.068462685052354e-18,  4.522962087485384e-20, -1.474118218498975e-21, -5.716814128118217e-23,  1.595401042300535e-03, -1.207456834133724e-05,
  2.051138202183749e-07, -2.366518414351967e-09,  2.174924501726103e-11, -4.069173392862353e-13,  1.087446083258840e-15,  1.804384184439941e-17,  2.154094787489122e-18,
  1.722625181161569e-20, -5.760338463432479e-22, -2.303891384950118e-23,  3.016863988701266e-04, -2.790780914550015e-06,  5.561110956852610e-08, -7.188656181704042e-10,
  7.799356481781374e-12, -1.422016920077021e-13,  7.304756157910912e-16, -5.169598365445764e-19,  6.438862328538199e-19,  4.012506483141096e-21, -1.458327991199164e-22,
 -6.257226136277184e-24,  4.178293942704404e-05, -4.751505917156609e-07,  1.081319956822531e-08, -1.569911808077621e-10,  1.994787243005161e-12, -3.599212760291992e-14,
  2.779039398634373e-16, -2.027525639093550e-18,  1.432287705338845e-19,  4.622060041043253e-22, -2.300991729764733e-23, -1.183680717009861e-24,  4.160837676465771e-06,
 -5.840179676617467e-08,  1.493066443128031e-09, -2.445425347485401e-11,  3.606122470495268e-13, -6.587277695184906e-15,  6.799284697050290e-17, -7.437856220598573e-19,
  2.478512335818653e-20, -2.708969773898007e-23, -1.714769223106013e-24, -1.610233903908592e-25,  2.909585184413337e-07, -5.060933260492684e-09,  1.440999638909566e-10,
 -2.677249037307979e-12,  4.548087595018168e-14, -8.615008954592807e-16,  1.111583598411994e-17, -1.500697174765851e-19,  3.415462815801310e-21, -2.072401094940186e-23,
  1.192297097114128e-25, -1.683126102872300e-26,  1.385840772052583e-08, -3.003302193268937e-10,  9.502206923107158e-12, -2.015789918531362e-13,  3.927596083907561e-15,
 -7.893390998345796e-17,  1.222643557688461e-18, -1.916458521361246e-20,  3.693558183695102e-22, -3.935878838606337e-24,  4.914474730059560e-26, -1.518200469289568e-27,
  4.320583253071040e-10, -1.176050007088313e-11,  4.149092071142932e-13, -1.013131894622168e-14,  2.262676929521935e-16, -4.929824238891848e-18,  8.954477583587824e-20,
 -1.595244995226659e-21,  2.985439610186372e-23, -4.282563989507763e-25,  6.525085460658358e-27, -1.269069303754891e-28,  8.361635074923068e-12, -2.894608733804356e-13,
  1.149625071591339e-14, -3.265345106076857e-16,  8.393009648535616e-18, -2.024631178330437e-19,  4.266084173875945e-21, -8.604750813570235e-23,  1.696887954378955e-24,
 -2.943180195717539e-26,  5.086307106173457e-28, -9.020547753180554e-30,  9.341895874838450e-14, -4.193532008801591e-15,  1.907230919813654e-16, -6.394982268550199e-18,
  1.911033651490586e-19, -5.219637808632933e-21,  1.275931191227085e-22, -2.933639620816810e-24,  6.397263756263029e-26, -1.290133155490717e-27,  2.511519675585648e-29,
 -4.726638130527695e-31,  5.436172967939812e-16, -3.263765248132992e-17,  1.748521986594330e-18, -7.077149596310680e-20,  2.506220830489456e-21, -7.962156935634247e-23,
  2.284044295184693e-24, -6.084294127646457e-26,  1.517005951526792e-27, -3.543877734831164e-29,  7.874120150001465e-31, -1.666967657441541e-32,  1.416261517198129e-18,
 -1.197896985737308e-19,  7.929414742371608e-21, -4.019950650104864e-22,  1.745611732626798e-23, -6.697520262875659e-25,  2.315453357955685e-26, -7.353722289936447e-28,
  2.167675087911988e-29, -5.976960778667057e-31,  1.554002666536811e-32, -3.825611191019996e-34,  1.322683462380136e-21, -1.734750886701780e-22,  1.549560044771902e-23,
 -1.053948875337120e-24,  5.981390697564493e-26, -2.946850571015222e-27,  1.293075378896101e-28, -5.145763697546579e-30,  1.880486840210554e-31, -6.371426044468628e-33,
  2.016602250989523e-34, -5.993211531539916e-36,  3.756169506062511e-25, -9.258248472214934e-26,  1.334654257805101e-26, -1.399224511797723e-27,  1.171658453726488e-28,
 -8.237594015178157e-30,  5.017326686687143e-31, -2.704538262512321e-32,  1.310361793157274e-33, -5.774001740520496e-35,  2.335421021291517e-36, -8.725853040230662e-38,
  9.068097668748634e-02, -3.415494959437244e-04,  1.315444699188880e-06, -4.552938145185278e-09,  7.500451247849677e-11,  1.080368553528155e-12, -3.947207184276777e-15,
 -8.420747064058173e-16, -1.480402205867131e-17,  2.029209550459451e-19,  1.251090013625233e-20,  1.287789742522006e-22,  6.945725103281557e-02, -2.746326817937627e-04,
  1.420337109245888e-06, -7.889752769870919e-09,  6.424991878023274e-11,  1.126498169684589e-13,  8.927137355965062e-17, -2.779256753273868e-16, -4.719785725172891e-18,
  6.372774882264384e-20,  3.995433643212969e-21,  4.214760972126865e-23,  4.067115267045227e-02, -1.763036721208023e-04,  1.327293617740613e-06, -1.012531546243169e-08,
  5.209003519341971e-11, -8.551075234765474e-13,  4.511853102241567e-15,  2.593548013206066e-16,  5.031139885620327e-18, -6.938861992408927e-20, -4.171470107546044e-21,
 -4.193489673390898e-23,  1.813517859704440e-02, -8.925115787378994e-05,  9.375457106804414e-07, -8.611492810010735e-09,  4.080445725024423e-11, -1.103322952290714e-12,
  6.096959440933601e-15,  3.866346835159666e-16,  7.530988015902640e-18, -1.017349354564253e-19, -6.174342656333381e-21, -6.379782554738952e-23,  6.120486046617106e-03,
 -3.509200759813588e-05,  4.815679091350464e-07, -5.036079566270494e-09,  2.734063133191889e-11, -7.774725761582134e-13,  4.807331700162896e-15,  2.422181838034299e-16,
  5.000423567695834e-18, -6.610519509368998e-20, -3.994111836896292e-21, -4.221278798345852e-23,  1.550212284252157e-03, -1.054194272876240e-05,  1.785403735018805e-07,
 -2.081901951216772e-09,  1.395475239574518e-11, -3.666038874029350e-13,  2.607217997697956e-15,  9.037009766569163e-17,  2.102805834404674e-18, -2.701560698116117e-20,
 -1.599504793898298e-21, -1.743541108777515e-23,  2.913611371321975e-04, -2.378485970572577e-06,  4.764278290070377e-08, -6.158374735234056e-10,  5.141872301917899e-12,
 -1.224363930862943e-13,  1.014882080527847e-15,  2.070654524961366e-17,  6.134082864539571e-19, -7.605207638399463e-21, -4.261589029831367e-22, -4.875367410342829e-24,
  4.004411368809795e-05, -3.956904008993086e-07,  9.098193991235899e-09, -1.304808089913767e-10,  1.339753513180185e-12, -2.947937794818000e-14,  2.859162285896913e-16,
  2.537220035594937e-18,  1.300575953009849e-19, -1.555212767390825e-21, -7.639253122229472e-23, -9.516620897616267e-25,  3.949386993901783e-06, -4.754244815105842e-08,
  1.230158269965466e-09, -1.965524670035084e-11,  2.439545611846261e-13, -5.117469367567627e-15,  5.794593062274036e-17,  6.005270822540836e-21,  2.078508504705433e-20,
 -2.439919758296482e-22, -8.951085898615765e-24, -1.324422393969667e-25,  2.728327631214624e-07, -4.025492233837937e-09,  1.158141143473628e-10, -2.074115377333370e-12,
  3.063920552099900e-14, -6.334869786997168e-16,  8.329849890134563e-18, -5.327142700922107e-20,  2.573011160273581e-21, -3.099149023534455e-23, -6.117988381728226e-25,
 -1.361697191106600e-26,  1.279516421728467e-08, -2.330304844142415e-10,  7.412932207373522e-12, -1.499325396894936e-13,  2.605273165891769e-15, -5.481470528065672e-17,
  8.321710472935953e-19, -9.359868565706471e-21,  2.475414761489342e-22, -3.234233641657999e-24, -1.124889499868988e-26, -1.109066319201795e-27,  3.909627719159587e-10,
 -8.872787715278638e-12,  3.121424450285559e-13, -7.196452657018369e-15,  1.460471451240353e-16, -3.221496118643566e-18,  5.623541926762589e-20, -8.462052973305799e-22,
  1.792834535575879e-23, -2.639072701796278e-25,  2.044155890698119e-27, -7.743668659022562e-29,  7.365773205570026e-12, -2.111568855408251e-13,  8.265962427593850e-15,
 -2.197975606193192e-16,  5.200463392206559e-18, -1.237091521992512e-19,  2.481652030075972e-21, -4.545357389400339e-23,  9.221901611742235e-25, -1.550559181730039e-26,
  2.193796016780005e-28, -4.605904318407594e-30,  7.927451578292861e-14, -2.929702660991259e-15,  1.293558531780301e-16, -4.030344244421447e-18,  1.117152101938961e-19,
 -2.948656728482694e-21,  6.830554140758033e-23, -1.470409830310475e-24,  3.149067275726695e-26, -6.071816333621721e-28,  1.092494242142071e-29, -2.092912201400878e-31,
  4.364885235794314e-16, -2.146901216588595e-17,  1.095584612538778e-18, -4.092676814059900e-20,  1.348006271854553e-21, -4.075467294322016e-23,  1.104502149455357e-24,
 -2.782653437039946e-26,  6.670002666464308e-28, -1.486413883692414e-29,  3.144161344319709e-31, -6.470528363145674e-33,  1.038993339051884e-18, -7.175373836619363e-20,
  4.420814434215790e-21, -2.054726952005058e-22,  8.284416213371561e-24, -2.990326508310486e-25,  9.736729014282728e-27, -2.926667914695429e-28,  8.217012766055921e-30,
 -2.159694523826564e-31,  5.368909648628697e-33, -1.269867310922951e-34,  8.148088394305322e-22, -8.741568889295011e-23,  7.082235697472335e-24, -4.388134374363268e-25,
  2.302305763618871e-26, -1.059312652639231e-27,  4.367691666885557e-29, -1.643047269636650e-30,  5.704515241051348e-32, -1.843358937512756e-33,  5.585194399017431e-35,
 -1.594312728481469e-36,  1.451006861513321e-25, -3.037579921275937e-26,  3.944758294943964e-27, -3.800330117249163e-28,  2.969031426922311e-29, -1.968728733942584e-30,
  1.140316196942877e-31, -5.884435839873973e-33,  2.744243064125207e-34, -1.169215436894103e-35,  4.590217883042673e-37, -1.670195391365055e-38,  8.933551066756076e-02,
 -3.312225127366385e-04,  1.268682282588710e-06, -3.194011825404328e-09,  9.351992170906517e-11,  6.595564959677007e-13, -3.233047638793382e-14, -1.096278921848372e-15,
  2.077966292058716e-18,  7.238933447868430e-19,  1.059950459796635e-20, -2.691455119721619e-22,  6.838087095949971e-02, -2.636310593446668e-04,  1.331894907739529e-06,
 -6.846528084011193e-09,  6.581902315984415e-11,  7.627271497062304e-15, -9.228842392220314e-15, -3.593618581735179e-16,  6.469484373411497e-19,  2.313360351895125e-19,
  3.450941282413897e-21, -8.441669705656260e-23,  3.998642350933254e-02, -1.661584179219294e-04,  1.210252608605776e-06, -9.420053661528705e-09,  3.673877806709754e-11,
 -6.450062385289873e-13,  1.340982439169161e-14,  3.462708827744358e-16, -6.457635983575373e-19, -2.418405359054232e-19, -3.466173028266953e-21,  9.138938319488365e-23,
  1.779253377079674e-02, -8.215465036878744e-05,  8.374336919313279e-07, -8.123092899381629e-09,  2.119801492794904e-11, -8.050353101401098e-13,  1.938623127358243e-14,
  5.183530644900723e-16, -8.599465633815334e-19, -3.590038477708186e-19, -5.236888692187447e-21,  1.328823397148031e-22,  5.987449368151274e-03, -3.147488788629808e-05,
  4.232738285726316e-07, -4.714164608656953e-09,  1.357418229167550e-11, -5.659931639355903e-13,  1.323858340296294e-14,  3.312798664335242e-16, -4.501231501818072e-19,
 -2.335508187299265e-19, -3.440025051422226e-21,  8.489627407493963e-23,  1.510747592346001e-03, -9.210285718385798e-06,  1.546689063696703e-07, -1.912901665090606e-09,
  7.487154362767106e-12, -2.674287644931138e-13,  5.839715930748076e-15,  1.288828461245511e-16, -1.057999416730184e-19, -9.460072900639161e-20, -1.403742195369418e-21,
  3.353512160797359e-23,  2.825644154442733e-04, -2.025681696300119e-06,  4.067045696185576e-08, -5.516013591886118e-10,  2.993614990819190e-12, -8.928179873269430e-14,
  1.803226075784707e-15,  3.241336735434910e-17,  7.787807787054228e-21, -2.581704559151538e-20, -3.835767502405893e-22,  8.805078920578074e-24,  3.859746527049253e-05,
 -3.288457499080253e-07,  7.642876419537169e-09, -1.133568853108168e-10,  8.266694474260826e-13, -2.136890945812614e-14,  4.022729775212059e-16,  5.162019677575894e-18,
  1.381967632132391e-20, -4.880214147908929e-21, -7.135478200007541e-23,  1.560241522834093e-24,  3.777489982776754e-06, -3.858556049290393e-08,  1.014585313311266e-09,
 -1.649392797137262e-11,  1.558700891034980e-13, -3.660393584653800e-15,  6.556457068908802e-17,  4.538653736929919e-19,  4.754678416116743e-21, -6.477600476901395e-22,
 -8.910146485068299e-24,  1.838659727141185e-25,  2.584367697690781e-07, -3.191097212478309e-09,  9.348216215789128e-11, -1.674738689337021e-12,  1.989082780164126e-14,
 -4.433889093240806e-16,  7.784311515980955e-18,  5.642863427618865e-21,  9.241077205895704e-22, -6.137012956151589e-23, -7.069835532313370e-25,  1.363618189154516e-26,
  1.197115331176391e-08, -1.802918044649065e-10,  5.830977538352604e-12, -1.160077974317589e-13,  1.691623546129543e-15, -3.720510417930361e-17,  6.624137787400416e-19,
 -3.463615816363903e-21,  1.144410360366111e-22, -4.287895822341753e-24, -2.949187682011253e-26,  5.219570642776566e-28,  3.599691525739194e-10, -6.685808941742803e-12,
  2.378974498506004e-13, -5.308804323666240e-15,  9.349390064562243e-17, -2.099702573927626e-18,  3.922432185190763e-20, -4.143376450980342e-22,  9.242283061767424e-24,
 -2.316792546353502e-25,  1.050087845974208e-28, -3.612187138691189e-30,  6.638469642215653e-12, -1.543338823268772e-13,  6.055419376756733e-15, -1.535263423180548e-16,
  3.234025206300293e-18, -7.655128119355945e-20,  1.548228036278139e-21, -2.352226997055162e-23,  4.814638224332451e-25, -9.870826006638083e-27,  8.439614016546343e-29,
 -1.560649934396892e-30,  6.935673532437912e-14, -2.061891089753552e-15,  9.002496413923022e-17, -2.637797432152226e-18,  6.631299681064568e-20, -1.707089485929220e-21,
  3.846587532669120e-23, -7.434936623328100e-25,  1.566992054736081e-26, -3.126793104126223e-28,  4.679918866711967e-30, -8.712766210857250e-32,  3.654777267304401e-16,
 -1.435591081323959e-17,  7.110076779975427e-19, -2.466623867630542e-20,  7.455261739372792e-22, -2.160419144409729e-23,  5.582627805323132e-25, -1.308352166369115e-26,
  3.030418381055427e-28, -6.569757690973839e-30,  1.282934811961662e-31, -2.569607662090762e-33,  8.097667459021159e-19, -4.438053297644074e-20,  2.587711428890509e-21,
 -1.104015250393131e-22,  4.104522601210210e-24, -1.399086626246490e-25,  4.296773310609932e-27, -1.215868974381826e-28,  3.258415907625820e-30, -8.181398207123445e-32,
  1.931654023237101e-33, -4.398301094153921e-35,  5.522166675234363e-22, -4.686361487612821e-23,  3.476775354952622e-24, -1.955675207115471e-25,  9.445561164554019e-27,
 -4.055876976777204e-28,  1.567921804352422e-29, -5.559788566274762e-31,  1.831141356124100e-32, -5.631913722654302e-34,  1.629285280930598e-35, -4.460027751766319e-37,
  6.623440391354479e-26, -1.122970612005986e-26,  1.298046683348592e-27, -1.134243057843812e-28,  8.183445225752071e-30, -5.074628766517576e-31,  2.774303148668595e-32,
 -1.361566114879146e-33,  6.076628838133945e-35, -2.490406605417122e-36,  9.446041512748429e-38, -3.333371549473733e-39,  };
  int offset = -18;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 18;
    if (std::isnan(t)) {
      fill_n(rr+offset, 18, 0.5);
      fill_n(ww+offset, 18, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 18; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=18; ++j) {
        const int boxof = it*216+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
