subroutine xerbla(srname, info)
!----------------------------------------------------------------------
! ======================================================================
! COPYRIGHT (C) LAPACK / BLAS
! COPYRIGHT (C) 2007 - 2013  EDF R&D                WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
!
!     SUBROUTINE LAPACK / BLAS DE TRAITEMENT DES ERREURS.
!-----------------------------------------------------------------------
!  -- LAPACK AUXILIARY ROUTINE (VERSION 2.0) --
!     UNIV. OF TENNESSEE, UNIV. OF CALIFORNIA BERKELEY, NAG LTD.,
!     COURANT INSTITUTE, ARGONNE NATIONAL LAB, AND RICE UNIVERSITY
!     SEPTEMBER 30, 1994
!
!  PURPOSE
!  =======
!
!  XERBLA  IS AN ERROR HANDLER FOR THE LAPACK ROUTINES.
!  IT IS CALLED BY AN LAPACK ROUTINE IF AN INPUT PARAMETER HAS AN
!  INVALID VALUE.  A MESSAGE IS PRINTED AND EXECUTION STOPS.
!
!  INSTALLERS MAY CONSIDER MODIFYING THE STOP STATEMENT IN ORDER TO
!  CALL SYSTEM-SPECIFIC EXCEPTION-HANDLING FACILITIES.
!
!  ARGUMENTS
!  =========
!
!  SRNAME  (INPUT) CHARACTER*6
!          THE NAME OF THE ROUTINE WHICH CALLED XERBLA.
!
!  INFO    (INPUT) INTEGER
!          THE POSITION OF THE INVALID PARAMETER IN THE PARAMETER LIST
!          OF THE CALLING ROUTINE.
!
! ASTER INFORMATION
! 11/01/2000 TOILETTAGE DU FORTRAN SUIVANT LES REGLES ASTER,
!            AU LIEU DE WRITE(*,FMT=9999)SRNAME,INFO
!            IMPLICIT NONE
!----------------------------------------------------------------------
! CORPS DU PROGRAMME
    implicit none
!
!     .. SCALAR ARGUMENTS ..
#include "asterfort/u2mesg.h"
    character(len=6) :: srname
    character(len=24) :: valk
    integer :: info
    integer :: vali(2)
!     ..
!     .. EXECUTABLE STATEMENTS ..
!
    valk = srname
    vali (1) = info
    vali (2) = info
    call u2mesg('F', 'ALGELINE5_4', 1, valk, 2,&
                vali, 0, 0.d0)
!
!     END OF XERBLA
!
end subroutine
