/*
 * Decompiled with CFR 0.152.
 */
package jbet;

import java.util.Vector;
import jbet.ClassFileException;
import jbet.ClassFilter;
import jbet.ClassInfo;
import jbet.DagMethodInfo;
import jbet.DagSnippit;
import jbet.DataFlowException;
import jbet.ElementNotFoundException;
import jbet.FieldInfo;

public class DagClassInfo {
    public String thisClass;
    public String superClass;
    public Vector interfaces;
    public Vector methods;
    public Vector fields;

    public DagClassInfo(ClassInfo cr) {
        this.thisClass = cr.thisClass;
        this.superClass = cr.superClass;
        this.interfaces = (Vector)cr.interfaces.clone();
        this.fields = cr.fields;
        this.methods = new Vector();
        int i = 0;
        while (i < cr.methods.size()) {
            DagMethodInfo mi = new DagMethodInfo(this, cr.methodAt(i));
            this.methods.addElement(mi);
            ++i;
        }
    }

    public DagClassInfo(ClassInfo cr, boolean runGraphify) throws ClassFileException, DataFlowException, ElementNotFoundException {
        this(cr, runGraphify, ClassFilter.ALL);
    }

    public DagClassInfo(ClassInfo cr, boolean runGraphify, ClassFilter fixcons) throws ClassFileException, DataFlowException, ElementNotFoundException {
        this.thisClass = cr.thisClass;
        this.superClass = cr.superClass;
        this.interfaces = (Vector)cr.interfaces.clone();
        this.fields = cr.fields;
        this.methods = new Vector();
        int i = 0;
        while (i < cr.methods.size()) {
            DagMethodInfo mi = new DagMethodInfo(this, cr.methodAt(i));
            if (runGraphify) {
                mi.dags = DagSnippit.graphify(cr.methodAt(i), fixcons);
                if (mi.dags != null) {
                    ((DagSnippit)mi.dags).method = mi;
                }
            }
            this.methods.addElement(mi);
            ++i;
        }
    }

    public String name() {
        DagClassInfo dagClassInfo = this;
        return dagClassInfo.thisClass;
    }

    public String toString() {
        DagClassInfo dagClassInfo = this;
        return dagClassInfo.thisClass;
    }

    public DagMethodInfo methodAt(int n) {
        DagClassInfo dagClassInfo = this;
        int n2 = n;
        Vector vector = dagClassInfo.methods;
        return (DagMethodInfo)vector.elementAt(n2);
    }

    public String interfaceAt(int n) {
        DagClassInfo dagClassInfo = this;
        int n2 = n;
        Vector vector = dagClassInfo.interfaces;
        return (String)vector.elementAt(n2);
    }

    public FieldInfo fieldAt(int n) {
        DagClassInfo dagClassInfo = this;
        int n2 = n;
        Vector vector = dagClassInfo.fields;
        return (FieldInfo)vector.elementAt(n2);
    }
}

