/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.sourceforge.cobertura.instrument.ContextMethodAwareMethodAdapter;
import net.sourceforge.cobertura.instrument.HistoryMethodAdapter;
import net.sourceforge.cobertura.instrument.TouchPointListener;
import net.sourceforge.cobertura.util.RegexUtil;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FindTouchPointsMethodAdapter
extends ContextMethodAwareMethodAdapter {
    private final AtomicInteger eventIdGenerator;
    private TouchPointListener touchPointListener;
    private int currentLine;
    private Collection ignoreRegexp;
    private final Map<Integer, Map<Integer, Integer>> duplicatedLinesMap;
    private final Map<Integer, Map<Integer, LinkedList<Integer>>> line2eventIds = new HashMap<Integer, Map<Integer, LinkedList<Integer>>>();
    private LinkedList<Integer> saveEventIdList = null;
    private LinkedList<Integer> replyEventIdList = null;
    private final List<AbstractInsnNode> backlog;

    public FindTouchPointsMethodAdapter(HistoryMethodAdapter mv, String className, String methodName, String methodSignature, AtomicInteger eventIdGenerator, Map<Integer, Map<Integer, Integer>> duplicatedLinesMap, AtomicInteger lineIdGenerator) {
        this(mv, mv.backlog(), className, methodName, methodSignature, eventIdGenerator, duplicatedLinesMap, lineIdGenerator);
    }

    public FindTouchPointsMethodAdapter(MethodVisitor mv, String className, String methodName, String methodSignature, AtomicInteger eventIdGenerator, Map<Integer, Map<Integer, Integer>> duplicatedLinesMap, AtomicInteger lineIdGenerator) {
        this(mv, Collections.emptyList(), className, methodName, methodSignature, eventIdGenerator, duplicatedLinesMap, lineIdGenerator);
    }

    protected FindTouchPointsMethodAdapter(MethodVisitor mv, List<AbstractInsnNode> backlog, String className, String methodName, String methodSignature, AtomicInteger eventIdGenerator, Map<Integer, Map<Integer, Integer>> duplicatedLinesMap, AtomicInteger lineIdGenerator) {
        super(mv, className, methodName, methodSignature, lineIdGenerator);
        this.backlog = backlog;
        this.eventIdGenerator = eventIdGenerator;
        this.duplicatedLinesMap = duplicatedLinesMap;
    }

    private int generateNewEventId() {
        return this.eventIdGenerator.incrementAndGet();
    }

    private int getEventId() {
        if (this.replyEventIdList != null && !this.replyEventIdList.isEmpty()) {
            return this.replyEventIdList.removeFirst();
        }
        int eventId = this.generateNewEventId();
        if (this.saveEventIdList != null) {
            this.saveEventIdList.addLast(eventId);
        }
        return eventId;
    }

    public void visitCode() {
        super.visitCode();
        this.touchPointListener.afterMethodStart(this.mv);
    }

    @Override
    public void visitLineNumber(int line, Label label) {
        super.visitLineNumber(line, label);
        this.currentLine = line;
        if (!this.isDuplicatedLine(line, this.lastLineId)) {
            this.replyEventIdList = null;
            this.saveEventIdList = new LinkedList();
            Map<Integer, LinkedList<Integer>> eventsMap = this.line2eventIds.get(line);
            if (eventsMap == null) {
                eventsMap = new HashMap<Integer, LinkedList<Integer>>();
                this.line2eventIds.put(line, eventsMap);
            }
            eventsMap.put(this.lastLineId, this.saveEventIdList);
        } else {
            Integer orgin = this.getOriginForLine(line, this.lastLineId);
            Map<Integer, LinkedList<Integer>> m = this.line2eventIds.get(this.currentLine);
            LinkedList<Integer> eventIds = m.get(orgin);
            this.replyEventIdList = new LinkedList<Integer>(eventIds);
            this.saveEventIdList = null;
        }
        this.touchPointListener.afterLineNumber(this.getEventId(), label, this.currentLine, this.mv, this.methodName, this.methodSignature);
    }

    private boolean isDuplicatedLine(int line, Integer lineId) {
        return this.getOriginForLine(line, lineId) != null;
    }

    private Integer getOriginForLine(int line, Integer lineId) {
        Map<Integer, Integer> labelMap = this.duplicatedLinesMap.get(line);
        return labelMap != null ? labelMap.get(lineId) : null;
    }

    public void visitLabel(Label label) {
        int eventId = this.getEventId();
        this.touchPointListener.beforeLabel(eventId, label, this.currentLine, this.mv);
        super.visitLabel(label);
        this.touchPointListener.afterLabel(eventId, label, this.currentLine, this.mv);
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (opcode != 167 && opcode != 168 && this.currentLine != 0 && !this.methodName.equals("<clinit>")) {
            int eventId = this.getEventId();
            this.touchPointListener.beforeJump(eventId, label, this.currentLine, this.mv);
            super.visitJumpInsn(opcode, label);
            this.touchPointListener.afterJump(eventId, label, this.currentLine, this.mv);
        } else {
            super.visitJumpInsn(opcode, label);
        }
    }

    public void visitMethodInsn(int opcode, String owner, String method, String descr) {
        super.visitMethodInsn(opcode, owner, method, descr);
        if (RegexUtil.matches(this.ignoreRegexp, owner)) {
            this.touchPointListener.ignoreLine(this.getEventId(), this.currentLine);
        }
    }

    public void visitLookupSwitchInsn(Label def, int[] values, Label[] labels) {
        this.touchPointListener.beforeSwitch(this.getEventId(), def, labels, this.currentLine, this.mv, this.tryToFindSignatureOfConditionEnum());
        super.visitLookupSwitchInsn(def, values, labels);
    }

    public void visitTableSwitchInsn(int min, int max, Label def, Label[] labels) {
        this.touchPointListener.beforeSwitch(this.getEventId(), def, labels, this.currentLine, this.mv, this.tryToFindSignatureOfConditionEnum());
        super.visitTableSwitchInsn(min, max, def, labels);
    }

    private String tryToFindSignatureOfConditionEnum() {
        if (this.backlog == null || this.backlog.size() < 4) {
            return null;
        }
        int last = this.backlog.size() - 1;
        if (this.backlog.get(last) instanceof InsnNode && this.backlog.get(last - 1) instanceof MethodInsnNode && this.backlog.get(last - 2) instanceof VarInsnNode) {
            VarInsnNode i2 = (VarInsnNode)this.backlog.get(last - 2);
            MethodInsnNode i3 = (MethodInsnNode)this.backlog.get(last - 1);
            InsnNode i4 = (InsnNode)this.backlog.get(last);
            if (i2.getOpcode() == 25 && i3.getOpcode() == 182 && i3.name.equals("ordinal") && i4.getOpcode() == 46) {
                return i3.owner;
            }
        }
        return null;
    }

    public TouchPointListener getTouchPointListener() {
        return this.touchPointListener;
    }

    public void setTouchPointListener(TouchPointListener touchPointListener) {
        this.touchPointListener = touchPointListener;
    }

    public Collection<Pattern> getIgnoreRegexp() {
        return this.ignoreRegexp;
    }

    public void setIgnoreRegexp(Collection<Pattern> ignoreRegexp) {
        this.ignoreRegexp = ignoreRegexp;
    }

    static enum Abc {
        A,
        B;

    }
}

