/*
 * Argus Client Software.  Tools to read, analyze and manage Argus data.
 * Copyright (c) 2000-2003 QoSient, LLC
 * All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/* Argus_def.h */
/* 
 * Argus_def.h is an update of the argus-1.8.1 argus_def.h to accomodate
 * new record and data types.  The basic changes are to include a 'cookie'
 * in the header, add some new record types in the man category, index and
 * event records, and the data category, data and supplement, remove
 * the protocol tags in the status, as they are going to be in the
 * flow record, and to add RTP and RTCP status bits, as they are not
 * going to be in the new flow structure.
 *
 */


#ifndef Argus_def_h
#define Argus_def_h


/*
Argus Record Header Format
                                    
    0                   1                   2                   3   
    0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |     Type      |     Cause     |             Length            |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |  Ver  |  Opt  |                    Status                     |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |                        Argus Identifier                       |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |                        Sequence Number                        |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |                             data                              |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
*/

/*
    0                   1                   2                   3
    0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |               |                  Status                       |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

                         Argus Status Record
          Note that one tick mark represents one bit position.
*/

#define ARGUS_COOKIE	0xE5617ACB


/* Argus Record Type */

#define ARGUS_MAR		0x80    /* Normal Argus Management Record */
#define ARGUS_INDEX   		0xA0    /* New Argus Index Record */
#define ARGUS_EVENT		0xC0    /* New Argus Event/Message Record */
#define ARGUS_CISCO_NETFLOW	0x10    /* Argus CISCO Netflow Support */
#define ARGUS_WRITESTRUCT  	0x20    /* Argus 1.x Write Struct Conversion */
#define ARGUS_RMON		0x40    /* New RMON style FAR Record Format */

#define ARGUS_FAR 		0x01    /* Normal Argus Data Record */
#define ARGUS_DATASUP		0x02    /* New Supplemental Argus Data Record */


/* Argus Record Cause */

#define ARGUS_START		0x01   /* INIT */
#define ARGUS_STATUS		0x04   /* STATUS */
#define ARGUS_STOP		0x08   /* CLOSE */
#define ARGUS_SHUTDOWN		0x10   /* Administrative shutdown */
#define ARGUS_TIMEOUT		0x20   /* TIMEOUT */
#define ARGUS_ERROR		0x40   /* MAJOR PROBLEM */

/* Record Version (Ver) */

#define ARGUS_VERSION		0x20000000    /* Version 2 */

/* Record Options (Opt)*/

#define ARGUS_ANON		0x01000000
#define ARGUS_MERGED		0x02000000
#define ARGUS_TOPN		0x04000000
#define ARGUS_MATRIX		0x08000000


/* Argus MAR Record Status */

#define ARGUS_SASL_AUTHENTICATE	0x00001000



/*
    0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |  Status Conditions    | Proto |        EtherType Field        |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 
                    Argus Record Status Field
          Note that one tick mark represents one bit position.
*/


#define ARGUS_ETHERTYPE		0x00FFFF

#define ARGUS_MPLS		0x00010000
#define ARGUS_VLAN		0x00020000
#define ARGUS_PPPoE 		0x00040000
#define ARGUS_SNAPENCAPS	0x00080000

#define ARGUS_CONNECTED		0x00100000
#define ARGUS_ID_IS_IPADDR	0x00800000

#define ARGUS_SRC_VLAN		0x0001
#define ARGUS_DST_VLAN		0x0002

#define ARGUS_SRC_MPLS		0x0001
#define ARGUS_DST_MPLS		0x0002

#define ARGUS_SRC_CHANGED	0x0010
#define ARGUS_DST_CHANGED	0x0020


/* Argus Error Messages go into the status field when
   the Record Cause is ARGUS_ERROR.
*/

#define ARGUS_ACCESSDENIED	0x000010
#define ARGUS_MAXLISTENEXCD	0x000020


/*  Link Types  */

#define ARGUS_ETHERNET			0x01000000
#define ARGUS_ATM			0x02000000
#define ARGUS_FDDI			0x03000000
#define ARGUS_TOKENRING			0x04000000
#define ARGUS_SLIP			0x05000000
#define ARGUS_PPP			0x06000000
#define ARGUS_ESP			0x07000000
#define ARGUS_RAW			0x08000000
#define ARGUS_NULL			0x09000000


#define ARGUS_SEND_FRAG_COMPLETE	0x10000000

/*
                  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 
                 +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
                 |                               |
                 +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 
                       Argus FAR Status Field
        Note that one tick mark represents one bit position.
*/


/* ICMP Mapped Indicator */
/*  argus_far.status indicator */

#define ARGUS_ICMP_MAPPED		0x0007
#define ARGUS_ICMPUNREACH_MAPPED	0x0001
#define ARGUS_ICMPREDIREC_MAPPED	0x0002
#define ARGUS_ICMPTIMXCED_MAPPED	0x0004

#define ARGUS_FRAGMENTS			0x0008
#define ARGUS_FRAGOVERLAP		0x0010

#define ARGUS_TOS_MODIFIED		0x0020
#define ARGUS_TTL_MODIFIED		0x0040
#define ARGUS_OPTION_MODIFIED		0x0080

/* IP Option Indicators */

#define ARGUS_IPOPTIONS			0x3F00
#define ARGUS_TIMESTAMP			0x0100
#define ARGUS_SECURITY			0x0200
#define ARGUS_LSRCROUTE			0x0400
#define ARGUS_RECORDROUTE		0x0800
#define ARGUS_SSRCROUTE			0x1000
#define ARGUS_RTRALERT                  0x2000

 

#define ARGUS_MULTIADDR			0x4000


/* Type:  DSR    Cause:  ANY  */
 
#define ARGUS_MAC_DSR			0x08
 
#define ARGUS_TCP_DSR			0x11
#define ARGUS_ICMP_DSR			0x12
#define ARGUS_RTP_DSR			0x14
#define ARGUS_IGMP_DSR			0x18

#define ARGUS_ARP_DSR			0x20
#define ARGUS_FRG_DSR			0x21
#define ARGUS_ESP_DSR			0x22

#define ARGUS_MPLS_DSR			0x28
#define ARGUS_VLAN_DSR			0x2a
#define ARGUS_PPPOE_DSR			0x2b
 
#define ARGUS_AGR_DSR			0x30
 
#define ARGUS_TIME_DSR			0x40
#define ARGUS_SRCUSRDATA_DSR		0x42
#define ARGUS_DSTUSRDATA_DSR		0x43

#define ARGUS_PERFORMANCE_DSR		0x50

#define ARGUS_SRC_TIME_DSR		0x01
#define ARGUS_DST_TIME_DSR		0x02

/* IP Sec AH Header Status Bits */

#define ARGUS_AH_HDR                  0x00000010
#define ARGUS_AH_REPLAY               0x00000008


/* RTP State Constants and Reporting Values */

#define ARGUS_RTP_SRCSILENCE		0x01
#define ARGUS_RTP_DSTSILENCE		0x02

#define ARGUS_RTCP_TAG			0x2000
#define ARGUS_RTP_TAG			0x4000

#define ARGUS_HTTP_FLOWTAG		0x01
#define ARGUS_RTCP_FLOWTAG		0x10
#define ARGUS_RTP_FLOWTAG		0x20
#define ARGUS_FRAG_FLOWTAG		0xCB


/* TCP State Constants and Reporting Values */

#define ARGUS_SAW_SYN			0x0001
#define ARGUS_SAW_SYN_SENT		0x0002
#define ARGUS_CON_ESTABLISHED		0x0004
#define ARGUS_FIN			0x0008
#define ARGUS_FIN_ACK			0x0010

#define ARGUS_NORMAL_CLOSE		0x0020
#define ARGUS_CLOSE_WAITING		0x0040

#define ARGUS_PKTS_RETRANS		0x0300  /* SRC_PKTS_RETRANS | DST_PK*/
#define ARGUS_SRC_PKTS_RETRANS		0x0100
#define ARGUS_DST_PKTS_RETRANS		0x0200

#define ARGUS_IN_CURR_WINDOW		0x0200000
#define ARGUS_WINDOW_CURR_SHUT		0x0100000

#define ARGUS_WINDOW_SHUT             0x0C00  /* SRC_WINDOW_SHUT | DST_WIN*/
#define ARGUS_SRC_WINDOW_SHUT         0x0400
#define ARGUS_DST_WINDOW_SHUT         0x0800
#define ARGUS_RESET                   0x3000  /* SRC_RESET | DST_RESET */
#define ARGUS_SRC_RESET               0x1000
#define ARGUS_DST_RESET               0x2000
#define ARGUS_ECN_CONGESTED           0xC000  /* SRC_CONGESTED | DST_CONGESTED */
#define ARGUS_SRC_CONGESTED           0x4000
#define ARGUS_DST_CONGESTED           0x8000

#define ARGUS_TCP_MAXSEG	0x00100000
#define ARGUS_TCP_WSCALE	0x00200000
#define ARGUS_TCP_SACKOK	0x00400000
#define ARGUS_TCP_SACK		0x00800000
#define ARGUS_TCP_ECHO		0x01000000
#define ARGUS_TCP_ECHOREPLY	0x02000000
#define ARGUS_TCP_TIMESTAMP	0x04000000
#define ARGUS_TCP_CC		0x08000000
#define ARGUS_TCP_CCNEW		0x10000000
#define ARGUS_TCP_CCECHO	0x20000000

#define ARGUS_TCP_SRC_ECN	0x40000000
#define ARGUS_TCP_DST_ECN	0x80000000


/* Fragment State Constants and Reporting Values */

#define ARGUS_FRAG_INIT			0x0001
#define ARGUS_FRAG_OUT_OF_ORDER		0x0002
#define ARGUS_TCPFRAGOFFSETERROR	0x0004

/* User Data Statua Values */

#define ARGUS_FAR_DSR_STATUS		0x00000001
#define ARGUS_MAC_DSR_STATUS		0x00000010
#define ARGUS_VLAN_DSR_STATUS		0x00000020
#define ARGUS_MPLS_DSR_STATUS		0x00000040

#define ARGUS_TCP_DSR_STATUS		0x00000100
#define ARGUS_ICMP_DSR_STATUS		0x00000200
#define ARGUS_RTP_DSR_STATUS		0x00000400
#define ARGUS_IGMP_DSR_STATUS		0x00000800
#define ARGUS_ARP_DSR_STATUS		0x00001000
#define ARGUS_FRG_DSR_STATUS		0x00002000

#define ARGUS_PERFORMANCE_DSR_STATUS	0x00004000
 
#define ARGUS_TIME_DSR_STATUS		0x00100000
#define ARGUS_SRCUSRDATA_DSR_STATUS	0x00200000
#define ARGUS_DSTUSRDATA_DSR_STATUS	0x00400000
#define ARGUS_ESP_DSR_STATUS		0x00800000

#define ARGUS_AGR_DSR_STATUS		0x80000000
 
#define ARGUS_FAR_DSR_INDEX		0
   
#define ARGUS_MAC_DSR_INDEX		4
#define ARGUS_VLAN_DSR_INDEX		5
#define ARGUS_MPLS_DSR_INDEX		6
#define ARGUS_TCP_DSR_INDEX		8
#define ARGUS_ICMP_DSR_INDEX		9
#define ARGUS_RTP_DSR_INDEX		10
#define ARGUS_IGMP_DSR_INDEX		11
#define ARGUS_ARP_DSR_INDEX		12
#define ARGUS_FRG_DSR_INDEX		13
#define ARGUS_PERFORMANCE_DSR_INDEX	14
  
#define ARGUS_TIME_DSR_INDEX		20
#define ARGUS_SRCUSRDATA_DSR_INDEX	21
#define ARGUS_DSTUSRDATA_DSR_INDEX	22
#define ARGUS_ESP_DSR_INDEX		23
#define ARGUS_AGR_DSR_INDEX		31

#define ARGUS_AGR_USECACTTIME		0x0010
#define ARGUS_AGR_USECIDLETIME		0x0020

#define ARGUS_AGR_MSECACTTIME		0x0040
#define ARGUS_AGR_MSECIDLETIME		0x0080

#define ARGUS_AGR_NORMALIZED  		0x0100

#endif /*  Argus_def_h */
