/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class CCorePreferenceConstants {
    public static final String TODO_TASK_TAGS = "org.eclipse.cdt.core.taskTags";
    public static final String DEFAULT_TASK_TAG = "TODO";
    public static final String DEFAULT_TASK_TAGS = "TODO,FIXME,XXX";
    public static final String TASK_PRIORITY_NORMAL = "normal";
    public static final String TASK_PRIORITY_HIGH = "high";
    public static final String TASK_PRIORITY_LOW = "low";
    public static final String DEFAULT_TASK_PRIORITY = "normal";
    public static final String TODO_TASK_PRIORITIES = "org.eclipse.cdt.core.taskPriorities";
    public static final String TODO_TASK_CASE_SENSITIVE = "org.eclipse.cdt.core.taskCaseSensitive";
    public static final String DEFAULT_TASK_CASE_SENSITIVE = "false";
    public static final String CODE_FORMATTER = "org.eclipse.cdt.core.code_formatter";
    public static final String DEFAULT_CODE_FORMATTER = "org.eclipse.cdt.core.defaultCodeFormatter";
    public static final String INDEX_DB_CACHE_SIZE_PCT = "org.eclipse.cdt.core.indexDBCacheSizePct";
    public static final String DEFAULT_INDEX_DB_CACHE_SIZE_PCT = "10";
    public static final String MAX_INDEX_DB_CACHE_SIZE_MB = "org.eclipse.cdt.core.maxIndexDBCacheSizeMB";
    public static final String DEFAULT_MAX_INDEX_DB_CACHE_SIZE_MB = "64";
    public static final String FILE_PATH_CANONICALIZATION = "org.eclipse.cdt.core.path_canonicalization";
    public static final String WORKSPACE_LANGUAGE_MAPPINGS = "org.eclipse.cdt.core.workspaceLanguageMappings";
    public static final String DEFAULT_WORKSPACE_LANGUAGE_MAPPINGS = "";
    public static final String SHOW_SOURCE_FILES_IN_BINARIES = "org.eclipse.cdt.core.showSourceFilesInBinaries";
    public static final String SHOW_SOURCE_ROOTS_AT_TOP_LEVEL_OF_PROJECT = "org.eclipse.cdt.core.showSourceRootsAtTopLevelOfProject";
    public static final String PREF_BUILD_ALL_CONFIGS = "build.all.configs.enabled";
    public static final String PREF_BUILD_CONFIGS_RESOURCE_CHANGES = "build.proj.ref.configs.enabled";
    public static final String DEFAULT_INCLUDE_EXPORT_PATTERN = "IWYU\\s+(pragma:?\\s+)?export";
    public static final String INCLUDE_EXPORT_PATTERN = "includes.exportPattern";
    public static final String DEFAULT_INCLUDE_BEGIN_EXPORTS_PATTERN = "IWYU\\s+(pragma:?\\s+)?begin_exports?";
    public static final String INCLUDE_BEGIN_EXPORTS_PATTERN = "includes.beginExportsPattern";
    public static final String DEFAULT_INCLUDE_END_EXPORTS_PATTERN = "IWYU\\s+(pragma:?\\s+)?end_exports?";
    public static final String INCLUDE_END_EXPORTS_PATTERN = "includes.endExportsPattern";
    public static final String DEFAULT_INCLUDE_PRIVATE_PATTERN = "IWYU\\s+(pragma:?\\s+)?private(,\\s+include\\s+(?<header>\\S+))?";
    public static final String INCLUDE_PRIVATE_PATTERN = "includes.privatePattern";
    public static String SCALABILITY_SKIP_TRIVIAL_EXPRESSIONS = "scalability.skipTrivialExpressions";
    public static final boolean DEFAULT_SCALABILITY_SKIP_TRIVIAL_EXPRESSIONS = true;
    public static final String SCALABILITY_MAXIMUM_TRIVIAL_EXPRESSIONS = "scalability.maximumTrivialExpressions";
    public static final int DEFAULT_SCALABILITY_MAXIMUM_TRIVIAL_EXPRESSIONS = 1000;
    public static final String SCALABILITY_LIMIT_TOKENS_PER_TU = "scalability.limitTokensPerTU";
    public static final boolean DEFAULT_SCALABILITY_LIMIT_TOKENS_PER_TU = false;
    public static final String SCALABILITY_MAXIMUM_TOKENS = "scalability.maximumTokens";
    public static final int DEFAULT_SCALABILITY_MAXIMUM_TOKENS = 25000000;

    private static IEclipsePreferences getPreferenceNode(String key, ICProject project) {
        IEclipsePreferences node = null;
        if (project != null && (node = new ProjectScope(project.getProject()).getNode("org.eclipse.cdt.core")).get(key, null) != null) {
            return node;
        }
        node = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core");
        if (node.get(key, null) != null) {
            return node;
        }
        node = ConfigurationScope.INSTANCE.getNode("org.eclipse.cdt.core");
        if (node.get(key, null) != null) {
            return node;
        }
        return DefaultScope.INSTANCE.getNode("org.eclipse.cdt.core");
    }

    public static String getPreference(String key, ICProject project) {
        return CCorePreferenceConstants.getPreference(key, project, null);
    }

    public static String getPreference(String key, ICProject project, String defaultValue) {
        return CCorePreferenceConstants.getPreferenceNode(key, project).get(key, defaultValue);
    }

    public static int getPreference(String key, ICProject project, int defaultValue) {
        return CCorePreferenceConstants.getPreferenceNode(key, project).getInt(key, defaultValue);
    }

    public static boolean getPreference(String key, ICProject project, boolean defaultValue) {
        return CCorePreferenceConstants.getPreferenceNode(key, project).getBoolean(key, defaultValue);
    }

    public static IScopeContext[] getPreferenceScopes(IProject project) {
        IScopeContext[] iScopeContextArray;
        if (project != null) {
            IScopeContext[] iScopeContextArray2 = new IScopeContext[4];
            iScopeContextArray2[0] = new ProjectScope(project);
            iScopeContextArray2[1] = InstanceScope.INSTANCE;
            iScopeContextArray2[2] = ConfigurationScope.INSTANCE;
            iScopeContextArray = iScopeContextArray2;
            iScopeContextArray2[3] = DefaultScope.INSTANCE;
        } else {
            IScopeContext[] iScopeContextArray3 = new IScopeContext[3];
            iScopeContextArray3[0] = InstanceScope.INSTANCE;
            iScopeContextArray3[1] = ConfigurationScope.INSTANCE;
            iScopeContextArray = iScopeContextArray3;
            iScopeContextArray3[2] = DefaultScope.INSTANCE;
        }
        return iScopeContextArray;
    }
}

