/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityUvmCounterKind;
import com.nvidia.viper.activity.CuptiActivityUvmCounterScope;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineKind;
import java.util.ArrayList;
import java.util.List;

public class CuptiActivityUvmCounter
extends CuptiActivityBase
implements ICuptiActivity {
    private int uvmCounterKind;
    private int uvmCounterScope;
    public long timestamp = 0L;
    public long value;
    public int processId;
    public long start;
    public long end;
    public long address;
    public int srcId;
    public int dstId;
    public int flags;
    private List<Integer> deviceIdList;
    public static long cpuId = -1L;

    public CuptiActivityUvmCounter() {
        this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_INVALID.getCode();
    }

    public CuptiActivityUvmCounter(CuptiActivityKind activityKind, CuptiActivityUvmCounterKind counterKind, CuptiActivityUvmCounterScope counterScope, int deviceId, int processId, long timestamp, long value) {
        this.kind = activityKind.getCode();
        this.uvmCounterKind = counterKind.getCode();
        this.uvmCounterScope = counterScope.getCode();
        this.processId = processId;
        this.timestamp = timestamp;
        this.value = value;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (!this.isNew() && this.timestamp <= 0L) {
            return false;
        }
        if (this.isNew() && this.start <= 0L) {
            return false;
        }
        return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT.getCode() == this.uvmCounterKind || CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_THRASHING.getCode() == this.uvmCounterKind || CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_REMOTE_MAP.getCode() == this.uvmCounterKind || !this.isNew() || this.end > 0L;
    }

    @Override
    public void appendToPDM(long hPdm) throws CuptiException {
        NativeCupti.cuptiPDMAppendActivity(hPdm, this);
    }

    public CuptiActivityUvmCounterKind getUvmCounterKind() {
        return CuptiActivityUvmCounterKind.valueOf(this.uvmCounterKind);
    }

    public CuptiActivityUvmCounterScope getUvmCounterScope() {
        return CuptiActivityUvmCounterScope.valueOf(this.uvmCounterScope);
    }

    public List<Integer> getDeviceIDList() {
        if (this.deviceIdList != null) {
            return this.deviceIdList;
        }
        this.deviceIdList = new ArrayList<Integer>();
        switch (this.getUvmCounterKind()) {
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOH: 
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_GPU_PAGE_FAULT_COUNT: {
                this.deviceIdList.add(this.srcId);
                break;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_HTOD: {
                this.deviceIdList.add(this.dstId);
                break;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOD: {
                this.deviceIdList.add(this.srcId);
                this.deviceIdList.add(this.dstId);
                break;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_THRASHING: {
                int srcId = this.srcId;
                int i = 0;
                while (i < 32 && srcId != 0) {
                    if ((this.srcId & 1 << i) != 0) {
                        this.deviceIdList.add(i);
                        srcId -= 1 << i;
                    }
                    ++i;
                }
                break;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_PAGE_THROTTLING: {
                if (this.flags == CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_THROTTLING_IN_CPU.getCode()) break;
                this.deviceIdList.add(this.srcId);
                break;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_REMOTE_MAP: {
                if ((long)this.srcId != cpuId) {
                    this.deviceIdList.add(this.srcId);
                }
                if ((long)this.dstId == cpuId) break;
                this.deviceIdList.add(this.dstId);
                break;
            }
        }
        return this.deviceIdList;
    }

    public boolean isCpu() {
        switch (this.getUvmCounterKind()) {
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT: {
                return true;
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_PAGE_THROTTLING: {
                return this.flags == CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_THROTTLING_IN_CPU.getCode();
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_THRASHING: {
                return this.flags == CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_THRASHING_IN_CPU.getCode();
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_REMOTE_MAP: {
                return (long)this.srcId == cpuId || (long)this.dstId == cpuId;
            }
        }
        return false;
    }

    public boolean isStartOnly() {
        switch (this.getUvmCounterKind()) {
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT: 
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_THRASHING: 
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_REMOTE_MAP: {
                return true;
            }
        }
        return false;
    }

    public void setDeviceIDList(List<Integer> deviceIdList) {
        this.deviceIdList = deviceIdList;
    }

    public boolean isNew() {
        return this.timestamp == 0L;
    }

    public boolean isTimelineDisabled(Session session) {
        switch (this.getUvmCounterKind()) {
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_HTOD: {
                return session.isTimelineDisabled(TimelineKind.UVM_MEMCPY_HTOD);
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOH: {
                return session.isTimelineDisabled(TimelineKind.UVM_MEMCPY_DTOH);
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOD: {
                return session.isTimelineDisabled(TimelineKind.UVM_MEMCPY_DTOD);
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT: {
                return session.isTimelineDisabled(TimelineKind.UVM_PAGE_FAULT);
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_GPU_PAGE_FAULT_COUNT: {
                return session.isTimelineDisabled(TimelineKind.UVM_GPU_PAGE_FAULT);
            }
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_THRASHING: 
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_PAGE_THROTTLING: 
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_REMOTE_MAP: {
                return session.isTimelineDisabled(TimelineKind.UVM_THRASHING_THROTTLING);
            }
        }
        return false;
    }

    public long getValue() {
        switch (this.getUvmCounterKind()) {
            case CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT: {
                return 1L;
            }
        }
        return this.value;
    }
}

