/**
 * @file   fvin.c
 * 
 * <EN>
 * @brief  A skeleton code of feature input plugin
 * </EN>
 * 
 * <JA>
 * @brief  ħϥץ饰ΤҤʷ
 * </JA>
 * 
 * @author Akinobu Lee
 * @date   Mon Aug 11 17:05:17 2008
 * 
 * $Revision: 1.3 $
 * 
 */

/**
 * Required for a file
 *   - get_plugin_info()
 *
 * Optional for a file
 *   - initialize()
 * 
 */

/**
 * feature input plugin functions
 * 
 * Required:
 *   - fvin_get_optname()
 *   - fvin_get_configuration()
 *   - fvin_standby()
 *   - fvin_open()
 *   - fvin_read()
 *   - fvin_close()
 *
 * Optional:
 *   - fvin_terminate()
 *   - fvin_pause()
 *   - fvin_resume()
 *   - fvin_input_name()
 * 
 */

#include <stdio.h>
#include <string.h>
#include "plugin_defs.h"

#define PLUGIN_TITLE "Feature vector input plugin for Julius"
#define INPUT_OPT "myfvin"

/************************************************************************/

/** 
 * <EN>
 * @brief  Initialization at loading time (optional)
 * 
 * If defined, this will be called just before this plugin is loaded to Julius.
 * if this returns -1, the whole functions in this file will not be loaded.
 *
 * This function is OPTIONAL.
 * </EN>
 * <JA>
 * @brief  ɤ߹߻νǤա
 *
 * ưJulius Υץ饰ɤ߹ݤ˺ǽ˸ƤФ롥
 * -1 ֤ȡΥץ饰Τɤ߹ޤʤʤ롥
 * ¹ԲǽΥå˻Ȥ롥
 *
 * </JA>
 * 
 * 
 * @return 0 on success, -1 on failure.
 * 
 */
int
initialize()
{
  return 0;
}

/** 
 * <EN>
 * @brief  Get information of this plugin (required)
 *
 * This function should return informations of this plugin file.
 * The required info will be specified by opcode:
 *  - 0: return description string of this file into buf
 *
 * This will be called just after Julius find this file and after
 * initialize().
 *
 * @param opcode [in] requested operation code
 * @param buf [out] buffer to store the return string
 * @param buflen [in] maximum length of buf
 *
 * @return 0 on success, -1 on failure.  On failure, Julius will ignore this
 * plugin.
 * 
 * </EN>
 * <JA>
 * @brief  ץ饰ɬܡ
 *
 * Υץ饰˴ؤ֤Ϳ줿 opcode ˤäư롥
 *  - 0 ξ硤Υץ饰ե̾ΤͿ줿Хåե˳Ǽ
 *
 * δؿϡJulius Υץ饰ɤ߹ľ˸ƤФ롥
 * 
 * @param opcode [in] ׵ư ( 0 Τ߼)
 * @param buf [out] ͤǼХåե
 * @param buflen [in] buf κĹ
 * 
 * @return 顼 -1,  0 ֤顼Ȥ -1 ֤硤
 * Υץ饰Τɤ߹ޤʤ
 * </JA>
 * 
 */
int
get_plugin_info(int opcode, char *buf, int buflen)
{
  switch(opcode) {
  case 0:
    /* plugin description string */
    strncpy(buf, PLUGIN_TITLE, buflen);
    break;
  }

  return 0;
}

/************************************************************************/
/************************************************************************/
/* Feature-vector input plugin functions */

/** 
 * <EN>
 * @brief  Return option string to select this input at option. (required)
 *
 * This function should return option string which should be specified
 * as an argument "-input" option, to be used on Julius.  The returning
 * string should not be the same with any existing value.
 *
 * This function will be called several times at option parsing at startup.
 *
 * @param buf [out] buffer to store the return string
 * @param buflen [in] maximum length of buf
 * </EN>
 * <JA>
 * @brief  ѤΥץʸ֤ɬܡ
 *
 * Υץ饰ϤȤ򤹤ݤˡ"-input" ץǻꤹ
 * ٤ʸǼ֤֤ʸϡƥˤǤˤΤ䡤
 * ¾Υץ饰󤬻ѤƤΤƱǤʤȡ
 * ʤ⤷Ʊä祷ƥ¦ͥ褵
 *
 * δؿϡưΥץϻ˲٤ƤФ롥
 *
 * @param buf [out] ͤǼ֤Хåե
 * @param buflen [in] buf κĹ
 * </JA>
 * 
 */
void
fvin_get_optname(char *buf, int buflen)
{
  strncpy(buf, INPUT_OPT, buflen);
}

/** 
 * <EN>
 * @brief  Return configuration parameters for this input (required)
 * 
 * This function should return configuration parameters about the input.
 *
 * When opcode = 0, return the dimension (length) of input vector.
 * 
 * When opcode = 1, return the frame interval (time between frames) in
 * milliseconds.
 * 
 * When opcode = 2, parameter type code can be returned.  The code should
 * the same format as used in HTK parameter file header.  This is for
 * checking the input parameter type against acousitc model, and
 * you can disable the checking by returning "0xffff" to this opcode.
 * 
 * @param opcode [in] requested operation code
 * 
 * @return values required for the opcode as described.
 * </EN>
 * 
 * <JA>
 * @brief  ħ̤Υѥ᡼֤ɬܡ
 *
 * ϥץ饰JuliusϤħ̤˴ؤѥ᡼֤
 * Ϳ줿ʲ opcode Ȥˡ֤ͤ
 *
 * opcode = 0: ٥ȥμ
 * opcode = 1: ե졼ढλñ̡ߥá
 * opcode = 2: ѥ᡼η
 *
 * opcode = 2 Υѥ᡼ηϡǥħ̤Ȥη
 * å˻Ȥ롥ͤϡHTK ħ̥եΥإå
 * 󥳡ɤ줿֤ͤåԤʤϡ
 * 0xffff ֤ȡ
 *
 * @param opcode [in] ׵ư ( 0 Τ߼)
 * 
 * @return opcode Ȥ׵ᤵ줿֤ͤ
 * </JA>
 */
int
fvin_get_configuration(int opcode)
{
  switch(opcode) {
  case 0:		   /* return number of elements in a vector */
    return(25);
  case 1:/* return msec per frame */
    return(10);
  case 2:/* return parameter type specification in HTK format */
    /* return 0xffff to disable checking */
    return(0xffff);
  }
}

/************************************************************************/

/**
 * <EN>
 * @brief  Initialize input device (required)
 *
 * This will be called only once at start up of Julius.  You can
 * check if the input file exists or prepare a socket for connection.
 *
 * If this function returns FALSE, Julius will exit.
 * 
 * JuliusLib: this function will be called at j_adin_init().
 *
 * @return TRUE on success, FALSE on failure.
 * </EN>
 * <JA>
 * @brief  ǥХɬܡ
 *
 * δؿϵư˰ƤФ롥Ǥϥեν
 * åȤѰդȤäϤΤνԤΤ˻Ȥ
 *
 * FALSE ֤硤Julius Ͻλ롥
 * 
 * JuliusLib: δؿ j_adin_init() ǸƤФ롥
 *
 * @return  TRUEԻ FALSE ֤
 * </JA>
 */
boolean
fvin_standby()
{

  /* sever socket ready etc... */
  return TRUE;

}

/**
 * <EN>
 * @brief  Open an input (required)
 *
 * This function should open a new input.  You may open a feature
 * vector file, or wait for connection at this function.
 *
 * If this function returns FALSE, Julius will exit recognition loop.
 * 
 * JuliusLib: this will be called at j_open_stream().
 * 
 * @return TRUE on success, FALSE on failure.
 * </EN>
 * <JA>
 * @brief  Ϥ򳫤ɬܡ
 *
 * Ϥ򿷵˳եΥץ󡤥ͥåȥ饤Ȥ
 * ³ʤɤϤǹԤ
 *
 * FALSE ֤ȤJulius ǧ롼פȴ롥
 * 
 * JuliusLib: δؿ j_open_stream() ǸƤФ롥
 * 
 * @return  TRUEԻ FALSE ֤
 * </JA>
 */
boolean
fvin_open()
{
  /* listen and accept socket, or open a file */
  return TRUE;
}

/**
 * <EN>
 * @brief  Read a vector from input (required)
 *
 * This will be called repeatedly at each frame, and the read vector
 * will be processed immediately, and then this function is called again.
 *
 * Return value of ADIN_EOF tells end of stream to Julius, which
 * causes Julius to finish current recognition and close stream.
 * ADIN_SEGMENT requests Julius to segment the current input.  The
 * current recognition will be stopped at this point, recognition
 * result will be output, and then Julius continues to the next input.
 * The behavior of ADIN_SEGMENT is similar to ADIN_EOF except that
 * ADIN_SEGMENT does not close/open input, but just stop and restart
 * the recognition.  At last, return value should be ADIN_ERROR on
 * error, in which Julius exits itself immediately.
 * 
 * @param vecbuf [out] store a vector obtained in this function
 * @param veclen [in] vector length
 * 
 * @return 0 on success, ADIN_EOF on end of stream, ADIN_SEGMENT to
 * request segmentation to Julius, or ADIN_ERROR on error.
 * </EN>
 * <JA>
 * @brief Ϥ٥ȥɤ߹ɬܡ
 *
 * δؿϤ٥ȥ򣱤Ĥɤ߹ࡥδؿ
 * ե졼ऴȤ˸ƤФ졤ɤ߹ޤ줿٥ȥϤΤȤǧ졤
 * ޤΥե졼ΥǡɤिˤδؿƤФ롥
 *
 * ϤüޤãȤADIN_EOF ֤ΤȤJulius ϸ
 * ǧλϤĤ롥
 *
 * ADIN_ERROR Ϥδؿǿʥ顼֤줬֤
 * 줿硤Julius Ϥξǰ۾ｪλ롥
 *
 * ADIN_SEGMENT ֤ȤǡJulius ˸ߤǧ򸽻Ƕڤ뤳
 * ׵᤹뤳ȤǤ롥ߤǧϤλǤäڤ졤
 * ޤǤǧ̤ꡦϤ줿ȡǧϤޤꤳ
 * ؿƤФ롥ADIN_SEGMENT  ADIN_EOF ưƤ뤬
 * ADIN_EOF  adin_close(), adin_open() ƤϤλ
 * ΤФơADIN_SEGMENT ϤƤФϤ³Ԥ롥
 * 
 * @param vecbuf [out] 줿٥ȥǼХåե
 * @param veclen [in] ٥ȥĹ
 * 
 * @return  0 뤤 end of stream  ADIN_EOF, Julius ˶
 * ڤ׵ФȤˤ ADIN_SEGMENT, 顼ADIN_ERROR ֤
 * </JA>
 */
int
fvin_read(float *vecbuf, int veclen)
{
  /* read one vector from the input */
  if (0/* error */) return ADIN_ERROR;
  if (0/* input should be segmented here */) return ADIN_SEGMENT;
  if (0/* EOF */) return ADIN_EOF;

  return(0);			/* success */
}

/**
 * <EN>
 * @brief  Close the current input (required)
 *
 * This function will be called when the input has reached end of file
 * (i.e. the last call of fvin_read() returns ADIN_EOF)
 *       
 * You may close a file or disconnect network client here.
 *
 * If this function returns TRUE, Julius will go again to adin_open()
 * to open another stream.  If returns FALSE, Julius will exit
 * the recognition loop.
 * 
 * JuliusLib: This will be called at the end of j_recognize_stream().
 * 
 * @return TRUE on success, FALSE on failure.
 * </EN>
 * <JA>
 * @brief  ϤĤɬܡ
 *
 * ߤϤĤ롥δؿϡϤüEOFˤãȤʤ
 *  fvin_read()  ADIN_EOF ֤Ȥˤ˸ƤФ롥̾Ǥ
 * եĤ롤ͥåȥ³ǤʤɤνԤ
 *
 * ｪλȤTRUE֤ȤJulius  adin_open() ä
 * ¾Υȥ꡼򳫤Ȥ롥 FALSE ֤ȤϡJulius 
 * ǧ롼פȴ롥
 * 
 * JuliusLib: δؿ j_recognize_stream() κǸǸƤФ롥
 * 
 * @return  TRUEԻ FALSE ֤
 * </JA>
 */
boolean
fvin_close()
{
  /* file close, connection close, etc.. */
  return TRUE;
}

/************************************************************************/

/**
 * <EN>
 * @brief  A hook for Termination request (optional)
 *
 * This function will be called when Julius receives a Termination
 * request to stop running.  This can be used to synchronize input
 * facility with Julius's running status.
 * 
 * Termination will occur when Julius is running on module mode and
 * received TERMINATE command from client, or j_request_terminate()
 * is called inside application.  On termination, Julius will stop
 * recognition immediately (discard current input if in process),
 * and wait until received RESUME command or call of j_request_resume().
 *
 * This hook function will be called just after a Termination request.
 * Please note that this will be called when Julius receives request,
 * not on actual termination.
 * 
 * @return TRUE on success, FALSE on failure.
 * </EN>
 * <JA>
 * @brief  ׵ѥեåǤա
 *
 * δؿȡJulius ׵äݤˤδؿƤӽФ
 * ȤäơJulius ǡƳƱƱ뤳Ȥ
 * Ǥ롥㡧Ф׵Фʤɡ
 *
 * ׵ϡJulius ץꥱ䥯饤Ȥ
 * ǧǤ׵Ǥ롥ŪˤϡJulius ⥸塼⡼ɤư
 *  TERMINATE ޥɤ򥯥饤ȤäȤ䡤
 * JuliusLibȤ߹ץꥱ j_request_terminate() 
 * ƤȤȯ롥
 *
 * ׵ȡJulius ϸߤǧǤ롥
 * ǧǤä硤Ϥ˴¨Ǥ롥
 * κƳϡRESUME ޥɤ j_request_resume() θƤӽФǹԤ롥
 *
 * δؿ׵ Julius äǸƤФ롥
 * ºݤ˽ǤǸƤФΤǤϤʤȤդ줿
 * 
 * @return  TRUE, 顼 FALSE ֤
 * </JA>
 * 
 */
boolean
fvin_terminate()
{
  printf("terminate request\n");
  return TRUE;
}

/**
 * <EN>
 * @brief  A hook for Pause request (optional)
 *
 * This function will be called when Julius receives a Pause request
 * to stop running.  This can be used to synchronize input facility
 * with Julius's running status.
 * 
 * Pause will occur when Julius is running on module mode and
 * received PAUSE command from client, or j_request_pause()
 * is called inside application.  On pausing, Julius will 
 * stop recognition and then wait until it receives RESUME command
 * or j_request_resume() is called.  When pausing occurs while recognition is
 * running, Julius will process it to the end before stops.
 *
 * This hook function will be called just after a Pause request.
 * Please note that this will be called when Julius receives request,
 * not on actual pause.
 *
 * @return TRUE on success, FALSE on failure.
 * </EN>
 * <JA>
 * @brief  ׵ѥեåǤա
 *
 * δؿȡJulius ׵äݤˤδؿƤӽФ
 * ȤäơJulius ǡƳƱƱ뤳Ȥ
 * Ǥ롥㡧Ф׵Фʤɡ
 *
 * ׵ϡJulius ץꥱ䥯饤Ȥ롤
 * ǧΰߤ׵Ǥ롥ŪˤϡJulius ⥸塼⡼ɤư
 *  PAUSE ޥɤ򥯥饤ȤäȤ䡤
 * JuliusLibȤ߹ץꥱ j_request_pause() 
 * ƤȤȯ롥
 *
 * ׵ȡJulius ϸߤǧǤ롥
 * ǧǤä硤ǧޤԤäƤǤ롥
 * κƳϡRESUME ޥɤ j_request_resume() θƤӽФǹԤ롥
 * 
 * ׵ (fvin_terminate) Ȥΰ㤤ϡǧ׵Ȥư
 * ۤʤ롥׵Ǥ϶Ǥ뤬׵ǤϤǧޤ
 * ԤäƤߤ롥
 *
 * δؿ׵ Julius äǸƤФ롥
 * ºݤ˽ߤǸƤФΤǤϤʤȤդ줿
 * 
 * @return  TRUE, 顼 FALSE ֤
 * </JA>
 * 
 */
boolean
fvin_pause()
{
  printf("pause request\n");
  return TRUE;
}

/**
 * <EN>
 * @brief  A hook for Resume request (optional)
 *
 * This function will be called when Julius received a resume request
 * to recover from pause/termination status.
 * 
 * Resume will occur when Julius has been stopped by receiving RESUME
 * command from client on module mode, or j_request_resume() is called
 * inside application.
 *
 * This hook function will be called just after a resume request.
 * This can be used to make this A/D-in plugin cooperate with the
 * pause/resume status, for example to tell audio client to restart
 * audio streaming.
 *
 * This function is totally optional.
 * 
 * @return TRUE on success, FALSE on failure.
 * </EN>
 * <JA>
 * @brief  ǧƳ׵ѥեåǤա
 *
 * δؿȡJulius ߾֤ǧƳ׵κݤ
 * δؿƤӽФ
 *
 * ǧƳ׵ϡJulius ⥸塼⡼ɤư RESUME ޥɤ
 * 饤ȤäȤ䡤JuliusLibȤ߹ץꥱ
 *  j_request_resume() ƤȤȯ롥κƳ׵᤬ȯ
 * ȡJulius ߤƤǧƳ롥
 *
 * աδؿϡºݤߤȤ˸ƤФΤǤϤʤJulius 
 * ׵äǡΤӤ˸ƤФ롥ʣƤФ뤳Ȥ䡤
 * ǤưǤˤˤΥޥɤäȤˤƤ
 * 뤳Ȥ뤳Ȥդ줿
 * 
 * @return  TRUE, 顼 FALSE ֤
 * </JA>
 * 
 */
boolean
fvin_resume()
{
  printf("resume request\n");
  return TRUE;
}

/**
 * <EN>
 * @brief  A function to return current device name for information (optional)
 *
 * This function is totally optional.
 * 
 * @return pointer to the device name string
 * </EN>
 * <JA>
 * @brief  ϥե롦ǥХ֤̾ؿǤա
 *
 * @return ϥե뤢뤤ϥǥХ̾ʸؤΥݥ
 * </JA>
 * 
 */
char *
fvin_input_name()
{
  printf("input name function was called\n");
  return("default");
}
/* end of file */
