/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import com.jamesmurty.utils.XMLBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.model.StorageBucketLoggingStatus;

public class S3BucketLoggingStatus
extends StorageBucketLoggingStatus {
    private final List<GrantAndPermission> targetGrantsList = new ArrayList<GrantAndPermission>();

    public S3BucketLoggingStatus() {
    }

    public S3BucketLoggingStatus(String targetBucketName, String logfilePrefix) {
        super(targetBucketName, logfilePrefix);
    }

    public GrantAndPermission[] getTargetGrants() {
        return this.targetGrantsList.toArray(new GrantAndPermission[this.targetGrantsList.size()]);
    }

    public void setTargetGrants(GrantAndPermission[] targetGrants) {
        this.targetGrantsList.clear();
        this.targetGrantsList.addAll(Arrays.asList(targetGrants));
    }

    public void addTargetGrant(GrantAndPermission targetGrant) {
        this.targetGrantsList.add(targetGrant);
    }

    public String toString() {
        String result = super.toString();
        result = result + ", targetGrants=[" + this.targetGrantsList + "]";
        return result;
    }

    public XMLBuilder toXMLBuilder() throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        XMLBuilder builder = XMLBuilder.create((String)"BucketLoggingStatus").attr("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        if (this.isLoggingEnabled()) {
            XMLBuilder enabledBuilder = builder.elem("LoggingEnabled").elem("TargetBucket").text(this.getTargetBucketName()).up().elem("TargetPrefix").text(this.getLogfilePrefix()).up();
            if (this.targetGrantsList.size() > 0) {
                Iterator<GrantAndPermission> targetGrantsIter = this.targetGrantsList.iterator();
                XMLBuilder grantsBuilder = enabledBuilder.elem("TargetGrants");
                while (targetGrantsIter.hasNext()) {
                    GrantAndPermission gap = targetGrantsIter.next();
                    grantsBuilder.elem("Grant").importXMLBuilder(gap.getGrantee().toXMLBuilder()).elem("Permission").text(gap.getPermission().toString());
                }
            }
        }
        return builder;
    }
}

