// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PASSWORD_MANAGER_CORE_BROWSER_CREDENTIAL_MANAGER_PENDING_REQUIRE_USER_MEDIATION_TASK_H_
#define COMPONENTS_PASSWORD_MANAGER_CORE_BROWSER_CREDENTIAL_MANAGER_PENDING_REQUIRE_USER_MEDIATION_TASK_H_

#include "base/macros.h"
#include "components/password_manager/core/browser/password_store.h"
#include "components/password_manager/core/browser/password_store_consumer.h"

namespace password_manager {

// Handles mediation completion and retrieves embedder-dependent services.
class CredentialManagerPendingRequireUserMediationTaskDelegate {
 public:
  virtual ~CredentialManagerPendingRequireUserMediationTaskDelegate() {}

  // Retrieves the PasswordStore.
  virtual PasswordStore* GetPasswordStore() = 0;

  // Finishes mediation tasks.
  virtual void DoneRequiringUserMediation() = 0;
};

// Notifies the password store that a list of origins require user mediation.
class CredentialManagerPendingRequireUserMediationTask
    : public PasswordStoreConsumer {
 public:
  explicit CredentialManagerPendingRequireUserMediationTask(
      CredentialManagerPendingRequireUserMediationTaskDelegate* delegate);
  ~CredentialManagerPendingRequireUserMediationTask() override;

  // Adds an origin to require user mediation.
  void AddOrigin(const PasswordStore::FormDigest& form_digest);

 private:
  // PasswordStoreConsumer implementation.
  void OnGetPasswordStoreResults(
      std::vector<std::unique_ptr<autofill::PasswordForm>> results) override;

  CredentialManagerPendingRequireUserMediationTaskDelegate* const
      delegate_;  // Weak.

  // Number of password store requests to be resolved.
  int pending_requests_;

  DISALLOW_COPY_AND_ASSIGN(CredentialManagerPendingRequireUserMediationTask);
};

}  // namespace password_manager

#endif  // COMPONENTS_PASSWORD_MANAGER_CORE_BROWSER_CREDENTIAL_MANAGER_PENDING_REQUIRE_USER_MEDIATION_TASK_H_
