/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.AbstractConnector;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class LocatorConnector
extends AbstractConnector {
    public static final int SIZE = 8;
    private Locator myLocator;
    private static final long serialVersionUID = 5062833203337604181L;
    private int locatorConnectorSerializedDataVersion = 1;

    public LocatorConnector() {
        this.setLocator(null);
    }

    public LocatorConnector(Figure figure, Locator locator) {
        super(figure);
        this.setLocator(locator);
    }

    public boolean containsPoint(int n, int n2) {
        return this.displayBox().contains(n, n2);
    }

    public Rectangle displayBox() {
        Point point = this.getLocator().locate(this.owner());
        return new Rectangle(point.x - 4, point.y - 4, 8, 8);
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.blue);
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeStorable(this.getLocator());
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.setLocator((Locator)storableInput.readStorable());
    }

    protected void setLocator(Locator locator) {
        this.myLocator = locator;
    }

    public Locator getLocator() {
        return this.myLocator;
    }
}

